/*
 * Decompiled with CFR 0.152.
 */
package rdr;

import java.io.OutputStream;
import rdr.Exception;
import rdr.IOException;
import rdr.OutStream;

public class JavaOutStream
extends OutStream {
    static final int defaultBufSize = 16384;
    static final int minBulkSize = 1024;
    private OutputStream jos;
    private int ptrOffset;
    private int bufSize;

    public JavaOutStream(OutputStream jos_, int bufSize_) {
        this.jos = jos_;
        this.bufSize = bufSize_;
        this.b = new byte[this.bufSize];
        this.ptr = 0;
        this.end = this.bufSize;
    }

    public JavaOutStream(OutputStream jos) {
        this(jos, 16384);
    }

    @Override
    public void writeBytes(byte[] data, int offset, int length) {
        if (length < 1024) {
            super.writeBytes(data, offset, length);
            return;
        }
        this.flush();
        try {
            this.jos.write(data, offset, length);
        }
        catch (java.io.IOException e) {
            throw new IOException(e);
        }
        this.ptrOffset += length;
    }

    @Override
    public void flush() {
        try {
            this.jos.write(this.b, 0, this.ptr);
        }
        catch (java.io.IOException e) {
            throw new IOException(e);
        }
        this.ptrOffset += this.ptr;
        this.ptr = 0;
    }

    @Override
    public int length() {
        return this.ptrOffset + this.ptr;
    }

    @Override
    protected int overrun(int itemSize, int nItems) {
        if (itemSize > this.bufSize) {
            throw new Exception("JavaOutStream overrun: max itemSize exceeded");
        }
        this.flush();
        if (itemSize * nItems > this.end) {
            nItems = this.end / itemSize;
        }
        return nItems;
    }
}

