/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.list;

import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections15.OrderedIterator;

public class TreeList<E>
extends AbstractList<E> {
    private AVLNode<E> root;
    private int size;

    public TreeList() {
    }

    public TreeList(Collection<? extends E> coll) {
        this.addAll(coll);
    }

    @Override
    public E get(int index) {
        this.checkInterval(index, 0, this.size() - 1);
        return this.root.get(index).getValue();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int fromIndex) {
        this.checkInterval(fromIndex, 0, this.size());
        return new TreeListIterator(this, fromIndex);
    }

    @Override
    public int indexOf(Object object) {
        if (this.root == null) {
            return -1;
        }
        return this.root.indexOf(object, ((AVLNode)this.root).relativePosition);
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        if (this.root != null) {
            this.root.toArray(array, ((AVLNode)this.root).relativePosition);
        }
        return array;
    }

    @Override
    public void add(int index, E obj) {
        ++this.modCount;
        this.checkInterval(index, 0, this.size());
        this.root = this.root == null ? new AVLNode(index, obj, null, null) : this.root.insert(index, obj);
        ++this.size;
    }

    @Override
    public E set(int index, E obj) {
        this.checkInterval(index, 0, this.size() - 1);
        AVLNode<E> node = this.root.get(index);
        Object result = ((AVLNode)node).value;
        node.setValue(obj);
        return (E)result;
    }

    @Override
    public E remove(int index) {
        ++this.modCount;
        this.checkInterval(index, 0, this.size() - 1);
        E result = this.get(index);
        this.root = this.root.remove(index);
        --this.size;
        return result;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.root = null;
        this.size = 0;
    }

    private void checkInterval(int index, int startIndex, int endIndex) {
        if (index < startIndex || index > endIndex) {
            throw new IndexOutOfBoundsException("Invalid index:" + index + ", size=" + this.size());
        }
    }

    static class TreeListIterator<E>
    implements ListIterator<E>,
    OrderedIterator<E> {
        protected final TreeList<E> parent;
        protected AVLNode<E> next;
        protected int nextIndex;
        protected AVLNode<E> current;
        protected int currentIndex;
        protected int expectedModCount;

        protected TreeListIterator(TreeList<E> parent, int fromIndex) throws IndexOutOfBoundsException {
            this.parent = parent;
            this.expectedModCount = ((TreeList)parent).modCount;
            this.next = ((TreeList)parent).root == null ? null : ((TreeList)parent).root.get(fromIndex);
            this.nextIndex = fromIndex;
        }

        protected void checkModCount() {
            if (((TreeList)this.parent).modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < this.parent.size();
        }

        @Override
        public E next() {
            this.checkModCount();
            if (!this.hasNext()) {
                throw new NoSuchElementException("No element at index " + this.nextIndex + ".");
            }
            if (this.next == null) {
                this.next = ((TreeList)this.parent).root.get(this.nextIndex);
            }
            E value = this.next.getValue();
            this.current = this.next;
            this.currentIndex = this.nextIndex++;
            this.next = this.next.next();
            return value;
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex > 0;
        }

        @Override
        public E previous() {
            this.checkModCount();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException("Already at start of list.");
            }
            this.next = this.next == null ? ((TreeList)this.parent).root.get(this.nextIndex - 1) : this.next.previous();
            E value = this.next.getValue();
            this.current = this.next;
            this.currentIndex = --this.nextIndex;
            return value;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex() - 1;
        }

        @Override
        public void remove() {
            this.checkModCount();
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.parent.remove(this.currentIndex);
            this.current = null;
            this.currentIndex = -1;
            --this.nextIndex;
            ++this.expectedModCount;
        }

        @Override
        public void set(E obj) {
            this.checkModCount();
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.current.setValue(obj);
        }

        @Override
        public void add(E obj) {
            this.checkModCount();
            this.parent.add(this.nextIndex, obj);
            this.current = null;
            this.currentIndex = -1;
            ++this.nextIndex;
            ++this.expectedModCount;
        }
    }

    static class AVLNode<T> {
        private AVLNode<T> left;
        private boolean leftIsPrevious;
        private AVLNode<T> right;
        private boolean rightIsNext;
        private int height;
        private int relativePosition;
        private T value;

        private AVLNode(int relativePosition, T obj, AVLNode<T> rightFollower, AVLNode<T> leftFollower) {
            this.relativePosition = relativePosition;
            this.value = obj;
            this.rightIsNext = true;
            this.leftIsPrevious = true;
            this.right = rightFollower;
            this.left = leftFollower;
        }

        T getValue() {
            return this.value;
        }

        void setValue(T obj) {
            this.value = obj;
        }

        AVLNode<T> get(int index) {
            AVLNode<T> nextNode;
            int indexRelativeToMe = index - this.relativePosition;
            if (indexRelativeToMe == 0) {
                return this;
            }
            AVLNode<T> aVLNode = nextNode = indexRelativeToMe < 0 ? this.getLeftSubTree() : this.getRightSubTree();
            if (nextNode == null) {
                return null;
            }
            return nextNode.get(indexRelativeToMe);
        }

        int indexOf(T object, int index) {
            int result;
            if (this.getLeftSubTree() != null && (result = this.left.indexOf(object, index + this.left.relativePosition)) != -1) {
                return result;
            }
            if (this.value == null ? this.value == object : this.value.equals(object)) {
                return index;
            }
            if (this.getRightSubTree() != null) {
                return this.right.indexOf(object, index + this.right.relativePosition);
            }
            return -1;
        }

        void toArray(T[] array, int index) {
            array[index] = this.value;
            if (this.getLeftSubTree() != null) {
                this.left.toArray(array, index + this.left.relativePosition);
            }
            if (this.getRightSubTree() != null) {
                this.right.toArray(array, index + this.right.relativePosition);
            }
        }

        AVLNode<T> next() {
            if (this.rightIsNext || this.right == null) {
                return this.right;
            }
            return super.min();
        }

        AVLNode<T> previous() {
            if (this.leftIsPrevious || this.left == null) {
                return this.left;
            }
            return super.max();
        }

        AVLNode<T> insert(int index, T obj) {
            int indexRelativeToMe = index - this.relativePosition;
            if (indexRelativeToMe <= 0) {
                return this.insertOnLeft(indexRelativeToMe, obj);
            }
            return this.insertOnRight(indexRelativeToMe, obj);
        }

        private AVLNode<T> insertOnLeft(int indexRelativeToMe, T obj) {
            AVLNode<T> ret = this;
            if (this.getLeftSubTree() == null) {
                this.setLeft(new AVLNode<T>(-1, obj, this, this.left), null);
            } else {
                this.setLeft(this.left.insert(indexRelativeToMe, obj), null);
            }
            if (this.relativePosition >= 0) {
                ++this.relativePosition;
            }
            ret = this.balance();
            super.recalcHeight();
            return ret;
        }

        private AVLNode<T> insertOnRight(int indexRelativeToMe, T obj) {
            AVLNode<T> ret = this;
            if (this.getRightSubTree() == null) {
                this.setRight(new AVLNode<T>(1, obj, this.right, this), null);
            } else {
                this.setRight(this.right.insert(indexRelativeToMe, obj), null);
            }
            if (this.relativePosition < 0) {
                --this.relativePosition;
            }
            ret = this.balance();
            super.recalcHeight();
            return ret;
        }

        private AVLNode<T> getLeftSubTree() {
            return this.leftIsPrevious ? null : this.left;
        }

        private AVLNode<T> getRightSubTree() {
            return this.rightIsNext ? null : this.right;
        }

        private AVLNode<T> max() {
            return this.getRightSubTree() == null ? this : super.max();
        }

        private AVLNode<T> min() {
            return this.getLeftSubTree() == null ? this : super.min();
        }

        AVLNode<T> remove(int index) {
            int indexRelativeToMe = index - this.relativePosition;
            if (indexRelativeToMe == 0) {
                return this.removeSelf();
            }
            if (indexRelativeToMe > 0) {
                this.setRight(this.right.remove(indexRelativeToMe), this.right.right);
                if (this.relativePosition < 0) {
                    ++this.relativePosition;
                }
            } else {
                this.setLeft(this.left.remove(indexRelativeToMe), this.left.left);
                if (this.relativePosition > 0) {
                    --this.relativePosition;
                }
            }
            this.recalcHeight();
            return this.balance();
        }

        private AVLNode<T> removeMax() {
            if (this.getRightSubTree() == null) {
                return this.removeSelf();
            }
            this.setRight(super.removeMax(), this.right.right);
            if (this.relativePosition < 0) {
                ++this.relativePosition;
            }
            this.recalcHeight();
            return this.balance();
        }

        private AVLNode<T> removeMin() {
            if (this.getLeftSubTree() == null) {
                return this.removeSelf();
            }
            this.setLeft(super.removeMin(), this.left.left);
            if (this.relativePosition > 0) {
                --this.relativePosition;
            }
            this.recalcHeight();
            return this.balance();
        }

        private AVLNode<T> removeSelf() {
            if (this.getRightSubTree() == null && this.getLeftSubTree() == null) {
                return null;
            }
            if (this.getRightSubTree() == null) {
                if (this.relativePosition > 0) {
                    this.left.relativePosition = this.left.relativePosition + (this.relativePosition + (this.relativePosition > 0 ? 0 : 1));
                }
                super.setRight(null, this.right);
                return this.left;
            }
            if (this.getLeftSubTree() == null) {
                this.right.relativePosition = this.right.relativePosition + (this.relativePosition - (this.relativePosition < 0 ? 0 : 1));
                super.setLeft(null, this.left);
                return this.right;
            }
            if (this.heightRightMinusLeft() > 0) {
                AVLNode<T> rightMin = super.min();
                this.value = rightMin.value;
                if (this.leftIsPrevious) {
                    this.left = rightMin.left;
                }
                this.right = super.removeMin();
                if (this.relativePosition < 0) {
                    ++this.relativePosition;
                }
            } else {
                AVLNode<T> leftMax = super.max();
                this.value = leftMax.value;
                if (this.rightIsNext) {
                    this.right = leftMax.right;
                }
                this.left = super.removeMax();
                if (this.relativePosition > 0) {
                    --this.relativePosition;
                }
            }
            this.recalcHeight();
            return this;
        }

        private AVLNode<T> balance() {
            switch (this.heightRightMinusLeft()) {
                case -1: 
                case 0: 
                case 1: {
                    return this;
                }
                case -2: {
                    if (super.heightRightMinusLeft() > 0) {
                        this.setLeft(super.rotateLeft(), null);
                    }
                    return this.rotateRight();
                }
                case 2: {
                    if (super.heightRightMinusLeft() < 0) {
                        this.setRight(super.rotateRight(), null);
                    }
                    return this.rotateLeft();
                }
            }
            throw new RuntimeException("tree inconsistent!");
        }

        private int getOffset(AVLNode<T> node) {
            if (node == null) {
                return 0;
            }
            return node.relativePosition;
        }

        private int setOffset(AVLNode<T> node, int newOffest) {
            if (node == null) {
                return 0;
            }
            int oldOffset = this.getOffset(node);
            node.relativePosition = newOffest;
            return oldOffset;
        }

        private void recalcHeight() {
            this.height = Math.max(this.getLeftSubTree() == null ? -1 : this.getLeftSubTree().height, this.getRightSubTree() == null ? -1 : this.getRightSubTree().height) + 1;
        }

        private int getHeight(AVLNode<T> node) {
            return node == null ? -1 : node.height;
        }

        private int heightRightMinusLeft() {
            return this.getHeight(this.getRightSubTree()) - this.getHeight(this.getLeftSubTree());
        }

        private AVLNode<T> rotateLeft() {
            AVLNode<T> newTop = this.right;
            AVLNode<T> movedNode = super.getLeftSubTree();
            int newTopPosition = this.relativePosition + this.getOffset(newTop);
            int myNewPosition = -newTop.relativePosition;
            int movedPosition = this.getOffset(newTop) + this.getOffset(movedNode);
            this.setRight(movedNode, newTop);
            super.setLeft(this, null);
            this.setOffset(newTop, newTopPosition);
            this.setOffset(this, myNewPosition);
            this.setOffset(movedNode, movedPosition);
            return newTop;
        }

        private AVLNode<T> rotateRight() {
            AVLNode<T> newTop = this.left;
            AVLNode<T> movedNode = super.getRightSubTree();
            int newTopPosition = this.relativePosition + this.getOffset(newTop);
            int myNewPosition = -newTop.relativePosition;
            int movedPosition = this.getOffset(newTop) + this.getOffset(movedNode);
            this.setLeft(movedNode, newTop);
            super.setRight(this, null);
            this.setOffset(newTop, newTopPosition);
            this.setOffset(this, myNewPosition);
            this.setOffset(movedNode, movedPosition);
            return newTop;
        }

        private void setLeft(AVLNode<T> node, AVLNode<T> previous) {
            this.leftIsPrevious = node == null;
            this.left = this.leftIsPrevious ? previous : node;
            this.recalcHeight();
        }

        private void setRight(AVLNode<T> node, AVLNode<T> next) {
            this.rightIsNext = node == null;
            this.right = this.rightIsNext ? next : node;
            this.recalcHeight();
        }

        public String toString() {
            return "AVLNode(" + this.relativePosition + "," + (this.left != null) + "," + this.value + "," + (this.getRightSubTree() != null) + ", faedelung " + this.rightIsNext + " )";
        }
    }
}

