/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.buffer;

import java.util.Collection;
import org.apache.commons.collections15.Buffer;
import org.apache.commons.collections15.BufferUnderflowException;
import org.apache.commons.collections15.buffer.SynchronizedBuffer;

public class BlockingBuffer<E>
extends SynchronizedBuffer<E> {
    private static final long serialVersionUID = 1719328905017860541L;

    public static <E> Buffer<E> decorate(Buffer<E> buffer) {
        return new BlockingBuffer<E>(buffer);
    }

    protected BlockingBuffer(Buffer<E> buffer) {
        super(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E o) {
        Object object = this.lock;
        synchronized (object) {
            boolean result = this.collection.add(o);
            this.notifyAll();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        Object object = this.lock;
        synchronized (object) {
            boolean result = this.collection.addAll(c);
            this.notifyAll();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get() {
        Object object = this.lock;
        synchronized (object) {
            while (this.collection.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new BufferUnderflowException();
                }
            }
            return this.getBuffer().get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove() {
        Object object = this.lock;
        synchronized (object) {
            while (this.collection.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new BufferUnderflowException();
                }
            }
            return this.getBuffer().remove();
        }
    }
}

