/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.bag;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections15.SortedBag;
import org.apache.commons.collections15.bag.AbstractMapBag;

public class TreeBag<E>
extends AbstractMapBag<E>
implements SortedBag<E>,
Serializable {
    static final long serialVersionUID = -7740146511091606676L;

    public TreeBag() {
        super(new TreeMap());
    }

    public TreeBag(Comparator<? super E> comparator) {
        super(new TreeMap(comparator));
    }

    public TreeBag(Collection<? extends E> coll) {
        this();
        this.addAll(coll);
    }

    @Override
    public E first() {
        return (E)((SortedMap)this.getMap()).firstKey();
    }

    @Override
    public E last() {
        return (E)((SortedMap)this.getMap()).lastKey();
    }

    @Override
    public Comparator comparator() {
        return ((SortedMap)this.getMap()).comparator();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.comparator());
        super.doWriteObject(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Comparator comp = (Comparator)in.readObject();
        super.doReadObject(new TreeMap(comp), in);
    }
}

