/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.collections15.MapIterator;
import org.apache.commons.collections15.OrderedIterator;
import org.apache.commons.collections15.OrderedMapIterator;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.ResettableIterator;
import org.apache.commons.collections15.ResettableListIterator;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.iterators.ArrayIterator;
import org.apache.commons.collections15.iterators.ArrayListIterator;
import org.apache.commons.collections15.iterators.CollatingIterator;
import org.apache.commons.collections15.iterators.EmptyIterator;
import org.apache.commons.collections15.iterators.EmptyListIterator;
import org.apache.commons.collections15.iterators.EmptyMapIterator;
import org.apache.commons.collections15.iterators.EmptyOrderedIterator;
import org.apache.commons.collections15.iterators.EmptyOrderedMapIterator;
import org.apache.commons.collections15.iterators.EnumerationIterator;
import org.apache.commons.collections15.iterators.FilterIterator;
import org.apache.commons.collections15.iterators.FilterListIterator;
import org.apache.commons.collections15.iterators.IteratorChain;
import org.apache.commons.collections15.iterators.IteratorEnumeration;
import org.apache.commons.collections15.iterators.ListIteratorWrapper;
import org.apache.commons.collections15.iterators.LoopingIterator;
import org.apache.commons.collections15.iterators.ObjectArrayIterator;
import org.apache.commons.collections15.iterators.ObjectArrayListIterator;
import org.apache.commons.collections15.iterators.ObjectGraphIterator;
import org.apache.commons.collections15.iterators.SingletonIterator;
import org.apache.commons.collections15.iterators.SingletonListIterator;
import org.apache.commons.collections15.iterators.TransformIterator;
import org.apache.commons.collections15.iterators.UnmodifiableIterator;
import org.apache.commons.collections15.iterators.UnmodifiableListIterator;
import org.apache.commons.collections15.iterators.UnmodifiableMapIterator;

public class IteratorUtils {
    public static final ResettableIterator EMPTY_ITERATOR = EmptyIterator.RESETTABLE_INSTANCE;
    public static final ResettableListIterator EMPTY_LIST_ITERATOR = EmptyListIterator.RESETTABLE_INSTANCE;
    public static final OrderedIterator EMPTY_ORDERED_ITERATOR = EmptyOrderedIterator.INSTANCE;
    public static final MapIterator EMPTY_MAP_ITERATOR = EmptyMapIterator.INSTANCE;
    public static final OrderedMapIterator EMPTY_ORDERED_MAP_ITERATOR = EmptyOrderedMapIterator.INSTANCE;

    public static ResettableIterator emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static ResettableListIterator emptyListIterator() {
        return EMPTY_LIST_ITERATOR;
    }

    public static OrderedIterator emptyOrderedIterator() {
        return EMPTY_ORDERED_ITERATOR;
    }

    public static MapIterator emptyMapIterator() {
        return EMPTY_MAP_ITERATOR;
    }

    public static OrderedMapIterator emptyOrderedMapIterator() {
        return EMPTY_ORDERED_MAP_ITERATOR;
    }

    public static <E> ResettableIterator<E> singletonIterator(E object) {
        return new SingletonIterator<E>(object);
    }

    public static <E> ListIterator<E> singletonListIterator(E object) {
        return new SingletonListIterator<E>(object);
    }

    public static <E> ResettableIterator<E> arrayIterator(E[] array) {
        return new ObjectArrayIterator<E>(array);
    }

    public static <E> ResettableIterator<E> arrayIterator(Object array) {
        return new ArrayIterator(array);
    }

    public static <E> ResettableIterator<E> arrayIterator(E[] array, int start) {
        return new ObjectArrayIterator<E>(array, start);
    }

    public static <E> ResettableIterator<E> arrayIterator(Object array, int start) {
        return new ArrayIterator(array, start);
    }

    public static <E> ResettableIterator<E> arrayIterator(E[] array, int start, int end) {
        return new ObjectArrayIterator<E>(array, start, end);
    }

    public static <E> ResettableIterator<E> arrayIterator(Object array, int start, int end) {
        return new ArrayIterator(array, start, end);
    }

    public static <E> ResettableListIterator<E> arrayListIterator(E[] array) {
        return new ObjectArrayListIterator<E>(array);
    }

    public static <E> ResettableListIterator<E> arrayListIterator(Object array) {
        return new ArrayListIterator(array);
    }

    public static <E> ResettableListIterator<E> arrayListIterator(E[] array, int start) {
        return new ObjectArrayListIterator<E>(array, start);
    }

    public static <E> ResettableListIterator<E> arrayListIterator(Object array, int start) {
        return new ArrayListIterator(array, start);
    }

    public static <E> ResettableListIterator<E> arrayListIterator(E[] array, int start, int end) {
        return new ObjectArrayListIterator<E>(array, start, end);
    }

    public static <E> ResettableListIterator<E> arrayListIterator(Object array, int start, int end) {
        return new ArrayListIterator(array, start, end);
    }

    public static <E> Iterator<E> unmodifiableIterator(Iterator<E> iterator) {
        return UnmodifiableIterator.decorate(iterator);
    }

    public static <E> ListIterator<E> unmodifiableListIterator(ListIterator<E> listIterator) {
        return UnmodifiableListIterator.decorate(listIterator);
    }

    public static <K, V> MapIterator<K, V> unmodifiableMapIterator(MapIterator<K, V> mapIterator) {
        return UnmodifiableMapIterator.decorate(mapIterator);
    }

    public static <E> Iterator<E> chainedIterator(Iterator<E> iterator1, Iterator<E> iterator2) {
        return new IteratorChain<E>(iterator1, iterator2);
    }

    public static <E> Iterator<E> chainedIterator(Iterator<E>[] iterators) {
        return new IteratorChain<E>(iterators);
    }

    public static <E> Iterator<E> chainedIterator(Collection<Iterator<? extends E>> iterators) {
        return new IteratorChain<E>(iterators);
    }

    public static <E> Iterator<E> collatedIterator(Comparator<? super E> comparator, Iterator<? extends E> iterator1, Iterator<? extends E> iterator2) {
        return new CollatingIterator<E>(comparator, iterator1, iterator2);
    }

    public static <E> Iterator<E> collatedIterator(Comparator<? super E> comparator, Iterator<? extends E>[] iterators) {
        return new CollatingIterator<E>(comparator, iterators);
    }

    public static <E> Iterator<E> collatedIterator(Comparator<? super E> comparator, Collection<Iterator<? extends E>> iterators) {
        return new CollatingIterator<E>(comparator, iterators);
    }

    public static Iterator objectGraphIterator(Object root, Transformer transformer) {
        return new ObjectGraphIterator(root, transformer);
    }

    public static <I, O> Iterator<O> transformedIterator(Iterator<I> iterator, Transformer<I, O> transform) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        if (transform == null) {
            throw new NullPointerException("Transformer must not be null");
        }
        return new TransformIterator<I, O>(iterator, transform);
    }

    public static <E> Iterator<E> filteredIterator(Iterator<E> iterator, Predicate<? super E> predicate) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        if (predicate == null) {
            throw new NullPointerException("Predicate must not be null");
        }
        return new FilterIterator<E>(iterator, predicate);
    }

    public static <E> ListIterator<E> filteredListIterator(ListIterator<E> listIterator, Predicate<? super E> predicate) {
        if (listIterator == null) {
            throw new NullPointerException("ListIterator must not be null");
        }
        if (predicate == null) {
            throw new NullPointerException("Predicate must not be null");
        }
        return new FilterListIterator<E>(listIterator, predicate);
    }

    public static <E> ResettableIterator<E> loopingIterator(Collection<E> coll) {
        if (coll == null) {
            throw new NullPointerException("Collection must not be null");
        }
        return new LoopingIterator<E>(coll);
    }

    public static <E> Iterator<E> asIterator(Enumeration<E> enumeration) {
        if (enumeration == null) {
            throw new NullPointerException("Enumeration must not be null");
        }
        return new EnumerationIterator<E>(enumeration);
    }

    public static <E> Iterator<E> asIterator(Enumeration<E> enumeration, Collection<E> removeCollection) {
        if (enumeration == null) {
            throw new NullPointerException("Enumeration must not be null");
        }
        if (removeCollection == null) {
            throw new NullPointerException("Collection must not be null");
        }
        return new EnumerationIterator<E>(enumeration, removeCollection);
    }

    public static <E> Enumeration<E> asEnumeration(Iterator<E> iterator) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        return new IteratorEnumeration<E>(iterator);
    }

    public static <E> ListIterator<E> toListIterator(Iterator<E> iterator) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        return new ListIteratorWrapper<E>(iterator);
    }

    public static <E> E[] toArray(Iterator<E> iterator) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        List<E> list = IteratorUtils.toList(iterator, 100);
        return list.toArray();
    }

    public static <E> E[] toArray(Iterator<E> iterator, Class<E> arrayClass) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        if (arrayClass == null) {
            throw new NullPointerException("Array class must not be null");
        }
        List<E> list = IteratorUtils.toList(iterator, 100);
        return list.toArray((Object[])Array.newInstance(arrayClass, list.size()));
    }

    public static <E> List<E> toList(Iterator<E> iterator) {
        return IteratorUtils.toList(iterator, 10);
    }

    public static <E> List<E> toList(Iterator<E> iterator, int estimatedSize) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        if (estimatedSize < 1) {
            throw new IllegalArgumentException("Estimated size must be greater than 0");
        }
        ArrayList<E> list = new ArrayList<E>(estimatedSize);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static Iterator getIterator(Object obj) {
        if (obj == null) {
            return IteratorUtils.emptyIterator();
        }
        if (obj instanceof Iterator) {
            return (Iterator)obj;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).iterator();
        }
        if (obj instanceof Object[]) {
            return new ObjectArrayIterator<Object>((Object[])obj);
        }
        if (obj instanceof Enumeration) {
            return new EnumerationIterator((Enumeration)obj);
        }
        if (obj instanceof Map) {
            return ((Map)obj).values().iterator();
        }
        if (obj instanceof Dictionary) {
            return new EnumerationIterator(((Dictionary)obj).elements());
        }
        if (obj != null && obj.getClass().isArray()) {
            return new ArrayIterator(obj);
        }
        try {
            Iterator it;
            Method method = obj.getClass().getMethod("iterator", null);
            if (Iterator.class.isAssignableFrom(method.getReturnType()) && (it = (Iterator)method.invoke(obj, null)) != null) {
                return it;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return IteratorUtils.singletonIterator(obj);
    }
}

