/*
 * Decompiled with CFR 0.152.
 */
package lcmc.utilities;

import java.util.HashMap;
import java.util.Map;
import lcmc.data.Host;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;

public final class VIRSH {
    private static final Map<String, String> VIRSH_COMMANDS = new HashMap<String, String>();

    private VIRSH() {
    }

    private static boolean execCommand(Host host, String commands, boolean outputVisible) {
        SSH.SSHOutput ret;
        return !host.isConnected() || (ret = Tools.execCommandProgressIndicator(host, commands, null, outputVisible, Tools.getString("VIRSH.ExecutingCommand") + " " + commands.replaceAll("@DMCSUDO@", " ") + "...", SSH.DEFAULT_COMMAND_TIMEOUT)).getExitCode() == 0;
    }

    private static boolean execCommand(Host[] hosts, Map<Host, String> hostCommands, boolean outputVisible) {
        boolean exitCode = false;
        for (Host host : hosts) {
            String commands = hostCommands.get(host);
            if (commands.length() <= 0 || VIRSH.execCommand(host, commands, outputVisible)) continue;
            return false;
        }
        return true;
    }

    public static void setParameters(Host[] hosts, String domainName, Map<String, String> parameters, String options) {
        HashMap<Host, String> hostCommands = new HashMap<Host, String>();
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put("@DOMAIN@", domainName);
        replaceHash.put("@OPTIONS@", options);
        for (Host host : hosts) {
            StringBuilder commands = new StringBuilder(100);
            for (String param : parameters.keySet()) {
                String command = host.getDistCommand(VIRSH_COMMANDS.get(param), replaceHash);
                if (command == null) continue;
                if (command.indexOf("@VALUE@") >= 0) {
                    String value = parameters.get(param);
                    if ("autostart".equals(param)) {
                        value = value == null || !value.equals(host.getName()) ? "--disable" : "";
                    }
                    command = command.replaceAll("@VALUE@", value);
                }
                if (commands.length() > 0) {
                    commands.append(" && ");
                }
                commands.append(command);
                hostCommands.put(host, commands.toString());
            }
        }
        VIRSH.execCommand(hosts, hostCommands, true);
    }

    public static boolean start(Host host, String domain, String options) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put("@DOMAIN@", domain);
        replaceHash.put("@OPTIONS@", options);
        String command = host.getDistCommand("VIRSH.Start", replaceHash);
        return VIRSH.execCommand(host, command, true);
    }

    public static boolean shutdown(Host host, String domain, String options) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put("@DOMAIN@", domain);
        replaceHash.put("@OPTIONS@", options);
        String command = host.getDistCommand("VIRSH.Shutdown", replaceHash);
        return VIRSH.execCommand(host, command, true);
    }

    public static boolean reboot(Host host, String domain, String options) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put("@DOMAIN@", domain);
        replaceHash.put("@OPTIONS@", options);
        String command = host.getDistCommand("VIRSH.Reboot", replaceHash);
        return VIRSH.execCommand(host, command, true);
    }

    public static boolean destroy(Host host, String domain, String options) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put("@DOMAIN@", domain);
        replaceHash.put("@OPTIONS@", options);
        String command = host.getDistCommand("VIRSH.Destroy", replaceHash);
        return VIRSH.execCommand(host, command, true);
    }

    public static boolean suspend(Host host, String domain, String options) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put("@DOMAIN@", domain);
        replaceHash.put("@OPTIONS@", options);
        String command = host.getDistCommand("VIRSH.Suspend", replaceHash);
        return VIRSH.execCommand(host, command, true);
    }

    public static boolean resume(Host host, String domain, String options) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put("@DOMAIN@", domain);
        replaceHash.put("@OPTIONS@", options);
        String command = host.getDistCommand("VIRSH.Resume", replaceHash);
        return VIRSH.execCommand(host, command, true);
    }

    public static boolean define(Host host, String config, String options) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put("@CONFIG@", config);
        replaceHash.put("@OPTIONS@", options);
        String command = host.getDistCommand("VIRSH.Define", replaceHash);
        return VIRSH.execCommand(host, command, true);
    }

    public static String getDefineCommand(Host host, String config, String options) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put("@CONFIG@", config);
        replaceHash.put("@OPTIONS@", options);
        String command = host.getDistCommand("VIRSH.Define", replaceHash);
        return command;
    }

    public static boolean undefine(Host host, String domain, String options) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put("@DOMAIN@", domain);
        replaceHash.put("@OPTIONS@", options);
        String command = host.getDistCommand("VIRSH.Undefine", replaceHash);
        return VIRSH.execCommand(host, command, true);
    }

    static {
        VIRSH_COMMANDS.put("autostart", "VIRSH.Autostart");
    }
}

