/*
 * Decompiled with CFR 0.152.
 */
package lcmc.utilities;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.InteractiveCallback;
import ch.ethz.ssh2.KnownHosts;
import ch.ethz.ssh2.LocalPortForwarder;
import ch.ethz.ssh2.SCPClient;
import ch.ethz.ssh2.ServerHostKeyVerifier;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.channel.ChannelManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import lcmc.data.Host;
import lcmc.gui.ProgressBar;
import lcmc.gui.SSHGui;
import lcmc.utilities.ConnectionCallback;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.NewOutputCallback;
import lcmc.utilities.Tools;

public final class SSH {
    private SSHGui sshGui;
    private ConnectionCallback callback;
    private Host host;
    private volatile MyConnection connection = null;
    private volatile ConnectionThread connectionThread = null;
    private ProgressBar progressBar = null;
    private boolean connectionFailed;
    private volatile boolean disconnectForGood = true;
    private static final int ERROR_EXIT_CODE = 255;
    private static final int EXEC_OUTPUT_BUFFER_SIZE = 8192;
    private String lastPassword = null;
    private String lastRSAKey = null;
    private String lastDSAKey = null;
    private final Lock mConnectionLock = new ReentrantLock();
    private final Lock mConnectionThreadLock = new ReentrantLock();
    private LocalPortForwarder localPortForwarder = null;
    public static final int DEFAULT_COMMAND_TIMEOUT = Tools.getDefaultInt("SSH.Command.Timeout");
    public static final int DEFAULT_COMMAND_TIMEOUT_LONG = Tools.getDefaultInt("SSH.Command.Timeout.Long");
    public static final int NO_COMMAND_TIMEOUT = 0;
    public static final String SUDO_PROMPT = "DRBD MC sudo pwd: ";
    public static final String SUDO_FAIL = "Sorry, try again";

    boolean reconnect() {
        ConnectionThread ct;
        this.mConnectionThreadLock.lock();
        if (this.connectionThread == null) {
            this.mConnectionThreadLock.unlock();
        } else {
            try {
                ct = this.connectionThread;
                this.mConnectionThreadLock.unlock();
                ct.join(20000L);
                if (ct.isAlive()) {
                    return false;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.disconnectForGood) {
            return false;
        }
        if (!this.isConnected()) {
            Tools.debug(this, "connecting: " + this.host.getName(), 1);
            this.callback = null;
            this.progressBar = null;
            this.sshGui = new SSHGui(Tools.getGUIData().getMainFrame(), this.host, null);
            this.host.getTerminalPanel().addCommand("ssh " + this.host.getUserAtHost());
            ct = new ConnectionThread();
            this.mConnectionThreadLock.lock();
            this.connectionThread = ct;
            this.mConnectionThreadLock.unlock();
            ct.start();
        }
        return true;
    }

    public void connect(SSHGui sshGui, ConnectionCallback callback, Host host) {
        this.sshGui = sshGui;
        this.callback = callback;
        this.host = host;
        this.connectionFailed = false;
        if (this.connection != null) {
            if (callback != null) {
                callback.done(1);
            }
            return;
        }
        host.getTerminalPanel().addCommand("ssh " + host.getUserAtHost());
        ConnectionThread ct = new ConnectionThread();
        this.mConnectionThreadLock.lock();
        this.connectionThread = ct;
        this.mConnectionThreadLock.unlock();
        ct.start();
    }

    public void setPasswords(String lastDSAKey, String lastRSAKey, String lastPassword) {
        if (this.lastDSAKey == null && this.lastRSAKey == null && this.lastPassword == null) {
            this.lastDSAKey = lastDSAKey;
            this.lastRSAKey = lastRSAKey;
            this.lastPassword = lastPassword;
        }
    }

    public String getLastDSAKey() {
        return this.lastDSAKey;
    }

    public String getLastRSAKey() {
        return this.lastRSAKey;
    }

    public String getLastPassword() {
        return this.lastPassword;
    }

    public void waitForConnection() {
        this.mConnectionThreadLock.lock();
        if (this.connectionThread == null) {
            this.mConnectionThreadLock.unlock();
        } else {
            try {
                ConnectionThread ct = this.connectionThread;
                this.mConnectionThreadLock.unlock();
                ct.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void connect(SSHGui sshGuiT, ProgressBar progressBar, ConnectionCallback callbackT, Host hostT) {
        this.progressBar = progressBar;
        this.connect(sshGuiT, callbackT, hostT);
    }

    public void cancelConnection() {
        this.mConnectionThreadLock.lock();
        ConnectionThread ct = this.connectionThread;
        this.mConnectionThreadLock.unlock();
        if (ct != null) {
            ct.cancel();
        }
        Tools.debug(this, "SSH cancel", 1);
        String message = "canceled";
        Tools.debug(this, "canceled", 1);
        this.host.getTerminalPanel().addCommandOutput("canceled\n");
        this.host.getTerminalPanel().nextCommand();
        this.connectionFailed = true;
        if (this.callback != null) {
            this.callback.doneError("canceled");
        }
    }

    public void cancelSession(ExecCommandThread execCommandThread) {
        execCommandThread.cancel();
        Tools.debug(this, "session cancel", 1);
        String message = "canceled";
        Tools.debug(this, "canceled", 1);
        this.host.getTerminalPanel().addCommandOutput("\n");
        this.host.getTerminalPanel().nextCommand();
    }

    public void disconnect() {
        this.mConnectionLock.lock();
        if (this.connection == null) {
            this.mConnectionLock.unlock();
        } else {
            this.disconnectForGood = true;
            this.connection.close();
            this.connection = null;
            this.mConnectionLock.unlock();
            Tools.debug(this, "disconnecting: " + this.host.getName(), 0);
            this.host.getTerminalPanel().addCommand("logout");
            this.host.getTerminalPanel().nextCommand();
        }
    }

    public void forceReconnect() {
        this.mConnectionLock.lock();
        if (this.connection == null) {
            this.mConnectionLock.unlock();
        } else {
            this.connection = null;
            this.mConnectionLock.unlock();
            Tools.debug(this, "force reconnecting: " + this.host.getName(), 0);
            this.host.getTerminalPanel().addCommand("logout");
            this.host.getTerminalPanel().nextCommand();
        }
    }

    public void forceDisconnect() {
        this.mConnectionLock.lock();
        if (this.connection == null) {
            this.mConnectionLock.unlock();
        } else {
            this.disconnectForGood = true;
            this.connection = null;
            this.mConnectionLock.unlock();
            Tools.debug(this, "force disconnecting: " + this.host.getName(), 0);
            this.host.getTerminalPanel().addCommand("logout");
            this.host.getTerminalPanel().nextCommand();
        }
    }

    public boolean isConnected() {
        this.mConnectionLock.lock();
        boolean ret = this.connection != null;
        this.mConnectionLock.unlock();
        return ret;
    }

    public boolean isConnectionFailed() {
        return this.connectionFailed;
    }

    public SSHOutput execCommandAndWait(String command, boolean outputVisible, boolean commandVisible, int sshCommandTimeout) {
        ExecCommandThread execCommandThread;
        if (this.host == null) {
            return new SSHOutput("", 101);
        }
        final String[] answer = new String[]{""};
        final Integer[] exitCode = new Integer[]{100};
        try {
            execCommandThread = new ExecCommandThread(command, new ExecCallback(){

                @Override
                public void done(String ans) {
                    answer[0] = ans;
                    exitCode[0] = 0;
                }

                @Override
                public void doneError(String ans, int ec) {
                    answer[0] = ans;
                    exitCode[0] = ec;
                }
            }, null, outputVisible, commandVisible, sshCommandTimeout);
        }
        catch (IOException e) {
            Tools.appError("Can not execute command: " + command, "", e);
            return new SSHOutput("", 102);
        }
        execCommandThread.start();
        try {
            execCommandThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return new SSHOutput(answer[0], exitCode[0]);
    }

    public ExecCommandThread execCommand(String command, ExecCallback execCallback, boolean outputVisible, boolean commandVisible, int sshCommandTimeout) {
        ExecCommandThread execCommandThread;
        if (this.host == null) {
            return null;
        }
        String realCommand = this.host.replaceVars(command);
        Tools.debug(this, "real command: " + realCommand, 2);
        try {
            execCommandThread = new ExecCommandThread(realCommand, execCallback, null, outputVisible, commandVisible, sshCommandTimeout);
        }
        catch (IOException e) {
            Tools.appError("Can not execute command: " + realCommand, "", e);
            return null;
        }
        execCommandThread.setPriority(1);
        execCommandThread.start();
        return execCommandThread;
    }

    public ExecCommandThread execCommand(String command, ExecCallback execCallback, NewOutputCallback newOutputCallback, boolean outputVisible, boolean commandVisible, int sshCommandTimeout) {
        ExecCommandThread execCommandThread;
        String realCommand = this.host.replaceVars(command);
        try {
            execCommandThread = new ExecCommandThread(realCommand, execCallback, newOutputCallback, outputVisible, commandVisible, sshCommandTimeout);
        }
        catch (IOException e) {
            Tools.appError("Can not execute command: " + realCommand, "", e);
            return null;
        }
        execCommandThread.setPriority(1);
        execCommandThread.start();
        return execCommandThread;
    }

    public ExecCommandThread execCommand(String command, ProgressBar progressBar, ExecCallback execCallback, boolean outputVisible, boolean commandVisible, int sshCommandTimeout) {
        Tools.debug(this, "execCommand with progress bar", 2);
        this.progressBar = progressBar;
        if (progressBar != null) {
            progressBar.start(0);
            progressBar.hold();
        }
        return this.execCommand(command, execCallback, outputVisible, commandVisible, sshCommandTimeout);
    }

    private String getKeyFromUser(String lastError) {
        return this.sshGui.enterSomethingDialog(Tools.getString("SSH.RSA.DSA.Authentication"), new String[]{lastError, "<html>" + Tools.getString("SSH.Enter.passphrase") + "</html>"}, "<html>" + Tools.getString("SSH.Enter.passphrase2") + "</html>", Tools.getDefault("SSH.PublicKey"), true);
    }

    private boolean enterSudoPassword() {
        if (this.host.isUseSudo() != null && this.host.isUseSudo().booleanValue()) {
            String lastError = "";
            String lastSudoPwd = this.host.getSudoPassword();
            String sudoPwd = this.sshGui.enterSomethingDialog(Tools.getString("SSH.SudoAuthentication"), new String[]{"", "<html>" + this.host.getName() + Tools.getString("SSH.Enter.sudoPassword") + "</html>"}, null, null, true);
            if (sudoPwd == null) {
                return true;
            }
            this.host.setSudoPassword(sudoPwd);
        }
        return false;
    }

    public void installGuiHelper() {
        if (!Tools.getConfigData().getKeepHelper()) {
            String fileName = "/help-progs/lcmc-gui-helper";
            String file = Tools.getFile("/help-progs/lcmc-gui-helper");
            if (file != null) {
                this.scp(file, "@GUI-HELPER@", "0700", false, null, null, null);
            }
        }
    }

    void installTestFiles() {
        String fileName = "lcmc-test.tar";
        MyConnection conn = this.connection;
        if (conn == null) {
            return;
        }
        SCPClient scpClient = new SCPClient(conn);
        String file = Tools.getFile("/lcmc-test.tar");
        try {
            scpClient.put(file.getBytes(), "lcmc-test.tar", "/tmp");
        }
        catch (IOException e) {
            Tools.appError("could not copy: lcmc-test.tar", "", e);
            return;
        }
        SSHOutput ret = this.execCommandAndWait("tar xf /tmp/lcmc-test.tar -C /tmp/", false, false, 60000);
    }

    public void createConfig(String config, String fileName, String dir, String mode, boolean makeBackup, String preCommand, String postCommand) {
        this.scp(config, dir + fileName, mode, makeBackup, null, preCommand, postCommand);
    }

    public void scp(String fileContent, String remoteFilename, String mode, boolean makeBackup, String installCommand, String preCommand, String postCommand) {
        int index;
        StringBuilder commands = new StringBuilder(40);
        if (preCommand != null) {
            commands.append(preCommand);
            commands.append(';');
        }
        if (makeBackup) {
            commands.append("cp ");
            commands.append(remoteFilename);
            commands.append("{,.bak} 2>/dev/null;");
        }
        if ((index = remoteFilename.lastIndexOf(47)) > 0) {
            String dir = remoteFilename.substring(0, index + 1);
            commands.append("mkdir -p ");
            commands.append(dir);
            commands.append(';');
        }
        if (!this.isConnected()) {
            return;
        }
        String modeString = "";
        if (mode != null) {
            modeString = " && chmod " + mode + " " + remoteFilename + ".new";
        }
        String postCommandString = "";
        if (postCommand != null) {
            postCommandString = " && " + postCommand;
        }
        StringBuilder backupString = new StringBuilder(50);
        if (makeBackup) {
            backupString.append(" && if ! diff ");
            backupString.append(remoteFilename);
            backupString.append("{,.bak}>/dev/null 2>&1; then ");
            backupString.append("mv ");
            backupString.append(remoteFilename);
            backupString.append("{.bak,.`date +'%s'`} 2>/dev/null;true;");
            backupString.append(" else ");
            backupString.append("rm -f ");
            backupString.append(remoteFilename);
            backupString.append(".bak;");
            backupString.append(" fi ");
        }
        String stacktrace = Tools.getStackTrace();
        if (installCommand == null) {
            installCommand = "mv " + remoteFilename + ".new " + remoteFilename;
        }
        String commandTail = "\">" + remoteFilename + ".new" + modeString + "&& " + installCommand + postCommandString + backupString.toString();
        Tools.debug(this, commands.toString() + "echo \"" + "..." + commandTail, 1);
        ExecCommandThread t = this.execCommand("@DMCSUDO@bash -c \"" + Tools.escapeQuotes(commands.toString() + "echo \"" + Tools.escapeQuotes(fileContent, 1) + commandTail, 1) + "\"", new ExecCallback(){

            @Override
            public void done(String ans) {
            }

            @Override
            public void doneError(String ans, int exitCode) {
                if (ans == null) {
                    return;
                }
                for (final String line : ans.split("\n")) {
                    if (line.indexOf("error:") != 0) continue;
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Tools.progressIndicatorFailed(SSH.this.host.getName(), line, 3000);
                        }
                    });
                    t.start();
                }
            }
        }, false, false, 10000);
        try {
            t.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    void startVncPortForwarding(String remoteHost, int remotePort) throws IOException {
        int localPort = remotePort + Tools.getConfigData().getVncPortOffset();
        this.localPortForwarder = this.connection.createLocalPortForwarder(localPort, "127.0.0.1", remotePort);
    }

    void stopVncPortForwarding(int remotePort) throws IOException {
        int localPort = remotePort + Tools.getConfigData().getVncPortOffset();
        this.localPortForwarder.close();
    }

    public boolean isConnectionCanceled() {
        return this.disconnectForGood;
    }

    public static final class SSHOutput {
        private final String output;
        private final int exitCode;

        SSHOutput(String output, int exitCode) {
            this.output = output;
            this.exitCode = exitCode;
        }

        public String getOutput() {
            return this.output;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }

    class ConnectionThread
    extends Thread {
        private final String username;
        private final String hostname;
        private boolean cancelIt = false;

        ConnectionThread() {
            this.username = SSH.this.host.getFirstUsername();
            this.hostname = SSH.this.host.getFirstIp();
        }

        private void authenticate(MyConnection conn) throws IOException {
            boolean enableKeyboardInteractive = true;
            boolean enablePublicKey = true;
            String lastError = null;
            int publicKeyTry = 3;
            int passwdTry = 3;
            int connectTimeout = Tools.getDefaultInt("SSH.ConnectTimeout");
            int kexTimeout = Tools.getDefaultInt("SSH.KexTimeout");
            boolean noPassphrase = Tools.getConfigData().isNoPassphrase();
            while (!this.cancelIt) {
                if (SSH.this.lastPassword == null) {
                    SSH.this.lastPassword = Tools.getConfigData().getAutoOptionHost("pw");
                    if (SSH.this.lastPassword == null) {
                        SSH.this.lastPassword = Tools.getConfigData().getAutoOptionCluster("pw");
                    }
                }
                if (SSH.this.lastPassword == null && enablePublicKey && conn.isAuthMethodAvailable(this.username, "publickey")) {
                    File dsaKey = new File(Tools.getConfigData().getIdDSAPath());
                    File rsaKey = new File(Tools.getConfigData().getIdRSAPath());
                    boolean res = false;
                    if (dsaKey.exists() || rsaKey.exists()) {
                        String key = "";
                        if (SSH.this.lastDSAKey != null) {
                            key = SSH.this.lastDSAKey;
                        } else if (SSH.this.lastRSAKey != null) {
                            key = SSH.this.lastRSAKey;
                        }
                        if (noPassphrase || !"".equals(key)) {
                            if (SSH.this.lastRSAKey == null && dsaKey.exists()) {
                                try {
                                    res = conn.authenticateWithPublicKey(this.username, dsaKey, key);
                                }
                                catch (Exception e) {
                                    SSH.this.lastDSAKey = null;
                                    Tools.debug(this, "dsa passwordless failed");
                                }
                                if (res) {
                                    Tools.debug(this, "dsa passwordless auth successful");
                                    SSH.this.lastDSAKey = key;
                                    SSH.this.lastRSAKey = null;
                                    SSH.this.lastPassword = null;
                                    break;
                                }
                                conn.close();
                                conn.connect(new AdvancedVerifier(), connectTimeout, kexTimeout);
                            }
                            if (rsaKey.exists()) {
                                try {
                                    res = conn.authenticateWithPublicKey(this.username, rsaKey, key);
                                }
                                catch (Exception e) {
                                    SSH.this.lastRSAKey = null;
                                    Tools.debug(this, "rsa passwordless failed");
                                }
                                if (res) {
                                    Tools.debug(this, "rsa passwordless auth successful");
                                    SSH.this.lastRSAKey = key;
                                    SSH.this.lastDSAKey = null;
                                    SSH.this.lastPassword = null;
                                    break;
                                }
                                conn.close();
                                conn.connect(new AdvancedVerifier(), connectTimeout, kexTimeout);
                            }
                        }
                        if ((key = SSH.this.getKeyFromUser(lastError)) == null) {
                            this.cancelIt = true;
                            SSH.this.disconnectForGood = true;
                            break;
                        }
                        if ("".equals(key)) {
                            publicKeyTry = 0;
                        }
                        if (dsaKey.exists()) {
                            try {
                                res = conn.authenticateWithPublicKey(this.username, dsaKey, key);
                            }
                            catch (Exception e) {
                                SSH.this.lastDSAKey = null;
                                Tools.debug(this, "dsa key auth failed");
                            }
                            if (res) {
                                Tools.debug(this, "dsa key auth successful");
                                SSH.this.lastRSAKey = null;
                                SSH.this.lastDSAKey = key;
                                SSH.this.lastPassword = null;
                                break;
                            }
                            conn.close();
                            conn.connect(new AdvancedVerifier(), connectTimeout, kexTimeout);
                        }
                        if (rsaKey.exists()) {
                            try {
                                res = conn.authenticateWithPublicKey(this.username, rsaKey, key);
                            }
                            catch (Exception e) {
                                SSH.this.lastRSAKey = null;
                                Tools.debug(this, "rsa key auth failed");
                            }
                            if (res) {
                                Tools.debug(this, "rsa key auth successful");
                                SSH.this.lastRSAKey = key;
                                SSH.this.lastDSAKey = null;
                                SSH.this.lastPassword = null;
                                break;
                            }
                            conn.close();
                            conn.connect(new AdvancedVerifier(), connectTimeout, kexTimeout);
                        }
                        lastError = Tools.getString("SSH.Publickey.Authentication.Failed");
                    } else {
                        publicKeyTry = 0;
                    }
                    if (--publicKeyTry > 0) continue;
                    enablePublicKey = false;
                    publicKeyTry = 3;
                    continue;
                }
                if (enableKeyboardInteractive && conn.isAuthMethodAvailable(this.username, "keyboard-interactive")) {
                    InteractiveLogic il = new InteractiveLogic(lastError);
                    boolean res = conn.authenticateWithKeyboardInteractive(this.username, il);
                    if (res) {
                        SSH.this.lastRSAKey = null;
                        SSH.this.lastDSAKey = null;
                        break;
                    }
                    SSH.this.lastPassword = null;
                    if (il.getPromptCount() == 0) {
                        lastError = Tools.getString("SSH.KeyboardInteractive.DoesNotWork");
                        enableKeyboardInteractive = false;
                        continue;
                    }
                    lastError = Tools.getString("SSH.KeyboardInteractive.Failed");
                    continue;
                }
                if (conn.isAuthMethodAvailable(this.username, "password")) {
                    boolean res;
                    String ans;
                    if (SSH.this.lastPassword == null) {
                        ans = SSH.this.sshGui.enterSomethingDialog(Tools.getString("SSH.PasswordAuthentication"), new String[]{lastError, "<html>" + SSH.this.host.getUserAtHost() + Tools.getString("SSH.Enter.password") + "</html>"}, null, null, true);
                        if (ans == null) {
                            this.cancelIt = true;
                            break;
                        }
                    } else {
                        ans = SSH.this.lastPassword;
                    }
                    if (ans == null) {
                        throw new IOException("Login aborted by user");
                    }
                    if ("".equals(ans)) {
                        passwdTry = 0;
                    }
                    if (res = conn.authenticateWithPassword(this.username, ans)) {
                        SSH.this.lastPassword = ans;
                        SSH.this.host.setSudoPassword(SSH.this.lastPassword);
                        SSH.this.lastRSAKey = null;
                        SSH.this.lastDSAKey = null;
                        break;
                    }
                    SSH.this.lastPassword = null;
                    lastError = Tools.getString("SSH.Password.Authentication.Failed");
                    if (--passwdTry > 0) continue;
                    enablePublicKey = true;
                    passwdTry = 3;
                    continue;
                }
                throw new IOException("No supported authentication methods available.");
            }
            if (this.cancelIt) {
                conn.close();
                Tools.debug(this, "closing established connection because it was canceled");
                SSH.this.mConnectionThreadLock.lock();
                SSH.this.connectionThread = null;
                SSH.this.mConnectionThreadLock.unlock();
                SSH.this.host.setConnected();
                if (SSH.this.callback != null) {
                    SSH.this.callback.doneError("");
                }
                SSH.this.mConnectionLock.lock();
                SSH.this.connection = null;
                SSH.this.mConnectionLock.unlock();
                SSH.this.host.setConnected();
            } else {
                SSH.this.mConnectionLock.lock();
                SSH.this.connection = conn;
                SSH.this.mConnectionLock.unlock();
                SSH.this.host.setConnected();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SSH.this.host.getTerminalPanel().nextCommand();
                    }
                });
                SSH.this.mConnectionThreadLock.lock();
                SSH.this.connectionThread = null;
                SSH.this.mConnectionThreadLock.unlock();
                SSH.this.host.setConnected();
                if (SSH.this.callback != null) {
                    SSH.this.callback.done(0);
                }
                Tools.debug(this, SSH.this.host.getName() + ": authentication ok", 1);
            }
        }

        void cancel() {
            this.cancelIt = true;
        }

        @Override
        public void run() {
            if (SSH.this.callback != null && SSH.this.isConnected()) {
                SSH.this.callback.done(1);
            }
            SSH.this.host.setSudoPassword("");
            MyConnection conn = new MyConnection(this.hostname, SSH.this.host.getSSHPortInt());
            SSH.this.disconnectForGood = false;
            try {
                Tools.debug(this, "verify host keys: " + this.hostname, 1);
                String[] hostkeyAlgos = Tools.getConfigData().getKnownHosts().getPreferredServerHostkeyAlgorithmOrder(this.hostname);
                if (hostkeyAlgos != null) {
                    conn.setServerHostKeyAlgorithms(hostkeyAlgos);
                }
                int connectTimeout = Tools.getDefaultInt("SSH.ConnectTimeout");
                int kexTimeout = Tools.getDefaultInt("SSH.KexTimeout");
                if (SSH.this.progressBar != null) {
                    int timeout = connectTimeout < kexTimeout ? connectTimeout : kexTimeout;
                    SSH.this.progressBar.start(timeout);
                }
                conn.connect(new AdvancedVerifier(), connectTimeout, kexTimeout);
                this.authenticate(conn);
            }
            catch (IOException e) {
                Tools.debug(this, "connecting: " + e.getMessage(), 1);
                SSH.this.connectionFailed = true;
                if (!this.cancelIt) {
                    SSH.this.host.getTerminalPanel().addCommandOutput(e.getMessage() + "\n");
                    SSH.this.host.getTerminalPanel().nextCommand();
                    if (SSH.this.callback != null) {
                        SSH.this.callback.doneError(e.getMessage());
                    }
                }
                SSH.this.mConnectionThreadLock.lock();
                SSH.this.connectionThread = null;
                SSH.this.mConnectionThreadLock.unlock();
                SSH.this.mConnectionLock.lock();
                SSH.this.connection = null;
                SSH.this.mConnectionLock.unlock();
                SSH.this.host.setConnected();
            }
        }
    }

    static class MyConnection
    extends Connection {
        MyConnection(String hostname, int port) {
            super(hostname, port);
        }

        void dmcCancel() {
            ChannelManager cm = this.getChannelManager();
            if (cm != null) {
                cm.closeAllChannels();
            }
        }
    }

    class InteractiveLogic
    implements InteractiveCallback {
        private int promptCount = 0;
        private String lastError;

        InteractiveLogic(String lastError) {
            this.lastError = lastError;
        }

        @Override
        public String[] replyToChallenge(String name, String instruction, int numPrompts, String[] prompt, boolean[] echo) throws IOException {
            String[] result = new String[numPrompts];
            for (int i = 0; i < numPrompts; ++i) {
                String ans;
                String[] content = new String[]{this.lastError, name, instruction, "<html><font color=red>" + prompt[i] + "</font>" + "</html>"};
                if (this.lastError != null) {
                    this.lastError = null;
                }
                if (SSH.this.lastPassword == null) {
                    ans = SSH.this.sshGui.enterSomethingDialog("Keyboard Interactive Authentication", content, null, null, !echo[i]);
                    SSH.this.lastPassword = ans;
                    SSH.this.host.setSudoPassword(SSH.this.lastPassword);
                } else {
                    ans = SSH.this.lastPassword;
                    SSH.this.host.setSudoPassword(SSH.this.lastPassword);
                }
                result[i] = ans;
                ++this.promptCount;
            }
            return result;
        }

        int getPromptCount() {
            return this.promptCount;
        }
    }

    class AdvancedVerifier
    implements ServerHostKeyVerifier {
        AdvancedVerifier() {
        }

        @Override
        public boolean verifyServerHostKey(String hostname, int port, String serverHostKeyAlgorithm, byte[] serverHostKey) throws Exception {
            String hostString = hostname;
            String algo = serverHostKeyAlgorithm;
            StringBuilder message = new StringBuilder(200);
            int result = Tools.getConfigData().getKnownHosts().verifyHostkey(hostname, serverHostKeyAlgorithm, serverHostKey);
            switch (result) {
                case 0: {
                    return true;
                }
                case 1: {
                    message.append("Do you want to accept the hostkey (type ");
                    message.append(algo);
                    message.append(") from ");
                    message.append(SSH.this.host);
                    message.append(" ?\n");
                    break;
                }
                case 2: {
                    message.append("WARNING! Hostkey for ");
                    message.append(hostString);
                    message.append(" has changed!\nAccept anyway?\n");
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            String hexFingerprint = KnownHosts.createHexFingerprint(serverHostKeyAlgorithm, serverHostKey);
            String bubblebabbleFingerprint = KnownHosts.createBubblebabbleFingerprint(serverHostKeyAlgorithm, serverHostKey);
            message.append("Hex Fingerprint: ");
            message.append(hexFingerprint);
            message.append("\nBubblebabble Fingerprint: ");
            message.append(bubblebabbleFingerprint);
            int choice = SSH.this.sshGui.getConfirmDialogChoice(message.toString());
            if (SSH.this.sshGui.isConfirmDialogYes(choice)) {
                String hashedHostname = KnownHosts.createHashedHostname(hostname);
                Tools.getConfigData().getKnownHosts().addHostkey(new String[]{hashedHostname}, serverHostKeyAlgorithm, serverHostKey);
                if (Tools.isWindows()) {
                    Tools.debug(this, "Not using known_hosts file, because this is Windows.");
                } else {
                    try {
                        KnownHosts.addHostkeyToFile(new File(Tools.getConfigData().getKnownHostPath()), new String[]{hashedHostname}, serverHostKeyAlgorithm, serverHostKey);
                    }
                    catch (IOException ignore) {
                        Tools.appWarning("SSH addHostKeyToFile failed " + ignore.getMessage());
                    }
                }
                return true;
            }
            if (SSH.this.sshGui.isConfirmDialogCancel(choice)) {
                throw new Exception("The user aborted the server hostkey verification.");
            }
            return false;
        }
    }

    public final class ExecCommandThread
    extends Thread {
        private String command;
        private final ExecCallback execCallback;
        private final NewOutputCallback newOutputCallback;
        private volatile boolean cancelIt = false;
        private boolean outputVisible;
        private final boolean commandVisible;
        private final Lock mSessionLock = new ReentrantLock();
        private Session sess = null;
        private final int sshCommandTimeout;

        private SSHOutput execOneCommand(String command, boolean outputVisible) {
            if (this.sshCommandTimeout > 0 && this.sshCommandTimeout < 2000) {
                Tools.appWarning(this.sshCommandTimeout + " to small for timeout? " + command);
            }
            this.command = command;
            this.outputVisible = outputVisible;
            int exitCode = 100;
            StringBuilder res = new StringBuilder("");
            SSH.this.mConnectionLock.lock();
            if (SSH.this.connection == null) {
                SSH.this.mConnectionLock.unlock();
                return new SSHOutput("SSH.NotConnected", 1);
            }
            SSH.this.mConnectionLock.unlock();
            if ("installGuiHelper".equals(command)) {
                SSH.this.installGuiHelper();
                return new SSHOutput("", 0);
            }
            try {
                this.mSessionLock.lock();
                Session thisSession = this.sess;
                this.mSessionLock.unlock();
                if (thisSession == null) {
                    return new SSHOutput("", 130);
                }
                thisSession.requestPTY("dumb", 0, 0, 0, 0, null);
                Tools.debug(this, "exec command: " + SSH.this.host.getName() + ": " + SSH.this.host.getSudoCommand(SSH.this.host.getHoppedCommand(command), true), 2);
                thisSession.execCommand("bash -c '" + Tools.escapeSingleQuotes("export LC_ALL=C;" + SSH.this.host.getSudoCommand(SSH.this.host.getHoppedCommand(command), false), 1) + "'");
                InputStream stdout = thisSession.getStdout();
                OutputStream stdin = thisSession.getStdin();
                InputStream stderr = thisSession.getStderr();
                byte[] buff = new byte[8192];
                boolean skipNextLine = false;
                boolean cancelSudo = false;
                while (true) {
                    String sudoPwd = SSH.this.host.getSudoPassword();
                    if (stdout.available() == 0 && stderr.available() == 0) {
                        int conditions = 0;
                        if (!this.cancelIt) {
                            conditions = thisSession.waitForCondition(28, this.sshCommandTimeout);
                        }
                        if (this.cancelIt) {
                            Tools.info("SSH cancel");
                            throw new IOException("Canceled while waiting for data from peer.");
                        }
                        if (conditions & true) {
                            Tools.appWarning("SSH timeout: " + command);
                            Tools.progressIndicatorFailed(SSH.this.host.getName(), "SSH timeout: " + command.replaceAll("@DMCSUDO@", ""));
                            throw new IOException("Timeout while waiting for data from peer.");
                        }
                        if ((conditions & 0x10) != 0 && (conditions & 0xC) == 0) break;
                    }
                    StringBuilder output = new StringBuilder("");
                    while (stdout.available() > 0 && !this.cancelIt) {
                        int len = stdout.read(buff);
                        if (len <= 0) continue;
                        String buffString = new String(buff, 0, len, "UTF-8");
                        output.append(buffString);
                        if (!outputVisible) continue;
                        SSH.this.host.getTerminalPanel().addContent(buffString);
                    }
                    if (output.indexOf(SSH.SUDO_PROMPT) >= 0) {
                        if (sudoPwd == null) {
                            cancelSudo = SSH.this.enterSudoPassword();
                        }
                        String pwd = SSH.this.host.getSudoPassword() + "\n";
                        stdin.write(pwd.getBytes());
                        skipNextLine = true;
                        continue;
                    }
                    if (output.indexOf(SSH.SUDO_FAIL) >= 0) {
                        SSH.this.host.setSudoPassword(null);
                    } else if (skipNextLine) {
                        skipNextLine = false;
                        if (output.charAt(0) == '\r' && output.charAt(1) == '\n') {
                            output.delete(0, 2);
                            if (output.length() == 0) continue;
                        }
                    }
                    StringBuilder errOutput = new StringBuilder("");
                    while (stderr.available() > 0 && !this.cancelIt) {
                        int len = stderr.read(buff);
                        if (len <= 0) continue;
                        String buffString = new String(buff, 0, len, "UTF-8");
                        output.append(buffString);
                        if (!outputVisible) continue;
                        SSH.this.host.getTerminalPanel().addContentErr(buffString);
                    }
                    res.append((CharSequence)errOutput);
                    if (this.newOutputCallback != null && !this.cancelIt) {
                        Tools.debug(this, "output" + exitCode + ": " + SSH.this.host.getName() + ": " + output.toString(), 2);
                        this.newOutputCallback.output(output.toString());
                    }
                    if (this.cancelIt) {
                        return new SSHOutput("", 130);
                    }
                    if (this.newOutputCallback != null) continue;
                    res.append((CharSequence)output);
                }
                if (outputVisible) {
                    SSH.this.host.getTerminalPanel().nextCommand();
                }
                thisSession.waitForCondition(32, 10000L);
                Integer ec = thisSession.getExitStatus();
                if (ec != null) {
                    exitCode = ec;
                }
                thisSession.close();
                this.sess = null;
            }
            catch (IOException e) {
                Tools.appWarning(SSH.this.host.getName() + ":" + e.getMessage() + ":" + command);
                exitCode = 255;
                this.cancel();
            }
            String outputString = res.toString();
            Tools.debug(this, "output" + exitCode + ": " + SSH.this.host.getName() + ": " + outputString, 2);
            return new SSHOutput(outputString, exitCode);
        }

        public void cancel() {
            this.cancelIt = true;
            this.mSessionLock.lock();
            Session thisSession = this.sess;
            this.sess = null;
            this.mSessionLock.unlock();
            if (thisSession != null) {
                thisSession.close();
            }
        }

        ExecCommandThread(String command, ExecCallback execCallback, NewOutputCallback newOutputCallback, boolean outputVisible, boolean commandVisible, int sshCommandTimeout) throws IOException {
            this.command = command;
            Tools.debug(this, "command: " + command, 1);
            this.execCallback = execCallback;
            this.newOutputCallback = newOutputCallback;
            this.outputVisible = outputVisible;
            this.commandVisible = commandVisible;
            this.sshCommandTimeout = sshCommandTimeout;
            if (command.length() > 9 && command.substring(0, 9).equals("NOOUTPUT:")) {
                this.outputVisible = false;
                this.command = command.substring(9, command.length());
            } else if (command.length() > 7 && command.substring(0, 7).equals("OUTPUT:")) {
                this.outputVisible = true;
                this.command = command.substring(7, command.length());
            } else {
                this.outputVisible = outputVisible;
                this.command = command;
            }
        }

        @Override
        public void run() {
            if (SSH.this.reconnect()) {
                SSH.this.mConnectionLock.lock();
                if (SSH.this.connection == null) {
                    SSH.this.mConnectionLock.unlock();
                    if (this.execCallback != null) {
                        this.execCallback.doneError("not connected", 139);
                    }
                } else {
                    MyConnection conn = SSH.this.connection;
                    SSH.this.mConnectionLock.unlock();
                    this.exec(conn);
                }
            }
        }

        private void exec(final MyConnection conn) {
            String[] commands = this.command.split(";;;");
            StringBuilder ans = new StringBuilder("");
            for (int i = 0; i < commands.length; ++i) {
                final Boolean[] cancelTimeout = new Boolean[]{false};
                Thread tt = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Tools.sleep(Tools.getDefaultInt("SSH.ConnectTimeout"));
                        if (!cancelTimeout[0].booleanValue()) {
                            Tools.debug(this, SSH.this.host.getName() + ": open ssh session: timeout.", 1);
                            cancelTimeout[0] = true;
                            conn.dmcCancel();
                        }
                    }
                });
                tt.start();
                try {
                    Session newSession = conn.openSession();
                    this.mSessionLock.lock();
                    this.sess = newSession;
                    this.mSessionLock.unlock();
                    if (cancelTimeout[0].booleanValue()) {
                        throw new IOException("open session failed");
                    }
                    cancelTimeout[0] = true;
                }
                catch (IOException e) {
                    SSH.this.mConnectionLock.lock();
                    SSH.this.connection = null;
                    SSH.this.mConnectionLock.unlock();
                    if (this.execCallback == null) break;
                    this.execCallback.doneError("could not open session", 45);
                    break;
                }
                commands[i].trim();
                if (this.commandVisible && this.outputVisible) {
                    String consoleCommand = SSH.this.host.replaceVars(commands[i], true);
                    SSH.this.host.getTerminalPanel().addCommand(consoleCommand.replaceAll("@DMCSUDO@", " "));
                }
                SSHOutput ret = this.execOneCommand(commands[i], this.outputVisible);
                ans.append(ret.getOutput());
                int exitCode = ret.getExitCode();
                if (exitCode == 0) continue;
                if (this.execCallback != null) {
                    if (this.outputVisible) {
                        Tools.getGUIData().expandTerminalSplitPane(0);
                    }
                    this.execCallback.doneError(ans.toString(), exitCode);
                }
                return;
            }
            if (this.execCallback != null) {
                this.execCallback.done(ans.toString());
            }
        }
    }
}

