/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.widget;

import java.util.Map;
import lcmc.data.AccessMode;
import lcmc.gui.widget.Checkbox;
import lcmc.gui.widget.ComboBox;
import lcmc.gui.widget.Label;
import lcmc.gui.widget.Passwdfield;
import lcmc.gui.widget.RadioGroup;
import lcmc.gui.widget.Textfield;
import lcmc.gui.widget.TextfieldWithUnit;
import lcmc.gui.widget.Widget;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;
import lcmc.utilities.Unit;

public final class WidgetFactory {
    private WidgetFactory() {
    }

    public static Widget createInstance(Widget.Type type, String selectedValue, Object[] items, String regexp, int width, Map<String, String> abbreviations, AccessMode enableAccessMode, MyButton fieldButton) {
        return WidgetFactory.createInstance(type, selectedValue, items, null, regexp, width, abbreviations, enableAccessMode, fieldButton);
    }

    public static Widget createInstance(Widget.Type type, String selectedValue, Object[] items, Unit[] units, String regexp, int width, Map<String, String> abbreviations, AccessMode enableAccessMode, MyButton fieldButton) {
        if (type != null && type != Widget.Type.TEXTFIELDWITHUNIT && units != null) {
            Tools.appError("wrong type with units: " + (Object)((Object)type));
        }
        if (type == null) {
            type = units != null ? Widget.Type.TEXTFIELDWITHUNIT : (items == null || items.length == 0 ? Widget.Type.TEXTFIELD : (items.length == 2 ? (items[0] != null && items[0].toString().equalsIgnoreCase(Tools.getString("Boolean.True")) && items[1] != null && items[1].toString().equalsIgnoreCase(Tools.getString("Boolean.False")) ? Widget.Type.CHECKBOX : Widget.Type.COMBOBOX) : Widget.Type.COMBOBOX));
        }
        switch (type) {
            case LABELFIELD: {
                return new Label(selectedValue, regexp, width, enableAccessMode, fieldButton);
            }
            case COMBOBOX: {
                return new ComboBox(selectedValue, items, regexp, width, abbreviations, enableAccessMode, fieldButton);
            }
            case PASSWDFIELD: {
                return new Passwdfield(selectedValue, regexp, width, enableAccessMode, fieldButton);
            }
            case TEXTFIELD: {
                return new Textfield(selectedValue, regexp, width, abbreviations, enableAccessMode, fieldButton);
            }
            case TEXTFIELDWITHUNIT: {
                return new TextfieldWithUnit(selectedValue, units, regexp, width, abbreviations, enableAccessMode, fieldButton);
            }
            case RADIOGROUP: {
                return new RadioGroup(selectedValue, items, regexp, width, enableAccessMode, fieldButton);
            }
            case CHECKBOX: {
                return new Checkbox(selectedValue, items, regexp, width, enableAccessMode, fieldButton);
            }
        }
        Tools.appError("unknown type: " + (Object)((Object)type));
        return null;
    }
}

