/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.widget;

import java.awt.Color;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import lcmc.data.AccessMode;
import lcmc.gui.widget.Widget;
import lcmc.utilities.MyButton;
import lcmc.utilities.PatternDocument;
import lcmc.utilities.WidgetListener;

public class Textfield
extends Widget {
    private static final long serialVersionUID = 1L;

    public Textfield(String selectedValue, String regexp, int width, Map<String, String> abbreviations, AccessMode enableAccessMode, MyButton fieldButton) {
        super(regexp, enableAccessMode, fieldButton);
        this.addComponent(this.getTextField(selectedValue, regexp, abbreviations), width);
    }

    private JComponent getTextField(String value, String regexp, Map<String, String> abbreviations) {
        Widget.MTextField tf = regexp == null ? new Widget.MTextField(value) : new Widget.MTextField(new PatternDocument(regexp, abbreviations), value, 0);
        return tf;
    }

    @Override
    public String getStringValue() {
        Object o = this.getValue();
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    @Override
    protected Object getValueInternal() {
        String value = ((Widget.MTextField)this.getComponent()).getText();
        if (NOTHING_SELECTED_DISPLAY.equals(value)) {
            return null;
        }
        return value;
    }

    @Override
    boolean isEditable() {
        return true;
    }

    @Override
    protected void setValueAndWait0(Object item) {
        ((Widget.MTextField)this.getComponent()).setText((String)item);
    }

    @Override
    public Document getDocument() {
        return ((Widget.MTextField)this.getComponent()).getDocument();
    }

    @Override
    public void addListeners(WidgetListener wl) {
        this.getWidgetListeners().add(wl);
        this.addDocumentListener(this.getDocument(), wl);
    }

    @Override
    protected void setComponentBackground(Color backgroundColor, Color compColor) {
        this.getComponent().setBackground(compColor);
    }

    @Override
    public void requestFocus() {
        ((Widget.MTextField)this.getComponent()).requestFocus();
    }

    @Override
    void selectAll() {
        ((Widget.MTextField)this.getComponent()).selectAll();
    }

    @Override
    public void setBackgroundColor(final Color bg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Textfield.this.setBackground(bg);
                Textfield.this.getComponent().setBackground(bg);
            }
        });
    }

    @Override
    Object getItemAt(int i) {
        return this.getComponent();
    }

    @Override
    public void cleanup() {
        this.getWidgetListeners().clear();
        AbstractDocument d = (AbstractDocument)this.getDocument();
        for (DocumentListener dl : d.getDocumentListeners()) {
            d.removeDocumentListener(dl);
        }
    }
}

