/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.widget;

import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import lcmc.data.AccessMode;
import lcmc.gui.widget.Widget;
import lcmc.utilities.MyButton;
import lcmc.utilities.WidgetListener;

public final class Label
extends Widget {
    private static final long serialVersionUID = 1L;

    public Label(String selectedValue, String regexp, int width, AccessMode enableAccessMode, MyButton fieldButton) {
        super(regexp, enableAccessMode, fieldButton);
        this.addComponent(this.getLabelField(selectedValue), width);
    }

    private JComponent getLabelField(String value) {
        return new JLabel(value);
    }

    @Override
    public String getStringValue() {
        Object o = this.getValue();
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    @Override
    protected Object getValueInternal() {
        return ((JLabel)this.getComponent()).getText();
    }

    @Override
    boolean isEditable() {
        return false;
    }

    @Override
    protected void setValueAndWait0(Object item) {
        ((JLabel)this.getComponent()).setText((String)item);
    }

    @Override
    public Document getDocument() {
        return null;
    }

    @Override
    public void addListeners(WidgetListener wl) {
        this.getWidgetListeners().add(wl);
    }

    @Override
    protected void setComponentBackground(Color backgroundColor, Color compColor) {
        this.getComponent().setBackground(backgroundColor);
    }

    @Override
    public void setBackgroundColor(final Color bg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Label.this.setBackground(bg);
                Label.this.getComponent().setBackground(bg);
            }
        });
    }

    @Override
    Object getItemAt(int i) {
        return this.getComponent();
    }

    @Override
    public void cleanup() {
        this.getWidgetListeners().clear();
    }
}

