/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import lcmc.Exceptions;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.VMSXML;
import lcmc.data.resources.Resource;
import lcmc.gui.Browser;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.HostBrowser;
import lcmc.gui.SpringUtilities;
import lcmc.gui.resources.BlockDevInfo;
import lcmc.gui.resources.EditableInfo;
import lcmc.gui.resources.Info;
import lcmc.gui.resources.NetInfo;
import lcmc.gui.resources.StringInfo;
import lcmc.gui.resources.VMSDiskInfo;
import lcmc.gui.resources.VMSFilesystemInfo;
import lcmc.gui.resources.VMSGraphicsInfo;
import lcmc.gui.resources.VMSHardwareInfo;
import lcmc.gui.resources.VMSInputDevInfo;
import lcmc.gui.resources.VMSInterfaceInfo;
import lcmc.gui.resources.VMSParallelInfo;
import lcmc.gui.resources.VMSSerialInfo;
import lcmc.gui.resources.VMSSoundInfo;
import lcmc.gui.resources.VMSVideoInfo;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.MyButton;
import lcmc.utilities.MyMenu;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.Tools;
import lcmc.utilities.Unit;
import lcmc.utilities.UpdatableItem;
import lcmc.utilities.VIRSH;
import lcmc.utilities.WidgetListener;
import org.w3c.dom.Node;

public final class VMSVirtualDomainInfo
extends EditableInfo {
    private JComponent infoPanel = null;
    private String uuid;
    private String definedOnString = "";
    private String runningOnString = "";
    private Color rowColor = Browser.PANEL_BACKGROUND;
    private final ReadWriteLock mTransitionLock = new ReentrantReadWriteLock();
    private final Lock mTransitionReadLock = this.mTransitionLock.readLock();
    private final Lock mTransitionWriteLock = this.mTransitionLock.writeLock();
    private final Set<String> starting = new HashSet<String>();
    private final Set<String> shuttingdown = new HashSet<String>();
    private final Set<String> suspending = new HashSet<String>();
    private final Set<String> resuming = new HashSet<String>();
    private final StringBuilder progress = new StringBuilder("-");
    private final Lock mDiskToInfoLock = new ReentrantLock();
    private final Map<String, VMSDiskInfo> diskToInfo = new HashMap<String, VMSDiskInfo>();
    private volatile Map<String, VMSDiskInfo> diskKeyToInfo = new HashMap<String, VMSDiskInfo>();
    private final Lock mFilesystemToInfoLock = new ReentrantLock();
    private final Map<String, VMSFilesystemInfo> filesystemToInfo = new HashMap<String, VMSFilesystemInfo>();
    private volatile Map<String, VMSFilesystemInfo> filesystemKeyToInfo = new HashMap<String, VMSFilesystemInfo>();
    private final Lock mInterfaceToInfoLock = new ReentrantLock();
    private final Map<String, VMSInterfaceInfo> interfaceToInfo = new HashMap<String, VMSInterfaceInfo>();
    private volatile Map<String, VMSInterfaceInfo> interfaceKeyToInfo = new HashMap<String, VMSInterfaceInfo>();
    private final Lock mInputDevToInfoLock = new ReentrantLock();
    private final Map<String, VMSInputDevInfo> inputDevToInfo = new HashMap<String, VMSInputDevInfo>();
    private volatile Map<String, VMSInputDevInfo> inputDevKeyToInfo = new HashMap<String, VMSInputDevInfo>();
    private final Lock mGraphicsToInfoLock = new ReentrantLock();
    private final Map<String, VMSGraphicsInfo> graphicsToInfo = new HashMap<String, VMSGraphicsInfo>();
    private volatile Map<String, VMSGraphicsInfo> graphicsKeyToInfo = new HashMap<String, VMSGraphicsInfo>();
    private final Lock mSoundToInfoLock = new ReentrantLock();
    private final Map<String, VMSSoundInfo> soundToInfo = new HashMap<String, VMSSoundInfo>();
    private volatile Map<String, VMSSoundInfo> soundKeyToInfo = new HashMap<String, VMSSoundInfo>();
    private final Lock mSerialToInfoLock = new ReentrantLock();
    private final Map<String, VMSSerialInfo> serialToInfo = new HashMap<String, VMSSerialInfo>();
    private volatile Map<String, VMSSerialInfo> serialKeyToInfo = new HashMap<String, VMSSerialInfo>();
    private final Lock mParallelToInfoLock = new ReentrantLock();
    private final Map<String, VMSParallelInfo> parallelToInfo = new HashMap<String, VMSParallelInfo>();
    private final String preferredEmulator;
    private volatile Map<String, VMSParallelInfo> parallelKeyToInfo = new HashMap<String, VMSParallelInfo>();
    private final Lock mVideoToInfoLock = new ReentrantLock();
    private final Map<String, VMSVideoInfo> videoToInfo = new HashMap<String, VMSVideoInfo>();
    private final Map<String, MyButton> hostButtons = new HashMap<String, MyButton>();
    private boolean usedByCRM = false;
    private volatile Map<String, VMSVideoInfo> videoKeyToInfo = new HashMap<String, VMSVideoInfo>();
    private volatile String prevType = null;
    private final String[] autostartPossibleValues;
    private static final int ACTION_TIMEOUT = 20;
    private static final String VIRSH_OPTION_KVM = "";
    private static final String VIRSH_OPTION_XEN = "-c 'xen:///'";
    private static final String VIRSH_OPTION_LXC = "-c 'lxc:///'";
    private static final String VIRSH_OPTION_VBOX = "-c 'vbox:///session'";
    private static final String VIRSH_OPTION_OPENVZ = "-c 'openvz:///system'";
    private static final String VIRSH_OPTION_UML = "-c 'uml:///system'";
    static final String DOMAIN_TYPE_KVM = "kvm";
    private static final String DOMAIN_TYPE_XEN = "xen";
    private static final String DOMAIN_TYPE_LXC = "lxc";
    private static final String DOMAIN_TYPE_VBOX = "vbox";
    private static final String DOMAIN_TYPE_OPENVZ = "openvz";
    private static final String DOMAIN_TYPE_UML = "uml";
    private static final String[] VIRSH_OPTIONS = new String[]{"", "-c 'xen:///'", "-c 'lxc:///'", "-c 'vbox:///session'", "-c 'openvz:///system'", "-c 'uml:///system'"};
    private static final Set<String> NEED_DISPLAY = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("kvm", "xen", "vbox")));
    private static final Set<String> NEED_CONSOLE = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("lxc", "openvz", "uml")));
    private static final Set<String> NEED_FILESYSTEM = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("lxc", "openvz", "vbox")));
    private static final String[] VM_PARAMETERS = new String[]{"domain-type", "name", "virsh-options", "emulator", "vcpu", "currentMemory", "memory", "bootloader", "boot", "boot2", "loader", "autostart", "type", "init", "arch", "machine", "acpi", "apic", "pae", "hap", "offset", "match", "model", "vendor", "sockets", "cores", "threads", "policy", "features", "on_poweroff", "on_reboot", "on_crash"};
    private static final Set<String> IS_ADVANCED = new HashSet<String>(Arrays.asList("acpi", "apic", "pae", "hap", "match", "model", "vendor", "sockets", "cores", "threads", "policy", "features", "on_poweroff", "on_reboot", "on_crash"));
    private static final Map<String, String> SECTION_MAP = new HashMap<String, String>();
    private static final Map<String, String> SHORTNAME_MAP = new HashMap<String, String>();
    private static final Map<String, String> DEFAULTS_MAP = new HashMap<String, String>();
    private static final Map<String, String> PREFERRED_MAP = new HashMap<String, String>();
    private static final Map<String, Widget.Type> FIELD_TYPES = new HashMap<String, Widget.Type>();
    private static final Map<String, Object[]> POSSIBLE_VALUES = new HashMap<String, Object[]>();
    private static final List<String> IS_INTEGER = new ArrayList<String>();
    private static final Map<String, String> REQUIRED_VERSION = new HashMap<String, String>();
    private static final Map<String, Boolean> HAS_UNIT_PREFIX = new HashMap<String, Boolean>();
    private static final Map<String, String> DEFAULT_UNIT = new HashMap<String, String>();
    private static final ImageIcon BACK_ICON = Tools.createImageIcon(Tools.getDefault("BackIcon"));
    static final ImageIcon VNC_ICON = Tools.createImageIcon(Tools.getDefault("VMS.VNC.IconLarge"));
    static final ImageIcon VNC_ICON_SMALL = Tools.createImageIcon(Tools.getDefault("VMS.VNC.IconSmall"));
    static final ImageIcon PAUSE_ICON = Tools.createImageIcon(Tools.getDefault("VMS.Pause.IconLarge"));
    private static final ImageIcon RESUME_ICON = Tools.createImageIcon(Tools.getDefault("VMS.Resume.IconLarge"));
    private static final ImageIcon SHUTDOWN_ICON = Tools.createImageIcon(Tools.getDefault("VMS.Shutdown.IconLarge"));
    private static final ImageIcon REBOOT_ICON = Tools.createImageIcon(Tools.getDefault("VMS.Reboot.IconLarge"));
    private static final ImageIcon DESTROY_ICON = Tools.createImageIcon(Tools.getDefault("VMS.Destroy.IconLarge"));
    static final String HEADER_TABLE = "header";
    static final String DISK_TABLE = "disks";
    static final String FILESYSTEM_TABLE = "filesystems";
    static final String INTERFACES_TABLE = "interfaces";
    static final String INPUTDEVS_TABLE = "inputdevs";
    static final String GRAPHICS_TABLE = "graphics";
    static final String SOUND_TABLE = "sound";
    static final String SERIAL_TABLE = "serial";
    static final String PARALLEL_TABLE = "parallel";
    static final String VIDEO_TABLE = "video";
    private static final String DEFINED_ON_HOST_TRUE = "True";
    private static final String DEFINED_ON_HOST_FALSE = "False";
    private static final String WIZARD_PREFIX = "wizard:";
    private static final String VIRTUAL_SYSTEM_STRING = Tools.getString("VMSVirtualDomainInfo.Section.VirtualSystem");
    private static final String VIRTUAL_SYSTEM_FEATURES = Tools.getString("VMSVirtualDomainInfo.Section.Features");
    private static final String VIRTUAL_SYSTEM_OPTIONS = Tools.getString("VMSVirtualDomainInfo.Section.Options");
    private static final String CPU_MATCH_OPTIONS = Tools.getString("VMSVirtualDomainInfo.Section.CPUMatch");
    static final String NOT_APPLIED = "not applied yet";
    static final String NO_VM_STATUS_STRING = "VM status is not available";
    private static final Map<Integer, Integer> HEADER_DEFAULT_WIDTHS = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> DISK_DEFAULT_WIDTHS = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> FILESYSTEM_DEFAULT_WIDTHS = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> INTERFACES_DEFAULT_WIDTHS = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> INPUTDEVS_DEFAULT_WIDTHS = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> GRAPHICS_DEFAULT_WIDTHS = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> SOUND_DEFAULT_WIDTHS = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> SERIAL_DEFAULT_WIDTHS = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> PARALLEL_DEFAULT_WIDTHS = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> VIDEO_DEFAULT_WIDTHS = new HashMap<Integer, Integer>();
    private static final String TYPE_HVM = "hvm";
    private static final String TYPE_LINUX = "linux";
    private static final String TYPE_EXE = "exe";
    private static final String TYPE_UML = "uml";
    private static final int CONTROL_BUTTON_WIDTH = 80;
    static final String IS_USED_BY_CRM_STRING = "it is used by cluster manager";
    private final Map<String, Widget> definedOnHostComboBoxHash = new HashMap<String, Widget>();

    public VMSVirtualDomainInfo(String name, Browser browser) {
        super(name, browser);
        Host firstHost = this.getBrowser().getClusterHosts()[0];
        this.preferredEmulator = firstHost.getDistString("KVM.emulator");
        ArrayList<String> hostsList = new ArrayList<String>();
        hostsList.add(null);
        for (Host h : this.getBrowser().getClusterHosts()) {
            hostsList.add(h.getName());
        }
        this.autostartPossibleValues = hostsList.toArray(new String[hostsList.size()]);
        this.setResource(new Resource(name));
    }

    @Override
    public ClusterBrowser getBrowser() {
        return (ClusterBrowser)super.getBrowser();
    }

    @Override
    public String toString() {
        if (this.getResource().isNew()) {
            return "new domain...";
        }
        return this.getName();
    }

    protected String getDomainName() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateDiskNodes() {
        DefaultMutableTreeNode thisNode = this.getNode();
        if (thisNode == null) {
            return false;
        }
        Map<String, VMSXML.DiskData> disks = this.getDisks();
        ArrayList<String> diskNames = new ArrayList<String>();
        if (disks != null) {
            for (String d : disks.keySet()) {
                diskNames.add(d);
            }
        }
        ArrayList<DefaultMutableTreeNode> nodesToRemove = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> e = thisNode.children();
        boolean nodeChanged = false;
        while (e.hasMoreElements()) {
            VMSDiskInfo vmsdi;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!(node.getUserObject() instanceof VMSDiskInfo) || (vmsdi = (VMSDiskInfo)node.getUserObject()).getResource().isNew()) continue;
            if (diskNames.contains(vmsdi.getName())) {
                diskNames.remove(vmsdi.getName());
                this.mDiskToInfoLock.lock();
                try {
                    this.diskToInfo.put(vmsdi.getName(), vmsdi);
                }
                finally {
                    this.mDiskToInfoLock.unlock();
                }
                vmsdi.updateParameters();
                continue;
            }
            this.mDiskToInfoLock.lock();
            try {
                this.diskToInfo.remove(vmsdi.getName());
            }
            finally {
                this.mDiskToInfoLock.unlock();
            }
            vmsdi.setNode(null);
            nodesToRemove.add(node);
            nodeChanged = true;
        }
        for (DefaultMutableTreeNode node : nodesToRemove) {
            node.removeFromParent();
        }
        for (String disk : diskNames) {
            Enumeration<TreeNode> eee = thisNode.children();
            int i = 0;
            while (eee.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)eee.nextElement();
                if (!(node.getUserObject() instanceof VMSDiskInfo)) continue;
                VMSDiskInfo v = (VMSDiskInfo)node.getUserObject();
                String n = v.getName();
                if (n != null && disk.compareTo(n) < 0) break;
                ++i;
            }
            VMSDiskInfo vmsdi = new VMSDiskInfo(disk, this.getBrowser(), this);
            this.mDiskToInfoLock.lock();
            try {
                this.diskToInfo.put(disk, vmsdi);
            }
            finally {
                this.mDiskToInfoLock.unlock();
            }
            vmsdi.updateParameters();
            DefaultMutableTreeNode resource = new DefaultMutableTreeNode(vmsdi);
            this.getBrowser().setNode(resource);
            thisNode.insert(resource, i);
            nodeChanged = true;
        }
        return nodeChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateFilesystemNodes() {
        DefaultMutableTreeNode thisNode = this.getNode();
        if (thisNode == null) {
            return false;
        }
        Map<String, VMSXML.FilesystemData> filesystems = this.getFilesystems();
        ArrayList<String> filesystemNames = new ArrayList<String>();
        if (filesystems != null) {
            for (String d : filesystems.keySet()) {
                filesystemNames.add(d);
            }
        }
        ArrayList<DefaultMutableTreeNode> nodesToRemove = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> e = thisNode.children();
        boolean nodeChanged = false;
        while (e.hasMoreElements()) {
            VMSFilesystemInfo vmsdi;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!(node.getUserObject() instanceof VMSFilesystemInfo) || (vmsdi = (VMSFilesystemInfo)node.getUserObject()).getResource().isNew()) continue;
            if (filesystemNames.contains(vmsdi.getName())) {
                filesystemNames.remove(vmsdi.getName());
                this.mFilesystemToInfoLock.lock();
                try {
                    this.filesystemToInfo.put(vmsdi.getName(), vmsdi);
                }
                finally {
                    this.mFilesystemToInfoLock.unlock();
                }
                vmsdi.updateParameters();
                continue;
            }
            this.mFilesystemToInfoLock.lock();
            try {
                this.filesystemToInfo.remove(vmsdi.getName());
            }
            finally {
                this.mFilesystemToInfoLock.unlock();
            }
            vmsdi.setNode(null);
            nodesToRemove.add(node);
            nodeChanged = true;
        }
        for (DefaultMutableTreeNode node : nodesToRemove) {
            node.removeFromParent();
        }
        for (String filesystem : filesystemNames) {
            Enumeration<TreeNode> eee = thisNode.children();
            int i = 0;
            while (eee.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)eee.nextElement();
                if (!(node.getUserObject() instanceof VMSFilesystemInfo)) continue;
                VMSFilesystemInfo v = (VMSFilesystemInfo)node.getUserObject();
                String n = v.getName();
                if (n != null && filesystem.compareTo(n) < 0) break;
                ++i;
            }
            VMSFilesystemInfo vmsdi = new VMSFilesystemInfo(filesystem, this.getBrowser(), this);
            this.mFilesystemToInfoLock.lock();
            try {
                this.filesystemToInfo.put(filesystem, vmsdi);
            }
            finally {
                this.mFilesystemToInfoLock.unlock();
            }
            vmsdi.updateParameters();
            DefaultMutableTreeNode resource = new DefaultMutableTreeNode(vmsdi);
            this.getBrowser().setNode(resource);
            thisNode.insert(resource, i);
            nodeChanged = true;
        }
        return nodeChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateInterfaceNodes() {
        DefaultMutableTreeNode thisNode = this.getNode();
        if (thisNode == null) {
            return false;
        }
        Map<String, VMSXML.InterfaceData> interfaces = this.getInterfaces();
        ArrayList<String> interfaceNames = new ArrayList<String>();
        if (interfaces != null) {
            for (String i : interfaces.keySet()) {
                interfaceNames.add(i);
            }
        }
        ArrayList<DefaultMutableTreeNode> nodesToRemove = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> e = thisNode.children();
        boolean nodeChanged = false;
        VMSInterfaceInfo emptySlot = null;
        while (e.hasMoreElements()) {
            VMSInterfaceInfo vmsii;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!(node.getUserObject() instanceof VMSInterfaceInfo) || (vmsii = (VMSInterfaceInfo)node.getUserObject()).getResource().isNew()) continue;
            if ("generate".equals(vmsii.getName())) {
                emptySlot = vmsii;
                continue;
            }
            if (interfaceNames.contains(vmsii.getName())) {
                interfaceNames.remove(vmsii.getName());
                vmsii.updateParameters();
                continue;
            }
            this.mInterfaceToInfoLock.lock();
            try {
                this.interfaceToInfo.remove(vmsii.getName());
            }
            finally {
                this.mInterfaceToInfoLock.unlock();
            }
            vmsii.setNode(null);
            nodesToRemove.add(node);
            nodeChanged = true;
        }
        for (DefaultMutableTreeNode node : nodesToRemove) {
            node.removeFromParent();
        }
        for (String interf : interfaceNames) {
            VMSInterfaceInfo vmsii;
            if (emptySlot == null) {
                Enumeration<TreeNode> eee = thisNode.children();
                int i = 0;
                while (eee.hasMoreElements()) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)eee.nextElement();
                    if (!(node.getUserObject() instanceof VMSInterfaceInfo)) {
                        if (!(node.getUserObject() instanceof VMSDiskInfo) && !(node.getUserObject() instanceof VMSFilesystemInfo)) continue;
                        ++i;
                        continue;
                    }
                    VMSInterfaceInfo v = (VMSInterfaceInfo)node.getUserObject();
                    String n = v.getName();
                    if (n != null && interf.compareTo(n) < 0) break;
                    ++i;
                }
                vmsii = new VMSInterfaceInfo(interf, this.getBrowser(), this);
                DefaultMutableTreeNode resource = new DefaultMutableTreeNode(vmsii);
                this.getBrowser().setNode(resource);
                thisNode.insert(resource, i);
                nodeChanged = true;
            } else {
                vmsii = emptySlot;
                vmsii.setName(interf);
                emptySlot = null;
            }
            this.mInterfaceToInfoLock.lock();
            try {
                this.interfaceToInfo.put(interf, vmsii);
            }
            finally {
                this.mInterfaceToInfoLock.unlock();
            }
            vmsii.updateParameters();
        }
        return nodeChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateInputDevNodes() {
        DefaultMutableTreeNode thisNode = this.getNode();
        if (thisNode == null) {
            return false;
        }
        Map<String, VMSXML.InputDevData> inputDevs = this.getInputDevs();
        ArrayList<String> inputDevNames = new ArrayList<String>();
        if (inputDevs != null) {
            for (String d : inputDevs.keySet()) {
                inputDevNames.add(d);
            }
        }
        ArrayList<DefaultMutableTreeNode> nodesToRemove = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> e = thisNode.children();
        boolean nodeChanged = false;
        while (e.hasMoreElements()) {
            VMSInputDevInfo vmsid;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!(node.getUserObject() instanceof VMSInputDevInfo) || (vmsid = (VMSInputDevInfo)node.getUserObject()).getResource().isNew()) continue;
            if (inputDevNames.contains(vmsid.getName())) {
                inputDevNames.remove(vmsid.getName());
                vmsid.updateParameters();
                continue;
            }
            this.mInputDevToInfoLock.lock();
            try {
                this.inputDevToInfo.remove(vmsid.getName());
            }
            finally {
                this.mInputDevToInfoLock.unlock();
            }
            vmsid.setNode(null);
            nodesToRemove.add(node);
            nodeChanged = true;
        }
        for (DefaultMutableTreeNode node : nodesToRemove) {
            node.removeFromParent();
        }
        for (String inputDev : inputDevNames) {
            VMSXML.InputDevData data = inputDevs.get(inputDev);
            Enumeration<TreeNode> eee = thisNode.children();
            int i = 0;
            while (eee.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)eee.nextElement();
                if (!(node.getUserObject() instanceof VMSInputDevInfo)) {
                    if (!(node.getUserObject() instanceof VMSDiskInfo) && !(node.getUserObject() instanceof VMSFilesystemInfo) && !(node.getUserObject() instanceof VMSInterfaceInfo)) continue;
                    ++i;
                    continue;
                }
                VMSInputDevInfo v = (VMSInputDevInfo)node.getUserObject();
                String n = v.getName();
                if (n != null && inputDev.compareTo(n) < 0) break;
                ++i;
            }
            VMSInputDevInfo vmsid = new VMSInputDevInfo(inputDev, this.getBrowser(), this);
            DefaultMutableTreeNode resource = new DefaultMutableTreeNode(vmsid);
            this.getBrowser().setNode(resource);
            thisNode.insert(resource, i);
            nodeChanged = true;
            this.mInputDevToInfoLock.lock();
            try {
                this.inputDevToInfo.put(inputDev, vmsid);
            }
            finally {
                this.mInputDevToInfoLock.unlock();
            }
            vmsid.updateParameters();
        }
        int i = 0;
        for (int j = 0; j < thisNode.getChildCount(); ++j) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)thisNode.getChildAt(j);
            VMSHardwareInfo v = (VMSHardwareInfo)node.getUserObject();
            String n = v.getName();
            if (i > 0) {
                DefaultMutableTreeNode prev = (DefaultMutableTreeNode)thisNode.getChildAt(j - 1);
                VMSHardwareInfo prevI = (VMSHardwareInfo)prev.getUserObject();
                if (prevI.getClass().getName().equals(v.getClass().getName())) {
                    String prevN = prevI.getName();
                    if (!prevI.getResource().isNew() && !v.getResource().isNew() && prevN != null && prevN.compareTo(n) > 0) {
                        thisNode.remove(j);
                        thisNode.insert(node, j - 1);
                    }
                } else {
                    i = 0;
                }
            }
            ++i;
        }
        return nodeChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateGraphicsNodes() {
        DefaultMutableTreeNode thisNode = this.getNode();
        if (thisNode == null) {
            return false;
        }
        Map<String, VMSXML.GraphicsData> graphicDisplays = this.getGraphicDisplays();
        ArrayList<String> graphicsNames = new ArrayList<String>();
        if (graphicDisplays != null) {
            for (String d : graphicDisplays.keySet()) {
                graphicsNames.add(d);
            }
        }
        ArrayList<DefaultMutableTreeNode> nodesToRemove = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> e = thisNode.children();
        boolean nodeChanged = false;
        while (e.hasMoreElements()) {
            VMSGraphicsInfo vmsgi;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!(node.getUserObject() instanceof VMSGraphicsInfo) || (vmsgi = (VMSGraphicsInfo)node.getUserObject()).getResource().isNew()) continue;
            if (graphicsNames.contains(vmsgi.getName())) {
                graphicsNames.remove(vmsgi.getName());
                this.mGraphicsToInfoLock.lock();
                try {
                    this.graphicsToInfo.put(vmsgi.getName(), vmsgi);
                }
                finally {
                    this.mGraphicsToInfoLock.unlock();
                }
                vmsgi.updateParameters();
                continue;
            }
            this.mGraphicsToInfoLock.lock();
            try {
                this.graphicsToInfo.remove(vmsgi.getName());
            }
            finally {
                this.mGraphicsToInfoLock.unlock();
            }
            vmsgi.setNode(null);
            nodesToRemove.add(node);
            nodeChanged = true;
        }
        for (DefaultMutableTreeNode node : nodesToRemove) {
            node.removeFromParent();
        }
        for (String graphicDisplay : graphicsNames) {
            VMSXML.GraphicsData data = graphicDisplays.get(graphicDisplay);
            Enumeration<TreeNode> eee = thisNode.children();
            int i = 0;
            while (eee.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)eee.nextElement();
                if (!(node.getUserObject() instanceof VMSGraphicsInfo)) {
                    if (!(node.getUserObject() instanceof VMSDiskInfo) && !(node.getUserObject() instanceof VMSFilesystemInfo) && !(node.getUserObject() instanceof VMSInterfaceInfo) && !(node.getUserObject() instanceof VMSInputDevInfo)) continue;
                    ++i;
                    continue;
                }
                VMSGraphicsInfo v = (VMSGraphicsInfo)node.getUserObject();
                String n = v.getName();
                if (n != null && graphicDisplay.compareTo(n) < 0) break;
                ++i;
            }
            VMSGraphicsInfo vmsgi = new VMSGraphicsInfo(graphicDisplay, this.getBrowser(), this);
            DefaultMutableTreeNode resource = new DefaultMutableTreeNode(vmsgi);
            this.getBrowser().setNode(resource);
            thisNode.insert(resource, i);
            nodeChanged = true;
            this.mGraphicsToInfoLock.lock();
            try {
                this.graphicsToInfo.put(graphicDisplay, vmsgi);
            }
            finally {
                this.mGraphicsToInfoLock.unlock();
            }
            vmsgi.updateParameters();
        }
        return nodeChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateSoundNodes() {
        DefaultMutableTreeNode thisNode = this.getNode();
        if (thisNode == null) {
            return false;
        }
        Map<String, VMSXML.SoundData> sounds = this.getSounds();
        ArrayList<String> soundNames = new ArrayList<String>();
        if (sounds != null) {
            for (String d : sounds.keySet()) {
                soundNames.add(d);
            }
        }
        ArrayList<DefaultMutableTreeNode> nodesToRemove = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> e = thisNode.children();
        boolean nodeChanged = false;
        while (e.hasMoreElements()) {
            VMSSoundInfo vmssi;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!(node.getUserObject() instanceof VMSSoundInfo) || (vmssi = (VMSSoundInfo)node.getUserObject()).getResource().isNew()) continue;
            if (soundNames.contains(vmssi.getName())) {
                soundNames.remove(vmssi.getName());
                this.mSoundToInfoLock.lock();
                try {
                    this.soundToInfo.put(vmssi.getName(), vmssi);
                }
                finally {
                    this.mSoundToInfoLock.unlock();
                }
                vmssi.updateParameters();
                continue;
            }
            this.mSoundToInfoLock.lock();
            try {
                this.soundToInfo.remove(vmssi.getName());
            }
            finally {
                this.mSoundToInfoLock.unlock();
            }
            vmssi.setNode(null);
            nodesToRemove.add(node);
            nodeChanged = true;
        }
        for (DefaultMutableTreeNode node : nodesToRemove) {
            node.removeFromParent();
        }
        for (String sound : soundNames) {
            VMSXML.SoundData data = sounds.get(sound);
            Enumeration<TreeNode> eee = thisNode.children();
            int i = 0;
            while (eee.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)eee.nextElement();
                if (!(node.getUserObject() instanceof VMSSoundInfo)) {
                    if (!(node.getUserObject() instanceof VMSDiskInfo) && !(node.getUserObject() instanceof VMSFilesystemInfo) && !(node.getUserObject() instanceof VMSInterfaceInfo) && !(node.getUserObject() instanceof VMSInputDevInfo) && !(node.getUserObject() instanceof VMSGraphicsInfo)) continue;
                    ++i;
                    continue;
                }
                VMSSoundInfo v = (VMSSoundInfo)node.getUserObject();
                String n = v.getName();
                if (n != null && sound.compareTo(n) < 0) break;
                ++i;
            }
            VMSSoundInfo vmssi = new VMSSoundInfo(sound, this.getBrowser(), this);
            DefaultMutableTreeNode resource = new DefaultMutableTreeNode(vmssi);
            this.getBrowser().setNode(resource);
            thisNode.insert(resource, i);
            nodeChanged = true;
            this.mSoundToInfoLock.lock();
            try {
                this.soundToInfo.put(sound, vmssi);
            }
            finally {
                this.mSoundToInfoLock.unlock();
            }
            vmssi.updateParameters();
        }
        return nodeChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateSerialNodes() {
        DefaultMutableTreeNode thisNode = this.getNode();
        if (thisNode == null) {
            return false;
        }
        Map<String, VMSXML.SerialData> serials = this.getSerials();
        ArrayList<String> serialNames = new ArrayList<String>();
        if (serials != null) {
            for (String d : serials.keySet()) {
                serialNames.add(d);
            }
        }
        ArrayList<DefaultMutableTreeNode> nodesToRemove = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> e = thisNode.children();
        boolean nodeChanged = false;
        VMSSerialInfo emptySlot = null;
        while (e.hasMoreElements()) {
            VMSSerialInfo vmssi;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!(node.getUserObject() instanceof VMSSerialInfo) || (vmssi = (VMSSerialInfo)node.getUserObject()).getResource().isNew()) continue;
            if ("generate".equals(vmssi.getTargetPort())) {
                emptySlot = vmssi;
                continue;
            }
            if (serialNames.contains(vmssi.getName())) {
                serialNames.remove(vmssi.getName());
                vmssi.updateParameters();
                continue;
            }
            this.mSerialToInfoLock.lock();
            try {
                this.serialToInfo.remove(vmssi.getName());
            }
            finally {
                this.mSerialToInfoLock.unlock();
            }
            vmssi.setNode(null);
            nodesToRemove.add(node);
            nodeChanged = true;
        }
        for (DefaultMutableTreeNode node : nodesToRemove) {
            node.removeFromParent();
        }
        for (String serial : serialNames) {
            VMSSerialInfo vmssi;
            VMSXML.SerialData data = serials.get(serial);
            if (emptySlot == null) {
                Enumeration<TreeNode> eee = thisNode.children();
                int i = 0;
                while (eee.hasMoreElements()) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)eee.nextElement();
                    if (!(node.getUserObject() instanceof VMSSerialInfo)) {
                        if (!(node.getUserObject() instanceof VMSDiskInfo) && !(node.getUserObject() instanceof VMSFilesystemInfo) && !(node.getUserObject() instanceof VMSInterfaceInfo) && !(node.getUserObject() instanceof VMSInputDevInfo) && !(node.getUserObject() instanceof VMSGraphicsInfo) && !(node.getUserObject() instanceof VMSSoundInfo)) continue;
                        ++i;
                        continue;
                    }
                    VMSSerialInfo v = (VMSSerialInfo)node.getUserObject();
                    String n = v.getName();
                    if (n != null && serial.compareTo(n) < 0) break;
                    ++i;
                }
                vmssi = new VMSSerialInfo(serial, this.getBrowser(), this);
                DefaultMutableTreeNode resource = new DefaultMutableTreeNode(vmssi);
                this.getBrowser().setNode(resource);
                thisNode.insert(resource, i);
                nodeChanged = true;
            } else {
                vmssi = emptySlot;
                vmssi.setName(serial);
                emptySlot = null;
            }
            this.mSerialToInfoLock.lock();
            try {
                this.serialToInfo.put(serial, vmssi);
            }
            finally {
                this.mSerialToInfoLock.unlock();
            }
            vmssi.updateParameters();
        }
        return nodeChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateParallelNodes() {
        DefaultMutableTreeNode thisNode = this.getNode();
        if (thisNode == null) {
            return false;
        }
        Map<String, VMSXML.ParallelData> parallels = this.getParallels();
        ArrayList<String> parallelNames = new ArrayList<String>();
        if (parallels != null) {
            for (String d : parallels.keySet()) {
                parallelNames.add(d);
            }
        }
        ArrayList<DefaultMutableTreeNode> nodesToRemove = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> e = thisNode.children();
        boolean nodeChanged = false;
        VMSParallelInfo emptySlot = null;
        while (e.hasMoreElements()) {
            VMSParallelInfo vmspi;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!(node.getUserObject() instanceof VMSParallelInfo) || (vmspi = (VMSParallelInfo)node.getUserObject()).getResource().isNew()) continue;
            if ("generate".equals(vmspi.getTargetPort())) {
                emptySlot = vmspi;
                continue;
            }
            if (parallelNames.contains(vmspi.getName())) {
                parallelNames.remove(vmspi.getName());
                vmspi.updateParameters();
                continue;
            }
            this.mParallelToInfoLock.lock();
            try {
                this.parallelToInfo.remove(vmspi.getName());
            }
            finally {
                this.mParallelToInfoLock.unlock();
            }
            vmspi.setNode(null);
            nodesToRemove.add(node);
            nodeChanged = true;
        }
        for (DefaultMutableTreeNode node : nodesToRemove) {
            node.removeFromParent();
        }
        for (String parallel : parallelNames) {
            VMSParallelInfo vmspi;
            VMSXML.ParallelData data = parallels.get(parallel);
            if (emptySlot == null) {
                Enumeration<TreeNode> eee = thisNode.children();
                int i = 0;
                while (eee.hasMoreElements()) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)eee.nextElement();
                    if (!(node.getUserObject() instanceof VMSParallelInfo)) {
                        if (!(node.getUserObject() instanceof VMSDiskInfo) && !(node.getUserObject() instanceof VMSFilesystemInfo) && !(node.getUserObject() instanceof VMSInterfaceInfo) && !(node.getUserObject() instanceof VMSInputDevInfo) && !(node.getUserObject() instanceof VMSGraphicsInfo) && !(node.getUserObject() instanceof VMSSoundInfo) && !(node.getUserObject() instanceof VMSSerialInfo)) continue;
                        ++i;
                        continue;
                    }
                    VMSParallelInfo v = (VMSParallelInfo)node.getUserObject();
                    String n = v.getName();
                    if (n != null && parallel.compareTo(n) < 0) break;
                    ++i;
                }
                vmspi = new VMSParallelInfo(parallel, this.getBrowser(), this);
                DefaultMutableTreeNode resource = new DefaultMutableTreeNode(vmspi);
                this.getBrowser().setNode(resource);
                thisNode.insert(resource, i);
                nodeChanged = true;
            } else {
                vmspi = emptySlot;
                vmspi.setName(parallel);
                emptySlot = null;
            }
            this.mParallelToInfoLock.lock();
            try {
                this.parallelToInfo.put(parallel, vmspi);
            }
            finally {
                this.mParallelToInfoLock.unlock();
            }
            vmspi.updateParameters();
        }
        return nodeChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateVideoNodes() {
        DefaultMutableTreeNode thisNode = this.getNode();
        if (thisNode == null) {
            return false;
        }
        Map<String, VMSXML.VideoData> videos = this.getVideos();
        ArrayList<String> videoNames = new ArrayList<String>();
        if (videos != null) {
            for (String d : videos.keySet()) {
                videoNames.add(d);
            }
        }
        ArrayList<DefaultMutableTreeNode> nodesToRemove = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> e = thisNode.children();
        boolean nodeChanged = false;
        while (e.hasMoreElements()) {
            VMSVideoInfo vmsvi;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!(node.getUserObject() instanceof VMSVideoInfo) || (vmsvi = (VMSVideoInfo)node.getUserObject()).getResource().isNew()) continue;
            if (videoNames.contains(vmsvi.getName())) {
                videoNames.remove(vmsvi.getName());
                this.mVideoToInfoLock.lock();
                try {
                    this.videoToInfo.put(vmsvi.getName(), vmsvi);
                }
                finally {
                    this.mVideoToInfoLock.unlock();
                }
                vmsvi.updateParameters();
                continue;
            }
            this.mVideoToInfoLock.lock();
            try {
                this.videoToInfo.remove(vmsvi.getName());
            }
            finally {
                this.mVideoToInfoLock.unlock();
            }
            vmsvi.setNode(null);
            nodesToRemove.add(node);
            nodeChanged = true;
        }
        for (DefaultMutableTreeNode node : nodesToRemove) {
            node.removeFromParent();
        }
        for (String video : videoNames) {
            VMSXML.VideoData data = videos.get(video);
            Enumeration<TreeNode> eee = thisNode.children();
            int i = 0;
            while (eee.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)eee.nextElement();
                if (!(node.getUserObject() instanceof VMSVideoInfo)) {
                    if (!(node.getUserObject() instanceof VMSDiskInfo) && !(node.getUserObject() instanceof VMSFilesystemInfo) && !(node.getUserObject() instanceof VMSInterfaceInfo) && !(node.getUserObject() instanceof VMSInputDevInfo) && !(node.getUserObject() instanceof VMSGraphicsInfo) && !(node.getUserObject() instanceof VMSSoundInfo) && !(node.getUserObject() instanceof VMSSerialInfo) && !(node.getUserObject() instanceof VMSParallelInfo)) continue;
                    ++i;
                    continue;
                }
                VMSVideoInfo v = (VMSVideoInfo)node.getUserObject();
                String n = v.getName();
                if (n != null && video.compareTo(n) < 0) break;
                ++i;
            }
            VMSVideoInfo vmspi = new VMSVideoInfo(video, this.getBrowser(), this);
            DefaultMutableTreeNode resource = new DefaultMutableTreeNode(vmspi);
            this.getBrowser().setNode(resource);
            thisNode.insert(resource, i);
            nodeChanged = true;
            this.mVideoToInfoLock.lock();
            try {
                this.videoToInfo.put(video, vmspi);
            }
            finally {
                this.mVideoToInfoLock.unlock();
            }
            vmspi.updateParameters();
        }
        return nodeChanged;
    }

    private MyButton getHostButton(final Host host, String prefix) {
        MyButton hostBtn = new MyButton("Start", null, "not defined on " + host.getName());
        hostBtn.miniButton();
        final MyButton hBtn = hostBtn;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                hBtn.setBackgroundColor(Browser.PANEL_BACKGROUND);
            }
        });
        hostBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        VMSXML vxml = VMSVirtualDomainInfo.this.getBrowser().getVMSXML(host);
                        if (vxml != null) {
                            if (hBtn.getIcon() == VNC_ICON) {
                                int remotePort = vxml.getRemotePort(VMSVirtualDomainInfo.this.getDomainName());
                                Tools.startTightVncViewer(host, remotePort);
                            } else if (hBtn.getIcon() == HostBrowser.HOST_ON_ICON) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        hBtn.setEnabled(false);
                                    }
                                });
                                VMSVirtualDomainInfo.this.start(host);
                            }
                        }
                    }
                });
                t.start();
            }
        });
        hostBtn.setPreferredSize(new Dimension(80, 20));
        hostBtn.setMinimumSize(hostBtn.getPreferredSize());
        if (prefix == null) {
            this.hostButtons.put(host.getName(), hostBtn);
        } else {
            this.hostButtons.put(prefix + ":" + host.getName(), hostBtn);
        }
        return hostBtn;
    }

    public void updateParameters() {
        final DefaultMutableTreeNode thisNode = this.getNode();
        if (thisNode == null) {
            return;
        }
        ArrayList<String> runningOnHosts = new ArrayList<String>();
        ArrayList<String> suspendedOnHosts = new ArrayList<String>();
        ArrayList<String> definedhosts = new ArrayList<String>();
        for (Host h : this.getBrowser().getClusterHosts()) {
            VMSXML vmsxml = this.getBrowser().getVMSXML(h);
            String hostName = h.getName();
            if (vmsxml != null && vmsxml.getDomainNames().contains(this.getDomainName())) {
                if (vmsxml.isRunning(this.getDomainName())) {
                    if (vmsxml.isSuspended(this.getDomainName())) {
                        suspendedOnHosts.add(hostName);
                        this.mTransitionWriteLock.lock();
                        this.suspending.remove(hostName);
                        this.mTransitionWriteLock.unlock();
                    } else {
                        this.mTransitionWriteLock.lock();
                        this.resuming.remove(hostName);
                        this.mTransitionWriteLock.unlock();
                    }
                    runningOnHosts.add(hostName);
                    this.mTransitionWriteLock.lock();
                    this.starting.remove(hostName);
                    this.mTransitionWriteLock.unlock();
                }
                definedhosts.add(hostName);
                continue;
            }
            definedhosts.add("<font color=\"#A3A3A3\">" + hostName + "</font>");
        }
        this.definedOnString = "<html>" + Tools.join(", ", definedhosts.toArray(new String[definedhosts.size()])) + "</html>";
        boolean running = !runningOnHosts.isEmpty();
        this.mTransitionWriteLock.lock();
        this.setHostButtons(running);
        if (runningOnHosts.isEmpty() && this.starting.isEmpty()) {
            this.shuttingdown.clear();
            this.suspending.clear();
            this.resuming.clear();
            this.mTransitionWriteLock.unlock();
            this.runningOnString = "Stopped";
        } else {
            this.mTransitionWriteLock.unlock();
            if (this.progress.charAt(0) == '-') {
                this.progress.setCharAt(0, '\\');
            } else if (this.progress.charAt(0) == '\\') {
                this.progress.setCharAt(0, '|');
            } else if (this.progress.charAt(0) == '|') {
                this.progress.setCharAt(0, '/');
            } else if (this.progress.charAt(0) == '/') {
                this.progress.setCharAt(0, '-');
            }
            this.mTransitionReadLock.lock();
            this.runningOnString = !this.starting.isEmpty() ? "<html>Starting on: " + Tools.join(", ", this.starting.toArray(new String[this.starting.size()])) + this.progress.toString() + "</html>" : (!this.shuttingdown.isEmpty() ? "<html>Shutting down on: " + Tools.join(", ", this.shuttingdown.toArray(new String[this.shuttingdown.size()])) + this.progress.toString() + "</html>" : (!this.suspending.isEmpty() ? "<html>Suspending on: " + Tools.join(", ", this.suspending.toArray(new String[this.suspending.size()])) + this.progress.toString() + "</html>" : (!this.resuming.isEmpty() ? "<html>Resuming on: " + Tools.join(", ", this.resuming.toArray(new String[this.suspending.size()])) + this.progress.toString() + "</html>" : (!suspendedOnHosts.isEmpty() ? "<html>Paused on: " + Tools.join(", ", suspendedOnHosts.toArray(new String[suspendedOnHosts.size()])) + "</html>" : "<html>Running on: " + Tools.join(", ", runningOnHosts.toArray(new String[runningOnHosts.size()])) + "</html>"))));
            this.mTransitionReadLock.unlock();
        }
        for (Host h : this.getBrowser().getClusterHosts()) {
            VMSXML vmsxml = this.getBrowser().getVMSXML(h);
            Widget hwi = this.definedOnHostComboBoxHash.get(h.getName());
            if (hwi == null) continue;
            String value = vmsxml != null && vmsxml.getDomainNames().contains(this.getDomainName()) ? DEFINED_ON_HOST_TRUE : DEFINED_ON_HOST_FALSE;
            hwi.setValue(value);
        }
        for (String param : this.getParametersFromXML()) {
            String oldValue = this.getParamSaved(param);
            String value = null;
            Widget wi = this.getWidget(param, null);
            for (Host h : this.getDefinedOnHosts()) {
                VMSXML vmsxml = this.getBrowser().getVMSXML(h);
                if (vmsxml == null || value != null) continue;
                value = this.getParamSaved(param);
                String savedValue = vmsxml.getValue(this.getDomainName(), param);
                if (savedValue == null) {
                    value = this.getParamDefault(param);
                    continue;
                }
                value = savedValue;
            }
            if (Tools.areEqual(value, oldValue)) continue;
            this.getResource().setValue(param, value);
            if (wi == null) continue;
            wi.setValue(value);
        }
        for (Host h : this.getDefinedOnHosts()) {
            VMSXML vmsxml = this.getBrowser().getVMSXML(h);
            if (vmsxml == null) continue;
            this.uuid = vmsxml.getValue(this.getDomainName(), "uuid");
        }
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                boolean interfaceNodeChanged = VMSVirtualDomainInfo.this.updateInterfaceNodes();
                boolean diskNodeChanged = VMSVirtualDomainInfo.this.updateDiskNodes();
                boolean filesystemNodeChanged = VMSVirtualDomainInfo.this.updateFilesystemNodes();
                boolean inputDevNodeChanged = VMSVirtualDomainInfo.this.updateInputDevNodes();
                boolean graphicsNodeChanged = VMSVirtualDomainInfo.this.updateGraphicsNodes();
                boolean soundNodeChanged = VMSVirtualDomainInfo.this.updateSoundNodes();
                boolean serialNodeChanged = VMSVirtualDomainInfo.this.updateSerialNodes();
                boolean parallelNodeChanged = VMSVirtualDomainInfo.this.updateParallelNodes();
                boolean videoNodeChanged = VMSVirtualDomainInfo.this.updateVideoNodes();
                if (interfaceNodeChanged || diskNodeChanged || filesystemNodeChanged || inputDevNodeChanged || graphicsNodeChanged || soundNodeChanged || serialNodeChanged || parallelNodeChanged || videoNodeChanged) {
                    VMSVirtualDomainInfo.this.getBrowser().reload(thisNode, false);
                }
            }
        });
        this.updateTable(HEADER_TABLE);
        this.updateTable(DISK_TABLE);
        this.updateTable(FILESYSTEM_TABLE);
        this.updateTable(INTERFACES_TABLE);
        this.updateTable(INPUTDEVS_TABLE);
        this.updateTable(GRAPHICS_TABLE);
        this.updateTable(SOUND_TABLE);
        this.updateTable(SERIAL_TABLE);
        this.updateTable(PARALLEL_TABLE);
        this.updateTable(VIDEO_TABLE);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VMSVirtualDomainInfo.this.setApplyButtons(null, VMSVirtualDomainInfo.this.getParametersFromXML());
                VMSVirtualDomainInfo.this.getBrowser().repaintTree();
            }
        });
    }

    private String getVNCMenuString(String viewer, Host host) {
        return Tools.getString("VMSVirtualDomainInfo.StartVNCViewerOn").replaceAll("@VIEWER@", Matcher.quoteReplacement(viewer)) + host.getName();
    }

    public JPanel getDefinedOnHostsPanel(String prefix, final MyButton thisApplyButton) {
        JPanel hostPanel = new JPanel(new SpringLayout());
        int rows = 0;
        boolean running = false;
        for (Host host : this.getBrowser().getClusterHosts()) {
            String defaultValue = null;
            VMSXML vmsxml = this.getBrowser().getVMSXML(host);
            if (vmsxml != null && vmsxml.isRunning(this.getDomainName())) {
                running = true;
            }
            boolean notDefined = false;
            if (vmsxml != null && !vmsxml.getDomainNames().contains(this.getDomainName())) {
                notDefined = false;
            }
            defaultValue = host.isConnected() && (this.getResource().isNew() || vmsxml != null && vmsxml.getDomainNames().contains(this.getDomainName())) ? DEFINED_ON_HOST_TRUE : DEFINED_ON_HOST_FALSE;
            MyButton hostBtn = this.getHostButton(host, prefix);
            final Widget wi = WidgetFactory.createInstance(Widget.Type.CHECKBOX, defaultValue, Widget.NO_ITEMS, Widget.NO_REGEXP, ClusterBrowser.SERVICE_FIELD_WIDTH * 2, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.ADMIN, false), hostBtn);
            Widget rpwi = null;
            if (prefix == null) {
                this.definedOnHostComboBoxHash.put(host.getName(), wi);
            } else {
                this.definedOnHostComboBoxHash.put(prefix + ":" + host.getName(), wi);
                rpwi = this.definedOnHostComboBoxHash.get(host.getName());
            }
            final Widget realParamWi = rpwi;
            if (!host.isConnected()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        wi.setEnabled(false);
                    }
                });
            }
            wi.addListeners(new WidgetListener(){

                @Override
                public void check(Object value) {
                    VMSVirtualDomainInfo.this.checkParameterFields(wi, realParamWi, "cached", VMSVirtualDomainInfo.this.getParametersFromXML(), thisApplyButton);
                }
            });
            wi.setBackgroundColor(ClusterBrowser.PANEL_BACKGROUND);
            JLabel label = new JLabel(host.getName());
            wi.setLabel(label, null);
            this.addField(hostPanel, label, wi, ClusterBrowser.SERVICE_LABEL_WIDTH, ClusterBrowser.SERVICE_FIELD_WIDTH * 2, 0);
            ++rows;
        }
        this.setHostButtons(running);
        SpringUtilities.makeCompactGrid(hostPanel, rows, 2, 1, 1, 1, 1);
        JPanel doPanel = this.getParamPanel("Defined on");
        doPanel.add(hostPanel);
        return doPanel;
    }

    @Override
    public JComponent getInfoPanel() {
        if (this.infoPanel != null) {
            return this.infoPanel;
        }
        boolean abExisted = this.getApplyButton() != null;
        JPanel mainPanel = new JPanel();
        mainPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JTable table = this.getTable(HEADER_TABLE);
        if (table != null) {
            JComponent newVMButton = this.getBrowser().getVMSInfo().getNewButton();
            mainPanel.add(newVMButton);
            mainPanel.add(table.getTableHeader());
            mainPanel.add(table);
        }
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBackground(ClusterBrowser.BUTTON_PANEL_BACKGROUND);
        buttonPanel.setMinimumSize(new Dimension(0, 50));
        buttonPanel.setPreferredSize(new Dimension(0, 50));
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        optionsPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        final String[] params = this.getParametersFromXML();
        this.initApplyButton(null);
        if (!abExisted) {
            this.getApplyButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            VMSVirtualDomainInfo.this.getBrowser().clStatusLock();
                            VMSVirtualDomainInfo.this.apply(false);
                            VMSVirtualDomainInfo.this.getBrowser().clStatusUnlock();
                        }
                    });
                    thread.start();
                }
            });
            this.getRevertButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            VMSVirtualDomainInfo.this.getBrowser().clStatusLock();
                            VMSVirtualDomainInfo.this.revert();
                            VMSVirtualDomainInfo.this.getBrowser().clStatusUnlock();
                        }
                    });
                    thread.start();
                }
            });
        }
        JPanel extraButtonPanel = new JPanel(new FlowLayout(2, 0, 0));
        extraButtonPanel.setBackground(Browser.BUTTON_PANEL_BACKGROUND);
        buttonPanel.add(extraButtonPanel);
        this.addApplyButton(buttonPanel);
        this.addRevertButton(extraButtonPanel);
        MyButton overviewButton = new MyButton("VMs Overview", BACK_ICON);
        overviewButton.miniButton();
        overviewButton.setPreferredSize(new Dimension(130, 50));
        overviewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VMSVirtualDomainInfo.this.getBrowser().getVMSInfo().selectMyself();
            }
        });
        extraButtonPanel.add(overviewButton);
        optionsPanel.add(this.getDefinedOnHostsPanel(null, this.getApplyButton()));
        this.addParams(optionsPanel, params, ClusterBrowser.SERVICE_LABEL_WIDTH, ClusterBrowser.SERVICE_FIELD_WIDTH * 2, null);
        buttonPanel.add((Component)this.getActionsButton(), "East");
        mainPanel.add(optionsPanel);
        MyButton newDiskBtn = VMSDiskInfo.getNewBtn(this);
        MyButton newFilesystemBtn = VMSFilesystemInfo.getNewBtn(this);
        MyButton newInterfaceBtn = VMSInterfaceInfo.getNewBtn(this);
        MyButton newInputBtn = VMSInputDevInfo.getNewBtn(this);
        MyButton newGraphicsBtn = VMSGraphicsInfo.getNewBtn(this);
        MyButton newSoundBtn = VMSSoundInfo.getNewBtn(this);
        MyButton newSerialBtn = VMSSerialInfo.getNewBtn(this);
        MyButton newParallelBtn = VMSParallelInfo.getNewBtn(this);
        MyButton newVideoBtn = VMSVideoInfo.getNewBtn(this);
        mainPanel.add(this.getTablePanel("Disks", DISK_TABLE, newDiskBtn));
        mainPanel.add(this.getTablePanel("Filesystems", FILESYSTEM_TABLE, newFilesystemBtn));
        mainPanel.add(Box.createVerticalStrut(20));
        mainPanel.add(this.getTablePanel("Interfaces", INTERFACES_TABLE, newInterfaceBtn));
        mainPanel.add(Box.createVerticalStrut(20));
        mainPanel.add(this.getTablePanel("Input Devices", INPUTDEVS_TABLE, newInputBtn));
        mainPanel.add(Box.createVerticalStrut(20));
        mainPanel.add(this.getTablePanel("Graphics Devices", GRAPHICS_TABLE, newGraphicsBtn));
        mainPanel.add(Box.createVerticalStrut(20));
        mainPanel.add(this.getTablePanel("Sound Devices", SOUND_TABLE, newSoundBtn));
        mainPanel.add(Box.createVerticalStrut(20));
        mainPanel.add(this.getTablePanel("Serial Devices", SERIAL_TABLE, newSerialBtn));
        mainPanel.add(Box.createVerticalStrut(20));
        mainPanel.add(this.getTablePanel("Parallel Devices", PARALLEL_TABLE, newParallelBtn));
        mainPanel.add(Box.createVerticalStrut(20));
        mainPanel.add(this.getTablePanel("Video Devices", VIDEO_TABLE, newVideoBtn));
        JPanel newPanel = new JPanel();
        newPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        newPanel.add(buttonPanel);
        newPanel.add(this.getMoreOptionsPanel(ClusterBrowser.SERVICE_LABEL_WIDTH + ClusterBrowser.SERVICE_FIELD_WIDTH * 2 + 4));
        newPanel.add(new JScrollPane(mainPanel));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VMSVirtualDomainInfo.this.setApplyButtons(null, params);
            }
        });
        this.infoPanel = newPanel;
        this.infoPanelDone();
        return this.infoPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(Host host) {
        boolean ret = VIRSH.start(host, this.getDomainName(), this.getVirshOptions());
        if (ret) {
            int i = 0;
            this.mTransitionWriteLock.lock();
            boolean wasEmpty = this.starting.isEmpty();
            this.starting.add(host.getName());
            if (!wasEmpty) {
                this.mTransitionWriteLock.unlock();
                return;
            }
            this.mTransitionWriteLock.unlock();
            while (true) {
                this.getBrowser().periodicalVMSUpdate(host);
                this.updateParameters();
                this.getBrowser().getVMSInfo().updateTable("main");
                Tools.sleep(1000);
                this.mTransitionReadLock.lock();
                if (this.starting.isEmpty() || ++i >= 20) break;
                this.mTransitionReadLock.unlock();
            }
            this.mTransitionReadLock.unlock();
            if (i >= 20) {
                Tools.appWarning("could not start on " + host.getName());
                this.mTransitionWriteLock.lock();
                try {
                    this.starting.clear();
                }
                finally {
                    this.mTransitionWriteLock.unlock();
                }
            }
            this.getBrowser().periodicalVMSUpdate(host);
            this.updateParameters();
            this.getBrowser().getVMSInfo().updateTable("main");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startShuttingdownIndicator(Host host) {
        int i = 0;
        this.mTransitionWriteLock.lock();
        boolean wasEmpty = this.starting.isEmpty();
        this.shuttingdown.add(host.getName());
        if (!wasEmpty) {
            this.mTransitionWriteLock.unlock();
            return;
        }
        this.mTransitionWriteLock.unlock();
        while (true) {
            this.getBrowser().periodicalVMSUpdate(host);
            this.updateParameters();
            this.getBrowser().getVMSInfo().updateTable("main");
            Tools.sleep(1000);
            this.mTransitionReadLock.lock();
            if (this.shuttingdown.isEmpty() || ++i >= 20) break;
            this.mTransitionReadLock.unlock();
        }
        this.mTransitionReadLock.unlock();
        if (i >= 20) {
            Tools.appWarning("could not shut down on " + host.getName());
            this.mTransitionWriteLock.lock();
            try {
                this.shuttingdown.clear();
            }
            finally {
                this.mTransitionWriteLock.unlock();
            }
        }
        this.getBrowser().periodicalVMSUpdate(host);
        this.updateParameters();
        this.getBrowser().getVMSInfo().updateTable("main");
    }

    void shutdown(Host host) {
        boolean ret = VIRSH.shutdown(host, this.getDomainName(), this.getVirshOptions());
        if (ret) {
            this.startShuttingdownIndicator(host);
        }
    }

    void destroy(Host host) {
        boolean ret = VIRSH.destroy(host, this.getDomainName(), this.getVirshOptions());
        if (ret) {
            this.startShuttingdownIndicator(host);
        }
    }

    void reboot(Host host) {
        boolean ret = VIRSH.reboot(host, this.getDomainName(), this.getVirshOptions());
        if (ret) {
            this.startShuttingdownIndicator(host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void suspend(Host host) {
        boolean ret = VIRSH.suspend(host, this.getDomainName(), this.getVirshOptions());
        if (ret) {
            int i = 0;
            this.mTransitionWriteLock.lock();
            boolean wasEmpty = this.suspending.isEmpty();
            this.suspending.add(host.getName());
            if (!wasEmpty) {
                this.mTransitionWriteLock.unlock();
                return;
            }
            this.mTransitionWriteLock.unlock();
            while (!this.suspending.isEmpty() && i < 20) {
                this.getBrowser().periodicalVMSUpdate(host);
                this.updateParameters();
                this.getBrowser().getVMSInfo().updateTable("main");
                Tools.sleep(1000);
                this.mTransitionReadLock.lock();
                if (this.suspending.isEmpty() || ++i >= 20) {
                    this.mTransitionReadLock.unlock();
                    break;
                }
                this.mTransitionReadLock.unlock();
            }
            if (i >= 20) {
                Tools.appWarning("could not suspend on " + host.getName());
                this.mTransitionWriteLock.lock();
                try {
                    this.suspending.clear();
                }
                finally {
                    this.mTransitionWriteLock.unlock();
                }
            }
            this.getBrowser().periodicalVMSUpdate(host);
            this.updateParameters();
            this.getBrowser().getVMSInfo().updateTable("main");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume(Host host) {
        boolean ret = VIRSH.resume(host, this.getDomainName(), this.getVirshOptions());
        if (ret) {
            int i = 0;
            this.mTransitionWriteLock.lock();
            boolean wasEmpty = this.resuming.isEmpty();
            this.resuming.add(host.getName());
            if (!wasEmpty) {
                this.mTransitionWriteLock.unlock();
                return;
            }
            this.mTransitionWriteLock.unlock();
            while (!this.resuming.isEmpty() && i < 20) {
                this.getBrowser().periodicalVMSUpdate(host);
                this.updateParameters();
                this.getBrowser().getVMSInfo().updateTable("main");
                Tools.sleep(1000);
                this.mTransitionReadLock.lock();
                if (this.resuming.isEmpty() || ++i >= 20) {
                    this.mTransitionReadLock.unlock();
                    break;
                }
                this.mTransitionReadLock.unlock();
            }
            if (i >= 20) {
                Tools.appWarning("could not resume on " + host.getName());
                this.mTransitionWriteLock.lock();
                try {
                    this.resuming.clear();
                }
                finally {
                    this.mTransitionWriteLock.unlock();
                }
            }
            this.getBrowser().periodicalVMSUpdate(host);
            this.updateParameters();
            this.getBrowser().getVMSInfo().updateTable("main");
        }
    }

    public VMSDiskInfo addDiskPanel() {
        VMSDiskInfo vmsdi = new VMSDiskInfo(null, this.getBrowser(), this);
        vmsdi.getResource().setNew(true);
        final DefaultMutableTreeNode resource = new DefaultMutableTreeNode(vmsdi);
        this.getBrowser().setNode(resource);
        final DefaultMutableTreeNode thisNode = this.getNode();
        if (thisNode == null) {
            return vmsdi;
        }
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                DefaultMutableTreeNode node;
                Enumeration<TreeNode> eee = thisNode.children();
                int i = 0;
                while (eee.hasMoreElements() && (node = (DefaultMutableTreeNode)eee.nextElement()).getUserObject() instanceof VMSDiskInfo) {
                    ++i;
                }
                thisNode.insert(resource, i);
            }
        });
        this.getBrowser().reload(thisNode, true);
        vmsdi.selectMyself();
        return vmsdi;
    }

    public VMSFilesystemInfo addFilesystemPanel() {
        VMSFilesystemInfo vmsdi = new VMSFilesystemInfo(null, this.getBrowser(), this);
        vmsdi.getResource().setNew(true);
        final DefaultMutableTreeNode resource = new DefaultMutableTreeNode(vmsdi);
        this.getBrowser().setNode(resource);
        final DefaultMutableTreeNode thisNode = this.getNode();
        if (thisNode == null) {
            return vmsdi;
        }
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                DefaultMutableTreeNode node;
                Enumeration<TreeNode> eee = thisNode.children();
                int i = 0;
                while (eee.hasMoreElements() && (node = (DefaultMutableTreeNode)eee.nextElement()).getUserObject() instanceof VMSFilesystemInfo) {
                    ++i;
                }
                thisNode.insert(resource, i);
            }
        });
        this.getBrowser().reload(thisNode, true);
        vmsdi.selectMyself();
        return vmsdi;
    }

    public VMSInterfaceInfo addInterfacePanel() {
        VMSInterfaceInfo vmsii = new VMSInterfaceInfo(null, this.getBrowser(), this);
        vmsii.getResource().setNew(true);
        final DefaultMutableTreeNode resource = new DefaultMutableTreeNode(vmsii);
        this.getBrowser().setNode(resource);
        final DefaultMutableTreeNode thisNode = this.getNode();
        if (thisNode == null) {
            return vmsii;
        }
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                DefaultMutableTreeNode node;
                Enumeration<TreeNode> eee = thisNode.children();
                int i = 0;
                while (eee.hasMoreElements() && ((node = (DefaultMutableTreeNode)eee.nextElement()).getUserObject() instanceof VMSDiskInfo || node.getUserObject() instanceof VMSFilesystemInfo || node.getUserObject() instanceof VMSInterfaceInfo)) {
                    ++i;
                }
                thisNode.insert(resource, i);
            }
        });
        this.getBrowser().reload(thisNode, true);
        vmsii.selectMyself();
        return vmsii;
    }

    void addInputDevPanel() {
        VMSInputDevInfo vmsidi = new VMSInputDevInfo(null, this.getBrowser(), this);
        vmsidi.getResource().setNew(true);
        final DefaultMutableTreeNode resource = new DefaultMutableTreeNode(vmsidi);
        this.getBrowser().setNode(resource);
        final DefaultMutableTreeNode thisNode = this.getNode();
        if (thisNode == null) {
            return;
        }
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                DefaultMutableTreeNode node;
                Enumeration<TreeNode> eee = thisNode.children();
                int i = 0;
                while (eee.hasMoreElements() && ((node = (DefaultMutableTreeNode)eee.nextElement()).getUserObject() instanceof VMSDiskInfo || node.getUserObject() instanceof VMSFilesystemInfo || node.getUserObject() instanceof VMSInterfaceInfo || node.getUserObject() instanceof VMSInputDevInfo)) {
                    ++i;
                }
                thisNode.insert(resource, i);
            }
        });
        this.getBrowser().reload(thisNode, true);
        vmsidi.selectMyself();
    }

    public VMSGraphicsInfo addGraphicsPanel() {
        VMSGraphicsInfo vmsgi = new VMSGraphicsInfo(null, this.getBrowser(), this);
        vmsgi.getResource().setNew(true);
        final DefaultMutableTreeNode resource = new DefaultMutableTreeNode(vmsgi);
        this.getBrowser().setNode(resource);
        final DefaultMutableTreeNode thisNode = this.getNode();
        if (thisNode == null) {
            return vmsgi;
        }
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                DefaultMutableTreeNode node;
                Enumeration<TreeNode> eee = thisNode.children();
                int i = 0;
                while (eee.hasMoreElements() && ((node = (DefaultMutableTreeNode)eee.nextElement()).getUserObject() instanceof VMSDiskInfo || node.getUserObject() instanceof VMSFilesystemInfo || node.getUserObject() instanceof VMSInterfaceInfo || node.getUserObject() instanceof VMSInputDevInfo || node.getUserObject() instanceof VMSGraphicsInfo)) {
                    ++i;
                }
                thisNode.insert(resource, i);
            }
        });
        this.getBrowser().reload(thisNode, true);
        vmsgi.selectMyself();
        return vmsgi;
    }

    void addSoundsPanel() {
        VMSSoundInfo vmssi = new VMSSoundInfo(null, this.getBrowser(), this);
        vmssi.getResource().setNew(true);
        final DefaultMutableTreeNode resource = new DefaultMutableTreeNode(vmssi);
        this.getBrowser().setNode(resource);
        final DefaultMutableTreeNode thisNode = this.getNode();
        if (thisNode == null) {
            return;
        }
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                DefaultMutableTreeNode node;
                Enumeration<TreeNode> eee = thisNode.children();
                int i = 0;
                while (eee.hasMoreElements() && ((node = (DefaultMutableTreeNode)eee.nextElement()).getUserObject() instanceof VMSDiskInfo || node.getUserObject() instanceof VMSFilesystemInfo || node.getUserObject() instanceof VMSInterfaceInfo || node.getUserObject() instanceof VMSInputDevInfo || node.getUserObject() instanceof VMSGraphicsInfo || node.getUserObject() instanceof VMSSoundInfo)) {
                    ++i;
                }
                thisNode.insert(resource, i);
            }
        });
        this.getBrowser().reload(thisNode, true);
        vmssi.selectMyself();
    }

    void addSerialsPanel() {
        VMSSerialInfo vmssi = new VMSSerialInfo(null, this.getBrowser(), this);
        vmssi.getResource().setNew(true);
        final DefaultMutableTreeNode resource = new DefaultMutableTreeNode(vmssi);
        this.getBrowser().setNode(resource);
        final DefaultMutableTreeNode thisNode = this.getNode();
        if (thisNode == null) {
            return;
        }
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                DefaultMutableTreeNode node;
                Enumeration<TreeNode> eee = thisNode.children();
                int i = 0;
                while (eee.hasMoreElements() && ((node = (DefaultMutableTreeNode)eee.nextElement()).getUserObject() instanceof VMSDiskInfo || node.getUserObject() instanceof VMSFilesystemInfo || node.getUserObject() instanceof VMSInterfaceInfo || node.getUserObject() instanceof VMSInputDevInfo || node.getUserObject() instanceof VMSGraphicsInfo || node.getUserObject() instanceof VMSSoundInfo || node.getUserObject() instanceof VMSSerialInfo)) {
                    ++i;
                }
                thisNode.insert(resource, i);
            }
        });
        this.getBrowser().reload(thisNode, true);
        vmssi.selectMyself();
    }

    void addParallelsPanel() {
        VMSParallelInfo vmspi = new VMSParallelInfo(null, this.getBrowser(), this);
        vmspi.getResource().setNew(true);
        final DefaultMutableTreeNode resource = new DefaultMutableTreeNode(vmspi);
        this.getBrowser().setNode(resource);
        final DefaultMutableTreeNode thisNode = this.getNode();
        if (thisNode == null) {
            return;
        }
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                DefaultMutableTreeNode node;
                Enumeration<TreeNode> eee = thisNode.children();
                int i = 0;
                while (eee.hasMoreElements() && ((node = (DefaultMutableTreeNode)eee.nextElement()).getUserObject() instanceof VMSDiskInfo || node.getUserObject() instanceof VMSFilesystemInfo || node.getUserObject() instanceof VMSInterfaceInfo || node.getUserObject() instanceof VMSInputDevInfo || node.getUserObject() instanceof VMSGraphicsInfo || node.getUserObject() instanceof VMSSoundInfo || node.getUserObject() instanceof VMSSerialInfo || node.getUserObject() instanceof VMSParallelInfo)) {
                    ++i;
                }
                thisNode.insert(resource, i);
            }
        });
        this.getBrowser().reload(thisNode, true);
        vmspi.selectMyself();
    }

    void addVideosPanel() {
        VMSVideoInfo vmsvi = new VMSVideoInfo(null, this.getBrowser(), this);
        vmsvi.getResource().setNew(true);
        final DefaultMutableTreeNode resource = new DefaultMutableTreeNode(vmsvi);
        this.getBrowser().setNode(resource);
        final DefaultMutableTreeNode thisNode = this.getNode();
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                thisNode.add(resource);
            }
        });
        this.getBrowser().reload(thisNode, true);
        vmsvi.selectMyself();
    }

    private MyMenu getAddNewHardwareMenu(String name) {
        return new MyMenu(name, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void update() {
                Tools.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        this.removeAll();
                    }
                });
                Point2D pos = this.getPos();
                MyMenuItem newDiskMenuItem = new MyMenuItem(Tools.getString("VMSVirtualDomainInfo.AddNewDisk"), BlockDevInfo.HARDDISK_ICON_LARGE, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void action() {
                        VMSVirtualDomainInfo.this.hidePopup();
                        VMSVirtualDomainInfo.this.addDiskPanel();
                    }
                };
                newDiskMenuItem.setPos(pos);
                this.add(newDiskMenuItem);
                MyMenuItem newFilesystemMenuItem = new MyMenuItem(Tools.getString("VMSVirtualDomainInfo.AddNewFilesystem"), BlockDevInfo.HARDDISK_ICON_LARGE, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void action() {
                        VMSVirtualDomainInfo.this.hidePopup();
                        VMSVirtualDomainInfo.this.addFilesystemPanel();
                    }
                };
                newFilesystemMenuItem.setPos(pos);
                this.add(newFilesystemMenuItem);
                MyMenuItem newInterfaceMenuItem = new MyMenuItem(Tools.getString("VMSVirtualDomainInfo.AddNewInterface"), NetInfo.NET_I_ICON_LARGE, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void action() {
                        VMSVirtualDomainInfo.this.hidePopup();
                        VMSVirtualDomainInfo.this.addInterfacePanel();
                    }
                };
                newInterfaceMenuItem.setPos(pos);
                this.add(newInterfaceMenuItem);
                MyMenuItem newGraphicsMenuItem = new MyMenuItem(Tools.getString("VMSVirtualDomainInfo.AddNewGraphics"), VNC_ICON, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void action() {
                        VMSVirtualDomainInfo.this.hidePopup();
                        VMSVirtualDomainInfo.this.addGraphicsPanel();
                    }
                };
                newGraphicsMenuItem.setPos(pos);
                this.add(newGraphicsMenuItem);
                MyMenuItem newInputDevMenuItem = new MyMenuItem(Tools.getString("VMSVirtualDomainInfo.AddNewInputDev"), null, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void action() {
                        VMSVirtualDomainInfo.this.hidePopup();
                        VMSVirtualDomainInfo.this.addInputDevPanel();
                    }
                };
                newInputDevMenuItem.setPos(pos);
                this.add(newInputDevMenuItem);
                MyMenuItem newSoundsMenuItem = new MyMenuItem(Tools.getString("VMSVirtualDomainInfo.AddNewSound"), null, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void action() {
                        VMSVirtualDomainInfo.this.hidePopup();
                        VMSVirtualDomainInfo.this.addSoundsPanel();
                    }
                };
                newSoundsMenuItem.setPos(pos);
                this.add(newSoundsMenuItem);
                MyMenuItem newSerialsMenuItem = new MyMenuItem(Tools.getString("VMSVirtualDomainInfo.AddNewSerial"), null, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void action() {
                        VMSVirtualDomainInfo.this.hidePopup();
                        VMSVirtualDomainInfo.this.addSerialsPanel();
                    }
                };
                newSerialsMenuItem.setPos(pos);
                this.add(newSerialsMenuItem);
                MyMenuItem newParallelsMenuItem = new MyMenuItem(Tools.getString("VMSVirtualDomainInfo.AddNewParallel"), null, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void action() {
                        VMSVirtualDomainInfo.this.hidePopup();
                        VMSVirtualDomainInfo.this.addParallelsPanel();
                    }
                };
                newParallelsMenuItem.setPos(pos);
                this.add(newParallelsMenuItem);
                MyMenuItem newVideosMenuItem = new MyMenuItem(Tools.getString("VMSVirtualDomainInfo.AddNewVideo"), null, new AccessMode(ConfigData.AccessType.ADMIN, true), new AccessMode(ConfigData.AccessType.OP, false)){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void action() {
                        VMSVirtualDomainInfo.this.hidePopup();
                        VMSVirtualDomainInfo.this.addVideosPanel();
                    }
                };
                newVideosMenuItem.setPos(pos);
                this.add(newVideosMenuItem);
                super.update();
            }
        };
    }

    void addStartMenu(List<UpdatableItem> items, final Host host) {
        MyMenuItem startMenuItem = new MyMenuItem(Tools.getString("VMSVirtualDomainInfo.StartOn") + host.getName(), HostBrowser.HOST_ON_ICON_LARGE, Tools.getString("VMSVirtualDomainInfo.StartOn") + host.getName(), new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                VMSXML vmsxml = VMSVirtualDomainInfo.this.getBrowser().getVMSXML(host);
                return vmsxml != null && vmsxml.getDomainNames().contains(VMSVirtualDomainInfo.this.getDomainName()) && !vmsxml.isRunning(VMSVirtualDomainInfo.this.getDomainName());
            }

            @Override
            public String enablePredicate() {
                if (!Tools.getConfigData().isAdvancedMode() && VMSVirtualDomainInfo.this.isUsedByCRM()) {
                    return VMSVirtualDomainInfo.IS_USED_BY_CRM_STRING;
                }
                return null;
            }

            @Override
            public void action() {
                VMSVirtualDomainInfo.this.hidePopup();
                VMSXML vxml = VMSVirtualDomainInfo.this.getBrowser().getVMSXML(host);
                if (vxml != null && host != null) {
                    VMSVirtualDomainInfo.this.start(host);
                }
            }
        };
        items.add(startMenuItem);
    }

    void addShutdownMenu(List<UpdatableItem> items, final Host host) {
        MyMenuItem shutdownMenuItem = new MyMenuItem(Tools.getString("VMSVirtualDomainInfo.ShutdownOn") + host.getName(), SHUTDOWN_ICON, Tools.getString("VMSVirtualDomainInfo.ShutdownOn") + host.getName(), new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                VMSXML vmsxml = VMSVirtualDomainInfo.this.getBrowser().getVMSXML(host);
                return vmsxml != null && vmsxml.getDomainNames().contains(VMSVirtualDomainInfo.this.getDomainName()) && vmsxml.isRunning(VMSVirtualDomainInfo.this.getDomainName());
            }

            @Override
            public String enablePredicate() {
                if (!Tools.getConfigData().isAdvancedMode() && VMSVirtualDomainInfo.this.isUsedByCRM()) {
                    return VMSVirtualDomainInfo.IS_USED_BY_CRM_STRING;
                }
                return null;
            }

            @Override
            public void action() {
                VMSVirtualDomainInfo.this.hidePopup();
                VMSXML vxml = VMSVirtualDomainInfo.this.getBrowser().getVMSXML(host);
                if (vxml != null && host != null) {
                    VMSVirtualDomainInfo.this.shutdown(host);
                }
            }
        };
        items.add(shutdownMenuItem);
    }

    void addRebootMenu(List<UpdatableItem> items, final Host host) {
        MyMenuItem rebootMenuItem = new MyMenuItem(Tools.getString("VMSVirtualDomainInfo.RebootOn") + host.getName(), REBOOT_ICON, Tools.getString("VMSVirtualDomainInfo.RebootOn") + host.getName(), new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                VMSXML vmsxml = VMSVirtualDomainInfo.this.getBrowser().getVMSXML(host);
                return vmsxml != null && vmsxml.getDomainNames().contains(VMSVirtualDomainInfo.this.getDomainName()) && vmsxml.isRunning(VMSVirtualDomainInfo.this.getDomainName());
            }

            @Override
            public String enablePredicate() {
                if (!Tools.getConfigData().isAdvancedMode() && VMSVirtualDomainInfo.this.isUsedByCRM()) {
                    return VMSVirtualDomainInfo.IS_USED_BY_CRM_STRING;
                }
                return null;
            }

            @Override
            public void action() {
                VMSVirtualDomainInfo.this.hidePopup();
                VMSXML vxml = VMSVirtualDomainInfo.this.getBrowser().getVMSXML(host);
                if (vxml != null && host != null) {
                    VMSVirtualDomainInfo.this.reboot(host);
                }
            }
        };
        items.add(rebootMenuItem);
    }

    void addResumeMenu(List<UpdatableItem> items, final Host host) {
        MyMenuItem resumeMenuItem = new MyMenuItem(Tools.getString("VMSVirtualDomainInfo.ResumeOn") + host.getName(), RESUME_ICON, Tools.getString("VMSVirtualDomainInfo.ResumeOn") + host.getName(), new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                VMSXML vmsxml = VMSVirtualDomainInfo.this.getBrowser().getVMSXML(host);
                return vmsxml != null && vmsxml.getDomainNames().contains(VMSVirtualDomainInfo.this.getDomainName()) && vmsxml.isSuspended(VMSVirtualDomainInfo.this.getDomainName());
            }

            @Override
            public String enablePredicate() {
                if (VMSVirtualDomainInfo.this.getResource().isNew()) {
                    return VMSVirtualDomainInfo.NOT_APPLIED;
                }
                VMSXML vmsxml = VMSVirtualDomainInfo.this.getBrowser().getVMSXML(host);
                if (vmsxml == null) {
                    return VMSVirtualDomainInfo.NO_VM_STATUS_STRING;
                }
                if (!vmsxml.isSuspended(VMSVirtualDomainInfo.this.getDomainName())) {
                    return "it is not suspended";
                }
                return null;
            }

            @Override
            public void action() {
                VMSVirtualDomainInfo.this.hidePopup();
                VMSXML vxml = VMSVirtualDomainInfo.this.getBrowser().getVMSXML(host);
                if (vxml != null && host != null) {
                    VMSVirtualDomainInfo.this.resume(host);
                }
            }
        };
        items.add(resumeMenuItem);
    }

    void addDestroyMenu(List<UpdatableItem> items, final Host host) {
        MyMenuItem destroyMenuItem = new MyMenuItem(Tools.getString("VMSVirtualDomainInfo.DestroyOn") + host.getName(), DESTROY_ICON, Tools.getString("VMSVirtualDomainInfo.DestroyOn") + host.getName(), new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (!Tools.getConfigData().isAdvancedMode() && VMSVirtualDomainInfo.this.isUsedByCRM()) {
                    return VMSVirtualDomainInfo.IS_USED_BY_CRM_STRING;
                }
                if (VMSVirtualDomainInfo.this.getResource().isNew()) {
                    return VMSVirtualDomainInfo.NOT_APPLIED;
                }
                VMSXML vmsxml = VMSVirtualDomainInfo.this.getBrowser().getVMSXML(host);
                if (vmsxml == null || !vmsxml.getDomainNames().contains(VMSVirtualDomainInfo.this.getDomainName())) {
                    return VMSVirtualDomainInfo.NO_VM_STATUS_STRING;
                }
                if (!vmsxml.isRunning(VMSVirtualDomainInfo.this.getDomainName())) {
                    return "not running";
                }
                return null;
            }

            @Override
            public void action() {
                VMSVirtualDomainInfo.this.hidePopup();
                VMSXML vxml = VMSVirtualDomainInfo.this.getBrowser().getVMSXML(host);
                if (vxml != null && host != null) {
                    VMSVirtualDomainInfo.this.destroy(host);
                }
            }
        };
        items.add(destroyMenuItem);
    }

    void addSuspendMenu(MyMenu advancedSubmenu, final Host host) {
        MyMenuItem suspendMenuItem = new MyMenuItem(Tools.getString("VMSVirtualDomainInfo.SuspendOn") + host.getName(), PAUSE_ICON, Tools.getString("VMSVirtualDomainInfo.SuspendOn") + host.getName(), new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (VMSVirtualDomainInfo.this.getResource().isNew()) {
                    return VMSVirtualDomainInfo.NOT_APPLIED;
                }
                VMSXML vmsxml = VMSVirtualDomainInfo.this.getBrowser().getVMSXML(host);
                if (vmsxml == null || !vmsxml.getDomainNames().contains(VMSVirtualDomainInfo.this.getDomainName())) {
                    return VMSVirtualDomainInfo.NO_VM_STATUS_STRING;
                }
                if (!vmsxml.isRunning(VMSVirtualDomainInfo.this.getDomainName())) {
                    return "not running";
                }
                if (vmsxml.isSuspended(VMSVirtualDomainInfo.this.getDomainName())) {
                    return "it is already suspended";
                }
                return null;
            }

            @Override
            public void action() {
                VMSVirtualDomainInfo.this.hidePopup();
                VMSXML vxml = VMSVirtualDomainInfo.this.getBrowser().getVMSXML(host);
                if (vxml != null && host != null) {
                    VMSVirtualDomainInfo.this.suspend(host);
                }
            }
        };
        advancedSubmenu.add(suspendMenuItem);
    }

    void addResumeAdvancedMenu(MyMenu advancedSubmenu, final Host host) {
        MyMenuItem resumeMenuItem = new MyMenuItem(Tools.getString("VMSVirtualDomainInfo.ResumeOn") + host.getName(), RESUME_ICON, Tools.getString("VMSVirtualDomainInfo.ResumeOn") + host.getName(), new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (VMSVirtualDomainInfo.this.getResource().isNew()) {
                    return VMSVirtualDomainInfo.NOT_APPLIED;
                }
                VMSXML vmsxml = VMSVirtualDomainInfo.this.getBrowser().getVMSXML(host);
                if (vmsxml == null || !vmsxml.getDomainNames().contains(VMSVirtualDomainInfo.this.getDomainName())) {
                    return VMSVirtualDomainInfo.NO_VM_STATUS_STRING;
                }
                if (!vmsxml.isRunning(VMSVirtualDomainInfo.this.getDomainName())) {
                    return "not running";
                }
                if (!vmsxml.isSuspended(VMSVirtualDomainInfo.this.getDomainName())) {
                    return "it is not suspended";
                }
                return null;
            }

            @Override
            public void action() {
                VMSVirtualDomainInfo.this.hidePopup();
                VMSXML vxml = VMSVirtualDomainInfo.this.getBrowser().getVMSXML(host);
                if (vxml != null && host != null) {
                    VMSVirtualDomainInfo.this.resume(host);
                }
            }
        };
        advancedSubmenu.add(resumeMenuItem);
    }

    @Override
    public List<UpdatableItem> createPopup() {
        ArrayList<UpdatableItem> items = new ArrayList<UpdatableItem>();
        for (Host h : this.getBrowser().getClusterHosts()) {
            this.addVncViewersToTheMenu(items, h);
        }
        for (Host h : this.getBrowser().getClusterHosts()) {
            this.addStartMenu(items, h);
        }
        for (Host h : this.getBrowser().getClusterHosts()) {
            this.addShutdownMenu(items, h);
        }
        for (Host h : this.getBrowser().getClusterHosts()) {
            this.addRebootMenu(items, h);
        }
        for (Host h : this.getBrowser().getClusterHosts()) {
            this.addDestroyMenu(items, h);
        }
        for (Host h : this.getBrowser().getClusterHosts()) {
            this.addResumeMenu(items, h);
        }
        items.add(this.getAddNewHardwareMenu(Tools.getString("VMSVirtualDomainInfo.AddNewHardware")));
        MyMenu advancedSubmenu = new MyMenu(Tools.getString("VMSVirtualDomainInfo.MoreOptions"), new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                return null;
            }
        };
        items.add(advancedSubmenu);
        for (Host h : this.getBrowser().getClusterHosts()) {
            this.addSuspendMenu(advancedSubmenu, h);
        }
        for (Host h : this.getBrowser().getClusterHosts()) {
            this.addResumeAdvancedMenu(advancedSubmenu, h);
        }
        MyMenuItem removeMenuItem = new MyMenuItem(Tools.getString("VMSVirtualDomainInfo.RemoveDomain"), ClusterBrowser.REMOVE_ICON, Tools.getString("VMSVirtualDomainInfo.RemoveDomain"), Tools.getString("VMSVirtualDomainInfo.CancelDomain"), ClusterBrowser.REMOVE_ICON, Tools.getString("VMSVirtualDomainInfo.CancelDomain"), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean predicate() {
                return !VMSVirtualDomainInfo.this.getResource().isNew();
            }

            @Override
            public String enablePredicate() {
                if (!Tools.getConfigData().isAdvancedMode() && VMSVirtualDomainInfo.this.isUsedByCRM()) {
                    return VMSVirtualDomainInfo.IS_USED_BY_CRM_STRING;
                }
                for (Host host : VMSVirtualDomainInfo.this.getBrowser().getClusterHosts()) {
                    VMSXML vmsxml = VMSVirtualDomainInfo.this.getBrowser().getVMSXML(host);
                    if (vmsxml == null || !vmsxml.isRunning(VMSVirtualDomainInfo.this.getDomainName())) continue;
                    return "it is running";
                }
                return null;
            }

            @Override
            public void action() {
                VMSVirtualDomainInfo.this.hidePopup();
                VMSVirtualDomainInfo.this.removeMyself(false);
            }
        };
        items.add(removeMenuItem);
        return items;
    }

    @Override
    public ImageIcon getMenuIcon(boolean testOnly) {
        for (Host h : this.getBrowser().getClusterHosts()) {
            VMSXML vmsxml = this.getBrowser().getVMSXML(h);
            if (vmsxml == null || !vmsxml.isRunning(this.getDomainName())) continue;
            return HostBrowser.HOST_ON_ICON;
        }
        return HostBrowser.HOST_OFF_ICON;
    }

    @Override
    public ImageIcon getCategoryIcon(boolean testOnly) {
        return this.getMenuIcon(testOnly);
    }

    void addVncViewersToTheMenu(List<UpdatableItem> items, final Host host) {
        boolean testOnly = false;
        VMSVirtualDomainInfo thisClass = this;
        if (Tools.getConfigData().isTightvnc()) {
            MyMenuItem tightvncViewerMenu = new MyMenuItem(this.getVNCMenuString("TIGHT", host), VNC_ICON, this.getVNCMenuString("TIGHT", host), new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
                private static final long serialVersionUID = 1L;

                @Override
                public String enablePredicate() {
                    if (VMSVirtualDomainInfo.this.getResource().isNew()) {
                        return VMSVirtualDomainInfo.NOT_APPLIED;
                    }
                    VMSXML vmsxml = VMSVirtualDomainInfo.this.getBrowser().getVMSXML(host);
                    if (vmsxml == null) {
                        return VMSVirtualDomainInfo.NO_VM_STATUS_STRING;
                    }
                    if (!vmsxml.isRunning(VMSVirtualDomainInfo.this.getDomainName())) {
                        return "not running";
                    }
                    return null;
                }

                @Override
                public void action() {
                    VMSVirtualDomainInfo.this.hidePopup();
                    VMSXML vxml = VMSVirtualDomainInfo.this.getBrowser().getVMSXML(host);
                    if (vxml != null) {
                        int remotePort = vxml.getRemotePort(VMSVirtualDomainInfo.this.getDomainName());
                        Host host2 = vxml.getHost();
                        if (host2 != null && remotePort > 0) {
                            Tools.startTightVncViewer(host2, remotePort);
                        }
                    }
                }
            };
            items.add(tightvncViewerMenu);
        }
        if (Tools.getConfigData().isUltravnc()) {
            MyMenuItem ultravncViewerMenu = new MyMenuItem(this.getVNCMenuString("ULTRA", host), VNC_ICON, this.getVNCMenuString("ULTRA", host), new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
                private static final long serialVersionUID = 1L;

                @Override
                public String enablePredicate() {
                    if (VMSVirtualDomainInfo.this.getResource().isNew()) {
                        return VMSVirtualDomainInfo.NOT_APPLIED;
                    }
                    VMSXML vmsxml = VMSVirtualDomainInfo.this.getBrowser().getVMSXML(host);
                    if (vmsxml == null) {
                        return VMSVirtualDomainInfo.NO_VM_STATUS_STRING;
                    }
                    if (!vmsxml.isRunning(VMSVirtualDomainInfo.this.getDomainName())) {
                        return "not running";
                    }
                    return null;
                }

                @Override
                public void action() {
                    VMSVirtualDomainInfo.this.hidePopup();
                    VMSXML vxml = VMSVirtualDomainInfo.this.getBrowser().getVMSXML(host);
                    if (vxml != null) {
                        int remotePort = vxml.getRemotePort(VMSVirtualDomainInfo.this.getDomainName());
                        Host host2 = vxml.getHost();
                        if (host2 != null && remotePort > 0) {
                            Tools.startUltraVncViewer(host2, remotePort);
                        }
                    }
                }
            };
            items.add(ultravncViewerMenu);
        }
        if (Tools.getConfigData().isRealvnc()) {
            MyMenuItem realvncViewerMenu = new MyMenuItem(this.getVNCMenuString("REAL", host), VNC_ICON, this.getVNCMenuString("REAL", host), new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
                private static final long serialVersionUID = 1L;

                @Override
                public String enablePredicate() {
                    if (VMSVirtualDomainInfo.this.getResource().isNew()) {
                        return VMSVirtualDomainInfo.NOT_APPLIED;
                    }
                    VMSXML vmsxml = VMSVirtualDomainInfo.this.getBrowser().getVMSXML(host);
                    if (vmsxml == null) {
                        return VMSVirtualDomainInfo.NO_VM_STATUS_STRING;
                    }
                    if (!vmsxml.isRunning(VMSVirtualDomainInfo.this.getDomainName())) {
                        return "not running";
                    }
                    return null;
                }

                @Override
                public void action() {
                    VMSVirtualDomainInfo.this.hidePopup();
                    VMSXML vxml = VMSVirtualDomainInfo.this.getBrowser().getVMSXML(host);
                    if (vxml != null) {
                        int remotePort = vxml.getRemotePort(VMSVirtualDomainInfo.this.getDomainName());
                        Host host2 = vxml.getHost();
                        if (host2 != null && remotePort > 0) {
                            Tools.startRealVncViewer(host2, remotePort);
                        }
                    }
                }
            };
            items.add(realvncViewerMenu);
        }
    }

    @Override
    protected String getParamLongDesc(String param) {
        return SHORTNAME_MAP.get(param);
    }

    @Override
    protected String getParamShortDesc(String param) {
        return SHORTNAME_MAP.get(param);
    }

    @Override
    protected String getParamPreferred(String param) {
        if (this.preferredEmulator != null && "emulator".equals(param)) {
            return this.preferredEmulator;
        }
        return PREFERRED_MAP.get(param);
    }

    @Override
    protected String getParamDefault(String param) {
        return DEFAULTS_MAP.get(param);
    }

    @Override
    protected boolean checkParam(String param, String newValue) {
        if (this.isRequired(param) && (newValue == null || VIRSH_OPTION_KVM.equals(newValue))) {
            return false;
        }
        if ("memory".equals(param)) {
            long mem = Tools.convertToKilobytes(newValue);
            if (mem < 4096L) {
                return false;
            }
            long curMem = Tools.convertToKilobytes(this.getComboBoxValue("currentMemory"));
            if (mem < curMem) {
                return false;
            }
        } else if ("currentMemory".equals(param)) {
            long curMem = Tools.convertToKilobytes(newValue);
            if (curMem < 4096L) {
                return false;
            }
            long mem = Tools.convertToKilobytes(this.getComboBoxValue("memory"));
            if (mem < curMem) {
                this.getWidget("memory", null).setValue(newValue);
            }
        } else if ("domain-type".equals(param)) {
            Widget wi = this.getWidget(param, null);
            if (this.getResource().isNew() && !Tools.areEqual(this.prevType, newValue)) {
                String xenLibPath = "/usr/lib/xen";
                for (Host host : this.getBrowser().getClusterHosts()) {
                    String xlp = host.getXenLibPath();
                    if (xlp == null) continue;
                    xenLibPath = xlp;
                    break;
                }
                String lxcLibPath = "/usr/lib/libvirt";
                for (Host host : this.getBrowser().getClusterHosts()) {
                    String llp = host.getLxcLibPath();
                    if (llp == null) continue;
                    lxcLibPath = llp;
                    break;
                }
                Widget emWi = this.getWidget("emulator", "widget");
                Widget loWi = this.getWidget("loader", "widget");
                Widget voWi = this.getWidget("virsh-options", "widget");
                Widget typeWi = this.getWidget("type", "widget");
                Widget inWi = this.getWidget("init", "widget");
                if (Tools.areEqual(DOMAIN_TYPE_XEN, newValue)) {
                    if (emWi != null) {
                        emWi.setValue(xenLibPath + "/bin/qemu-dm");
                    }
                    if (loWi != null) {
                        loWi.setValue(xenLibPath + "/boot/hvmloader");
                    }
                    if (voWi != null) {
                        voWi.setValue(VIRSH_OPTION_XEN);
                    }
                    if (typeWi != null) {
                        typeWi.setValue(TYPE_HVM);
                    }
                    if (inWi != null) {
                        inWi.setValue(VIRSH_OPTION_KVM);
                    }
                } else if (Tools.areEqual(DOMAIN_TYPE_LXC, newValue)) {
                    if (emWi != null) {
                        emWi.setValue(lxcLibPath + "/libvirt_lxc");
                    }
                    if (loWi != null) {
                        loWi.setValue(VIRSH_OPTION_KVM);
                    }
                    if (voWi != null) {
                        voWi.setValue(VIRSH_OPTION_LXC);
                    }
                    if (typeWi != null) {
                        typeWi.setValue(TYPE_EXE);
                    }
                    if (inWi != null) {
                        inWi.setValue("/bin/sh");
                    }
                } else if (Tools.areEqual(DOMAIN_TYPE_VBOX, newValue)) {
                    if (emWi != null) {
                        emWi.setValue(xenLibPath + VIRSH_OPTION_KVM);
                    }
                    if (loWi != null) {
                        loWi.setValue(xenLibPath + VIRSH_OPTION_KVM);
                    }
                    if (voWi != null) {
                        voWi.setValue(VIRSH_OPTION_VBOX);
                    }
                    if (typeWi != null) {
                        typeWi.setValue(TYPE_HVM);
                    }
                    if (inWi != null) {
                        inWi.setValue(VIRSH_OPTION_KVM);
                    }
                } else if (Tools.areEqual(DOMAIN_TYPE_OPENVZ, newValue)) {
                    if (emWi != null) {
                        emWi.setValue(VIRSH_OPTION_KVM);
                    }
                    if (loWi != null) {
                        loWi.setValue(VIRSH_OPTION_KVM);
                    }
                    if (voWi != null) {
                        voWi.setValue(VIRSH_OPTION_OPENVZ);
                    }
                    if (typeWi != null) {
                        typeWi.setValue(TYPE_EXE);
                    }
                    if (inWi != null) {
                        inWi.setValue("/sbin/init");
                    }
                } else if (Tools.areEqual("uml", newValue)) {
                    if (emWi != null) {
                        emWi.setValue(VIRSH_OPTION_KVM);
                    }
                    if (loWi != null) {
                        loWi.setValue(VIRSH_OPTION_KVM);
                    }
                    if (voWi != null) {
                        voWi.setValue(VIRSH_OPTION_UML);
                    }
                    if (typeWi != null) {
                        typeWi.setValue("uml");
                    }
                    if (inWi != null) {
                        inWi.setValue(VIRSH_OPTION_KVM);
                    }
                } else {
                    if (emWi != null) {
                        emWi.setValue("/usr/bin/kvm");
                    }
                    if (loWi != null) {
                        loWi.setValue(VIRSH_OPTION_KVM);
                    }
                    if (voWi != null) {
                        voWi.setValue(VIRSH_OPTION_KVM);
                    }
                    if (typeWi != null) {
                        typeWi.setValue(TYPE_HVM);
                    }
                    if (inWi != null) {
                        inWi.setValue(VIRSH_OPTION_KVM);
                    }
                }
            }
            this.prevType = wi.getStringValue();
        }
        return true;
    }

    @Override
    public String[] getParametersFromXML() {
        return (String[])VM_PARAMETERS.clone();
    }

    @Override
    protected Object[] getParamPossibleChoices(String param) {
        if ("autostart".equals(param)) {
            return this.autostartPossibleValues;
        }
        if ("virsh-options".equals(param)) {
            return VIRSH_OPTIONS;
        }
        if ("model".equals(param)) {
            LinkedHashSet<String> models = new LinkedHashSet<String>();
            models.add(VIRSH_OPTION_KVM);
            for (Host host : this.getBrowser().getClusterHosts()) {
                models.addAll(host.getCPUMapModels());
            }
            return models.toArray(new String[models.size()]);
        }
        if ("vendor".equals(param)) {
            LinkedHashSet<String> vendors = new LinkedHashSet<String>();
            vendors.add(VIRSH_OPTION_KVM);
            for (Host host : this.getBrowser().getClusterHosts()) {
                vendors.addAll(host.getCPUMapVendors());
            }
            return vendors.toArray(new String[vendors.size()]);
        }
        return POSSIBLE_VALUES.get(param);
    }

    @Override
    protected String getSection(String param) {
        return SECTION_MAP.get(param);
    }

    @Override
    protected boolean isRequired(String param) {
        return false;
    }

    @Override
    protected boolean isInteger(String param) {
        return IS_INTEGER.contains(param);
    }

    @Override
    protected boolean isLabel(String param) {
        return false;
    }

    @Override
    protected boolean isTimeType(String param) {
        return false;
    }

    @Override
    protected boolean isCheckBox(String param) {
        return false;
    }

    @Override
    protected String getParamType(String param) {
        return "undef";
    }

    @Override
    protected Widget.Type getFieldType(String param) {
        return FIELD_TYPES.get(param);
    }

    public void apply(boolean testOnly) {
        if (testOnly) {
            return;
        }
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                VMSVirtualDomainInfo.this.getApplyButton().setEnabled(false);
                VMSVirtualDomainInfo.this.getRevertButton().setEnabled(false);
            }
        });
        this.getInfoPanel();
        this.waitForInfoPanel();
        String[] params = this.getParametersFromXML();
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.setName(this.getComboBoxValue("name"));
        for (String param : this.getParametersFromXML()) {
            String value = this.getComboBoxValue(param);
            parameters.put(param, value);
            this.getResource().setValue(param, value);
        }
        ArrayList<Host> definedOnHosts = new ArrayList<Host>();
        Map<VMSHardwareInfo, Map<String, String>> allModifiedHWP = this.getAllHWParameters(false);
        Map<VMSHardwareInfo, Map<String, String>> allHWP = this.getAllHWParameters(true);
        HashMap<Node, VMSXML> domainNodesToSave = new HashMap<Node, VMSXML>();
        String clusterName = this.getBrowser().getCluster().getName();
        this.getBrowser().vmStatusLock();
        Tools.startProgressIndicator(clusterName, "VM view update");
        for (final Host host : this.getBrowser().getClusterHosts()) {
            Widget hostWi = this.definedOnHostComboBoxHash.get(host.getName());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Widget wizardHostWi = (Widget)VMSVirtualDomainInfo.this.definedOnHostComboBoxHash.get(VMSVirtualDomainInfo.WIZARD_PREFIX + host.getName());
                    if (wizardHostWi != null) {
                        wizardHostWi.setEnabled(false);
                    }
                }
            });
            String value = this.definedOnHostComboBoxHash.get(host.getName()).getStringValue();
            boolean needConsole = this.needConsole();
            if (DEFINED_ON_HOST_TRUE.equals(value)) {
                Node domainNode = null;
                VMSXML vmsxml = null;
                if (this.getResource().isNew()) {
                    vmsxml = new VMSXML(host);
                    this.getBrowser().vmsXMLPut(host, vmsxml);
                    domainNode = vmsxml.createDomainXML(this.getUUID(), this.getDomainName(), parameters, needConsole);
                    for (VMSHardwareInfo hi : allHWP.keySet()) {
                        hi.modifyXML(vmsxml, domainNode, this.getDomainName(), allHWP.get(hi));
                        hi.getResource().setNew(false);
                    }
                    vmsxml.saveAndDefine(domainNode, this.getDomainName(), this.getVirshOptions());
                } else {
                    vmsxml = this.getBrowser().getVMSXML(host);
                    if (vmsxml == null) {
                        vmsxml = new VMSXML(host);
                        this.getBrowser().vmsXMLPut(host, vmsxml);
                    }
                    if (vmsxml.getDomainNames().contains(this.getDomainName())) {
                        domainNode = vmsxml.modifyDomainXML(this.getDomainName(), parameters);
                        if (domainNode != null) {
                            for (VMSHardwareInfo hi : allModifiedHWP.keySet()) {
                                if (!hi.checkResourceFieldsChanged(null, hi.getRealParametersFromXML(), true)) continue;
                                hi.modifyXML(vmsxml, domainNode, this.getDomainName(), allModifiedHWP.get(hi));
                                hi.getResource().setNew(false);
                            }
                        }
                    } else {
                        domainNode = vmsxml.createDomainXML(this.getUUID(), this.getDomainName(), parameters, needConsole);
                        if (domainNode != null) {
                            for (VMSHardwareInfo hi : allHWP.keySet()) {
                                hi.modifyXML(vmsxml, domainNode, this.getDomainName(), allHWP.get(hi));
                                hi.getResource().setNew(false);
                            }
                        }
                    }
                }
                if (domainNode != null) {
                    domainNodesToSave.put(domainNode, vmsxml);
                }
                definedOnHosts.add(host);
                continue;
            }
            VMSXML vmsxml = this.getBrowser().getVMSXML(host);
            if (vmsxml == null || !vmsxml.getDomainNames().contains(this.getDomainName())) continue;
            VIRSH.undefine(host, this.getDomainName(), this.getVirshOptions());
        }
        for (Node dn : domainNodesToSave.keySet()) {
            ((VMSXML)domainNodesToSave.get(dn)).saveAndDefine(dn, this.getDomainName(), this.getVirshOptions());
        }
        for (VMSHardwareInfo hi : allHWP.keySet()) {
            hi.setApplyButtons(null, hi.getRealParametersFromXML());
        }
        if (this.getResource().isNew()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultMutableTreeNode thisNode = VMSVirtualDomainInfo.this.getNode();
                    if (thisNode != null) {
                        Enumeration<TreeNode> eee = thisNode.children();
                        while (eee.hasMoreElements()) {
                            MyButton mb;
                            DefaultMutableTreeNode node = (DefaultMutableTreeNode)eee.nextElement();
                            VMSHardwareInfo vmshi = (VMSHardwareInfo)node.getUserObject();
                            if (vmshi == null || (mb = vmshi.getApplyButton()) == null) continue;
                            mb.setVisible(true);
                        }
                    }
                }
            });
        }
        VIRSH.setParameters(definedOnHosts.toArray(new Host[definedOnHosts.size()]), this.getDomainName(), parameters, this.getVirshOptions());
        this.getResource().setNew(false);
        if (!testOnly) {
            this.storeComboBoxValues(params);
        }
        this.getBrowser().periodicalVMSUpdate(this.getBrowser().getClusterHosts());
        this.updateParameters();
        Tools.stopProgressIndicator(clusterName, "VM view update");
        this.getBrowser().vmStatusUnlock();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Host host : VMSVirtualDomainInfo.this.getBrowser().getClusterHosts()) {
                    Widget hostWi = (Widget)VMSVirtualDomainInfo.this.definedOnHostComboBoxHash.get(host.getName());
                    Widget wizardHostWi = (Widget)VMSVirtualDomainInfo.this.definedOnHostComboBoxHash.get(VMSVirtualDomainInfo.WIZARD_PREFIX + host.getName());
                    if (wizardHostWi == null) continue;
                    wizardHostWi.setEnabled(true);
                }
            }
        });
    }

    protected Map<VMSHardwareInfo, Map<String, String>> getAllHWParameters(boolean allParams) {
        TreeMap<VMSHardwareInfo, Map<String, String>> allParamaters = new TreeMap<VMSHardwareInfo, Map<String, String>>();
        DefaultMutableTreeNode thisNode = this.getNode();
        if (thisNode == null) {
            return allParamaters;
        }
        Enumeration<TreeNode> e = thisNode.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            VMSHardwareInfo hi = (VMSHardwareInfo)node.getUserObject();
            allParamaters.put(hi, hi.getHWParameters(allParams));
        }
        return allParamaters;
    }

    @Override
    protected boolean hasUnitPrefix(String param) {
        return HAS_UNIT_PREFIX.containsKey(param) && HAS_UNIT_PREFIX.get(param) != false;
    }

    @Override
    protected Unit[] getUnits() {
        return new Unit[]{new Unit("K", "K", "KiByte", "KiBytes"), new Unit("M", "M", "MiByte", "MiBytes"), new Unit("G", "G", "GiByte", "GiBytes"), new Unit("T", "T", "TiByte", "TiBytes")};
    }

    protected String getDefaultUnit(String param) {
        return DEFAULT_UNIT.get(param);
    }

    String getDefinedOnString() {
        return this.definedOnString;
    }

    String getRunningOnString() {
        return this.runningOnString;
    }

    @Override
    protected String[] getColumnNames(String tableName) {
        if (HEADER_TABLE.equals(tableName)) {
            return new String[]{"Name", "Defined on", "Status", "Memory", VIRSH_OPTION_KVM};
        }
        if (DISK_TABLE.equals(tableName)) {
            return new String[]{"Virtual Device", "Source", VIRSH_OPTION_KVM};
        }
        if (FILESYSTEM_TABLE.equals(tableName)) {
            return new String[]{"Virtual Device", "Source", VIRSH_OPTION_KVM};
        }
        if (INTERFACES_TABLE.equals(tableName)) {
            return new String[]{"Virtual Interface", "Source", VIRSH_OPTION_KVM};
        }
        if (INPUTDEVS_TABLE.equals(tableName)) {
            return new String[]{"Input Device", VIRSH_OPTION_KVM};
        }
        if (GRAPHICS_TABLE.equals(tableName)) {
            return new String[]{"Graphic Display", VIRSH_OPTION_KVM};
        }
        if (SOUND_TABLE.equals(tableName)) {
            return new String[]{"Sound Device", VIRSH_OPTION_KVM};
        }
        if (SERIAL_TABLE.equals(tableName)) {
            return new String[]{"Serial Device", VIRSH_OPTION_KVM};
        }
        if (PARALLEL_TABLE.equals(tableName)) {
            return new String[]{"Parallel Device", VIRSH_OPTION_KVM};
        }
        if (VIDEO_TABLE.equals(tableName)) {
            return new String[]{"Video Device", VIRSH_OPTION_KVM};
        }
        return new String[0];
    }

    @Override
    protected Object[][] getTableData(String tableName) {
        if (HEADER_TABLE.equals(tableName)) {
            return this.getMainTableData();
        }
        if (DISK_TABLE.equals(tableName)) {
            return this.getDiskTableData();
        }
        if (FILESYSTEM_TABLE.equals(tableName)) {
            return this.getFilesystemTableData();
        }
        if (INTERFACES_TABLE.equals(tableName)) {
            return this.getInterfaceTableData();
        }
        if (INPUTDEVS_TABLE.equals(tableName)) {
            return this.getInputDevTableData();
        }
        if (GRAPHICS_TABLE.equals(tableName)) {
            return this.getGraphicsTableData();
        }
        if (SOUND_TABLE.equals(tableName)) {
            return this.getSoundTableData();
        }
        if (SERIAL_TABLE.equals(tableName)) {
            return this.getSerialTableData();
        }
        if (PARALLEL_TABLE.equals(tableName)) {
            return this.getParallelTableData();
        }
        if (VIDEO_TABLE.equals(tableName)) {
            return this.getVideoTableData();
        }
        return new Object[0][];
    }

    protected Object[][] getMainTableData() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        String domainName = this.getDomainName();
        ImageIcon hostIcon = HostBrowser.HOST_OFF_ICON_LARGE;
        Color newColor = Browser.PANEL_BACKGROUND;
        for (Host host : this.getBrowser().getClusterHosts()) {
            VMSXML vxml = this.getBrowser().getVMSXML(host);
            if (vxml == null) continue;
            if (!vxml.isRunning(domainName)) break;
            newColor = host.getPmColors()[0];
            if (vxml.isSuspended(domainName)) {
                hostIcon = PAUSE_ICON;
                break;
            }
            hostIcon = HostBrowser.HOST_ON_ICON_LARGE;
            break;
        }
        this.rowColor = newColor;
        if (domainName != null) {
            MyButton domainNameLabel = new MyButton(domainName, hostIcon);
            domainNameLabel.setOpaque(true);
            MyButton removeDomain = new MyButton("Remove", ClusterBrowser.REMOVE_ICON_SMALL, "Remove " + domainName + " domain");
            removeDomain.miniButton();
            rows.add(new Object[]{domainNameLabel, this.getDefinedOnString(), this.getRunningOnString(), this.getResource().getValue("memory"), removeDomain});
        }
        return (Object[][])rows.toArray((T[])new Object[rows.size()][]);
    }

    protected Map<String, VMSXML.DiskData> getDisks() {
        Map<String, VMSXML.DiskData> disks = null;
        for (Host host : this.getDefinedOnHosts()) {
            VMSXML vxml = this.getBrowser().getVMSXML(host);
            if (vxml == null) continue;
            disks = vxml.getDisks(this.getDomainName());
            break;
        }
        return disks;
    }

    protected Object[] getDiskDataRow(String targetDev, Map<String, VMSDiskInfo> dkti, Map<String, VMSXML.DiskData> disks, boolean opaque) {
        if (disks == null) {
            return new Object[0];
        }
        MyButton removeBtn = new MyButton("Remove", ClusterBrowser.REMOVE_ICON_SMALL, "Remove " + targetDev);
        removeBtn.miniButton();
        VMSXML.DiskData diskData = disks.get(targetDev);
        if (diskData == null) {
            return new Object[]{targetDev, "unknown", removeBtn};
        }
        StringBuilder target = new StringBuilder(10);
        target.append(diskData.getTargetBusType());
        target.append(" : /dev/");
        target.append(targetDev);
        if (dkti != null) {
            this.mDiskToInfoLock.lock();
            VMSDiskInfo vdi = this.diskToInfo.get(targetDev);
            this.mDiskToInfoLock.unlock();
            dkti.put(target.toString(), vdi);
        }
        MyButton targetDevLabel = new MyButton(target.toString(), BlockDevInfo.HARDDISK_ICON_LARGE);
        targetDevLabel.setOpaque(opaque);
        StringBuilder source = new StringBuilder(20);
        String s = diskData.getSourceDev();
        if (s == null) {
            s = diskData.getSourceFile();
        }
        if (s != null) {
            source.append(diskData.getType());
            source.append(" : ");
            source.append(s);
        }
        return new Object[]{targetDevLabel, source.toString(), removeBtn};
    }

    List<Host> getDefinedOnHosts() {
        ArrayList<Host> definedOn = new ArrayList<Host>();
        for (Host h : this.getBrowser().getClusterHosts()) {
            if (this.getResource().isNew()) {
                String value = this.definedOnHostComboBoxHash.get(h.getName()).getStringValue();
                if (!DEFINED_ON_HOST_TRUE.equals(value)) continue;
                definedOn.add(h);
                continue;
            }
            VMSXML vmsxml = this.getBrowser().getVMSXML(h);
            if (vmsxml == null || !vmsxml.getDomainNames().contains(this.getDomainName())) continue;
            definedOn.add(h);
        }
        return definedOn;
    }

    private Object[][] getDiskTableData() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Map<String, VMSXML.DiskData> disks = this.getDisks();
        HashMap<String, VMSDiskInfo> dkti = new HashMap<String, VMSDiskInfo>();
        if (disks != null && !disks.isEmpty()) {
            for (String targetDev : disks.keySet()) {
                Object[] row = this.getDiskDataRow(targetDev, dkti, disks, false);
                rows.add(row);
            }
        }
        this.mDiskToInfoLock.lock();
        this.diskKeyToInfo = dkti;
        this.mDiskToInfoLock.unlock();
        return (Object[][])rows.toArray((T[])new Object[rows.size()][]);
    }

    protected Map<String, VMSXML.FilesystemData> getFilesystems() {
        Map<String, VMSXML.FilesystemData> filesystems = null;
        for (Host host : this.getDefinedOnHosts()) {
            VMSXML vxml = this.getBrowser().getVMSXML(host);
            if (vxml == null) continue;
            filesystems = vxml.getFilesystems(this.getDomainName());
            break;
        }
        return filesystems;
    }

    protected Object[] getFilesystemDataRow(String targetDev, Map<String, VMSFilesystemInfo> dkti, Map<String, VMSXML.FilesystemData> filesystems, boolean opaque) {
        if (filesystems == null) {
            return new Object[0];
        }
        MyButton removeBtn = new MyButton("Remove", ClusterBrowser.REMOVE_ICON_SMALL, "Remove " + targetDev);
        removeBtn.miniButton();
        VMSXML.FilesystemData filesystemData = filesystems.get(targetDev);
        if (filesystemData == null) {
            return new Object[]{targetDev, "unknown", removeBtn};
        }
        StringBuilder target = new StringBuilder(10);
        target.append(filesystemData.getTargetDir());
        if (dkti != null) {
            this.mFilesystemToInfoLock.lock();
            VMSFilesystemInfo vdi = this.filesystemToInfo.get(targetDev);
            this.mFilesystemToInfoLock.unlock();
            dkti.put(target.toString(), vdi);
        }
        MyButton targetDevLabel = new MyButton(target.toString(), BlockDevInfo.HARDDISK_ICON_LARGE);
        targetDevLabel.setOpaque(opaque);
        StringBuilder source = new StringBuilder(20);
        String s = filesystemData.getSourceDir();
        if (s == null) {
            s = filesystemData.getSourceDir();
        }
        if (s != null) {
            source.append(filesystemData.getType());
            source.append(" : ");
            source.append(s);
        }
        return new Object[]{targetDevLabel, source.toString(), removeBtn};
    }

    private Object[][] getFilesystemTableData() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Map<String, VMSXML.FilesystemData> filesystems = this.getFilesystems();
        HashMap<String, VMSFilesystemInfo> dkti = new HashMap<String, VMSFilesystemInfo>();
        if (filesystems != null && !filesystems.isEmpty()) {
            for (String targetDev : filesystems.keySet()) {
                Object[] row = this.getFilesystemDataRow(targetDev, dkti, filesystems, false);
                rows.add(row);
            }
        }
        this.mFilesystemToInfoLock.lock();
        this.filesystemKeyToInfo = dkti;
        this.mFilesystemToInfoLock.unlock();
        return (Object[][])rows.toArray((T[])new Object[rows.size()][]);
    }

    protected Object[] getInterfaceDataRow(String mac, Map<String, VMSInterfaceInfo> iToInfo, Map<String, VMSXML.InterfaceData> interfaces, boolean opaque) {
        if (interfaces == null) {
            return new Object[0];
        }
        MyButton removeBtn = new MyButton("Remove", ClusterBrowser.REMOVE_ICON_SMALL, "Remove " + mac);
        removeBtn.miniButton();
        VMSXML.InterfaceData interfaceData = interfaces.get(mac);
        if (interfaceData == null) {
            return new Object[]{mac, "unknown", removeBtn};
        }
        StringBuilder interf = new StringBuilder(20);
        interf.append(mac);
        String dev = interfaceData.getTargetDev();
        if (dev != null) {
            interf.append(' ');
            interf.append(dev);
        }
        if (iToInfo != null) {
            VMSInterfaceInfo vii = this.interfaceToInfo.get(mac);
            iToInfo.put(interf.toString(), vii);
        }
        MyButton iLabel = new MyButton(interf.toString(), NetInfo.NET_I_ICON_LARGE);
        iLabel.setOpaque(opaque);
        StringBuilder source = new StringBuilder(20);
        String type = interfaceData.getType();
        String s = "network".equals(type) ? interfaceData.getSourceNetwork() : interfaceData.getSourceBridge();
        if (s != null) {
            source.append(type);
            source.append(" : ");
            source.append(s);
        }
        return new Object[]{iLabel, source.toString(), removeBtn};
    }

    protected Object[] getInputDevDataRow(String index, Map<String, VMSInputDevInfo> iToInfo, Map<String, VMSXML.InputDevData> inputDevs, boolean opaque) {
        if (inputDevs == null) {
            return new Object[0];
        }
        MyButton removeBtn = new MyButton("Remove", ClusterBrowser.REMOVE_ICON_SMALL, "Remove " + index);
        removeBtn.miniButton();
        VMSXML.InputDevData inputDevData = inputDevs.get(index);
        if (inputDevData == null) {
            return new Object[]{index + ": unknown", VIRSH_OPTION_KVM, removeBtn};
        }
        if (iToInfo != null) {
            VMSInputDevInfo vidi = this.inputDevToInfo.get(index);
            iToInfo.put(index, vidi);
        }
        MyButton iLabel = new MyButton(index, null);
        iLabel.setOpaque(opaque);
        return new Object[]{iLabel, removeBtn};
    }

    protected Object[] getGraphicsDataRow(String index, Map<String, VMSGraphicsInfo> iToInfo, Map<String, VMSXML.GraphicsData> graphicDisplays, boolean opaque) {
        if (graphicDisplays == null) {
            return new Object[0];
        }
        MyButton removeBtn = new MyButton("Remove", ClusterBrowser.REMOVE_ICON_SMALL, "Remove " + index);
        removeBtn.miniButton();
        VMSXML.GraphicsData graphicsData = graphicDisplays.get(index);
        if (graphicsData == null) {
            return new Object[]{index + ": unknown", VIRSH_OPTION_KVM, removeBtn};
        }
        String type = graphicsData.getType();
        if (iToInfo != null) {
            VMSGraphicsInfo vidi = this.graphicsToInfo.get(index);
            iToInfo.put(index, vidi);
        }
        MyButton iLabel = new MyButton(index, VNC_ICON);
        iLabel.setOpaque(opaque);
        return new Object[]{iLabel, removeBtn};
    }

    protected Object[] getSoundDataRow(String index, Map<String, VMSSoundInfo> iToInfo, Map<String, VMSXML.SoundData> sounds, boolean opaque) {
        if (sounds == null) {
            return new Object[0];
        }
        MyButton removeBtn = new MyButton("Remove", ClusterBrowser.REMOVE_ICON_SMALL, "Remove " + index);
        removeBtn.miniButton();
        VMSXML.SoundData soundData = sounds.get(index);
        if (soundData == null) {
            return new Object[]{index + ": unknown", VIRSH_OPTION_KVM, removeBtn};
        }
        String model = soundData.getModel();
        if (iToInfo != null) {
            VMSSoundInfo vidi = this.soundToInfo.get(index);
            iToInfo.put(index, vidi);
        }
        MyButton iLabel = new MyButton(model, null);
        iLabel.setOpaque(opaque);
        return new Object[]{iLabel, removeBtn};
    }

    protected Object[] getSerialDataRow(String index, Map<String, VMSSerialInfo> iToInfo, Map<String, VMSXML.SerialData> serials, boolean opaque) {
        if (serials == null) {
            return new Object[0];
        }
        MyButton removeBtn = new MyButton("Remove", ClusterBrowser.REMOVE_ICON_SMALL, "Remove " + index);
        removeBtn.miniButton();
        VMSXML.SerialData serialData = serials.get(index);
        if (serialData == null) {
            return new Object[]{index + ": unknown", VIRSH_OPTION_KVM, removeBtn};
        }
        String type = serialData.getType();
        if (iToInfo != null) {
            VMSSerialInfo vidi = this.serialToInfo.get(index);
            iToInfo.put(index, vidi);
        }
        MyButton iLabel = new MyButton(index, null);
        iLabel.setOpaque(opaque);
        return new Object[]{iLabel, removeBtn};
    }

    protected Object[] getParallelDataRow(String index, Map<String, VMSParallelInfo> iToInfo, Map<String, VMSXML.ParallelData> parallels, boolean opaque) {
        if (parallels == null) {
            return new Object[0];
        }
        MyButton removeBtn = new MyButton("Remove", ClusterBrowser.REMOVE_ICON_SMALL, "Remove " + index);
        removeBtn.miniButton();
        VMSXML.ParallelData parallelData = parallels.get(index);
        if (parallelData == null) {
            return new Object[]{index + ": unknown", VIRSH_OPTION_KVM, removeBtn};
        }
        String type = parallelData.getType();
        if (iToInfo != null) {
            VMSParallelInfo vidi = this.parallelToInfo.get(index);
            iToInfo.put(index, vidi);
        }
        MyButton iLabel = new MyButton(index, null);
        iLabel.setOpaque(opaque);
        return new Object[]{iLabel, removeBtn};
    }

    protected Object[] getVideoDataRow(String index, Map<String, VMSVideoInfo> iToInfo, Map<String, VMSXML.VideoData> videos, boolean opaque) {
        if (videos == null) {
            return new Object[0];
        }
        MyButton removeBtn = new MyButton("Remove", ClusterBrowser.REMOVE_ICON_SMALL, "Remove " + index);
        removeBtn.miniButton();
        VMSXML.VideoData videoData = videos.get(index);
        if (videoData == null) {
            return new Object[]{index + ": unknown", VIRSH_OPTION_KVM, removeBtn};
        }
        String modelType = videoData.getModelType();
        if (iToInfo != null) {
            VMSVideoInfo vidi = this.videoToInfo.get(index);
            iToInfo.put(index, vidi);
        }
        MyButton iLabel = new MyButton(modelType, null);
        iLabel.setOpaque(opaque);
        return new Object[]{iLabel, removeBtn};
    }

    protected Map<String, VMSXML.InterfaceData> getInterfaces() {
        Map<String, VMSXML.InterfaceData> interfaces = null;
        for (Host host : this.getDefinedOnHosts()) {
            VMSXML vxml = this.getBrowser().getVMSXML(host);
            if (vxml == null) continue;
            interfaces = vxml.getInterfaces(this.getDomainName());
            break;
        }
        return interfaces;
    }

    private Object[][] getInputDevTableData() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Map<String, VMSXML.InputDevData> inputDevs = this.getInputDevs();
        HashMap<String, VMSInputDevInfo> iToInfo = new HashMap<String, VMSInputDevInfo>();
        if (inputDevs != null) {
            for (String index : inputDevs.keySet()) {
                Object[] row = this.getInputDevDataRow(index, iToInfo, inputDevs, false);
                rows.add(row);
            }
        }
        this.mInputDevToInfoLock.lock();
        this.inputDevKeyToInfo = iToInfo;
        this.mInputDevToInfoLock.unlock();
        return (Object[][])rows.toArray((T[])new Object[rows.size()][]);
    }

    private Object[][] getGraphicsTableData() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Map<String, VMSXML.GraphicsData> graphicDisplays = this.getGraphicDisplays();
        HashMap<String, VMSGraphicsInfo> iToInfo = new HashMap<String, VMSGraphicsInfo>();
        if (graphicDisplays != null) {
            for (String index : graphicDisplays.keySet()) {
                Object[] row = this.getGraphicsDataRow(index, iToInfo, graphicDisplays, false);
                rows.add(row);
            }
        }
        this.mGraphicsToInfoLock.lock();
        this.graphicsKeyToInfo = iToInfo;
        this.mGraphicsToInfoLock.unlock();
        return (Object[][])rows.toArray((T[])new Object[rows.size()][]);
    }

    private Object[][] getSoundTableData() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Map<String, VMSXML.SoundData> sounds = this.getSounds();
        HashMap<String, VMSSoundInfo> iToInfo = new HashMap<String, VMSSoundInfo>();
        if (sounds != null) {
            for (String index : sounds.keySet()) {
                Object[] row = this.getSoundDataRow(index, iToInfo, sounds, false);
                rows.add(row);
            }
        }
        this.mSoundToInfoLock.lock();
        this.soundKeyToInfo = iToInfo;
        this.mSoundToInfoLock.unlock();
        return (Object[][])rows.toArray((T[])new Object[rows.size()][]);
    }

    private Object[][] getSerialTableData() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Map<String, VMSXML.SerialData> serials = this.getSerials();
        HashMap<String, VMSSerialInfo> iToInfo = new HashMap<String, VMSSerialInfo>();
        if (serials != null) {
            for (String index : serials.keySet()) {
                Object[] row = this.getSerialDataRow(index, iToInfo, serials, false);
                rows.add(row);
            }
        }
        this.mSerialToInfoLock.lock();
        this.serialKeyToInfo = iToInfo;
        this.mSerialToInfoLock.unlock();
        return (Object[][])rows.toArray((T[])new Object[rows.size()][]);
    }

    private Object[][] getParallelTableData() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Map<String, VMSXML.ParallelData> parallels = this.getParallels();
        HashMap<String, VMSParallelInfo> iToInfo = new HashMap<String, VMSParallelInfo>();
        if (parallels != null) {
            for (String index : parallels.keySet()) {
                Object[] row = this.getParallelDataRow(index, iToInfo, parallels, false);
                rows.add(row);
            }
        }
        this.mParallelToInfoLock.lock();
        this.parallelKeyToInfo = iToInfo;
        this.mParallelToInfoLock.unlock();
        return (Object[][])rows.toArray((T[])new Object[rows.size()][]);
    }

    private Object[][] getVideoTableData() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Map<String, VMSXML.VideoData> videos = this.getVideos();
        HashMap<String, VMSVideoInfo> iToInfo = new HashMap<String, VMSVideoInfo>();
        if (videos != null) {
            for (String index : videos.keySet()) {
                Object[] row = this.getVideoDataRow(index, iToInfo, videos, false);
                rows.add(row);
            }
        }
        this.mVideoToInfoLock.lock();
        this.videoKeyToInfo = iToInfo;
        this.mVideoToInfoLock.unlock();
        return (Object[][])rows.toArray((T[])new Object[rows.size()][]);
    }

    protected Map<String, VMSXML.InputDevData> getInputDevs() {
        Map<String, VMSXML.InputDevData> inputDevs = null;
        for (Host host : this.getDefinedOnHosts()) {
            VMSXML vxml = this.getBrowser().getVMSXML(host);
            if (vxml == null) continue;
            inputDevs = vxml.getInputDevs(this.getDomainName());
            break;
        }
        return inputDevs;
    }

    protected Map<String, VMSXML.GraphicsData> getGraphicDisplays() {
        Map<String, VMSXML.GraphicsData> graphicDisplays = null;
        for (Host host : this.getDefinedOnHosts()) {
            VMSXML vxml = this.getBrowser().getVMSXML(host);
            if (vxml == null) continue;
            graphicDisplays = vxml.getGraphicDisplays(this.getDomainName());
            break;
        }
        return graphicDisplays;
    }

    protected Map<String, VMSXML.SoundData> getSounds() {
        Map<String, VMSXML.SoundData> sounds = null;
        for (Host host : this.getDefinedOnHosts()) {
            VMSXML vxml = this.getBrowser().getVMSXML(host);
            if (vxml == null) continue;
            sounds = vxml.getSounds(this.getDomainName());
            break;
        }
        return sounds;
    }

    protected Map<String, VMSXML.SerialData> getSerials() {
        Map<String, VMSXML.SerialData> serials = null;
        for (Host host : this.getDefinedOnHosts()) {
            VMSXML vxml = this.getBrowser().getVMSXML(host);
            if (vxml == null) continue;
            serials = vxml.getSerials(this.getDomainName());
            break;
        }
        return serials;
    }

    protected Map<String, VMSXML.ParallelData> getParallels() {
        Map<String, VMSXML.ParallelData> parallels = null;
        for (Host host : this.getDefinedOnHosts()) {
            VMSXML vxml = this.getBrowser().getVMSXML(host);
            if (vxml == null) continue;
            parallels = vxml.getParallels(this.getDomainName());
            break;
        }
        return parallels;
    }

    protected Map<String, VMSXML.VideoData> getVideos() {
        Map<String, VMSXML.VideoData> videos = null;
        for (Host host : this.getDefinedOnHosts()) {
            VMSXML vxml = this.getBrowser().getVMSXML(host);
            if (vxml == null) continue;
            videos = vxml.getVideos(this.getDomainName());
            break;
        }
        return videos;
    }

    private Object[][] getInterfaceTableData() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Map<String, VMSXML.InterfaceData> interfaces = this.getInterfaces();
        HashMap<String, VMSInterfaceInfo> iToInfo = new HashMap<String, VMSInterfaceInfo>();
        if (interfaces != null) {
            for (String mac : interfaces.keySet()) {
                Object[] row = this.getInterfaceDataRow(mac, iToInfo, interfaces, false);
                rows.add(row);
            }
        }
        this.mInterfaceToInfoLock.lock();
        this.interfaceKeyToInfo = iToInfo;
        this.mInterfaceToInfoLock.unlock();
        return (Object[][])rows.toArray((T[])new Object[rows.size()][]);
    }

    @Override
    protected void rowClicked(String tableName, String key, final int column) {
        if (HEADER_TABLE.equals(tableName)) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (HEADER_DEFAULT_WIDTHS.containsKey(column)) {
                        VMSVirtualDomainInfo.this.removeMyself(false);
                    } else {
                        VMSVirtualDomainInfo.this.getBrowser().getVMSInfo().selectMyself();
                    }
                }
            });
            thread.start();
        } else if (DISK_TABLE.equals(tableName)) {
            this.mDiskToInfoLock.lock();
            final VMSDiskInfo vdi = this.diskKeyToInfo.get(key);
            this.mDiskToInfoLock.unlock();
            if (vdi != null) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (DISK_DEFAULT_WIDTHS.containsKey(column)) {
                            vdi.removeMyself(false);
                        } else {
                            vdi.selectMyself();
                        }
                    }
                });
                thread.start();
            }
        } else if (FILESYSTEM_TABLE.equals(tableName)) {
            this.mFilesystemToInfoLock.lock();
            final VMSFilesystemInfo vfi = this.filesystemKeyToInfo.get(key);
            this.mFilesystemToInfoLock.unlock();
            if (vfi != null) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (FILESYSTEM_DEFAULT_WIDTHS.containsKey(column)) {
                            vfi.removeMyself(false);
                        } else {
                            vfi.selectMyself();
                        }
                    }
                });
                thread.start();
            }
        } else if (INTERFACES_TABLE.equals(tableName)) {
            this.mInterfaceToInfoLock.lock();
            final VMSInterfaceInfo vii = this.interfaceKeyToInfo.get(key);
            this.mInterfaceToInfoLock.unlock();
            if (vii != null) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (INTERFACES_DEFAULT_WIDTHS.containsKey(column)) {
                            vii.removeMyself(false);
                        } else {
                            vii.selectMyself();
                        }
                    }
                });
                thread.start();
            }
        } else if (INPUTDEVS_TABLE.equals(tableName)) {
            this.mInputDevToInfoLock.lock();
            final VMSInputDevInfo vidi = this.inputDevKeyToInfo.get(key);
            this.mInputDevToInfoLock.unlock();
            if (vidi != null) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (INPUTDEVS_DEFAULT_WIDTHS.containsKey(column)) {
                            vidi.removeMyself(false);
                        } else {
                            vidi.selectMyself();
                        }
                    }
                });
                thread.start();
            }
        } else if (GRAPHICS_TABLE.equals(tableName)) {
            this.mGraphicsToInfoLock.lock();
            final VMSGraphicsInfo vgi = this.graphicsKeyToInfo.get(key);
            this.mGraphicsToInfoLock.unlock();
            if (vgi != null) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (GRAPHICS_DEFAULT_WIDTHS.containsKey(column)) {
                            vgi.removeMyself(false);
                        } else {
                            vgi.selectMyself();
                        }
                    }
                });
                thread.start();
            }
        } else if (SOUND_TABLE.equals(tableName)) {
            this.mSoundToInfoLock.lock();
            final VMSSoundInfo vsi = this.soundKeyToInfo.get(key);
            this.mSoundToInfoLock.unlock();
            if (vsi != null) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (SOUND_DEFAULT_WIDTHS.containsKey(column)) {
                            vsi.removeMyself(false);
                        } else {
                            vsi.selectMyself();
                        }
                    }
                });
                thread.start();
            }
        } else if (SERIAL_TABLE.equals(tableName)) {
            this.mSerialToInfoLock.lock();
            final VMSSerialInfo vsi = this.serialKeyToInfo.get(key);
            this.mSerialToInfoLock.unlock();
            if (vsi != null) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (SERIAL_DEFAULT_WIDTHS.containsKey(column)) {
                            vsi.removeMyself(false);
                        } else {
                            vsi.selectMyself();
                        }
                    }
                });
                thread.start();
            }
        } else if (PARALLEL_TABLE.equals(tableName)) {
            this.mParallelToInfoLock.lock();
            final VMSParallelInfo vpi = this.parallelKeyToInfo.get(key);
            this.mParallelToInfoLock.unlock();
            if (vpi != null) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (PARALLEL_DEFAULT_WIDTHS.containsKey(column)) {
                            vpi.removeMyself(false);
                        } else {
                            vpi.selectMyself();
                        }
                    }
                });
                thread.start();
            }
        } else if (VIDEO_TABLE.equals(tableName)) {
            this.mVideoToInfoLock.lock();
            final VMSVideoInfo vvi = this.videoKeyToInfo.get(key);
            this.mVideoToInfoLock.unlock();
            if (vvi != null) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (VIDEO_DEFAULT_WIDTHS.containsKey(column)) {
                            vvi.removeMyself(false);
                        } else {
                            vvi.selectMyself();
                        }
                    }
                });
                thread.start();
            }
        }
    }

    @Override
    protected Color getTableRowColor(String tableName, String key) {
        if (HEADER_TABLE.equals(tableName)) {
            return this.rowColor;
        }
        return Browser.PANEL_BACKGROUND;
    }

    @Override
    protected int getTableColumnAlignment(String tableName, int column) {
        if (column == 3 && HEADER_TABLE.equals(tableName)) {
            return 4;
        }
        return 2;
    }

    @Override
    protected Info getTableInfo(String tableName, String key) {
        if (HEADER_TABLE.equals(tableName)) {
            return this;
        }
        if (DISK_TABLE.equals(tableName)) {
            this.mDiskToInfoLock.lock();
            Info info = this.diskToInfo.get(key);
            this.mDiskToInfoLock.unlock();
            return info;
        }
        if (FILESYSTEM_TABLE.equals(tableName)) {
            this.mFilesystemToInfoLock.lock();
            Info info = this.filesystemToInfo.get(key);
            this.mFilesystemToInfoLock.unlock();
            return info;
        }
        if (INTERFACES_TABLE.equals(tableName)) {
            return this.interfaceToInfo.get(key);
        }
        if (INPUTDEVS_TABLE.equals(tableName)) {
            return this.inputDevToInfo.get(key);
        }
        if (GRAPHICS_TABLE.equals(tableName)) {
            return this.graphicsToInfo.get(key);
        }
        if (SOUND_TABLE.equals(tableName)) {
            return this.soundToInfo.get(key);
        }
        if (SERIAL_TABLE.equals(tableName)) {
            return this.serialToInfo.get(key);
        }
        if (PARALLEL_TABLE.equals(tableName)) {
            return this.parallelToInfo.get(key);
        }
        if (VIDEO_TABLE.equals(tableName)) {
            return this.videoToInfo.get(key);
        }
        return null;
    }

    protected boolean isDevice(String dev) {
        this.mDiskToInfoLock.lock();
        boolean is = this.diskToInfo.containsKey(dev);
        this.mDiskToInfoLock.unlock();
        return is;
    }

    @Override
    protected boolean isAdvanced(String param) {
        if (!this.getResource().isNew() && "name".equals(param)) {
            return true;
        }
        return IS_ADVANCED.contains(param);
    }

    @Override
    protected String isEnabled(String param) {
        String libvirtVersion = this.getBrowser().getCluster().getMinLibvirtVersion();
        if (!this.getResource().isNew() && "name".equals(param)) {
            return VIRSH_OPTION_KVM;
        }
        if (REQUIRED_VERSION.containsKey(param)) {
            String rv = REQUIRED_VERSION.get(param);
            try {
                if (Tools.compareVersions(rv, libvirtVersion) > 0) {
                    return Tools.getString("VMSVirtualDomainInfo.AvailableInVersion").replace("@VERSION@", rv);
                }
            }
            catch (Exceptions.IllegalVersionException e) {
                Tools.appWarning(e.getMessage(), e);
                return Tools.getString("VMSVirtualDomainInfo.AvailableInVersion").replace("@VERSION@", rv);
            }
        }
        return null;
    }

    @Override
    protected boolean isEnabledOnlyInAdvancedMode(String param) {
        return "memory".equals(param);
    }

    @Override
    protected ConfigData.AccessType getAccessType(String param) {
        return ConfigData.AccessType.ADMIN;
    }

    @Override
    protected String getParamRegexp(String param) {
        if ("name".equals(param)) {
            return "^[\\w-]+$";
        }
        return super.getParamRegexp(param);
    }

    @Override
    public boolean checkResourceFieldsChanged(String param, String[] params) {
        DefaultMutableTreeNode thisNode = this.getNode();
        if (thisNode == null) {
            return false;
        }
        boolean changed = false;
        for (Host host : this.getBrowser().getClusterHosts()) {
            if (!this.definedOnHostComboBoxHash.containsKey(host.getName())) continue;
            String value = this.definedOnHostComboBoxHash.get(host.getName()).getStringValue();
            VMSXML vmsxml = this.getBrowser().getVMSXML(host);
            if ((vmsxml == null || !this.getResource().isNew() && !vmsxml.getDomainNames().contains(this.getDomainName())) && DEFINED_ON_HOST_TRUE.equals(value)) {
                changed = true;
                continue;
            }
            if (vmsxml == null || !vmsxml.getDomainNames().contains(this.getDomainName()) || !DEFINED_ON_HOST_FALSE.equals(value)) continue;
            changed = true;
        }
        Enumeration<TreeNode> eee = thisNode.children();
        while (eee.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)eee.nextElement();
            VMSHardwareInfo vmshi = (VMSHardwareInfo)node.getUserObject();
            if (!vmshi.checkResourceFieldsChanged(null, vmshi.getRealParametersFromXML(), true)) continue;
            changed = true;
        }
        boolean ch = super.checkResourceFieldsChanged(param, params) || changed;
        return ch;
    }

    @Override
    public boolean checkResourceFieldsCorrect(String param, String[] params) {
        DefaultMutableTreeNode thisNode = this.getNode();
        if (thisNode == null) {
            return false;
        }
        boolean cor = false;
        for (Host host : this.getBrowser().getClusterHosts()) {
            if (!this.definedOnHostComboBoxHash.containsKey(host.getName())) continue;
            Widget hostWi = this.definedOnHostComboBoxHash.get(host.getName());
            Widget wizardHostWi = this.definedOnHostComboBoxHash.get(WIZARD_PREFIX + host.getName());
            String value = hostWi.getStringValue();
            VMSXML vmsxml = this.getBrowser().getVMSXML(host);
            String savedValue = vmsxml != null && vmsxml.getDomainNames().contains(this.getDomainName()) ? DEFINED_ON_HOST_TRUE : DEFINED_ON_HOST_FALSE;
            hostWi.setBackground(value, savedValue, false);
            if (wizardHostWi != null) {
                wizardHostWi.setBackground(value, savedValue, false);
            }
            if (!DEFINED_ON_HOST_TRUE.equals(value)) continue;
            cor = true;
        }
        if (!cor) {
            for (String key : this.definedOnHostComboBoxHash.keySet()) {
                this.definedOnHostComboBoxHash.get(key).wrongValue();
            }
        }
        Enumeration<TreeNode> eee = thisNode.children();
        while (eee.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)eee.nextElement();
            VMSHardwareInfo vmshi = (VMSHardwareInfo)node.getUserObject();
            if (vmshi.checkResourceFieldsCorrect(null, vmshi.getRealParametersFromXML(), true)) continue;
            cor = false;
        }
        return super.checkResourceFieldsCorrect(null, params) && cor;
    }

    @Override
    protected Widget createWidget(String param, String prefix, int width) {
        Widget paramWi = super.createWidget(param, prefix, width);
        if ("boot".equals(param) || "boot2".equals(param)) {
            paramWi.setAlwaysEditable(false);
        }
        return paramWi;
    }

    @Override
    public void removeMyself(boolean testOnly) {
        if (this.getResource().isNew()) {
            super.removeMyself(testOnly);
            this.getResource().setNew(false);
            this.removeNode();
            return;
        }
        String desc = Tools.getString("VMSVirtualDomainInfo.confirmRemove.Description");
        String dn = this.getDomainName();
        if (dn == null) {
            dn = VIRSH_OPTION_KVM;
        }
        desc = desc.replaceAll("@DOMAIN@", Matcher.quoteReplacement(dn));
        if (Tools.confirmDialog(Tools.getString("VMSVirtualDomainInfo.confirmRemove.Title"), desc, Tools.getString("VMSVirtualDomainInfo.confirmRemove.Yes"), Tools.getString("VMSVirtualDomainInfo.confirmRemove.No"))) {
            this.removeMyselfNoConfirm(testOnly);
            this.getResource().setNew(false);
        }
    }

    protected void removeMyselfNoConfirm(boolean testOnly) {
        for (Host h : this.getBrowser().getClusterHosts()) {
            VMSXML vmsxml = this.getBrowser().getVMSXML(h);
            if (vmsxml == null || !vmsxml.getDomainNames().contains(this.getDomainName())) continue;
            VIRSH.undefine(h, this.getDomainName(), this.getVirshOptions());
        }
        this.getBrowser().periodicalVMSUpdate(this.getBrowser().getClusterHosts());
        this.removeNode();
    }

    @Override
    protected Map<Integer, Integer> getDefaultWidths(String tableName) {
        if (HEADER_TABLE.equals(tableName)) {
            return HEADER_DEFAULT_WIDTHS;
        }
        if (DISK_TABLE.equals(tableName)) {
            return DISK_DEFAULT_WIDTHS;
        }
        if (FILESYSTEM_TABLE.equals(tableName)) {
            return FILESYSTEM_DEFAULT_WIDTHS;
        }
        if (INTERFACES_TABLE.equals(tableName)) {
            return INTERFACES_DEFAULT_WIDTHS;
        }
        if (INPUTDEVS_TABLE.equals(tableName)) {
            return INPUTDEVS_DEFAULT_WIDTHS;
        }
        if (GRAPHICS_TABLE.equals(tableName)) {
            return GRAPHICS_DEFAULT_WIDTHS;
        }
        if (SOUND_TABLE.equals(tableName)) {
            return SOUND_DEFAULT_WIDTHS;
        }
        if (SERIAL_TABLE.equals(tableName)) {
            return SERIAL_DEFAULT_WIDTHS;
        }
        if (PARALLEL_TABLE.equals(tableName)) {
            return PARALLEL_DEFAULT_WIDTHS;
        }
        if (VIDEO_TABLE.equals(tableName)) {
            return VIDEO_DEFAULT_WIDTHS;
        }
        return null;
    }

    @Override
    protected boolean isControlButton(String tableName, int column) {
        if (HEADER_TABLE.equals(tableName)) {
            return HEADER_DEFAULT_WIDTHS.containsKey(column);
        }
        if (DISK_TABLE.equals(tableName)) {
            return DISK_DEFAULT_WIDTHS.containsKey(column);
        }
        if (FILESYSTEM_TABLE.equals(tableName)) {
            return FILESYSTEM_DEFAULT_WIDTHS.containsKey(column);
        }
        if (INTERFACES_TABLE.equals(tableName)) {
            return INTERFACES_DEFAULT_WIDTHS.containsKey(column);
        }
        if (INPUTDEVS_TABLE.equals(tableName)) {
            return INPUTDEVS_DEFAULT_WIDTHS.containsKey(column);
        }
        if (GRAPHICS_TABLE.equals(tableName)) {
            return GRAPHICS_DEFAULT_WIDTHS.containsKey(column);
        }
        if (SOUND_TABLE.equals(tableName)) {
            return SOUND_DEFAULT_WIDTHS.containsKey(column);
        }
        if (SERIAL_TABLE.equals(tableName)) {
            return SERIAL_DEFAULT_WIDTHS.containsKey(column);
        }
        if (PARALLEL_TABLE.equals(tableName)) {
            return PARALLEL_DEFAULT_WIDTHS.containsKey(column);
        }
        if (VIDEO_TABLE.equals(tableName)) {
            return VIDEO_DEFAULT_WIDTHS.containsKey(column);
        }
        return false;
    }

    @Override
    protected String getTableToolTip(String tableName, String key, Object object, int raw, int column) {
        if (HEADER_TABLE.equals(tableName)) {
            if (HEADER_DEFAULT_WIDTHS.containsKey(column)) {
                return "Remove domain " + key + ".";
            }
        } else if (DISK_TABLE.equals(tableName) ? DISK_DEFAULT_WIDTHS.containsKey(column) : (FILESYSTEM_TABLE.equals(tableName) ? FILESYSTEM_DEFAULT_WIDTHS.containsKey(column) : (INTERFACES_TABLE.equals(tableName) ? INTERFACES_DEFAULT_WIDTHS.containsKey(column) : (INPUTDEVS_TABLE.equals(tableName) ? INPUTDEVS_DEFAULT_WIDTHS.containsKey(column) : (GRAPHICS_TABLE.equals(tableName) ? GRAPHICS_DEFAULT_WIDTHS.containsKey(column) : (SOUND_TABLE.equals(tableName) ? SOUND_DEFAULT_WIDTHS.containsKey(column) : (SERIAL_TABLE.equals(tableName) ? SERIAL_DEFAULT_WIDTHS.containsKey(column) : (PARALLEL_TABLE.equals(tableName) ? PARALLEL_DEFAULT_WIDTHS.containsKey(column) : VIDEO_TABLE.equals(tableName) && VIDEO_DEFAULT_WIDTHS.containsKey(column))))))))) {
            return "Remove " + key + ".";
        }
        return super.getTableToolTip(tableName, key, object, raw, column);
    }

    private void setButtonToStart(final Host host, final Widget hostWi, final MyButton hostBtn, final boolean stopped) {
        if (hostWi != null) {
            final boolean enable = host.isConnected();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    hostWi.setTFButtonEnabled(enable && stopped);
                    hostBtn.setText("Start");
                    hostBtn.setIcon(HostBrowser.HOST_ON_ICON);
                    hostBtn.setToolTipText("Start on " + host.getName());
                }
            });
        }
    }

    private void setButtonToView(final Host host, final Widget hostWi, final MyButton hostBtn) {
        if (hostWi != null) {
            final boolean enable = host.isConnected();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    hostWi.setTFButtonEnabled(enable);
                    hostBtn.setText("View");
                    hostBtn.setIcon(VNC_ICON);
                    hostBtn.setToolTipText("Graphical console on " + host.getName());
                }
            });
        }
    }

    private void setButtonToNotDefined(final Host host, final Widget hostWi, final MyButton hostBtn) {
        if (hostWi != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    hostWi.setTFButtonEnabled(false);
                    hostBtn.setIcon(null);
                    hostBtn.setToolTipText("not defined on " + host.getName());
                }
            });
        }
    }

    private void setHostButtons(boolean running) {
        for (Host h : this.getBrowser().getClusterHosts()) {
            VMSXML vmsxml = this.getBrowser().getVMSXML(h);
            MyButton hostBtn = this.hostButtons.get(h.getName());
            MyButton wizardHostBtn = this.hostButtons.get(WIZARD_PREFIX + h.getName());
            Widget hostWi = this.definedOnHostComboBoxHash.get(h.getName());
            Widget wizardHostWi = this.definedOnHostComboBoxHash.get(WIZARD_PREFIX + h.getName());
            if (vmsxml != null && vmsxml.getDomainNames().contains(this.getDomainName())) {
                if (vmsxml.isRunning(this.getDomainName())) {
                    this.setButtonToView(h, hostWi, hostBtn);
                    this.setButtonToView(h, wizardHostWi, wizardHostBtn);
                    continue;
                }
                this.setButtonToStart(h, hostWi, hostBtn, !running);
                this.setButtonToStart(h, wizardHostWi, wizardHostBtn, !running);
                continue;
            }
            this.setButtonToNotDefined(h, hostWi, hostBtn);
            this.setButtonToNotDefined(h, wizardHostWi, wizardHostBtn);
        }
    }

    @Override
    public void revert() {
        DefaultMutableTreeNode thisNode = this.getNode();
        if (thisNode == null) {
            return;
        }
        for (Host h : this.getBrowser().getClusterHosts()) {
            Widget hostWi = this.definedOnHostComboBoxHash.get(h.getName());
            VMSXML vmsxml = this.getBrowser().getVMSXML(h);
            String savedValue = this.getResource().isNew() || vmsxml != null && vmsxml.getDomainNames().contains(this.getDomainName()) ? DEFINED_ON_HOST_TRUE : DEFINED_ON_HOST_FALSE;
            hostWi.setValue(savedValue);
        }
        Enumeration<TreeNode> eee = thisNode.children();
        while (eee.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)eee.nextElement();
            VMSHardwareInfo vmshi = (VMSHardwareInfo)node.getUserObject();
            if (!vmshi.checkResourceFieldsChanged(null, vmshi.getRealParametersFromXML(), true)) continue;
            vmshi.revert();
        }
        super.revert();
    }

    public void savePreferredValues() {
        for (String pv : PREFERRED_MAP.keySet()) {
            if (this.preferredEmulator != null && "emulator".equals(pv)) {
                this.getResource().setValue(pv, this.preferredEmulator);
                continue;
            }
            this.getResource().setValue(pv, PREFERRED_MAP.get(pv));
        }
    }

    boolean isUsedByCRM() {
        return this.usedByCRM;
    }

    public void setUsedByCRM(boolean usedByCRM) {
        this.usedByCRM = usedByCRM;
    }

    public String getUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID().toString();
        }
        return this.uuid;
    }

    public final String getVirshOptions() {
        return this.getResource().getValue("virsh-options");
    }

    public final boolean needDisplay() {
        return NEED_DISPLAY.contains(this.getWidget("domain-type", null).getStringValue());
    }

    public final boolean needConsole() {
        return NEED_CONSOLE.contains(this.getWidget("domain-type", null).getStringValue());
    }

    public final boolean needFilesystem() {
        return NEED_FILESYSTEM.contains(this.getWidget("domain-type", null).getStringValue());
    }

    static {
        HEADER_DEFAULT_WIDTHS.put(4, 80);
        DISK_DEFAULT_WIDTHS.put(2, 80);
        FILESYSTEM_DEFAULT_WIDTHS.put(2, 80);
        INTERFACES_DEFAULT_WIDTHS.put(2, 80);
        INPUTDEVS_DEFAULT_WIDTHS.put(1, 80);
        GRAPHICS_DEFAULT_WIDTHS.put(1, 80);
        SOUND_DEFAULT_WIDTHS.put(1, 80);
        SERIAL_DEFAULT_WIDTHS.put(1, 80);
        PARALLEL_DEFAULT_WIDTHS.put(1, 80);
        VIDEO_DEFAULT_WIDTHS.put(1, 80);
        SECTION_MAP.put("name", VIRTUAL_SYSTEM_STRING);
        SECTION_MAP.put("domain-type", VIRTUAL_SYSTEM_STRING);
        SECTION_MAP.put("emulator", VIRTUAL_SYSTEM_STRING);
        SECTION_MAP.put("vcpu", VIRTUAL_SYSTEM_STRING);
        SECTION_MAP.put("currentMemory", VIRTUAL_SYSTEM_STRING);
        SECTION_MAP.put("memory", VIRTUAL_SYSTEM_STRING);
        SECTION_MAP.put("bootloader", VIRTUAL_SYSTEM_STRING);
        SECTION_MAP.put("boot", VIRTUAL_SYSTEM_STRING);
        SECTION_MAP.put("boot2", VIRTUAL_SYSTEM_STRING);
        SECTION_MAP.put("loader", VIRTUAL_SYSTEM_STRING);
        SECTION_MAP.put("autostart", VIRTUAL_SYSTEM_STRING);
        SECTION_MAP.put("virsh-options", VIRTUAL_SYSTEM_STRING);
        SECTION_MAP.put("type", VIRTUAL_SYSTEM_STRING);
        SECTION_MAP.put("arch", VIRTUAL_SYSTEM_STRING);
        SECTION_MAP.put("machine", VIRTUAL_SYSTEM_STRING);
        SECTION_MAP.put("init", VIRTUAL_SYSTEM_STRING);
        SECTION_MAP.put("on_poweroff", VIRTUAL_SYSTEM_OPTIONS);
        SECTION_MAP.put("on_reboot", VIRTUAL_SYSTEM_OPTIONS);
        SECTION_MAP.put("on_crash", VIRTUAL_SYSTEM_OPTIONS);
        SECTION_MAP.put("acpi", VIRTUAL_SYSTEM_FEATURES);
        SECTION_MAP.put("apic", VIRTUAL_SYSTEM_FEATURES);
        SECTION_MAP.put("pae", VIRTUAL_SYSTEM_FEATURES);
        SECTION_MAP.put("hap", VIRTUAL_SYSTEM_FEATURES);
        SECTION_MAP.put("offset", VIRTUAL_SYSTEM_STRING);
        SECTION_MAP.put("match", CPU_MATCH_OPTIONS);
        SECTION_MAP.put("model", CPU_MATCH_OPTIONS);
        SECTION_MAP.put("vendor", CPU_MATCH_OPTIONS);
        SECTION_MAP.put("sockets", CPU_MATCH_OPTIONS);
        SECTION_MAP.put("cores", CPU_MATCH_OPTIONS);
        SECTION_MAP.put("threads", CPU_MATCH_OPTIONS);
        SECTION_MAP.put("policy", CPU_MATCH_OPTIONS);
        SECTION_MAP.put("features", CPU_MATCH_OPTIONS);
        SHORTNAME_MAP.put("name", Tools.getString("VMSVirtualDomainInfo.Short.Name"));
        SHORTNAME_MAP.put("domain-type", Tools.getString("VMSVirtualDomainInfo.Short.DomainType"));
        SHORTNAME_MAP.put("vcpu", Tools.getString("VMSVirtualDomainInfo.Short.Vcpu"));
        SHORTNAME_MAP.put("bootloader", Tools.getString("VMSVirtualDomainInfo.Short.Bootloader"));
        SHORTNAME_MAP.put("currentMemory", Tools.getString("VMSVirtualDomainInfo.Short.CurrentMemory"));
        SHORTNAME_MAP.put("memory", Tools.getString("VMSVirtualDomainInfo.Short.Memory"));
        SHORTNAME_MAP.put("boot", Tools.getString("VMSVirtualDomainInfo.Short.Os.Boot"));
        SHORTNAME_MAP.put("boot2", Tools.getString("VMSVirtualDomainInfo.Short.Os.Boot.2"));
        SHORTNAME_MAP.put("loader", Tools.getString("VMSVirtualDomainInfo.Short.Os.Loader"));
        SHORTNAME_MAP.put("autostart", Tools.getString("VMSVirtualDomainInfo.Short.Autostart"));
        SHORTNAME_MAP.put("virsh-options", Tools.getString("VMSVirtualDomainInfo.Short.VirshOptions"));
        SHORTNAME_MAP.put("type", Tools.getString("VMSVirtualDomainInfo.Short.Type"));
        SHORTNAME_MAP.put("init", Tools.getString("VMSVirtualDomainInfo.Short.Init"));
        SHORTNAME_MAP.put("arch", Tools.getString("VMSVirtualDomainInfo.Short.Arch"));
        SHORTNAME_MAP.put("machine", Tools.getString("VMSVirtualDomainInfo.Short.Machine"));
        SHORTNAME_MAP.put("acpi", Tools.getString("VMSVirtualDomainInfo.Short.Acpi"));
        SHORTNAME_MAP.put("apic", Tools.getString("VMSVirtualDomainInfo.Short.Apic"));
        SHORTNAME_MAP.put("pae", Tools.getString("VMSVirtualDomainInfo.Short.Pae"));
        SHORTNAME_MAP.put("hap", Tools.getString("VMSVirtualDomainInfo.Short.Hap"));
        SHORTNAME_MAP.put("offset", Tools.getString("VMSVirtualDomainInfo.Short.Clock.Offset"));
        SHORTNAME_MAP.put("match", Tools.getString("VMSVirtualDomainInfo.Short.CPU.Match"));
        SHORTNAME_MAP.put("model", Tools.getString("VMSVirtualDomainInfo.Short.CPUMatch.Model"));
        SHORTNAME_MAP.put("vendor", Tools.getString("VMSVirtualDomainInfo.Short.CPUMatch.Vendor"));
        SHORTNAME_MAP.put("sockets", Tools.getString("VMSVirtualDomainInfo.Short.CPUMatch.TopologySockets"));
        SHORTNAME_MAP.put("cores", Tools.getString("VMSVirtualDomainInfo.Short.CPUMatch.TopologyCores"));
        SHORTNAME_MAP.put("threads", Tools.getString("VMSVirtualDomainInfo.Short.CPUMatch.TopologyThreads"));
        SHORTNAME_MAP.put("policy", Tools.getString("VMSVirtualDomainInfo.Short.CPUMatch.Policy"));
        SHORTNAME_MAP.put("features", Tools.getString("VMSVirtualDomainInfo.Short.CPUMatch.Features"));
        SHORTNAME_MAP.put("on_poweroff", Tools.getString("VMSVirtualDomainInfo.Short.OnPoweroff"));
        SHORTNAME_MAP.put("on_reboot", Tools.getString("VMSVirtualDomainInfo.Short.OnReboot"));
        SHORTNAME_MAP.put("on_crash", Tools.getString("VMSVirtualDomainInfo.Short.OnCrash"));
        SHORTNAME_MAP.put("emulator", Tools.getString("VMSVirtualDomainInfo.Short.Emulator"));
        FIELD_TYPES.put("currentMemory", Widget.Type.TEXTFIELDWITHUNIT);
        FIELD_TYPES.put("memory", Widget.Type.TEXTFIELDWITHUNIT);
        FIELD_TYPES.put("apic", Widget.Type.CHECKBOX);
        FIELD_TYPES.put("acpi", Widget.Type.CHECKBOX);
        FIELD_TYPES.put("pae", Widget.Type.CHECKBOX);
        FIELD_TYPES.put("hap", Widget.Type.CHECKBOX);
        PREFERRED_MAP.put("currentMemory", "512M");
        PREFERRED_MAP.put("memory", "512M");
        PREFERRED_MAP.put("type", TYPE_HVM);
        PREFERRED_MAP.put("arch", "x86_64");
        PREFERRED_MAP.put("machine", "pc");
        PREFERRED_MAP.put("acpi", DEFINED_ON_HOST_TRUE);
        PREFERRED_MAP.put("apic", DEFINED_ON_HOST_TRUE);
        PREFERRED_MAP.put("pae", DEFINED_ON_HOST_TRUE);
        PREFERRED_MAP.put("offset", "utc");
        PREFERRED_MAP.put("on_poweroff", "destroy");
        PREFERRED_MAP.put("on_reboot", "restart");
        PREFERRED_MAP.put("on_crash", "restart");
        PREFERRED_MAP.put("emulator", "/usr/bin/kvm");
        DEFAULTS_MAP.put("autostart", null);
        DEFAULTS_MAP.put("virsh-options", VIRSH_OPTION_KVM);
        DEFAULTS_MAP.put("boot", "hd");
        DEFAULTS_MAP.put("boot", VIRSH_OPTION_KVM);
        DEFAULTS_MAP.put("domain-type", DOMAIN_TYPE_KVM);
        DEFAULTS_MAP.put("vcpu", "1");
        DEFAULTS_MAP.put("acpi", DEFINED_ON_HOST_FALSE);
        DEFAULTS_MAP.put("apic", DEFINED_ON_HOST_FALSE);
        DEFAULTS_MAP.put("pae", DEFINED_ON_HOST_FALSE);
        DEFAULTS_MAP.put("hap", DEFINED_ON_HOST_FALSE);
        DEFAULTS_MAP.put("match", VIRSH_OPTION_KVM);
        DEFAULTS_MAP.put("model", VIRSH_OPTION_KVM);
        DEFAULTS_MAP.put("vendor", VIRSH_OPTION_KVM);
        DEFAULTS_MAP.put("sockets", VIRSH_OPTION_KVM);
        DEFAULTS_MAP.put("cores", VIRSH_OPTION_KVM);
        DEFAULTS_MAP.put("threads", VIRSH_OPTION_KVM);
        DEFAULTS_MAP.put("policy", VIRSH_OPTION_KVM);
        DEFAULTS_MAP.put("features", VIRSH_OPTION_KVM);
        HAS_UNIT_PREFIX.put("memory", true);
        HAS_UNIT_PREFIX.put("currentMemory", true);
        POSSIBLE_VALUES.put("boot", new StringInfo[]{new StringInfo("Hard Disk", "hd", null), new StringInfo("Network (PXE)", "network", null), new StringInfo("CD-ROM", "cdrom", null), new StringInfo("Floppy", "fd", null)});
        POSSIBLE_VALUES.put("boot2", new StringInfo[]{null, new StringInfo("Hard Disk", "hd", null), new StringInfo("Network (PXE)", "network", null), new StringInfo("CD-ROM", "cdrom", null), new StringInfo("Floppy", "fd", null)});
        POSSIBLE_VALUES.put("loader", new String[0]);
        POSSIBLE_VALUES.put("domain-type", new String[]{DOMAIN_TYPE_KVM, DOMAIN_TYPE_XEN, DOMAIN_TYPE_LXC, DOMAIN_TYPE_OPENVZ, DOMAIN_TYPE_VBOX, "uml"});
        POSSIBLE_VALUES.put("bootloader", new String[]{VIRSH_OPTION_KVM, "/usr/bin/pygrub"});
        POSSIBLE_VALUES.put("type", new String[]{TYPE_HVM, TYPE_LINUX, TYPE_EXE});
        POSSIBLE_VALUES.put("arch", new String[]{VIRSH_OPTION_KVM, "x86_64", "i686"});
        POSSIBLE_VALUES.put("machine", new String[]{VIRSH_OPTION_KVM, "pc", "pc-0.12"});
        POSSIBLE_VALUES.put("init", new String[]{VIRSH_OPTION_KVM, "/bin/sh", "/init"});
        POSSIBLE_VALUES.put("offset", new String[]{"utc", "localtime"});
        POSSIBLE_VALUES.put("on_poweroff", new String[]{"destroy", "restart", "preserve", "rename-restart"});
        POSSIBLE_VALUES.put("on_reboot", new String[]{"restart", "destroy", "preserve", "rename-restart"});
        POSSIBLE_VALUES.put("on_crash", new String[]{"restart", "destroy", "preserve", "rename-restart", "coredump-destroy", "coredump-restart"});
        POSSIBLE_VALUES.put("emulator", new String[]{"/usr/bin/kvm", "/usr/bin/qemu"});
        POSSIBLE_VALUES.put("match", new String[]{VIRSH_OPTION_KVM, "exact", "minimum", "strict"});
        POSSIBLE_VALUES.put("sockets", new String[]{VIRSH_OPTION_KVM, "1", "2"});
        POSSIBLE_VALUES.put("cores", new String[]{VIRSH_OPTION_KVM, "1", "2", "4", "8"});
        POSSIBLE_VALUES.put("threads", new String[]{VIRSH_OPTION_KVM, "1", "2"});
        POSSIBLE_VALUES.put("policy", new String[]{VIRSH_OPTION_KVM, "force", "require", "optional", "disable", "forbid"});
        POSSIBLE_VALUES.put("features", new String[]{VIRSH_OPTION_KVM, "aes", "aes apic"});
        IS_INTEGER.add("vcpu");
        IS_INTEGER.add("sockets");
        IS_INTEGER.add("cores");
        IS_INTEGER.add("threads");
        REQUIRED_VERSION.put("match", "0.7.5");
        REQUIRED_VERSION.put("model", "0.7.5");
        REQUIRED_VERSION.put("vendor", "0.8.3");
        REQUIRED_VERSION.put("sockets", "0.7.5");
        REQUIRED_VERSION.put("cores", "0.7.5");
        REQUIRED_VERSION.put("threads", "0.7.5");
        REQUIRED_VERSION.put("policy", "0.7.5");
        REQUIRED_VERSION.put("features", "0.7.5");
    }
}

