/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.VMSXML;
import lcmc.gui.Browser;
import lcmc.gui.resources.VMSHardwareInfo;
import lcmc.gui.resources.VMSVirtualDomainInfo;
import lcmc.gui.widget.Widget;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;
import org.w3c.dom.Node;

final class VMSVideoInfo
extends VMSHardwareInfo {
    private static final String[] PARAMETERS = new String[]{"model_type", "model_vram", "model_heads"};
    private static final Set<String> IS_ENABLED_ONLY_IN_ADVANCED = new HashSet<String>(Arrays.asList("model_vram", "model_heads"));
    private static final Map<String, Widget.Type> FIELD_TYPES = new HashMap<String, Widget.Type>();
    private static final Map<String, String> SHORTNAME_MAP = new HashMap<String, String>();
    private static final Map<String, String> LONGNAME_MAP;
    private static final Set<String> IS_REQUIRED;
    private static final Map<String, String> DEFAULTS_MAP;
    private static final Map<String, Object[]> POSSIBLE_VALUES;
    private JComponent tablePanel = null;

    VMSVideoInfo(String name, Browser browser, VMSVirtualDomainInfo vmsVirtualDomainInfo) {
        super(name, browser, vmsVirtualDomainInfo);
    }

    @Override
    protected void addHardwareTable(JPanel mainPanel) {
        this.tablePanel = this.getTablePanel("Video Devices", "video", VMSVideoInfo.getNewBtn(this.getVMSVirtualDomainInfo()));
        if (this.getResource().isNew()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VMSVideoInfo.this.tablePanel.setVisible(false);
                }
            });
        }
        mainPanel.add(this.tablePanel);
    }

    @Override
    protected String getParamLongDesc(String param) {
        String name = LONGNAME_MAP.get(param);
        if (name == null) {
            return this.getParamShortDesc(param);
        }
        return name;
    }

    @Override
    protected String getParamShortDesc(String param) {
        String name = SHORTNAME_MAP.get(param);
        if (name == null) {
            return param;
        }
        return name;
    }

    @Override
    protected String getParamPreferred(String param) {
        return null;
    }

    @Override
    protected String getParamDefault(String param) {
        return DEFAULTS_MAP.get(param);
    }

    @Override
    public String[] getParametersFromXML() {
        return (String[])PARAMETERS.clone();
    }

    @Override
    protected Object[] getParamPossibleChoices(String param) {
        return POSSIBLE_VALUES.get(param);
    }

    @Override
    protected String getSection(String param) {
        return "Video Device Options";
    }

    @Override
    protected boolean isRequired(String param) {
        return IS_REQUIRED.contains(param);
    }

    @Override
    protected boolean isInteger(String param) {
        return false;
    }

    @Override
    protected boolean isLabel(String param) {
        return false;
    }

    @Override
    protected boolean isTimeType(String param) {
        return false;
    }

    @Override
    protected boolean isCheckBox(String param) {
        return false;
    }

    @Override
    protected String getParamType(String param) {
        return "undef";
    }

    @Override
    protected String getParamRegexp(String param) {
        return null;
    }

    @Override
    protected Widget.Type getFieldType(String param) {
        return FIELD_TYPES.get(param);
    }

    @Override
    void apply(boolean testOnly) {
        if (testOnly) {
            return;
        }
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                VMSVideoInfo.this.getApplyButton().setEnabled(false);
                VMSVideoInfo.this.getRevertButton().setEnabled(false);
            }
        });
        this.getInfoPanel();
        this.waitForInfoPanel();
        Map<String, String> parameters = this.getHWParameters(this.getResource().isNew());
        for (Host h : this.getVMSVirtualDomainInfo().getDefinedOnHosts()) {
            VMSXML vmsxml = this.getBrowser().getVMSXML(h);
            if (vmsxml != null) {
                parameters.put("saved_model_type", this.getParamSaved("model_type"));
                String domainName = this.getVMSVirtualDomainInfo().getDomainName();
                Node domainNode = vmsxml.getDomainNode(domainName);
                this.modifyXML(vmsxml, domainNode, domainName, parameters);
                String virshOptions = this.getVMSVirtualDomainInfo().getVirshOptions();
                vmsxml.saveAndDefine(domainNode, domainName, virshOptions);
            }
            this.getResource().setNew(false);
        }
        this.getBrowser().reload(this.getNode(), false);
        this.getBrowser().periodicalVMSUpdate(this.getVMSVirtualDomainInfo().getDefinedOnHosts());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VMSVideoInfo.this.tablePanel.setVisible(true);
            }
        });
        String[] params = this.getParametersFromXML();
        if (!testOnly) {
            this.storeComboBoxValues(params);
        }
        this.checkResourceFieldsChanged(null, params);
    }

    @Override
    protected Map<String, String> getHWParameters(boolean allParams) {
        Map<String, String> params = super.getHWParameters(allParams);
        this.setName(this.getParamSaved("model_type"));
        return params;
    }

    @Override
    protected Object[][] getTableData(String tableName) {
        if ("header".equals(tableName)) {
            return this.getVMSVirtualDomainInfo().getMainTableData();
        }
        if ("video".equals(tableName)) {
            if (this.getResource().isNew()) {
                return new Object[0][];
            }
            return new Object[][]{this.getVMSVirtualDomainInfo().getVideoDataRow(this.getName(), null, this.getVMSVirtualDomainInfo().getVideos(), true)};
        }
        return new Object[0][];
    }

    @Override
    protected boolean isAdvanced(String param) {
        return false;
    }

    @Override
    protected String isEnabled(String param) {
        if (this.getResource().isNew() || !"model_type".equals(param)) {
            return null;
        }
        return "";
    }

    @Override
    protected boolean isEnabledOnlyInAdvancedMode(String param) {
        return IS_ENABLED_ONLY_IN_ADVANCED.contains(param);
    }

    @Override
    protected ConfigData.AccessType getAccessType(String param) {
        return ConfigData.AccessType.ADMIN;
    }

    @Override
    protected boolean checkParam(String param, String newValue) {
        return !this.isRequired(param) || newValue != null && !"".equals(newValue);
    }

    @Override
    void updateParameters() {
        VMSXML.VideoData videoData;
        Map<String, VMSXML.VideoData> videos = this.getVMSVirtualDomainInfo().getVideos();
        if (videos != null && (videoData = videos.get(this.getName())) != null) {
            for (String param : this.getParametersFromXML()) {
                String oldValue = this.getParamSaved(param);
                String value = this.getParamSaved(param);
                Widget wi = this.getWidget(param, null);
                for (Host h : this.getVMSVirtualDomainInfo().getDefinedOnHosts()) {
                    String savedValue;
                    VMSXML vmsxml = this.getBrowser().getVMSXML(h);
                    if (vmsxml == null || (savedValue = videoData.getValue(param)) == null) continue;
                    value = savedValue;
                }
                if (Tools.areEqual(value, oldValue)) continue;
                this.getResource().setValue(param, value);
                if (wi == null) continue;
                wi.setValue(value);
            }
        }
        this.updateTable("header");
        this.updateTable("video");
        this.checkResourceFieldsChanged(null, this.getParametersFromXML());
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(30);
        String type = this.getParamSaved("model_type");
        if (type == null) {
            s.append("new video device...");
        } else {
            s.append(type);
        }
        return s.toString();
    }

    @Override
    protected void removeMyselfNoConfirm(boolean testOnly) {
        if (testOnly) {
            return;
        }
        String virshOptions = this.getVMSVirtualDomainInfo().getVirshOptions();
        for (Host h : this.getVMSVirtualDomainInfo().getDefinedOnHosts()) {
            VMSXML vmsxml = this.getBrowser().getVMSXML(h);
            if (vmsxml == null) continue;
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("saved_model_type", this.getParamSaved("model_type"));
            vmsxml.removeVideoXML(this.getVMSVirtualDomainInfo().getDomainName(), parameters, virshOptions);
        }
        this.getBrowser().periodicalVMSUpdate(this.getVMSVirtualDomainInfo().getDefinedOnHosts());
        this.removeNode();
    }

    @Override
    protected String isRemoveable() {
        return null;
    }

    static MyButton getNewBtn(final VMSVirtualDomainInfo vdi) {
        MyButton newBtn = new MyButton("Add Video Device");
        newBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        vdi.addVideosPanel();
                    }
                });
                t.start();
            }
        });
        return newBtn;
    }

    @Override
    protected void modifyXML(VMSXML vmsxml, Node node, String domainName, Map<String, String> params) {
        if (vmsxml != null) {
            vmsxml.modifyVideoXML(node, domainName, params);
        }
    }

    static {
        SHORTNAME_MAP.put("model_type", Tools.getString("VMSVideoInfo.ModelType"));
        SHORTNAME_MAP.put("model_vram", Tools.getString("VMSVideoInfo.ModelVRAM"));
        SHORTNAME_MAP.put("model_heads", Tools.getString("VMSVideoInfo.ModelHeads"));
        LONGNAME_MAP = new HashMap<String, String>();
        LONGNAME_MAP.put("model_vram", Tools.getString("VMSVideoInfo.ModelVRAM.ToolTip"));
        LONGNAME_MAP.put("model_heads", Tools.getString("VMSVideoInfo.ModelHeads.ToolTip"));
        IS_REQUIRED = new HashSet<String>(Arrays.asList("model_type"));
        DEFAULTS_MAP = new HashMap<String, String>();
        POSSIBLE_VALUES = new HashMap<String, Object[]>();
        POSSIBLE_VALUES.put("model_type", new String[]{"cirrus", "vga", "vmvga", "xen"});
    }
}

