/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import lcmc.data.Host;
import lcmc.data.VMSXML;
import lcmc.gui.Browser;
import lcmc.gui.resources.VMSParallelSerialInfo;
import lcmc.gui.resources.VMSVirtualDomainInfo;
import lcmc.gui.widget.Widget;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;
import org.w3c.dom.Node;

final class VMSSerialInfo
extends VMSParallelSerialInfo {
    VMSSerialInfo(String name, Browser browser, VMSVirtualDomainInfo vmsVirtualDomainInfo) {
        super(name, browser, vmsVirtualDomainInfo);
    }

    @Override
    protected Object[][] getTableData(String tableName) {
        if ("header".equals(tableName)) {
            return this.getVMSVirtualDomainInfo().getMainTableData();
        }
        if ("serial".equals(tableName)) {
            if (this.getResource().isNew()) {
                return new Object[0][];
            }
            return new Object[][]{this.getVMSVirtualDomainInfo().getSerialDataRow(this.getName(), null, this.getVMSVirtualDomainInfo().getSerials(), true)};
        }
        return new Object[0][];
    }

    @Override
    void updateParameters() {
        VMSXML.SerialData serialData;
        Map<String, VMSXML.SerialData> serials = this.getVMSVirtualDomainInfo().getSerials();
        if (serials != null && (serialData = serials.get(this.getName())) != null) {
            for (String param : this.getParametersFromXML()) {
                String oldValue = this.getParamSaved(param);
                String value = this.getParamSaved(param);
                Widget wi = this.getWidget(param, null);
                for (Host h : this.getVMSVirtualDomainInfo().getDefinedOnHosts()) {
                    String savedValue;
                    VMSXML vmsxml = this.getBrowser().getVMSXML(h);
                    if (vmsxml == null || (savedValue = serialData.getValue(param)) == null) continue;
                    value = savedValue;
                }
                if (Tools.areEqual(value, oldValue)) continue;
                this.getResource().setValue(param, value);
                if (wi == null) continue;
                wi.setValue(value);
            }
        }
        this.updateTable("header");
        this.updateTable("serial");
        this.checkResourceFieldsChanged(null, this.getParametersFromXML());
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(30);
        String type = this.getParamSaved("type");
        if (type == null) {
            s.append("new serial device...");
        } else {
            s.append(this.getName());
        }
        return s.toString();
    }

    @Override
    protected void removeMyselfNoConfirm(boolean testOnly) {
        if (testOnly) {
            return;
        }
        String virshOptions = this.getVMSVirtualDomainInfo().getVirshOptions();
        for (Host h : this.getVMSVirtualDomainInfo().getDefinedOnHosts()) {
            VMSXML vmsxml = this.getBrowser().getVMSXML(h);
            if (vmsxml == null) continue;
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("saved_type", this.getParamSaved("type"));
            vmsxml.removeSerialXML(this.getVMSVirtualDomainInfo().getDomainName(), parameters, virshOptions);
        }
        this.getBrowser().periodicalVMSUpdate(this.getVMSVirtualDomainInfo().getDefinedOnHosts());
        this.removeNode();
    }

    @Override
    protected MyButton getNewBtn0(VMSVirtualDomainInfo vdi) {
        return VMSSerialInfo.getNewBtn(vdi);
    }

    static MyButton getNewBtn(final VMSVirtualDomainInfo vdi) {
        MyButton newBtn = new MyButton("Add Serial Device");
        newBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        vdi.addSerialsPanel();
                    }
                });
                t.start();
            }
        });
        return newBtn;
    }

    @Override
    protected void modifyXML(VMSXML vmsxml, Node node, String domainName, Map<String, String> params) {
        if (vmsxml != null) {
            vmsxml.modifySerialXML(node, domainName, params);
        }
    }

    @Override
    protected String getTableScreenName() {
        return "Serial Device";
    }

    @Override
    protected String getTableName() {
        return "serial";
    }

    @Override
    protected Map<String, String> getHWParameters(boolean allParams) {
        Map<String, String> parameters = super.getHWParameters(allParams);
        this.setName("serial " + this.getParamSaved("target_port") + " / " + this.getParamSaved("type"));
        return parameters;
    }
}

