/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import lcmc.data.Host;
import lcmc.data.VMSXML;
import lcmc.gui.Browser;
import lcmc.gui.resources.VMSParallelSerialInfo;
import lcmc.gui.resources.VMSVirtualDomainInfo;
import lcmc.gui.widget.Widget;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;
import org.w3c.dom.Node;

final class VMSParallelInfo
extends VMSParallelSerialInfo {
    VMSParallelInfo(String name, Browser browser, VMSVirtualDomainInfo vmsVirtualDomainInfo) {
        super(name, browser, vmsVirtualDomainInfo);
    }

    @Override
    protected Object[][] getTableData(String tableName) {
        if ("header".equals(tableName)) {
            return this.getVMSVirtualDomainInfo().getMainTableData();
        }
        if ("parallel".equals(tableName)) {
            if (this.getResource().isNew()) {
                return new Object[0][];
            }
            return new Object[][]{this.getVMSVirtualDomainInfo().getParallelDataRow(this.getName(), null, this.getVMSVirtualDomainInfo().getParallels(), true)};
        }
        return new Object[0][];
    }

    @Override
    void updateParameters() {
        VMSXML.ParallelData parallelData;
        Map<String, VMSXML.ParallelData> parallels = this.getVMSVirtualDomainInfo().getParallels();
        if (parallels != null && (parallelData = parallels.get(this.getName())) != null) {
            for (String param : this.getParametersFromXML()) {
                String oldValue = this.getParamSaved(param);
                String value = this.getParamSaved(param);
                Widget wi = this.getWidget(param, null);
                for (Host h : this.getVMSVirtualDomainInfo().getDefinedOnHosts()) {
                    String savedValue;
                    VMSXML vmsxml = this.getBrowser().getVMSXML(h);
                    if (vmsxml == null || (savedValue = parallelData.getValue(param)) == null) continue;
                    value = savedValue;
                }
                if (Tools.areEqual(value, oldValue)) continue;
                this.getResource().setValue(param, value);
                if (wi == null) continue;
                wi.setValue(value);
            }
        }
        this.updateTable("header");
        this.updateTable("parallel");
        this.checkResourceFieldsChanged(null, this.getParametersFromXML());
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(30);
        String type = this.getParamSaved("type");
        if (type == null) {
            s.append("new parallel device...");
        } else {
            s.append(this.getName());
        }
        return s.toString();
    }

    @Override
    protected void removeMyselfNoConfirm(boolean testOnly) {
        if (testOnly) {
            return;
        }
        String virshOptions = this.getVMSVirtualDomainInfo().getVirshOptions();
        for (Host h : this.getVMSVirtualDomainInfo().getDefinedOnHosts()) {
            VMSXML vmsxml = this.getBrowser().getVMSXML(h);
            if (vmsxml == null) continue;
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("saved_type", this.getParamSaved("type"));
            vmsxml.removeParallelXML(this.getVMSVirtualDomainInfo().getDomainName(), parameters, virshOptions);
        }
        this.getBrowser().periodicalVMSUpdate(this.getVMSVirtualDomainInfo().getDefinedOnHosts());
        this.removeNode();
    }

    @Override
    protected MyButton getNewBtn0(VMSVirtualDomainInfo vdi) {
        return VMSParallelInfo.getNewBtn(vdi);
    }

    static MyButton getNewBtn(final VMSVirtualDomainInfo vdi) {
        MyButton newBtn = new MyButton("Add Parallel Device");
        newBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        vdi.addParallelsPanel();
                    }
                });
                t.start();
            }
        });
        return newBtn;
    }

    @Override
    protected void modifyXML(VMSXML vmsxml, Node node, String domainName, Map<String, String> params) {
        if (vmsxml != null) {
            vmsxml.modifyParallelXML(node, domainName, params);
        }
    }

    @Override
    protected String getTableScreenName() {
        return "Parallel Device";
    }

    @Override
    protected String getTableName() {
        return "parallel";
    }

    @Override
    protected Map<String, String> getHWParameters(boolean allParams) {
        Map<String, String> parameters = super.getHWParameters(allParams);
        this.setName("parallel " + this.getParamSaved("target_port") + " / " + this.getParamSaved("type"));
        return parameters;
    }
}

