/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import lcmc.data.ResourceAgent;
import lcmc.gui.Browser;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.resources.AvailableServiceInfo;
import lcmc.gui.resources.HbCategoryInfo;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;

public final class ResourceAgentClassInfo
extends HbCategoryInfo {
    private final Map<String, ResourceAgent> raMap = new HashMap<String, ResourceAgent>();
    private static final ImageIcon BACK_ICON = Tools.createImageIcon(Tools.getDefault("BackIcon"));

    public ResourceAgentClassInfo(String name, Browser browser) {
        super(name, browser);
        for (ResourceAgent ra : this.getBrowser().getCRMXML().getServices(name)) {
            this.raMap.put(ra.getName(), ra);
        }
    }

    @Override
    protected String[] getColumnNames(String tableName) {
        return new String[]{"Name", "Provider"};
    }

    @Override
    protected Object[][] getTableData(String tableName) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        for (ResourceAgent ra : this.getBrowser().getCRMXML().getServices(this.getName())) {
            MyButton nameLabel = new MyButton(ra.getName());
            rows.add(new Object[]{nameLabel, ra.getProvider()});
        }
        return (Object[][])rows.toArray((T[])new Object[rows.size()][]);
    }

    @Override
    public String toString() {
        return this.getName().toUpperCase();
    }

    @Override
    protected void rowClicked(String tableName, String key, int column) {
        AvailableServiceInfo asi;
        ResourceAgent ra = this.raMap.get(key);
        if (ra != null && (asi = this.getBrowser().getAvailableServiceInfoMap(ra)) != null) {
            asi.selectMyself();
        }
    }

    @Override
    protected JComponent getBackButton() {
        JPanel buttonPanel = new JPanel(new FlowLayout(0, 0, 0));
        buttonPanel.setBackground(ClusterBrowser.BUTTON_PANEL_BACKGROUND);
        buttonPanel.setMinimumSize(new Dimension(0, 50));
        buttonPanel.setPreferredSize(new Dimension(0, 50));
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        MyButton overviewButton = new MyButton(Tools.getString("ClusterBrowser.ClassesOverviewButton"), BACK_ICON);
        overviewButton.setPreferredSize(new Dimension(Tools.getConfigData().scaled(180), 50));
        overviewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceAgentClassInfo.this.getBrowser().getAvailableServicesInfo().selectMyself();
            }
        });
        buttonPanel.add(overviewButton);
        return buttonPanel;
    }
}

