/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import lcmc.data.Host;
import lcmc.data.resources.NetInterface;
import lcmc.gui.Browser;
import lcmc.gui.resources.NetInfo;

public final class ProxyNetInfo
extends NetInfo {
    static final Host SAME_HOST = null;
    private final Host proxyHost;
    public static final String PROXY_PREFIX = "proxy: ";

    public ProxyNetInfo(NetInfo netInfo, Browser browser, Host proxyHost) {
        super(netInfo.getName(), netInfo.getNetInterface(), browser);
        this.proxyHost = proxyHost;
    }

    public ProxyNetInfo(String name, NetInterface netInterface, Browser browser, Host proxyHost) {
        super(name, netInterface, browser);
        this.proxyHost = proxyHost;
    }

    @Override
    public String toString() {
        String ip = super.getInternalValue();
        String proxyHostName = null;
        if (this.proxyHost != null) {
            proxyHostName = this.proxyHost.getName();
        }
        return ProxyNetInfo.displayString(ip, this.getBrowser().getHost().getName(), proxyHostName);
    }

    public static String displayString(String someIp, String someHost, String someProxyHost) {
        StringBuilder s = new StringBuilder(PROXY_PREFIX);
        if (someIp != null) {
            s.append(someIp);
        }
        if (!someHost.equals(someProxyHost)) {
            s.append(" \u2192 ");
            s.append(someProxyHost);
        }
        return s.toString();
    }

    public Host getProxyHost() {
        return this.proxyHost;
    }
}

