/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import lcmc.data.AccessMode;
import lcmc.data.resources.Resource;
import lcmc.gui.Browser;
import lcmc.gui.widget.Widget;
import lcmc.utilities.ButtonCallback;
import lcmc.utilities.MyButton;
import lcmc.utilities.MyButtonCellRenderer;
import lcmc.utilities.MyCellRenderer;
import lcmc.utilities.Tools;
import lcmc.utilities.Unit;
import lcmc.utilities.UpdatableItem;

public class Info
implements Comparable<Info> {
    private DefaultMutableTreeNode node = null;
    private String name;
    private Resource resource;
    private static final float FPS = Tools.getConfigData().getAnimFPS();
    private int maxMenuList = 0;
    private JEditorPane resourceInfoArea;
    private final Map<String, Widget> widgetHash = Collections.synchronizedMap(new HashMap());
    private JPopupMenu popup;
    private final Lock mPopupLock = new ReentrantLock();
    private JMenu menu;
    private final Lock mMenuListLock = new ReentrantLock();
    private List<UpdatableItem> menuList = new ArrayList<UpdatableItem>();
    private boolean updated = false;
    private double animationIndex = 0.0;
    private String infoCache = "";
    private final Browser browser;
    private final Map<String, JTable> tables = new HashMap<String, JTable>();
    private final Map<String, DefaultTableModel> tableModels = new HashMap<String, DefaultTableModel>();
    public static final ImageIcon LOGFILE_ICON = Tools.createImageIcon(Tools.getDefault("Info.LogIcon"));
    private final Map<JTextComponent, AccessMode> componentToEditAccessMode = new HashMap<JTextComponent, AccessMode>();
    private final Map<JComponent, AccessMode> componentToEnableAccessMode = new HashMap<JComponent, AccessMode>();

    Info(String name, Browser browser) {
        this.name = name;
        this.browser = browser;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.name;
    }

    protected Browser getBrowser() {
        return this.browser;
    }

    String getToolTipText(boolean testOnly) {
        return "no tooltip";
    }

    protected final void setResource(Resource resource) {
        this.resource = resource;
    }

    protected final void widgetAdd(String param, String prefix, Widget paramWi) {
        if (prefix == null) {
            this.widgetHash.put(param, paramWi);
        } else {
            this.widgetHash.put(prefix + ":" + param, paramWi);
        }
    }

    public final Widget getWidget(String param, String prefix) {
        if (prefix == null) {
            return this.widgetHash.get(param);
        }
        return this.widgetHash.get(prefix + ":" + param);
    }

    protected final boolean widgetContains(String param, String prefix) {
        if (prefix == null) {
            return this.widgetHash.containsKey(param);
        }
        return this.widgetHash.containsKey(prefix + ":" + param);
    }

    protected final Widget widgetRemove(String param, String prefix) {
        if (prefix == null) {
            if (this.widgetHash.containsKey(param)) {
                this.widgetHash.get(param).cleanup();
                return this.widgetHash.remove(param);
            }
            return null;
        }
        if (this.widgetHash.containsKey(prefix + ":" + param)) {
            this.widgetHash.get(prefix + ":" + param).cleanup();
            return this.widgetHash.remove(prefix + ":" + param);
        }
        return null;
    }

    protected final void widgetClear() {
        for (String param : this.widgetHash.keySet()) {
            this.widgetHash.get(param).cleanup();
        }
        this.widgetHash.clear();
    }

    protected void setTerminalPanel() {
    }

    protected final boolean isUpdated() {
        return this.updated;
    }

    protected void setUpdated(boolean updated) {
        this.updated = updated;
        this.animationIndex = 0.0;
    }

    public final double getAnimationIndex() {
        return this.animationIndex;
    }

    public final void incAnimationIndex() {
        this.animationIndex += 60.0 / (double)FPS;
        if (this.animationIndex > 100.0) {
            this.animationIndex = 0.0;
        }
    }

    public ImageIcon getMenuIcon(boolean testOnly) {
        return null;
    }

    public ImageIcon getCategoryIcon(boolean testOnly) {
        return null;
    }

    public void updateInfo() {
        String newInfo;
        final JEditorPane ria = this.resourceInfoArea;
        if (ria != null && (newInfo = this.getInfo()) != null && !newInfo.equals(this.infoCache)) {
            this.infoCache = newInfo;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ria.setText(newInfo);
                }
            });
        }
    }

    protected void updateInfo(JEditorPane ep) {
    }

    protected String getInfoType() {
        return "text/plain";
    }

    protected JComponent getBackButton() {
        return null;
    }

    public JComponent getInfoPanel() {
        String info = this.getInfo();
        this.resourceInfoArea = null;
        if (info == null) {
            JPanel panel = new JPanel();
            panel.setBackground(Browser.PANEL_BACKGROUND);
            return panel;
        }
        Font f = new Font("Monospaced", 0, Tools.getConfigData().scaled(12));
        this.resourceInfoArea = new JEditorPane(this.getInfoType(), info);
        this.resourceInfoArea.setMinimumSize(new Dimension(Tools.getDefaultSize("HostBrowser.ResourceInfoArea.Width"), Tools.getDefaultSize("HostBrowser.ResourceInfoArea.Height")));
        this.resourceInfoArea.setPreferredSize(new Dimension(Tools.getDefaultSize("HostBrowser.ResourceInfoArea.Width"), Tools.getDefaultSize("HostBrowser.ResourceInfoArea.Height")));
        this.resourceInfoArea.setEditable(false);
        this.resourceInfoArea.setFont(f);
        this.resourceInfoArea.setBackground(Browser.PANEL_BACKGROUND);
        this.updateInfo(this.resourceInfoArea);
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BoxLayout(infoPanel, 1));
        infoPanel.setBackground(Browser.PANEL_BACKGROUND);
        JComponent backButton = this.getBackButton();
        if (backButton != null) {
            infoPanel.add(backButton);
        }
        infoPanel.add(new JScrollPane(this.resourceInfoArea));
        return infoPanel;
    }

    boolean selectAutomaticallyInTreeMenu() {
        return false;
    }

    public JPanel getGraphicalView() {
        return null;
    }

    String getInfo() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    final DefaultMutableTreeNode getNode() {
        return this.node;
    }

    public final void setNode(DefaultMutableTreeNode node) {
        this.node = node;
    }

    void cleanup() {
        this.mMenuListLock.lock();
        if (this.menuList == null) {
            this.mMenuListLock.unlock();
        } else {
            ArrayList<UpdatableItem> menuListCopy = new ArrayList<UpdatableItem>(this.menuList);
            this.mMenuListLock.unlock();
            for (UpdatableItem i : menuListCopy) {
                i.cleanup();
            }
        }
    }

    public void removeMyself(boolean testOnly) {
        this.cleanup();
    }

    public void selectMyself() {
        final DefaultMutableTreeNode n = this.node;
        if (n != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Info.this.getBrowser().reloadAndWait(n, true);
                }
            });
            this.getBrowser().nodeChanged(n);
        }
    }

    public final Resource getResource() {
        return this.resource;
    }

    protected String getToolTipText(String param, String value) {
        return "TODO: ToolTipText";
    }

    public String getInternalValue() {
        if (this.name != null) {
            return this.name.trim();
        }
        return null;
    }

    public final void showPopup(final JComponent c, final int x, final int y) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                final JPopupMenu pm = Info.this.getPopup();
                if (pm != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            pm.show(c, x, y);
                        }
                    });
                }
            }
        });
        thread.start();
    }

    public String getToolTipForGraph(boolean testOnly) {
        return this.getToolTipText(testOnly);
    }

    protected List<UpdatableItem> createPopup() {
        return null;
    }

    public void hidePopup() {
        this.mPopupLock.lock();
        final JPopupMenu popup0 = this.popup;
        this.mPopupLock.unlock();
        if (popup0 != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    popup0.setVisible(false);
                }
            });
        }
    }

    public final JPopupMenu getPopup() {
        List<UpdatableItem> items;
        this.mPopupLock.lock();
        if (this.popup == null && (items = this.createPopup()) != null) {
            this.registerAllMenuItems(items);
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Info.this.popup = new JPopupMenu();
                    }
                });
            }
            catch (InterruptedException ix) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException x) {
                Tools.printStackTrace();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (UpdatableItem u : items) {
                        Info.this.popup.add((JMenuItem)((Object)u));
                    }
                }
            });
        }
        JPopupMenu popup0 = this.popup;
        this.mPopupLock.unlock();
        if (popup0 != null) {
            this.updateMenus(null);
        }
        return popup0;
    }

    public final JPopupMenu getPopup(Point2D pos) {
        List<UpdatableItem> items;
        this.mPopupLock.lock();
        if (this.popup == null && (items = this.createPopup()) != null) {
            this.registerAllMenuItems(items);
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Info.this.popup = new JPopupMenu();
                    }
                });
            }
            catch (InterruptedException ix) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException x) {
                Tools.printStackTrace();
            }
            for (final UpdatableItem u : items) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Info.this.popup.add((JMenuItem)((Object)u));
                    }
                });
            }
        }
        JPopupMenu popup0 = this.popup;
        this.mPopupLock.unlock();
        if (popup0 != null) {
            this.updateMenus(pos);
        }
        return popup0;
    }

    private void addPopupMenuListener(JPopupMenu pm, final AbstractButton b) {
        pm.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        b.setSelected(false);
                    }
                });
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        b.setSelected(false);
                    }
                });
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
    }

    private void showPopup(JPopupMenu pm, AbstractButton b) {
        int w = (int)pm.getBounds().getWidth();
        if (w == 0) {
            pm.show(b, (int)b.getBounds().getWidth(), (int)b.getBounds().getHeight());
            w = (int)pm.getBounds().getWidth();
        }
        pm.show(b, (int)(b.getBounds().getWidth() - (double)w), (int)b.getBounds().getHeight());
        this.addPopupMenuListener(pm, b);
    }

    final JToggleButton getActionsButton() {
        final JToggleButton b = new JToggleButton(Tools.getString("Browser.ActionsMenu"), Browser.MENU_ICON);
        b.setToolTipText(Tools.getString("Browser.ActionsMenu"));
        Tools.makeMiniButton(b);
        b.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JToggleButton source = (JToggleButton)e.getSource();
                if (source.isSelected()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            b.setSelected(true);
                        }
                    });
                } else {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            final JPopupMenu pm = Info.this.getPopup();
                            if (pm != null) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        Info.this.showPopup(pm, b);
                                    }
                                });
                            }
                        }
                    });
                    thread.start();
                }
            }
        });
        return b;
    }

    public final JMenu getMenu() {
        return this.menu;
    }

    protected final void resetPopup() {
        this.mPopupLock.lock();
        this.popup = null;
        this.mPopupLock.unlock();
    }

    void updateMenus(Point2D pos) {
        this.mMenuListLock.lock();
        if (this.menuList == null) {
            this.mMenuListLock.unlock();
        } else {
            ArrayList<UpdatableItem> menuListCopy = new ArrayList<UpdatableItem>(this.menuList);
            this.mMenuListLock.unlock();
            for (UpdatableItem i : menuListCopy) {
                i.setPos(pos);
                i.update();
            }
            int size = menuListCopy.size();
            if (size > this.maxMenuList) {
                this.maxMenuList = size;
                Tools.debug(this, "menu list size: " + this.maxMenuList, 2);
            }
        }
    }

    final void registerAllMenuItems(List<UpdatableItem> allItemsAndSubitems) {
        this.mMenuListLock.lock();
        this.menuList = allItemsAndSubitems;
        this.mMenuListLock.unlock();
    }

    protected Unit[] getUnits() {
        return null;
    }

    protected Unit[] getTimeUnits() {
        return new Unit[]{new Unit("", "s", "Second", "Seconds"), new Unit("msec", "ms", "Millisecond", "Milliseconds"), new Unit("usec", "us", "Microsecond", "Microseconds"), new Unit("sec", "s", "Second", "Seconds"), new Unit("min", "m", "Minute", "Minutes"), new Unit("hr", "h", "Hour", "Hours")};
    }

    protected final void addMouseOverListener(final Component c, final ButtonCallback bc) {
        if (bc == null) {
            return;
        }
        c.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (c.isShowing() && c.isEnabled()) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            bc.mouseOver();
                        }
                    });
                    thread.start();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        bc.mouseOut();
                    }
                });
                t.start();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.mouseExited(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    @Override
    public int compareTo(Info o) {
        return this.toString().compareToIgnoreCase(o.toString());
    }

    protected JComponent getTablePanel(String title, String tableName, MyButton newButton) {
        JPanel p = new JPanel();
        p.setBackground(Browser.PANEL_BACKGROUND);
        p.setLayout(new BoxLayout(p, 1));
        TitledBorder titleBorder = Tools.getBorder(title);
        p.setBorder(titleBorder);
        JTable table = this.getTable(tableName);
        if (table != null) {
            if (newButton != null) {
                JPanel bp = new JPanel(new FlowLayout(0, 0, 0));
                bp.setBackground(Browser.BUTTON_PANEL_BACKGROUND);
                bp.add(newButton);
                Dimension d = bp.getPreferredSize();
                bp.setMaximumSize(new Dimension(Short.MAX_VALUE, (int)d.getHeight()));
                p.add(bp);
            }
            p.add(table.getTableHeader());
            p.add(table);
        }
        return p;
    }

    protected final JTable getTable(final String tableName) {
        Object[] colNames = this.getColumnNames(tableName);
        if (colNames != null && colNames.length > 0) {
            Object[][] data = this.getTableData(tableName);
            DefaultTableModel tableModel = new DefaultTableModel(data, colNames){
                private static final long serialVersionUID = 1L;

                @Override
                public final boolean isCellEditable(int r, int c) {
                    return false;
                }
            };
            this.tableModels.put(tableName, tableModel);
            final MyButtonCellRenderer bcr = new MyButtonCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public final Color getRowColor(String key) {
                    return Info.this.getTableRowColor(tableName, key);
                }

                @Override
                public final int getColumnAlignment(int column) {
                    return Info.this.getTableColumnAlignment(tableName, column);
                }
            };
            final JTable table = new JTable(tableModel){
                private static final long serialVersionUID = 1L;

                public Class getColumnClass(int c) {
                    Object o = this.getValueAt(0, c);
                    if (o == null) {
                        return super.getColumnClass(c);
                    }
                    return o.getClass();
                }

                @Override
                public TableCellRenderer getCellRenderer(int row, int column) {
                    if (column == 0 || Info.this.isControlButton(tableName, column)) {
                        return bcr;
                    }
                    return super.getCellRenderer(row, column);
                }

                @Override
                public String getToolTipText(MouseEvent me) {
                    int row = this.rowAtPoint(me.getPoint());
                    int column = this.columnAtPoint(me.getPoint());
                    try {
                        String key = ((MyButton)this.getValueAt(row, 0)).getText();
                        Object o = this.getValueAt(row, column);
                        return Info.this.getTableToolTip(tableName, key, o, row, column);
                    }
                    catch (IndexOutOfBoundsException e) {
                        return null;
                    }
                }
            };
            this.tables.put(tableName, table);
            TableRowSorter<12> sorter = new TableRowSorter<12>(tableModel);
            for (int i = 0; i < colNames.length; ++i) {
                Comparator<Object> c = this.getColComparator(tableName, i);
                if (c == null) continue;
                sorter.setComparator(i, c);
            }
            table.setRowSorter(sorter);
            sorter.setSortsOnUpdates(true);
            table.getTableHeader().setReorderingAllowed(true);
            table.setBackground(Browser.PANEL_BACKGROUND);
            table.setDefaultRenderer(Object.class, new MyCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public final Color getRowColor(String key) {
                    return Info.this.getTableRowColor(tableName, key);
                }

                @Override
                public final int getColumnAlignment(int column) {
                    return Info.this.getTableColumnAlignment(tableName, column);
                }
            });
            int h = this.getRowHeight();
            if (h >= 0) {
                table.setRowHeight(h);
            }
            table.addMouseMotionListener(new MouseMotionListener(){
                private int row;

                @Override
                public void mouseMoved(MouseEvent me) {
                    Object v;
                    int c;
                    Point p = me.getPoint();
                    int newRow = table.rowAtPoint(p);
                    if (this.row >= 0 && newRow != this.row) {
                        try {
                            for (c = 0; c < table.getColumnCount(); ++c) {
                                v = table.getValueAt(this.row, c);
                                if (!(v instanceof MyButton)) continue;
                                ((MyButton)v).getModel().setRollover(false);
                                table.setValueAt(v, this.row, c);
                            }
                        }
                        catch (IndexOutOfBoundsException e) {
                            // empty catch block
                        }
                    }
                    if (newRow >= 0 && newRow != this.row) {
                        this.row = newRow;
                        for (c = 0; c < table.getColumnCount(); ++c) {
                            v = table.getValueAt(this.row, c);
                            if (!(v instanceof MyButton)) continue;
                            ((MyButton)v).getModel().setRollover(true);
                            table.setValueAt(v, this.row, c);
                        }
                    }
                }

                @Override
                public void mouseDragged(MouseEvent me) {
                }
            });
            table.addMouseListener(new MouseAdapter(){
                private int row;
                private boolean paintIt = false;
                private boolean paintItMouseOver = false;

                @Override
                public final void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() > 1 || SwingUtilities.isRightMouseButton(e)) {
                        return;
                    }
                    JTable table2 = (JTable)e.getSource();
                    Point p = e.getPoint();
                    int row = table2.rowAtPoint(p);
                    int column = table2.columnAtPoint(p);
                    MyButton keyB = (MyButton)table2.getValueAt(row, 0);
                    Info.this.rowClicked(tableName, keyB.getText(), column);
                }

                @Override
                public final void mousePressed(MouseEvent e) {
                    JTable table2 = (JTable)e.getSource();
                    Point p = e.getPoint();
                    this.row = table2.rowAtPoint(p);
                    MyButton b = (MyButton)table2.getValueAt(this.row, 0);
                    if (SwingUtilities.isRightMouseButton(e)) {
                        Info info = Info.this.getTableInfo(tableName, b.getText());
                        if (info != null) {
                            info.showPopup(table2, e.getX(), e.getY());
                        }
                        return;
                    }
                    for (int c = 0; c < table2.getColumnCount(); ++c) {
                        Object v = table2.getValueAt(this.row, c);
                        if (!(v instanceof MyButton)) continue;
                        ((MyButton)v).getModel().setPressed(true);
                        ((MyButton)v).getModel().setArmed(true);
                        table2.setValueAt(v, this.row, c);
                    }
                    this.paintIt = true;
                }

                @Override
                public final void mouseReleased(MouseEvent e) {
                    if (this.paintIt) {
                        for (int c = 0; c < table.getColumnCount(); ++c) {
                            Object v = table.getValueAt(this.row, c);
                            if (!(v instanceof MyButton)) continue;
                            ((MyButton)v).getModel().setPressed(false);
                            ((MyButton)v).getModel().setArmed(false);
                            table.setValueAt(v, this.row, c);
                        }
                    }
                    this.paintIt = false;
                }

                @Override
                public final void mouseEntered(MouseEvent e) {
                    JTable table2 = (JTable)e.getSource();
                    Point p = e.getPoint();
                    int row = table2.rowAtPoint(p);
                    try {
                        for (int c = 0; c < table2.getColumnCount(); ++c) {
                            Object v = table2.getValueAt(row, c);
                            if (!(v instanceof MyButton)) continue;
                            ((MyButton)v).getModel().setRollover(true);
                            table2.setValueAt(v, row, c);
                        }
                        this.paintItMouseOver = true;
                    }
                    catch (IndexOutOfBoundsException ie) {
                        // empty catch block
                    }
                }

                @Override
                public final void mouseExited(MouseEvent e) {
                    if (this.paintItMouseOver) {
                        for (int i = 0; i < table.getRowCount(); ++i) {
                            for (int c = 0; c < table.getColumnCount(); ++c) {
                                Object v = table.getValueAt(i, c);
                                if (!(v instanceof MyButton)) continue;
                                ((MyButton)v).getModel().setRollover(false);
                                table.setValueAt(v, i, c);
                            }
                        }
                    }
                    this.paintItMouseOver = false;
                }
            });
            Tools.resizeTable(table, this.getDefaultWidths(tableName));
            return table;
        }
        return null;
    }

    protected int getTableColumnAlignment(String tableName, int column) {
        return 2;
    }

    protected Info getTableInfo(String tableName, String key) {
        return null;
    }

    protected String[] getColumnNames(String tableName) {
        return new String[0];
    }

    protected Object[][] getTableData(String tableName) {
        return new Object[0][];
    }

    public final void updateTable(final String tableName) {
        String[] colNames;
        Tools.debug(this, "update table: " + tableName, 2);
        final JTable table = this.tables.get(tableName);
        final DefaultTableModel tableModel = this.tableModels.get(tableName);
        if (tableModel != null && (colNames = this.getColumnNames(tableName)) != null && colNames.length > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object[][] data = Info.this.getTableData(tableName);
                    Tools.debug(this, "update table in: " + Info.this.getName(), 1);
                    tableModel.setDataVector(data, colNames);
                    tableModel.fireTableDataChanged();
                    Tools.resizeTable(table, Info.this.getDefaultWidths(tableName));
                }
            });
        }
    }

    protected void rowClicked(String tableName, String key, int column) {
    }

    protected final int getRowHeight() {
        return 40;
    }

    protected Color getTableRowColor(String tableName, String key) {
        return null;
    }

    protected Comparator<Object> getColComparator(String tableName, int col) {
        return null;
    }

    protected Map<Integer, Integer> getDefaultWidths(String tableName) {
        return null;
    }

    protected boolean isControlButton(String tableName, int column) {
        return false;
    }

    protected String getTableToolTip(String tableName, String key, Object object, int raw, int column) {
        if (object instanceof MyButton) {
            return ((MyButton)object).getText();
        }
        return object.toString();
    }

    final void removeNodeAndWait() {
        DefaultMutableTreeNode n = this.node;
        this.node = null;
        if (n == null) {
            return;
        }
        DefaultMutableTreeNode p = (DefaultMutableTreeNode)n.getParent();
        if (p != null) {
            p.remove(n);
            this.getBrowser().reloadAndWait(p, true);
        }
    }

    final void removeNode() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Info.this.removeNodeAndWait();
            }
        });
    }

    public String getMainTextForGraph() {
        return this.toString();
    }

    protected void registerComponentEditAccessMode(JTextComponent component, AccessMode mode) {
        this.componentToEditAccessMode.put(component, mode);
    }

    protected void registerComponentEnableAccessMode(JComponent component, AccessMode mode) {
        this.componentToEnableAccessMode.put(component, mode);
    }

    public void updateAdvancedPanels() {
        boolean accessible;
        for (JComponent jComponent : this.componentToEnableAccessMode.keySet()) {
            accessible = Tools.getConfigData().isAccessible(this.componentToEnableAccessMode.get(jComponent));
            jComponent.setEnabled(accessible);
        }
        for (JTextComponent jTextComponent : this.componentToEditAccessMode.keySet()) {
            accessible = Tools.getConfigData().isAccessible(this.componentToEditAccessMode.get(jTextComponent));
            jTextComponent.setEditable(accessible);
        }
    }
}

