/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import lcmc.data.AccessMode;
import lcmc.data.ClusterStatus;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.ResourceAgent;
import lcmc.data.Subtext;
import lcmc.gui.Browser;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.resources.CloneInfo;
import lcmc.gui.resources.DrbddiskInfo;
import lcmc.gui.resources.FilesystemInfo;
import lcmc.gui.resources.HbConnectionInfo;
import lcmc.gui.resources.IPaddrInfo;
import lcmc.gui.resources.LinbitDrbdInfo;
import lcmc.gui.resources.ServiceInfo;
import lcmc.gui.resources.VirtualDomainInfo;
import lcmc.gui.widget.Widget;
import lcmc.utilities.ButtonCallback;
import lcmc.utilities.CRM;
import lcmc.utilities.MyList;
import lcmc.utilities.MyListModel;
import lcmc.utilities.MyMenu;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.Tools;
import lcmc.utilities.UpdatableItem;

public final class GroupInfo
extends ServiceInfo {
    GroupInfo(ResourceAgent ra, Browser browser) {
        super("Group", ra, browser);
    }

    void applyWhole(Host dcHost, boolean createGroup, List<String> newOrder, boolean testOnly) {
        String[] params = this.getParametersFromXML();
        if (!testOnly) {
            Tools.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GroupInfo.this.getApplyButton().setEnabled(false);
                }
            });
        }
        LinkedHashMap<String, String> groupMetaArgs = new LinkedHashMap<String, String>();
        for (String param : params) {
            if ("__drbdmcid".equals(param) || "__pckmkid".equals(param)) continue;
            String value = this.getComboBoxValue(param);
            if (value == null) {
                value = "";
            }
            if (value.equals(this.getParamDefault(param)) || "".equals(value)) continue;
            if ("group-ordered".equals(param)) {
                groupMetaArgs.put("ordered", value);
                continue;
            }
            groupMetaArgs.put(param, value);
        }
        HashMap<String, Map<String, String>> pacemakerResAttrs = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, String>> pacemakerResArgs = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, String>> pacemakerMetaArgs = new HashMap<String, Map<String, String>>();
        HashMap<String, String> instanceAttrId = new HashMap<String, String>();
        HashMap<String, Map<String, String>> nvpairIdsHash = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, Map<String, String>>> pacemakerOps = new HashMap<String, Map<String, Map<String, String>>>();
        HashMap<String, String> operationsId = new HashMap<String, String>();
        HashMap<String, String> metaAttrsRefId = new HashMap<String, String>();
        HashMap<String, String> operationsRefId = new HashMap<String, String>();
        HashMap<String, Boolean> stonith = new HashMap<String, Boolean>();
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        for (String resId : newOrder) {
            ServiceInfo gsi = this.getBrowser().getServiceInfoFromCRMId(resId);
            if (gsi == null) continue;
            gsi.getInfoPanel();
            gsi.waitForInfoPanel();
            pacemakerResAttrs.put(resId, gsi.getPacemakerResAttrs(testOnly));
            pacemakerResArgs.put(resId, gsi.getPacemakerResArgs());
            pacemakerMetaArgs.put(resId, gsi.getPacemakerMetaArgs());
            instanceAttrId.put(resId, cs.getResourceInstanceAttrId(resId));
            nvpairIdsHash.put(resId, cs.getParametersNvpairsIds(resId));
            pacemakerOps.put(resId, gsi.getOperations(resId));
            operationsId.put(resId, cs.getOperationsId(resId));
            metaAttrsRefId.put(resId, gsi.getMetaAttrsRefId());
            operationsRefId.put(resId, gsi.getOperationsRefId());
            stonith.put(resId, gsi.getResourceAgent().isStonith());
        }
        CloneInfo ci = this.getCloneInfo();
        String cloneId = null;
        boolean master = false;
        LinkedHashMap<String, String> cloneMetaArgs = new LinkedHashMap<String, String>();
        String cloneMetaAttrsRefIds = null;
        if (createGroup && ci != null) {
            cloneId = ci.getHeartbeatId(testOnly);
            String[] cloneParams = ci.getParametersFromXML();
            master = ci.getService().isMaster();
            cloneMetaAttrsRefIds = ci.getMetaAttrsRefId();
            for (String param : cloneParams) {
                String value;
                if ("__drbdmcid".equals(param) || "__pckmkid".equals(param) || (value = ci.getComboBoxValue(param)).equals(ci.getParamDefault(param)) || "__drbdmcid".equals(param) || "".equals(value)) continue;
                cloneMetaArgs.put(param, value);
            }
        }
        CRM.replaceGroup(createGroup, dcHost, cloneId, master, cloneMetaArgs, cloneMetaAttrsRefIds, newOrder, groupMetaArgs, this.getHeartbeatId(testOnly), pacemakerResAttrs, pacemakerResArgs, pacemakerMetaArgs, instanceAttrId, nvpairIdsHash, pacemakerOps, operationsId, metaAttrsRefId, this.getMetaAttrsRefId(), operationsRefId, stonith, testOnly);
        if (!testOnly) {
            this.storeComboBoxValues(params);
            this.getBrowser().reload(this.getNode(), false);
        }
        this.getBrowser().getCRMGraph().repaint();
    }

    @Override
    void apply(Host dcHost, boolean testOnly) {
        ClusterStatus cs;
        List<String> resources;
        if (!testOnly) {
            Tools.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GroupInfo.this.getApplyButton().setEnabled(false);
                    GroupInfo.this.getRevertButton().setEnabled(false);
                }
            });
        }
        this.getInfoPanel();
        this.waitForInfoPanel();
        String[] params = this.getParametersFromXML();
        if (!testOnly) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GroupInfo.this.getApplyButton().setToolTipText(null);
                    Widget idField = GroupInfo.this.getWidget("__drbdmcid", null);
                    idField.setEnabled(false);
                }
            });
            this.getBrowser().removeFromServiceInfoHash(this);
            String oldHeartbeatId = this.getHeartbeatId(testOnly);
            if (oldHeartbeatId != null) {
                this.getBrowser().mHeartbeatIdToServiceLock();
                this.getBrowser().getHeartbeatIdToServiceInfo().remove(oldHeartbeatId);
                this.getBrowser().mHeartbeatIdToServiceUnlock();
            }
            if (this.getService().isNew()) {
                String id = this.getComboBoxValue("__drbdmcid");
                this.getService().setIdAndCrmId(id);
                if (this.getTypeRadioGroup() != null) {
                    this.getTypeRadioGroup().setEnabled(false);
                }
            }
            this.getBrowser().addNameToServiceInfoHash(this);
            this.getBrowser().addToHeartbeatIdList(this);
        }
        String heartbeatId = this.getHeartbeatId(testOnly);
        if (this.getService().isNew()) {
            Set<ServiceInfo> parents = this.getBrowser().getCRMGraph().getParents(this);
            ArrayList<Map<String, String>> colAttrsList = new ArrayList<Map<String, String>>();
            ArrayList<Map<String, String>> ordAttrsList = new ArrayList<Map<String, String>>();
            ArrayList<String> parentIds = new ArrayList<String>();
            for (ServiceInfo parentInfo : parents) {
                String parentId = parentInfo.getService().getHeartbeatId();
                parentIds.add(parentId);
                LinkedHashMap<String, String> colAttrs = new LinkedHashMap<String, String>();
                LinkedHashMap<String, String> ordAttrs = new LinkedHashMap<String, String>();
                colAttrs.put("score", "INFINITY");
                ordAttrs.put("score", "INFINITY");
                if (this.getService().isMaster()) {
                    colAttrs.put("with-rsc-role", "Master");
                    ordAttrs.put("first-action", "promote");
                    ordAttrs.put("then-action", "start");
                }
                colAttrsList.add(colAttrs);
                ordAttrsList.add(ordAttrs);
            }
            CRM.setOrderAndColocation(dcHost, heartbeatId, parentIds.toArray(new String[parentIds.size()]), colAttrsList, ordAttrsList, testOnly);
            Enumeration<TreeNode> e = this.getNode().children();
            ArrayList<String> newOrder = new ArrayList<String>();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                ServiceInfo child = (ServiceInfo)n.getUserObject();
                newOrder.add(child.getHeartbeatId(testOnly));
            }
            this.applyWhole(dcHost, true, newOrder, testOnly);
            if (!testOnly) {
                this.setApplyButtons(null, params);
            }
            this.getBrowser().getCRMGraph().repaint();
            return;
        }
        LinkedHashMap<String, String> groupMetaArgs = new LinkedHashMap<String, String>();
        for (String param : params) {
            String value;
            if ("__drbdmcid".equals(param) || "__pckmkid".equals(param) || (value = this.getComboBoxValue(param)).equals(this.getParamDefault(param)) || "".equals(value)) continue;
            if ("group-ordered".equals(param)) {
                groupMetaArgs.put("ordered", value);
                continue;
            }
            groupMetaArgs.put(param, value);
        }
        CRM.setParameters(dcHost, "-R", null, null, false, null, groupMetaArgs, heartbeatId, null, null, null, null, null, null, null, null, null, this.getMetaAttrsRefId(), null, false, testOnly);
        CloneInfo ci = this.getCloneInfo();
        if (ci == null) {
            this.setLocations(heartbeatId, dcHost, testOnly);
        } else {
            ci.setLocations(heartbeatId, dcHost, testOnly);
        }
        if (!testOnly) {
            this.storeComboBoxValues(params);
            this.getBrowser().reload(this.getNode(), false);
        }
        if ((resources = (cs = this.getBrowser().getClusterStatus()).getGroupResources(this.getHeartbeatId(testOnly), testOnly)) != null) {
            for (String hbId : resources) {
                ServiceInfo gsi = this.getBrowser().getServiceInfoFromCRMId(hbId);
                if (gsi == null || !gsi.checkResourceFieldsCorrect(null, gsi.getParametersFromXML(), false, false, true) || !gsi.checkResourceFieldsChanged(null, gsi.getParametersFromXML(), false, false, true)) continue;
                gsi.apply(dcHost, testOnly);
            }
        }
        if (!testOnly) {
            this.setApplyButtons(null, params);
        }
        this.getBrowser().getCRMGraph().repaint();
    }

    List<ResourceAgent> getAddGroupServiceList(String cl) {
        return this.getBrowser().getCRMXML().getServices(cl);
    }

    void addGroupServicePanel(ServiceInfo newServiceInfo, boolean reloadNode) {
        DefaultMutableTreeNode gn = this.getNode();
        if (gn == null) {
            return;
        }
        newServiceInfo.getService().setResourceClass(newServiceInfo.getResourceAgent().getResourceClass());
        newServiceInfo.setGroupInfo(this);
        this.getBrowser().addNameToServiceInfoHash(newServiceInfo);
        this.getBrowser().addToHeartbeatIdList(newServiceInfo);
        DefaultMutableTreeNode newServiceNode = new DefaultMutableTreeNode(newServiceInfo);
        newServiceInfo.setNode(newServiceNode);
        gn.add(newServiceNode);
        if (reloadNode) {
            this.getBrowser().reload(gn, false);
            this.getBrowser().reload(newServiceNode, true);
        }
    }

    ServiceInfo addGroupServicePanel(ResourceAgent newRA, boolean reloadNode) {
        ServiceInfo newServiceInfo;
        String name = newRA.getName();
        if (newRA.isFilesystem()) {
            newServiceInfo = new FilesystemInfo(name, newRA, this.getBrowser());
        } else if (newRA.isLinbitDrbd()) {
            newServiceInfo = new LinbitDrbdInfo(name, newRA, this.getBrowser());
        } else if (newRA.isDrbddisk()) {
            newServiceInfo = new DrbddiskInfo(name, newRA, this.getBrowser());
        } else if (newRA.isIPaddr()) {
            newServiceInfo = new IPaddrInfo(name, newRA, this.getBrowser());
        } else if (newRA.isVirtualDomain()) {
            newServiceInfo = new VirtualDomainInfo(name, newRA, this.getBrowser());
        } else {
            if (newRA.isGroup()) {
                Tools.appError("No groups in group allowed");
                return null;
            }
            newServiceInfo = new ServiceInfo(name, newRA, this.getBrowser());
        }
        this.addGroupServicePanel(newServiceInfo, reloadNode);
        return newServiceInfo;
    }

    @Override
    List<String> getRunningOnNodes(boolean testOnly) {
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        List<String> resources = cs.getGroupResources(this.getHeartbeatId(testOnly), testOnly);
        ArrayList<String> allNodes = new ArrayList<String>();
        if (resources != null) {
            for (String hbId : resources) {
                List<String> ns = cs.getRunningOnNodes(hbId, testOnly);
                if (ns == null) continue;
                for (String n : ns) {
                    if (allNodes.contains(n)) continue;
                    allNodes.add(n);
                }
            }
        }
        return allNodes;
    }

    @Override
    List<String> getMasterOnNodes(boolean testOnly) {
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        List<String> resources = cs.getGroupResources(this.getHeartbeatId(testOnly), testOnly);
        ArrayList<String> allNodes = new ArrayList<String>();
        if (resources != null) {
            for (String hbId : resources) {
                List<String> ns = cs.getMasterOnNodes(hbId, testOnly);
                if (ns == null) continue;
                for (String n : ns) {
                    if (allNodes.contains(n)) continue;
                    allNodes.add(n);
                }
            }
        }
        return allNodes;
    }

    @Override
    void startResource(Host dcHost, boolean testOnly) {
        ClusterStatus cs;
        List<String> resources;
        if (!testOnly) {
            this.setUpdated(true);
        }
        if ((resources = (cs = this.getBrowser().getClusterStatus()).getGroupResources(this.getHeartbeatId(testOnly), testOnly)) != null) {
            for (String hbId : resources) {
                CRM.startResource(dcHost, hbId, testOnly);
            }
        }
    }

    @Override
    void stopResource(Host dcHost, boolean testOnly) {
        ClusterStatus cs;
        List<String> resources;
        if (!testOnly) {
            this.setUpdated(true);
        }
        if ((resources = (cs = this.getBrowser().getClusterStatus()).getGroupResources(this.getHeartbeatId(testOnly), testOnly)) != null) {
            for (String hbId : resources) {
                CRM.stopResource(dcHost, hbId, testOnly);
            }
        }
    }

    @Override
    void cleanupResource(Host dcHost, boolean testOnly) {
        ClusterStatus cs;
        List<String> resources;
        if (!testOnly) {
            this.setUpdated(true);
        }
        if ((resources = (cs = this.getBrowser().getClusterStatus()).getGroupResources(this.getHeartbeatId(testOnly), testOnly)) != null) {
            for (String hbId : resources) {
                ServiceInfo gsi = this.getBrowser().getServiceInfoFromCRMId(hbId);
                if (gsi == null) continue;
                gsi.cleanupResource(dcHost, testOnly);
            }
        }
    }

    @Override
    void setManaged(boolean isManaged, Host dcHost, boolean testOnly) {
        ClusterStatus cs;
        List<String> resources;
        if (!testOnly) {
            this.setUpdated(true);
        }
        if ((resources = (cs = this.getBrowser().getClusterStatus()).getGroupResources(this.getHeartbeatId(testOnly), testOnly)) != null) {
            for (String hbId : resources) {
                CRM.setManaged(dcHost, hbId, isManaged, testOnly);
            }
        }
    }

    @Override
    public List<UpdatableItem> createPopup() {
        boolean testOnly = false;
        final GroupInfo thisGroupInfo = this;
        MyMenu addGroupServiceMenuItem = new MyMenu(Tools.getString("ClusterBrowser.Hb.AddGroupService"), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;
            private final Lock mUpdateLock;
            {
                super(x0, x1, x2);
                this.mUpdateLock = new ReentrantLock();
            }

            @Override
            public String enablePredicate() {
                if (GroupInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                return null;
            }

            @Override
            public void update() {
                Thread t = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (mUpdateLock.tryLock()) {
                            try {
                                this.updateThread();
                            }
                            finally {
                                mUpdateLock.unlock();
                            }
                        }
                    }
                });
                t.start();
            }

            private void updateThread() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.setEnabled(false);
                    }
                });
                Tools.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        this.removeAll();
                    }
                });
                final ArrayList<JDialog> popups = new ArrayList<JDialog>();
                for (String cl : ClusterBrowser.HB_CLASSES) {
                    final MyMenu classItem = new MyMenu(ClusterBrowser.HB_CLASS_MENU.get(cl), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false));
                    MyListModel<MyMenuItem> dlm = new MyListModel<MyMenuItem>();
                    for (final ResourceAgent ra : GroupInfo.this.getAddGroupServiceList(cl)) {
                        MyMenuItem mmi = new MyMenuItem(ra.getMenuName(), null, null, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
                            private static final long serialVersionUID = 1L;

                            @Override
                            public void action() {
                                CloneInfo ci = GroupInfo.this.getCloneInfo();
                                if (ci != null) {
                                    ci.hidePopup();
                                }
                                GroupInfo.this.hidePopup();
                                for (JDialog otherP : popups) {
                                    otherP.dispose();
                                }
                                if (ra.isLinbitDrbd() && !GroupInfo.this.getBrowser().linbitDrbdConfirmDialog()) {
                                    return;
                                }
                                GroupInfo.this.addGroupServicePanel(ra, true);
                                this.repaint();
                            }
                        };
                        dlm.addElement(mmi);
                    }
                    boolean ret = Tools.getScrollingMenu(ClusterBrowser.HB_CLASS_MENU.get(cl), null, classItem, dlm, new MyList<MyMenuItem>(dlm, this.getBackground()), thisGroupInfo, popups, null);
                    if (!ret) {
                        classItem.setEnabled(false);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.add(classItem);
                        }
                    });
                }
                Tools.waitForSwing();
                super.update();
            }
        };
        ArrayList<UpdatableItem> items = new ArrayList<UpdatableItem>();
        items.add(addGroupServiceMenuItem);
        for (UpdatableItem item : super.createPopup()) {
            items.add(item);
        }
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        List<String> resources = cs.getGroupResources(this.getHeartbeatId(false), false);
        if (resources != null) {
            for (String hbId : resources) {
                final ServiceInfo gsi = this.getBrowser().getServiceInfoFromCRMId(hbId);
                if (gsi == null) continue;
                MyMenu groupServicesMenu = new MyMenu(gsi.toString(), new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
                    private static final long serialVersionUID = 1L;
                    private final Lock mUpdateLock;
                    {
                        super(x0, x1, x2);
                        this.mUpdateLock = new ReentrantLock();
                    }

                    @Override
                    public String enablePredicate() {
                        return null;
                    }

                    @Override
                    public void update() {
                        Thread t = new Thread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (mUpdateLock.tryLock()) {
                                    try {
                                        this.updateThread();
                                    }
                                    finally {
                                        mUpdateLock.unlock();
                                    }
                                }
                            }
                        });
                        t.start();
                    }

                    public void updateThread() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                this.setEnabled(false);
                            }
                        });
                        Tools.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                this.removeAll();
                            }
                        });
                        final ArrayList<UpdatableItem> serviceMenus = new ArrayList<UpdatableItem>();
                        for (UpdatableItem u : gsi.createPopup()) {
                            serviceMenus.add(u);
                            u.update();
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                for (UpdatableItem u : serviceMenus) {
                                    this.add((JMenuItem)((Object)u));
                                }
                            }
                        });
                        super.update();
                    }
                };
                items.add(groupServicesMenu);
            }
        }
        return items;
    }

    @Override
    public void removeMyself(boolean testOnly) {
        if (this.getService().isNew()) {
            this.removeMyselfNoConfirm(this.getBrowser().getDCHost(), testOnly);
            this.getService().setNew(false);
            this.removeInfo();
            this.getService().doneRemoving();
            return;
        }
        String desc = Tools.getString("ClusterBrowser.confirmRemoveGroup.Description");
        StringBuilder services = new StringBuilder();
        Enumeration<TreeNode> e = this.getNode().children();
        try {
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                ServiceInfo child = (ServiceInfo)n.getUserObject();
                services.append(child.toString());
                if (!e.hasMoreElements()) continue;
                services.append(", ");
            }
        }
        catch (NoSuchElementException ele) {
            Tools.info("removing aborted");
            return;
        }
        desc = desc.replaceAll("@GROUP@", "'" + Matcher.quoteReplacement(this.toString()) + "'");
        desc = desc.replaceAll("@SERVICES@", Matcher.quoteReplacement(services.toString()));
        if (Tools.confirmDialog(Tools.getString("ClusterBrowser.confirmRemoveGroup.Title"), desc, Tools.getString("ClusterBrowser.confirmRemoveGroup.Yes"), Tools.getString("ClusterBrowser.confirmRemoveGroup.No"))) {
            if (!testOnly) {
                this.getService().setRemoved(true);
            }
            this.removeMyselfNoConfirm(this.getBrowser().getDCHost(), testOnly);
            this.removeInfo();
            this.getService().setNew(false);
        }
        this.getService().doneRemoving();
    }

    @Override
    public void removeMyselfNoConfirm(Host dcHost, boolean testOnly) {
        ArrayList<ServiceInfo> children = new ArrayList<ServiceInfo>();
        if (!testOnly) {
            Enumeration<TreeNode> e = this.getNode().children();
            try {
                while (e.hasMoreElements()) {
                    DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                    ServiceInfo child = (ServiceInfo)n.getUserObject();
                    child.getService().setRemoved(true);
                    children.add(child);
                }
            }
            catch (NoSuchElementException ele) {
                Tools.info("removing aborted");
                return;
            }
        }
        if (this.getService().isNew()) {
            if (!testOnly) {
                this.getService().setNew(false);
                this.getBrowser().getCRMGraph().killRemovedVertices();
                this.getService().doneRemoving();
            }
        } else {
            String cloneId = null;
            boolean master = false;
            CloneInfo ci = this.getCloneInfo();
            if (ci != null) {
                cloneId = ci.getHeartbeatId(testOnly);
                master = ci.getService().isMaster();
            }
            super.removeMyselfNoConfirm(dcHost, testOnly);
            for (ServiceInfo child : children) {
                child.removeConstraints(dcHost, testOnly);
            }
            CRM.removeResource(dcHost, null, this.getHeartbeatId(testOnly), cloneId, master, testOnly);
            for (ServiceInfo child : children) {
                child.cleanupResource(dcHost, testOnly);
            }
        }
        if (!testOnly) {
            for (ServiceInfo child : children) {
                this.getBrowser().mHeartbeatIdToServiceLock();
                this.getBrowser().getHeartbeatIdToServiceInfo().remove(child.getService().getHeartbeatId());
                this.getBrowser().mHeartbeatIdToServiceUnlock();
                this.getBrowser().removeFromServiceInfoHash(child);
                child.cleanup();
                child.getService().doneRemoving();
            }
        }
    }

    void removeMyselfNoConfirmFromChild(Host dcHost, boolean testOnly) {
        super.removeMyselfNoConfirm(dcHost, testOnly);
    }

    @Override
    public String getToolTipText(boolean testOnly) {
        List<String> hostNames = this.getRunningOnNodes(testOnly);
        StringBuilder sb = new StringBuilder(220);
        sb.append("<b>");
        sb.append(this.toString());
        if (hostNames == null || hostNames.isEmpty()) {
            sb.append(" not running");
        } else if (hostNames.size() == 1) {
            sb.append(" running on node: ");
        } else {
            sb.append(" running on nodes: ");
        }
        if (hostNames != null && !hostNames.isEmpty()) {
            sb.append(Tools.join(", ", hostNames.toArray(new String[hostNames.size()])));
        }
        sb.append("</b>");
        Enumeration<TreeNode> e = this.getNode().children();
        try {
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                ServiceInfo child = (ServiceInfo)n.getUserObject();
                sb.append("\n&nbsp;&nbsp;&nbsp;");
                sb.append(child.getToolTipText(testOnly));
            }
        }
        catch (NoSuchElementException ele) {
            // empty catch block
        }
        return sb.toString();
    }

    @Override
    boolean isOneFailed(boolean testOnly) {
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        List<String> resources = cs.getGroupResources(this.getHeartbeatId(testOnly), testOnly);
        if (resources != null) {
            for (String hbId : resources) {
                ServiceInfo gsi = this.getBrowser().getServiceInfoFromCRMId(hbId);
                if (gsi == null || !gsi.isOneFailed(testOnly)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    boolean isOneFailedCount(boolean testOnly) {
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        List<String> resources = cs.getGroupResources(this.getHeartbeatId(testOnly), testOnly);
        if (resources != null) {
            for (String hbId : resources) {
                ServiceInfo gsi = this.getBrowser().getServiceInfoFromCRMId(hbId);
                if (gsi == null || !gsi.isOneFailedCount(testOnly)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isFailed(boolean testOnly) {
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        List<String> resources = cs.getGroupResources(this.getHeartbeatId(testOnly), testOnly);
        if (resources != null) {
            for (String hbId : resources) {
                ServiceInfo si = this.getBrowser().getServiceInfoFromCRMId(hbId);
                if (si == null || !si.isFailed(testOnly)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Subtext[] getSubtextsForGraph(boolean testOnly) {
        ArrayList<Subtext> texts = new ArrayList<Subtext>();
        Subtext prevSubtext = null;
        Host dcHost = this.getBrowser().getDCHost();
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        List<String> resources = cs.getGroupResources(this.getHeartbeatId(testOnly), testOnly);
        if (resources != null) {
            for (String resId : resources) {
                ServiceInfo si = this.getBrowser().getServiceInfoFromCRMId(resId);
                if (si == null) continue;
                Subtext[] subtexts = si.getSubtextsForGraph(testOnly);
                Subtext sSubtext = null;
                if (subtexts == null || subtexts.length == 0) continue;
                sSubtext = subtexts[0];
                if (prevSubtext == null || !sSubtext.getSubtext().equals(prevSubtext.getSubtext())) {
                    texts.add(new Subtext(sSubtext.getSubtext() + ":", sSubtext.getColor(), Color.BLACK));
                    prevSubtext = sSubtext;
                }
                String unmanaged = "";
                if (!si.isManaged(testOnly)) {
                    unmanaged = " / unmanaged";
                }
                String migrated = "";
                if (si.getMigratedTo(testOnly) != null || si.getMigratedFrom(testOnly) != null) {
                    migrated = " / migrated";
                }
                HbConnectionInfo[] hbcis = this.getBrowser().getCRMGraph().getHbConnections(si);
                String constraintLeft = "";
                String constraint = "";
                if (hbcis != null) {
                    boolean scoreFirst = false;
                    boolean scoreThen = false;
                    boolean someConnection = false;
                    for (HbConnectionInfo hbci : hbcis) {
                        if (hbci == null) continue;
                        if (!someConnection && hbci.hasColocationOrOrder(si)) {
                            someConnection = true;
                        }
                        if (!scoreFirst && !hbci.isOrdScoreNull(si, null)) {
                            scoreFirst = true;
                        }
                        if (scoreThen || hbci.isOrdScoreNull(null, si)) continue;
                        scoreThen = true;
                    }
                    if (someConnection) {
                        if (scoreFirst || scoreThen) {
                            if (scoreFirst) {
                                constraint = " \u2192";
                            }
                            if (scoreThen) {
                                constraintLeft = "\u2192 ";
                            }
                        } else {
                            constraint = " --";
                        }
                    }
                }
                texts.add(new Subtext("   " + constraintLeft + si.toString() + unmanaged + migrated + constraint, sSubtext.getColor(), Color.BLACK));
                boolean skip = true;
                for (Subtext st : subtexts) {
                    if (skip) {
                        skip = false;
                        continue;
                    }
                    texts.add(new Subtext("   " + st.getSubtext(), st.getColor(), Color.BLACK));
                }
            }
        }
        return texts.toArray(new Subtext[texts.size()]);
    }

    @Override
    public List<Host> getMigratedFrom(boolean testOnly) {
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        List<String> resources = cs.getGroupResources(this.getHeartbeatId(testOnly), testOnly);
        List<Host> hosts = super.getMigratedFrom(testOnly);
        if (resources == null) {
            return null;
        }
        if (resources.isEmpty()) {
            return null;
        }
        for (String hbId : resources) {
            List<Host> siHosts;
            ServiceInfo si = this.getBrowser().getServiceInfoFromCRMId(hbId);
            if (si == null || (siHosts = si.getMigratedFrom(testOnly)) == null) continue;
            if (hosts == null) {
                hosts = new ArrayList<Host>();
            }
            hosts.addAll(siHosts);
        }
        return hosts;
    }

    @Override
    public boolean isManaged(boolean testOnly) {
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        List<String> resources = cs.getGroupResources(this.getHeartbeatId(testOnly), testOnly);
        if (resources == null) {
            return true;
        }
        if (resources.isEmpty()) {
            return true;
        }
        for (String hbId : resources) {
            ServiceInfo si = this.getBrowser().getServiceInfoFromCRMId(hbId);
            if (si == null || si.isManaged(testOnly)) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean isStarted(boolean testOnly) {
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        List<String> resources = cs.getGroupResources(this.getHeartbeatId(testOnly), testOnly);
        if (resources != null) {
            for (String hbId : resources) {
                ServiceInfo si = this.getBrowser().getServiceInfoFromCRMId(hbId);
                if (si == null || si.isStarted(testOnly)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isStopped(boolean testOnly) {
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        List<String> resources = cs.getGroupResources(this.getHeartbeatId(testOnly), testOnly);
        if (resources != null) {
            for (String hbId : resources) {
                ServiceInfo si = this.getBrowser().getServiceInfoFromCRMId(hbId);
                if (si == null || !si.isStopped(testOnly)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    boolean isGroupStopped(boolean testOnly) {
        return super.isStopped(testOnly);
    }

    boolean isOneRunning(boolean testOnly) {
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        List<String> resources = cs.getGroupResources(this.getHeartbeatId(testOnly), testOnly);
        if (resources != null) {
            for (String hbId : resources) {
                ServiceInfo si = this.getBrowser().getServiceInfoFromCRMId(hbId);
                if (si == null || !si.isRunning(testOnly)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isRunning(boolean testOnly) {
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        List<String> resources = cs.getGroupResources(this.getHeartbeatId(testOnly), testOnly);
        if (resources != null) {
            for (String hbId : resources) {
                ServiceInfo si = this.getBrowser().getServiceInfoFromCRMId(hbId);
                if (si == null || si.isRunning(testOnly)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean checkResourceFieldsChanged(String param, String[] params) {
        return this.checkResourceFieldsChanged(param, params, false, false);
    }

    boolean checkResourceFieldsChanged(String param, String[] params, boolean fromServicesInfo, boolean fromCloneInfo) {
        DefaultMutableTreeNode gn = this.getNode();
        if (gn == null) {
            return false;
        }
        Enumeration<TreeNode> se = gn.children();
        if (!se.hasMoreElements()) {
            return false;
        }
        boolean changed = super.checkResourceFieldsChanged(param, params, fromServicesInfo, fromCloneInfo, true);
        Enumeration<TreeNode> e = gn.children();
        try {
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                ServiceInfo gsi = (ServiceInfo)n.getUserObject();
                if (!gsi.checkResourceFieldsChanged(null, gsi.getParametersFromXML(), fromServicesInfo, fromCloneInfo, true)) continue;
                changed = true;
            }
        }
        catch (NoSuchElementException ele) {
            return false;
        }
        return changed;
    }

    @Override
    public boolean checkResourceFieldsCorrect(String param, String[] params) {
        return this.checkResourceFieldsCorrect(param, params, false, false);
    }

    boolean checkResourceFieldsCorrect(String param, String[] params, boolean fromServicesInfo, boolean fromCloneInfo) {
        boolean cor = super.checkResourceFieldsCorrect(param, params, fromServicesInfo, fromCloneInfo, true);
        DefaultMutableTreeNode gn = this.getNode();
        if (gn != null) {
            Enumeration<TreeNode> e = gn.children();
            if (!e.hasMoreElements()) {
                return false;
            }
            try {
                while (e.hasMoreElements()) {
                    DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                    ServiceInfo gsi = (ServiceInfo)n.getUserObject();
                    if (gsi.checkResourceFieldsCorrect(null, gsi.getParametersFromXML(), fromServicesInfo, fromCloneInfo, true)) continue;
                    cor = false;
                }
            }
            catch (NoSuchElementException ele) {
                return false;
            }
        }
        return cor;
    }

    @Override
    void updateMenus(Point2D pos) {
        super.updateMenus(pos);
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        List<String> resources = cs.getGroupResources(this.getHeartbeatId(false), false);
        if (resources != null) {
            for (String hbId : resources) {
                ServiceInfo si = this.getBrowser().getServiceInfoFromCRMId(hbId);
                if (si == null) continue;
                si.updateMenus(pos);
            }
        }
    }

    @Override
    protected void addExistingGroupServiceMenuItems(ServiceInfo asi, MyListModel<MyMenuItem> dlm, Map<MyMenuItem, ButtonCallback> callbackHash, MyList<MyMenuItem> list, JCheckBox colocationCB, JCheckBox orderCB, List<JDialog> popups, boolean testOnly) {
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        List<String> resources = cs.getGroupResources(this.getHeartbeatId(false), false);
        if (resources != null) {
            for (String hbId : resources) {
                ServiceInfo si = this.getBrowser().getServiceInfoFromCRMId(hbId);
                if (si == null) continue;
                asi.addExistingServiceMenuItem("         " + si.toString(), si, dlm, callbackHash, list, colocationCB, orderCB, popups, testOnly);
            }
        }
    }

    @Override
    public ImageIcon getCategoryIcon(boolean testOnly) {
        if (this.getBrowser().allHostsDown() || !this.isOneRunning(testOnly)) {
            return ServiceInfo.SERVICE_STOPPED_ICON_SMALL;
        }
        return ServiceInfo.SERVICE_RUNNING_ICON_SMALL;
    }

    @Override
    public void revert() {
        super.revert();
        Enumeration<TreeNode> e = this.getNode().children();
        try {
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                ServiceInfo gsi = (ServiceInfo)n.getUserObject();
                if (gsi == null || !gsi.checkResourceFieldsChanged(null, gsi.getParametersFromXML(), true, false, false)) continue;
                gsi.revert();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }
}

