/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import lcmc.AddDrbdSplitBrainDialog;
import lcmc.Exceptions;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.data.DRBDtestData;
import lcmc.data.DrbdXML;
import lcmc.data.Host;
import lcmc.data.resources.DrbdVolume;
import lcmc.gui.Browser;
import lcmc.gui.CRMGraph;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.dialog.cluster.DrbdLogs;
import lcmc.gui.resources.BlockDevInfo;
import lcmc.gui.resources.CloneInfo;
import lcmc.gui.resources.CommonDeviceInterface;
import lcmc.gui.resources.DrbdInfo;
import lcmc.gui.resources.DrbdResourceInfo;
import lcmc.gui.resources.DrbddiskInfo;
import lcmc.gui.resources.EditableInfo;
import lcmc.gui.resources.FilesystemInfo;
import lcmc.gui.resources.GroupInfo;
import lcmc.gui.resources.LinbitDrbdInfo;
import lcmc.gui.resources.ServiceInfo;
import lcmc.utilities.ButtonCallback;
import lcmc.utilities.DRBD;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.Tools;
import lcmc.utilities.UpdatableItem;

public final class DrbdVolumeInfo
extends EditableInfo
implements CommonDeviceInterface {
    private final DrbdResourceInfo drbdResourceInfo;
    private final List<BlockDevInfo> blockDevInfos;
    private String device;
    private String createdFs = null;
    private JComponent infoPanel = null;
    private final Set<Host> hosts;
    static final String DRBD_VOL_PARAM_DEV = "device";
    static final String DRBD_VOL_PARAM_NUMBER = "number";
    static final String IS_USED_BY_CRM_STRING = "it is used by cluster manager";
    static final String IS_SYNCING_STRING = "it is being full-synced";
    static final String IS_VERIFYING_STRING = "it is being verified";
    static final String[] PARAMS = new String[]{"number", "device"};
    static final String SECTION_STRING = Tools.getString("DrbdVolumeInfo.VolumeSection");
    private static final Map<String, String> LONG_DESC = Collections.unmodifiableMap(new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(DrbdVolumeInfo.DRBD_VOL_PARAM_DEV, "DRBD device");
            this.put(DrbdVolumeInfo.DRBD_VOL_PARAM_NUMBER, "DRBD Volume number");
        }
    });
    private static final Map<String, String> SHORT_DESC = Collections.unmodifiableMap(new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(DrbdVolumeInfo.DRBD_VOL_PARAM_DEV, Tools.getString("DrbdVolumeInfo.Device"));
            this.put(DrbdVolumeInfo.DRBD_VOL_PARAM_NUMBER, Tools.getString("DrbdVolumeInfo.Number"));
        }
    });
    private static final Map<String, Object[]> POSSIBLE_CHOICES = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(DrbdVolumeInfo.DRBD_VOL_PARAM_DEV, new String[]{"/dev/drbd0", "/dev/drbd1", "/dev/drbd2", "/dev/drbd3", "/dev/drbd4", "/dev/drbd5", "/dev/drbd6", "/dev/drbd7", "/dev/drbd8", "/dev/drbd9"});
            this.put(DrbdVolumeInfo.DRBD_VOL_PARAM_NUMBER, new String[]{"0", "1", "2", "3", "4", "5"});
        }
    });
    private static final String BY_RES_DEV_DIR = "/dev/drbd/by-res/";

    DrbdVolumeInfo(String name, String device, DrbdResourceInfo drbdResourceInfo, List<BlockDevInfo> blockDevInfos, Browser browser) {
        super(name, browser);
        assert (drbdResourceInfo != null);
        assert (blockDevInfos.size() >= 2);
        this.drbdResourceInfo = drbdResourceInfo;
        this.blockDevInfos = Collections.unmodifiableList(blockDevInfos);
        this.device = device;
        this.hosts = DrbdVolumeInfo.getHostsFromBlockDevices(blockDevInfos);
        this.setResource(new DrbdVolume(name));
        this.getResource().setValue(DRBD_VOL_PARAM_DEV, device);
        this.getResource().setNew(true);
    }

    @Override
    public JComponent getInfoPanel() {
        this.getBrowser().getDrbdGraph().pickInfo(this);
        JComponent driPanel = this.getDrbdResourceInfo().getInfoPanel();
        this.getInfoPanelVolume();
        this.infoPanelDone();
        return driPanel;
    }

    private JComponent getInfoPanelVolume() {
        this.getBrowser().getDrbdGraph().pickInfo(this);
        if (this.infoPanel != null) {
            return this.infoPanel;
        }
        ButtonCallback buttonCallback = new ButtonCallback(){
            private volatile boolean mouseStillOver = false;

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public void mouseOut() {
                if (!this.isEnabled()) {
                    return;
                }
                this.mouseStillOver = false;
                DrbdVolumeInfo.this.getBrowser().getDrbdGraph().stopTestAnimation(DrbdVolumeInfo.this.getApplyButton());
                DrbdVolumeInfo.this.getApplyButton().setToolTipText(null);
            }

            @Override
            public void mouseOver() {
                if (!this.isEnabled()) {
                    return;
                }
                this.mouseStillOver = true;
                DrbdVolumeInfo.this.getApplyButton().setToolTipText(Tools.getString("ClusterBrowser.StartingDRBDtest"));
                DrbdVolumeInfo.this.getApplyButton().setToolTipBackground(Tools.getDefaultColor("ClusterBrowser.Test.Tooltip.Background"));
                Tools.sleep(250);
                if (!this.mouseStillOver) {
                    return;
                }
                this.mouseStillOver = false;
                CountDownLatch startTestLatch = new CountDownLatch(1);
                DrbdVolumeInfo.this.getBrowser().getDrbdGraph().startTestAnimation(DrbdVolumeInfo.this.getApplyButton(), startTestLatch);
                DrbdVolumeInfo.this.getBrowser().drbdtestLockAcquire();
                DrbdVolumeInfo.this.getBrowser().setDRBDtestData(null);
                LinkedHashMap<Host, String> testOutput = new LinkedHashMap<Host, String>();
                try {
                    DrbdVolumeInfo.this.getDrbdInfo().createDrbdConfig(true);
                    for (Host h : DrbdVolumeInfo.this.getHosts()) {
                        DRBD.adjust(h, "all", null, true);
                        testOutput.put(h, DRBD.getDRBDtest());
                    }
                }
                catch (Exceptions.DrbdConfigException dce) {
                    DrbdVolumeInfo.this.getBrowser().drbdtestLockRelease();
                    return;
                }
                DRBDtestData dtd = new DRBDtestData(testOutput);
                DrbdVolumeInfo.this.getApplyButton().setToolTipText(dtd.getToolTip());
                DrbdVolumeInfo.this.getBrowser().setDRBDtestData(dtd);
                DrbdVolumeInfo.this.getBrowser().drbdtestLockRelease();
                startTestLatch.countDown();
            }
        };
        this.initApplyButton(buttonCallback, Tools.getString("Browser.ApplyDRBDResource"));
        JPanel mainPanel = new JPanel();
        mainPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBackground(ClusterBrowser.BUTTON_PANEL_BACKGROUND);
        buttonPanel.setMinimumSize(new Dimension(0, 50));
        buttonPanel.setPreferredSize(new Dimension(0, 50));
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        JPanel optionsPanel = new JPanel();
        optionsPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        optionsPanel.setAlignmentX(0.0f);
        mainPanel.add(buttonPanel);
        buttonPanel.add((Component)this.getActionsButton(), "East");
        this.getResource().setValue(DRBD_VOL_PARAM_NUMBER, this.getResource().getName());
        this.getResource().setValue(DRBD_VOL_PARAM_DEV, this.getDevice());
        String[] params = this.getParametersFromXML();
        this.addParams(optionsPanel, params, Tools.getDefaultSize("ClusterBrowser.DrbdResLabelWidth"), Tools.getDefaultSize("ClusterBrowser.DrbdResFieldWidth"), null);
        this.getApplyButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Tools.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                DrbdVolumeInfo.this.getApplyButton().setEnabled(false);
                                DrbdVolumeInfo.this.getRevertButton().setEnabled(false);
                            }
                        });
                        DrbdVolumeInfo.this.getBrowser().drbdStatusLock();
                        try {
                            DrbdVolumeInfo.this.getDrbdInfo().createDrbdConfig(false);
                            for (Host h : DrbdVolumeInfo.this.getHosts()) {
                                DRBD.adjust(h, "all", null, false);
                            }
                        }
                        catch (Exceptions.DrbdConfigException dce) {
                            DrbdVolumeInfo.this.getBrowser().drbdStatusUnlock();
                            Tools.appError("config failed");
                            return;
                        }
                        DrbdVolumeInfo.this.apply(false);
                        DrbdVolumeInfo.this.getBrowser().drbdStatusUnlock();
                    }
                });
                thread.start();
            }
        });
        this.getRevertButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        DrbdVolumeInfo.this.getBrowser().drbdStatusLock();
                        DrbdVolumeInfo.this.revert();
                        DrbdVolumeInfo.this.getBrowser().drbdStatusUnlock();
                    }
                });
                thread.start();
            }
        });
        this.addApplyButton(buttonPanel);
        this.addRevertButton(buttonPanel);
        mainPanel.add(optionsPanel);
        JPanel newPanel = new JPanel();
        newPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        newPanel.add(buttonPanel);
        newPanel.add(this.getMoreOptionsPanel(Tools.getDefaultInt("ClusterBrowser.DrbdResLabelWidth") + Tools.getDefaultInt("ClusterBrowser.DrbdResFieldWidth") + 4));
        newPanel.add(new JScrollPane(mainPanel));
        this.infoPanel = newPanel;
        this.infoPanelDone();
        return this.infoPanel;
    }

    public BlockDevInfo getFirstBlockDevInfo() {
        if (!this.blockDevInfos.isEmpty()) {
            return this.blockDevInfos.get(0);
        }
        return null;
    }

    public BlockDevInfo getSecondBlockDevInfo() {
        if (this.blockDevInfos.size() > 1) {
            return this.blockDevInfos.get(1);
        }
        return null;
    }

    public List<BlockDevInfo> getBlockDevInfos() {
        return this.blockDevInfos;
    }

    public boolean isFirstBlockDevInfo(BlockDevInfo bdi) {
        return this.getFirstBlockDevInfo() == bdi;
    }

    @Override
    public List<UpdatableItem> createPopup() {
        boolean testOnly = false;
        ArrayList<UpdatableItem> items = new ArrayList<UpdatableItem>();
        final DrbdVolumeInfo thisClass = this;
        MyMenuItem connectMenu = new MyMenuItem(Tools.getString("ClusterBrowser.Drbd.ResourceConnect") + " " + this.getDrbdResourceInfo().getName(), null, Tools.getString("ClusterBrowser.Drbd.ResourceConnect.ToolTip"), Tools.getString("ClusterBrowser.Drbd.ResourceDisconnect") + " " + this.getDrbdResourceInfo().getName(), null, Tools.getString("ClusterBrowser.Drbd.ResourceDisconnect.ToolTip"), new AccessMode(ConfigData.AccessType.OP, true), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean predicate() {
                return !DrbdVolumeInfo.this.isConnectedOrWF(false);
            }

            @Override
            public String enablePredicate() {
                if (!Tools.getConfigData().isAdvancedMode() && DrbdVolumeInfo.this.getDrbdResourceInfo().isUsedByCRM()) {
                    return DrbdVolumeInfo.IS_USED_BY_CRM_STRING;
                }
                if (DrbdVolumeInfo.this.isSyncing()) {
                    return DrbdVolumeInfo.IS_SYNCING_STRING;
                }
                return null;
            }

            @Override
            public void action() {
                BlockDevInfo sourceBDI = DrbdVolumeInfo.this.getBrowser().getDrbdGraph().getSource(thisClass);
                BlockDevInfo destBDI = DrbdVolumeInfo.this.getBrowser().getDrbdGraph().getDest(thisClass);
                if (this.getText().equals(Tools.getString("ClusterBrowser.Drbd.ResourceConnect") + " " + DrbdVolumeInfo.this.getDrbdResourceInfo().getName())) {
                    if (!destBDI.isConnectedOrWF(false)) {
                        destBDI.connect(false);
                    }
                    if (!sourceBDI.isConnectedOrWF(false)) {
                        sourceBDI.connect(false);
                    }
                } else {
                    destBDI.disconnect(false);
                    sourceBDI.disconnect(false);
                }
            }
        };
        ClusterBrowser clusterBrowser = this.getBrowser();
        clusterBrowser.getClass();
        ClusterBrowser.DRBDMenuItemCallback connectItemCallback = new ClusterBrowser.DRBDMenuItemCallback(clusterBrowser, connectMenu, null){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host host) {
                BlockDevInfo bdi;
                BlockDevInfo sourceBDI = DrbdVolumeInfo.this.getBrowser().getDrbdGraph().getSource(thisClass);
                BlockDevInfo destBDI = DrbdVolumeInfo.this.getBrowser().getDrbdGraph().getDest(thisClass);
                if (sourceBDI.getHost() == host) {
                    bdi = sourceBDI;
                } else if (destBDI.getHost() == host) {
                    bdi = destBDI;
                } else {
                    return;
                }
                if (sourceBDI.isConnected(false) && destBDI.isConnected(false)) {
                    bdi.disconnect(true);
                } else {
                    bdi.connect(true);
                }
            }
        };
        this.addMouseOverListener(connectMenu, connectItemCallback);
        items.add(connectMenu);
        MyMenuItem resumeSync = new MyMenuItem(Tools.getString("ClusterBrowser.Drbd.ResourceResumeSync"), null, Tools.getString("ClusterBrowser.Drbd.ResourceResumeSync.ToolTip"), Tools.getString("ClusterBrowser.Drbd.ResourcePauseSync"), null, Tools.getString("ClusterBrowser.Drbd.ResourcePauseSync.ToolTip"), new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean predicate() {
                return DrbdVolumeInfo.this.isPausedSync();
            }

            @Override
            public String enablePredicate() {
                if (!DrbdVolumeInfo.this.isSyncing()) {
                    return "it is not syncing";
                }
                return null;
            }

            @Override
            public void action() {
                BlockDevInfo sourceBDI = DrbdVolumeInfo.this.getBrowser().getDrbdGraph().getSource(thisClass);
                BlockDevInfo destBDI = DrbdVolumeInfo.this.getBrowser().getDrbdGraph().getDest(thisClass);
                if (this.getText().equals(Tools.getString("ClusterBrowser.Drbd.ResourceResumeSync"))) {
                    if (destBDI.getBlockDevice().isPausedSync()) {
                        destBDI.resumeSync(false);
                    }
                    if (sourceBDI.getBlockDevice().isPausedSync()) {
                        sourceBDI.resumeSync(false);
                    }
                } else {
                    sourceBDI.pauseSync(false);
                    destBDI.pauseSync(false);
                }
            }
        };
        items.add(resumeSync);
        MyMenuItem splitBrainMenu = new MyMenuItem(Tools.getString("ClusterBrowser.Drbd.ResolveSplitBrain"), null, Tools.getString("ClusterBrowser.Drbd.ResolveSplitBrain.ToolTip"), new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (DrbdVolumeInfo.this.isSplitBrain()) {
                    return null;
                }
                return "";
            }

            @Override
            public void action() {
                DrbdVolumeInfo.this.resolveSplitBrain();
            }
        };
        items.add(splitBrainMenu);
        MyMenuItem verifyMenu = new MyMenuItem(Tools.getString("ClusterBrowser.Drbd.Verify"), null, Tools.getString("ClusterBrowser.Drbd.Verify.ToolTip"), new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (!DrbdVolumeInfo.this.isConnected(false)) {
                    return "not connected";
                }
                if (DrbdVolumeInfo.this.isSyncing()) {
                    return DrbdVolumeInfo.IS_SYNCING_STRING;
                }
                if (DrbdVolumeInfo.this.isVerifying()) {
                    return DrbdVolumeInfo.IS_VERIFYING_STRING;
                }
                return null;
            }

            @Override
            public void action() {
                DrbdVolumeInfo.this.verify(false);
            }
        };
        items.add(verifyMenu);
        MyMenuItem removeResMenu = new MyMenuItem(Tools.getString("ClusterBrowser.Drbd.RemoveEdge"), ClusterBrowser.REMOVE_ICON, Tools.getString("ClusterBrowser.Drbd.RemoveEdge.ToolTip"), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public void action() {
                DrbdVolumeInfo.this.removeMyself(false);
            }

            @Override
            public String enablePredicate() {
                DrbdXML dxml = DrbdVolumeInfo.this.getBrowser().getDrbdXML();
                if (!Tools.getConfigData().isAdvancedMode() && DrbdVolumeInfo.this.getDrbdResourceInfo().isUsedByCRM()) {
                    return DrbdVolumeInfo.IS_USED_BY_CRM_STRING;
                }
                if (dxml.isDrbdDisabled()) {
                    return "disabled because of config";
                }
                return null;
            }
        };
        items.add(removeResMenu);
        MyMenuItem viewLogMenu = new MyMenuItem(Tools.getString("ClusterBrowser.Drbd.ViewLogs"), LOGFILE_ICON, null, new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void action() {
                DrbdVolumeInfo.this.hidePopup();
                String device = DrbdVolumeInfo.this.getDevice();
                DrbdLogs l = new DrbdLogs(DrbdVolumeInfo.this.getDrbdResourceInfo().getCluster(), device);
                l.showDialog();
            }
        };
        items.add(viewLogMenu);
        return items;
    }

    @Override
    public String getToolTipForGraph(boolean testOnly) {
        StringBuilder s = new StringBuilder(50);
        s.append("<html><b>Resource: ");
        s.append(this.getDrbdResourceInfo().getName());
        s.append(" volume: ");
        s.append(this.getName());
        s.append("</b><br>");
        if (this.isSyncing()) {
            String spString = this.getSyncedProgress();
            String bsString = this.getFirstBlockDevInfo().getBlockDevice().getBlockSize();
            String rateString = this.getDrbdResourceInfo().getResource().getValue("rate");
            if (spString != null && bsString != null && rateString != null) {
                double sp = Double.parseDouble(spString);
                double bs = Double.parseDouble(bsString);
                Object[] rateObj = Tools.extractUnit(rateString);
                double rate = Double.parseDouble((String)rateObj[0]);
                if (!"k".equalsIgnoreCase((String)rateObj[1])) {
                    rate = "m".equalsIgnoreCase((String)rateObj[1]) ? (rate *= 1024.0) : ("g".equalsIgnoreCase((String)rateObj[1]) ? (rate *= 1048576.0) : ("".equalsIgnoreCase((String)rateObj[1]) ? (rate /= 1024.0) : 0.0));
                }
                if (rate > 0.0) {
                    s.append("\nremaining at least: ");
                    double seconds = (100.0 - sp) / 100.0 * bs / rate;
                    if (seconds < 300.0) {
                        s.append((int)seconds);
                        s.append(" Seconds");
                    } else {
                        s.append((int)(seconds / 60.0));
                        s.append(" Minutes");
                    }
                }
            }
        }
        s.append("</html>");
        return s.toString();
    }

    public void removeMyselfNoConfirm(boolean testOnly) {
        ClusterBrowser cb = this.getBrowser();
        cb.drbdStatusLock();
        cb.getDrbdXML().removeVolume(this.getDrbdResourceInfo().getName(), this.getDevice(), this.getName());
        cb.getDrbdGraph().removeDrbdVolume(this);
        Set<Host> hosts = this.getHosts();
        boolean lastVolume = this.getDrbdResourceInfo().removeDrbdVolume(this);
        if (this.getDrbdVolume().isCommited()) {
            for (Host host : hosts) {
                DRBD.setSecondary(host, this.getDrbdResourceInfo().getName(), this.getName(), testOnly);
                if (!host.hasVolumes()) {
                    DRBD.disconnect(host, this.getDrbdResourceInfo().getName(), null, testOnly);
                }
                for (BlockDevInfo bdi : this.getBlockDevInfos()) {
                    if (bdi.getHost() != host) continue;
                    if (!bdi.getBlockDevice().isAttached()) break;
                    DRBD.detach(host, this.getDrbdResourceInfo().getName(), this.getName(), testOnly);
                    break;
                }
                if (!host.hasVolumes()) continue;
                DRBD.delMinor(host, this.getDevice(), testOnly);
                if (!lastVolume) continue;
                DRBD.delConnection(host, this.getDrbdResourceInfo().getName(), testOnly);
            }
        }
        super.removeMyself(testOnly);
        cb.reload(cb.getDrbdNode(), true);
        cb.getDrbdDevHash().remove(this.getDevice());
        cb.putDrbdDevHash();
        for (BlockDevInfo bdi : this.getBlockDevInfos()) {
            bdi.removeFromDrbd();
            bdi.removeMyself(testOnly);
        }
        if (lastVolume) {
            DrbdResourceInfo dri = this.getDrbdResourceInfo();
            for (BlockDevInfo bdi : this.getBlockDevInfos()) {
                if (!dri.isProxy(bdi.getHost())) continue;
                DRBD.proxyDown(bdi.getHost(), dri.getName(), null, testOnly);
            }
            dri.removeMyself(testOnly);
        }
        cb.updateCommonBlockDevices();
        try {
            this.getDrbdInfo().createDrbdConfig(testOnly);
        }
        catch (Exceptions.DrbdConfigException dce) {
            cb.drbdStatusUnlock();
            Tools.appError("config failed", dce);
            return;
        }
        this.getDrbdInfo().setSelectedNode(null);
        this.getDrbdInfo().selectMyself();
        cb.getDrbdGraph().updatePopupMenus();
        cb.resetFilesystems();
        DrbdXML dxml = new DrbdXML(hosts.toArray(new Host[hosts.size()]), cb.getDrbdParameters());
        for (Host host : hosts) {
            String conf = dxml.getConfig(host);
            if (conf == null) continue;
            dxml.update(conf);
        }
        cb.setDrbdXML(dxml);
        cb.drbdStatusUnlock();
        cb.updateDrbdResources();
        if (!testOnly) {
            this.removeNode();
        }
        cb.getDrbdGraph().scale();
    }

    @Override
    public void removeMyself(boolean testOnly) {
        if (!this.getDrbdVolume().isCommited()) {
            this.removeMyselfNoConfirm(testOnly);
            return;
        }
        String desc = Tools.getString("ClusterBrowser.confirmRemoveDrbdResource.Description");
        desc = desc.replaceAll("@RESOURCE@", Matcher.quoteReplacement(this.getDrbdResourceInfo() + "/" + this.getName()));
        if (Tools.confirmDialog(Tools.getString("ClusterBrowser.confirmRemoveDrbdResource.Title"), desc, Tools.getString("ClusterBrowser.confirmRemoveDrbdResource.Yes"), Tools.getString("ClusterBrowser.confirmRemoveDrbdResource.No"))) {
            this.removeMyselfNoConfirm(testOnly);
        }
    }

    public DrbdResourceInfo getDrbdResourceInfo() {
        return this.drbdResourceInfo;
    }

    @Override
    public String getDevice() {
        return this.device;
    }

    public String getDeviceByRes() {
        if (this.getDrbdInfo().atLeastVersion("8.4")) {
            return BY_RES_DEV_DIR + this.getDrbdResourceInfo().getName() + "/" + this.getName();
        }
        return BY_RES_DEV_DIR + this.getDrbdResourceInfo().getName();
    }

    @Override
    public String getCreatedFs() {
        return this.createdFs;
    }

    public void setCreatedFs(String createdFs) {
        this.createdFs = createdFs;
    }

    public String getSyncedProgress() {
        return this.getFirstBlockDevInfo().getBlockDevice().getSyncedProgress();
    }

    public boolean isSyncing() {
        for (BlockDevInfo bdi : this.getBlockDevInfos()) {
            if (!bdi.getBlockDevice().isSyncing()) continue;
            return true;
        }
        return false;
    }

    public boolean isSplitBrain() {
        for (BlockDevInfo bdi : this.getBlockDevInfos()) {
            if (!bdi.getBlockDevice().isSplitBrain()) continue;
            return true;
        }
        return false;
    }

    public boolean isConnected(boolean testOnly) {
        for (BlockDevInfo bdi : this.getBlockDevInfos()) {
            if (!bdi.isConnected(testOnly)) continue;
            return true;
        }
        return false;
    }

    public boolean isConnectedOrWF(boolean testOnly) {
        for (BlockDevInfo bdi : this.getBlockDevInfos()) {
            if (bdi.isConnectedOrWF(testOnly)) continue;
            return false;
        }
        return true;
    }

    public boolean isVerifying() {
        for (BlockDevInfo bdi : this.getBlockDevInfos()) {
            if (!bdi.getBlockDevice().isVerifying()) continue;
            return true;
        }
        return false;
    }

    public BlockDevInfo getOtherBlockDevInfo(BlockDevInfo thisBDI) {
        if (thisBDI.equals(this.getFirstBlockDevInfo())) {
            return this.getSecondBlockDevInfo();
        }
        for (BlockDevInfo bdi : this.getBlockDevInfos()) {
            if (bdi == this.getFirstBlockDevInfo() || !thisBDI.equals(bdi)) continue;
            return this.getFirstBlockDevInfo();
        }
        return null;
    }

    @Override
    public int getUsed() {
        for (BlockDevInfo bdi : this.getBlockDevInfos()) {
            if (!bdi.getBlockDevice().isPrimary()) continue;
            return bdi.getBlockDevice().getUsed();
        }
        return -1;
    }

    boolean isPausedSync() {
        for (BlockDevInfo bdi : this.getBlockDevInfos()) {
            if (!bdi.getBlockDevice().isPausedSync()) continue;
            return true;
        }
        return false;
    }

    void verify(boolean testOnly) {
        this.getFirstBlockDevInfo().verify(testOnly);
    }

    void removeDrbdDisk(FilesystemInfo fi, Host dcHost, boolean testOnly) {
        DrbddiskInfo drbddiskInfo = fi.getDrbddiskInfo();
        if (drbddiskInfo != null) {
            drbddiskInfo.removeMyselfNoConfirm(dcHost, testOnly);
        }
    }

    void removeLinbitDrbd(FilesystemInfo fi, Host dcHost, boolean testOnly) {
        LinbitDrbdInfo linbitDrbdInfo = fi.getLinbitDrbdInfo();
        if (linbitDrbdInfo != null) {
            linbitDrbdInfo.removeMyselfNoConfirm(dcHost, testOnly);
        }
    }

    void addDrbdDisk(FilesystemInfo fi, Host dcHost, boolean testOnly) {
        Point2D p = null;
        CRMGraph crmg = this.getBrowser().getCRMGraph();
        DrbddiskInfo di = (DrbddiskInfo)this.getBrowser().getServicesInfo().addServicePanel(this.getBrowser().getCRMXML().getHbDrbddisk(), p, true, null, null, testOnly);
        di.setGroupInfo(fi.getGroupInfo());
        this.getBrowser().addToHeartbeatIdList(di);
        fi.setDrbddiskInfo(di);
        GroupInfo giFi = fi.getGroupInfo();
        if (giFi == null) {
            crmg.addColocation(null, fi, di);
            crmg.addOrder(null, di, fi);
        } else {
            crmg.addColocation(null, giFi, di);
            crmg.addOrder(null, di, giFi);
        }
        di.waitForInfoPanel();
        di.getWidget("1", null).setValueAndWait(this.getDrbdResourceInfo().getName());
        di.apply(dcHost, testOnly);
    }

    void addLinbitDrbd(FilesystemInfo fi, Host dcHost, boolean testOnly) {
        Point2D p = null;
        CRMGraph crmg = this.getBrowser().getCRMGraph();
        LinbitDrbdInfo ldi = (LinbitDrbdInfo)this.getBrowser().getServicesInfo().addServicePanel(this.getBrowser().getCRMXML().getHbLinbitDrbd(), p, true, null, null, testOnly);
        Tools.waitForSwing();
        ldi.setGroupInfo(fi.getGroupInfo());
        this.getBrowser().addToHeartbeatIdList(ldi);
        fi.setLinbitDrbdInfo(ldi);
        CloneInfo ci = ldi.getCloneInfo();
        GroupInfo giFi = fi.getGroupInfo();
        if (giFi == null) {
            crmg.addColocation(null, fi, ci);
            crmg.addOrder(null, ci, fi);
        } else {
            crmg.addColocation(null, giFi, ci);
            crmg.addOrder(null, ci, giFi);
        }
        ldi.waitForInfoPanel();
        ldi.getWidget("drbd_resource", null).setValueAndWait(this.getDrbdResourceInfo().getName());
        Tools.waitForSwing();
        ldi.apply(dcHost, testOnly);
    }

    void resolveSplitBrain() {
        AddDrbdSplitBrainDialog adrd = new AddDrbdSplitBrainDialog(this);
        adrd.showDialogs();
    }

    public void connect(Host host, boolean testOnly) {
        for (BlockDevInfo bdi : this.getBlockDevInfos()) {
            if (bdi.getHost() != host || bdi.isConnectedOrWF(false)) continue;
            bdi.connect(testOnly);
            break;
        }
    }

    public Set<Host> getHosts() {
        return this.hosts;
    }

    public static Set<Host> getHostsFromBlockDevices(List<BlockDevInfo> bdis) {
        TreeSet<Host> hosts = new TreeSet<Host>(new Comparator<Host>(){

            @Override
            public int compare(Host h1, Host h2) {
                return h1.getName().compareToIgnoreCase(h2.getName());
            }
        });
        for (BlockDevInfo bdi : bdis) {
            hosts.add(bdi.getHost());
        }
        return hosts;
    }

    public String getMetaDiskForHost(Host host) {
        return this.getBrowser().getDrbdXML().getMetaDisk(host.getName(), this.getDrbdResourceInfo().getName(), this.getName());
    }

    @Override
    public String toString() {
        String resName = this.getDrbdResourceInfo().getName();
        String name = this.getName();
        if (resName == null || name == null || "".equals(name)) {
            return Tools.getString("ClusterBrowser.DrbdResUnconfigured");
        }
        return "DRBD: " + resName + "/" + name;
    }

    @Override
    public JPanel getGraphicalView() {
        return this.getBrowser().getDrbdGraph().getGraphPanel();
    }

    @Override
    public String[] getParametersFromXML() {
        return PARAMS;
    }

    @Override
    public boolean checkResourceFieldsCorrect(String param, String[] params) {
        return this.checkResourceFieldsCorrect(param, params, false, false);
    }

    boolean checkResourceFieldsCorrect(String param, String[] params, boolean fromDrbdInfo, boolean fromDrbdResourceInfo) {
        boolean correct = true;
        DrbdXML dxml = this.getBrowser().getDrbdXML();
        if (dxml != null && dxml.isDrbdDisabled()) {
            correct = false;
        }
        for (BlockDevInfo bdi : this.getBlockDevInfos()) {
            if (bdi == null || bdi.getBlockDevice().isNew() || bdi.checkResourceFieldsCorrect(param, bdi.getParametersFromXML(), fromDrbdInfo, fromDrbdResourceInfo, true)) continue;
            correct = false;
        }
        return super.checkResourceFieldsCorrect(param, params) && correct;
    }

    @Override
    public boolean checkResourceFieldsChanged(String param, String[] params) {
        return this.checkResourceFieldsChanged(param, params, false, false);
    }

    boolean checkResourceFieldsChanged(String param, String[] params, boolean fromDrbdInfo, boolean fromDrbdResourceInfo) {
        DrbdInfo di = this.getDrbdInfo();
        if (di != null && !fromDrbdInfo && !fromDrbdResourceInfo) {
            di.setApplyButtons(null, di.getParametersFromXML());
        }
        boolean changed = false;
        for (BlockDevInfo bdi : this.getBlockDevInfos()) {
            if (bdi == null || !bdi.checkResourceFieldsChanged(param, bdi.getParametersFromXML(), fromDrbdInfo, fromDrbdResourceInfo, true)) continue;
            changed = true;
        }
        return super.checkResourceFieldsChanged(param, params) || changed;
    }

    public void apply(boolean testOnly) {
        if (!testOnly) {
            String drbdDevStr;
            String[] params = this.getParametersFromXML();
            Tools.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    DrbdVolumeInfo.this.getApplyButton().setEnabled(false);
                    DrbdVolumeInfo.this.getRevertButton().setEnabled(false);
                }
            });
            this.getInfoPanel();
            this.waitForInfoPanel();
            this.getBrowser().getDrbdDevHash().remove(this.getDevice());
            this.getBrowser().putDrbdDevHash();
            this.storeComboBoxValues(params);
            String volumeNr = this.getParamSaved(DRBD_VOL_PARAM_NUMBER);
            this.setName(volumeNr);
            this.device = drbdDevStr = this.getParamSaved(DRBD_VOL_PARAM_DEV);
            this.getBrowser().getDrbdDevHash().put(drbdDevStr, this);
            this.getBrowser().putDrbdDevHash();
            this.getBrowser().getDrbdGraph().repaint();
            this.getDrbdInfo().setAllApplyButtons();
        }
    }

    @Override
    protected String getSection(String param) {
        return SECTION_STRING;
    }

    @Override
    protected boolean isInteger(String param) {
        return DRBD_VOL_PARAM_NUMBER.equals(param);
    }

    @Override
    public ClusterBrowser getBrowser() {
        return (ClusterBrowser)super.getBrowser();
    }

    @Override
    protected String getParamLongDesc(String param) {
        return LONG_DESC.get(param);
    }

    @Override
    protected String getParamShortDesc(String param) {
        return SHORT_DESC.get(param);
    }

    @Override
    protected String getParamPreferred(String param) {
        return null;
    }

    @Override
    public String getParamDefault(String param) {
        return null;
    }

    @Override
    protected boolean checkParam(String param, String newValue) {
        return this.getBrowser().getDrbdXML().checkParam(param, newValue);
    }

    @Override
    protected Object[] getParamPossibleChoices(String param) {
        return POSSIBLE_CHOICES.get(param);
    }

    @Override
    protected String getParamType(String param) {
        return null;
    }

    @Override
    protected boolean isCheckBox(String param) {
        return false;
    }

    @Override
    protected boolean isTimeType(String param) {
        return false;
    }

    @Override
    protected boolean isLabel(String param) {
        return false;
    }

    @Override
    protected boolean isEnabledOnlyInAdvancedMode(String param) {
        return false;
    }

    @Override
    protected ConfigData.AccessType getAccessType(String param) {
        return ConfigData.AccessType.ADMIN;
    }

    @Override
    protected String isEnabled(String param) {
        if (DRBD_VOL_PARAM_NUMBER.equals(param) && !this.getDrbdInfo().atLeastVersion("8.4")) {
            return "available in DRBD 8.4";
        }
        if (this.getDrbdVolume().isCommited()) {
            return "";
        }
        return null;
    }

    @Override
    protected boolean isAdvanced(String param) {
        return false;
    }

    @Override
    protected boolean isRequired(String param) {
        return true;
    }

    String drbdVolumeConfig(Host host, boolean volumesAvailable) throws Exceptions.DrbdConfigException {
        StringBuilder config = new StringBuilder(50);
        for (BlockDevInfo bdi : this.blockDevInfos) {
            if (bdi.getHost() != host) continue;
            if (volumesAvailable) {
                config.append("volume " + this.getName() + " {\n");
            }
            config.append(bdi.drbdBDConfig(this.getName(), this.getDevice(), volumesAvailable));
            config.append('\n');
            if (!volumesAvailable) continue;
            config.append("\t\t}");
        }
        this.getDrbdVolume().setCommited(true);
        return config.toString().trim();
    }

    void setAllApplyButtons() {
        for (BlockDevInfo bdi : this.getBlockDevInfos()) {
            if (bdi == null) continue;
            bdi.storeComboBoxValues(bdi.getParametersFromXML());
            bdi.setApplyButtons(null, bdi.getParametersFromXML());
        }
        this.setApplyButtons(null, this.getParametersFromXML());
    }

    public String getNameForGraph() {
        StringBuilder n = new StringBuilder(20);
        DrbdResourceInfo dri = this.getDrbdResourceInfo();
        n.append(dri.getName());
        if (dri.getDrbdVolumes().size() > 1) {
            n.append('/');
            n.append(this.getName());
        }
        return n.toString();
    }

    DrbdVolume getDrbdVolume() {
        return (DrbdVolume)this.getResource();
    }

    @Override
    public String getInternalValue() {
        return this.getDeviceByRes();
    }

    public void setParameters() {
        this.getDrbdVolume().setCommited(true);
    }

    @Override
    public void setUsedByCRM(ServiceInfo isUsedByCRM) {
        this.getDrbdResourceInfo().setUsedByCRM(isUsedByCRM);
    }

    @Override
    public boolean isUsedByCRM() {
        return this.getDrbdResourceInfo().isUsedByCRM();
    }

    public DrbdInfo getDrbdInfo() {
        return this.getDrbdResourceInfo().getDrbdInfo();
    }
}

