/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import lcmc.Exceptions;
import lcmc.data.AccessMode;
import lcmc.data.Cluster;
import lcmc.data.ConfigData;
import lcmc.data.DRBDtestData;
import lcmc.data.DrbdXML;
import lcmc.data.Host;
import lcmc.data.Subtext;
import lcmc.data.resources.BlockDevice;
import lcmc.gui.Browser;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.DrbdGraph;
import lcmc.gui.HostBrowser;
import lcmc.gui.dialog.drbd.DrbdLog;
import lcmc.gui.dialog.lvm.LVCreate;
import lcmc.gui.dialog.lvm.LVResize;
import lcmc.gui.dialog.lvm.LVSnapshot;
import lcmc.gui.dialog.lvm.PVCreate;
import lcmc.gui.dialog.lvm.PVRemove;
import lcmc.gui.dialog.lvm.VGCreate;
import lcmc.gui.dialog.lvm.VGRemove;
import lcmc.gui.resources.DrbdInfo;
import lcmc.gui.resources.DrbdResourceInfo;
import lcmc.gui.resources.DrbdVolumeInfo;
import lcmc.gui.resources.EditableInfo;
import lcmc.gui.resources.Info;
import lcmc.gui.resources.StringInfo;
import lcmc.gui.widget.Widget;
import lcmc.utilities.ButtonCallback;
import lcmc.utilities.DRBD;
import lcmc.utilities.LVM;
import lcmc.utilities.MyMenu;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.Tools;
import lcmc.utilities.UpdatableItem;

public final class BlockDevInfo
extends EditableInfo {
    private DrbdVolumeInfo drbdVolumeInfo;
    private final Map<String, Boolean> paramCorrectValueMap = new HashMap<String, Boolean>();
    private JComponent infoPanel = null;
    private static final String DRBD_MD_TYPE_FLEXIBLE = "Flexible";
    private static final String DRBD_MD_PARAM = "DrbdMetaDisk";
    private static final String DRBD_MD_INDEX_PARAM = "DrbdMetaDiskIndex";
    public static final ImageIcon HARDDISK_ICON_LARGE = Tools.createImageIcon(Tools.getDefault("BlockDevInfo.HarddiskIconLarge"));
    public static final ImageIcon HARDDISK_DRBD_ICON_LARGE = Tools.createImageIcon(Tools.getDefault("BlockDevInfo.HarddiskDRBDIconLarge"));
    public static final ImageIcon NO_HARDDISK_ICON_LARGE = Tools.createImageIcon(Tools.getDefault("BlockDevInfo.NoHarddiskIconLarge"));
    public static final ImageIcon HARDDISK_ICON = Tools.createImageIcon(Tools.getDefault("BlockDevInfo.HarddiskIcon"));
    private static final Subtext METADISK_SUBTEXT = new Subtext("meta-disk", Color.BLUE, Color.BLACK);
    private static final Subtext SWAP_SUBTEXT = new Subtext("swap", Color.BLUE, Color.BLACK);
    private static final Subtext MOUNTED_SUBTEXT = new Subtext("mounted", Color.BLUE, Color.BLACK);
    private static final Subtext PHYSICAL_VOLUME_SUBTEXT = new Subtext("PV", Color.BLUE, Color.GREEN);
    private static final int MAX_RIGHT_CORNER_STRING_LENGTH = 28;
    static final String NO_DRBD_RESOURCE_STRING = "it is not a drbd resource";
    private static final String ALLOW_TWO_PRIMARIES = "allow-two-primaries";
    private static final String PV_CREATE_MENU_ITEM = "Create PV";
    private static final String PV_CREATE_MENU_DESCRIPTION = "Initialize a disk or partition for use by LVM.";
    private static final String PV_REMOVE_MENU_ITEM = "Remove PV";
    private static final String PV_REMOVE_MENU_DESCRIPTION = "Remove a physical volume.";
    private static final String VG_CREATE_MENU_ITEM = "Create VG";
    private static final String VG_CREATE_MENU_DESCRIPTION = "Create a volume group.";
    private static final String VG_REMOVE_MENU_ITEM = "Remove VG";
    private static final String VG_REMOVE_MENU_DESCRIPTION = "Remove a volume group.";
    private static final String LV_CREATE_MENU_ITEM = "Create LV in VG ";
    private static final String LV_CREATE_MENU_DESCRIPTION = "Create a logical volume.";
    private static final String LV_REMOVE_MENU_ITEM = "Remove LV";
    private static final String LV_REMOVE_MENU_DESCRIPTION = "Remove the logical volume";
    private static final String LV_RESIZE_MENU_ITEM = "Resize LV";
    private static final String LV_RESIZE_MENU_DESCRIPTION = "Resize the logical volume";
    private static final String LV_SNAPSHOT_MENU_ITEM = "Create LV Snapshot ";
    private static final String LV_SNAPSHOT_MENU_DESCRIPTION = "Create a snapshot of the logical volume.";
    public static final String PROXY_UP = "Proxy Up";
    private static final String PROXY_DOWN = "Proxy Down";

    public BlockDevInfo(String name, BlockDevice blockDevice, Browser browser) {
        super(name, browser);
        this.setResource(blockDevice);
    }

    public BlockDevInfo getOtherBlockDevInfo() {
        DrbdVolumeInfo dvi = this.drbdVolumeInfo;
        if (dvi == null) {
            return null;
        }
        return dvi.getOtherBlockDevInfo(this);
    }

    @Override
    public HostBrowser getBrowser() {
        return (HostBrowser)super.getBrowser();
    }

    void setInfoPanel(JComponent infoPanel) {
        this.infoPanel = infoPanel;
    }

    @Override
    public void removeMyself(boolean testOnly) {
        this.getBlockDevice().setValue(DRBD_MD_PARAM, null);
        this.getBlockDevice().setValue(DRBD_MD_INDEX_PARAM, null);
        super.removeMyself(testOnly);
        if (!testOnly) {
            this.removeNode();
        }
        this.infoPanel = null;
    }

    public Host getHost() {
        return this.getBrowser().getHost();
    }

    @Override
    public ImageIcon getMenuIcon(boolean testOnly) {
        return HARDDISK_ICON;
    }

    @Override
    String getInfo() {
        StringBuilder ret = new StringBuilder(120);
        ret.append("Host            : ");
        ret.append(this.getHost().getName());
        ret.append("\nDevice          : ");
        ret.append(this.getBlockDevice().getName());
        ret.append("\nMeta disk       : ");
        ret.append(this.getBlockDevice().isDrbdMetaDisk());
        ret.append("\nSize            : ");
        ret.append(this.getBlockDevice().getBlockSize());
        ret.append(" blocks");
        if (this.getBlockDevice().getMountedOn() == null) {
            ret.append("\nnot mounted");
        } else {
            ret.append("\nMounted on      : ");
            ret.append(this.getBlockDevice().getMountedOn());
            ret.append("\nType            : ");
            ret.append(this.getBlockDevice().getFsType());
            if (this.getUsed() >= 0) {
                ret.append("\nUsed:           : ");
                ret.append(this.getUsed());
                ret.append('%');
            }
        }
        if (this.getBlockDevice().isDrbd()) {
            ret.append("\nConnection state: ");
            ret.append(this.getBlockDevice().getConnectionState());
            ret.append("\nNode state      : ");
            ret.append(this.getBlockDevice().getNodeState());
            ret.append("\nDisk state      : ");
            ret.append(this.getBlockDevice().getDiskState());
            ret.append('\n');
        }
        return ret.toString();
    }

    private void appendBlockDeviceHierarchy(BlockDevice bd, StringBuilder tt, int shift) {
        String tab = "";
        for (int i = 0; i != shift; ++i) {
            tab = tab + "    ";
        }
        String vg = null;
        String selectedPV = null;
        if (bd.isVolumeGroupOnPhysicalVolume()) {
            vg = bd.getVolumeGroupOnPhysicalVolume();
            selectedPV = bd.getName();
        } else if (this.isLVM()) {
            vg = bd.getVolumeGroup();
        }
        if (vg != null) {
            for (BlockDevice pv : this.getHost().getPhysicalVolumes(vg)) {
                if (pv.equals(selectedPV)) {
                    tt.append("<b>");
                    tt.append(tab + pv);
                    tt.append("</b>");
                } else {
                    tt.append(tab + pv);
                }
                tt.append('\n');
            }
        }
        String selectedLV = null;
        if (vg != null) {
            if (bd.isVolumeGroupOnPhysicalVolume()) {
                tt.append("<b>");
                tt.append("    " + tab + vg);
                tt.append("</b>\n");
            } else if (this.isLVM()) {
                tt.append("    " + tab);
                tt.append(vg);
                tt.append('\n');
                selectedLV = bd.getName();
            }
            Set<String> lvs = this.getHost().getLogicalVolumesFromVolumeGroup(vg);
            if (lvs != null) {
                for (String lv : lvs) {
                    tt.append("        " + tab);
                    String lvName = "/dev/" + vg + "/" + lv;
                    if (lvName.equals(selectedLV)) {
                        if (bd.isDrbd()) {
                            tt.append(lv);
                            tt.append("\n");
                            BlockDevice drbdBD = bd.getDrbdBlockDevice();
                            if (drbdBD == null) continue;
                            this.appendBlockDeviceHierarchy(drbdBD, tt, shift + 3);
                            continue;
                        }
                        tt.append("<b>");
                        tt.append(lv);
                        tt.append("</b>\n");
                        continue;
                    }
                    tt.append(lv);
                    tt.append('\n');
                }
            }
        } else {
            BlockDevice drbdBD = bd.getDrbdBlockDevice();
            if (drbdBD != null) {
                tt.append(tab + bd.getName());
                tt.append('\n');
                this.appendBlockDeviceHierarchy(drbdBD, tt, shift + 1);
            } else {
                tt.append("<b>");
                tt.append(tab + bd.getName());
                tt.append("</b>\n");
            }
        }
    }

    @Override
    public String getToolTipForGraph(boolean testOnly) {
        StringBuilder tt = new StringBuilder(60);
        BlockDevice bd = this.getBlockDevice();
        tt.append("<pre>");
        this.appendBlockDeviceHierarchy(bd, tt, 0);
        tt.append("</pre>");
        if (bd.isDrbdMetaDisk()) {
            tt.append(" (Meta Disk)\n");
            for (BlockDevice mb : this.getBlockDevice().getMetaDiskOfBlockDevices()) {
                tt.append("&nbsp;&nbsp;of ");
                tt.append(mb.getName());
                tt.append('\n');
            }
        }
        if (bd.isDrbd()) {
            if (this.getHost().isDrbdStatus()) {
                String cs = bd.getConnectionState();
                String st = bd.getNodeState();
                String ds = bd.getDiskState();
                if (cs == null) {
                    cs = "not available";
                }
                if (st == null) {
                    st = "not available";
                }
                if (ds == null) {
                    ds = "not available";
                }
                tt.append("\n<table><tr><td><b>cs:</b></td><td>");
                tt.append(cs);
                tt.append("</td></tr><tr><td><b>ro:</b></td><td>");
                tt.append(st);
                tt.append("</td></tr><tr><td><b>ds:</b></td><td>");
                tt.append(ds);
                tt.append("</td></tr></table>");
            } else {
                tt.append('\n');
                tt.append(Tools.getString("HostBrowser.Hb.NoInfoAvailable"));
            }
        }
        return tt.toString();
    }

    String drbdBDConfig(String resource, String drbdDevice, boolean volumesAvailable) throws Exceptions.DrbdConfigException {
        if (drbdDevice == null) {
            throw new Exceptions.DrbdConfigException("Drbd device not defined for host " + this.getHost().getName() + " (" + resource + ")");
        }
        if (this.getBlockDevice().getName() == null) {
            throw new Exceptions.DrbdConfigException("Block device not defined for host " + this.getHost().getName() + " (" + resource + ")");
        }
        StringBuilder config = new StringBuilder(120);
        String tabs = volumesAvailable ? "\t\t\t" : "\t\t";
        config.append(tabs + "device\t\t");
        config.append(drbdDevice);
        config.append(";\n" + tabs + "disk\t\t");
        config.append(this.getBlockDevice().getName());
        config.append(";\n" + tabs);
        config.append(this.getBlockDevice().getMetaDiskString(this.getComboBoxValue(DRBD_MD_PARAM), this.getComboBoxValue(DRBD_MD_INDEX_PARAM)));
        config.append(';');
        return config.toString();
    }

    void setDrbd(boolean drbd) {
        this.getBlockDevice().setDrbd(drbd);
    }

    @Override
    protected String getSection(String param) {
        return this.getBlockDevice().getSection(param);
    }

    @Override
    protected Object[] getPossibleChoices(String param) {
        return this.getBlockDevice().getPossibleChoices(param);
    }

    protected Object getDefaultValue(String param) {
        return "<select>";
    }

    @Override
    protected Widget createWidget(String param, String prefix, int width) {
        Widget paramWi;
        if (DRBD_MD_INDEX_PARAM.equals(param)) {
            Widget gwi;
            paramWi = gwi = super.createWidget(param, prefix, width);
        } else {
            Widget gwi;
            paramWi = gwi = super.createWidget(param, prefix, width);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    gwi.setEditable(false);
                }
            });
        }
        return paramWi;
    }

    @Override
    protected boolean checkParam(String param, String value) {
        boolean ret = true;
        if (value == null) {
            value = "";
        }
        if ("".equals(value) && this.isRequired(param)) {
            ret = false;
        } else if (DRBD_MD_PARAM.equals(param)) {
            if (this.infoPanel != null && !this.getHost().isServerStatusLatch()) {
                final boolean internal = "internal".equals(value);
                final Widget ind = this.getWidget(DRBD_MD_INDEX_PARAM, null);
                final Widget indW = this.getWidget(DRBD_MD_INDEX_PARAM, "widget");
                if (internal) {
                    ind.setValue(DRBD_MD_TYPE_FLEXIBLE);
                    if (indW != null) {
                        indW.setValue(DRBD_MD_TYPE_FLEXIBLE);
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ind.setEnabled(!internal);
                    }
                });
                if (indW != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            indW.setEnabled(!internal);
                        }
                    });
                }
            }
        } else if (DRBD_MD_INDEX_PARAM.equals(param)) {
            Pattern p;
            Matcher m;
            if (this.getBrowser().getUsedPorts().contains(value) && !value.equals(this.getBlockDevice().getValue(param))) {
                ret = false;
            }
            if ((m = (p = Pattern.compile(".*\\D.*")).matcher(value)).matches() && !DRBD_MD_TYPE_FLEXIBLE.equals(value)) {
                ret = false;
            }
        }
        this.paramCorrectValueMap.remove(param);
        this.paramCorrectValueMap.put(param, ret);
        return ret;
    }

    @Override
    protected boolean isRequired(String param) {
        return true;
    }

    @Override
    protected boolean isAdvanced(String param) {
        return false;
    }

    @Override
    protected ConfigData.AccessType getAccessType(String param) {
        return ConfigData.AccessType.ADMIN;
    }

    @Override
    protected String isEnabled(String param) {
        return null;
    }

    @Override
    protected boolean isEnabledOnlyInAdvancedMode(String param) {
        return false;
    }

    @Override
    protected boolean isInteger(String param) {
        return false;
    }

    @Override
    protected boolean isLabel(String param) {
        return false;
    }

    @Override
    protected boolean isTimeType(String param) {
        return false;
    }

    @Override
    protected boolean isCheckBox(String param) {
        return false;
    }

    @Override
    protected String getParamType(String param) {
        return null;
    }

    @Override
    protected String getParamRegexp(String param) {
        return null;
    }

    @Override
    protected Object[] getParamPossibleChoices(String param) {
        if (DRBD_MD_PARAM.equals(param)) {
            StringInfo internalMetaDisk = new StringInfo(Tools.getString("HostBrowser.MetaDisk.Internal"), "internal", this.getBrowser());
            String defaultMetaDiskString = internalMetaDisk.toString();
            this.getBrowser().lockBlockDevInfosRead();
            Object[] blockDevices = this.getAvailableBlockDevicesForMetaDisk(internalMetaDisk, this.getName(), this.getBrowser().getBlockDevInfos());
            this.getBrowser().unlockBlockDevInfosRead();
            this.getBlockDevice().setDefaultValue(DRBD_MD_PARAM, defaultMetaDiskString);
            return blockDevices;
        }
        if (DRBD_MD_INDEX_PARAM.equals(param)) {
            String defaultMetaDiskIndex = this.getBlockDevice().getValue(DRBD_MD_INDEX_PARAM);
            if ("internal".equals(defaultMetaDiskIndex)) {
                defaultMetaDiskIndex = Tools.getString("HostBrowser.MetaDisk.Internal");
            }
            Object[] indeces = new String[11];
            int index = 0;
            if (defaultMetaDiskIndex == null) {
                defaultMetaDiskIndex = DRBD_MD_TYPE_FLEXIBLE;
            } else if (!DRBD_MD_TYPE_FLEXIBLE.equals(defaultMetaDiskIndex) && (index = Integer.valueOf(defaultMetaDiskIndex) - 5) < 0) {
                index = 0;
            }
            indeces[0] = DRBD_MD_TYPE_FLEXIBLE;
            for (int i = 1; i < 11; ++i) {
                indeces[i] = Integer.toString(index);
                ++index;
            }
            this.getBlockDevice().setDefaultValue(DRBD_MD_INDEX_PARAM, DRBD_MD_TYPE_FLEXIBLE);
            return indeces;
        }
        return null;
    }

    @Override
    protected String getParamDefault(String param) {
        return this.getBlockDevice().getDefaultValue(param);
    }

    @Override
    protected String getParamPreferred(String param) {
        return this.getBlockDevice().getPreferredValue(param);
    }

    @Override
    protected boolean checkParamCache(String param) {
        Boolean cv = this.paramCorrectValueMap.get(param);
        if (cv == null) {
            return false;
        }
        return cv;
    }

    protected Info[] getAvailableBlockDevicesForMetaDisk(Info defaultValue, String serviceName, Set<BlockDevInfo> blockDevInfos) {
        ArrayList<Info> list = new ArrayList<Info>();
        String savedMetaDisk = this.getBlockDevice().getValue(DRBD_MD_PARAM);
        if (defaultValue != null) {
            list.add(defaultValue);
        }
        for (BlockDevInfo bdi : blockDevInfos) {
            BlockDevice bd = bdi.getBlockDevice();
            if (!bd.toString().equals(savedMetaDisk) && (bd.isDrbd() || bd.isUsedByCRM() || bd.isMounted())) continue;
            list.add(bdi);
        }
        return list.toArray(new Info[list.size()]);
    }

    void attach(boolean testOnly) {
        DRBD.attach(this.getHost(), this.drbdVolumeInfo.getDrbdResourceInfo().getName(), this.drbdVolumeInfo.getName(), testOnly);
    }

    void detach(boolean testOnly) {
        DRBD.detach(this.getHost(), this.drbdVolumeInfo.getDrbdResourceInfo().getName(), this.drbdVolumeInfo.getName(), testOnly);
    }

    void connect(boolean testOnly) {
        DRBD.connect(this.getHost(), this.drbdVolumeInfo.getDrbdResourceInfo().getName(), null, testOnly);
    }

    void disconnect(boolean testOnly) {
        DRBD.disconnect(this.getHost(), this.drbdVolumeInfo.getDrbdResourceInfo().getName(), null, testOnly);
    }

    void pauseSync(boolean testOnly) {
        DRBD.pauseSync(this.getHost(), this.drbdVolumeInfo.getDrbdResourceInfo().getName(), this.drbdVolumeInfo.getName(), testOnly);
    }

    void resumeSync(boolean testOnly) {
        DRBD.resumeSync(this.getHost(), this.drbdVolumeInfo.getDrbdResourceInfo().getName(), this.drbdVolumeInfo.getName(), testOnly);
    }

    void drbdUp(boolean testOnly) {
        DRBD.up(this.getHost(), this.drbdVolumeInfo.getDrbdResourceInfo().getName(), this.drbdVolumeInfo.getName(), testOnly);
    }

    void setPrimary(boolean testOnly) {
        DRBD.setPrimary(this.getHost(), this.drbdVolumeInfo.getDrbdResourceInfo().getName(), this.drbdVolumeInfo.getName(), testOnly);
    }

    public void setSecondary(boolean testOnly) {
        DRBD.setSecondary(this.getHost(), this.drbdVolumeInfo.getDrbdResourceInfo().getName(), this.drbdVolumeInfo.getName(), testOnly);
    }

    void initDrbd(boolean testOnly) {
        DRBD.initDrbd(this.getHost(), this.drbdVolumeInfo.getDrbdResourceInfo().getName(), this.drbdVolumeInfo.getName(), testOnly);
    }

    public void makeFilesystem(String filesystem, boolean testOnly) {
        DRBD.makeFilesystem(this.getHost(), this.getDrbdVolumeInfo().getDevice(), filesystem, testOnly);
    }

    public boolean pvCreate(boolean testOnly) {
        String device = this.getBlockDevice().isDrbd() ? this.drbdVolumeInfo.getDevice() : this.getBlockDevice().getName();
        boolean ret = LVM.pvCreate(this.getHost(), device, testOnly);
        if (ret) {
            this.getBlockDevice().setVolumeGroupOnPhysicalVolume("");
        }
        return ret;
    }

    public boolean pvRemove(boolean testOnly) {
        String device = this.getBlockDevice().isDrbd() ? this.drbdVolumeInfo.getDevice() : this.getBlockDevice().getName();
        boolean ret = LVM.pvRemove(this.getHost(), device, testOnly);
        if (ret) {
            if (this.getBlockDevice().isDrbd()) {
                this.getBlockDevice().getDrbdBlockDevice().setVolumeGroupOnPhysicalVolume(null);
            } else {
                this.getBlockDevice().setVolumeGroupOnPhysicalVolume(null);
            }
        }
        return ret;
    }

    public boolean lvRemove(boolean testOnly) {
        String device = this.getBlockDevice().getName();
        return LVM.lvRemove(this.getHost(), device, testOnly);
    }

    public boolean lvSnapshot(String snapshotName, String size, boolean testOnly) {
        String device = this.getBlockDevice().getName();
        return LVM.lvSnapshot(this.getHost(), snapshotName, device, size, testOnly);
    }

    public void skipInitialFullSync(boolean testOnly) {
        DRBD.skipInitialFullSync(this.getHost(), this.drbdVolumeInfo.getDrbdResourceInfo().getName(), this.drbdVolumeInfo.getName(), testOnly);
    }

    public void forcePrimary(boolean testOnly) {
        DRBD.forcePrimary(this.getHost(), this.drbdVolumeInfo.getDrbdResourceInfo().getName(), this.drbdVolumeInfo.getName(), testOnly);
    }

    void invalidateBD(boolean testOnly) {
        DRBD.invalidate(this.getHost(), this.drbdVolumeInfo.getDrbdResourceInfo().getName(), this.drbdVolumeInfo.getName(), testOnly);
    }

    void discardData(boolean testOnly) {
        DRBD.discardData(this.getHost(), this.drbdVolumeInfo.getDrbdResourceInfo().getName(), null, testOnly);
    }

    void verify(boolean testOnly) {
        DRBD.verify(this.getHost(), this.drbdVolumeInfo.getDrbdResourceInfo().getName(), this.drbdVolumeInfo.getName(), testOnly);
    }

    public boolean resizeDrbd(boolean testOnly) {
        return DRBD.resize(this.getHost(), this.drbdVolumeInfo.getDrbdResourceInfo().getName(), this.drbdVolumeInfo.getName(), testOnly);
    }

    @Override
    public JPanel getGraphicalView() {
        if (this.getBlockDevice().isDrbd()) {
            this.getBrowser().getDrbdGraph().getDrbdInfo().setSelectedNode(this);
        }
        return this.getBrowser().getDrbdGraph().getDrbdInfo().getGraphicalView();
    }

    @Override
    protected void setTerminalPanel() {
        if (this.getHost() != null) {
            Tools.getGUIData().setTerminalPanel(this.getHost().getTerminalPanel());
        }
    }

    @Override
    public JComponent getInfoPanel() {
        return this.getInfoPanelBD();
    }

    @Override
    public String[] getParametersFromXML() {
        String[] params = new String[]{DRBD_MD_PARAM, DRBD_MD_INDEX_PARAM};
        return params;
    }

    public void apply(boolean testOnly) {
        if (!testOnly) {
            String[] params = this.getParametersFromXML();
            Tools.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BlockDevInfo.this.getApplyButton().setEnabled(false);
                    BlockDevInfo.this.getRevertButton().setEnabled(false);
                }
            });
            this.getInfoPanel();
            this.waitForInfoPanel();
            if (this.getBlockDevice().getMetaDisk() != null) {
                this.getBlockDevice().getMetaDisk().removeMetadiskOfBlockDevice(this.getBlockDevice());
            }
            this.getBlockDevice().setNew(false);
            this.storeComboBoxValues(params);
            Object o = this.getWidget(DRBD_MD_PARAM, null).getValue();
            if (Tools.isStringInfoClass(o)) {
                this.getBlockDevice().setMetaDisk(null);
            } else {
                BlockDevice metaDisk = ((BlockDevInfo)o).getBlockDevice();
                this.getBlockDevice().setMetaDisk(metaDisk);
            }
            this.getBrowser().getDrbdGraph().getDrbdInfo().setAllApplyButtons();
        }
    }

    JComponent getInfoPanelBD() {
        if (this.infoPanel != null) {
            return this.infoPanel;
        }
        final BlockDevInfo thisClass = this;
        ButtonCallback buttonCallback = new ButtonCallback(){
            private volatile boolean mouseStillOver = false;

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public void mouseOut() {
                if (!this.isEnabled()) {
                    return;
                }
                this.mouseStillOver = false;
                DrbdGraph drbdGraph = BlockDevInfo.this.getBrowser().getDrbdGraph();
                drbdGraph.stopTestAnimation(BlockDevInfo.this.getApplyButton());
                BlockDevInfo.this.getApplyButton().setToolTipText(null);
            }

            @Override
            public void mouseOver() {
                if (!this.isEnabled()) {
                    return;
                }
                this.mouseStillOver = true;
                BlockDevInfo.this.getApplyButton().setToolTipText(Tools.getString("ClusterBrowser.StartingDRBDtest"));
                BlockDevInfo.this.getApplyButton().setToolTipBackground(Tools.getDefaultColor("ClusterBrowser.Test.Tooltip.Background"));
                Tools.sleep(250);
                if (!this.mouseStillOver) {
                    return;
                }
                this.mouseStillOver = false;
                CountDownLatch startTestLatch = new CountDownLatch(1);
                DrbdGraph drbdGraph = BlockDevInfo.this.getBrowser().getDrbdGraph();
                drbdGraph.startTestAnimation(BlockDevInfo.this.getApplyButton(), startTestLatch);
                BlockDevInfo.this.getBrowser().drbdtestLockAcquire();
                thisClass.setDRBDtestData(null);
                BlockDevInfo.this.apply(true);
                LinkedHashMap<Host, String> testOutput = new LinkedHashMap<Host, String>();
                try {
                    BlockDevInfo.this.getBrowser().getDrbdGraph().getDrbdInfo().createDrbdConfig(true);
                    for (Host h : BlockDevInfo.this.getHost().getCluster().getHostsArray()) {
                        DRBD.adjust(h, "all", null, true);
                        testOutput.put(h, DRBD.getDRBDtest());
                    }
                }
                catch (Exceptions.DrbdConfigException dce) {
                    Tools.appError("config failed");
                }
                DRBDtestData dtd = new DRBDtestData(testOutput);
                BlockDevInfo.this.getApplyButton().setToolTipText(dtd.getToolTip());
                thisClass.setDRBDtestData(dtd);
                BlockDevInfo.this.getBrowser().drbdtestLockRelease();
                startTestLatch.countDown();
            }
        };
        this.initApplyButton(buttonCallback);
        JPanel mainPanel = new JPanel();
        mainPanel.setBackground(HostBrowser.PANEL_BACKGROUND);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBackground(HostBrowser.BUTTON_PANEL_BACKGROUND);
        buttonPanel.setMinimumSize(new Dimension(0, 50));
        buttonPanel.setPreferredSize(new Dimension(0, 50));
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        JPanel optionsPanel = new JPanel();
        optionsPanel.setBackground(HostBrowser.PANEL_BACKGROUND);
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        optionsPanel.setAlignmentX(0.0f);
        buttonPanel.add((Component)this.getActionsButton(), "East");
        if (this.getBlockDevice().isDrbd()) {
            String[] params = this.getParametersFromXML();
            this.addParams(optionsPanel, params, Tools.getDefaultSize("HostBrowser.DrbdDevLabelWidth"), Tools.getDefaultSize("HostBrowser.DrbdDevFieldWidth"), null);
            this.getApplyButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Tools.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    BlockDevInfo.this.getApplyButton().setEnabled(false);
                                    BlockDevInfo.this.getRevertButton().setEnabled(false);
                                }
                            });
                            BlockDevInfo.this.getBrowser().getClusterBrowser().drbdStatusLock();
                            try {
                                BlockDevInfo.this.getBrowser().getDrbdGraph().getDrbdInfo().createDrbdConfig(false);
                                for (Host h : BlockDevInfo.this.getHost().getCluster().getHostsArray()) {
                                    DRBD.adjust(h, "all", null, false);
                                }
                            }
                            catch (Exceptions.DrbdConfigException e) {
                                BlockDevInfo.this.getBrowser().getClusterBrowser().drbdStatusUnlock();
                                Tools.appError("config failed");
                                return;
                            }
                            BlockDevInfo.this.apply(false);
                            BlockDevInfo.this.getBrowser().getClusterBrowser().drbdStatusUnlock();
                        }
                    });
                    thread.start();
                }
            });
            this.getRevertButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            BlockDevInfo.this.revert();
                        }
                    });
                    thread.start();
                }
            });
            this.addApplyButton(buttonPanel);
            this.addRevertButton(buttonPanel);
        }
        Font f = new Font("Monospaced", 0, Tools.getConfigData().scaled(12));
        JPanel riaPanel = new JPanel();
        riaPanel.setBackground(HostBrowser.PANEL_BACKGROUND);
        riaPanel.setAlignmentX(0.0f);
        riaPanel.add(super.getInfoPanel());
        mainPanel.add(riaPanel);
        mainPanel.add(optionsPanel);
        JPanel newPanel = new JPanel();
        newPanel.setBackground(HostBrowser.PANEL_BACKGROUND);
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        newPanel.add(buttonPanel);
        newPanel.add(new JScrollPane(mainPanel));
        this.infoPanel = newPanel;
        this.infoPanelDone();
        this.setApplyButtons(null, this.getParametersFromXML());
        return this.infoPanel;
    }

    @Override
    boolean selectAutomaticallyInTreeMenu() {
        return this.infoPanel == null;
    }

    void setDrbdVolumeInfo(DrbdVolumeInfo drbdVolumeInfo) {
        this.drbdVolumeInfo = drbdVolumeInfo;
    }

    public DrbdVolumeInfo getDrbdVolumeInfo() {
        return this.drbdVolumeInfo;
    }

    public BlockDevice getBlockDevice() {
        return (BlockDevice)this.getResource();
    }

    public void removeFromDrbd() {
        this.setDrbd(false);
        this.getBlockDevice().setDrbdBlockDevice(null);
        this.setDrbdVolumeInfo(null);
    }

    @Override
    protected String getParamShortDesc(String param) {
        return Tools.getString(param);
    }

    @Override
    protected String getParamLongDesc(String param) {
        return Tools.getString(param + ".Long");
    }

    private MyMenuItem addDrbdResourceMenuItem(final BlockDevInfo oBdi, final boolean testOnly) {
        final BlockDevInfo thisClass = this;
        return new MyMenuItem(oBdi.toString(), null, null, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public void action() {
                DrbdInfo drbdInfo = BlockDevInfo.this.getBrowser().getDrbdGraph().getDrbdInfo();
                this.cleanup();
                BlockDevInfo.this.setInfoPanel(null);
                oBdi.cleanup();
                oBdi.setInfoPanel(null);
                drbdInfo.addDrbdVolume(thisClass, oBdi, true, testOnly);
            }
        };
    }

    private MyMenuItem getPVCreateItem() {
        final BlockDevInfo thisBDI = this;
        return new MyMenuItem(PV_CREATE_MENU_ITEM, null, PV_CREATE_MENU_DESCRIPTION, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                return !BlockDevInfo.this.isLVM() && !BlockDevInfo.this.getBlockDevice().isPhysicalVolume() && !BlockDevInfo.this.getBlockDevice().isDrbdPhysicalVolume();
            }

            @Override
            public String enablePredicate() {
                if (BlockDevInfo.this.getBlockDevice().isDrbd() && !BlockDevInfo.this.getBlockDevice().isPrimary()) {
                    return "must be primary";
                }
                return null;
            }

            @Override
            public void action() {
                PVCreate pvCreate = new PVCreate(thisBDI);
                do {
                    pvCreate.showDialog();
                    if (!pvCreate.isPressedCancelButton()) continue;
                    pvCreate.cancelDialog();
                    return;
                } while (!pvCreate.isPressedFinishButton());
            }
        };
    }

    private MyMenuItem getPVRemoveItem() {
        final BlockDevInfo thisBDI = this;
        return new MyMenuItem(PV_REMOVE_MENU_ITEM, null, PV_REMOVE_MENU_DESCRIPTION, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                BlockDevice bd;
                if (BlockDevInfo.this.getBlockDevice().isDrbd()) {
                    if (!BlockDevInfo.this.getBlockDevice().isPrimary()) {
                        return false;
                    }
                    bd = BlockDevInfo.this.getBlockDevice().getDrbdBlockDevice();
                    if (bd == null) {
                        return false;
                    }
                } else {
                    bd = BlockDevInfo.this.getBlockDevice();
                }
                return bd.isPhysicalVolume() && !bd.isVolumeGroupOnPhysicalVolume();
            }

            @Override
            public String enablePredicate() {
                if (BlockDevInfo.this.getBlockDevice().isDrbd() && !BlockDevInfo.this.getBlockDevice().isDrbdPhysicalVolume()) {
                    return "DRBD is on it";
                }
                return null;
            }

            @Override
            public void action() {
                PVRemove pvRemove = new PVRemove(thisBDI);
                do {
                    pvRemove.showDialog();
                    if (!pvRemove.isPressedCancelButton()) continue;
                    pvRemove.cancelDialog();
                    return;
                } while (!pvRemove.isPressedFinishButton());
            }
        };
    }

    private MyMenuItem getVGCreateItem() {
        final BlockDevInfo thisBDI = this;
        return new MyMenuItem(VG_CREATE_MENU_ITEM, null, VG_CREATE_MENU_DESCRIPTION, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                BlockDevice bd;
                if (BlockDevInfo.this.getBlockDevice().isDrbd()) {
                    if (!BlockDevInfo.this.getBlockDevice().isPrimary()) {
                        return false;
                    }
                    bd = BlockDevInfo.this.getBlockDevice().getDrbdBlockDevice();
                    if (bd == null) {
                        return false;
                    }
                } else {
                    bd = BlockDevInfo.this.getBlockDevice();
                }
                return bd.isPhysicalVolume() && !bd.isVolumeGroupOnPhysicalVolume();
            }

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void action() {
                VGCreate vgCreate = new VGCreate(BlockDevInfo.this.getHost(), thisBDI);
                do {
                    vgCreate.showDialog();
                    if (!vgCreate.isPressedCancelButton()) continue;
                    vgCreate.cancelDialog();
                    return;
                } while (!vgCreate.isPressedFinishButton());
            }
        };
    }

    private MyMenuItem getVGRemoveItem() {
        final BlockDevInfo thisBDI = this;
        return new MyMenuItem(VG_REMOVE_MENU_ITEM, null, VG_REMOVE_MENU_DESCRIPTION, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                BlockDevice bd;
                if (BlockDevInfo.this.getBlockDevice().isDrbd()) {
                    if (!BlockDevInfo.this.getBlockDevice().isPrimary()) {
                        return false;
                    }
                    bd = BlockDevInfo.this.getBlockDevice().getDrbdBlockDevice();
                    if (bd == null) {
                        return false;
                    }
                } else {
                    bd = BlockDevInfo.this.getBlockDevice();
                }
                return bd.isVolumeGroupOnPhysicalVolume();
            }

            @Override
            public String enablePredicate() {
                BlockDevice bd = BlockDevInfo.this.getBlockDevice();
                BlockDevice drbdBD = bd.getDrbdBlockDevice();
                String vg = drbdBD == null ? bd.getVolumeGroupOnPhysicalVolume() : drbdBD.getVolumeGroupOnPhysicalVolume();
                if (BlockDevInfo.this.getHost().getLogicalVolumesFromVolumeGroup(vg) != null) {
                    return "has LV on it";
                }
                return null;
            }

            @Override
            public void action() {
                VGRemove vgRemove = new VGRemove(thisBDI);
                do {
                    vgRemove.showDialog();
                    if (!vgRemove.isPressedCancelButton()) continue;
                    vgRemove.cancelDialog();
                    return;
                } while (!vgRemove.isPressedFinishButton());
            }
        };
    }

    private MyMenuItem getLVCreateItem() {
        String name = LV_CREATE_MENU_ITEM;
        String vgName = this.getBlockDevice().getVolumeGroup();
        if (vgName != null) {
            name = name + vgName;
        }
        final BlockDevInfo thisClass = this;
        MyMenuItem mi = new MyMenuItem(name, null, LV_CREATE_MENU_DESCRIPTION, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            private String getVolumeGroup() {
                String vg;
                BlockDevice bd;
                if (BlockDevInfo.this.getBlockDevice().isDrbd()) {
                    bd = BlockDevInfo.this.getBlockDevice().getDrbdBlockDevice();
                    if (bd == null) {
                        return null;
                    }
                } else {
                    bd = BlockDevInfo.this.getBlockDevice();
                }
                if ((vg = bd.getVolumeGroup()) == null) {
                    return bd.getVolumeGroupOnPhysicalVolume();
                }
                return vg;
            }

            @Override
            public boolean visiblePredicate() {
                String vg = this.getVolumeGroup();
                return vg != null && !"".equals(vg) && BlockDevInfo.this.getHost().getVolumeGroupNames().contains(vg);
            }

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void action() {
                LVCreate lvCreate = new LVCreate(BlockDevInfo.this.getHost(), this.getVolumeGroup(), thisClass.getBlockDevice());
                do {
                    lvCreate.showDialog();
                    if (!lvCreate.isPressedCancelButton()) continue;
                    lvCreate.cancelDialog();
                    return;
                } while (!lvCreate.isPressedFinishButton());
            }

            @Override
            public void update() {
                this.setText1(BlockDevInfo.LV_CREATE_MENU_ITEM + this.getVolumeGroup());
                super.update();
            }
        };
        mi.setToolTipText(LV_CREATE_MENU_DESCRIPTION);
        return mi;
    }

    private MyMenuItem getLVRemoveItem() {
        return new MyMenuItem(LV_REMOVE_MENU_ITEM, null, LV_REMOVE_MENU_DESCRIPTION, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean predicate() {
                return true;
            }

            @Override
            public boolean visiblePredicate() {
                return BlockDevInfo.this.isLVM();
            }

            @Override
            public String enablePredicate() {
                if (BlockDevInfo.this.getBlockDevice().isDrbd()) {
                    return "DRBD is on it";
                }
                return null;
            }

            @Override
            public void action() {
                if (Tools.confirmDialog("Remove Logical Volume", "Remove logical volume and DESTROY all the data on it?", "Remove", "Cancel")) {
                    boolean ret = BlockDevInfo.this.lvRemove(false);
                    Host host = BlockDevInfo.this.getHost();
                    BlockDevInfo.this.getBrowser().getClusterBrowser().updateHWInfo(host);
                }
            }
        };
    }

    private MyMenuItem getLVResizeItem() {
        final BlockDevInfo thisBDI = this;
        return new MyMenuItem(LV_RESIZE_MENU_ITEM, null, LV_RESIZE_MENU_DESCRIPTION, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                return BlockDevInfo.this.isLVM();
            }

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void action() {
                LVResize lvmrd = new LVResize(thisBDI);
                do {
                    lvmrd.showDialog();
                    if (!lvmrd.isPressedCancelButton()) continue;
                    lvmrd.cancelDialog();
                    return;
                } while (!lvmrd.isPressedFinishButton());
            }
        };
    }

    private MyMenuItem getLVSnapshotItem() {
        final BlockDevInfo thisBDI = this;
        return new MyMenuItem(LV_SNAPSHOT_MENU_ITEM, null, LV_SNAPSHOT_MENU_DESCRIPTION, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                return BlockDevInfo.this.isLVM();
            }

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void action() {
                LVSnapshot lvsd = new LVSnapshot(thisBDI);
                do {
                    lvsd.showDialog();
                    if (!lvsd.isPressedCancelButton()) continue;
                    lvsd.cancelDialog();
                    return;
                } while (!lvsd.isPressedFinishButton());
            }
        };
    }

    @Override
    public List<UpdatableItem> createPopup() {
        ArrayList<UpdatableItem> items = new ArrayList<UpdatableItem>();
        BlockDevInfo thisClass = this;
        boolean testOnly = false;
        MyMenu repMenuItem = new MyMenu(Tools.getString("HostBrowser.Drbd.AddDrbdResource"), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                DrbdXML dxml = BlockDevInfo.this.getBrowser().getClusterBrowser().getDrbdXML();
                if (BlockDevInfo.this.drbdVolumeInfo != null) {
                    return "it is already a drbd resouce";
                }
                if (!BlockDevInfo.this.getHost().isConnected()) {
                    return "not connected to the host";
                }
                if (!BlockDevInfo.this.getHost().isDrbdLoaded()) {
                    return "drbd is not loaded";
                }
                if (BlockDevInfo.this.getBlockDevice().isMounted()) {
                    return "is mounted";
                }
                if (BlockDevInfo.this.getBlockDevice().isVolumeGroupOnPhysicalVolume()) {
                    return "is volume group";
                }
                if (!BlockDevInfo.this.getBlockDevice().isAvailable()) {
                    return "not available";
                }
                if (dxml.isDrbdDisabled()) {
                    return "disabled because of config";
                }
                return null;
            }

            @Override
            public void update() {
                super.update();
                Cluster cluster = BlockDevInfo.this.getHost().getCluster();
                Host[] otherHosts = cluster.getHostsArray();
                final ArrayList<1> hostMenus = new ArrayList<1>();
                for (final Host oHost : otherHosts) {
                    if (oHost == BlockDevInfo.this.getHost()) continue;
                    MyMenu hostMenu = new MyMenu(oHost.getName(), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public String enablePredicate() {
                            DrbdXML dxml = BlockDevInfo.this.getBrowser().getClusterBrowser().getDrbdXML();
                            if (!oHost.isConnected()) {
                                return "not connected to the host";
                            }
                            if (!oHost.isDrbdLoaded()) {
                                return "drbd is not loaded";
                            }
                            return null;
                        }

                        @Override
                        public void update() {
                            super.update();
                            Tools.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    this.removeAll();
                                }
                            });
                            Set<BlockDevInfo> blockDevInfos = oHost.getBrowser().getBlockDevInfos();
                            ArrayList<BlockDevInfo> blockDevInfosS = new ArrayList<BlockDevInfo>();
                            for (BlockDevInfo oBdi : blockDevInfos) {
                                if (oBdi.getName().equals(BlockDevInfo.this.getBlockDevice().getName())) {
                                    blockDevInfosS.add(0, oBdi);
                                    continue;
                                }
                                blockDevInfosS.add(oBdi);
                            }
                            for (BlockDevInfo oBdi : blockDevInfosS) {
                                if (oBdi.getDrbdVolumeInfo() == null && oBdi.getBlockDevice().isAvailable()) {
                                    this.add(BlockDevInfo.this.addDrbdResourceMenuItem(oBdi, false));
                                }
                                if (!oBdi.getName().equals(BlockDevInfo.this.getBlockDevice().getName())) continue;
                                this.addSeparator();
                            }
                        }
                    };
                    hostMenu.update();
                    hostMenus.add(hostMenu);
                }
                Tools.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        this.removeAll();
                        for (MyMenu hostMenu : hostMenus) {
                            this.add(hostMenu);
                        }
                    }
                });
            }
        };
        items.add(repMenuItem);
        items.add(this.getPVCreateItem());
        items.add(this.getPVRemoveItem());
        items.add(this.getVGCreateItem());
        items.add(this.getVGRemoveItem());
        items.add(this.getLVCreateItem());
        items.add(this.getLVRemoveItem());
        items.add(this.getLVResizeItem());
        items.add(this.getLVSnapshotItem());
        MyMenuItem attachMenu = new MyMenuItem(Tools.getString("HostBrowser.Drbd.Detach"), NO_HARDDISK_ICON_LARGE, Tools.getString("HostBrowser.Drbd.Detach.ToolTip"), Tools.getString("HostBrowser.Drbd.Attach"), HARDDISK_DRBD_ICON_LARGE, Tools.getString("HostBrowser.Drbd.Attach.ToolTip"), new AccessMode(ConfigData.AccessType.OP, true), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean predicate() {
                return !BlockDevInfo.this.getBlockDevice().isDrbd() || BlockDevInfo.this.getBlockDevice().isAttached();
            }

            @Override
            public boolean visiblePredicate() {
                return BlockDevInfo.this.getBlockDevice().isDrbd();
            }

            @Override
            public String enablePredicate() {
                if (!BlockDevInfo.this.getBlockDevice().isDrbd()) {
                    return BlockDevInfo.NO_DRBD_RESOURCE_STRING;
                }
                if (!Tools.getConfigData().isAdvancedMode() && BlockDevInfo.this.drbdVolumeInfo.getDrbdResourceInfo().isUsedByCRM()) {
                    return "it is used by cluster manager";
                }
                if (BlockDevInfo.this.getBlockDevice().isSyncing()) {
                    return "it is being full-synced";
                }
                return null;
            }

            @Override
            public void action() {
                if (this.getText().equals(Tools.getString("HostBrowser.Drbd.Attach"))) {
                    BlockDevInfo.this.attach(false);
                } else {
                    BlockDevInfo.this.detach(false);
                }
            }
        };
        ClusterBrowser wi = this.getBrowser().getClusterBrowser();
        if (wi != null) {
            ClusterBrowser clusterBrowser = wi;
            clusterBrowser.getClass();
            ClusterBrowser.DRBDMenuItemCallback attachItemCallback = new ClusterBrowser.DRBDMenuItemCallback(clusterBrowser, attachMenu, this.getHost()){
                {
                    ClusterBrowser clusterBrowser = x0;
                    clusterBrowser.getClass();
                    super(x1, x2);
                }

                @Override
                public void action(Host host) {
                    if (BlockDevInfo.this.isDiskless(false)) {
                        BlockDevInfo.this.attach(true);
                    } else {
                        BlockDevInfo.this.detach(true);
                    }
                }
            };
            this.addMouseOverListener(attachMenu, attachItemCallback);
        }
        items.add(attachMenu);
        MyMenuItem connectMenu = new MyMenuItem(Tools.getString("HostBrowser.Drbd.Disconnect"), null, Tools.getString("HostBrowser.Drbd.Disconnect"), Tools.getString("HostBrowser.Drbd.Connect"), null, Tools.getString("HostBrowser.Drbd.Connect"), new AccessMode(ConfigData.AccessType.OP, true), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean predicate() {
                return BlockDevInfo.this.isConnectedOrWF(false);
            }

            @Override
            public boolean visiblePredicate() {
                return BlockDevInfo.this.getBlockDevice().isDrbd();
            }

            @Override
            public String enablePredicate() {
                if (!BlockDevInfo.this.getBlockDevice().isDrbd()) {
                    return BlockDevInfo.NO_DRBD_RESOURCE_STRING;
                }
                if (!Tools.getConfigData().isAdvancedMode() && BlockDevInfo.this.drbdVolumeInfo.getDrbdResourceInfo().isUsedByCRM()) {
                    return "it is used by cluster manager";
                }
                if (!BlockDevInfo.this.getBlockDevice().isSyncing() || BlockDevInfo.this.getBlockDevice().isPrimary() && BlockDevInfo.this.getBlockDevice().isSyncSource() || BlockDevInfo.this.getOtherBlockDevInfo().getBlockDevice().isPrimary() && BlockDevInfo.this.getBlockDevice().isSyncTarget()) {
                    return null;
                }
                return "it is being full-synced";
            }

            @Override
            public void action() {
                if (this.getText().equals(Tools.getString("HostBrowser.Drbd.Connect"))) {
                    BlockDevInfo.this.connect(false);
                } else {
                    BlockDevInfo.this.disconnect(false);
                }
            }
        };
        if (wi != null) {
            ClusterBrowser clusterBrowser = wi;
            clusterBrowser.getClass();
            ClusterBrowser.DRBDMenuItemCallback connectItemCallback = new ClusterBrowser.DRBDMenuItemCallback(clusterBrowser, connectMenu, this.getHost()){
                {
                    ClusterBrowser clusterBrowser = x0;
                    clusterBrowser.getClass();
                    super(x1, x2);
                }

                @Override
                public void action(Host host) {
                    if (BlockDevInfo.this.isConnectedOrWF(false)) {
                        BlockDevInfo.this.disconnect(true);
                    } else {
                        BlockDevInfo.this.connect(true);
                    }
                }
            };
            this.addMouseOverListener(connectMenu, connectItemCallback);
        }
        items.add(connectMenu);
        MyMenuItem setPrimaryItem = new MyMenuItem(Tools.getString("HostBrowser.Drbd.SetPrimaryOtherSecondary"), null, Tools.getString("HostBrowser.Drbd.SetPrimaryOtherSecondary"), Tools.getString("HostBrowser.Drbd.SetPrimary"), null, Tools.getString("HostBrowser.Drbd.SetPrimary"), new AccessMode(ConfigData.AccessType.OP, true), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean predicate() {
                if (!BlockDevInfo.this.getBlockDevice().isDrbd()) {
                    return false;
                }
                return BlockDevInfo.this.getBlockDevice().isSecondary() && BlockDevInfo.this.getOtherBlockDevInfo().getBlockDevice().isPrimary();
            }

            @Override
            public boolean visiblePredicate() {
                return BlockDevInfo.this.getBlockDevice().isDrbd();
            }

            @Override
            public String enablePredicate() {
                if (!BlockDevInfo.this.getBlockDevice().isDrbd()) {
                    return BlockDevInfo.NO_DRBD_RESOURCE_STRING;
                }
                if (!Tools.getConfigData().isAdvancedMode() && BlockDevInfo.this.drbdVolumeInfo.getDrbdResourceInfo().isUsedByCRM()) {
                    return "it is used by cluster manager";
                }
                if (!BlockDevInfo.this.getBlockDevice().isSecondary()) {
                    return "cannot do that to the primary";
                }
                return null;
            }

            @Override
            public void action() {
                BlockDevInfo oBdi = BlockDevInfo.this.getOtherBlockDevInfo();
                if (oBdi != null && oBdi.getBlockDevice().isPrimary() && !"yes".equals(BlockDevInfo.this.drbdVolumeInfo.getDrbdResourceInfo().getParamSaved(BlockDevInfo.ALLOW_TWO_PRIMARIES))) {
                    oBdi.setSecondary(false);
                }
                BlockDevInfo.this.setPrimary(false);
            }
        };
        items.add(setPrimaryItem);
        MyMenuItem setSecondaryItem = new MyMenuItem(Tools.getString("HostBrowser.Drbd.SetSecondary"), null, Tools.getString("HostBrowser.Drbd.SetSecondary.ToolTip"), new AccessMode(ConfigData.AccessType.OP, true), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                return BlockDevInfo.this.getBlockDevice().isDrbd();
            }

            @Override
            public String enablePredicate() {
                if (!BlockDevInfo.this.getBlockDevice().isDrbd()) {
                    return BlockDevInfo.NO_DRBD_RESOURCE_STRING;
                }
                if (!Tools.getConfigData().isAdvancedMode() && BlockDevInfo.this.drbdVolumeInfo.getDrbdResourceInfo().isUsedByCRM()) {
                    return "it is used by cluster manager";
                }
                if (!BlockDevInfo.this.getBlockDevice().isPrimary()) {
                    return "cannot do that to the secondary";
                }
                return null;
            }

            @Override
            public void action() {
                BlockDevInfo.this.setSecondary(false);
            }
        };
        items.add(setSecondaryItem);
        MyMenuItem forcePrimaryItem = new MyMenuItem(Tools.getString("HostBrowser.Drbd.ForcePrimary"), null, Tools.getString("HostBrowser.Drbd.ForcePrimary"), new AccessMode(ConfigData.AccessType.OP, true), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                return BlockDevInfo.this.getBlockDevice().isDrbd();
            }

            @Override
            public String enablePredicate() {
                if (!BlockDevInfo.this.getBlockDevice().isDrbd()) {
                    return BlockDevInfo.NO_DRBD_RESOURCE_STRING;
                }
                if (!Tools.getConfigData().isAdvancedMode() && BlockDevInfo.this.drbdVolumeInfo.getDrbdResourceInfo().isUsedByCRM()) {
                    return "it is used by cluster manager";
                }
                return null;
            }

            @Override
            public void action() {
                BlockDevInfo.this.forcePrimary(false);
            }
        };
        items.add(forcePrimaryItem);
        MyMenuItem invalidateItem = new MyMenuItem(Tools.getString("HostBrowser.Drbd.Invalidate"), null, Tools.getString("HostBrowser.Drbd.Invalidate.ToolTip"), new AccessMode(ConfigData.AccessType.ADMIN, true), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                return BlockDevInfo.this.getBlockDevice().isDrbd();
            }

            @Override
            public String enablePredicate() {
                if (!BlockDevInfo.this.getBlockDevice().isDrbd()) {
                    return BlockDevInfo.NO_DRBD_RESOURCE_STRING;
                }
                if (!Tools.getConfigData().isAdvancedMode() && BlockDevInfo.this.drbdVolumeInfo.getDrbdResourceInfo().isUsedByCRM()) {
                    return "it is used by cluster manager";
                }
                if (BlockDevInfo.this.getBlockDevice().isSyncing()) {
                    return "it is being full-synced";
                }
                if (BlockDevInfo.this.getDrbdVolumeInfo().isVerifying()) {
                    return "it is being verified";
                }
                return null;
            }

            @Override
            public void action() {
                BlockDevInfo.this.invalidateBD(false);
            }
        };
        items.add(invalidateItem);
        MyMenuItem resumeSyncItem = new MyMenuItem(Tools.getString("HostBrowser.Drbd.ResumeSync"), null, Tools.getString("HostBrowser.Drbd.ResumeSync.ToolTip"), Tools.getString("HostBrowser.Drbd.PauseSync"), null, Tools.getString("HostBrowser.Drbd.PauseSync.ToolTip"), new AccessMode(ConfigData.AccessType.OP, true), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean predicate() {
                return BlockDevInfo.this.getBlockDevice().isSyncing() && BlockDevInfo.this.getBlockDevice().isPausedSync();
            }

            @Override
            public boolean visiblePredicate() {
                return BlockDevInfo.this.getBlockDevice().isDrbd();
            }

            @Override
            public String enablePredicate() {
                if (!BlockDevInfo.this.getBlockDevice().isDrbd()) {
                    return BlockDevInfo.NO_DRBD_RESOURCE_STRING;
                }
                if (!Tools.getConfigData().isAdvancedMode() && BlockDevInfo.this.drbdVolumeInfo.getDrbdResourceInfo().isUsedByCRM()) {
                    return "it is used by cluster manager";
                }
                if (!BlockDevInfo.this.getBlockDevice().isSyncing()) {
                    return "it is not being synced";
                }
                return null;
            }

            @Override
            public void action() {
                if (this.getText().equals(Tools.getString("HostBrowser.Drbd.ResumeSync"))) {
                    BlockDevInfo.this.resumeSync(false);
                } else {
                    BlockDevInfo.this.pauseSync(false);
                }
            }
        };
        items.add(resumeSyncItem);
        MyMenuItem resizeItem = new MyMenuItem(Tools.getString("HostBrowser.Drbd.Resize"), null, Tools.getString("HostBrowser.Drbd.Resize.ToolTip"), new AccessMode(ConfigData.AccessType.ADMIN, true), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                return BlockDevInfo.this.getBlockDevice().isDrbd();
            }

            @Override
            public String enablePredicate() {
                if (!BlockDevInfo.this.getBlockDevice().isDrbd()) {
                    return BlockDevInfo.NO_DRBD_RESOURCE_STRING;
                }
                if (!Tools.getConfigData().isAdvancedMode() && BlockDevInfo.this.drbdVolumeInfo.getDrbdResourceInfo().isUsedByCRM()) {
                    return "it is used by cluster manager";
                }
                if (BlockDevInfo.this.getBlockDevice().isSyncing()) {
                    return "it is being full-synced";
                }
                return null;
            }

            @Override
            public void action() {
                BlockDevInfo.this.resizeDrbd(false);
            }
        };
        items.add(resizeItem);
        MyMenuItem discardDataItem = new MyMenuItem(Tools.getString("HostBrowser.Drbd.DiscardData"), null, Tools.getString("HostBrowser.Drbd.DiscardData.ToolTip"), new AccessMode(ConfigData.AccessType.ADMIN, true), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                return BlockDevInfo.this.getBlockDevice().isDrbd();
            }

            @Override
            public String enablePredicate() {
                if (!BlockDevInfo.this.getBlockDevice().isDrbd()) {
                    return BlockDevInfo.NO_DRBD_RESOURCE_STRING;
                }
                if (!Tools.getConfigData().isAdvancedMode() && BlockDevInfo.this.drbdVolumeInfo.getDrbdResourceInfo().isUsedByCRM()) {
                    return "it is used by cluster manager";
                }
                if (BlockDevInfo.this.getBlockDevice().isSyncing()) {
                    return "it is being full-synced";
                }
                if (BlockDevInfo.this.getBlockDevice().isPrimary()) {
                    return "cannot do that to the primary";
                }
                return null;
            }

            @Override
            public void action() {
                BlockDevInfo.this.discardData(false);
            }
        };
        items.add(discardDataItem);
        MyMenuItem proxyItem = new MyMenuItem(Tools.getString("BlockDevInfo.Drbd.ProxyDown"), null, this.getMenuToolTip("DRBD.proxyDown"), Tools.getString("BlockDevInfo.Drbd.ProxyUp"), null, this.getMenuToolTip("DRBD.proxyUp"), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                if (!BlockDevInfo.this.getBlockDevice().isDrbd()) {
                    return false;
                }
                return BlockDevInfo.this.getDrbdVolumeInfo().getDrbdResourceInfo().isProxy(BlockDevInfo.this.getHost());
            }

            @Override
            public String enablePredicate() {
                if (!BlockDevInfo.this.getBlockDevice().isDrbd()) {
                    return BlockDevInfo.NO_DRBD_RESOURCE_STRING;
                }
                DrbdResourceInfo dri = BlockDevInfo.this.drbdVolumeInfo.getDrbdResourceInfo();
                Host pHost = dri.getProxyHost(BlockDevInfo.this.getHost(), false);
                if (pHost == null) {
                    return "not a proxy";
                }
                if (!pHost.isConnected()) {
                    return "not connected to the host";
                }
                if (!pHost.isDrbdProxyRunning()) {
                    return "proxy daemon is not running";
                }
                return null;
            }

            @Override
            public boolean predicate() {
                if (!BlockDevInfo.this.getBlockDevice().isDrbd()) {
                    return false;
                }
                DrbdResourceInfo dri = BlockDevInfo.this.drbdVolumeInfo.getDrbdResourceInfo();
                Host pHost = dri.getProxyHost(BlockDevInfo.this.getHost(), false);
                if (pHost == null) {
                    return false;
                }
                if (BlockDevInfo.this.getBlockDevice().isDrbd()) {
                    return pHost.isDrbdProxyUp(BlockDevInfo.this.drbdVolumeInfo.getDrbdResourceInfo().getName());
                }
                return true;
            }

            @Override
            public void action() {
                DrbdResourceInfo dri = BlockDevInfo.this.drbdVolumeInfo.getDrbdResourceInfo();
                Host pHost = dri.getProxyHost(BlockDevInfo.this.getHost(), false);
                if (pHost.isDrbdProxyUp(BlockDevInfo.this.drbdVolumeInfo.getDrbdResourceInfo().getName())) {
                    DRBD.proxyDown(pHost, BlockDevInfo.this.drbdVolumeInfo.getDrbdResourceInfo().getName(), BlockDevInfo.this.drbdVolumeInfo.getName(), false);
                } else {
                    DRBD.proxyUp(pHost, BlockDevInfo.this.drbdVolumeInfo.getDrbdResourceInfo().getName(), BlockDevInfo.this.drbdVolumeInfo.getName(), false);
                }
                BlockDevInfo.this.getBrowser().getClusterBrowser().updateProxyHWInfo(pHost);
            }
        };
        items.add(proxyItem);
        MyMenuItem viewDrbdLogItem = new MyMenuItem(Tools.getString("HostBrowser.Drbd.ViewDrbdLog"), LOGFILE_ICON, null, new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                return BlockDevInfo.this.getBlockDevice().isDrbd();
            }

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void action() {
                String device = BlockDevInfo.this.getDrbdVolumeInfo().getDevice();
                DrbdLog l = new DrbdLog(BlockDevInfo.this.getHost(), device);
                l.showDialog();
            }
        };
        items.add(viewDrbdLogItem);
        return items;
    }

    @Override
    public int getUsed() {
        DrbdVolumeInfo dvi = this.drbdVolumeInfo;
        if (dvi != null) {
            return dvi.getUsed();
        }
        return this.getBlockDevice().getUsed();
    }

    public String getIconTextForGraph(boolean testOnly) {
        if (!this.getHost().isConnected()) {
            return Tools.getString("HostBrowser.Drbd.NoInfoAvailable");
        }
        if (this.getBlockDevice().isDrbd()) {
            return this.getBlockDevice().getNodeState();
        }
        return null;
    }

    @Override
    public String getMainTextForGraph() {
        String vg;
        if (!this.isLVM() && (vg = this.getBlockDevice().getVolumeGroupOnPhysicalVolume()) != null && !"".equals(vg)) {
            return "VG " + vg;
        }
        return this.getName();
    }

    public Subtext getRightCornerTextForDrbdGraph(boolean testOnly) {
        String vg = null;
        vg = this.isLVM() ? this.getBlockDevice().getVolumeGroup() : this.getBlockDevice().getVolumeGroupOnPhysicalVolume();
        if (this.getBlockDevice().isDrbdMetaDisk()) {
            return METADISK_SUBTEXT;
        }
        if (this.getBlockDevice().isSwap()) {
            return SWAP_SUBTEXT;
        }
        if (this.getBlockDevice().getMountedOn() != null) {
            return MOUNTED_SUBTEXT;
        }
        if (this.getBlockDevice().isDrbd()) {
            String s = this.getBlockDevice().getName();
            if (s.length() > 28) {
                s = "..." + s.substring(s.length() - 28 + 3, s.length());
            }
            if (this.getBlockDevice().isDrbdPhysicalVolume()) {
                String drbdVG = this.getBlockDevice().getDrbdBlockDevice().getVolumeGroupOnPhysicalVolume();
                s = drbdVG != null && !"".equals(drbdVG) ? s + " VG:" + drbdVG : s + " PV";
            }
            return new Subtext(s, Color.BLUE, Color.BLACK);
        }
        if (vg != null && !"".equals(vg)) {
            if (this.isLVM()) {
                return new Subtext("LV in " + vg, Color.BLUE, Color.GREEN);
            }
            return new Subtext(this.getName(), Color.BLUE, Color.GREEN);
        }
        if (this.getBlockDevice().isPhysicalVolume()) {
            return PHYSICAL_VOLUME_SUBTEXT;
        }
        return null;
    }

    public boolean isConnected(boolean testOnly) {
        DRBDtestData dtd = this.getDRBDtestData();
        if (testOnly && dtd != null) {
            return this.isConnectedTest(dtd) && !this.isWFConnection(testOnly);
        }
        return this.getBlockDevice().isConnected();
    }

    boolean isConnectedOrWF(boolean testOnly) {
        DRBDtestData dtd = this.getDRBDtestData();
        if (testOnly && dtd != null) {
            return this.isConnectedTest(dtd);
        }
        return this.getBlockDevice().isConnectedOrWF();
    }

    public boolean isWFConnection(boolean testOnly) {
        DRBDtestData dtd = this.getDRBDtestData();
        if (testOnly && dtd != null) {
            return this.isConnectedOrWF(testOnly) && this.isConnectedTest(dtd) && !this.getOtherBlockDevInfo().isConnectedTest(dtd);
        }
        return this.getBlockDevice().isWFConnection();
    }

    boolean isConnectedTest(DRBDtestData dtd) {
        return dtd.isConnected(this.getHost(), this.drbdVolumeInfo.getDrbdResourceInfo().getName()) || !dtd.isDisconnected(this.getHost(), this.drbdVolumeInfo.getDrbdResourceInfo().getName()) && this.getBlockDevice().isConnectedOrWF();
    }

    public boolean isDiskless(boolean testOnly) {
        DRBDtestData dtd = this.getDRBDtestData();
        DrbdVolumeInfo dvi = this.drbdVolumeInfo;
        if (testOnly && dtd != null && dvi != null) {
            return dtd.isDiskless(this.getHost(), this.drbdVolumeInfo.getDevice()) || !dtd.isAttached(this.getHost(), this.drbdVolumeInfo.getDevice()) && this.getBlockDevice().isDiskless();
        }
        return this.getBlockDevice().isDiskless();
    }

    DRBDtestData getDRBDtestData() {
        ClusterBrowser b = this.getBrowser().getClusterBrowser();
        if (b == null) {
            return null;
        }
        return b.getDRBDtestData();
    }

    void setDRBDtestData(DRBDtestData drbdtestData) {
        ClusterBrowser b = this.getBrowser().getClusterBrowser();
        if (b == null) {
            return;
        }
        b.setDRBDtestData(drbdtestData);
    }

    @Override
    public int compareTo(Info o) {
        String oName;
        String name;
        if (o == null) {
            return -1;
        }
        if (o == this) {
            return 0;
        }
        int volume = 0;
        int oVolume = 0;
        DrbdVolumeInfo dvi = this.getDrbdVolumeInfo();
        if (this.getBlockDevice().isDrbd() && dvi != null) {
            name = dvi.getDrbdResourceInfo().getName();
            String v = dvi.getName();
            if (Tools.isNumber(v)) {
                volume = Integer.parseInt(v);
            }
        } else {
            name = this.getName();
        }
        BlockDevInfo obdi = (BlockDevInfo)o;
        DrbdVolumeInfo odvi = obdi.getDrbdVolumeInfo();
        if (obdi.getBlockDevice().isDrbd() && odvi != null) {
            oName = odvi.getDrbdResourceInfo().getName();
            String v = odvi.getName();
            if (Tools.isNumber(v)) {
                oVolume = Integer.parseInt(v);
            }
        } else {
            oName = ((BlockDevInfo)o).getName();
        }
        if (this.getBlockDevice().isDrbd() && !obdi.getBlockDevice().isDrbd()) {
            return -1;
        }
        if (!this.getBlockDevice().isDrbd() && obdi.getBlockDevice().isDrbd()) {
            return 1;
        }
        if (this.getBlockDevice().isVolumeGroupOnPhysicalVolume() && !obdi.getBlockDevice().isVolumeGroupOnPhysicalVolume()) {
            return 1;
        }
        if (!this.getBlockDevice().isVolumeGroupOnPhysicalVolume() && obdi.getBlockDevice().isVolumeGroupOnPhysicalVolume()) {
            return -1;
        }
        int ret = name.compareToIgnoreCase(oName);
        if (ret == 0) {
            return volume - oVolume;
        }
        return ret;
    }

    public void setParameters(String resName) {
        this.getBlockDevice().setNew(false);
        ClusterBrowser clusterBrowser = this.getBrowser().getClusterBrowser();
        if (clusterBrowser == null) {
            return;
        }
        DrbdVolumeInfo dvi = this.drbdVolumeInfo;
        if (dvi == null) {
            return;
        }
        DrbdXML dxml = clusterBrowser.getDrbdXML();
        String hostName = this.getHost().getName();
        DrbdGraph drbdGraph = this.getBrowser().getDrbdGraph();
        String value = null;
        String volumeNr = dvi.getName();
        for (String param : this.getParametersFromXML()) {
            if (DRBD_MD_PARAM.equals(param)) {
                BlockDevInfo mdI;
                value = dxml.getMetaDisk(hostName, resName, volumeNr);
                if (!"internal".equals(value) && (mdI = drbdGraph.findBlockDevInfo(hostName, value)) != null) {
                    this.getBlockDevice().setMetaDisk(mdI.getBlockDevice());
                }
            } else if (DRBD_MD_INDEX_PARAM.equals(param)) {
                value = dxml.getMetaDiskIndex(hostName, resName, volumeNr);
            }
            String defaultValue = this.getParamDefault(param);
            if (value == null) {
                value = defaultValue;
            }
            if (value == null) {
                value = "";
            }
            String oldValue = this.getParamSaved(param);
            Widget wi = this.getWidget(param, null);
            if (Tools.areEqual(value, oldValue)) continue;
            this.getResource().setValue(param, value);
            if (wi == null) continue;
            wi.setValue(value);
        }
    }

    @Override
    public boolean checkResourceFieldsChanged(String param, String[] params) {
        return this.checkResourceFieldsChanged(param, params, false, false, false);
    }

    boolean checkResourceFieldsChanged(String param, String[] params, boolean fromDrbdInfo, boolean fromDrbdResourceInfo, boolean fromDrbdVolumeInfo) {
        DrbdVolumeInfo dvi = this.getDrbdVolumeInfo();
        if (!(dvi == null || fromDrbdVolumeInfo || fromDrbdResourceInfo || fromDrbdInfo)) {
            dvi.setApplyButtons(null, dvi.getParametersFromXML());
        }
        return super.checkResourceFieldsChanged(param, params);
    }

    @Override
    public boolean checkResourceFieldsCorrect(String param, String[] params) {
        return this.checkResourceFieldsCorrect(param, params, false, false, false);
    }

    boolean checkResourceFieldsCorrect(String param, String[] params, boolean fromDrbdInfo, boolean fromDrbdResourceInfo, boolean fromDrbdVolumeInfo) {
        boolean correct = true;
        DrbdXML dxml = this.getBrowser().getClusterBrowser().getDrbdXML();
        if (dxml != null && dxml.isDrbdDisabled()) {
            correct = false;
        }
        return super.checkResourceFieldsCorrect(param, params) && correct;
    }

    public boolean isLVM() {
        return this.getBlockDevice().getVolumeGroup() != null;
    }

    public Long getFreeInVolumeGroup() {
        return this.getHost().getFreeInVolumeGroup(this.getBlockDevice().getVolumeGroup());
    }

    public boolean isFirstDrbdVolume() {
        if (!this.getBlockDevice().isDrbd()) {
            return true;
        }
        Set<DrbdVolumeInfo> drbdVolumes = this.getDrbdVolumeInfo().getDrbdResourceInfo().getDrbdVolumes();
        if (drbdVolumes == null || drbdVolumes.isEmpty()) {
            return true;
        }
        return drbdVolumes.iterator().next() == this.getDrbdVolumeInfo();
    }

    boolean allowTwoPrimaries() {
        DrbdResourceInfo dri = this.drbdVolumeInfo.getDrbdResourceInfo();
        return "yes".equals(dri.getParamSaved(ALLOW_TWO_PRIMARIES));
    }

    public String getProxyStateForGraph(boolean testOnly) {
        DrbdResourceInfo dri = this.drbdVolumeInfo.getDrbdResourceInfo();
        Host pHost = dri.getProxyHost(this.getHost(), false);
        if (dri.isProxy(this.getHost())) {
            if (pHost.isConnected()) {
                if (pHost.isDrbdProxyUp(dri.getName())) {
                    return PROXY_UP;
                }
                return PROXY_DOWN;
            }
            if (this.drbdVolumeInfo.isConnected(testOnly)) {
                return PROXY_UP;
            }
            return pHost.getName();
        }
        return null;
    }

    private String getMenuToolTip(String cmd) {
        if (this.getBlockDevice().isDrbd()) {
            return DRBD.getDistCommand(cmd, this.getHost(), this.drbdVolumeInfo.getDrbdResourceInfo().getName(), this.drbdVolumeInfo.getName()).replaceAll("@.*?@", "");
        }
        return null;
    }
}

