/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.lvm;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import lcmc.data.AccessMode;
import lcmc.data.Cluster;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.resources.BlockDevice;
import lcmc.gui.Browser;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.lvm.LV;
import lcmc.gui.resources.BlockDevInfo;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.LVM;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;

public final class VGCreate
extends LV {
    private final Host host;
    private final BlockDevInfo selectedBlockDevInfo;
    private final MyButton createButton = new MyButton("Create VG");
    private Widget vgNameWi;
    private Map<Host, JCheckBox> hostCheckBoxes = null;
    private Map<String, JCheckBox> pvCheckBoxes = null;
    private static final String VG_CREATE_DESCRIPTION = "Create a volume group.";
    private static final int CREATE_TIMEOUT = 5000;

    public VGCreate(Host host, BlockDevInfo selectedBlockDevInfo) {
        super(null);
        this.host = host;
        this.selectedBlockDevInfo = selectedBlockDevInfo;
    }

    @Override
    protected void finishDialog() {
    }

    @Override
    protected String getDialogTitle() {
        return "Create VG";
    }

    @Override
    protected String getDescription() {
        return VG_CREATE_DESCRIPTION;
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[0]);
    }

    @Override
    protected void initDialogAfterVisible() {
        this.enableComponents();
        this.makeDefaultAndRequestFocusLater(this.vgNameWi);
        this.makeDefaultButton(this.createButton);
    }

    protected void checkButtons() {
        boolean enable = true;
        for (Host h : this.hostCheckBoxes.keySet()) {
            if (!this.hostCheckBoxes.get(h).isSelected() || this.hostHasPVS(h)) continue;
            enable = false;
            break;
        }
        SwingUtilities.invokeLater(new EnableCreateRunnable(enable));
    }

    private Map<String, JCheckBox> getPVCheckBoxes(String selectedPV) {
        LinkedHashMap<String, JCheckBox> components = new LinkedHashMap<String, JCheckBox>();
        for (BlockDevice pv : this.host.getPhysicalVolumes()) {
            String pvName = pv.getName();
            JCheckBox button = new JCheckBox(pvName, pvName.equals(selectedPV));
            button.setBackground(Tools.getDefaultColor("ConfigDialog.Background.Light"));
            components.put(pvName, button);
        }
        return components;
    }

    private boolean hostHasPVS(Host host) {
        HashMap<String, BlockDevice> oPVS = new HashMap<String, BlockDevice>();
        for (BlockDevice bd : host.getPhysicalVolumes()) {
            oPVS.put(bd.getName(), bd);
        }
        Set<String> pvs = this.pvCheckBoxes.keySet();
        int selected = 0;
        for (String pv : pvs) {
            if (!this.pvCheckBoxes.get(pv).isSelected()) continue;
            ++selected;
            BlockDevice opv = (BlockDevice)oPVS.get(pv);
            if (opv == null) {
                return false;
            }
            if (opv.isPhysicalVolume() && !opv.isVolumeGroupOnPhysicalVolume()) continue;
            return false;
        }
        return selected > 0;
    }

    @Override
    protected JComponent getInputPane() {
        String defaultName;
        this.createButton.setEnabled(false);
        JPanel pane = new JPanel(new SpringLayout());
        JPanel inputPane = new JPanel(new SpringLayout());
        inputPane.setBackground(Browser.BUTTON_PANEL_BACKGROUND);
        Set<String> volumeGroups = this.host.getVolumeGroupNames();
        int i = 0;
        while (true) {
            defaultName = "vg" + String.format("%02d", i);
            if (volumeGroups == null || !volumeGroups.contains(defaultName)) break;
            ++i;
        }
        this.vgNameWi = WidgetFactory.createInstance(Widget.Type.TEXTFIELD, defaultName, Widget.NO_ITEMS, Widget.NO_REGEXP, 250, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.OP, false), Widget.NO_BUTTON);
        inputPane.add(new JLabel("VG Name"));
        inputPane.add(this.vgNameWi);
        this.createButton.addActionListener(new CreateActionListener());
        inputPane.add(this.createButton);
        SpringUtilities.makeCompactGrid(inputPane, 1, 3, 1, 1, 1, 1);
        pane.add(inputPane);
        JPanel pvsPane = new JPanel(new FlowLayout(0));
        String selectedPV = null;
        if (this.selectedBlockDevInfo != null) {
            selectedPV = this.selectedBlockDevInfo.getBlockDevice().isDrbd() ? this.selectedBlockDevInfo.getBlockDevice().getDrbdBlockDevice().getName() : this.selectedBlockDevInfo.getName();
        }
        this.pvCheckBoxes = this.getPVCheckBoxes(selectedPV);
        pvsPane.add(new JLabel("Select physical volumes: "));
        for (String pvName : this.pvCheckBoxes.keySet()) {
            this.pvCheckBoxes.get(pvName).addItemListener(new ItemChangeListener(true));
            pvsPane.add(this.pvCheckBoxes.get(pvName));
        }
        JScrollPane pvSP = new JScrollPane(pvsPane);
        pvSP.setPreferredSize(new Dimension(0, 45));
        pane.add(pvSP);
        JPanel hostsPane = new JPanel(new FlowLayout(0));
        Cluster cluster = this.host.getCluster();
        this.hostCheckBoxes = Tools.getHostCheckBoxes(cluster);
        hostsPane.add(new JLabel("Select Hosts: "));
        for (Host h : this.hostCheckBoxes.keySet()) {
            this.hostCheckBoxes.get(h).addItemListener(new ItemChangeListener(true));
            if (this.host == h) {
                this.hostCheckBoxes.get(h).setEnabled(false);
                this.hostCheckBoxes.get(h).setSelected(true);
            } else if (this.selectedBlockDevInfo != null && this.selectedBlockDevInfo.getBlockDevice().isDrbd()) {
                this.hostCheckBoxes.get(h).setEnabled(false);
                this.hostCheckBoxes.get(h).setSelected(false);
            } else if (this.hostHasPVS(h)) {
                this.hostCheckBoxes.get(h).setEnabled(true);
                this.hostCheckBoxes.get(h).setSelected(false);
            } else {
                this.hostCheckBoxes.get(h).setEnabled(false);
                this.hostCheckBoxes.get(h).setSelected(false);
            }
            hostsPane.add(this.hostCheckBoxes.get(h));
        }
        JScrollPane sp = new JScrollPane(hostsPane);
        sp.setPreferredSize(new Dimension(0, 45));
        pane.add(sp);
        pane.add(this.getProgressBarPane(null));
        pane.add(this.getAnswerPane(""));
        SpringUtilities.makeCompactGrid(pane, 5, 1, 0, 0, 0, 0);
        this.checkButtons();
        return pane;
    }

    private boolean vgCreate(Host host, String vgName, List<String> pvNames) {
        for (String pv : pvNames) {
            BlockDevInfo bdi = host.getBrowser().getDrbdGraph().findBlockDevInfo(host.getName(), pv);
            if (bdi == null) continue;
            bdi.getBlockDevice().setVolumeGroupOnPhysicalVolume(vgName);
            bdi.getBrowser().getDrbdGraph().startAnimation(bdi);
        }
        boolean ret = LVM.vgCreate(host, vgName, pvNames, false);
        if (ret) {
            this.answerPaneAddText("Volume group " + vgName + " was successfully created " + " on " + host.getName() + ".");
        } else {
            this.answerPaneAddTextError("Creating of volume group " + vgName + " failed.");
        }
        return ret;
    }

    private class CreateRunnable
    implements Runnable {
        private CreateRunnable() {
        }

        @Override
        public void run() {
            Tools.invokeAndWait(new EnableCreateRunnable(false));
            VGCreate.this.disableComponents();
            VGCreate.this.getProgressBar().start(5000 * VGCreate.this.hostCheckBoxes.size());
            boolean oneFailed = false;
            for (Host h : VGCreate.this.hostCheckBoxes.keySet()) {
                if (!((JCheckBox)VGCreate.this.hostCheckBoxes.get(h)).isSelected()) continue;
                ArrayList<String> pvNames = new ArrayList<String>();
                for (String pv : VGCreate.this.pvCheckBoxes.keySet()) {
                    if (!((JCheckBox)VGCreate.this.pvCheckBoxes.get(pv)).isSelected()) continue;
                    pvNames.add(pv);
                }
                boolean ret = VGCreate.this.vgCreate(h, VGCreate.this.vgNameWi.getStringValue(), pvNames);
                if (ret) continue;
                oneFailed = true;
            }
            VGCreate.this.enableComponents();
            if (oneFailed) {
                for (Host h : VGCreate.this.hostCheckBoxes.keySet()) {
                    h.getBrowser().getClusterBrowser().updateHWInfo(h);
                }
                VGCreate.this.checkButtons();
                VGCreate.this.progressBarDoneError();
            } else {
                VGCreate.this.progressBarDone();
                VGCreate.this.disposeDialog();
                for (Host h : VGCreate.this.hostCheckBoxes.keySet()) {
                    h.getBrowser().getClusterBrowser().updateHWInfo(h);
                }
            }
        }
    }

    private class CreateActionListener
    implements ActionListener {
        private CreateActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Thread thread = new Thread(new CreateRunnable());
            thread.start();
        }
    }

    private class SizeDocumentListener
    implements DocumentListener {
        private SizeDocumentListener() {
        }

        private void check() {
            VGCreate.this.checkButtons();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.check();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.check();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.check();
        }
    }

    private class ItemChangeListener
    implements ItemListener {
        private final boolean onDeselect;

        public ItemChangeListener(boolean onDeselect) {
            this.onDeselect = onDeselect;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1 || this.onDeselect) {
                VGCreate.this.checkButtons();
            }
        }
    }

    private class EnableCreateRunnable
    implements Runnable {
        private final boolean enable;

        public EnableCreateRunnable(boolean enable) {
            this.enable = enable;
        }

        @Override
        public void run() {
            boolean e = this.enable;
            if (this.enable) {
                boolean vgNameCorrect = true;
                if ("".equals(VGCreate.this.vgNameWi.getStringValue())) {
                    vgNameCorrect = false;
                } else if (VGCreate.this.hostCheckBoxes != null) {
                    for (Host h : VGCreate.this.hostCheckBoxes.keySet()) {
                        Set<String> vgs;
                        if (!((JCheckBox)VGCreate.this.hostCheckBoxes.get(h)).isSelected() || (vgs = h.getVolumeGroupNames()) == null || !vgs.contains(VGCreate.this.vgNameWi.getStringValue())) continue;
                        vgNameCorrect = false;
                        break;
                    }
                }
                if (vgNameCorrect) {
                    VGCreate.this.vgNameWi.setBackground("", "", true);
                } else {
                    e = false;
                    VGCreate.this.vgNameWi.wrongValue();
                }
            }
            VGCreate.this.createButton.setEnabled(e);
        }
    }
}

