/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.host;

import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import lcmc.data.Host;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.host.CheckInstallation;
import lcmc.gui.dialog.host.DialogHost;
import lcmc.utilities.ConvertCmdCallback;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;

final class PacemakerInst
extends DialogHost {
    private static final long serialVersionUID = 1L;
    private WizardDialog nextDialogObject = null;

    PacemakerInst(WizardDialog previousDialog, Host host) {
        super(previousDialog, host);
    }

    void checkAnswer(String ans, String installMethod) {
        this.nextDialogObject = new CheckInstallation(this.getPreviousDialog().getPreviousDialog(), this.getHost());
        this.progressBarDone();
        this.answerPaneSetText(Tools.getString("Dialog.Host.PacemakerInst.InstOk"));
        this.enableComponents(new JComponent[]{this.buttonClass(this.backButton())});
        this.buttonClass(this.nextButton()).requestFocus();
        if (Tools.getConfigData().getAutoOptionHost("pminst") != null) {
            Tools.sleep(1000);
            this.pressNextButton();
        }
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.nextButton())});
    }

    @Override
    protected void initDialogAfterVisible() {
        this.installPm();
    }

    private void installPm() {
        String arch = this.getHost().getDistString("PmInst.install." + this.getHost().getArch());
        if (arch == null) {
            arch = this.getHost().getArch();
        }
        final String archString = arch.replaceAll("i686", "i386");
        String installCommand = "PmInst.install";
        final String installMethod = this.getHost().getPmInstallMethod();
        if (installMethod != null) {
            installCommand = "PmInst.install." + installMethod;
            String filesStr = this.getHost().getDistString("PmInst.install.files." + installMethod);
            if (filesStr != null) {
                String[] parts = filesStr.split(":");
                for (int i = 0; i < parts.length; i += 3) {
                    String fileName = "/help-progs/" + parts[i];
                    String to = parts[i + 1];
                    String perm = parts[i + 2];
                    String file = Tools.getFile(fileName);
                    if (file == null) continue;
                    this.getHost().getSSH().scp(file, to, perm, true, null, null, null);
                }
            }
        }
        Tools.getConfigData().setLastHbPmInstalledMethod(this.getHost().getDistString("PmInst.install.text." + installMethod));
        Tools.getConfigData().setLastInstalledClusterStack("Corosync/OpenAIS");
        this.getHost().execCommandInBash(installCommand, this.getProgressBar(), new ExecCallback(){

            @Override
            public void done(String ans) {
                PacemakerInst.this.checkAnswer(ans, installMethod);
            }

            @Override
            public void doneError(String ans, int exitCode) {
                PacemakerInst.this.printErrorAndRetry(Tools.getString("Dialog.Host.PacemakerInst.InstError"), ans, exitCode);
            }
        }, new ConvertCmdCallback(){

            @Override
            public String convert(String command) {
                return command.replaceAll("@ARCH@", archString);
            }
        }, true, SSH.DEFAULT_COMMAND_TIMEOUT_LONG);
    }

    @Override
    public WizardDialog nextDialog() {
        return this.nextDialogObject;
    }

    @Override
    protected String getHostDialogTitle() {
        return Tools.getString("Dialog.Host.PacemakerInst.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.Host.PacemakerInst.Description");
    }

    @Override
    protected JComponent getInputPane() {
        JPanel pane = new JPanel(new SpringLayout());
        pane.add(this.getProgressBarPane());
        pane.add(this.getAnswerPane(Tools.getString("Dialog.Host.PacemakerInst.Executing")));
        SpringUtilities.makeCompactGrid(pane, 2, 1, 0, 0, 0, 0);
        return pane;
    }
}

