/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.host;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lcmc.AddClusterDialog;
import lcmc.data.Host;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.host.DialogHost;
import lcmc.gui.dialog.host.NewHost;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;

final class Finish
extends DialogHost {
    private static final long serialVersionUID = 1L;
    private MyButton addAnotherHostButton;
    private MyButton confClusterButton;
    private static final ImageIcon HOST_ICON = Tools.createImageIcon(Tools.getDefault("Dialog.Host.Finish.HostIcon"));
    private static final ImageIcon CLUSTER_ICON = Tools.createImageIcon(Tools.getDefault("Dialog.Host.Finish.ClusterIcon"));
    private static final Dimension BUTTON_DIMENSION = new Dimension(300, 100);
    private final JCheckBox saveCB = new JCheckBox(Tools.getString("Dialog.Host.Finish.Save"), true);
    private WizardDialog nextDialog = null;

    Finish(WizardDialog previousDialog, Host host) {
        super(previousDialog, host);
    }

    @Override
    public WizardDialog nextDialog() {
        return this.nextDialog;
    }

    @Override
    protected void finishDialog() {
        if (this.saveCB.isSelected()) {
            String saveFile = Tools.getConfigData().getSaveFile();
            Tools.save(saveFile, false);
        }
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.nextButton()), this.buttonClass(this.finishButton())});
    }

    @Override
    protected void initDialogAfterVisible() {
        this.enableComponents(new JComponent[]{this.buttonClass(this.nextButton())});
        if (Tools.getConfigData().danglingHostsCount() < 2) {
            this.makeDefaultAndRequestFocusLater(this.addAnotherHostButton);
        } else {
            this.makeDefaultAndRequestFocusLater(this.confClusterButton);
        }
        Tools.getConfigData().removeAutoHost();
        if (Tools.getConfigData().getAutoHosts().isEmpty()) {
            if (!Tools.getConfigData().getAutoClusters().isEmpty()) {
                Tools.sleep(1000);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Finish.this.confClusterButton.pressButton();
                    }
                });
            }
        } else {
            Tools.sleep(1000);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Finish.this.addAnotherHostButton.pressButton();
                }
            });
        }
    }

    @Override
    protected String getHostDialogTitle() {
        return Tools.getString("Dialog.Host.Finish.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.Host.Finish.Description");
    }

    @Override
    protected JComponent getInputPane() {
        JPanel pane = new JPanel();
        this.addAnotherHostButton = new MyButton(Tools.getString("Dialog.Host.Finish.AddAnotherHostButton"), HOST_ICON);
        this.addAnotherHostButton.setPreferredSize(BUTTON_DIMENSION);
        final Finish thisClass = this;
        this.addAnotherHostButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Host newHost = new Host();
                        newHost.getSSH().setPasswords(Finish.this.getHost().getSSH().getLastDSAKey(), Finish.this.getHost().getSSH().getLastRSAKey(), Finish.this.getHost().getSSH().getLastPassword());
                        Finish.this.nextDialog = new NewHost(thisClass, newHost);
                        Tools.getGUIData().allHostsUpdate();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Finish.this.addAnotherHostButton.setEnabled(false);
                                Finish.this.buttonClass(Finish.this.nextButton()).pressButton();
                            }
                        });
                    }
                });
                t.start();
            }
        });
        this.confClusterButton = new MyButton(Tools.getString("Dialog.Host.Finish.ConfigureClusterButton"), CLUSTER_ICON);
        this.confClusterButton.setPreferredSize(BUTTON_DIMENSION);
        this.confClusterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Finish.this.confClusterButton.setEnabled(false);
                                Finish.this.buttonClass(Finish.this.finishButton()).pressButton();
                            }
                        });
                        AddClusterDialog c = new AddClusterDialog();
                        c.showDialogs();
                    }
                });
                t.start();
            }
        });
        pane.add(this.addAnotherHostButton);
        if (Tools.getConfigData().danglingHostsCount() < 1) {
            this.confClusterButton.setEnabled(false);
        }
        pane.add(this.confClusterButton);
        this.saveCB.setBackground(Tools.getDefaultColor("ConfigDialog.Background"));
        pane.add(this.saveCB);
        return pane;
    }
}

