/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.drbdConfig;

import javax.swing.JComponent;
import lcmc.data.Host;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.drbdConfig.SSHProxy;
import lcmc.gui.dialog.host.Configuration;
import lcmc.gui.resources.DrbdVolumeInfo;
import lcmc.utilities.Tools;

final class ConfigurationProxy
extends Configuration {
    private static final long serialVersionUID = 1L;
    private final DrbdVolumeInfo drbdVolumeInfo;
    private final WizardDialog origDialog;
    private WizardDialog nextDialogObject = null;

    ConfigurationProxy(WizardDialog previousDialog, Host host, DrbdVolumeInfo drbdVolumeInfo, WizardDialog origDialog) {
        super(previousDialog, host);
        this.drbdVolumeInfo = drbdVolumeInfo;
        this.origDialog = origDialog;
    }

    @Override
    public WizardDialog nextDialog() {
        if (this.nextDialogObject == null) {
            return new SSHProxy(this, this.getHost(), this.drbdVolumeInfo, this.origDialog);
        }
        return this.nextDialogObject;
    }

    @Override
    protected void finishDialog() {
        super.finishDialog();
        if (this.isPressedFinishButton()) {
            if (this.origDialog != null) {
                this.nextDialogObject = this.origDialog;
                this.setPressedButton(this.nextButton());
            }
            this.getHost().getCluster().addProxyHost(this.getHost());
            if (this.drbdVolumeInfo != null) {
                this.drbdVolumeInfo.getDrbdResourceInfo().resetDrbdResourcePanel();
                this.drbdVolumeInfo.getDrbdInfo().addProxyHostNode(this.getHost());
            }
        }
    }

    @Override
    protected String getHostDialogTitle() {
        return Tools.getString("Dialog.Host.Configuration.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.Host.Configuration.Description");
    }

    @Override
    protected JComponent[] nextButtons() {
        return new JComponent[]{this.buttonClass(this.nextButton()), this.buttonClass(this.finishButton())};
    }

    @Override
    protected final WizardDialog dialogAfterCancel() {
        return this.origDialog;
    }
}

