/*
 * Decompiled with CFR 0.152.
 */
package lcmc.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.widget.Widget;
import lcmc.utilities.Tools;
import org.apache.commons.collections15.map.MultiKeyMap;

public final class ResourceAgent {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String provider;
    private final String resourceClass;
    private String version;
    private String longDesc;
    private String shortDesc;
    private final int hash;
    private final List<String> masterParameters = new ArrayList<String>();
    private final List<String> parameters = new ArrayList<String>();
    private final Set<String> paramRequired = new HashSet<String>();
    private final Set<String> paramIsMetaAttr = new HashSet<String>();
    private final Map<String, String> paramLongDesc = new HashMap<String, String>();
    private final Map<String, String> paramShortDesc = new HashMap<String, String>();
    private final Map<String, String> paramType = new HashMap<String, String>();
    private final Map<String, String> paramDefault = new HashMap<String, String>();
    private final Map<String, String> paramPreferred = new HashMap<String, String>();
    private final Map<String, String[]> paramPossibleChoices = new HashMap<String, String[]>();
    private final Map<String, String[]> paramPossibleChoicesMS = new HashMap<String, String[]>();
    private final String menuName;
    private final MultiKeyMap<String, String> opToDefault = new MultiKeyMap();
    private final Set<String> operations = new LinkedHashSet<String>();
    private boolean probablyMasterSlave = false;
    private boolean probablyClone = false;
    private final Map<String, String> sectionMap = new HashMap<String, String>();
    private final Map<String, Widget.Type> fieldType = new HashMap<String, Widget.Type>();
    private final boolean pingService;
    private boolean ignoreDefaults = false;
    private boolean metaDataLoaded = false;
    public static final String SERVICE_CLASS = "service";
    public static final String UPSTART_CLASS = "upstart";
    public static final String SYSTEMD_CLASS = "systemd";
    public static final String LSB_CLASS = "lsb";
    public static final List<String> SERVICE_CLASSES = new ArrayList<String>();
    public static final String HEARTBEAT_CLASS = "heartbeat";
    public static final String OCF_CLASS = "ocf";
    public static final String STONITH_CLASS = "stonith";
    public static final String HEARTBEAT_PROVIDER = "heartbeat";

    public ResourceAgent(String name, String provider, String resourceClass) {
        this.name = name;
        this.provider = provider;
        this.resourceClass = resourceClass;
        this.operations.addAll(Arrays.asList(ClusterBrowser.HB_OPERATIONS));
        this.hash = (name == null ? 0 : name.hashCode() * 31) + (resourceClass == null ? 0 : resourceClass.hashCode());
        this.menuName = "heartbeat".equals(provider) ? name : provider + ":" + name;
        String section = "Resource";
        if (this.isClone()) {
            section = "Set";
        } else if (this.isGroup()) {
            section = "Group";
        }
        this.pingService = "ping".equals(name) || "pingd".equals(name);
        this.addParameter("__drbdmcid");
        this.sectionMap.put("__drbdmcid", section);
        this.paramRequired.add("__drbdmcid");
        this.paramShortDesc.put("__drbdmcid", "Name");
        this.paramLongDesc.put("__drbdmcid", "Name");
        this.addInfoParameter(section, "__pckmkid", "new...", "Id", "Id");
        if (!this.isClone() && !this.isGroup()) {
            this.addInfoParameter("Resource", "ra", this.getRAString(), "Resource Agent", "Resource Agent");
        }
    }

    private void addInfoParameter(String section, String name, String defaultValue, String shortName, String longName) {
        this.addParameter(name);
        if (defaultValue != null) {
            this.paramDefault.put(name, defaultValue);
        }
        this.sectionMap.put(name, section);
        this.paramRequired.add(name);
        this.paramShortDesc.put(name, shortName);
        this.paramLongDesc.put(name, longName);
        this.fieldType.put(name, Widget.Type.LABELFIELD);
    }

    public String getName() {
        return this.name;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getMenuName() {
        return this.menuName;
    }

    public String getResourceClass() {
        return this.resourceClass;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null || !this.getClass().isInstance(oth)) {
            return false;
        }
        ResourceAgent other = (ResourceAgent)this.getClass().cast(oth);
        return (this.name == null ? other.name == null : this.name.equals(other.name)) && (this.resourceClass == null ? other.resourceClass == null : this.resourceClass.equals(other.resourceClass));
    }

    void setVersion(String version2) {
        this.version = version2;
    }

    String getVersion() {
        return this.version;
    }

    void setLongDesc(String longDesc) {
        this.longDesc = longDesc;
    }

    String getLongDesc() {
        return this.longDesc;
    }

    void setShortDesc(String shortDesc) {
        this.shortDesc = shortDesc;
    }

    String getShortDesc() {
        return this.shortDesc;
    }

    void addMasterParameter(String param) {
        this.masterParameters.add(param);
    }

    void addParameter(String param) {
        this.masterParameters.add(param);
        this.parameters.add(param);
    }

    List<String> getParameters(boolean master) {
        if (master) {
            return this.masterParameters;
        }
        return this.parameters;
    }

    private void wrongParameterError(String param) {
        Tools.appError("Wrong parameter: " + param);
    }

    void setParamRequired(String param, boolean required) {
        if (!this.masterParameters.contains(param)) {
            this.wrongParameterError(param);
            return;
        }
        if (required) {
            this.paramRequired.add(param);
        } else {
            this.paramRequired.remove(param);
        }
    }

    boolean isRequired(String param) {
        return this.paramRequired.contains(param);
    }

    void setParamLongDesc(String param, String longDesc) {
        if (!this.masterParameters.contains(param)) {
            this.wrongParameterError(param);
            return;
        }
        this.paramLongDesc.put(param, longDesc);
    }

    void setParamShortDesc(String param, String shortDesc) {
        if (!this.masterParameters.contains(param)) {
            this.wrongParameterError(param);
            return;
        }
        this.paramShortDesc.put(param, shortDesc);
    }

    void setParamType(String param, String type) {
        if (!this.masterParameters.contains(param)) {
            this.wrongParameterError(param);
            return;
        }
        this.paramType.put(param, type);
    }

    String getParamType(String param) {
        return this.paramType.get(param);
    }

    void setParamDefault(String param, String defaultValue) {
        if (!this.masterParameters.contains(param)) {
            this.wrongParameterError(param);
            return;
        }
        this.paramDefault.put(param, defaultValue);
    }

    String getParamDefault(String param) {
        return this.paramDefault.get(param);
    }

    void setParamPreferred(String param, String preferredValue) {
        if (!this.masterParameters.contains(param)) {
            this.wrongParameterError(param);
            return;
        }
        this.paramPreferred.put(param, preferredValue);
    }

    String getParamPreferred(String param) {
        return this.paramPreferred.get(param);
    }

    void setParamPossibleChoices(String param, String[] choices) {
        if (!this.masterParameters.contains(param)) {
            this.wrongParameterError(param);
            return;
        }
        this.paramPossibleChoices.put(param, choices);
    }

    void setParamPossibleChoicesMS(String param, String[] choices) {
        if (!this.masterParameters.contains(param)) {
            this.wrongParameterError(param);
            return;
        }
        this.paramPossibleChoicesMS.put(param, choices);
    }

    String[] getParamPossibleChoices(String param) {
        return this.paramPossibleChoices.get(param);
    }

    String[] getParamPossibleChoicesMS(String param) {
        String[] ret = this.paramPossibleChoicesMS.get(param);
        if (ret == null) {
            return this.getParamPossibleChoices(param);
        }
        return ret;
    }

    String getParamShortDesc(String param) {
        return this.paramShortDesc.get(param);
    }

    String getParamLongDesc(String param) {
        return this.paramLongDesc.get(param);
    }

    public boolean isFilesystem() {
        return "Filesystem".equals(this.name) && this.isOCFClass();
    }

    public boolean isDrbddisk() {
        return "drbddisk".equals(this.name) && this.isHeartbeatClass();
    }

    public boolean isLinbitDrbd() {
        return "drbd".equals(this.name) && "linbit".equals(this.provider);
    }

    public boolean isHbDrbd() {
        return "drbd".equals(this.name) && "heartbeat".equals(this.provider);
    }

    void setParamIsMetaAttr(String param, boolean isMetaAttr) {
        if (!this.masterParameters.contains(param)) {
            this.wrongParameterError(param);
            return;
        }
        if (isMetaAttr) {
            this.paramIsMetaAttr.add(param);
        } else {
            this.paramIsMetaAttr.remove(param);
        }
    }

    boolean isParamMetaAttr(String param) {
        return this.paramIsMetaAttr.contains(param);
    }

    public boolean isIPaddr() {
        return this.isOCFClass() && ("IPaddr".equals(this.name) || "IPaddr2".equals(this.name));
    }

    public boolean isVirtualDomain() {
        return this.isOCFClass() && "VirtualDomain".equals(this.name);
    }

    public boolean isGroup() {
        return "Group".equals(this.name) && "group".equals(this.resourceClass);
    }

    public boolean isClone() {
        return "Clone Set".equals(this.name) && "clone".equals(this.resourceClass);
    }

    public boolean isStonith() {
        return STONITH_CLASS.equals(this.resourceClass);
    }

    public boolean isHeartbeatClass() {
        return "heartbeat".equals(this.resourceClass);
    }

    public boolean isOCFClass() {
        return OCF_CLASS.equals(this.resourceClass);
    }

    void addOperationDefault(String name, String param, String defaultValue) {
        this.opToDefault.put(name, param, defaultValue);
        this.operations.add(name);
    }

    public String getOperationDefault(String name, String param) {
        return this.opToDefault.get((K[])new String[]{name, param});
    }

    public Set<String> getOperationNames() {
        return this.operations;
    }

    void setProbablyMasterSlave(boolean probablyMasterSlave) {
        this.probablyMasterSlave = probablyMasterSlave;
    }

    public boolean isProbablyMasterSlave() {
        return this.probablyMasterSlave;
    }

    void setProbablyClone(boolean probablyClone) {
        this.probablyClone = probablyClone;
    }

    public boolean isProbablyClone() {
        return this.probablyClone;
    }

    String getSection(String param) {
        return this.sectionMap.get(param);
    }

    void setSection(String param, String section) {
        this.sectionMap.put(param, section);
    }

    public Widget.Type getFieldType(String param) {
        return this.fieldType.get(param);
    }

    public String getRAString() {
        if ("heartbeat".equals(this.provider)) {
            return this.resourceClass + ":" + this.name;
        }
        return this.resourceClass + ":" + this.provider + ":" + this.name;
    }

    public boolean isPingService() {
        return this.pingService;
    }

    public void setIgnoreDefaults(boolean ignoreDefaults) {
        this.ignoreDefaults = ignoreDefaults;
    }

    public boolean isIgnoreDefaults() {
        return this.ignoreDefaults;
    }

    public final boolean isMetaDataLoaded() {
        return this.metaDataLoaded;
    }

    public final void setMetaDataLoaded(boolean metaDataLoaded) {
        this.metaDataLoaded = metaDataLoaded;
    }

    public boolean hasParameter(String param) {
        return this.parameters.contains(param);
    }

    static {
        SERVICE_CLASSES.add(SERVICE_CLASS);
        SERVICE_CLASSES.add(UPSTART_CLASS);
        SERVICE_CLASSES.add(SYSTEMD_CLASS);
        SERVICE_CLASSES.add(LSB_CLASS);
    }
}

