/*
 * Decompiled with CFR 0.152.
 */
package lcmc.data;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import lcmc.Exceptions;
import lcmc.data.Cluster;
import lcmc.data.DrbdXML;
import lcmc.data.VMSXML;
import lcmc.data.resources.BlockDevice;
import lcmc.data.resources.NetInterface;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.HostBrowser;
import lcmc.gui.ProgressBar;
import lcmc.gui.ResourceGraph;
import lcmc.gui.SSHGui;
import lcmc.gui.TerminalPanel;
import lcmc.gui.resources.CategoryInfo;
import lcmc.utilities.ConnectionCallback;
import lcmc.utilities.ConvertCmdCallback;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.NewOutputCallback;
import lcmc.utilities.RoboTest;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;

public final class Host {
    private static final long serialVersionUID = 1L;
    private String name;
    private String hostnameEntered = Tools.getDefault("SSH.Host");
    private String ip;
    private final Map<Integer, String[]> ips = new HashMap<Integer, String[]>();
    private String hostname = "unknown";
    private String username = null;
    private String detectedKernelName = "";
    private String detectedDist = "";
    private String detectedDistVersion = "";
    private String detectedKernelVersion = "";
    private String detectedArch = "";
    private String kernelName = "";
    private String dist = "";
    private String distVersion = "";
    private String distVersionString = "";
    private String kernelVersion = "";
    private String arch = "";
    private List<String> availableDrbdVersions = null;
    private String drbdVersionToInstall = null;
    private String drbdVersionUrlStringToInstall = null;
    private String drbdBuildToInstall = null;
    private String drbdPackagesToInstall = null;
    private Cluster cluster = null;
    private String drbdVersion = null;
    private String drbdModuleVersion = null;
    private Map<String, NetInterface> netInterfaces = new LinkedHashMap<String, NetInterface>();
    private Set<String> fileSystems = new TreeSet<String>();
    private Set<String> cryptoModules = new TreeSet<String>();
    private Set<String> qemuKeymaps = new TreeSet<String>();
    private Set<String> cpuMapModels = new TreeSet<String>();
    private Set<String> cpuMapVendors = new TreeSet<String>();
    private Set<String> mountPoints = new TreeSet<String>();
    private Map<String, BlockDevice> blockDevices = new LinkedHashMap<String, BlockDevice>();
    private Map<String, BlockDevice> drbdBlockDevices = new LinkedHashMap<String, BlockDevice>();
    private Map<String, List<String>> guiOptions = new HashMap<String, List<String>>();
    private Set<String> drbdResProxy = new HashSet<String>();
    private Color defaultColor;
    private Color savedColor;
    private SSH.ExecCommandThread connectionStatusThread = null;
    private SSH.ExecCommandThread drbdStatusThread = null;
    private SSH.ExecCommandThread clStatusThread = null;
    private SSH.ExecCommandThread serverStatusThread = null;
    private final Map<String, Point2D> servicePositions = new HashMap<String, Point2D>();
    private String pacemakerVersion = null;
    private String openaisVersion = null;
    private boolean commLayerStopping = false;
    private boolean commLayerStarting = false;
    private boolean pcmkStarting = false;
    private boolean drbdProxyStarting = false;
    private boolean csIsRc = false;
    private boolean aisIsRc = false;
    private boolean heartbeatInit = false;
    private boolean csInit = false;
    private boolean aisInit = false;
    private boolean csRunning = false;
    private boolean aisRunning = false;
    private boolean csAisConf = false;
    private boolean heartbeatIsRc = false;
    private boolean heartbeatRunning = false;
    private boolean heartbeatConf = false;
    private boolean pcmkIsRc = false;
    private boolean pcmkRunning = false;
    private boolean drbdProxyRunning = false;
    private boolean pcmkInit = false;
    private int pcmkServiceVersion = -1;
    private boolean drbdLoaded = false;
    private String corosyncVersion = null;
    private String heartbeatVersion = null;
    private boolean drbdWillBeUpgraded = false;
    private boolean drbdWasInstalled = false;
    private boolean clStatus = false;
    private boolean drbdStatus = false;
    private final SSH ssh = new SSH();
    private TerminalPanel terminalPanel = null;
    private String sshPort = null;
    private Boolean useSudo = null;
    private String sudoPassword = "";
    private HostBrowser browser;
    private CountDownLatch isLoadingGate;
    private final CountDownLatch serverStatusLatch = new CountDownLatch(1);
    private final List<JComponent> enableOnConnectList = new ArrayList<JComponent>();
    private String pmInstallMethod;
    private String hbPmInstallMethod;
    private String drbdInstallMethod;
    private String proxyInstallMethod;
    private String hbLibPath = null;
    private String vmInfoMD5 = null;
    private int index = 0;
    private volatile boolean lastConnected = false;
    private Boolean corosyncHeartbeatRunning = null;
    private String libvirtVersion = null;
    public static final String NOT_CONNECTED_STRING = "not connected to the host";
    public static final String PROXY_NOT_CONNECTED_STRING = "not connected to the proxy host";
    public static final Pattern BDP = Pattern.compile("(\\D+)\\d+");
    public static final Pattern DRBDP = Pattern.compile(".*\\/drbd\\d+$");
    private List<BlockDevice> physicalVolumes = new ArrayList<BlockDevice>();
    private Map<String, Long> volumeGroups = new LinkedHashMap<String, Long>();
    private Map<String, Set<String>> volumeGroupsLVS = new HashMap<String, Set<String>>();
    private boolean savable = true;
    private volatile AtomicBoolean ping = new AtomicBoolean(true);
    private final Lock mDRBDStatusLock = new ReentrantLock();
    private final Lock mUpdateVMSlock = new ReentrantLock();
    private final Lock mInfoTimestampLock = new ReentrantLock();
    private final Map<String, Double> infoTimestamp = new HashMap<String, Double>();
    private final int PING_TIMEOUT = 40000;
    private final int DRBD_EVENTS_TIMEOUT = 40000;
    private final int CLUSTER_EVENTS_TIMEOUT = 40000;
    private final int HW_INFO_TIMEOUT = 40000;
    public static final String DEFAULT_HOSTNAME = "unknown";
    public static final String VM_FILESYSTEM_SOURCE_DIR_LXC = "vm.filesystem.source.dir.lxc";
    public static final String ROOT_USER = "root";
    public static final String DEFAULT_SSH_PORT = "22";
    private static final String NET_INFO = "net-info";
    private static final String DISK_INFO = "disk-info";
    private static final String VG_INFO = "vg-info";
    private static final String FILESYSTEMS_INFO = "filesystems-info";
    private static final String CRYPTO_INFO = "crypto-info";
    private static final String QEMU_KEYMAPS_INFO = "qemu-keymaps-info";
    private static final String CPU_MAP_MODEL_INFO = "cpu-map-model-info";
    private static final String CPU_MAP_VENDOR_INFO = "cpu-map-vendor-info";
    private static final String MOUNT_POINTS_INFO = "mount-points-info";
    private static final String GUI_INFO = "gui-info";
    private static final String INSTALLATION_INFO = "installation-info";
    private static final String GUI_OPTIONS_INFO = "gui-options-info";
    private static final String VERSION_INFO = "version-info";
    private static final String DRBD_PROXY_INFO = "drbd-proxy-info";
    private static final Set<String> INFO_TYPES = new HashSet<String>(Arrays.asList("net-info", "disk-info", "vg-info", "filesystems-info", "crypto-info", "qemu-keymaps-info", "cpu-map-model-info", "cpu-map-vendor-info", "mount-points-info", "gui-info", "installation-info", "gui-options-info", "version-info", "drbd-proxy-info"));

    public Host() {
        if (Tools.getConfigData().getHosts().size() == 1) {
            this.hostnameEntered = Tools.getDefault("SSH.SecHost");
        }
        this.browser = new HostBrowser(this);
        this.browser.initHostResources();
        this.mountPoints.add("/mnt/");
    }

    public Host(String ip) {
        this();
        this.ip = ip;
    }

    public HostBrowser getBrowser() {
        return this.browser;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public Color[] getDrbdColors() {
        Color secColor;
        if (this.defaultColor == null) {
            this.defaultColor = Tools.getDefaultColor("Host.DefaultColor");
        }
        Color col = this.savedColor == null ? this.defaultColor : this.savedColor;
        if (this.isConnected()) {
            if (this.isDrbdStatus() && this.isDrbdLoaded()) {
                return new Color[]{col};
            }
            secColor = Tools.getDefaultColor("Host.NoStatusColor");
        } else {
            secColor = Tools.getDefaultColor("Host.ErrorColor");
        }
        return new Color[]{col, secColor};
    }

    public Color[] getPmColors() {
        Color secColor;
        if (this.defaultColor == null) {
            this.defaultColor = Tools.getDefaultColor("Host.DefaultColor");
        }
        Color col = this.savedColor == null ? this.defaultColor : this.savedColor;
        if (this.isConnected()) {
            if (this.isClStatus()) {
                return new Color[]{col};
            }
            secColor = Tools.getDefaultColor("Host.NoStatusColor");
        } else {
            secColor = Tools.getDefaultColor("Host.ErrorColor");
        }
        return new Color[]{col, secColor};
    }

    void setColor(Color defaultColor) {
        this.defaultColor = defaultColor;
        if (this.savedColor == null) {
            this.savedColor = defaultColor;
        }
        if (this.terminalPanel != null) {
            this.terminalPanel.resetPromptColor();
        }
    }

    public void setSavedColor(Color savedColor) {
        this.savedColor = savedColor;
        if (this.terminalPanel != null) {
            this.terminalPanel.resetPromptColor();
        }
    }

    public void setClStatus(boolean clStatus) {
        this.clStatus = clStatus;
    }

    public void setDrbdStatus(boolean drbdStatus) {
        this.drbdStatus = drbdStatus;
        if (!drbdStatus) {
            for (BlockDevice b : this.getBlockDevices()) {
                b.resetDrbd();
            }
        }
    }

    public boolean isClStatus() {
        return this.clStatus && this.isConnected();
    }

    public boolean isDrbdStatus() {
        return this.drbdStatus;
    }

    public boolean isInCluster() {
        return this.cluster != null;
    }

    public boolean isInCluster(Cluster otherCluster) {
        return this.cluster != null && !this.cluster.equals(otherCluster);
    }

    public void setHostnameEntered(String hostnameEntered) {
        if (hostnameEntered != null && !hostnameEntered.equals(this.hostnameEntered)) {
            this.setName(null);
            this.setIp(null);
            this.setHostname(null);
        }
        this.hostnameEntered = hostnameEntered;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setUsername(String username) {
        if (!username.equals(this.username)) {
            this.ssh.disconnect();
        }
        this.username = username;
    }

    public void setIp(String ip) {
        if (ip != null) {
            if (!ip.equals(this.ip)) {
                this.ssh.disconnect();
            }
        } else if (this.ip != null) {
            this.ssh.disconnect();
        }
        this.ip = ip;
    }

    public void setIps(int hop, String[] ipsForHop) {
        this.ips.put(hop, ipsForHop);
    }

    public NetInterface[] getNetInterfaces() {
        return this.netInterfaces.values().toArray(new NetInterface[this.netInterfaces.size()]);
    }

    public List<String> getBridges() {
        ArrayList<String> bridges = new ArrayList<String>();
        for (NetInterface ni : this.netInterfaces.values()) {
            if (!ni.isBridge()) continue;
            bridges.add(ni.getName());
        }
        return bridges;
    }

    public BlockDevice[] getBlockDevices() {
        return this.blockDevices.values().toArray(new BlockDevice[this.blockDevices.size()]);
    }

    List<String> getBlockDevicesNames() {
        ArrayList<String> blockDevicesNames = new ArrayList<String>();
        for (String bdName : this.blockDevices.keySet()) {
            BlockDevice bd = this.blockDevices.get(bdName);
            if (bd.isDrbd() || bd.isUsedByCRM()) continue;
            blockDevicesNames.add(bdName);
        }
        return blockDevicesNames;
    }

    List<String> getBlockDevicesNamesIntersection(List<String> otherBlockDevices) {
        ArrayList<String> blockDevicesIntersection = new ArrayList<String>();
        if (otherBlockDevices == null) {
            return this.getBlockDevicesNames();
        }
        for (String otherBd : otherBlockDevices) {
            BlockDevice bd = this.blockDevices.get(otherBd);
            if (bd == null || bd.isDrbd()) continue;
            blockDevicesIntersection.add(otherBd);
        }
        return blockDevicesIntersection;
    }

    Map<String, String> getNetworkIps() {
        LinkedHashMap<String, String> networkIps = new LinkedHashMap<String, String>();
        for (NetInterface ni : this.netInterfaces.values()) {
            String netIp = ni.getNetworkIp();
            networkIps.put(netIp, ni.getNetmask());
        }
        return networkIps;
    }

    public Map<String, String> getNetworksIntersection(Map<String, String> otherNetworkIps) {
        if (otherNetworkIps == null) {
            return this.getNetworkIps();
        }
        LinkedHashMap<String, String> networksIntersection = new LinkedHashMap<String, String>();
        for (NetInterface ni : this.netInterfaces.values()) {
            String networkIp;
            if (ni.isLocalHost() || !otherNetworkIps.containsKey(networkIp = ni.getNetworkIp()) || networksIntersection.containsKey(networkIp)) continue;
            networksIntersection.put(networkIp, ni.getNetmask());
        }
        return networksIntersection;
    }

    List<String> getIpsFromNetwork(String netIp) {
        ArrayList<String> networkIps = new ArrayList<String>();
        for (NetInterface ni : this.netInterfaces.values()) {
            if (!netIp.equals(ni.getNetworkIp())) continue;
            networkIps.add(ni.getIp());
        }
        return networkIps;
    }

    BlockDevice getBlockDevice(String device) {
        return this.blockDevices.get(device);
    }

    void removeFileSystems() {
        this.fileSystems.clear();
    }

    String[] getFileSystems() {
        return this.fileSystems.toArray(new String[this.fileSystems.size()]);
    }

    Set<String> getFileSystemsList() {
        return this.fileSystems;
    }

    Set<String> getCryptoModules() {
        return this.cryptoModules;
    }

    public Set<String> getQemuKeymaps() {
        return this.qemuKeymaps;
    }

    public Set<String> getCPUMapModels() {
        return this.cpuMapModels;
    }

    public Set<String> getCPUMapVendors() {
        return this.cpuMapVendors;
    }

    Set<String> getMountPointsList() {
        return this.mountPoints;
    }

    public String[] getIps(int hop) {
        return this.ips.get(hop);
    }

    public void setAvailableDrbdVersions(String[] versions) {
        this.availableDrbdVersions = new ArrayList<String>(Arrays.asList(versions));
    }

    public String[] getAvailableDrbdVersions() {
        if (this.availableDrbdVersions == null) {
            return null;
        }
        return this.availableDrbdVersions.toArray(new String[this.availableDrbdVersions.size()]);
    }

    public boolean isDrbdUpgradeAvailable(String versionString) {
        if (this.availableDrbdVersions == null || versionString == null) {
            return false;
        }
        String version2 = versionString.split(" ")[0];
        for (String v : this.availableDrbdVersions) {
            try {
                if (Tools.compareVersions(v, version2) <= 0) continue;
                return true;
            }
            catch (Exceptions.IllegalVersionException e) {
                Tools.appWarning(e.getMessage(), e);
            }
        }
        return false;
    }

    public String getDrbdVersion() {
        return this.drbdVersion;
    }

    public String getDrbdModuleVersion() {
        return this.drbdModuleVersion;
    }

    public void setDrbdVersionToInstall(String drbdVersionToInstall) {
        this.drbdVersionToInstall = drbdVersionToInstall;
    }

    public void setDrbdVersionUrlStringToInstall(String drbdVersionUrlStringToInstall) {
        this.drbdVersionUrlStringToInstall = drbdVersionUrlStringToInstall;
    }

    public String getDrbdVersionToInstall() {
        return this.drbdVersionToInstall;
    }

    public String getDrbdVersionUrlStringToInstall() {
        return this.drbdVersionUrlStringToInstall;
    }

    public void setDrbdBuildToInstall(String drbdBuildToInstall) {
        this.drbdBuildToInstall = drbdBuildToInstall;
    }

    public String getDrbdBuildToInstall() {
        return this.drbdBuildToInstall;
    }

    public void setDrbdPackagesToInstall(String drbdPackagesToInstall) {
        this.drbdPackagesToInstall = drbdPackagesToInstall;
    }

    void setDistInfo(String[] info) {
        if (info == null) {
            return;
        }
        String lsbVersion = null;
        String lsbDist = null;
        switch (info.length) {
            case 9: {
                lsbVersion = info[8];
            }
            case 8: {
                lsbDist = info[7];
            }
            case 7: {
                lsbVersion = info[6];
            }
            case 6: {
                lsbDist = info[5];
            }
            case 5: {
                this.detectedDist = lsbDist == null || "linux".equals(lsbDist) ? info[4] : lsbDist;
            }
            case 4: {
                this.detectedDistVersion = lsbVersion == null ? info[3] : info[3] + "/" + lsbVersion;
            }
            case 3: {
                this.detectedKernelVersion = info[2];
            }
            case 2: {
                this.detectedArch = info[1];
            }
            case 1: {
                this.detectedKernelName = info[0];
            }
            case 0: {
                break;
            }
            default: {
                Tools.appError("Error.SetDistInfo.CannotSetInfo", Arrays.asList(info).toString());
            }
        }
        this.dist = this.detectedDist;
        this.distVersion = this.detectedDistVersion;
        this.initDistInfo();
        Tools.debug(this, "kernel name: " + this.detectedKernelName, 1);
        Tools.debug(this, "kernel version: " + this.detectedKernelVersion, 1);
        Tools.debug(this, "arch: " + this.detectedArch, 1);
        Tools.debug(this, "dist version: " + this.detectedDistVersion, 1);
        Tools.debug(this, "dist: " + this.detectedDist, 1);
    }

    void initDistInfo() {
        if (!"Linux".equals(this.detectedKernelName)) {
            Tools.appWarning("detected kernel not linux: " + this.detectedKernelName);
        }
        this.setKernelName("Linux");
        if (!this.dist.equals(this.detectedDist)) {
            Tools.appError("dist: " + this.dist + " does not match " + this.detectedDist);
        }
        this.distVersionString = Tools.getDistVersionString(this.dist, this.distVersion);
        this.distVersion = Tools.getDistString("distributiondir", this.detectedDist, this.distVersionString, null);
        this.setKernelVersion(Tools.getKernelDownloadDir(this.detectedKernelVersion, this.getDist(), this.distVersionString, null));
        this.setArch(Tools.getDistString("arch:" + this.detectedArch, this.getDist(), this.distVersionString, null));
    }

    public String getDetectedInfo() {
        return this.detectedDist + " " + this.detectedDistVersion;
    }

    String getDistFromDistVersion(String dV) {
        if ("No Match".equals(dV)) {
            return null;
        }
        Tools.debug(this, "getDistVersionString dist:" + dV.replaceFirst("\\d.*", ""), 0);
        return Tools.getDistString("dist:" + dV.replaceFirst("\\d.*", ""), "", "", null);
    }

    void setDist(String dist) {
        this.dist = dist;
    }

    void setDistVersion(String distVersion) {
        this.distVersion = distVersion;
        this.distVersionString = Tools.getDistVersionString(this.dist, distVersion);
        this.dist = this.getDistFromDistVersion(distVersion);
    }

    public void setArch(String arch) {
        this.arch = arch;
    }

    void setKernelName(String kernelName) {
        this.kernelName = kernelName;
    }

    void setKernelVersion(String kernelVersion) {
        this.kernelVersion = kernelVersion;
    }

    String getKernelName() {
        return this.kernelName;
    }

    public String getKernelVersion() {
        return this.kernelVersion;
    }

    public String getDetectedKernelVersion() {
        return this.detectedKernelVersion;
    }

    public String getArch() {
        return this.arch;
    }

    public String getHeartbeatLibPath() {
        if (this.hbLibPath != null) {
            return this.hbLibPath;
        }
        if ("".equals(this.arch)) {
            Tools.appWarning("getHeartbeatLibPath() called to soon: unknown arch");
        } else if ("x86_64".equals(this.arch) || "amd64".equals(this.arch)) {
            return "/usr/lib64/heartbeat";
        }
        return "/usr/lib/heartbeat";
    }

    public String getLxcLibPath() {
        return this.getDistString("libvirt.lxc.libpath");
    }

    public String getXenLibPath() {
        return this.getDistString("libvirt.xen.libpath");
    }

    public String getDist() {
        return this.dist;
    }

    public String getDistVersion() {
        return this.distVersion;
    }

    public String getDistVersionString() {
        return this.distVersionString;
    }

    public void disconnect() {
        if (this.ssh.isConnected()) {
            this.ssh.forceDisconnect();
        }
        this.setVMInfoMD5(null);
    }

    public String getDistCommand(String commandString, ConvertCmdCallback convertCmdCallback) {
        return Tools.getDistCommand(commandString, this.dist, this.distVersionString, this.arch, convertCmdCallback, false);
    }

    public String getDistString(String commandString) {
        return Tools.getDistString(commandString, this.dist, this.distVersionString, this.arch);
    }

    public List<String> getDistStrings(String commandString) {
        return Tools.getDistStrings(commandString, this.dist, this.distVersionString, this.arch);
    }

    public String getDistCommand(String commandString, final Map<String, String> replaceHash) {
        return Tools.getDistCommand(commandString, this.dist, this.distVersionString, this.arch, new ConvertCmdCallback(){

            @Override
            public String convert(String command) {
                for (String tag : replaceHash.keySet()) {
                    String s;
                    if (tag == null || command.indexOf(tag) <= -1 || (s = (String)replaceHash.get(tag)) == null) continue;
                    command = command.replaceAll(tag, s);
                }
                return command;
            }
        }, false);
    }

    public SSH.ExecCommandThread execCommand(String commandString, ExecCallback execCallback, ConvertCmdCallback convertCmdCallback, boolean outputVisible, int commandTimeout) {
        if (outputVisible) {
            Tools.getGUIData().setTerminalPanel(this.getTerminalPanel());
        }
        return this.ssh.execCommand(Tools.getDistCommand(commandString, this.dist, this.distVersionString, this.arch, convertCmdCallback, false), execCallback, outputVisible, true, commandTimeout);
    }

    public SSH.ExecCommandThread execCommandRaw(String command, ExecCallback callback, boolean outputVisible, boolean commandVisible, int commandTimeout) {
        if (outputVisible) {
            Tools.getGUIData().setTerminalPanel(this.getTerminalPanel());
        }
        return this.ssh.execCommand(command, callback, outputVisible, commandVisible, commandTimeout);
    }

    public SSH.ExecCommandThread execCommand(String commandString, ProgressBar progressBar, ExecCallback callback, ConvertCmdCallback convertCmdCallback, boolean outputVisible, int commandTimeout) {
        if (outputVisible) {
            Tools.getGUIData().setTerminalPanel(this.getTerminalPanel());
        }
        return this.ssh.execCommand(Tools.getDistCommand(commandString, this.dist, this.distVersionString, this.arch, convertCmdCallback, false), progressBar, callback, outputVisible, true, commandTimeout);
    }

    public SSH.ExecCommandThread execCommandInBash(String commandString, ProgressBar progressBar, ExecCallback callback, ConvertCmdCallback convertCmdCallback, boolean outputVisible, int commandTimeout) {
        if (outputVisible) {
            Tools.getGUIData().setTerminalPanel(this.getTerminalPanel());
        }
        return this.ssh.execCommand(Tools.getDistCommand(commandString, this.dist, this.distVersionString, this.arch, convertCmdCallback, true), progressBar, callback, outputVisible, true, commandTimeout);
    }

    public SSH.ExecCommandThread execCommandRaw(String command, ProgressBar progressBar, ExecCallback execCallback, boolean outputVisible, boolean commandVisible, int commandTimeout) {
        if (outputVisible) {
            Tools.getGUIData().setTerminalPanel(this.getTerminalPanel());
        }
        return this.ssh.execCommand(command, progressBar, execCallback, outputVisible, commandVisible, commandTimeout);
    }

    public void execDrbdStatusCommand(ExecCallback execCallback, NewOutputCallback outputCallback) {
        if (this.drbdStatusThread == null) {
            this.drbdStatusThread = this.ssh.execCommand(Tools.getDistCommand("DRBD.getDrbdStatus", this.dist, this.distVersionString, this.arch, null, false), execCallback, outputCallback, false, false, 40000);
        } else {
            Tools.appWarning("trying to start started drbd status");
        }
    }

    public void stopServerStatus() {
        if (this.serverStatusThread == null) {
            Tools.appWarning("trying to stop stopped server status");
            return;
        }
        this.serverStatusThread.cancel();
        this.serverStatusThread = null;
    }

    public void stopDrbdStatus() {
        if (this.drbdStatusThread == null) {
            Tools.appWarning("trying to stop stopped drbd status");
            return;
        }
        this.drbdStatusThread.cancel();
        this.drbdStatusThread = null;
    }

    public void waitOnDrbdStatus() {
        if (this.drbdStatusThread != null) {
            try {
                this.drbdStatusThread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.stopDrbdStatus();
        }
    }

    public void execClStatusCommand(ExecCallback execCallback, NewOutputCallback outputCallback) {
        if (this.clStatusThread == null) {
            this.clStatusThread = this.ssh.execCommand(Tools.getDistCommand("Heartbeat.getClStatus", this.dist, this.distVersionString, this.arch, null, false), execCallback, outputCallback, false, false, 40000);
        } else {
            Tools.appWarning("trying to start started hb status");
        }
    }

    public void waitOnClStatus() {
        try {
            this.clStatusThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.clStatusThread = null;
    }

    public void stopClStatus() {
        if (this.clStatusThread == null) {
            Tools.appWarning("trying to stop stopped hb status");
            return;
        }
        this.clStatusThread.cancel();
    }

    public String getIp() {
        return this.ip;
    }

    public String getIp(int hop) {
        if (this.ip == null) {
            return null;
        }
        String[] ips = this.ip.split(",");
        if (ips.length < hop + 1) {
            return null;
        }
        return ips[hop];
    }

    public String getFirstIp() {
        if (this.ip == null) {
            return null;
        }
        String[] ips = this.ip.split(",");
        return ips[0];
    }

    public String getUsername() {
        return this.username;
    }

    public String getFirstUsername() {
        String[] usernames = this.username.split(",");
        return usernames[0];
    }

    public String getHostnameEntered() {
        return this.hostnameEntered;
    }

    String getSudoPrefix(boolean sudoTest) {
        if (this.useSudo != null && this.useSudo.booleanValue()) {
            if (sudoTest) {
                return "sudo -E -n ";
            }
            return "sudo -E -p 'DRBD MC sudo pwd: ' ";
        }
        return "";
    }

    public String getSudoCommand(String command, boolean sudoTest) {
        if (this.useSudo != null && this.useSudo.booleanValue()) {
            String sudoPrefix = this.getSudoPrefix(sudoTest);
            return command.replaceAll("@DMCSUDO@", sudoPrefix);
        }
        return command.replaceAll("@DMCSUDO@", " ");
    }

    public String getHoppedCommand(String command) {
        int i;
        int hops = Tools.charCount(this.ip, ',') + 1;
        String[] usernames = this.username.split(",");
        String[] ips = this.ip.split(",");
        StringBuilder s = new StringBuilder(200);
        if (hops > 1) {
            String sshAgentPid = "";
            String sshAgentSock = "";
            Map<String, String> variables = System.getenv();
            for (String name : variables.keySet()) {
                String value = variables.get(name);
                if ("SSH_AGENT_PID".equals(name)) {
                    sshAgentPid = value;
                    continue;
                }
                if (!"SSH_AUTH_SOCK".equals(name)) continue;
                sshAgentSock = value;
            }
            s.append("SSH_AGENT_PID=");
            s.append(sshAgentPid);
            s.append(" SSH_AUTH_SOCK=");
            s.append(sshAgentSock);
            s.append(' ');
        }
        for (i = 1; i < hops; ++i) {
            s.append("ssh -q -A -tt -o 'StrictHostKeyChecking no' -o 'ForwardAgent yes' -l ");
            if (i < usernames.length) {
                s.append(usernames[i]);
            } else {
                s.append(ROOT_USER);
            }
            s.append(' ');
            s.append(ips[i]);
            s.append(' ');
            s.append(Tools.escapeQuotes("\"", i - 1));
        }
        s.append(Tools.escapeQuotes(command, hops - 1));
        for (i = hops - 1; i > 0; --i) {
            s.append(Tools.escapeQuotes("\"", i - 1));
        }
        return s.toString();
    }

    public String getHostname() {
        return this.hostname;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        if (this.name == null) {
            String nodeName;
            if (this.hostname != null) {
                int i = this.hostname.indexOf(44);
                nodeName = i > 0 ? this.hostname.substring(i + 1) : this.hostname;
            } else if (this.hostnameEntered != null) {
                int i = this.hostnameEntered.indexOf(44);
                nodeName = i > 0 ? this.hostnameEntered.substring(i + 1) : this.hostnameEntered;
            } else {
                return this.ip;
            }
            return nodeName;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUserAtHost() {
        return this.username + "@" + this.getHostname();
    }

    public SSH getSSH() {
        return this.ssh;
    }

    public void setTerminalPanel(TerminalPanel terminalPanel) {
        this.terminalPanel = terminalPanel;
    }

    public TerminalPanel getTerminalPanel() {
        return this.terminalPanel;
    }

    public void connect(SSHGui sshGui, ConnectionCallback callback) {
        if (sshGui == null) {
            sshGui = new SSHGui(Tools.getGUIData().getMainFrame(), this, null);
        }
        this.ssh.connect(sshGui, callback, this);
    }

    public void connect(SSHGui sshGui, ProgressBar progressBar, ConnectionCallback callback) {
        Tools.debug(this, "host connect: " + sshGui, 1);
        this.ssh.connect(sshGui, progressBar, callback, this);
    }

    public void registerEnableOnConnect(final JComponent c) {
        if (!this.enableOnConnectList.contains(c)) {
            this.enableOnConnectList.add(c);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                c.setEnabled(Host.this.isConnected());
            }
        });
    }

    public void setConnected() {
        final boolean con = this.isConnected();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (JComponent c : Host.this.enableOnConnectList) {
                    c.setEnabled(con);
                }
            }
        });
        if (this.lastConnected != con) {
            this.lastConnected = con;
            if (con) {
                Tools.info(this.getName() + ": connection established");
            } else {
                Tools.info(this.getName() + ": connection lost");
            }
            ClusterBrowser cb = this.getBrowser().getClusterBrowser();
            if (cb != null) {
                cb.getCRMGraph().repaint();
                cb.getDrbdGraph().repaint();
            }
        }
    }

    void connect(SSHGui sshGui, final boolean progressIndicator, final int index) {
        if (!this.isConnected()) {
            final String hostName = this.getName();
            if (progressIndicator) {
                Tools.startProgressIndicator(hostName, Tools.getString("Dialog.Host.SSH.Connecting") + " (" + index + ")");
            }
            if (sshGui == null) {
                sshGui = new SSHGui(Tools.getGUIData().getMainFrame(), this, null);
            }
            this.connect(sshGui, new ConnectionCallback(){

                @Override
                public void done(int flag) {
                    Host.this.setConnected();
                    Host.this.getSSH().execCommandAndWait(":", false, false, 10000);
                    Host.this.getSSH().installGuiHelper();
                    Host.this.getAllInfo();
                    if (progressIndicator) {
                        Tools.stopProgressIndicator(hostName, Tools.getString("Dialog.Host.SSH.Connecting") + " (" + index + ")");
                    }
                }

                @Override
                public void doneError(String errorText) {
                    Host.this.setLoadingError();
                    Host.this.setConnected();
                    if (progressIndicator) {
                        Tools.stopProgressIndicator(hostName, Tools.getString("Dialog.Host.SSH.Connecting") + " (" + index + ")");
                        Tools.progressIndicatorFailed(hostName, Tools.getString("Dialog.Host.SSH.Connecting") + " (" + index + ")");
                        Tools.stopProgressIndicator(hostName, Tools.getString("Dialog.Host.SSH.Connecting") + " (" + index + ")");
                    }
                }
            });
        }
    }

    void getAllInfo() {
        SSH.ExecCommandThread t = this.execCommand("GetHostAllInfo", new ExecCallback(){

            @Override
            public void done(String ans) {
                Host.this.parseHostInfo(ans);
                Host.this.setLoadingDone();
            }

            @Override
            public void doneError(String ans, int exitCode) {
                Host.this.setLoadingError();
            }
        }, null, false, 40000);
        try {
            t.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void getHWInfo(final CategoryInfo[] infosToUpdate, final ResourceGraph[] graphs) {
        SSH.ExecCommandThread t = this.execCommand("GetHostHWInfo", new ExecCallback(){

            @Override
            public void done(String ans) {
                Host.this.parseHostInfo(ans);
                for (CategoryInfo ci : infosToUpdate) {
                    ci.updateTable("main");
                }
                for (ResourceGraph g : graphs) {
                    if (g == null) continue;
                    g.repaint();
                }
                Host.this.setLoadingDone();
            }

            @Override
            public void doneError(String ans, int exitCode) {
                Host.this.setLoadingError();
                Host.this.getSSH().forceReconnect();
            }
        }, null, false, 40000);
        try {
            t.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public String getOutput(String type, StringBuffer buffer) {
        String infoStart = "--" + type + "-info-start--";
        String infoEnd = "--" + type + "-info-end--";
        int infoStartLength = infoStart.length();
        int infoEndLength = infoEnd.length();
        int s = buffer.indexOf(infoStart);
        int s2 = buffer.indexOf("\r\n", s);
        int e = buffer.indexOf(infoEnd, s);
        String out = null;
        if (s > -1 && s < s2 && s2 <= e) {
            Double timestamp = null;
            String ts = buffer.substring(s + infoStartLength, s2);
            try {
                timestamp = Double.parseDouble(ts);
            }
            catch (NumberFormatException nfe) {
                Tools.debug(this, "could not parse: " + ts + " " + nfe);
            }
            this.mInfoTimestampLock.lock();
            if (timestamp != null && (!this.infoTimestamp.containsKey(type) || timestamp >= this.infoTimestamp.get(type))) {
                this.infoTimestamp.put(type, timestamp);
                this.mInfoTimestampLock.unlock();
                out = buffer.substring(s2 + 2, e);
            } else {
                this.mInfoTimestampLock.unlock();
            }
            buffer.delete(0, e + infoEndLength + 2);
        }
        return out;
    }

    public void startPing() {
        SSH.ExecCommandThread t = this.ssh.execCommand(Tools.getDistCommand("PingCommand", this.dist, this.distVersionString, this.arch, null, true), new ExecCallback(){

            @Override
            public void done(String ans) {
            }

            @Override
            public void doneError(String ans, int exitCode) {
            }
        }, new NewOutputCallback(){

            @Override
            public void output(String output) {
                Host.this.ping.set(true);
            }
        }, false, false, 40000);
        try {
            t.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void startHWInfoDaemon(final CategoryInfo[] infosToUpdate, final ResourceGraph[] graphs) {
        final Host host = this;
        this.serverStatusThread = this.ssh.execCommand(Tools.getDistCommand("HostHWInfoDaemon", this.dist, this.distVersionString, this.arch, null, false), new ExecCallback(){

            @Override
            public void done(String ans) {
                Host.this.parseHostInfo(ans);
                for (CategoryInfo ci : infosToUpdate) {
                    ci.updateTable("main");
                }
                for (ResourceGraph g : graphs) {
                    if (g == null) continue;
                    g.repaint();
                }
                if (host.isServerStatusLatch()) {
                    ClusterBrowser cb = Host.this.getBrowser().getClusterBrowser();
                    cb.updateServerStatus(host);
                }
                Host.this.setLoadingDone();
            }

            @Override
            public void doneError(String ans, int exitCode) {
                if (host.isServerStatusLatch()) {
                    ClusterBrowser cb = Host.this.getBrowser().getClusterBrowser();
                    cb.updateServerStatus(host);
                }
                Host.this.setLoadingError();
            }
        }, new NewOutputCallback(){
            private StringBuffer outputBuffer = new StringBuffer(300);

            @Override
            public void output(String output) {
                VMSXML newVMSXML;
                String drbdConfig;
                String vm;
                String hw;
                this.outputBuffer.append(output);
                ClusterBrowser cb = Host.this.getBrowser().getClusterBrowser();
                int i = 0;
                String hwUpdate = null;
                String vmUpdate = null;
                String drbdUpdate = null;
                do {
                    ++i;
                    hw = Host.this.getOutput("hw", this.outputBuffer);
                    if (hw != null) {
                        hwUpdate = hw;
                    }
                    Host.this.vmStatusLock();
                    vm = Host.this.getOutput("vm", this.outputBuffer);
                    if (vm != null) {
                        vmUpdate = vm;
                    }
                    Host.this.vmStatusUnlock();
                    Host.this.drbdStatusLock();
                    drbdConfig = Host.this.getOutput("drbd", this.outputBuffer);
                    if (drbdConfig != null) {
                        drbdUpdate = drbdConfig;
                    }
                    Host.this.drbdStatusUnlock();
                } while (hw != null || vm != null || drbdConfig != null);
                Tools.chomp(this.outputBuffer);
                if (hwUpdate != null) {
                    Host.this.parseHostInfo(hwUpdate);
                    for (ResourceGraph g : graphs) {
                        if (g == null) continue;
                        g.repaint();
                    }
                }
                if (vmUpdate != null && (newVMSXML = new VMSXML(host)).update(vmUpdate)) {
                    cb.vmsXMLPut(host, newVMSXML);
                    cb.updateVMS();
                }
                if (drbdUpdate != null) {
                    DrbdXML dxml = new DrbdXML(Host.this.cluster.getHostsArray(), cb.getDrbdParameters());
                    dxml.update(drbdUpdate);
                    cb.setDrbdXML(dxml);
                    cb.getDrbdGraph().getDrbdInfo().setParameters();
                    cb.updateDrbdResources();
                }
                if (drbdUpdate != null || vmUpdate != null) {
                    cb.updateHWInfo(host);
                }
                if (drbdUpdate != null) {
                    cb.updateServerStatus(host);
                }
                if (Host.this.isServerStatusLatch()) {
                    cb.updateServerStatus(host);
                }
                Host.this.setLoadingDone();
            }
        }, false, false, 40000);
        try {
            this.serverStatusThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void startConnectionStatus() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                do {
                    if (Host.this.ping.get()) {
                        Tools.debug(this, "connection ok on " + Host.this.getName(), 2);
                        Host.this.setConnected();
                        Host.this.ping.set(false);
                    } else {
                        Tools.debug(this, "connection lost on " + Host.this.getName(), 2);
                        Host.this.getSSH().forceReconnect();
                        Host.this.setConnected();
                    }
                    Tools.sleep(40000);
                } while (!Host.this.getBrowser().getClusterBrowser().isCancelServerStatus());
            }
        });
        thread.start();
    }

    public boolean isConnected() {
        if (this.ssh == null) {
            return false;
        }
        return this.ssh.isConnected();
    }

    public String replaceVars(String command, boolean hidePassword) {
        if (command.indexOf("@USER@") > -1) {
            command = command.replaceAll("@USER@", Tools.getConfigData().getDownloadUser());
        }
        if (command.indexOf("@PASSWORD@") > -1) {
            command = hidePassword ? command.replaceAll("@PASSWORD@", "*****") : command.replaceAll("@PASSWORD@", Tools.getConfigData().getDownloadPassword());
        }
        String supportDir = "support";
        if (Tools.getConfigData().isStagingDrbd()) {
            supportDir = "support/staging";
        }
        String drbdDir = "drbd";
        if (this.kernelVersion != null && command.indexOf("@KERNELVERSIONDIR@") > -1) {
            command = command.replaceAll("@KERNELVERSIONDIR@", this.kernelVersion);
        }
        if (this.drbdVersionToInstall != null && command.indexOf("@DRBDVERSION@") > -1) {
            command = command.replaceAll("@DRBDVERSION@", this.drbdVersionToInstall);
        }
        if (this.distVersion != null && command.indexOf("@DISTRIBUTION@") > -1) {
            command = command.replaceAll("@DISTRIBUTION@", this.distVersion);
        }
        if (this.arch != null && command.indexOf("@ARCH@") > -1) {
            command = command.replaceAll("@ARCH@", this.arch);
        }
        if (this.drbdBuildToInstall != null && command.indexOf("@BUILD@") > -1) {
            command = command.replaceAll("@BUILD@", this.drbdBuildToInstall);
        }
        if (this.drbdPackagesToInstall != null && command.indexOf("@DRBDPACKAGES@") > -1) {
            command = command.replaceAll("@DRBDPACKAGES@", this.drbdPackagesToInstall);
        }
        if (command.indexOf("@SUPPORTDIR@") > -1) {
            command = command.replaceAll("@SUPPORTDIR@", supportDir);
        }
        if (command.indexOf("@DRBDDIR@") > -1) {
            command = command.replaceAll("@DRBDDIR@", "drbd");
        }
        if (command.indexOf("@GUI-HELPER@") > -1) {
            command = command.replaceAll("@GUI-HELPER@", "/usr/local/bin/lcmc-gui-helper-" + Tools.getRelease());
        }
        return command;
    }

    public String replaceVars(String command) {
        return this.replaceVars(command, false);
    }

    public void parseHostInfo(String ans) {
        Tools.debug(this, "updating host info: " + this.getName(), 1);
        String[] lines = ans.split("\\r?\\n");
        String type = "";
        ArrayList<String> versionLines = new ArrayList<String>();
        LinkedHashMap<String, BlockDevice> newBlockDevices = new LinkedHashMap<String, BlockDevice>();
        LinkedHashMap<String, BlockDevice> newDrbdBlockDevices = new LinkedHashMap<String, BlockDevice>();
        LinkedHashMap<String, NetInterface> newNetInterfaces = new LinkedHashMap<String, NetInterface>();
        LinkedHashMap<String, Long> newVolumeGroups = new LinkedHashMap<String, Long>();
        HashMap<String, Set<String>> newVolumeGroupsLVS = new HashMap<String, Set<String>>();
        ArrayList<BlockDevice> newPhysicalVolumes = new ArrayList<BlockDevice>();
        TreeSet<String> newFileSystems = new TreeSet<String>();
        TreeSet<String> newCryptoModules = new TreeSet<String>();
        TreeSet<String> newQemuKeymaps = new TreeSet<String>();
        TreeSet<String> newCpuMapModels = new TreeSet<String>();
        TreeSet<String> newCpuMapVendors = new TreeSet<String>();
        TreeSet<String> newMountPoints = new TreeSet<String>();
        HashMap<String, List<String>> newGuiOptions = new HashMap<String, List<String>>();
        HashSet<String> newDrbdResProxy = new HashSet<String>();
        HashSet<String> changedTypes = new HashSet<String>();
        newMountPoints.add("/mnt/");
        String guiOptionName = null;
        for (String line : lines) {
            if (line.indexOf("ERROR:") == 0) break;
            if (line.indexOf("WARNING:") == 0) continue;
            if (INFO_TYPES.contains(line)) {
                type = line;
                changedTypes.add(type);
                continue;
            }
            if (NET_INFO.equals(type)) {
                NetInterface netInterface = new NetInterface(line);
                if (this.netInterfaces.containsKey(netInterface.getName())) {
                    netInterface = this.netInterfaces.get(netInterface.getName());
                }
                newNetInterfaces.put(netInterface.getName(), netInterface);
                continue;
            }
            if (DISK_INFO.equals(type)) {
                String vg;
                BlockDevice blockDevice = new BlockDevice(line);
                String name = blockDevice.getName();
                if (name != null) {
                    Matcher drbdM = DRBDP.matcher(name);
                    if (drbdM.matches()) {
                        if (this.drbdBlockDevices.containsKey(name)) {
                            blockDevice = this.drbdBlockDevices.get(name);
                            blockDevice.update(line);
                        }
                        newDrbdBlockDevices.put(name, blockDevice);
                    } else {
                        Matcher m;
                        if (this.blockDevices.containsKey(name)) {
                            blockDevice = this.blockDevices.get(name);
                            blockDevice.update(line);
                        }
                        newBlockDevices.put(name, blockDevice);
                        if (blockDevice.getVolumeGroup() == null && name.length() > 5 && name.indexOf(47, 5) < 0 && (m = BDP.matcher(name)).matches()) {
                            newBlockDevices.remove(m.group(1));
                        }
                    }
                }
                if ((vg = blockDevice.getVolumeGroup()) != null) {
                    String lv;
                    HashSet<String> logicalVolumes = (HashSet<String>)newVolumeGroupsLVS.get(vg);
                    if (logicalVolumes == null) {
                        logicalVolumes = new HashSet<String>();
                        newVolumeGroupsLVS.put(vg, logicalVolumes);
                    }
                    if ((lv = blockDevice.getLogicalVolume()) != null) {
                        logicalVolumes.add(lv);
                    }
                }
                if (!blockDevice.isPhysicalVolume()) continue;
                newPhysicalVolumes.add(blockDevice);
                continue;
            }
            if (VG_INFO.equals(type)) {
                String[] vgi = line.split("\\s+");
                if (vgi.length == 2) {
                    newVolumeGroups.put(vgi[0], Long.parseLong(vgi[1]));
                    continue;
                }
                Tools.appWarning("could not parse volume info: " + line);
                continue;
            }
            if (FILESYSTEMS_INFO.equals(type)) {
                newFileSystems.add(line);
                continue;
            }
            if (CRYPTO_INFO.equals(type)) {
                newCryptoModules.add(line);
                continue;
            }
            if (QEMU_KEYMAPS_INFO.equals(type)) {
                newQemuKeymaps.add(line);
                continue;
            }
            if (CPU_MAP_MODEL_INFO.equals(type)) {
                newCpuMapModels.add(line);
                continue;
            }
            if (CPU_MAP_VENDOR_INFO.equals(type)) {
                newCpuMapVendors.add(line);
                continue;
            }
            if (MOUNT_POINTS_INFO.equals(type)) {
                newMountPoints.add(line);
                continue;
            }
            if (GUI_INFO.equals(type)) {
                this.parseGuiInfo(line);
                continue;
            }
            if (INSTALLATION_INFO.equals(type)) {
                this.parseInstallationInfo(line);
                continue;
            }
            if (GUI_OPTIONS_INFO.equals(type)) {
                guiOptionName = this.parseGuiOptionsInfo(line, guiOptionName, newGuiOptions);
                continue;
            }
            if (VERSION_INFO.equals(type)) {
                versionLines.add(line);
                continue;
            }
            if (!DRBD_PROXY_INFO.equals(type)) continue;
            String res = null;
            Cluster cluster = this.getCluster();
            if (cluster == null) continue;
            if (line.startsWith("up:")) {
                for (Host otherHost : this.getCluster().getProxyHosts()) {
                    String hostsPart;
                    int i;
                    if (otherHost == this || (i = line.indexOf(hostsPart = "-" + otherHost.getName() + "-" + this.getName())) <= 0) continue;
                    res = line.substring(3, i);
                    break;
                }
            }
            if (res == null) {
                Tools.appWarning("could not parse proxy line: " + line);
                continue;
            }
            newDrbdResProxy.add(res);
        }
        if (changedTypes.contains(NET_INFO)) {
            this.netInterfaces = newNetInterfaces;
        }
        if (changedTypes.contains(DISK_INFO)) {
            this.blockDevices = newBlockDevices;
            this.drbdBlockDevices = newDrbdBlockDevices;
            this.physicalVolumes = newPhysicalVolumes;
            this.volumeGroupsLVS = newVolumeGroupsLVS;
        }
        if (changedTypes.contains(VG_INFO)) {
            this.volumeGroups = newVolumeGroups;
        }
        if (changedTypes.contains(FILESYSTEMS_INFO)) {
            this.fileSystems = newFileSystems;
        }
        if (changedTypes.contains(CRYPTO_INFO)) {
            this.cryptoModules = newCryptoModules;
        }
        if (changedTypes.contains(QEMU_KEYMAPS_INFO)) {
            this.qemuKeymaps = newQemuKeymaps;
        }
        if (changedTypes.contains(CPU_MAP_MODEL_INFO)) {
            this.cpuMapModels = newCpuMapModels;
        }
        if (changedTypes.contains(CPU_MAP_VENDOR_INFO)) {
            this.cpuMapVendors = newCpuMapVendors;
        }
        if (changedTypes.contains(MOUNT_POINTS_INFO)) {
            this.mountPoints = newMountPoints;
        }
        if (changedTypes.contains(VERSION_INFO)) {
            this.setDistInfo(versionLines.toArray(new String[versionLines.size()]));
        }
        if (changedTypes.contains(GUI_OPTIONS_INFO)) {
            this.guiOptions = newGuiOptions;
        }
        if (changedTypes.contains(DRBD_PROXY_INFO)) {
            this.drbdResProxy = newDrbdResProxy;
        }
        this.getBrowser().updateHWResources(this.getNetInterfaces(), this.getBlockDevices(), this.getFileSystems());
    }

    private void parseGuiInfo(String line) {
        String[] tokens = line.split(";");
        String id = null;
        String x = null;
        String y = null;
        for (String token : tokens) {
            String[] r = token.split("=");
            if (r.length != 2) continue;
            if (r[0].equals("hb") || r[0].equals("dr")) {
                id = token;
                continue;
            }
            if (r[0].equals("x")) {
                x = r[1];
                continue;
            }
            if (!r[0].equals("y")) continue;
            y = r[1];
        }
        if (id != null && x != null && y != null) {
            this.servicePositions.put(id, new Point2D.Double(new Double(x), new Double(y)));
        }
    }

    public String parseGuiOptionsInfo(String line, String guiOptionName, Map<String, List<String>> goptions) {
        List<String> options;
        if (line.length() > 2 && line.substring(0, 2).equals("o:")) {
            String name = line.substring(2);
            goptions.put(name, new ArrayList());
            return name;
        }
        if (guiOptionName != null && (options = goptions.get(guiOptionName)) != null) {
            options.add(line);
        }
        return guiOptionName;
    }

    public void parseInstallationInfo(String line) {
        String[] tokens = line.split(":|\\s+");
        if (tokens.length < 2) {
            return;
        }
        if ("pm".equals(tokens[0])) {
            this.pacemakerVersion = tokens.length == 2 ? tokens[1].trim() : null;
        } else if ("cs".equals(tokens[0])) {
            this.corosyncVersion = tokens.length == 2 ? tokens[1].trim() : null;
        } else if ("ais".equals(tokens[0])) {
            this.openaisVersion = tokens.length == 2 ? tokens[1].trim() : null;
        } else if ("ais-rc".equals(tokens[0])) {
            this.aisIsRc = tokens.length == 2 ? "on".equals(tokens[1].trim()) : false;
        } else if ("cs-rc".equals(tokens[0])) {
            this.csIsRc = tokens.length == 2 ? "on".equals(tokens[1].trim()) : false;
        } else if ("cs-ais-conf".equals(tokens[0])) {
            this.csAisConf = tokens.length == 2 ? "on".equals(tokens[1].trim()) : false;
        } else if ("cs-running".equals(tokens[0])) {
            this.csRunning = tokens.length == 2 ? "on".equals(tokens[1].trim()) : false;
        } else if ("ais-running".equals(tokens[0])) {
            if (tokens.length == 2) {
                this.aisRunning = "on".equals(tokens[1].trim());
                this.commLayerStarting = false;
                this.pcmkStarting = false;
            } else {
                this.aisRunning = false;
            }
        } else if ("cs-init".equals(tokens[0])) {
            this.csInit = tokens.length == 2 ? "on".equals(tokens[1].trim()) : false;
        } else if ("ais-init".equals(tokens[0])) {
            this.aisInit = tokens.length == 2 ? "on".equals(tokens[1].trim()) : false;
        } else if ("hb".equals(tokens[0])) {
            this.heartbeatVersion = tokens.length == 2 ? tokens[1].trim() : null;
        } else if ("hb-init".equals(tokens[0])) {
            this.heartbeatInit = tokens.length == 2 ? "on".equals(tokens[1].trim()) : false;
        } else if ("hb-rc".equals(tokens[0])) {
            this.heartbeatIsRc = tokens.length == 2 ? "on".equals(tokens[1].trim()) : false;
        } else if ("hb-conf".equals(tokens[0])) {
            this.heartbeatConf = tokens.length == 2 ? "on".equals(tokens[1].trim()) : false;
        } else if ("hb-running".equals(tokens[0])) {
            this.heartbeatRunning = tokens.length == 2 ? "on".equals(tokens[1].trim()) : false;
        } else if ("pcmk-rc".equals(tokens[0])) {
            this.pcmkIsRc = tokens.length == 2 ? "on".equals(tokens[1].trim()) : false;
        } else if ("pcmk-running".equals(tokens[0])) {
            this.pcmkRunning = tokens.length == 2 ? "on".equals(tokens[1].trim()) : false;
        } else if ("drbdp-running".equals(tokens[0])) {
            this.drbdProxyRunning = tokens.length == 2 ? "on".equals(tokens[1].trim()) : false;
        } else if ("pcmk-init".equals(tokens[0])) {
            this.pcmkInit = tokens.length == 2 ? "on".equals(tokens[1].trim()) : false;
        } else if ("pcmk-svc-ver".equals(tokens[0])) {
            if (tokens.length == 2) {
                try {
                    this.pcmkServiceVersion = Integer.parseInt(tokens[1].trim());
                }
                catch (NumberFormatException e) {
                    this.pcmkServiceVersion = -1;
                }
            }
        } else if ("drbd-loaded".equals(tokens[0])) {
            this.drbdLoaded = tokens.length == 2 ? "on".equals(tokens[1].trim()) : false;
        } else if ("hb-lib-path".equals(tokens[0])) {
            this.hbLibPath = tokens.length == 2 ? tokens[1].trim() : null;
        } else if ("hn".equals(tokens[0])) {
            this.hostname = tokens.length == 2 ? tokens[1].trim() : null;
            this.setName(this.hostname);
        } else if ("drbd".equals(tokens[0])) {
            this.drbdVersion = tokens.length == 2 ? tokens[1].trim() : null;
        } else if ("drbd-mod".equals(tokens[0])) {
            this.drbdModuleVersion = tokens.length == 2 ? tokens[1].trim() : null;
        }
        this.corosyncHeartbeatRunning = this.heartbeatRunning || this.csRunning || this.aisRunning;
        if (this.commLayerStarting && (this.csRunning || this.aisRunning || this.heartbeatRunning)) {
            this.commLayerStarting = false;
        }
        if (this.pcmkStarting && this.pcmkRunning) {
            this.pcmkStarting = false;
        }
        if (this.drbdProxyStarting && this.drbdProxyRunning) {
            this.drbdProxyStarting = false;
        }
        if (this.commLayerStopping && !this.csRunning && !this.aisRunning && !this.heartbeatRunning) {
            this.commLayerStopping = false;
        }
    }

    public Point2D getGraphPosition(String id) {
        return this.servicePositions.get(id);
    }

    public void resetGraphPosition(String id) {
        this.servicePositions.remove(id);
    }

    public void saveGraphPositions(Map<String, Point2D> positions) {
        StringBuilder lines = new StringBuilder();
        for (String id : positions.keySet()) {
            double y;
            Point2D p = positions.get(id);
            double x = p.getX();
            if (x < 0.0) {
                x = 0.0;
            }
            if ((y = p.getY()) < 0.0) {
                y = 0.0;
            }
            lines.append(id + ";x=" + x + ";y=" + y + "\n");
        }
        this.getSSH().createConfig(lines.toString(), "drbdgui.cf", "/var/lib/heartbeat/", "0600", false, null, null);
    }

    public void setHeartbeatVersion(String heartbeatVersion) {
        this.heartbeatVersion = heartbeatVersion;
    }

    public void setCorosyncVersion(String corosyncVersion) {
        this.corosyncVersion = corosyncVersion;
    }

    public void setPacemakerVersion(String pacemakerVersion) {
        this.pacemakerVersion = pacemakerVersion;
    }

    public void setOpenaisVersion(String openaisVersion) {
        this.openaisVersion = openaisVersion;
    }

    public String getPacemakerVersion() {
        return this.pacemakerVersion;
    }

    public String getCorosyncVersion() {
        return this.corosyncVersion;
    }

    public boolean isCorosync() {
        return this.corosyncVersion != null;
    }

    public boolean isOpenaisWrapper() {
        return "wrapper".equals(this.openaisVersion);
    }

    public String getOpenaisVersion() {
        return this.openaisVersion;
    }

    public String getHeartbeatVersion() {
        return this.heartbeatVersion;
    }

    public void setDrbdWillBeUpgraded(boolean drbdWillBeUpgraded) {
        this.drbdWillBeUpgraded = drbdWillBeUpgraded;
    }

    public void setDrbdWasInstalled(boolean drbdWasInstalled) {
        this.drbdWasInstalled = drbdWasInstalled;
    }

    public boolean isDrbdUpgraded() {
        return this.drbdWillBeUpgraded && this.drbdWasInstalled;
    }

    public void setIsLoading() {
        this.isLoadingGate = new CountDownLatch(1);
    }

    public void waitOnLoading() {
        if (this.isLoadingGate == null) {
            return;
        }
        try {
            this.isLoadingGate.await();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    void setLoadingDone() {
        this.isLoadingGate.countDown();
    }

    void setLoadingError() {
        this.isLoadingGate.countDown();
    }

    public void waitForServerStatusLatch() {
        try {
            this.serverStatusLatch.await();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    public void serverStatusLatchDone() {
        this.serverStatusLatch.countDown();
    }

    public boolean isServerStatusLatch() {
        return this.serverStatusLatch.getCount() == 1L;
    }

    public String getSSHPort() {
        return this.sshPort;
    }

    public int getSSHPortInt() {
        return Integer.valueOf(this.sshPort);
    }

    public void setSSHPort(String sshPort) {
        if (sshPort != null && !sshPort.equals(this.sshPort)) {
            this.ssh.disconnect();
        }
        this.sshPort = sshPort;
    }

    public String getSudoPassword() {
        return this.sudoPassword;
    }

    public void setSudoPassword(String sudoPassword) {
        this.sudoPassword = sudoPassword;
    }

    public Boolean isUseSudo() {
        return this.useSudo;
    }

    public void setUseSudo(Boolean useSudo) {
        this.useSudo = useSudo;
    }

    public void setPmInstallMethod(String pmInstallMethod) {
        this.pmInstallMethod = pmInstallMethod;
    }

    public String getPmInstallMethod() {
        return this.pmInstallMethod;
    }

    public void setHbPmInstallMethod(String hbPmInstallMethod) {
        this.hbPmInstallMethod = hbPmInstallMethod;
    }

    public String getHbPmInstallMethod() {
        return this.hbPmInstallMethod;
    }

    public void setDrbdInstallMethod(String drbdInstallMethod) {
        this.drbdInstallMethod = drbdInstallMethod;
    }

    public String getDrbdInstallMethod() {
        return this.drbdInstallMethod;
    }

    public void setProxyInstallMethod(String proxyInstallMethod) {
        this.proxyInstallMethod = proxyInstallMethod;
    }

    public String getProxyInstallMethod() {
        return this.proxyInstallMethod;
    }

    public boolean isCsRc() {
        return this.csIsRc;
    }

    public boolean isAisRc() {
        return this.aisIsRc;
    }

    public boolean isPcmkRc() {
        return this.pcmkIsRc;
    }

    public boolean isHeartbeatInit() {
        return this.heartbeatInit;
    }

    public boolean isCsInit() {
        return this.csInit;
    }

    public boolean isAisInit() {
        return this.aisInit;
    }

    public boolean isPcmkInit() {
        return this.pcmkInit;
    }

    public boolean isCsRunning() {
        return this.csRunning;
    }

    public boolean isPcmkRunning() {
        return this.pcmkRunning;
    }

    public boolean isDrbdProxyRunning() {
        return this.drbdProxyRunning;
    }

    public boolean isAisRunning() {
        return this.aisRunning;
    }

    public boolean isCsAisConf() {
        return this.csAisConf;
    }

    public boolean isHeartbeatRc() {
        return this.heartbeatIsRc;
    }

    public boolean isHeartbeatRunning() {
        return this.heartbeatRunning;
    }

    public boolean isHeartbeatConf() {
        return this.heartbeatConf;
    }

    public boolean isDrbdLoaded() {
        return this.drbdLoaded;
    }

    String getVMInfoMD5() {
        return this.vmInfoMD5;
    }

    void setVMInfoMD5(String vmInfoMD5) {
        this.vmInfoMD5 = vmInfoMD5;
    }

    void setIndex(int index) {
        this.index = index;
    }

    int getIndex() {
        return this.index;
    }

    boolean checkTest(String checkCommand, String test, double index, String name, int maxHosts) {
        Tools.sleep(1500);
        StringBuilder command = new StringBuilder(50);
        command.append("@DMCSUDO@" + this.replaceVars("@GUI-HELPER@"));
        command.append(' ');
        command.append(checkCommand);
        command.append(' ');
        command.append(test);
        command.append(' ');
        String indexString = Double.toString(index).replaceFirst("\\.0+$", "");
        command.append(indexString);
        if (name != null) {
            command.append(' ');
            command.append(name);
        }
        int h = 1;
        for (Host host : this.getCluster().getHosts()) {
            Tools.debug(this, "host" + h + " = " + host.getName(), 1);
            command.append(' ');
            command.append(host.getName());
            if (maxHosts > 0 && h >= maxHosts) break;
            ++h;
        }
        command.append(" 2>&1");
        int i = 0;
        SSH.SSHOutput out = null;
        while (i < 5 && (out = this.getSSH().execCommandAndWait(command.toString(), false, false, 60000)).getExitCode() != 0 && out.getExitCode() != 10) {
            RoboTest.sleepNoFactor(++i * 2000);
        }
        String nameS = " " + name;
        if (name == null) {
            nameS = "";
        }
        if (i > 0) {
            RoboTest.info(this.getName() + " " + test + " " + index + nameS + " tries: " + (i + 1));
        }
        RoboTest.info(this.getName() + " " + test + " " + index + nameS + " " + out.getOutput());
        return out.getExitCode() == 0;
    }

    public boolean checkPCMKTest(String test, double index) {
        return this.checkTest("gui-test", test, index, null, 0);
    }

    public boolean checkDRBDTest(String test, double index) {
        StringBuilder testName = new StringBuilder(20);
        if (Tools.getConfigData().getBigDRBDConf()) {
            testName.append("big-");
        }
        if (!this.hasVolumes()) {
            testName.append("novolumes-");
        }
        testName.append(test);
        return this.checkTest("gui-drbd-test", testName.toString(), index, null, 2);
    }

    public boolean checkVMTest(String test, double index, String name) {
        return this.checkTest("gui-vm-test", test, index, name, 0);
    }

    String getColor() {
        if (this.savedColor == null || this.defaultColor == this.savedColor) {
            return null;
        }
        return Integer.toString(this.savedColor.getRGB());
    }

    public void setSavedColor(String colorString) {
        try {
            this.savedColor = new Color(Integer.parseInt(colorString));
        }
        catch (NumberFormatException e) {
            Tools.appWarning("could not parse: " + colorString);
        }
    }

    public long getFreeInVolumeGroup(String volumeGroup) {
        Long f = this.volumeGroups.get(volumeGroup);
        if (f == null) {
            return 0L;
        }
        return f;
    }

    public Set<String> getVolumeGroupNames() {
        return this.volumeGroups.keySet();
    }

    public Boolean getCorosyncHeartbeatRunning() {
        return this.corosyncHeartbeatRunning;
    }

    public void setCorosyncHeartbeatRunning(Boolean corosyncHeartbeatRunning) {
        this.corosyncHeartbeatRunning = corosyncHeartbeatRunning;
    }

    public boolean isCommLayerStopping() {
        return this.commLayerStopping;
    }

    public void setCommLayerStopping(boolean commLayerStopping) {
        this.commLayerStopping = commLayerStopping;
    }

    public boolean isCommLayerStarting() {
        return this.commLayerStarting;
    }

    public void setCommLayerStarting(boolean commLayerStarting) {
        this.commLayerStarting = commLayerStarting;
    }

    public boolean isPcmkStarting() {
        return this.pcmkStarting;
    }

    public void setPcmkStarting(boolean pcmkStarting) {
        this.pcmkStarting = pcmkStarting;
    }

    public boolean isDrbdProxyStarting() {
        return this.drbdProxyStarting;
    }

    public void setDrbdProxyStarting(boolean drbdProxyStarting) {
        this.drbdProxyStarting = drbdProxyStarting;
    }

    public boolean isPcmkStartedByCorosync() {
        return this.pcmkServiceVersion == 0;
    }

    void setLibvirtVersion(String libvirtVersion) {
        this.libvirtVersion = libvirtVersion;
    }

    String getLibvirtVersion() {
        return this.libvirtVersion;
    }

    public Set<String> getLogicalVolumesFromVolumeGroup(String vg) {
        return this.volumeGroupsLVS.get(vg);
    }

    public Set<String> getAllLogicalVolumes() {
        LinkedHashSet<String> allLVS = new LinkedHashSet<String>();
        for (String vg : this.volumeGroups.keySet()) {
            Set<String> lvs = this.volumeGroupsLVS.get(vg);
            if (lvs == null) continue;
            allLVS.addAll(lvs);
        }
        return allLVS;
    }

    public boolean hasVolumes() {
        try {
            return Tools.compareVersions(this.getDrbdVersion(), "8.4") >= 0;
        }
        catch (Exceptions.IllegalVersionException e) {
            Tools.appWarning(e.getMessage(), e);
            return true;
        }
    }

    public List<BlockDevice> getPhysicalVolumes() {
        return this.physicalVolumes;
    }

    public void setSavable(boolean savable) {
        this.savable = savable;
    }

    public boolean isSavable() {
        return this.savable;
    }

    public BlockDevice getDrbdBlockDevice(String device) {
        return this.drbdBlockDevices.get(device);
    }

    public Collection<BlockDevice> getDrbdBlockDevices() {
        return this.drbdBlockDevices.values();
    }

    public List<BlockDevice> getPhysicalVolumes(String vg) {
        ArrayList<BlockDevice> bds = new ArrayList<BlockDevice>();
        if (vg == null) {
            return bds;
        }
        for (BlockDevice b : this.physicalVolumes) {
            if (!vg.equals(b.getVolumeGroupOnPhysicalVolume())) continue;
            bds.add(b);
        }
        return bds;
    }

    public boolean drbdStatusTryLock() {
        return this.mDRBDStatusLock.tryLock();
    }

    public void drbdStatusLock() {
        this.mDRBDStatusLock.lock();
    }

    public void drbdStatusUnlock() {
        this.mDRBDStatusLock.unlock();
    }

    public void vmStatusLock() {
        this.mUpdateVMSlock.lock();
    }

    public boolean vmStatusTryLock() {
        return this.mUpdateVMSlock.tryLock();
    }

    public void vmStatusUnlock() {
        this.mUpdateVMSlock.unlock();
    }

    public boolean isRoot() {
        return ROOT_USER.equals(this.username);
    }

    public List<String> getGuiOptions(String name) {
        List<String> opts = this.guiOptions.get(name);
        if (opts == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>((Collection)this.guiOptions.get(name));
    }

    public boolean isDrbdProxyUp(String res) {
        return this.drbdResProxy.contains(res);
    }

    public void updateDrbdParameters() {
        ClusterBrowser browser = this.getBrowser().getClusterBrowser();
        DrbdXML drbdXML = browser.getDrbdXML();
        String output = drbdXML.updateDrbdParameters(this);
        drbdXML.parseDrbdParameters(this, output, browser.getClusterHosts());
        browser.getDrbdParameters().put(this, output);
    }
}

