/*
 * Decompiled with CFR 0.152.
 */
package lcmc.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lcmc.data.CRMXML;
import lcmc.data.CibQuery;
import lcmc.data.Host;
import lcmc.data.HostLocation;
import lcmc.data.PtestData;
import lcmc.data.ResourceAgent;
import lcmc.utilities.ConvertCmdCallback;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;
import org.apache.commons.collections15.map.MultiKeyMap;

public final class ClusterStatus {
    private volatile CibQuery cibQueryMap = new CibQuery();
    private volatile CibQuery shadowCibQueryMap = new CibQuery();
    private final CRMXML crmXML;
    private volatile Map<String, CRMXML.ResStatus> resStateMap = null;
    private volatile PtestData ptestData = null;
    private String oldStatus = null;
    private String oldCib = null;
    private boolean oldAdvancedMode = false;
    private final Host host;

    public ClusterStatus(Host host, CRMXML crmXML) {
        this.host = host;
        this.crmXML = crmXML;
        String command = host.getDistCommand("Heartbeat.getClusterMetadata", (ConvertCmdCallback)null);
        SSH.SSHOutput ret = Tools.execCommandProgressIndicator(host, command, null, false, Tools.getString("Heartbeat.getClusterMetadata"), SSH.DEFAULT_COMMAND_TIMEOUT);
        String output = ret.getOutput();
        if (ret.getExitCode() != 0) {
            return;
        }
        if (output != null) {
            crmXML.parseClusterMetaData(output);
        }
    }

    public String getGlobalParam(String param) {
        return this.cibQueryMap.getCrmConfig().get(param);
    }

    String[] getGlobalParameters() {
        HashMap globalConfigMap = new HashMap();
        if (globalConfigMap != null) {
            return globalConfigMap.keySet().toArray(new String[globalConfigMap.size()]);
        }
        return null;
    }

    public String getRscDefaultsParameter(String param, boolean testOnly) {
        if (testOnly && this.ptestData != null) {
            return this.shadowCibQueryMap.getRscDefaultsParams().get(param);
        }
        return this.cibQueryMap.getRscDefaultsParams().get(param);
    }

    public String getRscDefaultsId(boolean testOnly) {
        if (testOnly && this.ptestData != null) {
            return this.shadowCibQueryMap.getRscDefaultsId();
        }
        return this.cibQueryMap.getRscDefaultsId();
    }

    public String getParameter(String hbId, String param, boolean testOnly) {
        Map<String, String> params = testOnly && this.ptestData != null ? this.shadowCibQueryMap.getParameters().get(hbId) : this.cibQueryMap.getParameters().get(hbId);
        if (params != null) {
            return params.get(param);
        }
        return null;
    }

    public Map<String, String> getParametersNvpairsIds(String hbId) {
        return this.cibQueryMap.getParametersNvpairsIds().get(hbId);
    }

    public String getDC() {
        return this.cibQueryMap.getDC();
    }

    public void setDC(String dc) {
        this.cibQueryMap.setDC(dc);
    }

    public Map<String, String> getRscDefaultsValuePairs() {
        return this.cibQueryMap.getRscDefaultsParams();
    }

    public Map<String, String> getOpDefaultsValuePairs() {
        return this.cibQueryMap.getOpDefaultsParams();
    }

    public Map<String, String> getParamValuePairs(String hbId) {
        return this.cibQueryMap.getParameters().get(hbId);
    }

    public Set<String> getAllGroups() {
        Map<String, List<String>> groupsToResources = this.cibQueryMap.getGroupsToResources();
        return groupsToResources.keySet();
    }

    public List<String> getGroupResources(String group, boolean testOnly) {
        if (testOnly && this.ptestData != null) {
            return this.shadowCibQueryMap.getGroupsToResources().get(group);
        }
        return this.cibQueryMap.getGroupsToResources().get(group);
    }

    String[] getAllClones() {
        Map<String, String> cloneToResource = this.cibQueryMap.getCloneToResource();
        return cloneToResource.keySet().toArray(new String[cloneToResource.size()]);
    }

    public boolean isMaster(String pmId) {
        return this.cibQueryMap.getMasterList().contains(pmId);
    }

    String getCloneResource(String clone) {
        return this.cibQueryMap.getCloneToResource().get(clone);
    }

    String[] getAllResources() {
        Map<String, Map<String, String>> parametersMap = this.cibQueryMap.getParameters();
        return parametersMap.keySet().toArray(new String[parametersMap.size()]);
    }

    String getResourceFromClone(String cloneId) {
        return this.cibQueryMap.getCloneToResource().get(cloneId);
    }

    public boolean isClone(String cloneId) {
        return this.cibQueryMap.getCloneToResource().containsKey(cloneId);
    }

    public ResourceAgent getResourceType(String hbId) {
        return this.cibQueryMap.getResourceType().get(hbId);
    }

    public boolean isInLRMOnHost(String hostName, String rscId, boolean testOnly) {
        Set<String> inLRMList = this.cibQueryMap.getInLRM().get(hostName.toLowerCase(Locale.US));
        if (inLRMList == null) {
            return false;
        }
        return inLRMList.contains(rscId);
    }

    public boolean isOrphaned(String rscId) {
        return this.cibQueryMap.getOrphaned().contains(rscId);
    }

    public String getResourceInstanceAttrId(String hbId) {
        return this.cibQueryMap.getResourceInstanceAttrId().get(hbId);
    }

    public CRMXML.ColocationData getColocationData(String colId) {
        return this.cibQueryMap.getColocationId().get(colId);
    }

    public List<CRMXML.ColocationData> getColocationDatas(String rsc) {
        return this.cibQueryMap.getColocationRsc().get(rsc);
    }

    public Map<String, List<CRMXML.ColocationData>> getColocationRscMap() {
        return this.cibQueryMap.getColocationRsc();
    }

    public CRMXML.OrderData getOrderData(String ordId) {
        return this.cibQueryMap.getOrderId().get(ordId);
    }

    public List<CRMXML.OrderData> getOrderDatas(String rsc) {
        return this.cibQueryMap.getOrderRsc().get(rsc);
    }

    public Map<String, List<CRMXML.OrderData>> getOrderRscMap() {
        return this.cibQueryMap.getOrderRsc();
    }

    public List<CRMXML.RscSetConnectionData> getRscSetConnections() {
        return this.cibQueryMap.getRscSetConnections();
    }

    public List<CRMXML.RscSet> getRscSetsOrd(String ordId) {
        return this.cibQueryMap.getOrderIdRscSets().get(ordId);
    }

    public List<CRMXML.RscSet> getRscSetsCol(String colId) {
        return this.cibQueryMap.getColocationIdRscSets().get(colId);
    }

    public List<String> getLocationIds(String rsc, boolean testOnly) {
        List<String> locs = testOnly && this.ptestData != null ? this.shadowCibQueryMap.getLocationsId().get(rsc) : this.cibQueryMap.getLocationsId().get(rsc);
        if (locs == null) {
            return new ArrayList<String>();
        }
        return locs;
    }

    public HostLocation getScore(String hbId, String onHost, boolean testOnly) {
        Map<String, HostLocation> hostToScoreMap = testOnly && this.ptestData != null ? this.shadowCibQueryMap.getLocation().get(hbId) : this.cibQueryMap.getLocation().get(hbId);
        if (hostToScoreMap != null) {
            return hostToScoreMap.get(onHost.toLowerCase(Locale.US));
        }
        return null;
    }

    public HostLocation getPingScore(String hbId, boolean testOnly) {
        HostLocation hostLocation = testOnly && this.ptestData != null ? this.shadowCibQueryMap.getPingLocation().get(hbId) : this.cibQueryMap.getPingLocation().get(hbId);
        return hostLocation;
    }

    HostLocation getHostLocationFromId(String locationId, boolean testOnly) {
        if (testOnly && this.ptestData != null) {
            return this.shadowCibQueryMap.getLocationMap().get(locationId);
        }
        return this.cibQueryMap.getLocationMap().get(locationId);
    }

    public String getLocationId(String rsc, String node, boolean testOnly) {
        if (testOnly && this.ptestData != null) {
            return this.shadowCibQueryMap.getResHostToLocId().get((K[])new String[]{rsc, node.toLowerCase(Locale.US)});
        }
        return this.cibQueryMap.getResHostToLocId().get((K[])new String[]{rsc, node.toLowerCase(Locale.US)});
    }

    public String getPingLocationId(String rsc, boolean testOnly) {
        if (testOnly && this.ptestData != null) {
            return this.shadowCibQueryMap.getResPingToLocId().get(rsc);
        }
        return this.cibQueryMap.getResPingToLocId().get(rsc);
    }

    public String getMetaAttrsId(String hbId) {
        return this.cibQueryMap.getMetaAttrsId().get(hbId);
    }

    public String getOperation(String hbId, String op, String param) {
        return this.cibQueryMap.getOperations().get((K[])new String[]{hbId, op, param});
    }

    public String getOperationsId(String hbId) {
        return this.cibQueryMap.getOperationsId().get(hbId);
    }

    public String getOpId(String hbId, String op) {
        Map<String, String> opIds = this.cibQueryMap.getResOpIds().get(hbId);
        if (opIds == null) {
            return null;
        }
        return opIds.get(op);
    }

    public String getMetaAttrsRef(String hbId) {
        return this.cibQueryMap.getMetaAttrsRefs().get(hbId);
    }

    public String getOperationsRef(String hbId) {
        return this.cibQueryMap.getOperationsRefs().get(hbId);
    }

    public boolean isManaged(String hbId, boolean testOnly) {
        PtestData pd = this.ptestData;
        if (testOnly && pd != null) {
            return pd.isManaged(hbId);
        }
        if (this.resStateMap == null) {
            return true;
        }
        CRMXML.ResStatus resStatus = this.resStateMap.get(hbId);
        if (resStatus == null) {
            return true;
        }
        return resStatus.isManaged();
    }

    public List<String> getRunningOnNodes(String hbId, boolean testOnly) {
        List<String> ron;
        PtestData pd = this.ptestData;
        if (testOnly && pd != null && (ron = pd.getRunningOnNodes(hbId)) != null) {
            Collections.sort(ron);
            return ron;
        }
        if (this.resStateMap == null) {
            return null;
        }
        CRMXML.ResStatus resStatus = this.resStateMap.get(hbId);
        if (resStatus == null) {
            return null;
        }
        return resStatus.getRunningOnNodes();
    }

    public List<String> getSlaveOnNodes(String hbId, boolean testOnly) {
        List<String> son;
        PtestData pd = this.ptestData;
        if (testOnly && pd != null && (son = pd.getSlaveOnNodes(hbId)) != null) {
            Collections.sort(son);
            return son;
        }
        if (this.resStateMap == null) {
            return null;
        }
        CRMXML.ResStatus resStatus = this.resStateMap.get(hbId);
        if (resStatus == null) {
            return null;
        }
        return resStatus.getSlaveOnNodes();
    }

    public List<String> getMasterOnNodes(String hbId, boolean testOnly) {
        List<String> mon;
        PtestData pd = this.ptestData;
        if (testOnly && pd != null && (mon = pd.getMasterOnNodes(hbId)) != null) {
            Collections.sort(mon);
            return mon;
        }
        if (this.resStateMap == null) {
            return null;
        }
        CRMXML.ResStatus resStatus = this.resStateMap.get(hbId);
        if (resStatus == null) {
            return null;
        }
        return resStatus.getMasterOnNodes();
    }

    public Map<String, String> getAllocationScores(String crmId, boolean testOnly) {
        if (this.resStateMap == null) {
            return Collections.emptyMap();
        }
        CRMXML.ResStatus resStatus = this.resStateMap.get(crmId);
        if (resStatus == null) {
            return Collections.emptyMap();
        }
        return resStatus.getAllocationScores();
    }

    public String isOnlineNode(String node) {
        return this.cibQueryMap.getNodeOnline().get(node.toLowerCase(Locale.US));
    }

    public void setOnlineNode(String node, String online) {
        this.cibQueryMap.getNodeOnline().put(node.toLowerCase(Locale.US), online);
    }

    public boolean isPendingNode(String node) {
        return this.cibQueryMap.getNodePending().contains(node.toLowerCase(Locale.US));
    }

    public boolean isFencedNode(String node) {
        return this.cibQueryMap.getFencedNodes().contains(node.toLowerCase(Locale.US));
    }

    public String getFailCount(String node, String res, boolean testOnly) {
        return this.cibQueryMap.getFailCount(node.toLowerCase(Locale.US), res);
    }

    public String getPingCount(String node, boolean testOnly) {
        if (testOnly && this.ptestData != null) {
            return this.shadowCibQueryMap.getPingCount(node.toLowerCase(Locale.US));
        }
        return this.cibQueryMap.getPingCount(node.toLowerCase(Locale.US));
    }

    public Set<String> getFailedClones(String node, String res, boolean testOnly) {
        return this.cibQueryMap.getFailedClones().get((K[])new String[]{node.toLowerCase(Locale.US), res});
    }

    public String getNodeParameter(String node, String param, boolean testOnly) {
        MultiKeyMap<String, String> nodeParams = testOnly && this.ptestData != null ? this.shadowCibQueryMap.getNodeParameters() : this.cibQueryMap.getNodeParameters();
        if (nodeParams == null) {
            return null;
        }
        return nodeParams.get((K[])new String[]{node.toLowerCase(Locale.US), param});
    }

    private boolean parseCommand(String command, List<String> data) {
        String[] commands = command.split("<<<>>>");
        String cmd = commands[0];
        if (commands.length == 1) {
            if (!"fenced_nodes".equals(cmd)) {
                if ("res_status".equals(cmd)) {
                    String status = Tools.join("\n", data.toArray(new String[data.size()]));
                    if (!status.equals(this.oldStatus)) {
                        Tools.debug(this, "status update: " + this.host.getName(), 1);
                        this.oldStatus = status;
                        this.parseResStatus(status);
                        return true;
                    }
                } else if ("cibadmin".equals(cmd)) {
                    String cib = Tools.join("\n", data.toArray(new String[data.size()]));
                    boolean advancedMode = Tools.getConfigData().isAdvancedMode();
                    if (!cib.equals(this.oldCib) || this.oldAdvancedMode != advancedMode) {
                        Tools.debug(this, "cib update: " + this.host.getName(), 1);
                        this.oldCib = cib;
                        this.oldAdvancedMode = advancedMode;
                        this.parseCibQuery(cib);
                        return true;
                    }
                }
            }
        } else {
            Tools.appError("unknown command: " + command);
        }
        return false;
    }

    public boolean parseStatus(String status) {
        String[] lines = status.split("\n");
        String command = null;
        ArrayList<String> data = null;
        boolean failed = false;
        boolean updated = false;
        for (String line : lines) {
            if ("---start---".equals(line = line.trim()) || "init".equals(line) || "evt:cib_changed".equals(line)) continue;
            if ("---done---".equals(line)) break;
            if (command == null) {
                command = line;
                data = null;
                continue;
            }
            if (line.equals(">>>" + command)) {
                if (!failed && this.parseCommand(command, data)) {
                    updated = true;
                }
                command = null;
                continue;
            }
            if ("ok".equals(line)) {
                data = new ArrayList<String>();
                failed = false;
                continue;
            }
            if ("fail".equals(line) || "None".equals(line)) {
                failed = true;
                data = new ArrayList();
                continue;
            }
            if (data != null) {
                if (failed) continue;
                data.add(line);
                continue;
            }
            Tools.appWarning("Error parsing heartbeat status, line not ok: " + line + "\n" + status);
        }
        return updated;
    }

    private void parseResStatus(String resStatus) {
        this.resStateMap = this.crmXML.parseResStatus(resStatus);
    }

    private void parseCibQuery(String query) {
        this.cibQueryMap = this.crmXML.parseCibQuery(query);
    }

    public void setPtestData(PtestData ptestData) {
        this.ptestData = ptestData;
        this.shadowCibQueryMap = ptestData == null ? new CibQuery() : this.crmXML.parseCibQuery("<pcmk>" + ptestData.getShadowCib() + "</pcmk>");
    }
}

