/*
 * Decompiled with CFR 0.152.
 */
package lcmc.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lcmc.Exceptions;
import lcmc.data.CibQuery;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.HostLocation;
import lcmc.data.ResourceAgent;
import lcmc.data.XML;
import lcmc.gui.resources.Info;
import lcmc.gui.resources.ServiceInfo;
import lcmc.gui.resources.ServicesInfo;
import lcmc.utilities.ConvertCmdCallback;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;
import org.apache.commons.collections15.map.MultiKeyMap;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CRMXML
extends XML {
    private final Host host;
    private final List<String> globalParams = new ArrayList<String>();
    private final List<String> globalNotAdvancedParams = new ArrayList<String>();
    private final Map<String, ConfigData.AccessType> paramGlobalAccessTypes = new HashMap<String, ConfigData.AccessType>();
    private final List<String> globalRequiredParams = new ArrayList<String>();
    private final Map<String, List<ResourceAgent>> classToServicesMap = new HashMap<String, List<ResourceAgent>>();
    private final Map<String, String> paramGlobalShortDescMap = new HashMap<String, String>();
    private final Map<String, String> paramGlobalLongDescMap = new HashMap<String, String>();
    private final Map<String, String> paramGlobalDefaultMap = new HashMap<String, String>();
    private final Map<String, String> paramGlobalPreferredMap = new HashMap<String, String>();
    private final Map<String, String> paramGlobalTypeMap = new HashMap<String, String>();
    private final Map<String, String[]> paramGlobalPossibleChoices = new HashMap<String, String[]>();
    private final List<String> colParams = new ArrayList<String>();
    private final List<String> rscSetColParams = new ArrayList<String>();
    private final List<String> rscSetColConnectionParams = new ArrayList<String>();
    private final List<String> colRequiredParams = new ArrayList<String>();
    private final Map<String, String> paramColShortDescMap = new HashMap<String, String>();
    private final Map<String, String> paramColLongDescMap = new HashMap<String, String>();
    private final Map<String, String> paramColDefaultMap = new HashMap<String, String>();
    private final Map<String, String> paramColPreferredMap = new HashMap<String, String>();
    private final Map<String, String> paramColTypeMap = new HashMap<String, String>();
    private final Map<String, String[]> paramColPossibleChoices = new HashMap<String, String[]>();
    private final Map<String, String[]> paramColPossibleChoicesMS = new HashMap<String, String[]>();
    private final List<String> ordParams = new ArrayList<String>();
    private final List<String> rscSetOrdParams = new ArrayList<String>();
    private final List<String> rscSetOrdConnectionParams = new ArrayList<String>();
    private final List<String> ordRequiredParams = new ArrayList<String>();
    private final Map<String, String> paramOrdShortDescMap = new HashMap<String, String>();
    private final Map<String, String> paramOrdLongDescMap = new HashMap<String, String>();
    private final Map<String, String> paramOrdDefaultMap = new HashMap<String, String>();
    private final Map<String, String> paramOrdPreferredMap = new HashMap<String, String>();
    private final Map<String, String> paramOrdTypeMap = new HashMap<String, String>();
    private final Map<String, String[]> paramOrdPossibleChoices = new HashMap<String, String[]>();
    private final Map<String, String[]> paramOrdPossibleChoicesMS = new HashMap<String, String[]>();
    private final ResourceAgent hbGroup = new ResourceAgent("Group", "", "group");
    private final ResourceAgent pcmkClone;
    private final ResourceAgent hbDrbddisk = new ResourceAgent("drbddisk", "heartbeat", "heartbeat");
    private final ResourceAgent hbLinbitDrbd = new ResourceAgent("drbd", "linbit", "ocf");
    private final MultiKeyMap<String, ResourceAgent> serviceToResourceAgentMap = new MultiKeyMap();
    private boolean drbddiskPresent;
    private boolean linbitDrbdPresent;
    private final List<String> hostlistChoices = new ArrayList<String>();
    private static final MultiKeyMap<String, String> RA_PARAM_SECTION = new MultiKeyMap();
    static final String PCMK_TRUE = "true";
    static final String PCMK_FALSE = "false";
    public static final String DISABLED_STRING = "disabled";
    private static final String PARAM_TYPE_BOOLEAN = "boolean";
    private static final String PARAM_TYPE_INTEGER = "integer";
    private static final String PARAM_TYPE_LABEL = "label";
    private static final String PARAM_TYPE_STRING = "string";
    private static final String PARAM_TYPE_TIME = "time";
    private static final String FAIL_COUNT_PREFIX = "fail-count-";
    private static final String[] ATTRIBUTE_ROLES = new String[]{null, "Stopped", "Started"};
    private static final String[] ATTRIBUTE_ROLES_MS = new String[]{null, "Stopped", "Started", "Master", "Slave"};
    private static final String[] ATTRIBUTE_ACTIONS = new String[]{null, "start", "stop"};
    private static final String[] ATTRIBUTE_ACTIONS_MS = new String[]{null, "start", "promote", "demote", "stop"};
    public static final String TARGET_ROLE_STOPPED = "stopped";
    private static final String TARGET_ROLE_STARTED = "started";
    private static final String TARGET_ROLE_MASTER = "master";
    public static final String TARGET_ROLE_SLAVE = "slave";
    public static final String INFINITY_STRING = "INFINITY";
    public static final String PLUS_INFINITY_STRING = "+INFINITY";
    public static final String MINUS_INFINITY_STRING = "-INFINITY";
    private static final String[] INTEGER_VALUES = new String[]{null, "0", "2", "100", "INFINITY", "-INFINITY", "+INFINITY"};
    private static final String STONITH_TIMEOUT_INSTANCE_ATTR = "stonith-timeout";
    public static final String STONITH_PRIORITY_INSTANCE_ATTR = "stonith-priority";
    public static final String SCORE_STRING = "score";
    private Map<String, String> metaAttrParams = null;
    private Map<String, String> rscDefaultsMetaAttrs = null;
    private static final String PRIORITY_META_ATTR = "priority";
    private static final String RESOURCE_STICKINESS_META_ATTR = "resource-stickiness";
    private static final String MIGRATION_THRESHOLD_META_ATTR = "migration-threshold";
    private static final String FAILURE_TIMEOUT_META_ATTR = "failure-timeout";
    private static final String MULTIPLE_ACTIVE_META_ATTR = "multiple-active";
    private static final String TARGET_ROLE_META_ATTR = "target-role";
    private static final String IS_MANAGED_META_ATTR = "is-managed";
    private static final String ALLOW_MIGRATE_META_ATTR = "allow-migrate";
    private static final String MASTER_MAX_META_ATTR = "master-max";
    private static final String MASTER_NODE_MAX_META_ATTR = "master-node-max";
    private static final String CLONE_MAX_META_ATTR = "clone-max";
    private static final String CLONE_NODE_MAX_META_ATTR = "clone-node-max";
    private static final String NOTIFY_META_ATTR = "notify";
    private static final String GLOBALLY_UNIQUE_META_ATTR = "globally-unique";
    private static final String ORDERED_META_ATTR = "ordered";
    private static final String INTERLEAVE_META_ATTR = "interleave";
    public static final String GROUP_ORDERED_META_ATTR = "group-ordered";
    private static final String GROUP_COLLOCATED_META_ATTR = "collocated";
    public static final String REQUIRE_ALL_TRUE = "true";
    public static final String REQUIRE_ALL_FALSE = "false";
    public static final String REQUIRE_ALL_ATTR = "require-all";
    private static final Map<String, String> M_A_SECTION = new HashMap<String, String>();
    private static final List<String> M_A_NOT_ADVANCED = new ArrayList<String>();
    private static final List<String> GROUP_M_A_NOT_ADVANCED = new ArrayList<String>();
    private static final Map<String, ConfigData.AccessType> M_A_ACCESS_TYPE = new HashMap<String, ConfigData.AccessType>();
    private static final Map<String, ConfigData.AccessType> M_A_RSC_DEFAULTS_ACCESS_TYPE = new HashMap<String, ConfigData.AccessType>();
    private static final Map<String, String[]> M_A_POSSIBLE_CHOICES = new HashMap<String, String[]>();
    private static final Map<String, String[]> M_A_POSSIBLE_CHOICES_MS = new HashMap<String, String[]>();
    private static final Map<String, String> M_A_SHORT_DESC = new HashMap<String, String>();
    private static final Map<String, String> M_A_LONG_DESC = new HashMap<String, String>();
    private static final Map<String, String> M_A_DEFAULT = new HashMap<String, String>();
    private static final Map<String, String> M_A_TYPE = new HashMap<String, String>();
    private static final Map<String, String> M_A_PREFERRED = new HashMap<String, String>();
    private static final String[] PCMK_BOOLEAN_VALUES = new String[]{"true", "false"};
    private static final List<String> IGNORE_DEFAULTS_FOR = new ArrayList<String>();
    private static final String PCMK_HOST_CHECK_PARAM = "pcmk_host_check";
    private static final String PCMK_HOST_LIST_PARAM = "pcmk_host_list";
    private static final String PCMK_HOST_MAP_PARAM = "pcmk_host_map";
    private static final String FENCING_ACTION_PARAM = "action";
    private static final String PCMK_HOST_CHECK_STATIC = "static-list";
    private static final String PCMK_HOST_CHECK_DYNAMIC = "dynamic-list";
    public static final String PAR_CHECK_LEVEL = "OCF_CHECK_LEVEL";

    public CRMXML(final Host host, final ServicesInfo ssi) {
        this.host = host;
        String[] booleanValues = PCMK_BOOLEAN_VALUES;
        String hbBooleanTrue = booleanValues[0];
        String hbBooleanFalse = booleanValues[1];
        this.hostlistChoices.add("");
        String[] hosts = host.getCluster().getHostNames();
        if (hosts != null && hosts.length < 8) {
            this.hostlistChoices.add(Tools.join(" ", hosts));
            for (String h : hosts) {
                this.hostlistChoices.add(h);
            }
        }
        this.pcmkClone = new ResourceAgent("Clone Set", "", "clone");
        this.pcmkClone.setMetaDataLoaded(true);
        this.addMetaAttribute(this.pcmkClone, MASTER_MAX_META_ATTR, null, true);
        this.addMetaAttribute(this.pcmkClone, MASTER_NODE_MAX_META_ATTR, null, true);
        this.addMetaAttribute(this.pcmkClone, CLONE_MAX_META_ATTR, null, false);
        this.addMetaAttribute(this.pcmkClone, CLONE_NODE_MAX_META_ATTR, null, false);
        this.addMetaAttribute(this.pcmkClone, NOTIFY_META_ATTR, null, false);
        this.addMetaAttribute(this.pcmkClone, GLOBALLY_UNIQUE_META_ATTR, null, false);
        this.addMetaAttribute(this.pcmkClone, ORDERED_META_ATTR, null, false);
        this.addMetaAttribute(this.pcmkClone, INTERLEAVE_META_ATTR, null, false);
        this.addMetaAttribute(this.hbGroup, GROUP_ORDERED_META_ATTR, null, false);
        this.addMetaAttribute(this.hbGroup, GROUP_COLLOCATED_META_ATTR, null, false);
        Map<String, String> metaAttrParams = this.getMetaAttrParameters();
        for (String metaAttr : metaAttrParams.keySet()) {
            this.addMetaAttribute(this.pcmkClone, metaAttr, metaAttrParams.get(metaAttr), false);
            this.addMetaAttribute(this.hbGroup, metaAttr, metaAttrParams.get(metaAttr), false);
        }
        this.globalParams.add("symmetric-cluster");
        this.paramGlobalShortDescMap.put("symmetric-cluster", "Symmetric Cluster");
        this.paramGlobalLongDescMap.put("symmetric-cluster", "Symmetric Cluster");
        this.paramGlobalTypeMap.put("symmetric-cluster", PARAM_TYPE_BOOLEAN);
        this.paramGlobalDefaultMap.put("symmetric-cluster", hbBooleanFalse);
        this.paramGlobalPossibleChoices.put("symmetric-cluster", booleanValues);
        this.globalRequiredParams.add("symmetric-cluster");
        this.globalNotAdvancedParams.add("symmetric-cluster");
        this.globalParams.add("stonith-enabled");
        this.paramGlobalShortDescMap.put("stonith-enabled", "Stonith Enabled");
        this.paramGlobalLongDescMap.put("stonith-enabled", "Stonith Enabled");
        this.paramGlobalTypeMap.put("stonith-enabled", PARAM_TYPE_BOOLEAN);
        this.paramGlobalDefaultMap.put("stonith-enabled", hbBooleanTrue);
        this.paramGlobalPossibleChoices.put("stonith-enabled", booleanValues);
        this.globalRequiredParams.add("stonith-enabled");
        this.globalNotAdvancedParams.add("stonith-enabled");
        this.globalParams.add("default-action-timeout");
        this.paramGlobalShortDescMap.put("default-action-timeout", "Transition Timeout");
        this.paramGlobalLongDescMap.put("default-action-timeout", "Transition Timeout");
        this.paramGlobalTypeMap.put("default-action-timeout", PARAM_TYPE_INTEGER);
        this.paramGlobalDefaultMap.put("default-action-timeout", "20");
        this.paramGlobalPossibleChoices.put("default-action-timeout", INTEGER_VALUES);
        this.globalRequiredParams.add("default-action-timeout");
        this.globalParams.add("default-resource-stickiness");
        this.paramGlobalShortDescMap.put("default-resource-stickiness", "Resource Stickiness");
        this.paramGlobalLongDescMap.put("default-resource-stickiness", "Resource Stickiness");
        this.paramGlobalTypeMap.put("default-resource-stickiness", PARAM_TYPE_INTEGER);
        this.paramGlobalPossibleChoices.put("default-resource-stickiness", INTEGER_VALUES);
        this.paramGlobalDefaultMap.put("default-resource-stickiness", "0");
        this.globalRequiredParams.add("default-resource-stickiness");
        this.globalParams.add("no-quorum-policy");
        this.paramGlobalShortDescMap.put("no-quorum-policy", "No Quorum Policy");
        this.paramGlobalLongDescMap.put("no-quorum-policy", "No Quorum Policy");
        this.paramGlobalTypeMap.put("no-quorum-policy", PARAM_TYPE_STRING);
        this.paramGlobalDefaultMap.put("no-quorum-policy", "stop");
        this.paramGlobalPossibleChoices.put("no-quorum-policy", new String[]{"ignore", "stop", "freeze", "suicide"});
        this.globalRequiredParams.add("no-quorum-policy");
        this.globalNotAdvancedParams.add("no-quorum-policy");
        this.globalParams.add("default-resource-failure-stickiness");
        this.paramGlobalShortDescMap.put("default-resource-failure-stickiness", "Resource Failure Stickiness");
        this.paramGlobalLongDescMap.put("default-resource-failure-stickiness", "Resource Failure Stickiness");
        this.paramGlobalTypeMap.put("default-resource-failure-stickiness", PARAM_TYPE_INTEGER);
        this.paramGlobalPossibleChoices.put("default-resource-failure-stickiness", INTEGER_VALUES);
        this.paramGlobalDefaultMap.put("default-resource-failure-stickiness", "0");
        this.globalRequiredParams.add("default-resource-failure-stickiness");
        this.paramGlobalPossibleChoices.put("placement-strategy", new String[]{"default", "utilization", "minimal", "balanced"});
        String hbV = host.getHeartbeatVersion();
        String pcmkV = host.getPacemakerVersion();
        try {
            if (pcmkV != null || Tools.compareVersions(hbV, "2.1.3") >= 0) {
                String clusterRecheckInterval = "cluster-recheck-interval";
                String dcDeadtime = "dc-deadtime";
                String electionTimeout = "election-timeout";
                String shutdownEscalation = "shutdown-escalation";
                if (Tools.versionBeforePacemaker(host)) {
                    clusterRecheckInterval = "cluster_recheck_interval";
                    dcDeadtime = "dc_deadtime";
                    electionTimeout = "election_timeout";
                    shutdownEscalation = "shutdown_escalation";
                }
                String[] params = new String[]{"stonith-action", "is-managed-default", "cluster-delay", "batch-limit", "stop-orphan-resources", "stop-orphan-actions", "remove-after-stop", "pe-error-series-max", "pe-warn-series-max", "pe-input-series-max", "startup-fencing", "start-failure-is-fatal", dcDeadtime, clusterRecheckInterval, electionTimeout, shutdownEscalation, "crmd-integration-timeout", "crmd-finalization-timeout", "expected-quorum-votes", "maintenance-mode"};
                this.globalParams.add("dc-version");
                this.paramGlobalShortDescMap.put("dc-version", "DC Version");
                this.paramGlobalTypeMap.put("dc-version", PARAM_TYPE_LABEL);
                this.paramGlobalAccessTypes.put("dc-version", ConfigData.AccessType.NEVER);
                this.globalParams.add("cluster-infrastructure");
                this.paramGlobalShortDescMap.put("cluster-infrastructure", "Cluster Infrastructure");
                this.paramGlobalTypeMap.put("cluster-infrastructure", PARAM_TYPE_LABEL);
                this.paramGlobalAccessTypes.put("cluster-infrastructure", ConfigData.AccessType.NEVER);
                this.globalNotAdvancedParams.add("no-quorum-policy");
                this.globalNotAdvancedParams.add("maintenance-mode");
                this.paramGlobalAccessTypes.put("maintenance-mode", ConfigData.AccessType.OP);
                this.globalNotAdvancedParams.add(clusterRecheckInterval);
                for (String param : params) {
                    this.globalParams.add(param);
                    String[] parts = param.split("[-_]");
                    for (int i = 0; i < parts.length; ++i) {
                        if ("dc".equals(parts[i])) {
                            parts[i] = "DC";
                        }
                        parts[i] = "crmd".equals(parts[i]) ? "CRMD" : Tools.ucfirst(parts[i]);
                    }
                    String name = Tools.join(" ", parts);
                    this.paramGlobalShortDescMap.put(param, name);
                    this.paramGlobalLongDescMap.put(param, name);
                    this.paramGlobalTypeMap.put(param, PARAM_TYPE_STRING);
                    this.paramGlobalDefaultMap.put(param, "");
                }
                this.paramGlobalDefaultMap.put("stonith-action", "reboot");
                this.paramGlobalPossibleChoices.put("stonith-action", new String[]{"reboot", "poweroff"});
                this.paramGlobalTypeMap.put("is-managed-default", PARAM_TYPE_BOOLEAN);
                this.paramGlobalDefaultMap.put("is-managed-default", hbBooleanFalse);
                this.paramGlobalPossibleChoices.put("is-managed-default", booleanValues);
                this.paramGlobalTypeMap.put("stop-orphan-resources", PARAM_TYPE_BOOLEAN);
                this.paramGlobalDefaultMap.put("stop-orphan-resources", hbBooleanFalse);
                this.paramGlobalPossibleChoices.put("stop-orphan-resources", booleanValues);
                this.paramGlobalTypeMap.put("stop-orphan-actions", PARAM_TYPE_BOOLEAN);
                this.paramGlobalDefaultMap.put("stop-orphan-actions", hbBooleanFalse);
                this.paramGlobalPossibleChoices.put("stop-orphan-actions", booleanValues);
                this.paramGlobalTypeMap.put("remove-after-stop", PARAM_TYPE_BOOLEAN);
                this.paramGlobalDefaultMap.put("remove-after-stop", hbBooleanFalse);
                this.paramGlobalPossibleChoices.put("remove-after-stop", booleanValues);
                this.paramGlobalTypeMap.put("startup-fencing", PARAM_TYPE_BOOLEAN);
                this.paramGlobalDefaultMap.put("startup-fencing", hbBooleanFalse);
                this.paramGlobalPossibleChoices.put("startup-fencing", booleanValues);
                this.paramGlobalTypeMap.put("start-failure-is-fatal", PARAM_TYPE_BOOLEAN);
                this.paramGlobalDefaultMap.put("start-failure-is-fatal", hbBooleanFalse);
                this.paramGlobalPossibleChoices.put("start-failure-is-fatal", booleanValues);
            }
        }
        catch (Exceptions.IllegalVersionException e) {
            Tools.appWarning(e.getMessage(), e);
        }
        this.colParams.add("rsc-role");
        this.paramColShortDescMap.put("rsc-role", "rsc col role");
        this.paramColLongDescMap.put("rsc-role", "@RSC@ colocation role");
        this.paramColTypeMap.put("rsc-role", PARAM_TYPE_STRING);
        this.paramColPossibleChoices.put("rsc-role", ATTRIBUTE_ROLES);
        this.paramColPossibleChoicesMS.put("rsc-role", ATTRIBUTE_ROLES_MS);
        this.colParams.add("with-rsc-role");
        this.paramColShortDescMap.put("with-rsc-role", "with-rsc col role");
        this.paramColLongDescMap.put("with-rsc-role", "@WITH-RSC@ colocation role");
        this.paramColTypeMap.put("with-rsc-role", PARAM_TYPE_STRING);
        this.paramColPossibleChoices.put("with-rsc-role", ATTRIBUTE_ROLES);
        this.paramColPossibleChoicesMS.put("with-rsc-role", ATTRIBUTE_ROLES_MS);
        this.colParams.add(SCORE_STRING);
        this.paramColShortDescMap.put(SCORE_STRING, "Score");
        this.paramColLongDescMap.put(SCORE_STRING, "Score");
        this.paramColTypeMap.put(SCORE_STRING, PARAM_TYPE_INTEGER);
        this.paramColDefaultMap.put(SCORE_STRING, null);
        this.paramColPreferredMap.put(SCORE_STRING, INFINITY_STRING);
        this.paramColPossibleChoices.put(SCORE_STRING, INTEGER_VALUES);
        this.ordParams.add("first-action");
        this.paramOrdShortDescMap.put("first-action", "first order action");
        this.paramOrdLongDescMap.put("first-action", "@FIRST-RSC@ order action");
        this.paramOrdTypeMap.put("first-action", PARAM_TYPE_STRING);
        this.paramOrdPossibleChoices.put("first-action", ATTRIBUTE_ACTIONS);
        this.paramOrdPossibleChoicesMS.put("first-action", ATTRIBUTE_ACTIONS_MS);
        this.paramOrdPreferredMap.put(SCORE_STRING, INFINITY_STRING);
        this.paramOrdDefaultMap.put("first-action", null);
        this.ordParams.add("then-action");
        this.paramOrdShortDescMap.put("then-action", "then order action");
        this.paramOrdLongDescMap.put("then-action", "@THEN-RSC@ order action");
        this.paramOrdTypeMap.put("then-action", PARAM_TYPE_STRING);
        this.paramOrdPossibleChoices.put("then-action", ATTRIBUTE_ACTIONS);
        this.paramOrdPossibleChoicesMS.put("then-action", ATTRIBUTE_ACTIONS_MS);
        this.paramOrdDefaultMap.put("then-action", null);
        this.ordParams.add("symmetrical");
        this.paramOrdShortDescMap.put("symmetrical", "Symmetrical");
        this.paramOrdLongDescMap.put("symmetrical", "Symmetrical");
        this.paramOrdTypeMap.put("symmetrical", PARAM_TYPE_BOOLEAN);
        this.paramOrdDefaultMap.put("symmetrical", hbBooleanTrue);
        this.paramOrdPossibleChoices.put("symmetrical", booleanValues);
        this.ordParams.add(SCORE_STRING);
        this.paramOrdShortDescMap.put(SCORE_STRING, "Score");
        this.paramOrdLongDescMap.put(SCORE_STRING, "Score");
        this.paramOrdTypeMap.put(SCORE_STRING, PARAM_TYPE_INTEGER);
        this.paramOrdPossibleChoices.put(SCORE_STRING, INTEGER_VALUES);
        this.paramOrdDefaultMap.put(SCORE_STRING, null);
        this.rscSetOrdParams.add(SCORE_STRING);
        this.rscSetColParams.add(SCORE_STRING);
        this.rscSetOrdConnectionParams.add(FENCING_ACTION_PARAM);
        this.paramOrdShortDescMap.put(FENCING_ACTION_PARAM, "order action");
        this.paramOrdLongDescMap.put(FENCING_ACTION_PARAM, "order action");
        this.paramOrdTypeMap.put(FENCING_ACTION_PARAM, PARAM_TYPE_STRING);
        this.paramOrdPossibleChoices.put(FENCING_ACTION_PARAM, ATTRIBUTE_ACTIONS);
        this.paramOrdPossibleChoicesMS.put(FENCING_ACTION_PARAM, ATTRIBUTE_ACTIONS_MS);
        this.paramOrdDefaultMap.put(FENCING_ACTION_PARAM, null);
        this.rscSetOrdConnectionParams.add("sequential");
        this.paramOrdShortDescMap.put("sequential", "sequential");
        this.paramOrdLongDescMap.put("sequential", "sequential");
        this.paramOrdTypeMap.put("sequential", PARAM_TYPE_BOOLEAN);
        this.paramOrdDefaultMap.put("sequential", hbBooleanTrue);
        this.paramOrdPossibleChoices.put("sequential", booleanValues);
        this.paramOrdPreferredMap.put("sequential", hbBooleanFalse);
        this.rscSetOrdConnectionParams.add(REQUIRE_ALL_ATTR);
        this.paramOrdShortDescMap.put(REQUIRE_ALL_ATTR, "require all");
        this.paramOrdLongDescMap.put(REQUIRE_ALL_ATTR, "require all");
        this.paramOrdTypeMap.put(REQUIRE_ALL_ATTR, PARAM_TYPE_BOOLEAN);
        this.paramOrdDefaultMap.put(REQUIRE_ALL_ATTR, "true");
        this.paramOrdPossibleChoices.put(REQUIRE_ALL_ATTR, booleanValues);
        this.rscSetColConnectionParams.add("role");
        this.paramColShortDescMap.put("role", "col role");
        this.paramColLongDescMap.put("role", "colocation role");
        this.paramColTypeMap.put("role", PARAM_TYPE_STRING);
        this.paramColPossibleChoices.put("role", ATTRIBUTE_ROLES);
        this.paramColPossibleChoicesMS.put("role", ATTRIBUTE_ROLES_MS);
        this.rscSetColConnectionParams.add("sequential");
        this.paramColShortDescMap.put("sequential", "sequential");
        this.paramColLongDescMap.put("sequential", "sequential");
        this.paramColTypeMap.put("sequential", PARAM_TYPE_BOOLEAN);
        this.paramColDefaultMap.put("sequential", hbBooleanTrue);
        this.paramColPossibleChoices.put("sequential", booleanValues);
        this.paramColPreferredMap.put("sequential", hbBooleanFalse);
        this.hbGroup.setMetaDataLoaded(true);
        this.initOCFMetaDataQuick();
        this.initOCFMetaDataConfigured();
        Tools.debug(this, "cluster loaded", 0);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                CRMXML.this.initOCFMetaDataAll();
                String hn = host.getName();
                String text = Tools.getString("CRMXML.GetRAMetaData.Done");
                Tools.startProgressIndicator(hn, text);
                ssi.setAllResources(ssi.getBrowser().getClusterStatus(), false);
                Info li = ssi.getBrowser().getClusterViewPanel().getLastSelectedInfo();
                if (li instanceof ServiceInfo) {
                    ssi.getBrowser().getClusterViewPanel().reloadRightComponent();
                }
                Tools.stopProgressIndicator(hn, text);
                Tools.debug(this, "RAs loaded", 0);
            }
        });
        t.start();
    }

    private void initOCFMetaDataQuick() {
        String command = this.host.getDistCommand("Heartbeat.getOCFParametersQuick", (ConvertCmdCallback)null);
        SSH.SSHOutput ret = Tools.execCommandProgressIndicator(this.host, command, null, false, Tools.getString("CRMXML.GetRAMetaData"), 60000);
        boolean linbitDrbdPresent0 = false;
        boolean drbddiskPresent0 = false;
        if (ret.getExitCode() != 0) {
            this.drbddiskPresent = drbddiskPresent0;
            this.linbitDrbdPresent = linbitDrbdPresent0;
            return;
        }
        String output = ret.getOutput();
        if (output == null) {
            this.drbddiskPresent = drbddiskPresent0;
            this.linbitDrbdPresent = linbitDrbdPresent0;
            return;
        }
        String[] lines = output.split("\\r?\\n");
        Pattern mp = Pattern.compile("^master:\\s*(.*?)\\s*$");
        Pattern cp = Pattern.compile("^class:\\s*(.*?)\\s*$");
        Pattern pp = Pattern.compile("^provider:\\s*(.*?)\\s*$");
        Pattern sp = Pattern.compile("^ra:\\s*(.*?)\\s*$");
        StringBuilder xml = new StringBuilder("");
        String resourceClass = null;
        String provider = null;
        String serviceName = null;
        boolean masterSlave = false;
        for (int i = 0; i < lines.length; ++i) {
            ResourceAgent ra;
            Matcher cm = cp.matcher(lines[i]);
            if (cm.matches()) {
                resourceClass = cm.group(1);
                continue;
            }
            Matcher pm = pp.matcher(lines[i]);
            if (pm.matches()) {
                provider = pm.group(1);
                continue;
            }
            Matcher sm = sp.matcher(lines[i]);
            if (sm.matches()) {
                serviceName = sm.group(1);
            }
            if (serviceName == null) continue;
            xml.append(lines[i]);
            xml.append('\n');
            if ("drbddisk".equals(serviceName)) {
                drbddiskPresent0 = true;
            } else if ("drbd".equals(serviceName) && "linbit".equals(provider)) {
                linbitDrbdPresent0 = true;
            }
            if ("drbddisk".equals(serviceName) && "heartbeat".equals(resourceClass)) {
                ra = this.hbDrbddisk;
                ra.setMetaDataLoaded(true);
                this.setLSBResourceAgent(serviceName, resourceClass, ra);
            } else if ("drbd".equals(serviceName) && "ocf".equals(resourceClass) && "linbit".equals(provider)) {
                ra = this.hbLinbitDrbd;
            } else {
                ra = new ResourceAgent(serviceName, provider, resourceClass);
                if (IGNORE_DEFAULTS_FOR.contains(serviceName)) {
                    ra.setIgnoreDefaults(true);
                }
                if (ResourceAgent.SERVICE_CLASSES.contains(resourceClass) || "heartbeat".equals(resourceClass)) {
                    ra.setMetaDataLoaded(true);
                    this.setLSBResourceAgent(serviceName, resourceClass, ra);
                }
            }
            this.serviceToResourceAgentMap.put(serviceName, provider, resourceClass, ra);
            List<ResourceAgent> raList = this.classToServicesMap.get(resourceClass);
            if (raList == null) {
                raList = new ArrayList<ResourceAgent>();
                this.classToServicesMap.put(resourceClass, raList);
            }
            raList.add(ra);
            serviceName = null;
            xml.delete(0, xml.length());
        }
        this.drbddiskPresent = drbddiskPresent0;
        this.linbitDrbdPresent = linbitDrbdPresent0;
    }

    private void initOCFMetaDataConfigured() {
        this.initOCFMetaData(this.host.getDistCommand("Heartbeat.getOCFParametersConfigured", (ConvertCmdCallback)null));
    }

    private void initOCFMetaDataAll() {
        this.initOCFMetaData(this.host.getDistCommand("Heartbeat.getOCFParameters", (ConvertCmdCallback)null));
    }

    private void initOCFMetaData(String command) {
        SSH.SSHOutput ret = Tools.execCommand(this.host, command, null, false, 300000);
        if (ret.getExitCode() != 0) {
            return;
        }
        String output = ret.getOutput();
        if (output == null) {
            return;
        }
        String[] lines = output.split("\\r?\\n");
        Pattern pp = Pattern.compile("^provider:\\s*(.*?)\\s*$");
        Pattern mp = Pattern.compile("^master:\\s*(.*?)\\s*$");
        Pattern bp = Pattern.compile("<resource-agent.*\\s+name=\"(.*?)\".*");
        Pattern ep = Pattern.compile("</resource-agent>");
        StringBuilder xml = new StringBuilder("");
        String provider = null;
        String serviceName = null;
        boolean masterSlave = false;
        for (int i = 0; i < lines.length; ++i) {
            Matcher pm = pp.matcher(lines[i]);
            if (pm.matches()) {
                provider = pm.group(1);
                continue;
            }
            Matcher mm = mp.matcher(lines[i]);
            if (mm.matches()) {
                if ("".equals(mm.group(1))) {
                    masterSlave = false;
                    continue;
                }
                masterSlave = true;
                continue;
            }
            Matcher m = bp.matcher(lines[i]);
            if (m.matches()) {
                serviceName = m.group(1);
            }
            if (serviceName == null) continue;
            xml.append(lines[i]);
            xml.append('\n');
            Matcher m2 = ep.matcher(lines[i]);
            if (!m2.matches()) continue;
            this.parseMetaData(serviceName, provider, xml.toString(), masterSlave);
            serviceName = null;
            xml.delete(0, xml.length());
        }
        if (!this.drbddiskPresent) {
            Tools.appWarning("drbddisk heartbeat script is not present");
        }
    }

    public String[] getCheckBoxChoices(ResourceAgent ra, String param) {
        String paramDefault = this.getParamDefault(ra, param);
        return this.getCheckBoxChoices(paramDefault);
    }

    private String[] getCheckBoxChoices(String paramDefault) {
        if (paramDefault != null) {
            if ("yes".equals(paramDefault) || "no".equals(paramDefault)) {
                return new String[]{"yes", "no"};
            }
            if ("Yes".equals(paramDefault) || "No".equals(paramDefault)) {
                return new String[]{"Yes", "No"};
            }
            if ("true".equals(paramDefault) || "false".equals(paramDefault)) {
                return (String[])PCMK_BOOLEAN_VALUES.clone();
            }
            if ("True".equals(paramDefault) || "False".equals(paramDefault)) {
                return new String[]{"True", "False"};
            }
        }
        return (String[])PCMK_BOOLEAN_VALUES.clone();
    }

    public List<ResourceAgent> getServices(String cl) {
        List<ResourceAgent> services = this.classToServicesMap.get(cl);
        if (services == null) {
            return new ArrayList<ResourceAgent>();
        }
        Collections.sort(services, new Comparator<ResourceAgent>(){

            @Override
            public int compare(ResourceAgent s1, ResourceAgent s2) {
                return s1.getName().compareToIgnoreCase(s2.getName());
            }
        });
        return services;
    }

    public List<String> getParameters(ResourceAgent ra, boolean master) {
        return ra.getParameters(master);
    }

    public String[] getGlobalParameters() {
        if (this.globalParams != null) {
            return this.globalParams.toArray(new String[this.globalParams.size()]);
        }
        return null;
    }

    public String getVersion(ResourceAgent ra) {
        return ra.getVersion();
    }

    public String getShortDesc(ResourceAgent ra) {
        return ra.getShortDesc();
    }

    public String getLongDesc(ResourceAgent ra) {
        return ra.getLongDesc();
    }

    public String getGlobalParamShortDesc(String param) {
        String shortDesc = this.paramGlobalShortDescMap.get(param);
        if (shortDesc == null) {
            shortDesc = param;
        }
        return shortDesc;
    }

    public String getParamShortDesc(ResourceAgent ra, String param) {
        return ra.getParamShortDesc(param);
    }

    public String getGlobalParamLongDesc(String param) {
        String shortDesc = this.getGlobalParamShortDesc(param);
        String longDesc = this.paramGlobalLongDescMap.get(param);
        if (longDesc == null) {
            longDesc = "";
        }
        return Tools.html("<b>" + shortDesc + "</b>\n" + longDesc);
    }

    public String getParamLongDesc(ResourceAgent ra, String param) {
        String shortDesc = this.getParamShortDesc(ra, param);
        String longDesc = ra.getParamLongDesc(param);
        if (longDesc == null) {
            longDesc = "";
        }
        return Tools.html("<b>" + shortDesc + "</b>\n" + longDesc);
    }

    public String getGlobalParamType(String param) {
        return this.paramGlobalTypeMap.get(param);
    }

    public String getParamType(ResourceAgent ra, String param) {
        return ra.getParamType(param);
    }

    public String getGlobalParamDefault(String param) {
        return this.paramGlobalDefaultMap.get(param);
    }

    public String getGlobalParamPreferred(String param) {
        return this.paramGlobalPreferredMap.get(param);
    }

    public String getParamPreferred(ResourceAgent ra, String param) {
        return ra.getParamPreferred(param);
    }

    public String getParamDefault(ResourceAgent ra, String param) {
        return ra.getParamDefault(param);
    }

    public String[] getGlobalParamPossibleChoices(String param) {
        return this.paramGlobalPossibleChoices.get(param);
    }

    public String[] getParamPossibleChoices(ResourceAgent ra, String param, boolean ms) {
        if (ms) {
            return ra.getParamPossibleChoicesMS(param);
        }
        return ra.getParamPossibleChoices(param);
    }

    public boolean isGlobalAdvanced(String param) {
        return !this.globalNotAdvancedParams.contains(param);
    }

    public ConfigData.AccessType getGlobalAccessType(String param) {
        ConfigData.AccessType at = this.paramGlobalAccessTypes.get(param);
        if (at == null) {
            return ConfigData.AccessType.ADMIN;
        }
        return at;
    }

    public boolean isGlobalRequired(String param) {
        return this.globalRequiredParams.contains(param);
    }

    public boolean isAdvanced(ResourceAgent ra, String param) {
        if (this.isMetaAttr(ra, param)) {
            if (ra == this.hbGroup) {
                return !GROUP_M_A_NOT_ADVANCED.contains(param);
            }
            if (ra == this.pcmkClone) {
                return true;
            }
            return !M_A_NOT_ADVANCED.contains(param);
        }
        if (RA_PARAM_SECTION.containsKey((K[])new String[]{ra.getName(), param})) {
            return false;
        }
        return !this.isRequired(ra, param);
    }

    public ConfigData.AccessType getAccessType(ResourceAgent ra, String param) {
        ConfigData.AccessType accessType;
        if (this.isMetaAttr(ra, param) && (accessType = M_A_ACCESS_TYPE.get(param)) != null) {
            return accessType;
        }
        return ConfigData.AccessType.ADMIN;
    }

    public boolean isRequired(ResourceAgent ra, String param) {
        return ra.isRequired(param);
    }

    public boolean isMetaAttr(ResourceAgent ra, String param) {
        return ra.isParamMetaAttr(param);
    }

    public boolean isInteger(ResourceAgent ra, String param) {
        String type = this.getParamType(ra, param);
        return PARAM_TYPE_INTEGER.equals(type);
    }

    public boolean isLabel(ResourceAgent ra, String param) {
        String type = this.getParamType(ra, param);
        return PARAM_TYPE_LABEL.equals(type);
    }

    public boolean isBoolean(ResourceAgent ra, String param) {
        String type = this.getParamType(ra, param);
        return PARAM_TYPE_BOOLEAN.equals(type);
    }

    public boolean isGlobalInteger(String param) {
        String type = this.getGlobalParamType(param);
        return PARAM_TYPE_INTEGER.equals(type);
    }

    public boolean isGlobalLabel(String param) {
        String type = this.getGlobalParamType(param);
        return PARAM_TYPE_LABEL.equals(type);
    }

    public boolean isGlobalBoolean(String param) {
        String type = this.getGlobalParamType(param);
        return PARAM_TYPE_BOOLEAN.equals(type);
    }

    public boolean isTimeType(ResourceAgent ra, String param) {
        String type = this.getParamType(ra, param);
        return PARAM_TYPE_TIME.equals(type);
    }

    public boolean isGlobalTimeType(String param) {
        String type = this.getGlobalParamType(param);
        return PARAM_TYPE_TIME.equals(type);
    }

    public String getSection(ResourceAgent ra, String param) {
        String section = ra.getSection(param);
        if (section != null) {
            return section;
        }
        if (this.isMetaAttr(ra, param)) {
            return Tools.getString("CRMXML.MetaAttrOptions");
        }
        if (this.isRequired(ra, param)) {
            return Tools.getString("CRMXML.RequiredOptions");
        }
        return Tools.getString("CRMXML.OptionalOptions");
    }

    public String getGlobalSection(String param) {
        if (this.isGlobalRequired(param)) {
            return Tools.getString("CRMXML.GlobalRequiredOptions");
        }
        return Tools.getString("CRMXML.GlobalOptionalOptions");
    }

    private String convertRscDefaultsParam(String param) {
        String newParam = this.rscDefaultsMetaAttrs.get(param);
        if (newParam == null) {
            return param;
        }
        return newParam;
    }

    public boolean checkMetaAttrParam(String param, String value) {
        String newParam = this.convertRscDefaultsParam(param);
        String type = M_A_TYPE.get(newParam);
        boolean required = this.isRscDefaultsRequired(newParam);
        boolean metaAttr = true;
        return this.checkParam(type, required, true, newParam, value);
    }

    public String getRscDefaultsSection(String param) {
        String newParam = this.convertRscDefaultsParam(param);
        String section = M_A_SECTION.get(newParam);
        if (section == null) {
            return Tools.getString("CRMXML.RscDefaultsSection");
        }
        return section;
    }

    public String getRscDefaultsDefault(String param) {
        String newParam = this.convertRscDefaultsParam(param);
        return M_A_DEFAULT.get(newParam);
    }

    public String getRscDefaultsPreferred(String param) {
        return null;
    }

    public String[] getRscDefaultsPossibleChoices(String param) {
        String newParam = this.convertRscDefaultsParam(param);
        return M_A_POSSIBLE_CHOICES.get(newParam);
    }

    public String[] getRscDefaultsCheckBoxChoices(String param) {
        String newParam = this.convertRscDefaultsParam(param);
        String paramDefault = this.getRscDefaultsDefault(newParam);
        return this.getCheckBoxChoices(paramDefault);
    }

    public String getRscDefaultsShortDesc(String param) {
        String newParam = this.convertRscDefaultsParam(param);
        return M_A_SHORT_DESC.get(newParam);
    }

    public String getRscDefaultsLongDesc(String param) {
        String newParam = this.convertRscDefaultsParam(param);
        return M_A_LONG_DESC.get(newParam);
    }

    public String getRscDefaultsType(String param) {
        String newParam = this.convertRscDefaultsParam(param);
        return M_A_TYPE.get(newParam);
    }

    public boolean isRscDefaultsAdvanced(String param) {
        String newParam = this.convertRscDefaultsParam(param);
        return !M_A_NOT_ADVANCED.contains(newParam);
    }

    public ConfigData.AccessType getRscDefaultsAccessType(String param) {
        String newParam = this.convertRscDefaultsParam(param);
        ConfigData.AccessType at = M_A_RSC_DEFAULTS_ACCESS_TYPE.get(newParam);
        if (at == null) {
            return ConfigData.AccessType.ADMIN;
        }
        return at;
    }

    public boolean isRscDefaultsRequired(String param) {
        String newParam = this.convertRscDefaultsParam(param);
        return false;
    }

    public boolean isRscDefaultsInteger(String param) {
        String newParam = this.convertRscDefaultsParam(param);
        String type = this.getRscDefaultsType(newParam);
        return PARAM_TYPE_INTEGER.equals(type);
    }

    public boolean isRscDefaultsLabel(String param) {
        String newParam = this.convertRscDefaultsParam(param);
        String type = this.getRscDefaultsType(newParam);
        return PARAM_TYPE_LABEL.equals(type);
    }

    public boolean isRscDefaultsBoolean(String param) {
        String newParam = this.convertRscDefaultsParam(param);
        String type = this.getRscDefaultsType(newParam);
        return PARAM_TYPE_BOOLEAN.equals(type);
    }

    public boolean isRscDefaultsTimeType(String param) {
        String newParam = this.convertRscDefaultsParam(param);
        String type = this.getRscDefaultsType(newParam);
        return PARAM_TYPE_TIME.equals(type);
    }

    public boolean checkParam(ResourceAgent ra, String param, String value) {
        String type = this.getParamType(ra, param);
        boolean required = this.isRequired(ra, param);
        boolean metaAttr = this.isMetaAttr(ra, param);
        return this.checkParam(type, required, metaAttr, param, value);
    }

    private boolean checkParam(String type, boolean required, boolean metaAttr, String param, String value) {
        if (metaAttr && this.isRscDefaultsInteger(param) && DISABLED_STRING.equals(value)) {
            value = "";
        }
        boolean correctValue = true;
        if (PARAM_TYPE_BOOLEAN.equals(type)) {
            if (!("yes".equals(value) || "no".equals(value) || "true".equals(value) || "false".equals(value) || "True".equals(value) || "False".equals(value))) {
                correctValue = false;
            }
        } else if (PARAM_TYPE_INTEGER.equals(type)) {
            Pattern p = Pattern.compile("^(-?\\d*|(-|\\+)?INFINITY)$");
            Matcher m = p.matcher(value);
            if (!m.matches()) {
                correctValue = false;
            }
        } else if (PARAM_TYPE_TIME.equals(type)) {
            Pattern p = Pattern.compile("^-?\\d*(ms|msec|us|usec|s|sec|m|min|h|hr)?$");
            Matcher m = p.matcher(value);
            if (!m.matches()) {
                correctValue = false;
            }
        } else if ((value == null || "".equals(value)) && required) {
            correctValue = false;
        }
        return correctValue;
    }

    public boolean checkGlobalParam(String param, String value) {
        String type = this.getGlobalParamType(param);
        boolean correctValue = true;
        if (PARAM_TYPE_BOOLEAN.equals(type)) {
            if (!("yes".equals(value) || "no".equals(value) || "true".equals(value) || "false".equals(value) || "True".equals(value) || "False".equals(value))) {
                correctValue = false;
            }
        } else if (PARAM_TYPE_INTEGER.equals(type)) {
            Pattern p = Pattern.compile("^(-?\\d*|(-|\\+)?INFINITY)$");
            Matcher m = p.matcher(value);
            if (!m.matches()) {
                correctValue = false;
            }
        } else if (PARAM_TYPE_TIME.equals(type)) {
            Pattern p = Pattern.compile("^-?\\d*(ms|msec|us|usec|s|sec|m|min|h|hr)?$");
            Matcher m = p.matcher(value);
            if (!m.matches()) {
                correctValue = false;
            }
        } else if ((value == null || "".equals(value)) && this.isGlobalRequired(param)) {
            correctValue = false;
        }
        return correctValue;
    }

    private void addMetaAttribute(ResourceAgent ra, String name, String newName, boolean masterSlave) {
        if (newName == null) {
            newName = name;
        }
        if (masterSlave) {
            ra.addMasterParameter(name);
        } else {
            ra.addParameter(name);
        }
        ra.setParamIsMetaAttr(name, true);
        ra.setParamRequired(name, false);
        ra.setParamPossibleChoices(name, M_A_POSSIBLE_CHOICES.get(newName));
        ra.setParamPossibleChoicesMS(name, M_A_POSSIBLE_CHOICES_MS.get(newName));
        ra.setParamShortDesc(name, M_A_SHORT_DESC.get(newName));
        ra.setParamLongDesc(name, M_A_LONG_DESC.get(newName));
        ra.setParamDefault(name, M_A_DEFAULT.get(newName));
        ra.setParamType(name, M_A_TYPE.get(newName));
        ra.setParamPreferred(name, M_A_PREFERRED.get(newName));
    }

    private Map<String, String> getMetaAttrParameters() {
        if (this.metaAttrParams != null) {
            return this.metaAttrParams;
        }
        this.metaAttrParams = new LinkedHashMap<String, String>();
        if (Tools.versionBeforePacemaker(this.host)) {
            this.metaAttrParams.put("target_role", TARGET_ROLE_META_ATTR);
            this.metaAttrParams.put("is_managed", IS_MANAGED_META_ATTR);
        } else {
            this.metaAttrParams.put(TARGET_ROLE_META_ATTR, null);
            this.metaAttrParams.put(IS_MANAGED_META_ATTR, null);
        }
        this.metaAttrParams.put(MIGRATION_THRESHOLD_META_ATTR, null);
        this.metaAttrParams.put(PRIORITY_META_ATTR, null);
        this.metaAttrParams.put(MULTIPLE_ACTIVE_META_ATTR, null);
        this.metaAttrParams.put(ALLOW_MIGRATE_META_ATTR, null);
        String hbV = this.host.getHeartbeatVersion();
        String pcmkV = this.host.getPacemakerVersion();
        try {
            if (pcmkV != null || Tools.compareVersions(hbV, "2.1.4") >= 0) {
                this.metaAttrParams.put(RESOURCE_STICKINESS_META_ATTR, null);
                this.metaAttrParams.put(FAILURE_TIMEOUT_META_ATTR, null);
            }
        }
        catch (Exceptions.IllegalVersionException e) {
            Tools.appWarning(e.getMessage(), e);
        }
        return this.metaAttrParams;
    }

    public Map<String, String> getRscDefaultsParameters() {
        if (this.rscDefaultsMetaAttrs != null) {
            return this.rscDefaultsMetaAttrs;
        }
        this.rscDefaultsMetaAttrs = new LinkedHashMap<String, String>();
        if (Tools.versionBeforePacemaker(this.host)) {
            return this.rscDefaultsMetaAttrs;
        }
        for (String param : this.getMetaAttrParameters().keySet()) {
            this.rscDefaultsMetaAttrs.put(param, this.getMetaAttrParameters().get(param));
        }
        this.rscDefaultsMetaAttrs.put(MASTER_MAX_META_ATTR, null);
        this.rscDefaultsMetaAttrs.put(MASTER_NODE_MAX_META_ATTR, null);
        this.rscDefaultsMetaAttrs.put(CLONE_MAX_META_ATTR, null);
        this.rscDefaultsMetaAttrs.put(CLONE_NODE_MAX_META_ATTR, null);
        this.rscDefaultsMetaAttrs.put(NOTIFY_META_ATTR, null);
        this.rscDefaultsMetaAttrs.put(GLOBALLY_UNIQUE_META_ATTR, null);
        this.rscDefaultsMetaAttrs.put(ORDERED_META_ATTR, null);
        this.rscDefaultsMetaAttrs.put(INTERLEAVE_META_ATTR, null);
        return this.rscDefaultsMetaAttrs;
    }

    private void parseParameters(ResourceAgent ra, Node parametersNode) {
        NodeList parameters = parametersNode.getChildNodes();
        for (int i = 0; i < parameters.getLength(); ++i) {
            String section;
            Node contentParamNode;
            Node shortdescParamNode;
            Node longdescParamNode;
            Node parameterNode = parameters.item(i);
            if (!parameterNode.getNodeName().equals("parameter")) continue;
            String param = this.getAttribute(parameterNode, "name");
            String required = this.getAttribute(parameterNode, "required");
            ra.addParameter(param);
            if (required != null && required.equals("1")) {
                ra.setParamRequired(param, true);
            }
            if ((longdescParamNode = this.getChildNode(parameterNode, "longdesc")) != null) {
                String longDesc = this.getText(longdescParamNode);
                ra.setParamLongDesc(param, Tools.trimText(longDesc));
            }
            if ((shortdescParamNode = this.getChildNode(parameterNode, "shortdesc")) != null) {
                String shortDesc = this.getText(shortdescParamNode);
                ra.setParamShortDesc(param, shortDesc);
            }
            if ((contentParamNode = this.getChildNode(parameterNode, "content")) != null) {
                String type = this.getAttribute(contentParamNode, "type");
                String defaultValue = this.getAttribute(contentParamNode, "default");
                if (defaultValue == null && ra.isStonith() && PARAM_TYPE_BOOLEAN.equals(type)) {
                    defaultValue = "false";
                }
                if (ra.isIPaddr() && "nic".equals(param)) {
                    defaultValue = "";
                }
                if ("force_stop".equals(param) && "0".equals(defaultValue)) {
                    defaultValue = "false";
                }
                if (ra.isPingService()) {
                    ra.setProbablyClone(true);
                    if ("host_list".equals(param)) {
                        ra.setParamRequired(param, true);
                    }
                } else {
                    ra.setParamType(param, type);
                }
                if (!ra.isStonith() || !PARAM_TYPE_BOOLEAN.equals(type) || defaultValue == null) {
                    // empty if block
                }
                ra.setParamDefault(param, defaultValue);
            }
            if (ra.isStonith() && "hostlist".equals(param)) {
                ra.setParamPossibleChoices(param, this.hostlistChoices.toArray(new String[this.hostlistChoices.size()]));
            }
            if ((section = RA_PARAM_SECTION.get((K[])new String[]{ra.getName(), param})) == null) continue;
            ra.setSection(param, section);
        }
        if (ra.isStonith()) {
            ra.addParameter(STONITH_TIMEOUT_INSTANCE_ATTR);
            ra.setParamShortDesc(STONITH_TIMEOUT_INSTANCE_ATTR, Tools.getString("CRMXML.stonith-timeout.ShortDesc"));
            ra.setParamLongDesc(STONITH_TIMEOUT_INSTANCE_ATTR, Tools.getString("CRMXML.stonith-timeout.LongDesc"));
            ra.setParamType(STONITH_TIMEOUT_INSTANCE_ATTR, PARAM_TYPE_TIME);
            ra.setParamDefault(STONITH_TIMEOUT_INSTANCE_ATTR, "");
            ra.addParameter(STONITH_PRIORITY_INSTANCE_ATTR);
            ra.setParamShortDesc(STONITH_PRIORITY_INSTANCE_ATTR, Tools.getString("CRMXML.stonith-priority.ShortDesc"));
            ra.setParamLongDesc(STONITH_PRIORITY_INSTANCE_ATTR, Tools.getString("CRMXML.stonith-priority.LongDesc"));
            ra.setParamPossibleChoices(STONITH_PRIORITY_INSTANCE_ATTR, new String[]{"0", "5", "10"});
            ra.setParamType(STONITH_PRIORITY_INSTANCE_ATTR, PARAM_TYPE_INTEGER);
            ra.setParamDefault(STONITH_PRIORITY_INSTANCE_ATTR, "0");
            ra.addParameter(PCMK_HOST_CHECK_PARAM);
            ra.setParamPossibleChoices(PCMK_HOST_CHECK_PARAM, new String[]{"", PCMK_HOST_CHECK_DYNAMIC, PCMK_HOST_CHECK_STATIC});
            ra.setParamShortDesc(PCMK_HOST_CHECK_PARAM, Tools.getString("CRMXML.pcmk_host_check.ShortDesc"));
            ra.setParamLongDesc(PCMK_HOST_CHECK_PARAM, Tools.getString("CRMXML.pcmk_host_check.LongDesc"));
            ra.setParamDefault(PCMK_HOST_CHECK_PARAM, PCMK_HOST_CHECK_DYNAMIC);
            ra.setParamType(PCMK_HOST_CHECK_PARAM, PARAM_TYPE_STRING);
            ra.addParameter(PCMK_HOST_LIST_PARAM);
            ra.setParamShortDesc(PCMK_HOST_LIST_PARAM, Tools.getString("CRMXML.pcmk_host_list.ShortDesc"));
            ra.setParamLongDesc(PCMK_HOST_LIST_PARAM, Tools.getString("CRMXML.pcmk_host_list.LongDesc"));
            ra.setParamType(PCMK_HOST_LIST_PARAM, PARAM_TYPE_STRING);
            ra.setParamPossibleChoices(PCMK_HOST_LIST_PARAM, this.hostlistChoices.toArray(new String[this.hostlistChoices.size()]));
            ra.addParameter(PCMK_HOST_MAP_PARAM);
            ra.setParamShortDesc(PCMK_HOST_MAP_PARAM, Tools.getString("CRMXML.pcmk_host_map.ShortDesc"));
            ra.setParamLongDesc(PCMK_HOST_MAP_PARAM, Tools.getString("CRMXML.pcmk_host_map.LongDesc"));
            ra.setParamType(PCMK_HOST_MAP_PARAM, PARAM_TYPE_STRING);
        }
        Map<String, String> metaAttrParams = this.getMetaAttrParameters();
        for (String metaAttr : metaAttrParams.keySet()) {
            this.addMetaAttribute(ra, metaAttr, metaAttrParams.get(metaAttr), false);
        }
    }

    private void parseActions(ResourceAgent ra, Node actionsNode) {
        NodeList actions2 = actionsNode.getChildNodes();
        for (int i = 0; i < actions2.getLength(); ++i) {
            String name;
            Node actionNode = actions2.item(i);
            if (!actionNode.getNodeName().equals(FENCING_ACTION_PARAM) || "status ".equals(name = this.getAttribute(actionNode, "name"))) continue;
            String depth = this.getAttribute(actionNode, "depth");
            String timeout = this.getAttribute(actionNode, "timeout");
            String interval = this.getAttribute(actionNode, "interval");
            String startDelay = this.getAttribute(actionNode, "start-delay");
            String role = this.getAttribute(actionNode, "role");
            ra.addOperationDefault(name, "depth", depth);
            ra.addOperationDefault(name, "timeout", timeout);
            ra.addOperationDefault(name, "interval", interval);
            ra.addOperationDefault(name, "start-delay", startDelay);
            ra.addOperationDefault(name, "role", role);
        }
        ra.addOperationDefault("monitor", PAR_CHECK_LEVEL, "");
    }

    private void parseStonithActions(ResourceAgent ra, Node actionsNode) {
        NodeList actionNodes = actionsNode.getChildNodes();
        ArrayList<String> actions2 = new ArrayList<String>();
        for (int i = 0; i < actionNodes.getLength(); ++i) {
            Node actionNode = actionNodes.item(i);
            if (!actionNode.getNodeName().equals(FENCING_ACTION_PARAM)) continue;
            String name = this.getAttribute(actionNode, "name");
            actions2.add(name);
        }
        ra.setParamPossibleChoices(FENCING_ACTION_PARAM, actions2.toArray(new String[actions2.size()]));
    }

    void parseMetaData(String serviceName, String provider, String xml, boolean masterSlave) {
        ResourceAgent ra;
        Document document = this.getXMLDocument(xml);
        if (document == null) {
            return;
        }
        Node raNode = this.getChildNode(document, "resource-agent");
        if (raNode == null) {
            return;
        }
        String resourceClass = this.getAttribute(raNode, "class");
        if (resourceClass == null) {
            resourceClass = "ocf";
        }
        if ((ra = this.serviceToResourceAgentMap.get((K[])new String[]{serviceName, provider, resourceClass})) == null) {
            Tools.appWarning("cannot save meta-data for: " + resourceClass + ":" + provider + ":" + serviceName);
            return;
        }
        if (ra.isMetaDataLoaded()) {
            return;
        }
        if (ResourceAgent.SERVICE_CLASSES.contains(resourceClass) || "heartbeat".equals(resourceClass)) {
            this.setLSBResourceAgent(serviceName, resourceClass, ra);
        } else {
            Node actionsNode;
            Node parametersNode;
            Node shortdescNode;
            Node longdescNode;
            Node versionNode = this.getChildNode(raNode, "version");
            if (versionNode != null) {
                ra.setVersion(this.getText(versionNode));
            }
            if ((longdescNode = this.getChildNode(raNode, "longdesc")) != null) {
                ra.setLongDesc(Tools.trimText(this.getText(longdescNode)));
            }
            if ((shortdescNode = this.getChildNode(raNode, "shortdesc")) != null) {
                ra.setShortDesc(this.getText(shortdescNode));
            }
            if ((parametersNode = this.getChildNode(raNode, "parameters")) != null) {
                this.parseParameters(ra, parametersNode);
            }
            if ((actionsNode = this.getChildNode(raNode, "actions")) != null) {
                if (ra.isStonith() && ra.hasParameter(FENCING_ACTION_PARAM)) {
                    this.parseStonithActions(ra, actionsNode);
                } else {
                    this.parseActions(ra, actionsNode);
                }
            }
            ra.setProbablyMasterSlave(masterSlave);
        }
        ra.setMetaDataLoaded(true);
    }

    private void setLSBResourceAgent(String serviceName, String raClass, ResourceAgent ra) {
        ra.setVersion("0.0");
        if ("lsb".equals(raClass)) {
            ra.setLongDesc("LSB resource.");
            ra.setShortDesc("/etc/init.d/" + serviceName);
        } else if (ResourceAgent.SERVICE_CLASSES.contains(raClass)) {
            ra.setLongDesc(raClass);
            ra.setShortDesc(serviceName);
        } else if ("heartbeat".equals(raClass)) {
            ra.setLongDesc("Heartbeat 1 RA.");
            ra.setShortDesc("/etc/ha.d/resource.d/" + serviceName);
        }
        for (int i = 1; i < 11; ++i) {
            String param = Integer.toString(i);
            ra.addParameter(param);
            ra.setParamLongDesc(param, param);
            ra.setParamShortDesc(param, param);
            ra.setParamType(param, PARAM_TYPE_STRING);
            ra.setParamDefault(param, "");
        }
        for (String name : new String[]{"start", "stop", "status", "meta-data"}) {
            ra.addOperationDefault(name, "timeout", "15");
        }
        String monitorName = "monitor";
        ra.addOperationDefault("monitor", "timeout", "15");
        ra.addOperationDefault("monitor", "interval", "15");
        ra.addOperationDefault("monitor", "start-delay", "15");
        ra.setProbablyMasterSlave(false);
    }

    void parseClusterMetaData(String xml) {
        Document document = this.getXMLDocument(xml);
        if (document == null) {
            return;
        }
        Node metadataNode = this.getChildNode(document, "metadata");
        if (metadataNode == null) {
            return;
        }
        NodeList resAgents = metadataNode.getChildNodes();
        String[] booleanValues = PCMK_BOOLEAN_VALUES;
        for (int i = 0; i < resAgents.getLength(); ++i) {
            Node resAgentNode = resAgents.item(i);
            if (!resAgentNode.getNodeName().equals("resource-agent")) continue;
            Node parametersNode = this.getChildNode(resAgentNode, "parameters");
            if (parametersNode == null) {
                return;
            }
            NodeList parameters = parametersNode.getChildNodes();
            for (int j = 0; j < parameters.getLength(); ++j) {
                Pattern p;
                Matcher m;
                Node contentParamNode;
                Node longdescParamNode;
                Node parameterNode = parameters.item(j);
                if (!parameterNode.getNodeName().equals("parameter")) continue;
                String param = this.getAttribute(parameterNode, "name");
                String required = this.getAttribute(parameterNode, "required");
                if (!this.globalParams.contains(param)) {
                    this.globalParams.add(param);
                }
                if (required != null && required.equals("1") && !this.globalRequiredParams.contains(param)) {
                    this.globalRequiredParams.add(param);
                }
                if ((longdescParamNode = this.getChildNode(parameterNode, "longdesc")) != null) {
                    String longDesc = this.getText(longdescParamNode);
                    this.paramGlobalLongDescMap.put(param, Tools.trimText(longDesc));
                }
                if ((contentParamNode = this.getChildNode(parameterNode, "content")) == null) continue;
                String type = this.getAttribute(contentParamNode, "type");
                String defaultValue = this.getAttribute(contentParamNode, "default");
                this.paramGlobalTypeMap.put(param, type);
                if (PARAM_TYPE_TIME.equals(type) && (m = (p = Pattern.compile("^(\\d+)s$")).matcher(defaultValue)).matches()) {
                    defaultValue = m.group(1);
                }
                if (!"expected-quorum-votes".equals(param)) {
                    this.paramGlobalDefaultMap.put(param, defaultValue);
                }
                if (PARAM_TYPE_BOOLEAN.equals(type)) {
                    this.paramGlobalPossibleChoices.put(param, booleanValues);
                }
                if (!PARAM_TYPE_INTEGER.equals(type)) continue;
                this.paramGlobalPossibleChoices.put(param, INTEGER_VALUES);
            }
        }
        this.paramGlobalTypeMap.put(STONITH_TIMEOUT_INSTANCE_ATTR, PARAM_TYPE_TIME);
    }

    public ResourceAgent getResourceAgent(String serviceName, String provider, String raClass) {
        ResourceAgent ra = this.serviceToResourceAgentMap.get((K[])new String[]{serviceName, provider, raClass});
        if (ra == null) {
            ResourceAgent notInstalledRA = new ResourceAgent(serviceName, provider, raClass);
            if (ResourceAgent.SERVICE_CLASSES.contains(raClass) || "heartbeat".equals(raClass)) {
                this.setLSBResourceAgent(serviceName, raClass, notInstalledRA);
            } else {
                Tools.appWarning(raClass + ":" + provider + ":" + serviceName + " RA does not exist");
            }
            this.serviceToResourceAgentMap.put(serviceName, provider, raClass, notInstalledRA);
            return notInstalledRA;
        }
        return ra;
    }

    public ResourceAgent getHbDrbddisk() {
        return this.hbDrbddisk;
    }

    public ResourceAgent getHbLinbitDrbd() {
        return this.hbLinbitDrbd;
    }

    public ResourceAgent getHbGroup() {
        return this.hbGroup;
    }

    public ResourceAgent getHbClone() {
        return this.pcmkClone;
    }

    String parseRscDefaults(Node rscDefaultsNode, Map<String, String> rscDefaultsParams, Map<String, String> rscDefaultsParamsNvpairIds) {
        HashMap nvpairIds = new HashMap();
        Node metaAttrsNode = this.getChildNode(rscDefaultsNode, "meta_attributes");
        String rscDefaultsId = null;
        if (metaAttrsNode != null) {
            NodeList nvpairsMA;
            rscDefaultsId = this.getAttribute(metaAttrsNode, "id");
            if (Tools.versionBeforePacemaker(this.host)) {
                Node attrsNode = this.getChildNode(metaAttrsNode, "attributes");
                nvpairsMA = attrsNode.getChildNodes();
            } else {
                nvpairsMA = metaAttrsNode.getChildNodes();
            }
            for (int l = 0; l < nvpairsMA.getLength(); ++l) {
                Node maNode = nvpairsMA.item(l);
                if (!maNode.getNodeName().equals("nvpair")) continue;
                String nvpairId = this.getAttribute(maNode, "id");
                String name = this.getAttribute(maNode, "name");
                String value = this.getAttribute(maNode, "value");
                if (TARGET_ROLE_META_ATTR.equals(name)) {
                    value = value.toLowerCase(Locale.US);
                }
                rscDefaultsParams.put(name, value);
                rscDefaultsParamsNvpairIds.put(name, nvpairId);
            }
        }
        return rscDefaultsId;
    }

    void parseOpDefaults(Node opDefaultsNode, Map<String, String> opDefaultsParams) {
        HashMap nvpairIds = new HashMap();
        Node metaAttrsNode = this.getChildNode(opDefaultsNode, "meta_attributes");
        if (metaAttrsNode != null) {
            NodeList nvpairsMA;
            if (Tools.versionBeforePacemaker(this.host)) {
                Node attrsNode = this.getChildNode(metaAttrsNode, "attributes");
                nvpairsMA = attrsNode.getChildNodes();
            } else {
                nvpairsMA = metaAttrsNode.getChildNodes();
            }
            for (int l = 0; l < nvpairsMA.getLength(); ++l) {
                Node maNode = nvpairsMA.item(l);
                if (!maNode.getNodeName().equals("nvpair")) continue;
                String name = this.getAttribute(maNode, "name");
                String value = this.getAttribute(maNode, "value");
                opDefaultsParams.put(name, value);
            }
        }
    }

    private void parseAttributes(Node resourceNode, String crmId, Map<String, Map<String, String>> parametersMap, Map<String, Map<String, String>> parametersNvpairsIdsMap, Map<String, String> resourceInstanceAttrIdMap, MultiKeyMap<String, String> operationsMap, Map<String, String> metaAttrsIdMap, Map<String, String> operationsIdMap, Map<String, Map<String, String>> resOpIdsMap, Map<String, String> operationsIdRefs, Map<String, String> operationsIdtoCRMId, Map<String, String> metaAttrsIdRefs, Map<String, String> metaAttrsIdToCRMId, boolean stonith) {
        Node metaAttrsNode;
        String name;
        Node operationsNode;
        HashMap<String, String> params = new HashMap<String, String>();
        parametersMap.put(crmId, params);
        HashMap<String, String> nvpairIds = new HashMap<String, String>();
        parametersNvpairsIdsMap.put(crmId, nvpairIds);
        Node instanceAttrNode = this.getChildNode(resourceNode, "instance_attributes");
        if (instanceAttrNode != null) {
            NodeList nvpairsRes;
            String iAId = this.getAttribute(instanceAttrNode, "id");
            resourceInstanceAttrIdMap.put(crmId, iAId);
            if (Tools.versionBeforePacemaker(this.host)) {
                Node attrNode = this.getChildNode(instanceAttrNode, "attributes");
                nvpairsRes = attrNode.getChildNodes();
            } else {
                nvpairsRes = instanceAttrNode.getChildNodes();
            }
            for (int j = 0; j < nvpairsRes.getLength(); ++j) {
                Node optionNode = nvpairsRes.item(j);
                if (!optionNode.getNodeName().equals("nvpair")) continue;
                String nvpairId = this.getAttribute(optionNode, "id");
                String name2 = this.getAttribute(optionNode, "name");
                String value = this.getAttribute(optionNode, "value");
                if (stonith && PRIORITY_META_ATTR.equals(name2)) {
                    name2 = STONITH_PRIORITY_INSTANCE_ATTR;
                }
                params.put(name2, value);
                nvpairIds.put(name2, nvpairId);
            }
        }
        if ((operationsNode = this.getChildNode(resourceNode, "operations")) != null) {
            String operationsIdRef = this.getAttribute(operationsNode, "id-ref");
            if (operationsIdRef == null) {
                String operationsId = this.getAttribute(operationsNode, "id");
                operationsIdMap.put(crmId, operationsId);
                operationsIdtoCRMId.put(operationsId, crmId);
                HashMap<String, String> opIds = new HashMap<String, String>();
                resOpIdsMap.put(crmId, opIds);
                NodeList ops = operationsNode.getChildNodes();
                for (int k = 0; k < ops.getLength(); ++k) {
                    Node opNode = ops.item(k);
                    if (!opNode.getNodeName().equals("op")) continue;
                    String opId = this.getAttribute(opNode, "id");
                    name = this.getAttribute(opNode, "name");
                    String timeout = this.getAttribute(opNode, "timeout");
                    String interval = this.getAttribute(opNode, "interval");
                    String startDelay = this.getAttribute(opNode, "start-delay");
                    operationsMap.put(crmId, name, "interval", interval);
                    operationsMap.put(crmId, name, "timeout", timeout);
                    operationsMap.put(crmId, name, "start-delay", startDelay);
                    opIds.put(name, opId);
                    if (!"monitor".equals(name)) continue;
                    String checkLevel = this.parseCheckLevel(opNode);
                    operationsMap.put(crmId, name, PAR_CHECK_LEVEL, checkLevel);
                }
            } else {
                operationsIdRefs.put(crmId, operationsIdRef);
            }
        }
        if ((metaAttrsNode = this.getChildNode(resourceNode, "meta_attributes")) != null) {
            String metaAttrsIdRef = this.getAttribute(metaAttrsNode, "id-ref");
            if (metaAttrsIdRef == null) {
                NodeList nvpairsMA;
                String metaAttrsId = this.getAttribute(metaAttrsNode, "id");
                metaAttrsIdMap.put(crmId, metaAttrsId);
                metaAttrsIdToCRMId.put(metaAttrsId, crmId);
                if (Tools.versionBeforePacemaker(this.host)) {
                    Node attrsNode = this.getChildNode(metaAttrsNode, "attributes");
                    nvpairsMA = attrsNode.getChildNodes();
                } else {
                    nvpairsMA = metaAttrsNode.getChildNodes();
                }
                for (int l = 0; l < nvpairsMA.getLength(); ++l) {
                    Node maNode = nvpairsMA.item(l);
                    if (!maNode.getNodeName().equals("nvpair")) continue;
                    String nvpairId = this.getAttribute(maNode, "id");
                    name = this.getAttribute(maNode, "name");
                    String value = this.getAttribute(maNode, "value");
                    if (TARGET_ROLE_META_ATTR.equals(name)) {
                        value = value.toLowerCase(Locale.US);
                    }
                    params.put(name, value);
                    nvpairIds.put(name, nvpairId);
                }
            } else {
                metaAttrsIdRefs.put(crmId, metaAttrsIdRef);
            }
        }
    }

    private String parseCheckLevel(Node opNode) {
        Node iaNode = this.getChildNode(opNode, "instance_attributes");
        if (iaNode == null) {
            return "";
        }
        Node nvpairNode = this.getChildNode(iaNode, "nvpair");
        if (nvpairNode == null) {
            return "";
        }
        String name = this.getAttribute(nvpairNode, "name");
        String value = this.getAttribute(nvpairNode, "value");
        if (PAR_CHECK_LEVEL.equals(name)) {
            return value;
        }
        Tools.appWarning("unexpected instance attribute: " + name + " " + value);
        return "";
    }

    private void parseGroup(Node groupNode, List<String> resList, Map<String, List<String>> groupsToResourcesMap, Map<String, Map<String, String>> parametersMap, Map<String, ResourceAgent> resourceTypeMap, Map<String, Map<String, String>> parametersNvpairsIdsMap, Map<String, String> resourceInstanceAttrIdMap, MultiKeyMap<String, String> operationsMap, Map<String, String> metaAttrsIdMap, Map<String, String> operationsIdMap, Map<String, Map<String, String>> resOpIdsMap, Map<String, String> operationsIdRefs, Map<String, String> operationsIdtoCRMId, Map<String, String> metaAttrsIdRefs, Map<String, String> metaAttrsIdToCRMId) {
        List<String> groupResList;
        NodeList primitives = groupNode.getChildNodes();
        String groupId = this.getAttribute(groupNode, "id");
        HashMap<String, String> params = new HashMap<String, String>();
        parametersMap.put(groupId, params);
        HashMap<String, String> nvpairIds = new HashMap<String, String>();
        parametersNvpairsIdsMap.put(groupId, nvpairIds);
        if (resList != null) {
            resList.add(groupId);
        }
        if ((groupResList = groupsToResourcesMap.get(groupId)) == null) {
            groupResList = new ArrayList<String>();
            groupsToResourcesMap.put(groupId, groupResList);
        }
        for (int j = 0; j < primitives.getLength(); ++j) {
            Node primitiveNode = primitives.item(j);
            if (!primitiveNode.getNodeName().equals("primitive")) continue;
            this.parsePrimitive(primitiveNode, groupResList, resourceTypeMap, parametersMap, parametersNvpairsIdsMap, resourceInstanceAttrIdMap, operationsMap, metaAttrsIdMap, operationsIdMap, resOpIdsMap, operationsIdRefs, operationsIdtoCRMId, metaAttrsIdRefs, metaAttrsIdToCRMId);
        }
        Node metaAttrsNode = this.getChildNode(groupNode, "meta_attributes");
        if (metaAttrsNode != null) {
            String metaAttrsIdRef = this.getAttribute(metaAttrsNode, "id-ref");
            if (metaAttrsIdRef == null) {
                NodeList nvpairsMA;
                String metaAttrsId = this.getAttribute(metaAttrsNode, "id");
                metaAttrsIdMap.put(groupId, metaAttrsId);
                metaAttrsIdToCRMId.put(metaAttrsId, groupId);
                if (Tools.versionBeforePacemaker(this.host)) {
                    Node attrsNode = this.getChildNode(metaAttrsNode, "attributes");
                    nvpairsMA = attrsNode.getChildNodes();
                } else {
                    nvpairsMA = metaAttrsNode.getChildNodes();
                }
                for (int l = 0; l < nvpairsMA.getLength(); ++l) {
                    Node maNode = nvpairsMA.item(l);
                    if (!maNode.getNodeName().equals("nvpair")) continue;
                    String nvpairId = this.getAttribute(maNode, "id");
                    String name = this.getAttribute(maNode, "name");
                    String value = this.getAttribute(maNode, "value");
                    if (TARGET_ROLE_META_ATTR.equals(name)) {
                        value = value.toLowerCase(Locale.US);
                    }
                    if (ORDERED_META_ATTR.equals(name)) {
                        name = GROUP_ORDERED_META_ATTR;
                    }
                    params.put(name, value);
                    nvpairIds.put(name, nvpairId);
                }
            } else {
                metaAttrsIdRefs.put(groupId, metaAttrsIdRef);
            }
        }
    }

    private void parsePrimitive(Node primitiveNode, List<String> groupResList, Map<String, ResourceAgent> resourceTypeMap, Map<String, Map<String, String>> parametersMap, Map<String, Map<String, String>> parametersNvpairsIdsMap, Map<String, String> resourceInstanceAttrIdMap, MultiKeyMap<String, String> operationsMap, Map<String, String> metaAttrsIdMap, Map<String, String> operationsIdMap, Map<String, Map<String, String>> resOpIdsMap, Map<String, String> operationsIdRefs, Map<String, String> operationsIdtoCRMId, Map<String, String> metaAttrsIdRefs, Map<String, String> metaAttrsIdToCRMId) {
        String raClass = this.getAttribute(primitiveNode, "class");
        String crmId = this.getAttribute(primitiveNode, "id");
        String provider = this.getAttribute(primitiveNode, "provider");
        if (provider == null) {
            provider = "heartbeat";
        }
        String type = this.getAttribute(primitiveNode, "type");
        resourceTypeMap.put(crmId, this.getResourceAgent(type, provider, raClass));
        groupResList.add(crmId);
        this.parseAttributes(primitiveNode, crmId, parametersMap, parametersNvpairsIdsMap, resourceInstanceAttrIdMap, operationsMap, metaAttrsIdMap, operationsIdMap, resOpIdsMap, operationsIdRefs, operationsIdtoCRMId, metaAttrsIdRefs, metaAttrsIdToCRMId, "stonith".equals(raClass));
    }

    private Map<String, String> parseAllocationScores(String res, NodeList scores) {
        LinkedHashMap<String, String> allocationScores = new LinkedHashMap<String, String>();
        for (int i = 0; i < scores.getLength(); ++i) {
            Node scoreNode = scores.item(i);
            if (!scoreNode.getNodeName().equals(SCORE_STRING)) continue;
            String host = this.getAttribute(scoreNode, "host");
            String score = this.getAttribute(scoreNode, SCORE_STRING);
            allocationScores.put(host, score);
        }
        return allocationScores;
    }

    Map<String, ResStatus> parseResStatus(String resStatus) {
        HashMap<String, ResStatus> resStatusMap = new HashMap<String, ResStatus>();
        Document document = this.getXMLDocument(resStatus);
        if (document == null) {
            return null;
        }
        Node statusNode = this.getChildNode(document, "resource_status");
        if (statusNode == null) {
            return null;
        }
        NodeList resources = statusNode.getChildNodes();
        for (int i = 0; i < resources.getLength(); ++i) {
            Node resourceNode = resources.item(i);
            if (!resourceNode.getNodeName().equals("resource")) continue;
            String id = this.getAttribute(resourceNode, "id");
            String isManaged = this.getAttribute(resourceNode, "managed");
            NodeList statusList = resourceNode.getChildNodes();
            ArrayList<String> runningOnList = null;
            ArrayList<String> masterOnList = null;
            ArrayList<String> slaveOnList = null;
            boolean managed = false;
            if ("managed".equals(isManaged)) {
                managed = true;
            }
            Map<String, String> allocationScores = new HashMap<String, String>();
            for (int j = 0; j < statusList.getLength(); ++j) {
                String node;
                Node setNode = statusList.item(j);
                if (TARGET_ROLE_STARTED.equalsIgnoreCase(setNode.getNodeName())) {
                    node = this.getText(setNode);
                    if (runningOnList == null) {
                        runningOnList = new ArrayList<String>();
                    }
                    runningOnList.add(node);
                    continue;
                }
                if (TARGET_ROLE_MASTER.equalsIgnoreCase(setNode.getNodeName())) {
                    node = this.getText(setNode);
                    if (masterOnList == null) {
                        masterOnList = new ArrayList<String>();
                    }
                    masterOnList.add(node);
                    continue;
                }
                if (TARGET_ROLE_SLAVE.equalsIgnoreCase(setNode.getNodeName())) {
                    node = this.getText(setNode);
                    if (slaveOnList == null) {
                        slaveOnList = new ArrayList<String>();
                    }
                    slaveOnList.add(node);
                    continue;
                }
                if (!"scores".equals(setNode.getNodeName())) continue;
                allocationScores = this.parseAllocationScores(id, setNode.getChildNodes());
            }
            resStatusMap.put(id, new ResStatus(runningOnList, masterOnList, slaveOnList, allocationScores, managed));
        }
        return resStatusMap;
    }

    private void parseTransientAttributes(String uname, Node transientAttrNode, MultiKeyMap<String, String> failedMap, MultiKeyMap<String, Set<String>> failedClonesMap, Map<String, String> pingCountMap) {
        Node instanceAttrNode = this.getChildNode(transientAttrNode, "instance_attributes");
        if (instanceAttrNode != null) {
            NodeList nvpairsRes;
            if (Tools.versionBeforePacemaker(this.host)) {
                Node attrNode = this.getChildNode(instanceAttrNode, "attributes");
                nvpairsRes = attrNode.getChildNodes();
            } else {
                nvpairsRes = instanceAttrNode.getChildNodes();
            }
            for (int j = 0; j < nvpairsRes.getLength(); ++j) {
                Node optionNode = nvpairsRes.item(j);
                if (!optionNode.getNodeName().equals("nvpair")) continue;
                String name = this.getAttribute(optionNode, "name");
                String value = this.getAttribute(optionNode, "value");
                if ("pingd".equals(name)) {
                    pingCountMap.put(uname, value);
                    continue;
                }
                if (name.indexOf(FAIL_COUNT_PREFIX) != 0) continue;
                String resId = name.substring(FAIL_COUNT_PREFIX.length());
                String unameLowerCase = uname.toLowerCase(Locale.US);
                failedMap.put(unameLowerCase, resId, value);
                Pattern p = Pattern.compile("(.*):(\\d+)$");
                Matcher m = p.matcher(resId);
                if (!m.matches()) continue;
                String crmId = m.group(1);
                Set<String> clones = failedClonesMap.get((K[])new String[]{unameLowerCase, crmId});
                if (clones == null) {
                    clones = new LinkedHashSet<String>();
                    failedClonesMap.put(unameLowerCase, crmId, clones);
                }
                clones.add(m.group(2));
                failedMap.put(uname.toLowerCase(Locale.US), crmId, value);
            }
        }
    }

    void parseNode(String node, Node nodeNode, MultiKeyMap<String, String> nodeParametersMap) {
        Node instanceAttrNode = this.getChildNode(nodeNode, "instance_attributes");
        if (instanceAttrNode != null) {
            NodeList nvpairsRes;
            if (Tools.versionBeforePacemaker(this.host)) {
                Node attrNode = this.getChildNode(instanceAttrNode, "attributes");
                nvpairsRes = attrNode.getChildNodes();
            } else {
                nvpairsRes = instanceAttrNode.getChildNodes();
            }
            for (int j = 0; j < nvpairsRes.getLength(); ++j) {
                Node optionNode = nvpairsRes.item(j);
                if (!optionNode.getNodeName().equals("nvpair")) continue;
                String name = this.getAttribute(optionNode, "name");
                String value = this.getAttribute(optionNode, "value");
                nodeParametersMap.put(node.toLowerCase(Locale.US), name, value);
            }
        }
    }

    private void parseRscSets(Node node, String colId, String ordId, List<RscSet> rscSets, List<RscSetConnectionData> rscSetConnections) {
        NodeList nodes = node.getChildNodes();
        RscSet prevRscSet = null;
        int rscSetCount = 0;
        int ordPos = 0;
        int colPos = 0;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node rscSetNode = nodes.item(i);
            if (!rscSetNode.getNodeName().equals("resource_set")) continue;
            String id = this.getAttribute(rscSetNode, "id");
            String sequential = this.getAttribute(rscSetNode, "sequential");
            String requireAll = this.getAttribute(rscSetNode, REQUIRE_ALL_ATTR);
            String orderAction = this.getAttribute(rscSetNode, FENCING_ACTION_PARAM);
            String colocationRole = this.getAttribute(rscSetNode, "role");
            NodeList rscNodes = rscSetNode.getChildNodes();
            ArrayList<String> rscIds = new ArrayList<String>();
            for (int j = 0; j < rscNodes.getLength(); ++j) {
                Node rscRefNode = rscNodes.item(j);
                if (!rscRefNode.getNodeName().equals("resource_ref")) continue;
                String rscId = this.getAttribute(rscRefNode, "id");
                rscIds.add(rscId);
            }
            RscSet rscSet = new RscSet(id, rscIds, sequential, requireAll, orderAction, colocationRole);
            rscSets.add(rscSet);
            if (prevRscSet != null) {
                RscSetConnectionData rscSetConnectionData;
                if (colId == null) {
                    rscSetConnectionData = new RscSetConnectionData(prevRscSet, rscSet, ordId, ordPos, false);
                    ++ordPos;
                    rscSetConnections.add(0, rscSetConnectionData);
                } else {
                    rscSetConnectionData = new RscSetConnectionData(rscSet, prevRscSet, colId, colPos, true);
                    ++colPos;
                    rscSetConnections.add(rscSetConnectionData);
                }
            }
            prevRscSet = rscSet;
            ++rscSetCount;
        }
        if (rscSetCount == 1) {
            RscSetConnectionData rscSetConnectionData = colId == null ? new RscSetConnectionData(prevRscSet, null, ordId, ordPos, false) : new RscSetConnectionData(prevRscSet, null, colId, colPos, true);
            rscSetConnections.add(rscSetConnectionData);
        }
    }

    CibQuery parseCibQuery(String query) {
        Node resourcesNode;
        Node crmConfNode;
        Node cibNode;
        Document document = this.getXMLDocument(query);
        CibQuery cibQueryData = new CibQuery();
        if (document == null) {
            Tools.appWarning("cib error: " + query);
            return cibQueryData;
        }
        Node pcmkNode = this.getChildNode(document, "pcmk");
        if (pcmkNode == null) {
            Tools.appWarning("there is no pcmk node");
            return cibQueryData;
        }
        HashSet<String> fencedNodes = new HashSet<String>();
        Node fencedNode = this.getChildNode(pcmkNode, "fenced");
        if (fencedNode != null) {
            NodeList nodes = fencedNode.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                String host;
                Node hostNode = nodes.item(i);
                if (!hostNode.getNodeName().equals("node") || (host = this.getText(hostNode)) == null) continue;
                fencedNodes.add(host.toLowerCase(Locale.US));
            }
        }
        if ((cibNode = this.getChildNode(pcmkNode, "cib")) == null) {
            Tools.appWarning("there is no cib node");
            return cibQueryData;
        }
        String dcUuid = this.getAttribute(cibNode, "dc-uuid");
        Node confNode = this.getChildNode(cibNode, "configuration");
        if (confNode == null) {
            Tools.appWarning("there is no configuration node");
            return cibQueryData;
        }
        Node rscDefaultsNode = this.getChildNode(confNode, "rsc_defaults");
        String rscDefaultsId = null;
        HashMap<String, String> rscDefaultsParams = new HashMap<String, String>();
        HashMap<String, String> rscDefaultsParamsNvpairIds = new HashMap<String, String>();
        if (rscDefaultsNode != null) {
            rscDefaultsId = this.parseRscDefaults(rscDefaultsNode, rscDefaultsParams, rscDefaultsParamsNvpairIds);
        }
        Node opDefaultsNode = this.getChildNode(confNode, "op_defaults");
        HashMap<String, String> opDefaultsParams = new HashMap<String, String>();
        if (opDefaultsNode != null) {
            this.parseOpDefaults(opDefaultsNode, opDefaultsParams);
        }
        if ((crmConfNode = this.getChildNode(confNode, "crm_config")) == null) {
            Tools.appWarning("there is no crm_config node");
            return cibQueryData;
        }
        Node cpsNode = this.getChildNode(crmConfNode, "cluster_property_set");
        if (cpsNode == null) {
            Tools.appWarning("there is no cluster_property_set node");
        } else {
            NodeList nvpairs;
            if (Tools.versionBeforePacemaker(this.host)) {
                Node attrNode = this.getChildNode(cpsNode, "attributes");
                nvpairs = attrNode.getChildNodes();
            } else {
                nvpairs = cpsNode.getChildNodes();
            }
            HashMap<String, String> crmConfMap = new HashMap<String, String>();
            for (int i = 0; i < nvpairs.getLength(); ++i) {
                Node optionNode = nvpairs.item(i);
                if (!optionNode.getNodeName().equals("nvpair")) continue;
                String name = this.getAttribute(optionNode, "name");
                String value = this.getAttribute(optionNode, "value");
                crmConfMap.put(name, value);
            }
            cibQueryData.setCrmConfig(crmConfMap);
        }
        String dc = null;
        MultiKeyMap<String, String> nodeParametersMap = new MultiKeyMap<String, String>();
        Node nodesNode = this.getChildNode(confNode, "nodes");
        HashMap<String, String> nodeOnline = new HashMap<String, String>();
        HashMap<String, String> nodeID = new HashMap<String, String>();
        if (nodesNode != null) {
            NodeList nodes = nodesNode.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node nodeNode = nodes.item(i);
                if (!nodeNode.getNodeName().equals("node")) continue;
                String id = this.getAttribute(nodeNode, "id");
                String uname = this.getAttribute(nodeNode, "uname");
                if (!nodeID.containsKey(uname)) {
                    nodeID.put(uname, id);
                }
                if (dcUuid != null && dcUuid.equals(id)) {
                    dc = uname;
                }
                this.parseNode(uname, nodeNode, nodeParametersMap);
                if (nodeOnline.containsKey(uname.toLowerCase(Locale.US))) continue;
                nodeOnline.put(uname.toLowerCase(Locale.US), "no");
            }
        }
        if ((resourcesNode = this.getChildNode(confNode, "resources")) == null) {
            Tools.appWarning("there is no resources node");
            return cibQueryData;
        }
        HashMap<String, Map<String, String>> parametersMap = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, String>> parametersNvpairsIdsMap = new HashMap<String, Map<String, String>>();
        HashMap<String, ResourceAgent> resourceTypeMap = new HashMap<String, ResourceAgent>();
        HashSet<String> orphanedList = new HashSet<String>();
        HashMap<String, Set<String>> inLRMList = new HashMap<String, Set<String>>();
        HashMap<String, String> resourceInstanceAttrIdMap = new HashMap<String, String>();
        MultiKeyMap<String, String> operationsMap = new MultiKeyMap<String, String>();
        HashMap<String, String> metaAttrsIdMap = new HashMap<String, String>();
        HashMap<String, String> operationsIdMap = new HashMap<String, String>();
        HashMap<String, Map<String, String>> resOpIdsMap = new HashMap<String, Map<String, String>>();
        LinkedHashMap<String, List<String>> groupsToResourcesMap = new LinkedHashMap<String, List<String>>();
        HashMap<String, String> cloneToResourceMap = new HashMap<String, String>();
        ArrayList<String> masterList = new ArrayList<String>();
        MultiKeyMap<String, String> failedMap = new MultiKeyMap<String, String>();
        MultiKeyMap<String, Set<String>> failedClonesMap = new MultiKeyMap<String, Set<String>>();
        HashMap<String, String> pingCountMap = new HashMap<String, String>();
        groupsToResourcesMap.put("none", new ArrayList());
        NodeList primitivesGroups = resourcesNode.getChildNodes();
        HashMap<String, String> operationsIdRefs = new HashMap<String, String>();
        HashMap<String, String> operationsIdtoCRMId = new HashMap<String, String>();
        HashMap<String, String> metaAttrsIdRefs = new HashMap<String, String>();
        HashMap<String, String> metaAttrsIdToCRMId = new HashMap<String, String>();
        for (int i = 0; i < primitivesGroups.getLength(); ++i) {
            Node primitiveGroupNode = primitivesGroups.item(i);
            String nodeName = primitiveGroupNode.getNodeName();
            if ("primitive".equals(nodeName)) {
                List resList = (List)groupsToResourcesMap.get("none");
                this.parsePrimitive(primitiveGroupNode, resList, resourceTypeMap, parametersMap, parametersNvpairsIdsMap, resourceInstanceAttrIdMap, operationsMap, metaAttrsIdMap, operationsIdMap, resOpIdsMap, operationsIdRefs, operationsIdtoCRMId, metaAttrsIdRefs, metaAttrsIdToCRMId);
                continue;
            }
            if ("group".equals(nodeName)) {
                this.parseGroup(primitiveGroupNode, null, groupsToResourcesMap, parametersMap, resourceTypeMap, parametersNvpairsIdsMap, resourceInstanceAttrIdMap, operationsMap, metaAttrsIdMap, operationsIdMap, resOpIdsMap, operationsIdRefs, operationsIdtoCRMId, metaAttrsIdRefs, metaAttrsIdToCRMId);
                continue;
            }
            if (!TARGET_ROLE_MASTER.equals(nodeName) && !"master_slave".equals(nodeName) && !"clone".equals(nodeName)) continue;
            NodeList primitives = primitiveGroupNode.getChildNodes();
            String cloneId = this.getAttribute(primitiveGroupNode, "id");
            ArrayList<String> resList = (ArrayList<String>)groupsToResourcesMap.get(cloneId);
            if (resList == null) {
                resList = new ArrayList<String>();
                groupsToResourcesMap.put(cloneId, resList);
            }
            this.parseAttributes(primitiveGroupNode, cloneId, parametersMap, parametersNvpairsIdsMap, resourceInstanceAttrIdMap, operationsMap, metaAttrsIdMap, operationsIdMap, resOpIdsMap, operationsIdRefs, operationsIdtoCRMId, metaAttrsIdRefs, metaAttrsIdToCRMId, false);
            for (int j = 0; j < primitives.getLength(); ++j) {
                Node primitiveNode = primitives.item(j);
                if (primitiveNode.getNodeName().equals("primitive")) {
                    this.parsePrimitive(primitiveNode, resList, resourceTypeMap, parametersMap, parametersNvpairsIdsMap, resourceInstanceAttrIdMap, operationsMap, metaAttrsIdMap, operationsIdMap, resOpIdsMap, operationsIdRefs, operationsIdtoCRMId, metaAttrsIdRefs, metaAttrsIdToCRMId);
                    continue;
                }
                if (!primitiveNode.getNodeName().equals("group")) continue;
                this.parseGroup(primitiveNode, resList, groupsToResourcesMap, parametersMap, resourceTypeMap, parametersNvpairsIdsMap, resourceInstanceAttrIdMap, operationsMap, metaAttrsIdMap, operationsIdMap, resOpIdsMap, operationsIdRefs, operationsIdtoCRMId, metaAttrsIdRefs, metaAttrsIdToCRMId);
            }
            if (resList.isEmpty()) continue;
            cloneToResourceMap.put(cloneId, (String)resList.get(0));
            if (!TARGET_ROLE_MASTER.equals(nodeName) && !"master_slave".equals(nodeName)) continue;
            masterList.add(cloneId);
        }
        HashMap<String, String> operationsRefs = new HashMap<String, String>();
        for (String crmId : operationsIdRefs.keySet()) {
            String idRef = (String)operationsIdRefs.get(crmId);
            operationsRefs.put(crmId, (String)operationsIdtoCRMId.get(idRef));
        }
        HashMap<String, String> metaAttrsRefs = new HashMap<String, String>();
        for (String crmId : metaAttrsIdRefs.keySet()) {
            String idRef = (String)metaAttrsIdRefs.get(crmId);
            metaAttrsRefs.put(crmId, (String)metaAttrsIdToCRMId.get(idRef));
        }
        LinkedHashMap<String, ColocationData> colocationIdMap = new LinkedHashMap<String, ColocationData>();
        HashMap<String, List<ColocationData>> colocationRscMap = new HashMap<String, List<ColocationData>>();
        LinkedHashMap<String, OrderData> orderIdMap = new LinkedHashMap<String, OrderData>();
        HashMap<String, List<RscSet>> orderIdRscSetsMap = new HashMap<String, List<RscSet>>();
        HashMap<String, List<RscSet>> colocationIdRscSetsMap = new HashMap<String, List<RscSet>>();
        ArrayList<RscSetConnectionData> rscSetConnections = new ArrayList<RscSetConnectionData>();
        HashMap<String, List<OrderData>> orderRscMap = new HashMap<String, List<OrderData>>();
        HashMap<String, Map<String, HostLocation>> locationMap = new HashMap<String, Map<String, HostLocation>>();
        HashMap<String, HostLocation> pingLocationMap = new HashMap<String, HostLocation>();
        HashMap<String, List<String>> locationsIdMap = new HashMap<String, List<String>>();
        MultiKeyMap<String, String> resHostToLocIdMap = new MultiKeyMap<String, String>();
        HashMap<String, String> resPingToLocIdMap = new HashMap<String, String>();
        Node constraintsNode = this.getChildNode(confNode, "constraints");
        if (constraintsNode != null) {
            NodeList constraints = constraintsNode.getChildNodes();
            String rscString = "rsc";
            String rscRoleString = "rsc-role";
            String withRscString = "with-rsc";
            String withRscRoleString = "with-rsc-role";
            String firstString = "first";
            String thenString = "then";
            String firstActionString = "first-action";
            String thenActionString = "then-action";
            if (Tools.versionBeforePacemaker(this.host)) {
                rscString = "from";
                rscRoleString = "from_role";
                withRscString = "to";
                withRscRoleString = "to_role";
                firstString = "to";
                thenString = "from";
                firstActionString = "to_action";
                thenActionString = FENCING_ACTION_PARAM;
            }
            for (int i = 0; i < constraints.getLength(); ++i) {
                HashMap<String, HostLocation> hostScoreMap;
                String score;
                ArrayList<RscSet> rscSets;
                Node constraintNode = constraints.item(i);
                if (constraintNode.getNodeName().equals("rsc_colocation")) {
                    String colId = this.getAttribute(constraintNode, "id");
                    String rsc = this.getAttribute(constraintNode, rscString);
                    String withRsc = this.getAttribute(constraintNode, withRscString);
                    if (rsc == null || withRsc == null) {
                        rscSets = new ArrayList<RscSet>();
                        this.parseRscSets(constraintNode, colId, null, rscSets, rscSetConnections);
                        colocationIdRscSetsMap.put(colId, rscSets);
                    }
                    String rscRole = this.getAttribute(constraintNode, rscRoleString);
                    String withRscRole = this.getAttribute(constraintNode, withRscRoleString);
                    String score2 = this.getAttribute(constraintNode, SCORE_STRING);
                    ColocationData colocationData = new ColocationData(colId, rsc, withRsc, rscRole, withRscRole, score2);
                    colocationIdMap.put(colId, colocationData);
                    ArrayList<ColocationData> withs = (ArrayList<ColocationData>)colocationRscMap.get(rsc);
                    if (withs == null) {
                        withs = new ArrayList<ColocationData>();
                    }
                    withs.add(colocationData);
                    colocationRscMap.put(rsc, withs);
                    continue;
                }
                if (constraintNode.getNodeName().equals("rsc_order")) {
                    String rscFirst = this.getAttribute(constraintNode, firstString);
                    String rscThen = this.getAttribute(constraintNode, thenString);
                    String ordId = this.getAttribute(constraintNode, "id");
                    if (rscFirst == null || rscThen == null) {
                        rscSets = new ArrayList();
                        this.parseRscSets(constraintNode, null, ordId, rscSets, rscSetConnections);
                        orderIdRscSetsMap.put(ordId, rscSets);
                    }
                    score = this.getAttribute(constraintNode, SCORE_STRING);
                    String symmetrical = this.getAttribute(constraintNode, "symmetrical");
                    String firstAction = this.getAttribute(constraintNode, firstActionString);
                    String thenAction = this.getAttribute(constraintNode, thenActionString);
                    String type = this.getAttribute(constraintNode, "type");
                    if (type != null && "before".equals(type)) {
                        String rsc = rscFirst;
                        rscFirst = rscThen;
                        rscThen = rsc;
                        String act = firstAction;
                        firstAction = thenAction;
                        thenAction = act;
                    }
                    OrderData orderData = new OrderData(ordId, rscFirst, rscThen, score, symmetrical, firstAction, thenAction);
                    orderIdMap.put(ordId, orderData);
                    ArrayList<OrderData> thens = (ArrayList<OrderData>)orderRscMap.get(rscFirst);
                    if (thens == null) {
                        thens = new ArrayList<OrderData>();
                    }
                    thens.add(orderData);
                    orderRscMap.put(rscFirst, thens);
                    continue;
                }
                if (!"rsc_location".equals(constraintNode.getNodeName())) continue;
                String locId = this.getAttribute(constraintNode, "id");
                String node = this.getAttribute(constraintNode, "node");
                String rsc = this.getAttribute(constraintNode, "rsc");
                score = this.getAttribute(constraintNode, SCORE_STRING);
                String role = null;
                ArrayList<String> locs = (ArrayList<String>)locationsIdMap.get(rsc);
                if (locs == null) {
                    locs = new ArrayList<String>();
                    locationsIdMap.put(rsc, locs);
                }
                if ((hostScoreMap = (HashMap<String, HostLocation>)locationMap.get(rsc)) == null) {
                    hostScoreMap = new HashMap<String, HostLocation>();
                    locationMap.put(rsc, hostScoreMap);
                }
                if (node != null) {
                    resHostToLocIdMap.put(rsc, node.toLowerCase(Locale.US), locId);
                }
                if (score != null) {
                    hostScoreMap.put(node.toLowerCase(Locale.US), new HostLocation(score, "eq", null, role));
                }
                locs.add(locId);
                Node ruleNode = this.getChildNode(constraintNode, "rule");
                if (ruleNode == null) continue;
                String score2 = this.getAttribute(ruleNode, SCORE_STRING);
                String booleanOp = this.getAttribute(ruleNode, "boolean-op");
                Node expNode = this.getChildNode(ruleNode, "expression");
                if (expNode == null || !"expression".equals(expNode.getNodeName())) continue;
                String attr = this.getAttribute(expNode, "attribute");
                String op = this.getAttribute(expNode, "operation");
                String type = this.getAttribute(expNode, "type");
                String value = this.getAttribute(expNode, "value");
                if ((booleanOp == null || "and".equals(booleanOp)) && "#uname".equals(attr)) {
                    hostScoreMap.put(value.toLowerCase(Locale.US), new HostLocation(score2, op, null, role));
                    resHostToLocIdMap.put(rsc, value.toLowerCase(Locale.US), locId);
                    continue;
                }
                if ((booleanOp == null || "and".equals(booleanOp)) && "pingd".equals(attr)) {
                    pingLocationMap.put(rsc, new HostLocation(score2, op, value, null));
                    resPingToLocIdMap.put(rsc, locId);
                    continue;
                }
                Tools.appWarning("could not parse rsc_location: " + locId);
            }
        }
        Node statusNode = this.getChildNode(cibNode, "status");
        HashSet<String> nodePending = new HashSet<String>();
        if (statusNode != null) {
            String hbV = this.host.getHeartbeatVersion();
            NodeList nodes = statusNode.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node nodeStateNode = nodes.item(i);
                if (!"node_state".equals(nodeStateNode.getNodeName())) continue;
                String uname = this.getAttribute(nodeStateNode, "uname");
                String id = this.getAttribute(nodeStateNode, "id");
                if (!id.equals(nodeID.get(uname))) {
                    Tools.appWarning("skipping " + uname + " " + id);
                }
                String ha = this.getAttribute(nodeStateNode, "ha");
                String join = this.getAttribute(nodeStateNode, "join");
                String inCCM = this.getAttribute(nodeStateNode, "in_ccm");
                String crmd = this.getAttribute(nodeStateNode, "crmd");
                if ("member".equals(join) && "true".equals(inCCM) && !"offline".equals(crmd)) {
                    nodeOnline.put(uname.toLowerCase(Locale.US), "yes");
                } else {
                    nodeOnline.put(uname.toLowerCase(Locale.US), "no");
                }
                if ("pending".equals(join)) {
                    nodePending.add(uname.toLowerCase(Locale.US));
                }
                NodeList nodeStates = nodeStateNode.getChildNodes();
                for (int j = 0; j < nodeStates.getLength(); ++j) {
                    Node nodeStateChild = nodeStates.item(j);
                    if (!"transient_attributes".equals(nodeStateChild.getNodeName())) continue;
                    this.parseTransientAttributes(uname, nodeStateChild, failedMap, failedClonesMap, pingCountMap);
                }
                List resList = (List)groupsToResourcesMap.get("none");
                for (int j = 0; j < nodeStates.getLength(); ++j) {
                    Node nodeStateChild = nodeStates.item(j);
                    if (!"lrm".equals(nodeStateChild.getNodeName())) continue;
                    this.parseLRM(uname.toLowerCase(Locale.US), nodeStateChild, resList, resourceTypeMap, parametersMap, inLRMList, orphanedList, failedClonesMap);
                }
            }
        }
        cibQueryData.setDC(dc);
        cibQueryData.setNodeParameters(nodeParametersMap);
        cibQueryData.setParameters(parametersMap);
        cibQueryData.setParametersNvpairsIds(parametersNvpairsIdsMap);
        cibQueryData.setResourceType(resourceTypeMap);
        cibQueryData.setInLRM(inLRMList);
        cibQueryData.setOrphaned(orphanedList);
        cibQueryData.setResourceInstanceAttrId(resourceInstanceAttrIdMap);
        cibQueryData.setColocationRsc(colocationRscMap);
        cibQueryData.setColocationId(colocationIdMap);
        cibQueryData.setOrderId(orderIdMap);
        cibQueryData.setOrderIdRscSets(orderIdRscSetsMap);
        cibQueryData.setColocationIdRscSets(colocationIdRscSetsMap);
        cibQueryData.setRscSetConnections(rscSetConnections);
        cibQueryData.setOrderRsc(orderRscMap);
        cibQueryData.setLocation(locationMap);
        cibQueryData.setPingLocation(pingLocationMap);
        cibQueryData.setLocationsId(locationsIdMap);
        cibQueryData.setResHostToLocId(resHostToLocIdMap);
        cibQueryData.setResPingToLocId(resPingToLocIdMap);
        cibQueryData.setOperations(operationsMap);
        cibQueryData.setOperationsId(operationsIdMap);
        cibQueryData.setOperationsRefs(operationsRefs);
        cibQueryData.setMetaAttrsId(metaAttrsIdMap);
        cibQueryData.setMetaAttrsRefs(metaAttrsRefs);
        cibQueryData.setResOpIds(resOpIdsMap);
        cibQueryData.setNodeOnline(nodeOnline);
        cibQueryData.setNodePending(nodePending);
        cibQueryData.setGroupsToResources(groupsToResourcesMap);
        cibQueryData.setCloneToResource(cloneToResourceMap);
        cibQueryData.setMasterList(masterList);
        cibQueryData.setFailed(failedMap);
        cibQueryData.setFailedClones(failedClonesMap);
        cibQueryData.setPingCount(pingCountMap);
        cibQueryData.setRscDefaultsId(rscDefaultsId);
        cibQueryData.setRscDefaultsParams(rscDefaultsParams);
        cibQueryData.setRscDefaultsParamsNvpairIds(rscDefaultsParamsNvpairIds);
        cibQueryData.setOpDefaultsParams(opDefaultsParams);
        cibQueryData.setFencedNodes(fencedNodes);
        return cibQueryData;
    }

    public String[] getOrderParameters() {
        if (this.ordParams != null) {
            return this.ordParams.toArray(new String[this.ordParams.size()]);
        }
        return null;
    }

    public String[] getRscSetOrderParameters() {
        if (this.rscSetOrdParams != null) {
            return this.rscSetOrdParams.toArray(new String[this.rscSetOrdParams.size()]);
        }
        return null;
    }

    public String[] getRscSetOrdConnectionParameters() {
        if (this.rscSetOrdConnectionParams != null) {
            return this.rscSetOrdConnectionParams.toArray(new String[this.rscSetOrdConnectionParams.size()]);
        }
        return null;
    }

    public boolean isOrderRequired(String param) {
        return this.ordRequiredParams.contains(param);
    }

    public String getOrderParamShortDesc(String param) {
        String shortDesc = this.paramOrdShortDescMap.get(param);
        if (shortDesc == null) {
            shortDesc = param;
        }
        return shortDesc;
    }

    public String getOrderParamLongDesc(String param) {
        String shortDesc = this.getOrderParamShortDesc(param);
        String longDesc = this.paramOrdLongDescMap.get(param);
        if (longDesc == null) {
            longDesc = "";
        }
        return Tools.html("<b>" + shortDesc + "</b>\n" + longDesc);
    }

    public String getOrderParamType(String param) {
        return this.paramOrdTypeMap.get(param);
    }

    public String getOrderParamDefault(String param) {
        return this.paramOrdDefaultMap.get(param);
    }

    public String getOrderParamPreferred(String param) {
        return this.paramOrdPreferredMap.get(param);
    }

    public String[] getOrderParamPossibleChoices(String param, boolean ms) {
        if (ms) {
            return this.paramOrdPossibleChoicesMS.get(param);
        }
        return this.paramOrdPossibleChoices.get(param);
    }

    public boolean isOrderInteger(String param) {
        String type = this.getOrderParamType(param);
        return PARAM_TYPE_INTEGER.equals(type);
    }

    public boolean isOrderLabel(String param) {
        String type = this.getOrderParamType(param);
        return PARAM_TYPE_LABEL.equals(type);
    }

    public boolean isOrderBoolean(String param) {
        String type = this.getOrderParamType(param);
        return PARAM_TYPE_BOOLEAN.equals(type);
    }

    public boolean isOrderTimeType(String param) {
        String type = this.getOrderParamType(param);
        return PARAM_TYPE_TIME.equals(type);
    }

    public String getOrderSection(String param) {
        return Tools.getString("CRMXML.OrderSectionParams");
    }

    public boolean checkOrderParam(String param, String value) {
        String type = this.getOrderParamType(param);
        boolean correctValue = true;
        if (PARAM_TYPE_BOOLEAN.equals(type)) {
            if (!("yes".equals(value) || "no".equals(value) || "true".equals(value) || "false".equals(value) || "True".equals(value) || "False".equals(value))) {
                correctValue = false;
            }
        } else if (PARAM_TYPE_INTEGER.equals(type)) {
            Pattern p = Pattern.compile("^(-?\\d*|(-|\\+)?INFINITY)$");
            Matcher m = p.matcher(value);
            if (!m.matches()) {
                correctValue = false;
            }
        } else if (PARAM_TYPE_TIME.equals(type)) {
            Pattern p = Pattern.compile("^-?\\d*(ms|msec|us|usec|s|sec|m|min|h|hr)?$");
            Matcher m = p.matcher(value);
            if (!m.matches()) {
                correctValue = false;
            }
        } else if ((value == null || "".equals(value)) && this.isOrderRequired(param)) {
            correctValue = false;
        }
        return correctValue;
    }

    public String[] getColocationParameters() {
        if (this.colParams != null) {
            return this.colParams.toArray(new String[this.colParams.size()]);
        }
        return null;
    }

    public String[] getRscSetColocationParameters() {
        if (this.rscSetColParams != null) {
            return this.rscSetColParams.toArray(new String[this.rscSetColParams.size()]);
        }
        return null;
    }

    public String[] getRscSetColConnectionParameters() {
        if (this.rscSetColConnectionParams != null) {
            return this.rscSetColConnectionParams.toArray(new String[this.rscSetColConnectionParams.size()]);
        }
        return null;
    }

    public boolean isColocationRequired(String param) {
        return this.colRequiredParams.contains(param);
    }

    public String getColocationParamShortDesc(String param) {
        String shortDesc = this.paramColShortDescMap.get(param);
        if (shortDesc == null) {
            shortDesc = param;
        }
        return shortDesc;
    }

    public String getColocationParamLongDesc(String param) {
        String shortDesc = this.getColocationParamShortDesc(param);
        String longDesc = this.paramColLongDescMap.get(param);
        if (longDesc == null) {
            longDesc = "";
        }
        return Tools.html("<b>" + shortDesc + "</b>\n" + longDesc);
    }

    public String getColocationParamType(String param) {
        return this.paramColTypeMap.get(param);
    }

    public String getColocationParamDefault(String param) {
        return this.paramColDefaultMap.get(param);
    }

    public String getColocationParamPreferred(String param) {
        return this.paramColPreferredMap.get(param);
    }

    public String[] getColocationParamPossibleChoices(String param, boolean ms) {
        if (ms) {
            return this.paramColPossibleChoicesMS.get(param);
        }
        return this.paramColPossibleChoices.get(param);
    }

    public boolean isColocationInteger(String param) {
        String type = this.getColocationParamType(param);
        return PARAM_TYPE_INTEGER.equals(type);
    }

    public boolean isColocationLabel(String param) {
        String type = this.getColocationParamType(param);
        return PARAM_TYPE_LABEL.equals(type);
    }

    public boolean isColocationBoolean(String param) {
        String type = this.getOrderParamType(param);
        return PARAM_TYPE_BOOLEAN.equals(type);
    }

    public boolean isColocationTimeType(String param) {
        String type = this.getColocationParamType(param);
        return PARAM_TYPE_TIME.equals(type);
    }

    public String getColocationSection(String param) {
        return Tools.getString("CRMXML.ColocationSectionParams");
    }

    public boolean checkColocationParam(String param, String value) {
        String type = this.getColocationParamType(param);
        boolean correctValue = true;
        if (PARAM_TYPE_BOOLEAN.equals(type)) {
            if (!("yes".equals(value) || "no".equals(value) || "true".equals(value) || "false".equals(value) || "True".equals(value) || "False".equals(value))) {
                correctValue = false;
            }
        } else if (PARAM_TYPE_INTEGER.equals(type)) {
            Pattern p = Pattern.compile("^(-?\\d*|(-|\\+)?INFINITY)$");
            Matcher m = p.matcher(value);
            if (!m.matches()) {
                correctValue = false;
            }
        } else if (PARAM_TYPE_TIME.equals(type)) {
            Pattern p = Pattern.compile("^-?\\d*(ms|msec|us|usec|s|sec|m|min|h|hr)?$");
            Matcher m = p.matcher(value);
            if (!m.matches()) {
                correctValue = false;
            }
        } else if ((value == null || "".equals(value)) && this.isColocationRequired(param)) {
            correctValue = false;
        }
        return correctValue;
    }

    public boolean isDrbddiskPresent() {
        return this.drbddiskPresent;
    }

    public boolean isLinbitDrbdPresent() {
        return this.linbitDrbdPresent;
    }

    void parseLRM(String unameLowerCase, Node lrmNode, List<String> resList, Map<String, ResourceAgent> resourceTypeMap, Map<String, Map<String, String>> parametersMap, Map<String, Set<String>> inLRMList, Set<String> orphanedList, MultiKeyMap<String, Set<String>> failedClonesMap) {
        Node lrmResourcesNode = this.getChildNode(lrmNode, "lrm_resources");
        NodeList lrmResources = lrmResourcesNode.getChildNodes();
        for (int j = 0; j < lrmResources.getLength(); ++j) {
            Set<String> inLRMOnHost;
            String crmId;
            Node rscNode = lrmResources.item(j);
            if (!"lrm_resource".equals(rscNode.getNodeName())) continue;
            String resId = this.getAttribute(rscNode, "id");
            Pattern p = Pattern.compile("(.*):(\\d+)$");
            Matcher m = p.matcher(resId);
            if (m.matches()) {
                crmId = m.group(1);
                Set<String> clones = failedClonesMap.get((K[])new String[]{unameLowerCase, crmId});
                if (clones == null) {
                    clones = new LinkedHashSet<String>();
                    failedClonesMap.put(unameLowerCase, crmId, clones);
                }
                clones.add(m.group(2));
            } else {
                crmId = resId;
            }
            if (!resourceTypeMap.containsKey(crmId)) {
                String raClass = this.getAttribute(rscNode, "class");
                String provider = this.getAttribute(rscNode, "provider");
                if (provider == null) {
                    provider = "heartbeat";
                }
                String type = this.getAttribute(rscNode, "type");
                resourceTypeMap.put(crmId, this.getResourceAgent(type, provider, raClass));
                resList.add(crmId);
                parametersMap.put(crmId, new HashMap());
                orphanedList.add(crmId);
            }
            if ((inLRMOnHost = inLRMList.get(unameLowerCase)) == null) {
                inLRMOnHost = new HashSet<String>();
                inLRMList.put(unameLowerCase, inLRMOnHost);
            }
            inLRMOnHost.add(crmId);
        }
    }

    static {
        M_A_POSSIBLE_CHOICES.put(TARGET_ROLE_META_ATTR, new String[]{null, TARGET_ROLE_STARTED, TARGET_ROLE_STOPPED});
        M_A_POSSIBLE_CHOICES_MS.put(TARGET_ROLE_META_ATTR, new String[]{null, TARGET_ROLE_MASTER, TARGET_ROLE_STARTED, TARGET_ROLE_SLAVE, TARGET_ROLE_STOPPED});
        M_A_SHORT_DESC.put(TARGET_ROLE_META_ATTR, Tools.getString("CRMXML.TargetRole.ShortDesc"));
        M_A_LONG_DESC.put(TARGET_ROLE_META_ATTR, Tools.getString("CRMXML.TargetRole.LongDesc"));
        M_A_DEFAULT.put(TARGET_ROLE_META_ATTR, null);
        M_A_NOT_ADVANCED.add(TARGET_ROLE_META_ATTR);
        GROUP_M_A_NOT_ADVANCED.add(TARGET_ROLE_META_ATTR);
        M_A_POSSIBLE_CHOICES.put(IS_MANAGED_META_ATTR, PCMK_BOOLEAN_VALUES);
        M_A_SHORT_DESC.put(IS_MANAGED_META_ATTR, Tools.getString("CRMXML.IsManaged.ShortDesc"));
        M_A_LONG_DESC.put(IS_MANAGED_META_ATTR, Tools.getString("CRMXML.IsManaged.LongDesc"));
        M_A_DEFAULT.put(IS_MANAGED_META_ATTR, "true");
        M_A_TYPE.put(IS_MANAGED_META_ATTR, PARAM_TYPE_BOOLEAN);
        M_A_NOT_ADVANCED.add(IS_MANAGED_META_ATTR);
        M_A_POSSIBLE_CHOICES.put(ALLOW_MIGRATE_META_ATTR, PCMK_BOOLEAN_VALUES);
        M_A_SHORT_DESC.put(ALLOW_MIGRATE_META_ATTR, Tools.getString("CRMXML.AllowMigrate.ShortDesc"));
        M_A_LONG_DESC.put(ALLOW_MIGRATE_META_ATTR, Tools.getString("CRMXML.AllowMigrate.LongDesc"));
        M_A_DEFAULT.put(ALLOW_MIGRATE_META_ATTR, "false");
        M_A_TYPE.put(ALLOW_MIGRATE_META_ATTR, PARAM_TYPE_BOOLEAN);
        M_A_POSSIBLE_CHOICES.put(PRIORITY_META_ATTR, new String[]{"0", "5", "10"});
        M_A_SHORT_DESC.put(PRIORITY_META_ATTR, Tools.getString("CRMXML.Priority.ShortDesc"));
        M_A_LONG_DESC.put(PRIORITY_META_ATTR, Tools.getString("CRMXML.Priority.LongDesc"));
        M_A_DEFAULT.put(PRIORITY_META_ATTR, "0");
        M_A_TYPE.put(PRIORITY_META_ATTR, PARAM_TYPE_INTEGER);
        M_A_POSSIBLE_CHOICES.put(RESOURCE_STICKINESS_META_ATTR, INTEGER_VALUES);
        M_A_SHORT_DESC.put(RESOURCE_STICKINESS_META_ATTR, Tools.getString("CRMXML.ResourceStickiness.ShortDesc"));
        M_A_LONG_DESC.put(RESOURCE_STICKINESS_META_ATTR, Tools.getString("CRMXML.ResourceStickiness.LongDesc"));
        M_A_DEFAULT.put(RESOURCE_STICKINESS_META_ATTR, "0");
        M_A_TYPE.put(RESOURCE_STICKINESS_META_ATTR, PARAM_TYPE_INTEGER);
        M_A_NOT_ADVANCED.add(RESOURCE_STICKINESS_META_ATTR);
        M_A_POSSIBLE_CHOICES.put(MIGRATION_THRESHOLD_META_ATTR, new String[]{DISABLED_STRING, "0", "5", "10"});
        M_A_SHORT_DESC.put(MIGRATION_THRESHOLD_META_ATTR, Tools.getString("CRMXML.MigrationThreshold.ShortDesc"));
        M_A_LONG_DESC.put(MIGRATION_THRESHOLD_META_ATTR, Tools.getString("CRMXML.MigrationThreshold.LongDesc"));
        M_A_DEFAULT.put(MIGRATION_THRESHOLD_META_ATTR, DISABLED_STRING);
        M_A_TYPE.put(MIGRATION_THRESHOLD_META_ATTR, PARAM_TYPE_INTEGER);
        M_A_SHORT_DESC.put(FAILURE_TIMEOUT_META_ATTR, Tools.getString("CRMXML.FailureTimeout.ShortDesc"));
        M_A_LONG_DESC.put(FAILURE_TIMEOUT_META_ATTR, Tools.getString("CRMXML.FailureTimeout.LongDesc"));
        M_A_TYPE.put(FAILURE_TIMEOUT_META_ATTR, PARAM_TYPE_TIME);
        M_A_POSSIBLE_CHOICES.put(MULTIPLE_ACTIVE_META_ATTR, new String[]{"stop_start", "stop_only", "block"});
        M_A_SHORT_DESC.put(MULTIPLE_ACTIVE_META_ATTR, Tools.getString("CRMXML.MultipleActive.ShortDesc"));
        M_A_LONG_DESC.put(MULTIPLE_ACTIVE_META_ATTR, Tools.getString("CRMXML.MultipleActive.LongDesc"));
        M_A_DEFAULT.put(MULTIPLE_ACTIVE_META_ATTR, "stop_start");
        M_A_SHORT_DESC.put(MASTER_MAX_META_ATTR, "M/S Master-Max");
        M_A_DEFAULT.put(MASTER_MAX_META_ATTR, "1");
        M_A_TYPE.put(MASTER_MAX_META_ATTR, PARAM_TYPE_INTEGER);
        M_A_POSSIBLE_CHOICES.put(MASTER_MAX_META_ATTR, INTEGER_VALUES);
        M_A_SECTION.put(MASTER_MAX_META_ATTR, "Master / Slave Resource Defaults");
        M_A_RSC_DEFAULTS_ACCESS_TYPE.put(MASTER_MAX_META_ATTR, ConfigData.AccessType.GOD);
        M_A_SHORT_DESC.put(MASTER_NODE_MAX_META_ATTR, "M/S Master-Node-Max");
        M_A_DEFAULT.put(MASTER_NODE_MAX_META_ATTR, "1");
        M_A_TYPE.put(MASTER_NODE_MAX_META_ATTR, PARAM_TYPE_INTEGER);
        M_A_POSSIBLE_CHOICES.put(MASTER_NODE_MAX_META_ATTR, INTEGER_VALUES);
        M_A_SECTION.put(MASTER_NODE_MAX_META_ATTR, "Master / Slave Resource Defaults");
        M_A_RSC_DEFAULTS_ACCESS_TYPE.put(MASTER_NODE_MAX_META_ATTR, ConfigData.AccessType.GOD);
        M_A_SHORT_DESC.put(CLONE_MAX_META_ATTR, "Clone Max");
        M_A_DEFAULT.put(CLONE_MAX_META_ATTR, "");
        M_A_PREFERRED.put(CLONE_MAX_META_ATTR, "2");
        M_A_TYPE.put(CLONE_MAX_META_ATTR, PARAM_TYPE_INTEGER);
        M_A_POSSIBLE_CHOICES.put(CLONE_MAX_META_ATTR, INTEGER_VALUES);
        M_A_SECTION.put(CLONE_MAX_META_ATTR, "Clone Resource Defaults");
        M_A_RSC_DEFAULTS_ACCESS_TYPE.put(CLONE_MAX_META_ATTR, ConfigData.AccessType.GOD);
        M_A_SHORT_DESC.put(CLONE_NODE_MAX_META_ATTR, "Clone Node Max");
        M_A_DEFAULT.put(CLONE_NODE_MAX_META_ATTR, "1");
        M_A_TYPE.put(CLONE_NODE_MAX_META_ATTR, PARAM_TYPE_INTEGER);
        M_A_POSSIBLE_CHOICES.put(CLONE_NODE_MAX_META_ATTR, INTEGER_VALUES);
        M_A_SECTION.put(CLONE_NODE_MAX_META_ATTR, "Clone Resource Defaults");
        M_A_RSC_DEFAULTS_ACCESS_TYPE.put(CLONE_NODE_MAX_META_ATTR, ConfigData.AccessType.GOD);
        M_A_SHORT_DESC.put(NOTIFY_META_ATTR, "Notify");
        M_A_DEFAULT.put(NOTIFY_META_ATTR, "false");
        M_A_PREFERRED.put(NOTIFY_META_ATTR, "true");
        M_A_POSSIBLE_CHOICES.put(NOTIFY_META_ATTR, PCMK_BOOLEAN_VALUES);
        M_A_SECTION.put(NOTIFY_META_ATTR, "Clone Resource Defaults");
        M_A_RSC_DEFAULTS_ACCESS_TYPE.put(NOTIFY_META_ATTR, ConfigData.AccessType.GOD);
        M_A_SHORT_DESC.put(GLOBALLY_UNIQUE_META_ATTR, "Globally-Unique");
        M_A_DEFAULT.put(GLOBALLY_UNIQUE_META_ATTR, "false");
        M_A_POSSIBLE_CHOICES.put(GLOBALLY_UNIQUE_META_ATTR, PCMK_BOOLEAN_VALUES);
        M_A_SECTION.put(GLOBALLY_UNIQUE_META_ATTR, "Clone Resource Defaults");
        M_A_RSC_DEFAULTS_ACCESS_TYPE.put(GLOBALLY_UNIQUE_META_ATTR, ConfigData.AccessType.GOD);
        M_A_SHORT_DESC.put(ORDERED_META_ATTR, "Ordered");
        M_A_DEFAULT.put(ORDERED_META_ATTR, "false");
        M_A_POSSIBLE_CHOICES.put(ORDERED_META_ATTR, PCMK_BOOLEAN_VALUES);
        M_A_SECTION.put(ORDERED_META_ATTR, "Clone Resource Defaults");
        M_A_RSC_DEFAULTS_ACCESS_TYPE.put(ORDERED_META_ATTR, ConfigData.AccessType.GOD);
        M_A_SHORT_DESC.put(INTERLEAVE_META_ATTR, "Interleave");
        M_A_DEFAULT.put(INTERLEAVE_META_ATTR, "false");
        M_A_POSSIBLE_CHOICES.put(INTERLEAVE_META_ATTR, PCMK_BOOLEAN_VALUES);
        M_A_SECTION.put(INTERLEAVE_META_ATTR, "Clone Resource Defaults");
        M_A_RSC_DEFAULTS_ACCESS_TYPE.put(INTERLEAVE_META_ATTR, ConfigData.AccessType.GOD);
        M_A_PREFERRED.put(INTERLEAVE_META_ATTR, "true");
        M_A_SHORT_DESC.put(GROUP_COLLOCATED_META_ATTR, "Collocated");
        M_A_DEFAULT.put(GROUP_COLLOCATED_META_ATTR, "true");
        M_A_POSSIBLE_CHOICES.put(GROUP_COLLOCATED_META_ATTR, PCMK_BOOLEAN_VALUES);
        M_A_RSC_DEFAULTS_ACCESS_TYPE.put(GROUP_COLLOCATED_META_ATTR, ConfigData.AccessType.ADMIN);
        M_A_SHORT_DESC.put(GROUP_ORDERED_META_ATTR, "Ordered");
        M_A_DEFAULT.put(GROUP_ORDERED_META_ATTR, "true");
        M_A_POSSIBLE_CHOICES.put(GROUP_ORDERED_META_ATTR, PCMK_BOOLEAN_VALUES);
        M_A_RSC_DEFAULTS_ACCESS_TYPE.put(GROUP_ORDERED_META_ATTR, ConfigData.AccessType.ADMIN);
        IGNORE_DEFAULTS_FOR.add("iSCSITarget");
        RA_PARAM_SECTION.put("IPaddr2", "cidr_netmask", Tools.getString("CRMXML.OtherOptions"));
        RA_PARAM_SECTION.put("VirtualDomain", "hypervisor", Tools.getString("CRMXML.OtherOptions"));
    }

    public static final class RscSetConnectionData {
        private RscSet rscSet1;
        private RscSet rscSet2;
        private String constraintId;
        private final int connectionPos;
        private final boolean colocation;

        RscSetConnectionData(RscSet rscSet1, RscSet rscSet2, String constraintId, int connectionPos, boolean colocation) {
            this.rscSet1 = rscSet1;
            this.rscSet2 = rscSet2;
            this.constraintId = constraintId;
            this.connectionPos = connectionPos;
            this.colocation = colocation;
        }

        public RscSet getRscSet1() {
            return this.rscSet1;
        }

        public RscSet getRscSet2() {
            return this.rscSet2;
        }

        public String getConstraintId() {
            return this.constraintId;
        }

        public void setConstraintId(String constraintId) {
            this.constraintId = constraintId;
        }

        public boolean isColocation() {
            return this.colocation;
        }

        private boolean rscSetsAreEqual(RscSet set1, RscSet set2) {
            if (set1 == set2) {
                return true;
            }
            if (set1 == null || set2 == null) {
                return false;
            }
            return set1.equals(set2);
        }

        boolean equals(RscSetConnectionData oRdata) {
            RscSet oRscSet1 = oRdata.getRscSet1();
            RscSet oRscSet2 = oRdata.getRscSet2();
            return oRdata.isColocation() == this.colocation && this.rscSetsAreEqual(this.rscSet1, oRscSet1) && this.rscSetsAreEqual(this.rscSet2, oRscSet2);
        }

        public boolean equalsReversed(RscSetConnectionData oRdata) {
            RscSet oRscSet1 = oRdata.getRscSet1();
            RscSet oRscSet2 = oRdata.getRscSet2();
            return oRdata.isColocation() == this.colocation && (this.rscSet1 == null && oRscSet2 == null && this.rscSetsAreEqual(this.rscSet2, oRscSet1) || this.rscSet2 == null && oRscSet1 == null && this.rscSetsAreEqual(this.rscSet1, oRscSet2));
        }

        public boolean samePlaceholder(RscSetConnectionData oRdata) {
            if (oRdata.isColocation() == this.colocation) {
                return this.equals(oRdata);
            }
            RscSet oRscSet1 = oRdata.getRscSet1();
            RscSet oRscSet2 = oRdata.getRscSet2();
            if ((this.rscSet1 == oRscSet1 || this.rscSet1 == null || oRscSet1 == null || this.rscSet1.isSubsetOf(oRscSet1) || oRscSet1.isSubsetOf(this.rscSet1)) && (this.rscSet2 == oRscSet2 || this.rscSet2 == null || oRscSet2 == null || this.rscSet2.isSubsetOf(oRscSet2) || oRscSet2.isSubsetOf(this.rscSet2)) && (this.rscSet1 != null && this.rscSet1.isSubsetOf(oRscSet1) || oRscSet1 != null && oRscSet1.isSubsetOf(this.rscSet1) || this.rscSet2 != null && this.rscSet2.isSubsetOf(oRscSet2) || oRscSet2 != null && oRscSet2.isSubsetOf(this.rscSet2))) {
                return true;
            }
            return (this.rscSet1 == oRscSet2 || this.rscSet1 == null || oRscSet2 == null || this.rscSet1.isSubsetOf(oRscSet2) || oRscSet2.isSubsetOf(this.rscSet1)) && (this.rscSet2 == oRscSet1 || this.rscSet2 == null || oRscSet1 == null || this.rscSet2.isSubsetOf(oRscSet1) || oRscSet1.isSubsetOf(this.rscSet2)) && (this.rscSet1 != null && this.rscSet1.isSubsetOf(oRscSet2) || oRscSet2 != null && oRscSet2.isSubsetOf(this.rscSet1) || this.rscSet2 != null && this.rscSet2.isSubsetOf(oRscSet1) || oRscSet1 != null && oRscSet1.isSubsetOf(this.rscSet2));
        }

        public void reverse() {
            RscSet old1 = this.rscSet1;
            this.rscSet1 = this.rscSet2;
            this.rscSet2 = old1;
        }

        public boolean isEmpty() {
            return !(this.rscSet1 != null && !this.rscSet1.isRscIdsEmpty() || this.rscSet2 != null && !this.rscSet2.isRscIdsEmpty());
        }

        public int getConnectionPos() {
            return this.connectionPos;
        }

        public String toString() {
            StringBuilder s = new StringBuilder(100);
            s.append("rsc set conn id: ");
            s.append(this.constraintId);
            if (this.colocation) {
                s.append(" (colocation)");
            } else {
                s.append(" (order)");
            }
            s.append("\n   (rscset1: ");
            if (this.rscSet1 == null) {
                s.append("null");
            } else {
                s.append(this.rscSet1.toString());
            }
            s.append(") \n   (rscset2: ");
            if (this.rscSet2 == null) {
                s.append("null");
            } else {
                s.append(this.rscSet2.toString());
            }
            s.append(") ");
            return s.toString();
        }
    }

    public static final class RscSet {
        private final String id;
        private final List<String> rscIds;
        private final ReadWriteLock mRscIdsLock = new ReentrantReadWriteLock();
        private final Lock mRscIdsReadLock = this.mRscIdsLock.readLock();
        private final Lock mRscIdsWriteLock = this.mRscIdsLock.writeLock();
        private final String sequential;
        private final String requireAll;
        private final String orderAction;
        private final String colocationRole;

        public RscSet(String id, List<String> rscIds, String sequential, String requireAll, String orderAction, String colocationRole) {
            this.id = id;
            this.rscIds = rscIds;
            this.sequential = sequential;
            this.requireAll = requireAll;
            this.orderAction = orderAction;
            this.colocationRole = colocationRole;
        }

        public String getId() {
            return this.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<String> getRscIds() {
            ArrayList<String> copy = new ArrayList<String>();
            this.mRscIdsReadLock.lock();
            try {
                for (String id : this.rscIds) {
                    copy.add(id);
                }
            }
            finally {
                this.mRscIdsReadLock.unlock();
            }
            return copy;
        }

        public String getSequential() {
            return this.sequential;
        }

        public String getRequireAll() {
            return this.requireAll;
        }

        public boolean isSubsetOf(RscSet oRscSet) {
            if (oRscSet == null) {
                return false;
            }
            List<String> oRscIds = oRscSet.getRscIds();
            this.mRscIdsReadLock.lock();
            if (this.rscIds.isEmpty()) {
                this.mRscIdsReadLock.unlock();
                return false;
            }
            for (String rscId : this.rscIds) {
                if (oRscIds.contains(rscId)) continue;
                this.mRscIdsReadLock.unlock();
                return false;
            }
            this.mRscIdsReadLock.unlock();
            return true;
        }

        boolean equals(RscSet oRscSet) {
            if (oRscSet == null) {
                return false;
            }
            List<String> oRscIds = oRscSet.getRscIds();
            this.mRscIdsReadLock.lock();
            if (oRscIds.size() != this.rscIds.size()) {
                this.mRscIdsReadLock.unlock();
                return false;
            }
            for (String rscId : this.rscIds) {
                if (oRscIds.contains(rscId)) continue;
                this.mRscIdsReadLock.unlock();
                return false;
            }
            this.mRscIdsReadLock.unlock();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRscId(String id) {
            this.mRscIdsWriteLock.lock();
            try {
                this.rscIds.add(id);
            }
            finally {
                this.mRscIdsWriteLock.unlock();
            }
        }

        boolean isRscIdsEmpty() {
            this.mRscIdsReadLock.lock();
            boolean empty = this.rscIds.isEmpty();
            this.mRscIdsReadLock.unlock();
            return empty;
        }

        public String toString() {
            StringBuilder s = new StringBuilder(20);
            s.append("rscset id: ");
            s.append(this.id);
            s.append(" ids: ");
            s.append(this.rscIds);
            return s.toString();
        }

        public String getOrderAction() {
            return this.orderAction;
        }

        public String getColocationRole() {
            return this.colocationRole;
        }

        public boolean isSequential() {
            return this.sequential == null || "true".equals(this.sequential);
        }

        public boolean isRequireAll() {
            return this.requireAll == null || "true".equals(this.requireAll);
        }
    }

    public static final class OrderData {
        private final String id;
        private final String rscFirst;
        private final String rscThen;
        private final String score;
        private final String symmetrical;
        private final String firstAction;
        private final String thenAction;

        OrderData(String id, String rscFirst, String rscThen, String score, String symmetrical, String firstAction, String thenAction) {
            this.id = id;
            this.rscFirst = rscFirst;
            this.rscThen = rscThen;
            this.score = score;
            this.symmetrical = symmetrical;
            this.firstAction = firstAction;
            this.thenAction = thenAction;
        }

        public String getId() {
            return this.id;
        }

        String getRscFirst() {
            return this.rscFirst;
        }

        public String getRscThen() {
            return this.rscThen;
        }

        public String getScore() {
            return this.score;
        }

        public String getSymmetrical() {
            return this.symmetrical;
        }

        public String getFirstAction() {
            return this.firstAction;
        }

        public String getThenAction() {
            return this.thenAction;
        }
    }

    public static final class ColocationData {
        private final String id;
        private final String rsc;
        private final String withRsc;
        private final String rscRole;
        private final String withRscRole;
        private final String score;

        ColocationData(String id, String rsc, String withRsc, String rscRole, String withRscRole, String score) {
            this.id = id;
            this.rsc = rsc;
            this.withRsc = withRsc;
            this.rscRole = rscRole;
            this.withRscRole = withRscRole;
            this.score = score;
        }

        public String getId() {
            return this.id;
        }

        public String getRsc() {
            return this.rsc;
        }

        public String getWithRsc() {
            return this.withRsc;
        }

        public String getRscRole() {
            return this.rscRole;
        }

        public String getWithRscRole() {
            return this.withRscRole;
        }

        public String getScore() {
            return this.score;
        }
    }

    static class ResStatus {
        private final List<String> runningOnNodes;
        private final List<String> masterOnNodes;
        private final List<String> slaveOnNodes;
        private final Map<String, String> allocationScores;
        private final boolean managed;

        ResStatus(List<String> runningOnNodes, List<String> masterOnNodes, List<String> slaveOnNodes, Map<String, String> allocationScores, boolean managed) {
            this.runningOnNodes = runningOnNodes;
            this.masterOnNodes = masterOnNodes;
            this.slaveOnNodes = slaveOnNodes;
            this.allocationScores = allocationScores;
            this.managed = managed;
        }

        List<String> getRunningOnNodes() {
            return this.runningOnNodes;
        }

        List<String> getMasterOnNodes() {
            return this.masterOnNodes;
        }

        List<String> getSlaveOnNodes() {
            return this.slaveOnNodes;
        }

        boolean isManaged() {
            return this.managed;
        }

        Map<String, String> getAllocationScores() {
            return this.allocationScores;
        }
    }
}

