/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import hep.aida.IAxis;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.ref.Histogram;

abstract class AbstractHistogram3D
extends Histogram
implements IHistogram3D {
    protected IAxis xAxis;
    protected IAxis yAxis;
    protected IAxis zAxis;

    AbstractHistogram3D(String title) {
        super(title);
    }

    @Override
    public int allEntries() {
        int n = 0;
        int i = this.xAxis.bins();
        while (--i >= -2) {
            int j = this.yAxis.bins();
            while (--j >= -2) {
                int k = this.zAxis.bins();
                while (--k >= -2) {
                    n += this.binEntries(i, j, k);
                }
            }
        }
        return n;
    }

    @Override
    public int dimensions() {
        return 3;
    }

    @Override
    public int entries() {
        int n = 0;
        for (int i = 0; i < this.xAxis.bins(); ++i) {
            for (int j = 0; j < this.yAxis.bins(); ++j) {
                for (int k = 0; k < this.zAxis.bins(); ++k) {
                    n += this.binEntries(i, j, k);
                }
            }
        }
        return n;
    }

    @Override
    public int extraEntries() {
        return this.allEntries() - this.entries();
    }

    @Override
    public void fill(double x, double y, double z) {
        this.fill(x, y, z, 1.0);
    }

    protected abstract IHistogram2D internalSliceXY(String var1, int var2, int var3);

    protected abstract IHistogram2D internalSliceXZ(String var1, int var2, int var3);

    protected abstract IHistogram2D internalSliceYZ(String var1, int var2, int var3);

    int mapX(int index) {
        int bins = this.xAxis.bins() + 2;
        if (index >= bins) {
            throw new IllegalArgumentException("bin=" + index);
        }
        if (index >= 0) {
            return index + 1;
        }
        if (index == -2) {
            return 0;
        }
        if (index == -1) {
            return bins - 1;
        }
        throw new IllegalArgumentException("bin=" + index);
    }

    int mapY(int index) {
        int bins = this.yAxis.bins() + 2;
        if (index >= bins) {
            throw new IllegalArgumentException("bin=" + index);
        }
        if (index >= 0) {
            return index + 1;
        }
        if (index == -2) {
            return 0;
        }
        if (index == -1) {
            return bins - 1;
        }
        throw new IllegalArgumentException("bin=" + index);
    }

    int mapZ(int index) {
        int bins = this.zAxis.bins() + 2;
        if (index >= bins) {
            throw new IllegalArgumentException("bin=" + index);
        }
        if (index >= 0) {
            return index + 1;
        }
        if (index == -2) {
            return 0;
        }
        if (index == -1) {
            return bins - 1;
        }
        throw new IllegalArgumentException("bin=" + index);
    }

    @Override
    public int[] minMaxBins() {
        double minValue = Double.MAX_VALUE;
        double maxValue = Double.MIN_VALUE;
        int minBinX = -1;
        int minBinY = -1;
        int minBinZ = -1;
        int maxBinX = -1;
        int maxBinY = -1;
        int maxBinZ = -1;
        int i = this.xAxis.bins();
        while (--i >= 0) {
            int j = this.yAxis.bins();
            while (--j >= 0) {
                int k = this.zAxis.bins();
                while (--k >= 0) {
                    double value = this.binHeight(i, j, k);
                    if (value < minValue) {
                        minValue = value;
                        minBinX = i;
                        minBinY = j;
                        minBinZ = k;
                    }
                    if (!(value > maxValue)) continue;
                    maxValue = value;
                    maxBinX = i;
                    maxBinY = j;
                    maxBinZ = k;
                }
            }
        }
        int[] result = new int[]{minBinX, minBinY, minBinZ, maxBinX, maxBinY, maxBinZ};
        return result;
    }

    @Override
    public IHistogram2D projectionXY() {
        String newTitle = this.title() + " (projectionXY)";
        return this.internalSliceXY(newTitle, this.mapZ(-2), this.mapZ(-1));
    }

    @Override
    public IHistogram2D projectionXZ() {
        String newTitle = this.title() + " (projectionXZ)";
        return this.internalSliceXZ(newTitle, this.mapY(-2), this.mapY(-1));
    }

    @Override
    public IHistogram2D projectionYZ() {
        String newTitle = this.title() + " (projectionYZ)";
        return this.internalSliceYZ(newTitle, this.mapX(-2), this.mapX(-1));
    }

    @Override
    public IHistogram2D sliceXY(int indexZ) {
        return this.sliceXY(indexZ, indexZ);
    }

    @Override
    public IHistogram2D sliceXY(int indexZ1, int indexZ2) {
        int start = this.mapZ(indexZ1);
        int stop = this.mapZ(indexZ2);
        String newTitle = this.title() + " (sliceXY [" + indexZ1 + ":" + indexZ2 + "])";
        return this.internalSliceXY(newTitle, start, stop);
    }

    @Override
    public IHistogram2D sliceXZ(int indexY) {
        return this.sliceXZ(indexY, indexY);
    }

    @Override
    public IHistogram2D sliceXZ(int indexY1, int indexY2) {
        int start = this.mapY(indexY1);
        int stop = this.mapY(indexY2);
        String newTitle = this.title() + " (sliceXZ [" + indexY1 + ":" + indexY2 + "])";
        return this.internalSliceXY(newTitle, start, stop);
    }

    @Override
    public IHistogram2D sliceYZ(int indexX) {
        return this.sliceYZ(indexX, indexX);
    }

    @Override
    public IHistogram2D sliceYZ(int indexX1, int indexX2) {
        int start = this.mapX(indexX1);
        int stop = this.mapX(indexX2);
        String newTitle = this.title() + " (sliceYZ [" + indexX1 + ":" + indexX2 + "])";
        return this.internalSliceYZ(newTitle, start, stop);
    }

    @Override
    public double sumAllBinHeights() {
        double n = 0.0;
        int i = this.xAxis.bins();
        while (--i >= -2) {
            int j = this.yAxis.bins();
            while (--j >= -2) {
                int k = this.zAxis.bins();
                while (--k >= -2) {
                    n += this.binHeight(i, j, k);
                }
            }
        }
        return n;
    }

    @Override
    public double sumBinHeights() {
        double n = 0.0;
        for (int i = 0; i < this.xAxis.bins(); ++i) {
            for (int j = 0; j < this.yAxis.bins(); ++j) {
                for (int k = 0; k < this.zAxis.bins(); ++k) {
                    n += this.binHeight(i, j, k);
                }
            }
        }
        return n;
    }

    @Override
    public double sumExtraBinHeights() {
        return this.sumAllBinHeights() - this.sumBinHeights();
    }

    @Override
    public IAxis xAxis() {
        return this.xAxis;
    }

    @Override
    public IAxis yAxis() {
        return this.yAxis;
    }

    @Override
    public IAxis zAxis() {
        return this.zAxis;
    }
}

