/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.decorators;

import edu.uci.ics.jung.visualization.FourPassImageShaper;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.collections15.Transformer;

public class VertexIconShapeTransformer<V>
implements Transformer<V, Shape> {
    protected Map<Image, Shape> shapeMap = new HashMap<Image, Shape>();
    protected Map<V, Icon> iconMap;
    protected Transformer<V, Shape> delegate;

    public VertexIconShapeTransformer(Transformer<V, Shape> delegate) {
        this.delegate = delegate;
    }

    public Transformer<V, Shape> getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Transformer<V, Shape> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Shape transform(V v) {
        Icon icon = this.iconMap.get(v);
        if (icon != null && icon instanceof ImageIcon) {
            Image image = ((ImageIcon)icon).getImage();
            Shape shape = this.shapeMap.get(image);
            if (shape == null && (shape = FourPassImageShaper.getShape(image, 30)).getBounds().getWidth() > 0.0 && shape.getBounds().getHeight() > 0.0) {
                int width = image.getWidth(null);
                int height = image.getHeight(null);
                AffineTransform transform = AffineTransform.getTranslateInstance(-width / 2, -height / 2);
                shape = transform.createTransformedShape(shape);
                this.shapeMap.put(image, shape);
            }
            return shape;
        }
        return this.delegate.transform(v);
    }

    public Map<V, Icon> getIconMap() {
        return this.iconMap;
    }

    public void setIconMap(Map<V, Icon> iconMap) {
        this.iconMap = iconMap;
    }

    public Map<Image, Shape> getShapeMap() {
        return this.shapeMap;
    }

    public void setShapeMap(Map<Image, Shape> shapeMap) {
        this.shapeMap = shapeMap;
    }
}

