/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.layout3d;

import edu.uci.ics.jung.algorithms.layout3d.Layout;
import edu.uci.ics.jung.graph.Graph;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.media.j3d.BoundingSphere;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.map.LazyMap;

public abstract class AbstractLayout<V, E>
implements Layout<V, E> {
    private Set<V> dontmove = new HashSet<V>();
    private BoundingSphere size;
    private Graph<V, E> graph;
    protected Map<V, Point3f> locations = LazyMap.decorate(new HashMap(), new Transformer<V, Point3f>(){

        @Override
        public Point3f transform(V arg0) {
            return new Point3f();
        }
    });

    protected AbstractLayout(Graph<V, E> graph) {
        this.graph = graph;
    }

    protected AbstractLayout(Graph<V, E> graph, Transformer<V, Point3f> initializer) {
        this.graph = graph;
        this.locations = LazyMap.decorate(new HashMap(), initializer);
    }

    protected AbstractLayout(Graph<V, E> graph, BoundingSphere size) {
        this.graph = graph;
        this.size = size;
    }

    protected AbstractLayout(Graph<V, E> graph, Transformer<V, Point3f> initializer, BoundingSphere size) {
        this.graph = graph;
        this.locations = LazyMap.decorate(new HashMap(), initializer);
        this.size = size;
    }

    @Override
    public void setGraph(Graph<V, E> graph) {
        this.graph = graph;
        if (this.size != null && graph != null) {
            this.initialize();
        }
    }

    @Override
    public void setSize(BoundingSphere size) {
        if (size != null && this.graph != null) {
            BoundingSphere oldSize = this.size;
            this.size = size;
            this.initialize();
            if (oldSize != null) {
                this.adjustLocations(oldSize, size);
            }
        }
    }

    private void adjustLocations(BoundingSphere oldSize, BoundingSphere size) {
        float oldWidth = 0.0f;
        float oldHeight = 0.0f;
        float oldDepth = 0.0f;
        float width = 0.0f;
        float height = 0.0f;
        float depth = 0.0f;
        oldHeight = oldDepth = (float)(2.0 * oldSize.getRadius());
        oldWidth = oldDepth;
        height = depth = (float)(2.0 * size.getRadius());
        width = depth;
        float xOffset = (oldWidth - width) / 2.0f;
        float yOffset = (oldHeight - height) / 2.0f;
        float zOffset = (oldDepth - depth) / 2.0f;
        while (true) {
            try {
                for (Object v : this.getGraph().getVertices()) {
                    this.offsetVertex(v, xOffset, yOffset, zOffset);
                }
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            break;
        }
    }

    @Override
    public boolean isLocked(V v) {
        return this.dontmove.contains(v);
    }

    public Collection<V> getVertices() {
        return this.getGraph().getVertices();
    }

    @Override
    public abstract void initialize();

    @Override
    public void setInitializer(Transformer<V, Point3f> initializer) {
        this.locations = LazyMap.decorate(new HashMap<V, Point3f>(this.locations), initializer);
    }

    @Override
    public BoundingSphere getSize() {
        return this.size;
    }

    private Point3f getCoordinates(V v) {
        return this.locations.get(v);
    }

    @Override
    public Point3f transform(V v) {
        return this.getCoordinates(v);
    }

    public double getX(V v) {
        assert (this.getCoordinates(v) != null) : "Cannot getX for an unmapped vertex " + v;
        return this.getCoordinates(v).getX();
    }

    public double getY(V v) {
        assert (this.getCoordinates(v) != null) : "Cannot getY for an unmapped vertex " + v;
        return this.getCoordinates(v).getY();
    }

    protected void offsetVertex(V v, float xOffset, float yOffset, float zOffset) {
        Point3f c = this.getCoordinates(v);
        c.set(c.getX() + xOffset, c.getY() + yOffset, c.getZ() + zOffset);
        this.setLocation(v, c);
    }

    @Override
    public Graph<V, E> getGraph() {
        return this.graph;
    }

    public void setLocation(V picked, float x, float y, float z) {
        Point3f coord = this.getCoordinates(picked);
        coord.set(x, y, z);
    }

    @Override
    public void setLocation(V picked, Point3f p) {
        Point3f coord = this.getCoordinates(picked);
        coord.set((Tuple3f)p);
    }

    @Override
    public void lock(V v, boolean state) {
        if (state) {
            this.dontmove.add(v);
        } else {
            this.dontmove.remove(v);
        }
    }

    public void lock(boolean lock) {
        for (Object v : this.graph.getVertices()) {
            this.lock(v, lock);
        }
    }
}

