/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.interaction;

import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.interaction.TGSelfDeactivatingUI;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public abstract class TGAbstractDragUI
extends TGSelfDeactivatingUI {
    public TGPanel tgPanel;
    private ADUIMouseListener ml;
    private ADUIMouseMotionListener mml;
    public boolean mouseWasDragged;

    public TGAbstractDragUI(TGPanel tgp) {
        this.tgPanel = tgp;
        this.ml = new ADUIMouseListener();
        this.mml = new ADUIMouseMotionListener();
    }

    @Override
    public final void activate() {
        this.preActivate();
        this.tgPanel.addMouseListener(this.ml);
        this.tgPanel.addMouseMotionListener(this.mml);
        this.mouseWasDragged = false;
    }

    public final void activate(MouseEvent e) {
        this.activate();
        this.mousePressed(e);
    }

    @Override
    public final void deactivate() {
        this.preDeactivate();
        this.tgPanel.removeMouseListener(this.ml);
        this.tgPanel.removeMouseMotionListener(this.mml);
        super.deactivate();
    }

    public abstract void preActivate();

    public abstract void preDeactivate();

    public abstract void mousePressed(MouseEvent var1);

    public abstract void mouseDragged(MouseEvent var1);

    public abstract void mouseReleased(MouseEvent var1);

    private class ADUIMouseMotionListener
    extends MouseMotionAdapter {
        private ADUIMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            TGAbstractDragUI.this.mouseWasDragged = true;
            TGAbstractDragUI.this.mouseDragged(e);
        }
    }

    private class ADUIMouseListener
    extends MouseAdapter {
        private ADUIMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TGAbstractDragUI.this.mousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            TGAbstractDragUI.this.mouseReleased(e);
            if (TGAbstractDragUI.this.selfDeactivate) {
                TGAbstractDragUI.this.deactivate();
            }
        }
    }
}

