/*
 * Decompiled with CFR 0.152.
 */
package com.tomtessier.scrollabledesktop;

import com.tomtessier.scrollabledesktop.BaseInternalFrame;
import com.tomtessier.scrollabledesktop.DesktopConstants;
import com.tomtessier.scrollabledesktop.FrameAccessorInterface;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JToggleButton;

public class BaseToggleButton
extends JToggleButton
implements DesktopConstants,
FrameAccessorInterface {
    private BaseInternalFrame associatedFrame;
    private Color defaultColor;

    public BaseToggleButton(String title) {
        super(title);
        this.setButtonFormat();
        this.setToolTipText(title);
        this.defaultColor = this.getForeground();
    }

    private void setButtonFormat() {
        Font buttonFont = this.getFont();
        this.setFont(new Font(buttonFont.getFontName(), buttonFont.getStyle(), buttonFont.getSize() - 1));
        this.setMargin(new Insets(0, 0, 0, 0));
    }

    @Override
    public void setAssociatedFrame(BaseInternalFrame associatedFrame) {
        this.associatedFrame = associatedFrame;
    }

    @Override
    public BaseInternalFrame getAssociatedFrame() {
        return this.associatedFrame;
    }

    public void flagContentsChanged(boolean changed) {
        if (changed) {
            this.setForeground(CONTENTS_CHANGED_COLOR);
        } else {
            this.setForeground(this.defaultColor);
        }
    }
}

