/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix;

import cern.colt.function.ObjectFunction;
import cern.colt.function.ObjectObjectFunction;
import cern.colt.function.ObjectProcedure;
import cern.colt.list.IntArrayList;
import cern.colt.list.ObjectArrayList;
import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.ObjectMatrix1DProcedure;
import cern.colt.matrix.impl.AbstractMatrix2D;
import cern.colt.matrix.objectalgo.Formatter;
import cern.colt.matrix.objectalgo.Sorting;

public abstract class ObjectMatrix2D
extends AbstractMatrix2D {
    protected ObjectMatrix2D() {
    }

    public Object aggregate(ObjectObjectFunction aggr, ObjectFunction f) {
        if (this.size() == 0) {
            return null;
        }
        Object a = f.apply(this.getQuick(this.rows - 1, this.columns - 1));
        int d = 1;
        int row = this.rows;
        while (--row >= 0) {
            int column = this.columns - d;
            while (--column >= 0) {
                a = aggr.apply(a, f.apply(this.getQuick(row, column)));
            }
            d = 0;
        }
        return a;
    }

    public Object aggregate(ObjectMatrix2D other, ObjectObjectFunction aggr, ObjectObjectFunction f) {
        this.checkShape(other);
        if (this.size() == 0) {
            return null;
        }
        Object a = f.apply(this.getQuick(this.rows - 1, this.columns - 1), other.getQuick(this.rows - 1, this.columns - 1));
        int d = 1;
        int row = this.rows;
        while (--row >= 0) {
            int column = this.columns - d;
            while (--column >= 0) {
                a = aggr.apply(a, f.apply(this.getQuick(row, column), other.getQuick(row, column)));
            }
            d = 0;
        }
        return a;
    }

    public ObjectMatrix2D assign(Object[][] values) {
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
        }
        int row = this.rows;
        while (--row >= 0) {
            Object[] currentRow = values[row];
            if (currentRow.length != this.columns) {
                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
            }
            int column = this.columns;
            while (--column >= 0) {
                this.setQuick(row, column, currentRow[column]);
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectFunction function) {
        int row = this.rows;
        while (--row >= 0) {
            int column = this.columns;
            while (--column >= 0) {
                this.setQuick(row, column, function.apply(this.getQuick(row, column)));
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D other) {
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        if (this.haveSharedCells(other)) {
            other = other.copy();
        }
        int row = this.rows;
        while (--row >= 0) {
            int column = this.columns;
            while (--column >= 0) {
                this.setQuick(row, column, other.getQuick(row, column));
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D y, ObjectObjectFunction function) {
        this.checkShape(y);
        int row = this.rows;
        while (--row >= 0) {
            int column = this.columns;
            while (--column >= 0) {
                this.setQuick(row, column, function.apply(this.getQuick(row, column), y.getQuick(row, column)));
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(Object value) {
        int row = this.rows;
        while (--row >= 0) {
            int column = this.columns;
            while (--column >= 0) {
                this.setQuick(row, column, value);
            }
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int row = this.rows;
        while (--row >= 0) {
            int column = this.columns;
            while (--column >= 0) {
                if (this.getQuick(row, column) == null) continue;
                ++cardinality;
            }
        }
        return cardinality;
    }

    public ObjectMatrix2D copy() {
        return this.like().assign(this);
    }

    public boolean equals(Object otherObj) {
        return this.equals(otherObj, true);
    }

    public boolean equals(Object otherObj, boolean testForEquality) {
        if (!(otherObj instanceof ObjectMatrix2D)) {
            return false;
        }
        if (this == otherObj) {
            return true;
        }
        if (otherObj == null) {
            return false;
        }
        ObjectMatrix2D other = (ObjectMatrix2D)otherObj;
        if (this.rows != other.rows()) {
            return false;
        }
        if (this.columns != other.columns()) {
            return false;
        }
        if (!testForEquality) {
            int row = this.rows;
            while (--row >= 0) {
                int column = this.columns;
                while (--column >= 0) {
                    if (this.getQuick(row, column) == other.getQuick(row, column)) continue;
                    return false;
                }
            }
        } else {
            int row = this.rows;
            while (--row >= 0) {
                int column = this.columns;
                while (--column >= 0) {
                    if (this.getQuick(row, column) != null ? this.getQuick(row, column).equals(other.getQuick(row, column)) : other.getQuick(row, column) == null) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Object get(int row, int column) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + row + ", column:" + column);
        }
        return this.getQuick(row, column);
    }

    protected ObjectMatrix2D getContent() {
        return this;
    }

    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, ObjectArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int r = this.rows;
        int c = this.columns;
        for (int row = 0; row < r; ++row) {
            for (int column = 0; column < c; ++column) {
                Object value = this.getQuick(row, column);
                if (value == null) continue;
                rowList.add(row);
                columnList.add(column);
                valueList.add(value);
            }
        }
    }

    public abstract Object getQuick(int var1, int var2);

    protected boolean haveSharedCells(ObjectMatrix2D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix2D other) {
        return false;
    }

    public ObjectMatrix2D like() {
        return this.like(this.rows, this.columns);
    }

    public abstract ObjectMatrix2D like(int var1, int var2);

    public abstract ObjectMatrix1D like1D(int var1);

    protected abstract ObjectMatrix1D like1D(int var1, int var2, int var3);

    public void set(int row, int column, Object value) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + row + ", column:" + column);
        }
        this.setQuick(row, column, value);
    }

    public abstract void setQuick(int var1, int var2, Object var3);

    public Object[][] toArray() {
        Object[][] values = new Object[this.rows][this.columns];
        int row = this.rows;
        while (--row >= 0) {
            Object[] currentRow = values[row];
            int column = this.columns;
            while (--column >= 0) {
                currentRow[column] = this.getQuick(row, column);
            }
        }
        return values;
    }

    public String toString() {
        return new Formatter().toString(this);
    }

    protected ObjectMatrix2D view() {
        return (ObjectMatrix2D)this.clone();
    }

    public ObjectMatrix1D viewColumn(int column) {
        this.checkColumn(column);
        int viewSize = this.rows;
        int viewZero = this.index(0, column);
        int viewStride = this.rowStride;
        return this.like1D(viewSize, viewZero, viewStride);
    }

    public ObjectMatrix2D viewColumnFlip() {
        return (ObjectMatrix2D)this.view().vColumnFlip();
    }

    public ObjectMatrix2D viewDice() {
        return (ObjectMatrix2D)this.view().vDice();
    }

    public ObjectMatrix2D viewPart(int row, int column, int height, int width) {
        return (ObjectMatrix2D)this.view().vPart(row, column, height, width);
    }

    public ObjectMatrix1D viewRow(int row) {
        this.checkRow(row);
        int viewSize = this.columns;
        int viewZero = this.index(row, 0);
        int viewStride = this.columnStride;
        return this.like1D(viewSize, viewZero, viewStride);
    }

    public ObjectMatrix2D viewRowFlip() {
        return (ObjectMatrix2D)this.view().vRowFlip();
    }

    public ObjectMatrix2D viewSelection(int[] rowIndexes, int[] columnIndexes) {
        int i;
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            i = this.rows;
            while (--i >= 0) {
                rowIndexes[i] = i;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            i = this.columns;
            while (--i >= 0) {
                columnIndexes[i] = i;
            }
        }
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        int[] rowOffsets = new int[rowIndexes.length];
        int[] columnOffsets = new int[columnIndexes.length];
        int i2 = rowIndexes.length;
        while (--i2 >= 0) {
            rowOffsets[i2] = this._rowOffset(this._rowRank(rowIndexes[i2]));
        }
        i2 = columnIndexes.length;
        while (--i2 >= 0) {
            columnOffsets[i2] = this._columnOffset(this._columnRank(columnIndexes[i2]));
        }
        return this.viewSelectionLike(rowOffsets, columnOffsets);
    }

    public ObjectMatrix2D viewSelection(ObjectMatrix1DProcedure condition) {
        IntArrayList matches = new IntArrayList();
        for (int i = 0; i < this.rows; ++i) {
            if (!condition.apply(this.viewRow(i))) continue;
            matches.add(i);
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements(), null);
    }

    protected abstract ObjectMatrix2D viewSelectionLike(int[] var1, int[] var2);

    public ObjectMatrix2D viewSorted(int column) {
        return Sorting.mergeSort.sort(this, column);
    }

    public ObjectMatrix2D viewStrides(int rowStride, int columnStride) {
        return (ObjectMatrix2D)this.view().vStrides(rowStride, columnStride);
    }

    private boolean xforEach(ObjectProcedure procedure) {
        int row = this.rows;
        while (--row >= 0) {
            int column = this.columns;
            while (--column >= 0) {
                if (procedure.apply(this.getQuick(row, column))) continue;
                return false;
            }
        }
        return true;
    }
}

