/*
 * Decompiled with CFR 0.152.
 */
import EDU.oswego.cs.dl.util.concurrent.FJTask;
import EDU.oswego.cs.dl.util.concurrent.FJTaskRunnerGroup;

public class Heat {
    static int nx;
    static int ny;
    static int nt;
    static int leafmaxcol;
    static double[][] newm;
    static double[][] oldm;
    static final double xu = 0.0;
    static final double xo = 1.5707963267948966;
    static final double yu = 0.0;
    static final double yo = 1.5707963267948966;
    static final double tu = 0.0;
    static final double to = 1.0E-7;
    static final double dx;
    static final double dy;
    static final double dt;
    static final double dtdxsq;
    static final double dtdysq;

    public static void main(String[] args) {
        int procs = 1;
        int benchmark = 0;
        try {
            procs = Integer.parseInt(args[0]);
            benchmark = Integer.parseInt(args[1]);
        }
        catch (Exception e) {
            System.out.println("Usage: java Heat <threads> <0-4>");
            return;
        }
        switch (benchmark) {
            case 0: {
                nx = 4096;
                ny = 512;
                nt = 100;
                leafmaxcol = 10;
                break;
            }
            case 1: {
                nx = 512;
                ny = 512;
                nt = 1;
                leafmaxcol = 10;
                break;
            }
            case 2: {
                nx = 4096;
                ny = 512;
                nt = 40;
                leafmaxcol = 10;
                break;
            }
            case 3: {
                nx = 4096;
                ny = 1024;
                nt = 100;
                leafmaxcol = 1;
                break;
            }
            case 4: {
                nx = 1024;
                ny = 512;
                nt = 100;
                leafmaxcol = 16;
                break;
            }
            default: {
                System.out.println("Usage: java Heat <threads> <0-4>");
                return;
            }
        }
        System.out.print("Parameters: ");
        System.out.print(" granularity = " + leafmaxcol);
        System.out.print(" rows = " + nx);
        System.out.print(" columns = " + ny);
        System.out.println(" steps = " + nt);
        oldm = new double[nx][ny];
        newm = new double[nx][ny];
        try {
            FJTaskRunnerGroup g = new FJTaskRunnerGroup(procs);
            FJTask main = new FJTask(){

                @Override
                public void run() {
                    for (int timestep = 0; timestep <= nt; ++timestep) {
                        FJTask.invoke(new Compute(0, nx, timestep));
                    }
                }
            };
            g.invoke(main);
            g.stats();
        }
        catch (InterruptedException ex) {
            return;
        }
    }

    static final double f(double x, double y) {
        return Math.sin(x) * Math.sin(y);
    }

    static final double randa(double x, double t) {
        return 0.0;
    }

    static final double randb(double x, double t) {
        return Math.exp(-2.0 * t) * Math.sin(x);
    }

    static final double randc(double y, double t) {
        return 0.0;
    }

    static final double randd(double y, double t) {
        return Math.exp(-2.0 * t) * Math.sin(y);
    }

    static final double solu(double x, double y, double t) {
        return Math.exp(-2.0 * t) * Math.sin(x) * Math.sin(y);
    }

    static {
        dx = 1.5707963267948966 / (double)(nx - 1);
        dy = 1.5707963267948966 / (double)(ny - 1);
        dt = 1.0E-7 / (double)nt;
        dtdxsq = dt / (dx * dx);
        dtdysq = dt / (dy * dy);
    }

    static final class Compute
    extends FJTask {
        final int lb;
        final int ub;
        final int time;

        Compute(int lowerBound, int upperBound, int timestep) {
            this.lb = lowerBound;
            this.ub = upperBound;
            this.time = timestep;
        }

        @Override
        public void run() {
            if (this.ub - this.lb > leafmaxcol) {
                int mid = (this.lb + this.ub) / 2;
                Compute.coInvoke(new Compute(this.lb, mid, this.time), new Compute(mid, this.ub, this.time));
            } else if (this.time == 0) {
                this.init();
            } else if (this.time % 2 != 0) {
                this.compstripe(newm, oldm);
            } else {
                this.compstripe(oldm, newm);
            }
        }

        final void compstripe(double[][] newMat, double[][] oldMat) {
            int llb = this.lb == 0 ? 1 : this.lb;
            int lub = this.ub == nx ? nx - 1 : this.ub;
            double[] row = oldMat[llb - 1];
            double[] east = oldMat[llb];
            for (int a = llb; a < lub; ++a) {
                double[] west = row;
                row = east;
                east = oldMat[a + 1];
                double cell = row[0];
                double next = row[1];
                double[] nv = newMat[a];
                for (int b = 1; b < ny - 1; ++b) {
                    double prev = cell;
                    cell = next;
                    double twoc = 2.0 * cell;
                    next = row[b + 1];
                    nv[b] = cell + dtdysq * (prev - twoc + next) + dtdxsq * (east[b] - twoc + west[b]);
                }
            }
            this.edges(newMat, llb, lub, 0.0 + (double)this.time * dt);
        }

        final void origcompstripe(double[][] newMat, double[][] oldMat) {
            int llb = this.lb == 0 ? 1 : this.lb;
            int lub = this.ub == nx ? nx - 1 : this.ub;
            for (int a = llb; a < lub; ++a) {
                for (int b = 1; b < ny - 1; ++b) {
                    double cell = oldMat[a][b];
                    double twoc = 2.0 * cell;
                    newMat[a][b] = cell + dtdxsq * (oldMat[a + 1][b] - twoc + oldMat[a - 1][b]) + dtdysq * (oldMat[a][b + 1] - twoc + oldMat[a][b - 1]);
                }
            }
            this.edges(newMat, llb, lub, 0.0 + (double)this.time * dt);
        }

        final void init() {
            int llb = this.lb == 0 ? 1 : this.lb;
            int lub = this.ub == nx ? nx - 1 : this.ub;
            for (int a = llb; a < lub; ++a) {
                double[] ov = oldm[a];
                double x = 0.0 + (double)a * dx;
                double y = 0.0;
                for (int b = 1; b < ny - 1; ++b) {
                    ov[b] = Heat.f(x, y += dy);
                }
            }
            this.edges(oldm, llb, lub, 0.0);
        }

        final void edges(double[][] m, int llb, int lub, double t) {
            int b;
            for (int a = llb; a < lub; ++a) {
                double[] v = m[a];
                double x = 0.0 + (double)a * dx;
                v[0] = Heat.randa(x, t);
                v[Heat.ny - 1] = Heat.randb(x, t);
            }
            if (this.lb == 0) {
                double[] v = m[0];
                double y = 0.0;
                for (b = 0; b < ny; ++b) {
                    v[b] = Heat.randc(y += dy, t);
                }
            }
            if (this.ub == nx) {
                double[] v = m[nx - 1];
                double y = 0.0;
                for (b = 0; b < ny; ++b) {
                    v[b] = Heat.randd(y += dy, t);
                }
            }
        }
    }
}

