/*
 * Decompiled with CFR 0.152.
 */
import EDU.oswego.cs.dl.util.concurrent.CyclicBarrier;

public class BarrierJacobi {
    static final int DEFAULT_GRANULARITY = 128;
    static int granularity = 128;
    static final double EPSILON = 0.001;

    public static void main(String[] args) {
        try {
            int steps;
            int n;
            try {
                n = Integer.parseInt(args[0]);
                steps = Integer.parseInt(args[1]);
                if (args.length > 2) {
                    granularity = Integer.parseInt(args[2]);
                }
            }
            catch (Exception e) {
                System.out.println("Usage: java BarrierJacobi <matrix size> <max steps> [<granularity>]");
                return;
            }
            double[][] a = new double[n + 2][n + 2];
            double[][] b = new double[n + 2][n + 2];
            for (int k = 0; k < n + 2; ++k) {
                a[k][0] = 1.0;
                a[k][n + 1] = 1.0;
                a[0][k] = 1.0;
                a[n + 1][k] = 1.0;
                b[k][0] = 1.0;
                b[k][n + 1] = 1.0;
                b[0][k] = 1.0;
                b[n + 1][k] = 1.0;
            }
            long startTime = System.currentTimeMillis();
            new Driver(a, b, 1, n, 1, n, steps).compute();
            long time = System.currentTimeMillis() - startTime;
            double secs = (double)time / 1000.0;
            System.out.println("Compute Time: " + secs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static class Driver {
        double[][] A;
        double[][] B;
        final int loRow;
        final int hiRow;
        final int loCol;
        final int hiCol;
        final int steps;

        Driver(double[][] mat1, double[][] mat2, int firstRow, int lastRow, int firstCol, int lastCol, int steps) {
            this.A = mat1;
            this.B = mat2;
            this.loRow = firstRow;
            this.hiRow = lastRow;
            this.loCol = firstCol;
            this.hiCol = lastCol;
            this.steps = steps;
        }

        public void compute() throws InterruptedException {
            int rows = this.hiRow - this.loRow + 1;
            int cols = this.hiCol - this.loCol + 1;
            int rblocks = rows / granularity;
            int cblocks = cols / granularity;
            int n = rblocks * cblocks;
            System.out.println("Using " + n + " segments (threads)");
            Segment[] segs = new Segment[n];
            Thread[] threads = new Thread[n];
            CyclicBarrier barrier = new CyclicBarrier(n);
            int k = 0;
            for (int i = 0; i < rblocks; ++i) {
                int lr = this.loRow + i * granularity;
                int hr = lr + granularity;
                if (i == rblocks - 1) {
                    hr = this.hiRow;
                }
                for (int j = 0; j < cblocks; ++j) {
                    int lc = this.loCol + j * granularity;
                    int hc = lc + granularity;
                    if (j == cblocks - 1) {
                        hc = this.hiCol;
                    }
                    segs[k] = new Segment(this.A, this.B, lr, hr, lc, hc, this.steps, barrier, segs);
                    threads[k] = new Thread(segs[k]);
                    ++k;
                }
            }
            for (k = 0; k < n; ++k) {
                threads[k].start();
            }
            for (k = 0; k < n; ++k) {
                threads[k].join();
            }
            double maxd = 0.0;
            for (k = 0; k < n; ++k) {
                double md = segs[k].maxDiff;
                if (!(md > maxd)) continue;
                maxd = md;
            }
            System.out.println("Max diff after " + this.steps + " steps = " + maxd);
        }
    }

    static class Segment
    implements Runnable {
        double[][] A;
        double[][] B;
        final int loRow;
        final int hiRow;
        final int loCol;
        final int hiCol;
        final int steps;
        final CyclicBarrier barrier;
        final Segment[] allSegments;
        volatile double maxDiff;
        volatile boolean converged = false;

        Segment(double[][] A, double[][] B, int loRow, int hiRow, int loCol, int hiCol, int steps, CyclicBarrier barrier, Segment[] allSegments) {
            this.A = A;
            this.B = B;
            this.loRow = loRow;
            this.hiRow = hiRow;
            this.loCol = loCol;
            this.hiCol = hiCol;
            this.steps = steps;
            this.barrier = barrier;
            this.allSegments = allSegments;
        }

        void convergenceCheck(int step) {
            int i;
            for (i = 0; i < this.allSegments.length; ++i) {
                if (!(this.allSegments[i].maxDiff > 0.001)) continue;
                return;
            }
            System.out.println("Converged after " + step + " steps");
            for (i = 0; i < this.allSegments.length; ++i) {
                this.allSegments[i].converged = true;
            }
        }

        @Override
        public void run() {
            try {
                double[][] a = this.A;
                double[][] b = this.B;
                for (int i = 1; i <= this.steps && !this.converged; ++i) {
                    this.maxDiff = this.update(a, b);
                    int index = this.barrier.barrier();
                    if (index == 0) {
                        this.convergenceCheck(i);
                    }
                    this.barrier.barrier();
                    double[][] tmp = a;
                    a = b;
                    b = tmp;
                }
            }
            catch (Exception ex) {
                return;
            }
        }

        double update(double[][] a, double[][] b) {
            double md = 0.0;
            for (int i = this.loRow; i <= this.hiRow; ++i) {
                for (int j = this.loCol; j <= this.hiCol; ++j) {
                    double v;
                    b[i][j] = v = 0.25 * (a[i - 1][j] + a[i][j - 1] + a[i + 1][j] + a[i][j + 1]);
                    double diff = v - a[i][j];
                    if (diff < 0.0) {
                        diff = -diff;
                    }
                    if (!(diff > md)) continue;
                    md = diff;
                }
            }
            return md;
        }
    }
}

