/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.jmock.core.Formatting;
import org.jmock.core.SelfDescribing;

public class Invocation
implements SelfDescribing {
    public final Object invokedObject;
    public final Method invokedMethod;
    public final List parameterValues;
    private static final Map BOX_TYPES = Invocation.makeBoxTypesMap();

    public Invocation(Object object, Method method, Object[] objectArray) {
        this.invokedObject = object;
        this.invokedMethod = method;
        this.parameterValues = objectArray == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(Arrays.asList(objectArray));
    }

    public String toString() {
        return this.describeTo(new StringBuffer()).toString();
    }

    public boolean equals(Object object) {
        return object instanceof Invocation && this.equals((Invocation)object);
    }

    public boolean equals(Invocation invocation) {
        return invocation != null && this.invokedObject == invocation.invokedObject && this.invokedMethod.equals(invocation.invokedMethod) && this.parameterValues.equals(invocation.parameterValues);
    }

    public int hashCode() {
        return this.invokedObject.hashCode() ^ this.invokedMethod.hashCode() ^ this.parameterValues.hashCode();
    }

    @Override
    public StringBuffer describeTo(StringBuffer stringBuffer) {
        stringBuffer.append(this.invokedObject.toString()).append(".").append(this.invokedMethod.getName());
        Formatting.join(this.parameterValues, stringBuffer, "(", ")");
        return stringBuffer;
    }

    public void checkReturnTypeCompatibility(Object object) {
        Class<?> clazz = this.invokedMethod.getReturnType();
        if (clazz == Void.TYPE) {
            this.failIfReturnTypeIsNotNull(object);
        } else if (object == null) {
            this.failIfReturnTypeIsPrimitive();
        } else {
            Class<?> clazz2 = object.getClass();
            if (!this.isCompatible(clazz, clazz2)) {
                this.reportTypeError(clazz, clazz2);
            }
        }
    }

    private boolean isCompatible(Class clazz, Class clazz2) {
        if (clazz.isPrimitive()) {
            return this.isBoxedType(clazz, clazz2);
        }
        return clazz.isAssignableFrom(clazz2);
    }

    private boolean isBoxedType(Class clazz, Class clazz2) {
        return BOX_TYPES.get(clazz) == clazz2;
    }

    private void failIfReturnTypeIsNotNull(Object object) {
        Assert.assertNull((String)"tried to return a value from a void method", (Object)object);
    }

    private void failIfReturnTypeIsPrimitive() {
        Class<?> clazz = this.invokedMethod.getReturnType();
        Assert.assertFalse((String)("tried to return null value from method returning " + clazz.getName()), (boolean)clazz.isPrimitive());
    }

    private void reportTypeError(Class clazz, Class clazz2) {
        Assert.fail((String)("tried to return an incompatible value: expected a " + clazz.getName() + " but returned a " + clazz2.getName()));
    }

    private static Map makeBoxTypesMap() {
        HashMap<Class<Comparable<Boolean>>, Class> hashMap = new HashMap<Class<Comparable<Boolean>>, Class>();
        hashMap.put(Boolean.TYPE, Boolean.class);
        hashMap.put(Byte.TYPE, Byte.class);
        hashMap.put(Character.TYPE, Character.class);
        hashMap.put(Short.TYPE, Short.class);
        hashMap.put(Integer.TYPE, Integer.class);
        hashMap.put(Long.TYPE, Long.class);
        hashMap.put(Float.TYPE, Float.class);
        hashMap.put(Double.TYPE, Double.class);
        return hashMap;
    }
}

