/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.ServiceInfo;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSStatefulObject;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.DNSTask;

public abstract class DNSStateTask
extends DNSTask {
    static Logger logger1 = Logger.getLogger(DNSStateTask.class.getName());
    private final int _ttl;
    private static int _defaultTTL = 3600;
    private DNSState _taskState = null;

    public abstract String getTaskDescription();

    public static int defaultTTL() {
        return _defaultTTL;
    }

    public static void setDefaultTTL(int n) {
        _defaultTTL = n;
    }

    public DNSStateTask(JmDNSImpl jmDNSImpl, int n) {
        super(jmDNSImpl);
        this._ttl = n;
    }

    public int getTTL() {
        return this._ttl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void associate(DNSState dNSState) {
        JmDNSImpl jmDNSImpl = this.getDns();
        synchronized (jmDNSImpl) {
            this.getDns().associateWithTask(this, dNSState);
        }
        for (ServiceInfo serviceInfo : this.getDns().getServices().values()) {
            ((ServiceInfoImpl)serviceInfo).associateWithTask(this, dNSState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAssociation() {
        JmDNSImpl jmDNSImpl = this.getDns();
        synchronized (jmDNSImpl) {
            this.getDns().removeAssociationWithTask(this);
        }
        for (ServiceInfo serviceInfo : this.getDns().getServices().values()) {
            ((ServiceInfoImpl)serviceInfo).removeAssociationWithTask(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DNSOutgoing dNSOutgoing = this.createOugoing();
        try {
            if (!this.checkRunCondition()) {
                this.cancel();
                return;
            }
            ArrayList<DNSStatefulObject> arrayList = new ArrayList<DNSStatefulObject>();
            JmDNSImpl jmDNSImpl = this.getDns();
            synchronized (jmDNSImpl) {
                if (this.getDns().isAssociatedWithTask(this, this.getTaskState())) {
                    logger1.finer(this.getName() + ".run() JmDNS " + this.getTaskDescription() + " " + this.getDns().getName());
                    arrayList.add(this.getDns());
                    dNSOutgoing = this.buildOutgoingForDNS(dNSOutgoing);
                }
            }
            for (ServiceInfo serviceInfo : this.getDns().getServices().values()) {
                ServiceInfoImpl serviceInfoImpl;
                ServiceInfoImpl serviceInfoImpl2 = serviceInfoImpl = (ServiceInfoImpl)serviceInfo;
                synchronized (serviceInfoImpl2) {
                    if (serviceInfoImpl.isAssociatedWithTask(this, this.getTaskState())) {
                        logger1.fine(this.getName() + ".run() JmDNS " + this.getTaskDescription() + " " + serviceInfoImpl.getQualifiedName());
                        arrayList.add(serviceInfoImpl);
                        dNSOutgoing = this.buildOutgoingForInfo(serviceInfoImpl, dNSOutgoing);
                    }
                }
            }
            if (dNSOutgoing.isEmpty()) {
                this.advanceObjectsState(arrayList);
                this.cancel();
                return;
            }
            logger1.finer(this.getName() + ".run() JmDNS " + this.getTaskDescription() + " #" + (Object)((Object)this.getTaskState()));
            this.getDns().send(dNSOutgoing);
            this.advanceObjectsState(arrayList);
        }
        catch (Throwable throwable) {
            logger1.log(Level.WARNING, this.getName() + ".run() exception ", throwable);
            this.recoverTask(throwable);
        }
        this.advanceTask();
    }

    protected abstract boolean checkRunCondition();

    protected abstract DNSOutgoing buildOutgoingForDNS(DNSOutgoing var1) throws IOException;

    protected abstract DNSOutgoing buildOutgoingForInfo(ServiceInfoImpl var1, DNSOutgoing var2) throws IOException;

    protected abstract DNSOutgoing createOugoing();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void advanceObjectsState(List<DNSStatefulObject> list) {
        if (list != null) {
            Iterator<DNSStatefulObject> iterator = list.iterator();
            while (iterator.hasNext()) {
                DNSStatefulObject dNSStatefulObject;
                DNSStatefulObject dNSStatefulObject2 = dNSStatefulObject = iterator.next();
                synchronized (dNSStatefulObject2) {
                    dNSStatefulObject.advanceState(this);
                }
            }
        }
    }

    protected abstract void recoverTask(Throwable var1);

    protected abstract void advanceTask();

    protected DNSState getTaskState() {
        return this._taskState;
    }

    protected void setTaskState(DNSState dNSState) {
        this._taskState = dNSState;
    }
}

