/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks.resolver;

import java.io.IOException;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.tasks.resolver.DNSResolverTask;

public class ServiceInfoResolver
extends DNSResolverTask {
    private final ServiceInfoImpl _info;

    public ServiceInfoResolver(JmDNSImpl jmDNSImpl, ServiceInfoImpl serviceInfoImpl) {
        super(jmDNSImpl);
        this._info = serviceInfoImpl;
        serviceInfoImpl.setDns(this.getDns());
        this.getDns().addListener(serviceInfoImpl, DNSQuestion.newQuestion(serviceInfoImpl.getQualifiedName(), DNSRecordType.TYPE_ANY, DNSRecordClass.CLASS_IN, false));
    }

    @Override
    public String getName() {
        return "ServiceInfoResolver(" + (this.getDns() != null ? this.getDns().getName() : "") + ")";
    }

    @Override
    public boolean cancel() {
        boolean bl = super.cancel();
        if (!this._info.isPersistent()) {
            this.getDns().removeListener(this._info);
        }
        return bl;
    }

    @Override
    protected DNSOutgoing addAnswers(DNSOutgoing dNSOutgoing) throws IOException {
        DNSOutgoing dNSOutgoing2 = dNSOutgoing;
        if (!this._info.hasData()) {
            long l = System.currentTimeMillis();
            dNSOutgoing2 = this.addAnswer(dNSOutgoing2, (DNSRecord)this.getDns().getCache().getDNSEntry(this._info.getQualifiedName(), DNSRecordType.TYPE_SRV, DNSRecordClass.CLASS_IN), l);
            dNSOutgoing2 = this.addAnswer(dNSOutgoing2, (DNSRecord)this.getDns().getCache().getDNSEntry(this._info.getQualifiedName(), DNSRecordType.TYPE_TXT, DNSRecordClass.CLASS_IN), l);
            if (this._info.getServer().length() > 0) {
                dNSOutgoing2 = this.addAnswer(dNSOutgoing2, (DNSRecord)this.getDns().getCache().getDNSEntry(this._info.getServer(), DNSRecordType.TYPE_A, DNSRecordClass.CLASS_IN), l);
                dNSOutgoing2 = this.addAnswer(dNSOutgoing2, (DNSRecord)this.getDns().getCache().getDNSEntry(this._info.getServer(), DNSRecordType.TYPE_AAAA, DNSRecordClass.CLASS_IN), l);
            }
        }
        return dNSOutgoing2;
    }

    @Override
    protected DNSOutgoing addQuestions(DNSOutgoing dNSOutgoing) throws IOException {
        DNSOutgoing dNSOutgoing2 = dNSOutgoing;
        if (!this._info.hasData()) {
            dNSOutgoing2 = this.addQuestion(dNSOutgoing2, DNSQuestion.newQuestion(this._info.getQualifiedName(), DNSRecordType.TYPE_SRV, DNSRecordClass.CLASS_IN, false));
            dNSOutgoing2 = this.addQuestion(dNSOutgoing2, DNSQuestion.newQuestion(this._info.getQualifiedName(), DNSRecordType.TYPE_TXT, DNSRecordClass.CLASS_IN, false));
            if (this._info.getServer().length() > 0) {
                dNSOutgoing2 = this.addQuestion(dNSOutgoing2, DNSQuestion.newQuestion(this._info.getServer(), DNSRecordType.TYPE_A, DNSRecordClass.CLASS_IN, false));
                dNSOutgoing2 = this.addQuestion(dNSOutgoing2, DNSQuestion.newQuestion(this._info.getServer(), DNSRecordType.TYPE_AAAA, DNSRecordClass.CLASS_IN, false));
            }
        }
        return dNSOutgoing2;
    }

    @Override
    protected String description() {
        return "querying service info: " + (this._info != null ? this._info.getQualifiedName() : "null");
    }
}

