/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.text.Position;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatContact;
import net.java.sip.communicator.impl.gui.main.chat.conference.ChatContactRoleIcon;
import net.java.sip.communicator.impl.gui.main.chat.conference.ConferenceChatContact;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactListCellRenderer;
import net.java.sip.communicator.plugin.desktoputil.ExtendedTooltip;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.util.skin.Skinnable;

public class DefaultContactList
extends JList
implements Skinnable {
    private static final long serialVersionUID = 0L;
    private MouseEvent cachedMouseEvent;
    ContactListCellRenderer renderer = new ContactListCellRenderer();

    public DefaultContactList() {
        this.setOpaque(false);
        this.getSelectionModel().setSelectionMode(2);
        this.setDragEnabled(true);
        this.setCellRenderer(this.renderer);
    }

    public boolean isMetaContactActive(MetaContact metaContact) {
        return false;
    }

    public boolean isGroupClosed(MetaContactGroup group) {
        return false;
    }

    public PresenceStatus getMetaContactStatus(MetaContact metaContact) {
        PresenceStatus status = null;
        Iterator i = metaContact.getContacts();
        while (i.hasNext()) {
            Contact protoContact = (Contact)i.next();
            PresenceStatus contactStatus = protoContact.getPresenceStatus();
            if (status == null) {
                status = contactStatus;
                continue;
            }
            status = contactStatus.compareTo(status) > 0 ? contactStatus : status;
        }
        return status;
    }

    @Override
    public JToolTip createToolTip() {
        Point currentMouseLocation = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(currentMouseLocation, this);
        int index = this.locationToIndex(currentMouseLocation);
        Object element = this.getModel().getElementAt(index);
        ExtendedTooltip tip = new ExtendedTooltip(true);
        if (element instanceof MetaContact) {
            MetaContact metaContact = (MetaContact)element;
            byte[] avatarImage = metaContact.getAvatar();
            if (avatarImage != null && avatarImage.length > 0) {
                tip.setImage(new ImageIcon(avatarImage));
            }
            tip.setTitle(metaContact.getDisplayName());
            Iterator i = metaContact.getContacts();
            String statusMessage = null;
            while (i.hasNext()) {
                Contact protocolContact = (Contact)i.next();
                ImageIcon protocolStatusIcon = new ImageIcon(protocolContact.getPresenceStatus().getStatusIcon());
                String contactAddress = protocolContact.getAddress();
                tip.addLine((Icon)protocolStatusIcon, contactAddress);
                if (statusMessage != null || protocolContact.getStatusMessage() == null || protocolContact.getStatusMessage().length() <= 0) continue;
                statusMessage = protocolContact.getStatusMessage();
            }
            if (statusMessage != null) {
                tip.setBottomText(statusMessage);
            }
        } else if (element instanceof MetaContactGroup) {
            MetaContactGroup metaGroup = (MetaContactGroup)element;
            tip.setTitle(metaGroup.getGroupName());
        } else if (element instanceof ChatContact) {
            ChatContact chatContact = (ChatContact)element;
            ImageIcon avatarImage = chatContact.getAvatar();
            if (avatarImage != null) {
                tip.setImage(avatarImage);
            }
            tip.setTitle(chatContact.getName());
            Object descriptor = chatContact.getDescriptor();
            if (descriptor instanceof ChatRoomMember) {
                ChatRoomMember member = (ChatRoomMember)descriptor;
                String roleName = GuiActivator.getResources().getI18NString(member.getRole().getLocalizedRoleName());
                tip.addLine(ChatContactRoleIcon.getRoleIcon(member.getRole()), roleName);
                PresenceStatus status = member.getPresenceStatus();
                tip.addLine(null, status.getStatusName());
            }
        }
        tip.setComponent((JComponent)this);
        return tip;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Point currentMouseLocation = event.getPoint();
        int index = this.locationToIndex(currentMouseLocation);
        if (index == -1) {
            return null;
        }
        Object element = this.getModel().getElementAt(index);
        if (element instanceof MetaContact) {
            MetaContact metaContact = (MetaContact)element;
            return metaContact.getMetaUID();
        }
        if (element instanceof MetaContactGroup) {
            MetaContactGroup metaGroup = (MetaContactGroup)element;
            return metaGroup.getMetaUID();
        }
        if (element instanceof ChatContact) {
            ChatContact chatContact = (ChatContact)element;
            return chatContact.getUID();
        }
        return null;
    }

    @Override
    public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
        int max = this.getModel().getSize();
        if (prefix == null) {
            throw new IllegalArgumentException("prefix");
        }
        if (startIndex < 0 || startIndex >= max) {
            throw new IllegalArgumentException("startIndex");
        }
        prefix = prefix.toUpperCase();
        int increment = bias == Position.Bias.Forward ? 1 : -1;
        int index = startIndex;
        do {
            Object o;
            if ((o = this.getModel().getElementAt(index)) == null) continue;
            String contactName = null;
            if (o instanceof MetaContact) {
                contactName = ((MetaContact)o).getDisplayName().toUpperCase();
            } else if (o instanceof ConferenceChatContact) {
                contactName = ((ConferenceChatContact)o).getName().toUpperCase();
            }
            if (contactName == null || !contactName.startsWith(prefix)) continue;
            return index;
        } while ((index = (index + increment + max) % max) != startIndex);
        return -1;
    }

    @Override
    protected void fireSelectionValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
        if (this.cachedMouseEvent != null) {
            super.processMouseEvent(new MouseEvent((Component)this.cachedMouseEvent.getSource(), this.cachedMouseEvent.getID(), this.cachedMouseEvent.getWhen(), this.cachedMouseEvent.getModifiers(), this.cachedMouseEvent.getX(), this.cachedMouseEvent.getY(), this.cachedMouseEvent.getClickCount(), this.cachedMouseEvent.isPopupTrigger()));
            this.cachedMouseEvent = null;
        }
        super.fireSelectionValueChanged(firstIndex, lastIndex, isAdjusting);
    }

    @Override
    protected void processMouseEvent(MouseEvent event) {
        if ((event.getModifiersEx() & 0x400) != 0) {
            this.cachedMouseEvent = event;
        }
        super.processMouseEvent(event);
    }

    public void loadSkin() {
        this.renderer.loadSkin();
    }
}

