/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat;

import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.call.CallPanel;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTabbedPane;
import net.java.sip.communicator.plugin.desktoputil.event.CloseListener;
import net.java.sip.communicator.util.skin.Skinnable;

public class ConversationTabbedPane
extends SIPCommTabbedPane
implements Skinnable {
    public ConversationTabbedPane() {
        super(true, false);
        this.addCloseListener(new CloseListener(){

            public void closeOperation(MouseEvent e) {
                int tabIndex = ConversationTabbedPane.this.getOverTabIndex();
                Component c = ConversationTabbedPane.this.getComponentAt(tabIndex);
                if (c instanceof ChatPanel) {
                    GuiActivator.getUIService().getChatWindowManager().closeChat((ChatPanel)((Object)c));
                } else if (c instanceof CallPanel) {
                    CallManager.hangupCalls(((CallPanel)((Object)c)).getCallConference());
                }
            }
        });
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Component c;
                int index = ConversationTabbedPane.this.getSelectedIndex();
                if (index > 0 && (c = ConversationTabbedPane.this.getComponentAt(index)) instanceof ChatPanel) {
                    GuiActivator.getUIService().getChatWindowManager().removeNonReadChatState((ChatPanel)((Object)c));
                }
            }
        });
    }

    public void setSelectedIndex(int tabIndex) {
        if (tabIndex < 0) {
            return;
        }
        Component c = this.getComponentAt(tabIndex);
        if (c instanceof ChatPanel) {
            ChatPanel chatPanel = (ChatPanel)((Object)c);
            int unreadMessageNumber = chatPanel.unreadMessageNumber;
            if (unreadMessageNumber > 0) {
                String tabTitle = chatPanel.getChatSession().getChatName();
                this.setTitleAt(tabIndex, tabTitle);
            }
            chatPanel.unreadMessageNumber = 0;
        }
        super.setSelectedIndex(tabIndex);
    }

    public void highlightTab(int tabIndex, int unreadMessageNumber) {
        Component c = this.getComponentAt(tabIndex);
        String tabTitle = "";
        if (c instanceof ChatPanel) {
            tabTitle = ((ChatPanel)((Object)c)).getChatSession().getChatName();
        } else if (c instanceof CallPanel) {
            tabTitle = ((CallPanel)((Object)c)).getCallTitle();
        }
        if (unreadMessageNumber > 0) {
            tabTitle = "(" + unreadMessageNumber + ") " + tabTitle;
        }
        this.setTitleAt(tabIndex, tabTitle);
        super.highlightTab(tabIndex);
    }

    public void loadSkin() {
        super.loadSkin();
        int count = this.getTabCount();
        for (int i = 0; i < count; ++i) {
            Component c = this.getComponentAt(i);
            if (!(c instanceof ChatPanel)) continue;
            this.setIconAt(i, ((ChatPanel)((Object)c)).getChatSession().getChatStatusIcon());
        }
    }
}

