/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat;

import com.explodingpixels.macwidgets.MacUtils;
import com.explodingpixels.macwidgets.UnifiedToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.MenuSelectionManager;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.UIServiceImpl;
import net.java.sip.communicator.impl.gui.event.PluginComponentEvent;
import net.java.sip.communicator.impl.gui.event.PluginComponentListener;
import net.java.sip.communicator.impl.gui.main.chat.ChatChangeListener;
import net.java.sip.communicator.impl.gui.main.chat.ChatContainer;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.ChatSession;
import net.java.sip.communicator.impl.gui.main.chat.ChatWritePanel;
import net.java.sip.communicator.impl.gui.main.chat.ContactPhotoPanel;
import net.java.sip.communicator.impl.gui.main.chat.ConversationTabbedPane;
import net.java.sip.communicator.impl.gui.main.chat.menus.ChatRightButtonMenu;
import net.java.sip.communicator.impl.gui.main.chat.menus.MessageWindowMenuBar;
import net.java.sip.communicator.impl.gui.main.chat.menus.WritePanelRightButtonMenu;
import net.java.sip.communicator.impl.gui.main.chat.toolBars.MainToolBar;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.SIPCommFrame;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.UIAction;
import net.java.sip.communicator.service.gui.ExportedWindow;
import net.java.sip.communicator.service.gui.PluginComponentFactory;
import net.java.sip.communicator.service.gui.WindowID;
import net.java.sip.communicator.service.keybindings.KeybindingSet;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.util.OSUtils;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ChatWindow
extends SIPCommFrame
implements ChatContainer,
ExportedWindow,
PluginComponentListener,
WindowFocusListener {
    private static final Logger logger = Logger.getLogger(ChatWindow.class);
    private ConversationTabbedPane chatTabbedPane = null;
    private int chatCount = 0;
    private final List<ChatChangeListener> chatChangeListeners = new Vector<ChatChangeListener>();
    private final JPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout());
    private final JPanel statusBarPanel = new TransparentPanel((LayoutManager)new BorderLayout());
    private final JPanel pluginPanelSouth = new JPanel();
    private final JPanel pluginPanelWest = new JPanel();
    private final JPanel pluginPanelEast = new JPanel();
    private final ContactPhotoPanel contactPhotoPanel;
    private final MessageWindowMenuBar menuBar;
    private MainToolBar mainToolBar;
    private final Component toolbarPanel;
    private KeyboardFocusManager keyManager;
    private KeyEventDispatcher keyDispatcher;

    public ChatWindow() {
        if (!ConfigurationUtils.isWindowDecorated()) {
            this.setUndecorated(true);
        }
        this.addWindowFocusListener(this);
        this.setDefaultCloseOperation(0);
        if (ConfigurationUtils.isMultiChatWindowEnabled()) {
            this.chatTabbedPane = new ConversationTabbedPane();
        }
        this.menuBar = new MessageWindowMenuBar(this);
        this.contactPhotoPanel = new ContactPhotoPanel();
        this.setJMenuBar(this.menuBar);
        this.toolbarPanel = this.createToolBar();
        this.getContentPane().add(this.toolbarPanel, "North");
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)this.statusBarPanel, "South");
        this.initPluginComponents();
        this.setKeybindingInput(KeybindingSet.Category.CHAT);
        this.addKeybindingAction("chat-nextTab", (Action)((Object)new ForwardTabAction()));
        this.addKeybindingAction("chat-previousTab", (Action)((Object)new BackwordTabAction()));
        this.addKeybindingAction("chat-copy", (Action)((Object)new CopyAction()));
        this.addKeybindingAction("chat-paste", (Action)((Object)new PasteAction()));
        this.addKeybindingAction("chat-openSmileys", (Action)((Object)new OpenSmileyAction()));
        this.addKeybindingAction("chat-openHistory", (Action)((Object)new OpenHistoryAction()));
        this.addKeybindingAction("chat-close", (Action)((Object)new CloseAction()));
        this.addWindowListener(new ChatWindowAdapter());
        int width = GuiActivator.getResources().getSettingsInt("impl.gui.CHAT_WINDOW_WIDTH");
        int height = GuiActivator.getResources().getSettingsInt("impl.gui.CHAT_WINDOW_HEIGHT");
        this.setSize(width, height);
    }

    @Override
    public void setToolbarVisible(boolean b) {
        this.toolbarPanel.setVisible(b);
    }

    public void dispose() {
        try {
            UIServiceImpl uiService = GuiActivator.getUIService();
            uiService.unregisterExportedWindow(this);
            uiService.removePluginComponentListener(this);
            this.mainToolBar.dispose();
            this.menuBar.dispose();
        }
        finally {
            super.dispose();
        }
    }

    public MainToolBar getMainToolBar() {
        return this.mainToolBar;
    }

    @Override
    public void addChat(ChatPanel chatPanel) {
        if (ConfigurationUtils.isMultiChatWindowEnabled()) {
            this.addChatTab(chatPanel);
        } else {
            this.addSimpleChat(chatPanel);
        }
        ++this.chatCount;
        chatPanel.setShown(true);
        for (ChatChangeListener l : this.chatChangeListeners) {
            l.chatChanged(chatPanel);
        }
    }

    private Component createToolBar() {
        Object toolbarPanel = null;
        this.mainToolBar = new MainToolBar(this);
        boolean chatToolbarVisible = ConfigurationUtils.isChatToolbarVisible();
        if (OSUtils.IS_MAC) {
            UnifiedToolBar macToolbarPanel = new UnifiedToolBar();
            MacUtils.makeWindowLeopardStyle(this.getRootPane());
            macToolbarPanel.addComponentToLeft((JComponent)((Object)this.mainToolBar));
            macToolbarPanel.addComponentToRight(this.contactPhotoPanel);
            macToolbarPanel.disableBackgroundPainter();
            macToolbarPanel.installWindowDraggerOnWindow((Window)((Object)this));
            macToolbarPanel.getComponent().setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            macToolbarPanel.getComponent().setVisible(chatToolbarVisible);
            toolbarPanel = macToolbarPanel.getComponent();
        } else {
            ToolbarPanel panel = new ToolbarPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
            panel.add((Component)((Object)this.mainToolBar), "Center");
            panel.add(this.contactPhotoPanel, "East");
            panel.setVisible(chatToolbarVisible);
            toolbarPanel = panel;
        }
        return toolbarPanel;
    }

    private void addSimpleChat(ChatPanel chatPanel) {
        this.mainPanel.add((Component)((Object)chatPanel), "Center");
    }

    private void addChatTab(ChatPanel chatPanel) {
        ChatSession chatSession = chatPanel.getChatSession();
        String chatName = chatSession.getChatName();
        ChatPanel currentChatPanel = this.getCurrentChat();
        if (currentChatPanel == null) {
            this.mainPanel.add((Component)((Object)chatPanel), "Center");
        } else if (this.getChatTabCount() == 0) {
            ChatSession firstChatSession = currentChatPanel.getChatSession();
            this.chatTabbedPane.addTab(firstChatSession.getChatName(), firstChatSession.getChatStatusIcon(), (Component)((Object)currentChatPanel));
            this.chatTabbedPane.addTab(chatName, chatSession.getChatStatusIcon(), (Component)((Object)chatPanel));
            this.chatTabbedPane.setSelectedComponent((Component)((Object)currentChatPanel));
            this.mainPanel.add((Component)((Object)this.chatTabbedPane), "Center");
            this.mainPanel.validate();
        } else {
            this.chatTabbedPane.addTab(chatName, chatSession.getChatStatusIcon(), (Component)((Object)chatPanel));
            this.chatTabbedPane.getParent().validate();
        }
    }

    @Override
    public void removeChat(ChatPanel chatPanel) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removes chat for contact: " + chatPanel.getChatSession().getChatName()));
        }
        if (this.getChatTabCount() == 0) {
            this.mainPanel.remove((Component)((Object)chatPanel));
            --this.chatCount;
        } else {
            int index = this.chatTabbedPane.indexOfComponent((Component)((Object)chatPanel));
            if (index != -1) {
                if (this.chatTabbedPane.getTabCount() > 1) {
                    this.chatTabbedPane.removeTabAt(index);
                }
                if (this.chatTabbedPane.getTabCount() == 1) {
                    ChatPanel currentChatPanel = this.getCurrentChat();
                    this.chatTabbedPane.removeAll();
                    this.mainPanel.remove((Component)((Object)this.chatTabbedPane));
                    this.mainPanel.add((Component)((Object)currentChatPanel), "Center");
                    this.setCurrentChat(currentChatPanel);
                    GuiActivator.getUIService().getChatWindowManager().removeNonReadChatState(currentChatPanel);
                }
                --this.chatCount;
            }
        }
        if (this.getChatCount() == 0) {
            this.dispose();
        }
    }

    @Override
    public void removeAllChats() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Remove all tabs from the chat window.");
        }
        if (this.getChatTabCount() > 0) {
            this.chatTabbedPane.removeAll();
            this.mainPanel.remove((Component)((Object)this.chatTabbedPane));
            this.chatCount = 0;
        } else {
            this.removeChat(this.getCurrentChat());
        }
        this.dispose();
    }

    @Override
    public void setCurrentChat(ChatPanel chatPanel) {
        ChatSession chatSession = chatPanel.getChatSession();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Set current chat panel to: " + chatSession.getChatName()));
        }
        if (this.getChatTabCount() > 0) {
            this.chatTabbedPane.setSelectedComponent((Component)((Object)chatPanel));
        }
        this.setTitle(chatSession.getChatName());
        this.setChatContactPhoto(chatSession);
        this.mainToolBar.getSmileysBox().setChat(chatPanel);
        chatPanel.requestFocusInWriteArea();
        for (ChatChangeListener l : this.chatChangeListeners) {
            l.chatChanged(chatPanel);
        }
    }

    public void setCurrentChatTab(int index) {
        if (this.getChatTabCount() > 0) {
            ChatPanel chatPanel = (ChatPanel)((Object)this.chatTabbedPane.getComponentAt(index));
            this.setCurrentChat(chatPanel);
        }
    }

    @Override
    public ChatPanel getCurrentChat() {
        if (this.getChatTabCount() > 0) {
            return (ChatPanel)((Object)this.chatTabbedPane.getSelectedComponent());
        }
        int componentCount = this.mainPanel.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            Component c = this.mainPanel.getComponent(i);
            if (!(c instanceof ChatPanel)) continue;
            return (ChatPanel)((Object)c);
        }
        return null;
    }

    @Override
    public List<ChatPanel> getChats() {
        Object container = this.getChatTabCount() > 0 ? this.chatTabbedPane : this.mainPanel;
        int componentCount = ((Container)container).getComponentCount();
        ArrayList<ChatPanel> chatPanels = new ArrayList<ChatPanel>(componentCount);
        for (int i = 0; i < componentCount; ++i) {
            Component c = ((Container)container).getComponent(i);
            if (!(c instanceof ChatPanel)) continue;
            chatPanels.add((ChatPanel)((Object)c));
        }
        return chatPanels;
    }

    private int getChatTabCount() {
        return this.chatTabbedPane == null ? 0 : this.chatTabbedPane.getTabCount();
    }

    private void highlightTab(ChatPanel chatPanel) {
        int tabIndex = this.chatTabbedPane.indexOfComponent((Component)((Object)chatPanel));
        if (tabIndex > -1) {
            ++chatPanel.unreadMessageNumber;
            this.chatTabbedPane.highlightTab(tabIndex, chatPanel.unreadMessageNumber);
        }
    }

    public void setTabIcon(ChatPanel chatPanel, Icon icon) {
        int index = this.chatTabbedPane.indexOfComponent((Component)((Object)chatPanel));
        if (index > -1) {
            this.chatTabbedPane.setIconAt(index, icon);
        }
    }

    public void setTabTitle(ChatPanel chatPanel, String title) {
        int index = this.chatTabbedPane.indexOfComponent((Component)((Object)chatPanel));
        if (index > -1) {
            this.chatTabbedPane.setTitleAt(index, title);
        }
    }

    protected void close(boolean isEscaped) {
        if (isEscaped) {
            ChatPanel chatPanel = this.getCurrentChat();
            if (chatPanel == null || chatPanel.getChatConversationPanel() == null) {
                return;
            }
            ChatRightButtonMenu chatRightMenu = chatPanel.getChatConversationPanel().getRightButtonMenu();
            ChatWritePanel chatWritePanel = chatPanel.getChatWritePanel();
            WritePanelRightButtonMenu writePanelRightMenu = chatWritePanel.getRightButtonMenu();
            if (chatRightMenu.isVisible()) {
                chatRightMenu.setVisible(false);
            } else if (writePanelRightMenu.isVisible()) {
                writePanelRightMenu.setVisible(false);
            } else if (this.menuBar.getSelectedMenu() != null || this.mainToolBar.getSmileysBox().getPopupMenu().isVisible()) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            } else {
                GuiActivator.getUIService().getChatWindowManager().closeChat(chatPanel);
            }
        } else if (ConfigurationUtils.isMultiChatWindowEnabled()) {
            GuiActivator.getUIService().getChatWindowManager().closeAllChats(this, true);
        } else {
            ChatPanel chatPanel = this.getCurrentChat();
            if (chatPanel == null || chatPanel.getChatConversationPanel() == null) {
                return;
            }
            GuiActivator.getUIService().getChatWindowManager().closeChat(chatPanel);
        }
    }

    public WindowID getIdentifier() {
        return ExportedWindow.CHAT_WINDOW;
    }

    public void minimize() {
        this.setExtendedState(1);
    }

    public void maximize() {
        this.setExtendedState(6);
    }

    public void bringToFront() {
        if (this.getExtendedState() == 1) {
            this.setExtendedState(0);
        }
        this.toFront();
    }

    private void initPluginComponents() {
        Collection serRefs;
        GuiActivator.getUIService().addPluginComponentListener(this);
        this.pluginPanelEast.setLayout(new BoxLayout(this.pluginPanelEast, 1));
        this.pluginPanelSouth.setLayout(new BoxLayout(this.pluginPanelSouth, 1));
        this.pluginPanelWest.setLayout(new BoxLayout(this.pluginPanelWest, 1));
        this.getContentPane().add((Component)this.pluginPanelEast, "East");
        this.getContentPane().add((Component)this.pluginPanelWest, "West");
        this.mainPanel.add((Component)this.pluginPanelSouth, "South");
        String osgiFilter = "(|(CONTAINER_ID=" + net.java.sip.communicator.service.gui.Container.CONTAINER_CHAT_WINDOW.getID() + ")(" + "CONTAINER_ID" + "=" + net.java.sip.communicator.service.gui.Container.CONTAINER_CHAT_STATUS_BAR.getID() + "))";
        try {
            serRefs = GuiActivator.bundleContext.getServiceReferences(PluginComponentFactory.class, osgiFilter);
        }
        catch (InvalidSyntaxException ex) {
            serRefs = null;
            logger.error((Object)"Could not obtain plugin component reference.", (Throwable)ex);
        }
        if (serRefs != null && !serRefs.isEmpty()) {
            for (ServiceReference serRef : serRefs) {
                PluginComponentFactory factory = (PluginComponentFactory)GuiActivator.bundleContext.getService(serRef);
                Component comp = (Component)factory.getPluginComponentInstance((Object)this).getComponent();
                if (comp.getParent() != null) {
                    return;
                }
                Object borderLayoutConstraints = UIServiceImpl.getBorderLayoutConstraintsFromContainer(factory.getConstraints());
                this.addPluginComponent(comp, factory.getContainer(), borderLayoutConstraints);
            }
        }
    }

    @Override
    public void pluginComponentAdded(PluginComponentEvent event) {
        PluginComponentFactory factory = event.getPluginComponentFactory();
        Component comp = (Component)factory.getPluginComponentInstance((Object)this).getComponent();
        if (comp.getParent() != null) {
            return;
        }
        if (factory.getContainer().equals((Object)net.java.sip.communicator.service.gui.Container.CONTAINER_CHAT_WINDOW) || factory.getContainer().equals((Object)net.java.sip.communicator.service.gui.Container.CONTAINER_CHAT_STATUS_BAR)) {
            Object borderLayoutConstraints = UIServiceImpl.getBorderLayoutConstraintsFromContainer(factory.getConstraints());
            this.addPluginComponent(comp, factory.getContainer(), borderLayoutConstraints);
        }
    }

    @Override
    public void pluginComponentRemoved(PluginComponentEvent event) {
        PluginComponentFactory factory = event.getPluginComponentFactory();
        if (factory.getContainer().equals((Object)net.java.sip.communicator.service.gui.Container.CONTAINER_CHAT_WINDOW) || factory.getContainer().equals((Object)net.java.sip.communicator.service.gui.Container.CONTAINER_CHAT_STATUS_BAR)) {
            Object borderLayoutConstraint = UIServiceImpl.getBorderLayoutConstraintsFromContainer(factory.getConstraints());
            this.removePluginComponent((Component)factory.getPluginComponentInstance((Object)this).getComponent(), factory.getContainer(), borderLayoutConstraint);
            this.pack();
        }
    }

    public Object getSource() {
        return this;
    }

    @Override
    public int getChatCount() {
        return this.chatCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChatChangeListener(ChatChangeListener listener) {
        List<ChatChangeListener> list = this.chatChangeListeners;
        synchronized (list) {
            if (!this.chatChangeListeners.contains(listener)) {
                this.chatChangeListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChatChangeListener(ChatChangeListener listener) {
        List<ChatChangeListener> list = this.chatChangeListeners;
        synchronized (list) {
            this.chatChangeListeners.remove(listener);
        }
    }

    private void addPluginComponent(Component c, net.java.sip.communicator.service.gui.Container container, Object constraints) {
        if (container.equals((Object)net.java.sip.communicator.service.gui.Container.CONTAINER_CHAT_WINDOW)) {
            if (constraints.equals("South")) {
                this.pluginPanelSouth.add(c);
                this.pluginPanelSouth.repaint();
            } else if (constraints.equals("West")) {
                this.pluginPanelWest.add(c);
                this.pluginPanelSouth.repaint();
            } else if (constraints.equals("East")) {
                this.pluginPanelEast.add(c);
                this.pluginPanelSouth.repaint();
            }
        } else if (container.equals((Object)net.java.sip.communicator.service.gui.Container.CONTAINER_CHAT_STATUS_BAR)) {
            this.statusBarPanel.add(c);
        }
        this.getContentPane().repaint();
    }

    private void removePluginComponent(Component c, net.java.sip.communicator.service.gui.Container container, Object constraints) {
        if (container.equals((Object)net.java.sip.communicator.service.gui.Container.CONTAINER_CHAT_WINDOW)) {
            if (constraints.equals("South")) {
                this.pluginPanelSouth.remove(c);
            } else if (constraints.equals("West")) {
                this.pluginPanelWest.remove(c);
            } else if (constraints.equals("East")) {
                this.pluginPanelEast.remove(c);
            }
        } else if (container.equals((Object)net.java.sip.communicator.service.gui.Container.CONTAINER_CHAT_STATUS_BAR)) {
            this.statusBarPanel.remove(c);
        }
    }

    private void setChatContactPhoto(ChatSession chatSession) {
        this.contactPhotoPanel.setChatSession(chatSession);
        byte[] chatAvatar = chatSession.getChatAvatar();
        if (chatAvatar != null && chatAvatar.length > 0) {
            ImageIcon contactPhotoIcon = ImageUtils.getScaledRoundedIcon((byte[])chatAvatar, (int)128, (int)128);
            if (contactPhotoIcon != null) {
                this.setIconImage(contactPhotoIcon.getImage());
            }
        } else {
            this.setIconImage(ImageLoader.getImage(ImageLoader.SIP_COMMUNICATOR_LOGO));
        }
    }

    public void setParams(Object[] windowParams) {
    }

    @Override
    public void windowGainedFocus(WindowEvent evt) {
        ChatPanel currentChat = this.getCurrentChat();
        if (currentChat != null) {
            GuiActivator.getUIService().getChatWindowManager().removeNonReadChatState(currentChat);
        }
    }

    @Override
    public void windowLostFocus(WindowEvent arg0) {
    }

    public void directoryDropped(File dir, Point point) {
    }

    public void fileDropped(File file, Point point) {
        this.getCurrentChat().sendFile(file);
    }

    @Override
    public void openChat(ChatPanel chatPanel, boolean setSelected) {
        boolean isWindowVisible = this.isVisible();
        if (this.getExtendedState() != 1) {
            if (ConfigurationUtils.isAutoPopupNewMessage() || setSelected) {
                if (!this.isVisible()) {
                    this.setVisible(true);
                }
                this.toFront();
            } else if (!isWindowVisible) {
                this.setFocusableWindowState(false);
                if (!OSUtils.IS_MAC) {
                    this.setState(1);
                }
                this.setVisible(true);
                this.setFocusableWindowState(true);
            }
        } else {
            String chatWindowTitle;
            if (setSelected) {
                this.setExtendedState(0);
                this.toFront();
            }
            if (!(chatWindowTitle = this.getTitle()).startsWith("*")) {
                this.setTitle("*" + chatWindowTitle);
            }
        }
        if (setSelected || !isWindowVisible) {
            this.setCurrentChat(chatPanel);
        } else if (!this.getCurrentChat().equals(chatPanel) && this.getChatTabCount() > 0) {
            this.highlightTab(chatPanel);
        }
    }

    @Override
    public Frame getFrame() {
        return this;
    }

    @Override
    public void setChatTitle(ChatPanel chatPanel, String title) {
        this.setTabTitle(chatPanel, title);
    }

    @Override
    public void setChatIcon(ChatPanel chatPanel, Icon icon) {
        this.setTabIcon(chatPanel, icon);
    }

    public boolean isFrameActive() {
        return this.isActive();
    }

    @Override
    public void updateHistoryButtonState(ChatPanel chatPanel) {
        this.mainToolBar.changeHistoryButtonsState(chatPanel);
    }

    private class MainKeyDispatcher
    implements KeyEventDispatcher {
        private final KeyboardFocusManager keyManager;

        public MainKeyDispatcher(KeyboardFocusManager keyManager) {
            this.keyManager = keyManager;
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (!ChatWindow.this.isFocused() || e.getID() != 400) {
                return false;
            }
            if (e.getKeyChar() == '\uffff' || e.getKeyCode() == 10) {
                return false;
            }
            if (ChatWindow.this.getCurrentChat() == null) {
                return false;
            }
            ChatWritePanel chatWritePanel = ChatWindow.this.getCurrentChat().getChatWritePanel();
            JEditorPane chatWriteEditor = chatWritePanel.getEditorPane();
            if (ChatWindow.this.menuBar.getSelectedMenu() != null && ChatWindow.this.menuBar.getSelectedMenu().isPopupMenuVisible()) {
                return false;
            }
            if (this.keyManager.getFocusOwner() != null && !chatWritePanel.isFocusOwner()) {
                chatWriteEditor.requestFocusInWindow();
                this.keyManager.redispatchEvent(chatWriteEditor, e);
                return true;
            }
            return false;
        }
    }

    private static class ToolbarPanel
    extends TransparentPanel
    implements Skinnable {
        private Image logoBgImage;

        public ToolbarPanel(LayoutManager layoutManager) {
            super(layoutManager);
            this.loadSkin();
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.logoBgImage != null) {
                g.drawImage(this.logoBgImage, (this.getWidth() - this.logoBgImage.getWidth(null)) / 2, 0, null);
            }
        }

        public void loadSkin() {
            Image logoBgImage = ImageLoader.getImage(ImageLoader.WINDOW_TITLE_BAR);
            if (logoBgImage != null) {
                logoBgImage = ImageUtils.scaleImageWithinBounds((Image)logoBgImage, (int)80, (int)35);
            }
            this.logoBgImage = logoBgImage;
        }
    }

    public class ChatWindowAdapter
    extends WindowAdapter {
        @Override
        public void windowDeiconified(WindowEvent e) {
            String title = ChatWindow.this.getTitle();
            if (title.startsWith("*")) {
                ChatWindow.this.setTitle(title.substring(1, title.length()));
            }
        }

        @Override
        public void windowOpened(WindowEvent e) {
            if (ChatWindow.this.keyManager == null) {
                ChatWindow.this.keyManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                if (ChatWindow.this.keyDispatcher == null) {
                    ChatWindow.this.keyDispatcher = new MainKeyDispatcher(ChatWindow.this.keyManager);
                }
                ChatWindow.this.keyManager.addKeyEventDispatcher(ChatWindow.this.keyDispatcher);
            }
        }

        @Override
        public void windowClosed(WindowEvent e) {
            if (ChatWindow.this.keyManager != null) {
                ChatWindow.this.keyManager.removeKeyEventDispatcher(ChatWindow.this.keyDispatcher);
            }
            ChatWindow.this.keyManager = null;
            ChatWindow.this.keyDispatcher = null;
        }
    }

    private class CloseAction
    extends UIAction {
        private CloseAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ChatWindow.this.close(true);
        }
    }

    private class OpenHistoryAction
    extends UIAction {
        private OpenHistoryAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ChatWindow.this.mainToolBar.getHistoryButton().doClick();
        }
    }

    private class OpenSmileyAction
    extends UIAction {
        private OpenSmileyAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ChatWindow.this.mainToolBar.getSmileysBox().open();
        }
    }

    private class PasteAction
    extends UIAction {
        private PasteAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ChatWindow.this.getCurrentChat().paste();
        }
    }

    private class CopyAction
    extends UIAction {
        private CopyAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ChatWindow.this.getCurrentChat().copy();
        }
    }

    private class BackwordTabAction
    extends UIAction {
        private BackwordTabAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ChatWindow.this.getChatTabCount() > 0) {
                int selectedIndex = ChatWindow.this.chatTabbedPane.getSelectedIndex();
                if (selectedIndex != 0) {
                    ChatWindow.this.setCurrentChatTab(selectedIndex - 1);
                } else {
                    ChatWindow.this.setCurrentChatTab(ChatWindow.this.chatTabbedPane.getTabCount() - 1);
                }
            }
        }
    }

    private class ForwardTabAction
    extends UIAction {
        private ForwardTabAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ChatWindow.this.getChatTabCount() > 0) {
                int selectedIndex = ChatWindow.this.chatTabbedPane.getSelectedIndex();
                if (selectedIndex < ChatWindow.this.chatTabbedPane.getTabCount() - 1) {
                    ChatWindow.this.setCurrentChatTab(selectedIndex + 1);
                } else {
                    ChatWindow.this.setCurrentChatTab(0);
                }
            }
        }
    }
}

