/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import com.explodingpixels.macwidgets.HudWidgetFactory;
import com.explodingpixels.macwidgets.HudWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.account.Account;
import net.java.sip.communicator.impl.gui.main.call.CallToolBar;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.ComponentMover;
import net.java.sip.communicator.plugin.desktoputil.SIPCommButton;
import net.java.sip.communicator.plugin.desktoputil.SIPCommFrame;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.MediaUseCase;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.util.OSUtils;
import org.jitsi.util.swing.TransparentPanel;

public abstract class PreCallDialog
implements ActionListener,
Skinnable {
    private static final List<Window> visibleWindows = new ArrayList<Window>();
    private static final String CALL_BUTTON = "CallButton";
    private static final String CONF_CALL_BUTTON = "ConfCallButton";
    private static final String VIDEO_CALL_BUTTON = "VideoCallButton";
    private static final String HANGUP_BUTTON = "HangupButton";
    private SIPCommButton callButton;
    private SIPCommButton mergeCallButton;
    private SIPCommButton videoCallButton;
    private SIPCommButton hangupButton;
    private JLabel callLabelDisplayName;
    private JLabel callLabelAddress;
    private JLabel callLabelAccount;
    private JLabel callLabelImage;
    private JComboBox accountsCombo;
    private final Window preCallWindow;
    private final boolean video;
    private final boolean mergeCall;

    public PreCallDialog(String title, boolean video, boolean existingCall) {
        this(title, null, null, video, existingCall);
    }

    public PreCallDialog(String title, String text, Account[] accounts) {
        this(title, text, accounts, false, false);
    }

    public PreCallDialog(String title, String text, Account[] accounts, boolean video, boolean existingCall) {
        MediaDevice mediaDevice;
        this.preCallWindow = this.createPreCallWindow(title, text, accounts);
        if (video && ((mediaDevice = GuiActivator.getMediaService().getDefaultDevice(MediaType.VIDEO, MediaUseCase.CALL)) == null || !mediaDevice.getDirection().allowsSending())) {
            video = false;
        }
        this.video = video;
        this.mergeCall = existingCall;
        this.initComponents();
    }

    private Window createPreCallWindow(String title, String text, Account[] accounts) {
        Object receivedCallWindow = null;
        if (OSUtils.IS_MAC) {
            HudWindow window = new HudWindow();
            window.hideCloseButton();
            JDialog dialog = window.getJDialog();
            dialog.setUndecorated(true);
            dialog.setTitle(title);
            receivedCallWindow = window.getJDialog();
            this.callLabelDisplayName = HudWidgetFactory.createHudLabel("");
            this.callLabelAddress = HudWidgetFactory.createHudLabel("");
            this.callLabelImage = HudWidgetFactory.createHudLabel("");
            if (accounts != null) {
                this.accountsCombo = HudWidgetFactory.createHudComboBox(new DefaultComboBoxModel<Account>(accounts));
            } else {
                this.callLabelAccount = HudWidgetFactory.createHudLabel("");
            }
        } else {
            SIPCommFrame frame = new SIPCommFrame(false);
            frame.setUndecorated(true);
            receivedCallWindow = frame;
            this.callLabelDisplayName = new JLabel();
            this.callLabelAddress = new JLabel();
            this.callLabelImage = new JLabel();
            if (accounts != null) {
                this.accountsCombo = new JComboBox<Account>(accounts);
            } else {
                this.callLabelAccount = new JLabel();
            }
        }
        if (text != null) {
            this.callLabelDisplayName.setText(text);
        }
        ((Window)receivedCallWindow).setAlwaysOnTop(true);
        ComponentMover.registerComponent((Component)receivedCallWindow);
        ((Window)receivedCallWindow).setFocusableWindowState(false);
        return receivedCallWindow;
    }

    private void initComponents() {
        TransparentPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 0));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.callLabelDisplayName.putClientProperty("html.disable", Boolean.TRUE);
        this.callLabelAddress.putClientProperty("html.disable", Boolean.TRUE);
        this.callLabelImage.putClientProperty("html.disable", Boolean.TRUE);
        if (this.callLabelAccount != null) {
            this.callLabelAccount.putClientProperty("html.disable", Boolean.TRUE);
        }
        CallToolBar buttonsPanel = new CallToolBar(false, true);
        this.callButton = new SIPCommButton();
        if (this.mergeCall) {
            this.mergeCallButton = new SIPCommButton();
        }
        if (this.video) {
            this.videoCallButton = new SIPCommButton();
        }
        this.hangupButton = new SIPCommButton();
        this.callButton.setName(CALL_BUTTON);
        this.hangupButton.setName(HANGUP_BUTTON);
        this.callButton.addActionListener((ActionListener)this);
        if (this.mergeCall) {
            this.mergeCallButton.setName(CONF_CALL_BUTTON);
            this.mergeCallButton.addActionListener((ActionListener)this);
        }
        this.hangupButton.addActionListener((ActionListener)this);
        if (this.video) {
            this.videoCallButton.setName(VIDEO_CALL_BUTTON);
            this.videoCallButton.addActionListener((ActionListener)this);
        }
        this.preCallWindow.add((Component)mainPanel);
        mainPanel.add((Component)this.callLabelImage, "West");
        TransparentPanel labelsPanel = new TransparentPanel();
        labelsPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        labelsPanel.setLayout(new BoxLayout((Container)labelsPanel, 1));
        this.callLabelDisplayName.setAlignmentX(0.0f);
        labelsPanel.add(this.callLabelDisplayName);
        labelsPanel.add(Box.createVerticalStrut(3));
        this.callLabelAddress.setAlignmentX(0.0f);
        labelsPanel.add(this.callLabelAddress);
        if (this.callLabelAccount != null) {
            labelsPanel.add(Box.createVerticalStrut(3));
            this.callLabelAccount.setAlignmentX(0.0f);
            labelsPanel.add(this.callLabelAccount);
        }
        if (this.accountsCombo != null) {
            labelsPanel.add(Box.createVerticalStrut(3));
            this.accountsCombo.setAlignmentX(0.0f);
            labelsPanel.add(this.accountsCombo);
        }
        mainPanel.add((Component)labelsPanel, "Center");
        this.loadSkin();
        TransparentPanel rightPanel = new TransparentPanel();
        rightPanel.setLayout(new BoxLayout((Container)rightPanel, 1));
        rightPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        ((Container)((Object)buttonsPanel)).add((Component)this.callButton);
        if (this.mergeCall) {
            ((Container)((Object)buttonsPanel)).add((Component)this.mergeCallButton);
        }
        if (this.video) {
            ((Container)((Object)buttonsPanel)).add((Component)this.videoCallButton);
        }
        ((Container)((Object)buttonsPanel)).add((Component)this.hangupButton);
        ((JComponent)((Object)buttonsPanel)).setAlignmentX(0.5f);
        rightPanel.add(Box.createVerticalGlue());
        rightPanel.add((Component)((Object)buttonsPanel));
        rightPanel.add(Box.createVerticalGlue());
        mainPanel.add((Component)rightPanel, "East");
    }

    public void pack() {
        this.preCallWindow.pack();
    }

    public synchronized void setVisible(boolean isVisible) {
        if (isVisible) {
            this.preCallWindow.pack();
            this.preCallWindow.setVisible(isVisible);
            if (visibleWindows.isEmpty()) {
                this.preCallWindow.setLocationRelativeTo(null);
            } else {
                Window last = visibleWindows.get(visibleWindows.size() - 1);
                int newX = last.getX();
                int newY = last.getY() + last.getHeight();
                this.preCallWindow.setLocation(newX, newY);
            }
            visibleWindows.add(this.preCallWindow);
        } else {
            visibleWindows.remove(this.preCallWindow);
            this.preCallWindow.setVisible(isVisible);
        }
    }

    public boolean isVisible() {
        return this.preCallWindow.isVisible();
    }

    public void dispose() {
        visibleWindows.remove(this.preCallWindow);
        this.preCallWindow.dispose();
    }

    public JLabel[] getCallLabels() {
        if (this.callLabelAccount == null) {
            return new JLabel[]{this.callLabelImage, this.callLabelDisplayName, this.callLabelAddress};
        }
        return new JLabel[]{this.callLabelImage, this.callLabelDisplayName, this.callLabelAddress, this.callLabelAccount};
    }

    public JComboBox getAccountsCombo() {
        return this.accountsCombo;
    }

    public void loadSkin() {
        this.callButton.setBackgroundImage((Image)ImageLoader.getImage(ImageLoader.INCOMING_CALL_BUTTON_BG));
        this.callButton.setRolloverImage((Image)ImageLoader.getImage(ImageLoader.INCOMING_CALL_BUTTON_ROLLOVER));
        this.callButton.setPressedImage((Image)ImageLoader.getImage(ImageLoader.INCOMING_CALL_BUTTON_PRESSED));
        if (this.videoCallButton != null) {
            this.videoCallButton.setBackgroundImage((Image)ImageLoader.getImage(ImageLoader.CALL_VIDEO_BUTTON_BG));
            this.videoCallButton.setRolloverImage((Image)ImageLoader.getImage(ImageLoader.CALL_VIDEO_BUTTON_ROLLOVER));
            this.videoCallButton.setPressedImage((Image)ImageLoader.getImage(ImageLoader.CALL_VIDEO_BUTTON_PRESSED));
        }
        if (this.mergeCallButton != null) {
            this.mergeCallButton.setBackgroundImage((Image)ImageLoader.getImage(ImageLoader.MERGE_CALL_BUTTON_BG));
            this.mergeCallButton.setRolloverImage((Image)ImageLoader.getImage(ImageLoader.MERGE_CALL_BUTTON_ROLLOVER));
            this.mergeCallButton.setPressedImage((Image)ImageLoader.getImage(ImageLoader.MERGE_CALL_BUTTON_PRESSED));
        }
        this.hangupButton.setBackgroundImage((Image)ImageLoader.getImage(ImageLoader.HANGUP_BUTTON_BG));
        this.hangupButton.setRolloverImage((Image)ImageLoader.getImage(ImageLoader.HANGUP_BUTTON_ROLLOVER));
        this.hangupButton.setPressedImage((Image)ImageLoader.getImage(ImageLoader.HANGUP_BUTTON_PRESSED));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton button = (JButton)e.getSource();
        String buttonName = button.getName();
        if (buttonName.equals(CALL_BUTTON)) {
            this.callButtonPressed();
        } else if (buttonName.equals(CONF_CALL_BUTTON)) {
            this.mergeCallButtonPressed();
        } else if (buttonName.equals(VIDEO_CALL_BUTTON)) {
            this.videoCallButtonPressed();
        } else if (buttonName.equals(HANGUP_BUTTON)) {
            this.hangupButtonPressed();
        }
        this.dispose();
    }

    public abstract void callButtonPressed();

    public abstract void mergeCallButtonPressed();

    public abstract void hangupButtonPressed();

    public abstract void videoCallButtonPressed();
}

