/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.event.ConferencePeerViewEvent;
import net.java.sip.communicator.impl.gui.event.PluginComponentEvent;
import net.java.sip.communicator.impl.gui.event.PluginComponentListener;
import net.java.sip.communicator.impl.gui.main.call.CallContainer;
import net.java.sip.communicator.impl.gui.main.call.CallDialog;
import net.java.sip.communicator.impl.gui.main.call.CallInfoFrame;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.call.CallTitleListener;
import net.java.sip.communicator.impl.gui.main.call.CallToolBar;
import net.java.sip.communicator.impl.gui.main.call.CallToolBarButton;
import net.java.sip.communicator.impl.gui.main.call.DTMFHandler;
import net.java.sip.communicator.impl.gui.main.call.DesktopSharingButton;
import net.java.sip.communicator.impl.gui.main.call.DialpadDialog;
import net.java.sip.communicator.impl.gui.main.call.FullScreenButton;
import net.java.sip.communicator.impl.gui.main.call.HangupButton;
import net.java.sip.communicator.impl.gui.main.call.HoldButton;
import net.java.sip.communicator.impl.gui.main.call.InputVolumeControlButton;
import net.java.sip.communicator.impl.gui.main.call.LocalVideoButton;
import net.java.sip.communicator.impl.gui.main.call.OneToOneCallPanel;
import net.java.sip.communicator.impl.gui.main.call.OutputVolumeControlButton;
import net.java.sip.communicator.impl.gui.main.call.ParkCallButton;
import net.java.sip.communicator.impl.gui.main.call.RecordButton;
import net.java.sip.communicator.impl.gui.main.call.ResizeVideoButton;
import net.java.sip.communicator.impl.gui.main.call.ShowHideVideoButton;
import net.java.sip.communicator.impl.gui.main.call.TransferCallButton;
import net.java.sip.communicator.impl.gui.main.call.UIVideoHandler2;
import net.java.sip.communicator.impl.gui.main.call.conference.AudioConferenceCallPanel;
import net.java.sip.communicator.impl.gui.main.call.conference.BasicConferenceCallPanel;
import net.java.sip.communicator.impl.gui.main.call.conference.ConferenceInviteDialog;
import net.java.sip.communicator.impl.gui.main.call.conference.ConferencePeerViewListener;
import net.java.sip.communicator.impl.gui.main.call.conference.ShowHidePeersButton;
import net.java.sip.communicator.impl.gui.main.call.conference.VideoConferenceCallPanel;
import net.java.sip.communicator.impl.gui.utils.Constants;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.OrderedComponent;
import net.java.sip.communicator.plugin.desktoputil.SIPCommButton;
import net.java.sip.communicator.plugin.desktoputil.SIPCommToggleButton;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.gui.PluginComponent;
import net.java.sip.communicator.service.gui.PluginComponentFactory;
import net.java.sip.communicator.service.gui.call.CallRenderer;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.CallState;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetAdvancedTelephony;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetDesktopStreaming;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.OperationSetTelephonyConferencing;
import net.java.sip.communicator.service.protocol.OperationSetTelephonyPark;
import net.java.sip.communicator.service.protocol.OperationSetVideoTelephony;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.CallChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallChangeListener;
import net.java.sip.communicator.service.protocol.event.CallEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerConferenceAdapter;
import net.java.sip.communicator.service.protocol.event.CallPeerConferenceEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerConferenceListener;
import net.java.sip.communicator.service.protocol.event.CallPeerEvent;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusListener;
import net.java.sip.communicator.service.protocol.media.MediaAwareCall;
import net.java.sip.communicator.util.GuiUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.service.neomedia.MediaUseCase;
import org.jitsi.util.OSUtils;
import org.jitsi.util.event.SizeChangeVideoEvent;
import org.jitsi.util.event.VideoEvent;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class CallPanel
extends TransparentPanel
implements ActionListener,
PluginComponentListener,
Skinnable,
ConferencePeerViewListener,
ContactPresenceStatusListener {
    private static final String CHAT_BUTTON = "CHAT_BUTTON";
    private static final String CONFERENCE_BUTTON = "CONFERENCE_BUTTON";
    private static final String DIAL_BUTTON = "DIAL_BUTTON";
    private static final String INFO_BUTTON = "INFO_BUTTON";
    private static final String CRM_BUTTON = "CRM_BUTTON";
    private static final Logger logger = Logger.getLogger(CallDialog.class);
    private static final String MERGE_BUTTON = "MERGE_BUTTON";
    private static final long serialVersionUID = 0L;
    private static final String HIDE_CALL_INFO_BUTON_PROP = "net.java.sip.communicator.impl.gui.main.call.HIDE_CALL_INFO_BUTTON";
    private static final String SHOW_CRM_BUTON_PROP = "net.java.sip.communicator.impl.gui.main.call.SHOW_CRM_BUTTON";
    private static final String HIDE_CONFERENCE_BUTON_PROP = "net.java.sip.communicator.impl.gui.main.call.HIDE_CONFERENCE_BUTTON";
    private static final String HIDE_CALL_RECORD_BUTON_PROP = "net.java.sip.communicator.impl.gui.main.call.HIDE_CALL_RECORD_BUTTON";
    private static final String HIDE_CALL_MERGE_BUTON_PROP = "net.java.sip.communicator.impl.gui.main.call.HIDE_CALL_MERGE_BUTTON";
    private static final String HIDE_CALL_TRANSFER_BUTON_PROP = "net.java.sip.communicator.impl.gui.main.call.HIDE_CALL_TRANSFER_BUTTON";
    private static final String HIDE_CALL_HOLD_BUTON_PROP = "net.java.sip.communicator.impl.gui.main.call.HIDE_CALL_HOLD_BUTTON";
    private static final String HIDE_DIAL_BUTON_PROP = "net.java.sip.communicator.impl.gui.main.call.HIDE_DIAL_BUTTON";
    private static final String HIDE_VIDEO_BUTON_PROP = "net.java.sip.communicator.impl.gui.main.call.HIDE_VIDEO_BUTTON";
    private static final String HIDE_PEERS_LIST_BUTON_PROP = "net.java.sip.communicator.impl.gui.main.call.HIDE_PEERS_LIST_BUTTON";
    private static final String PEERS_LIST_HIDDEN_PROP = "net.java.sip.communicator.impl.gui.main.call.PEERS_LIST_HIDDEN";
    private static final String HIDE_DESKTOP_SHARING_BUTON_PROP = "net.java.sip.communicator.impl.gui.main.call.HIDE_DESKTOP_SHARING_BUTTON";
    private static final String HIDE_FULL_SCREEN_BUTON_PROP = "net.java.sip.communicator.impl.gui.main.call.HIDE_FULL_SCREEN_BUTTON";
    private static final String HIDE_TOGGLE_VIDEO_BUTON_PROP = "net.java.sip.communicator.impl.gui.main.call.HIDE_TOGGLE_VIDEO_BUTTON";
    private JComponent bottomBar;
    private final CallConference callConference;
    private final CallConferenceListener callConferenceListener = new CallConferenceListener();
    private long callConferenceStartTime;
    private Timer callDurationTimer;
    private CallInfoFrame callInfoFrame;
    private JComponent callPanel;
    private final CallContainer callWindow;
    private SIPCommButton chatButton;
    private OperationSetPresence operationSetPresence;
    private CallToolBarButton conferenceButton;
    private DesktopSharingButton desktopSharingButton;
    private CallToolBarButton dialButton;
    private DialpadDialog dialpadDialog;
    private boolean disposed = false;
    private DTMFHandler dtmfHandler;
    private FullScreenButton fullScreenButton;
    private SIPCommButton hangupButton;
    private HoldButton holdButton;
    private SIPCommButton infoButton;
    private CallToolBarButton crmButton;
    private SIPCommButton parkButton;
    private boolean isCallTimerStarted = false;
    private InputVolumeControlButton localLevel;
    private CallToolBarButton mergeButton;
    private RecordButton recordButton;
    private Component remoteLevel;
    private ResizeVideoButton resizeVideoButton;
    private CallToolBar settingsPanel;
    private ShowHideVideoButton showHideVideoButton;
    private ShowHidePeersButton showHidePeersButton;
    private String title;
    private Collection<CallTitleListener> titleListeners = new Vector<CallTitleListener>();
    private TransferCallButton transferCallButton;
    private final UIVideoHandler2 uiVideoHandler;
    private boolean isCloseWaitAfterHangup = true;
    private final Observer uiVideoHandlerObserver = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            CallPanel.this.uiVideoHandlerUpdate(arg);
        }
    };
    private final Runnable updateViewFromModelInEventDispatchThread = new Runnable(){

        @Override
        public void run() {
            if (!CallPanel.this.disposed) {
                CallPanel.this.updateViewFromModelInEventDispatchThread();
            }
        }
    };
    private LocalVideoButton videoButton;

    public CallPanel(CallConference callConference, CallContainer callWindow) {
        super((LayoutManager)new BorderLayout());
        this.callConference = callConference;
        this.callWindow = callWindow;
        this.uiVideoHandler = new UIVideoHandler2(this.callConference);
        this.callDurationTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CallPanel.this.setCallTitle(CallPanel.this.callConferenceStartTime);
            }
        });
        this.callDurationTimer.setRepeats(true);
        this.setCallTitle(0L);
        this.initializeUserInterfaceHierarchy();
        this.dtmfHandler = new DTMFHandler(this);
        this.callConference.addCallChangeListener((CallChangeListener)this.callConferenceListener);
        this.callConference.addCallPeerConferenceListener((CallPeerConferenceListener)this.callConferenceListener);
        this.callConference.addPropertyChangeListener((PropertyChangeListener)this.callConferenceListener);
        this.uiVideoHandler.addObserver(this.uiVideoHandlerObserver);
        callWindow.getFrame().addPropertyChangeListener("fullScreen", this.callConferenceListener);
        this.updateViewFromModel();
        this.initPluginComponents();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        String buttonName = button.getName();
        if (buttonName.equals(MERGE_BUTTON)) {
            CallManager.mergeExistingCalls(this.callConference, CallManager.getInProgressCalls());
        } else if (buttonName.equals(DIAL_BUTTON)) {
            if (this.dialpadDialog == null) {
                this.dialpadDialog = this.getDialpadDialog();
            }
            if (!this.dialpadDialog.isVisible()) {
                this.dialpadDialog.pack();
                Point location = new Point(button.getX(), button.getY() + button.getHeight());
                SwingUtilities.convertPointToScreen(location, button.getParent());
                this.dialpadDialog.setLocation((int)location.getX() + 2, (int)location.getY() + 2);
                this.dialpadDialog.addWindowFocusListener(this.dialpadDialog);
                this.dialpadDialog.setVisible(true);
            } else {
                this.dialpadDialog.removeWindowFocusListener(this.dialpadDialog);
                this.dialpadDialog.setVisible(false);
            }
        } else if (buttonName.equals(CONFERENCE_BUTTON)) {
            ConferenceInviteDialog inviteDialog = this.callConference.isJitsiVideobridge() ? new ConferenceInviteDialog(this.callConference, ((Call)this.callConference.getCalls().get(0)).getProtocolProvider(), true) : new ConferenceInviteDialog(this.callConference);
            inviteDialog.setVisible(true);
        } else if (buttonName.equals(CHAT_BUTTON)) {
            List<Contact> imCapableCallPeers = this.getIMCapableCallPeers(1);
            if (imCapableCallPeers.size() == 1) {
                Contact contact = imCapableCallPeers.get(0);
                MetaContact metaContact = GuiActivator.getContactListService().findMetaContactByContact(contact);
                GuiActivator.getUIService().getChatWindowManager().startChat(metaContact);
            }
        } else if (buttonName.equals(INFO_BUTTON)) {
            if (this.callInfoFrame == null) {
                this.callInfoFrame = new CallInfoFrame(this.callConference);
                this.addCallTitleListener(this.callInfoFrame);
            }
            this.callInfoFrame.setVisible(this.callInfoFrame.hasCallInfo() && !this.callInfoFrame.isVisible());
        } else if (buttonName.equals(CRM_BUTTON)) {
            String command = GuiActivator.getConfigurationService().getString("net.java.sip.communicator.impl.gui.main.call.CRM_COMMAND");
            if (command == null) {
                return;
            }
            List callPeers = this.callConference.getCallPeers();
            if (callPeers.isEmpty()) {
                logger.info((Object)"No CallPeer for CRM application found.");
                return;
            }
            command = String.format(command, ((CallPeer)callPeers.get(0)).getAddress());
            try {
                logger.info((Object)("Launching CRM application: " + command));
                Runtime.getRuntime().exec(command);
            }
            catch (IOException e) {
                logger.error((Object)"Unable launch CRM application", (Throwable)e);
            }
        }
    }

    public void actionPerformedOnHangupButton(boolean closeWait) {
        this.isCloseWaitAfterHangup = closeWait;
        this.disposeCallInfoFrame();
        if (this.callConference.getCallCount() > 0) {
            CallManager.hangupCalls(this.callConference);
        } else {
            this.callWindow.close(this, false);
        }
    }

    public boolean isCloseWaitAfterHangup() {
        return this.isCloseWaitAfterHangup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallTitleListener(CallTitleListener l) {
        Collection<CallTitleListener> collection = this.titleListeners;
        synchronized (collection) {
            this.titleListeners.add(l);
        }
    }

    public void addRemoteVideoSpecificComponents(CallPeer callPeer) {
        if (CallManager.isVideoQualityPresetSupported(callPeer)) {
            if (this.resizeVideoButton == null) {
                this.resizeVideoButton = new ResizeVideoButton(callPeer.getCall());
                this.resizeVideoButton.setIndex(9);
            }
            if (this.resizeVideoButton.countAvailableOptions() > 1) {
                this.settingsPanel.add((Component)((Object)this.resizeVideoButton));
                this.settingsPanel.revalidate();
                this.settingsPanel.repaint();
            }
        }
    }

    private void callWindowPropertyChange(PropertyChangeEvent ev) {
        try {
            if (OSUtils.IS_MAC && this.bottomBar != null) {
                this.bottomBar.setOpaque(!this.isFullScreen());
            }
        }
        finally {
            this.firePropertyChange(ev.getPropertyName(), ev.getOldValue(), ev.getNewValue());
        }
    }

    private int countButtons(Component[] cs) {
        int count = 0;
        for (Component c : cs) {
            if (c instanceof SIPCommButton || c instanceof SIPCommToggleButton) {
                ++count;
            }
            if (!(c instanceof Container)) continue;
            count += this.countButtons(((Container)c).getComponents());
        }
        return count;
    }

    private JComponent createBottomBar() {
        this.bottomBar = new TransparentPanel((LayoutManager)new FlowLayout(1, 0, 0));
        this.bottomBar.setBorder(BorderFactory.createEmptyBorder(0, 30, 2, 30));
        if (OSUtils.IS_MAC) {
            this.bottomBar.setOpaque(!this.isFullScreen());
            this.bottomBar.setBackground(new Color(GuiActivator.getResources().getColor("service.gui.MAC_PANEL_BACKGROUND")));
        }
        this.bottomBar.add((Component)((Object)this.settingsPanel));
        return this.bottomBar;
    }

    void dispose() {
        this.disposed = true;
        this.callConference.removeCallChangeListener((CallChangeListener)this.callConferenceListener);
        this.callConference.removeCallPeerConferenceListener((CallPeerConferenceListener)this.callConferenceListener);
        this.callConference.removePropertyChangeListener((PropertyChangeListener)this.callConferenceListener);
        this.uiVideoHandler.deleteObserver(this.uiVideoHandlerObserver);
        this.uiVideoHandler.dispose();
        this.callWindow.getFrame().removePropertyChangeListener("fullScreen", this.callConferenceListener);
        if (this.callPanel != null) {
            if (this.callPanel instanceof BasicConferenceCallPanel) {
                ((BasicConferenceCallPanel)this.callPanel).removePeerViewListener(this);
            }
            ((CallRenderer)this.callPanel).dispose();
        }
        if (this.operationSetPresence != null) {
            this.operationSetPresence.removeContactPresenceStatusListener((ContactPresenceStatusListener)this);
        }
    }

    public void disposeCallInfoFrame() {
        if (this.callInfoFrame != null) {
            this.callInfoFrame.dispose();
        }
    }

    private void doUpdateSettingsPanelInEventDispatchThread(boolean callConferenceIsEnded) {
        this.settingsPanel.setFullScreen(this.isFullScreen());
        boolean isConference = this.callPanel instanceof BasicConferenceCallPanel;
        if (isConference) {
            this.settingsPanel.add((Component)((Object)this.localLevel));
            this.settingsPanel.add(this.remoteLevel);
            this.settingsPanel.remove((Component)this.parkButton);
        } else {
            this.settingsPanel.remove((Component)((Object)this.localLevel));
            this.settingsPanel.remove(this.remoteLevel);
        }
        List<Contact> imContacts = this.getIMCapableCallPeers(1);
        this.chatButton.setVisible(!isConference && imContacts.size() == 1);
        if (this.chatButton.isVisible() && this.operationSetPresence == null) {
            Contact contact = imContacts.get(0);
            this.operationSetPresence = (OperationSetPresence)contact.getProtocolProvider().getOperationSet(OperationSetPresence.class);
            if (this.operationSetPresence != null) {
                this.operationSetPresence.addContactPresenceStatusListener((ContactPresenceStatusListener)this);
            }
            this.chatButton.setIconImage((Image)Constants.getMessageStatusIcon(contact.getPresenceStatus()));
            this.chatButton.repaint();
        }
        this.updateHoldButtonState();
        this.updateMergeButtonState();
        List calls = this.callConference.getCalls();
        boolean advancedTelephony = !calls.isEmpty();
        boolean telephonyConferencing = false;
        boolean videoTelephony = false;
        boolean videoTelephonyIsLocalVideoAllowed = false;
        boolean videoTelephonyIsLocalVideoStreaming = false;
        boolean desktopSharing = false;
        boolean desktopSharingIsStreamed = false;
        boolean allCallsConnected = true;
        for (Call call : calls) {
            OperationSetTelephonyPark opsetPark;
            OperationSetDesktopStreaming osds;
            OperationSetVideoTelephony osvt;
            OperationSetTelephonyConferencing ostc;
            OperationSetAdvancedTelephony osat;
            ProtocolProviderService pps = call.getProtocolProvider();
            if (advancedTelephony && (osat = (OperationSetAdvancedTelephony)pps.getOperationSet(OperationSetAdvancedTelephony.class)) == null) {
                advancedTelephony = false;
            }
            if (!telephonyConferencing && (ostc = (OperationSetTelephonyConferencing)pps.getOperationSet(OperationSetTelephonyConferencing.class)) != null) {
                telephonyConferencing = true;
            }
            if (!(videoTelephony && videoTelephonyIsLocalVideoAllowed && videoTelephonyIsLocalVideoStreaming || (osvt = (OperationSetVideoTelephony)pps.getOperationSet(OperationSetVideoTelephony.class)) == null)) {
                if (!videoTelephony) {
                    videoTelephony = true;
                }
                if (!videoTelephonyIsLocalVideoAllowed && osvt.isLocalVideoAllowed(call)) {
                    videoTelephonyIsLocalVideoAllowed = true;
                }
                if (!videoTelephonyIsLocalVideoStreaming && osvt.isLocalVideoStreaming(call)) {
                    videoTelephonyIsLocalVideoStreaming = true;
                }
            }
            if (!desktopSharing && (osds = (OperationSetDesktopStreaming)pps.getOperationSet(OperationSetDesktopStreaming.class)) != null) {
                desktopSharing = true;
                if (videoTelephonyIsLocalVideoStreaming && call instanceof MediaAwareCall && ((MediaAwareCall)call).getMediaUseCase() == MediaUseCase.DESKTOP) {
                    desktopSharingIsStreamed = true;
                }
            }
            if (CallState.CALL_IN_PROGRESS != call.getCallState()) {
                allCallsConnected = false;
            }
            if (isConference || (opsetPark = (OperationSetTelephonyPark)pps.getOperationSet(OperationSetTelephonyPark.class)) == null) continue;
            this.settingsPanel.add((Component)this.parkButton);
            this.parkButton.setEnabled(allCallsConnected);
        }
        if (this.conferenceButton != null) {
            this.conferenceButton.setEnabled(telephonyConferencing);
        }
        if (this.transferCallButton != null) {
            this.transferCallButton.setEnabled(advancedTelephony);
            this.transferCallButton.setVisible(!this.callConference.isConferenceFocus());
        }
        if (this.videoButton != null) {
            this.videoButton.setEnabled(allCallsConnected && videoTelephony);
            this.videoButton.setSelected(videoTelephonyIsLocalVideoAllowed);
            if (this.showHideVideoButton != null) {
                this.showHideVideoButton.setEnabled(this.videoButton.isEnabled() && videoTelephonyIsLocalVideoAllowed);
                this.showHideVideoButton.setSelected(this.showHideVideoButton.isEnabled() && this.uiVideoHandler.isLocalVideoVisible());
                this.showHideVideoButton.setVisible(this.showHideVideoButton.isEnabled());
            }
        }
        if (this.showHidePeersButton != null) {
            this.showHidePeersButton.setVisible(isConference && CallManager.isVideoStreaming(this.callConference));
        }
        if (this.desktopSharingButton != null) {
            this.desktopSharingButton.setEnabled(desktopSharing);
            this.desktopSharingButton.setSelected(desktopSharingIsStreamed);
        }
        if (this.callPanel instanceof OneToOneCallPanel) {
            OneToOneCallPanel oneToOneCallPanel = (OneToOneCallPanel)((Object)this.callPanel);
            if (desktopSharingIsStreamed) {
                oneToOneCallPanel.addDesktopSharingComponents();
            } else {
                oneToOneCallPanel.removeDesktopSharingComponents();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateViewFromModelInEventDispatchThread() {
        if (this.callConference.isEnded() || this.callConference.getCallPeerCount() == 0) {
            this.updateSettingsPanelInEventDispatchThread(true);
            return;
        }
        boolean isConference = this.isConference();
        boolean isVideo = CallManager.isVideoStreaming(this.callConference);
        CallPeer callPeer = null;
        boolean validateAndRepaint = false;
        if (this.callPanel != null) {
            boolean removeCallPanel;
            if (isConference) {
                removeCallPanel = this.callPanel instanceof BasicConferenceCallPanel ? (isVideo ? !(this.callPanel instanceof VideoConferenceCallPanel) : this.callPanel instanceof VideoConferenceCallPanel) : true;
            } else if (this.callPanel instanceof OneToOneCallPanel) {
                List callPeers;
                if (callPeer == null && !(callPeers = this.callConference.getCallPeers()).isEmpty()) {
                    callPeer = (CallPeer)callPeers.get(0);
                }
                removeCallPanel = !((OneToOneCallPanel)((Object)this.callPanel)).getCallPeer().equals(callPeer);
            } else {
                removeCallPanel = !(this.callPanel instanceof BasicConferenceCallPanel) || !((BasicConferenceCallPanel)this.callPanel).hasDelayedCallPeers();
            }
            if (removeCallPanel) {
                this.remove(this.callPanel);
                validateAndRepaint = true;
                try {
                    ((CallRenderer)this.callPanel).dispose();
                }
                finally {
                    this.callPanel = null;
                }
            }
        }
        if (this.callPanel == null) {
            if (isConference) {
                this.callPanel = isVideo ? new VideoConferenceCallPanel(this, this.callConference, this.uiVideoHandler) : new AudioConferenceCallPanel(this, this.callConference);
                ((BasicConferenceCallPanel)this.callPanel).addPeerViewlListener(this);
            } else {
                List callPeers;
                if (callPeer == null && !(callPeers = this.callConference.getCallPeers()).isEmpty()) {
                    callPeer = (CallPeer)callPeers.get(0);
                }
                if (callPeer != null) {
                    this.callPanel = new OneToOneCallPanel(this, callPeer, this.uiVideoHandler);
                }
            }
            if (this.callPanel != null) {
                this.add(this.callPanel, "Center");
                validateAndRepaint = true;
            }
        }
        try {
            this.updateSettingsPanelInEventDispatchThread(false);
        }
        finally {
            if (validateAndRepaint) {
                if (this.isDisplayable()) {
                    this.validate();
                    this.repaint();
                } else {
                    this.doLayout();
                }
            }
        }
    }

    private void ensureSize(Component component, int width, int height) {
        CallContainer callContainer = this.getCallWindow();
        if (callContainer != null) {
            callContainer.ensureSize(component, width, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTitleChangeEvent() {
        Iterator<CallTitleListener> listeners;
        Collection<CallTitleListener> collection = this.titleListeners;
        synchronized (collection) {
            listeners = new Vector<CallTitleListener>(this.titleListeners).iterator();
        }
        while (listeners.hasNext()) {
            listeners.next().callTitleChanged(this);
        }
    }

    public CallConference getCallConference() {
        return this.callConference;
    }

    public String getCallTitle() {
        return this.title;
    }

    public CallContainer getCallWindow() {
        return this.callWindow;
    }

    public CallRenderer getCurrentCallRenderer() {
        return (CallRenderer)this.callPanel;
    }

    private DialpadDialog getDialpadDialog() {
        return new DialpadDialog(this.dtmfHandler);
    }

    private List<Contact> getIMCapableCallPeers(int limit) {
        List callPeers = this.callConference.getCallPeers();
        ArrayList<Contact> contacts = new ArrayList<Contact>(callPeers.size());
        for (CallPeer callPeer : callPeers) {
            Contact contact;
            if (callPeer.getProtocolProvider().getOperationSet(OperationSetBasicInstantMessaging.class) != null) {
                contact = callPeer.getContact();
                if (contact != null) {
                    contacts.add(contact);
                }
            } else {
                contact = CallManager.getIMCapableCusaxContact(callPeer);
                if (contact != null) {
                    contacts.add(contact);
                }
            }
            if (contacts.size() < limit) continue;
            break;
        }
        return contacts;
    }

    public int getMinimumButtonWidth() {
        int numberOfButtons = this.countButtons(this.settingsPanel.getComponents());
        if (numberOfButtons > 0) {
            return (numberOfButtons + 1) * 32;
        }
        return -1;
    }

    private void initButtonIndexes() {
        if (this.dialButton != null) {
            this.dialButton.setIndex(0);
        }
        if (this.conferenceButton != null) {
            this.conferenceButton.setIndex(1);
        }
        if (this.holdButton != null) {
            this.holdButton.setIndex(2);
        }
        if (this.recordButton != null) {
            this.recordButton.setIndex(3);
        }
        if (this.mergeButton != null) {
            this.mergeButton.setIndex(4);
        }
        if (this.transferCallButton != null) {
            this.transferCallButton.setIndex(5);
        }
        this.localLevel.setIndex(6);
        if (this.remoteLevel instanceof OrderedComponent) {
            ((OrderedComponent)this.remoteLevel).setIndex(7);
        }
        if (this.desktopSharingButton != null) {
            this.desktopSharingButton.setIndex(8);
        }
        if (this.fullScreenButton != null) {
            this.fullScreenButton.setIndex(10);
        }
        if (this.videoButton != null) {
            this.videoButton.setIndex(11);
        }
        if (this.showHideVideoButton != null) {
            this.showHideVideoButton.setIndex(12);
        }
        if (this.showHidePeersButton != null) {
            this.showHidePeersButton.setIndex(13);
        }
        this.chatButton.setIndex(19);
        this.parkButton.setIndex(25);
        if (this.crmButton != null) {
            this.crmButton.setIndex(30);
        }
        if (this.infoButton != null) {
            this.infoButton.setIndex(50);
        }
        this.hangupButton.setIndex(100);
    }

    private void initPluginComponents() {
        Collection serRefs;
        String osgiFilter = "(CONTAINER_ID=" + net.java.sip.communicator.service.gui.Container.CONTAINER_CALL_DIALOG.getID() + ")";
        try {
            serRefs = GuiActivator.bundleContext.getServiceReferences(PluginComponentFactory.class, osgiFilter);
        }
        catch (InvalidSyntaxException ise) {
            serRefs = null;
            logger.error((Object)"Could not obtain plugin reference.", (Throwable)ise);
        }
        if (serRefs != null && !serRefs.isEmpty()) {
            for (ServiceReference serRef : serRefs) {
                PluginComponentFactory factory = (PluginComponentFactory)GuiActivator.bundleContext.getService(serRef);
                PluginComponent component = factory.getPluginComponentInstance((Object)this);
                component.setCurrentContact(CallManager.getPeerMetaContact((CallPeer)this.callConference.getCallPeers().get(0)));
                this.settingsPanel.add((Component)component.getComponent());
            }
        }
        GuiActivator.getUIService().addPluginComponentListener(this);
    }

    private void initializeUserInterfaceHierarchy() {
        this.settingsPanel = new CallToolBar(this.isFullScreen(), false);
        Call aCall = (Call)this.callConference.getCalls().get(0);
        this.chatButton = new CallToolBarButton(ImageLoader.getImage(ImageLoader.CHAT_BUTTON_SMALL_WHITE), CHAT_BUTTON, GuiActivator.getResources().getI18NString("service.gui.CHAT"));
        if (this.isButtonEnabled(HIDE_CONFERENCE_BUTON_PROP)) {
            this.conferenceButton = new CallToolBarButton(ImageLoader.getImage(ImageLoader.ADD_TO_CALL_BUTTON), CONFERENCE_BUTTON, GuiActivator.getResources().getI18NString("service.gui.CREATE_CONFERENCE_CALL"));
        }
        if (this.isButtonEnabled(HIDE_DESKTOP_SHARING_BUTON_PROP)) {
            this.desktopSharingButton = new DesktopSharingButton(aCall);
        }
        if (this.isButtonEnabled(HIDE_DIAL_BUTON_PROP)) {
            this.dialButton = new CallToolBarButton(ImageLoader.getImage(ImageLoader.DIAL_BUTTON), DIAL_BUTTON, GuiActivator.getResources().getI18NString("service.gui.DIALPAD"));
        }
        if (this.isButtonEnabled(HIDE_FULL_SCREEN_BUTON_PROP)) {
            this.fullScreenButton = new FullScreenButton(this);
        }
        this.hangupButton = new HangupButton(this);
        if (this.isButtonEnabled(HIDE_CALL_HOLD_BUTON_PROP)) {
            this.holdButton = new HoldButton(aCall);
        }
        if (this.isButtonEnabled(HIDE_CALL_INFO_BUTON_PROP)) {
            this.infoButton = new CallToolBarButton(ImageLoader.getImage(ImageLoader.CALL_INFO), INFO_BUTTON, GuiActivator.getResources().getI18NString("service.gui.PRESS_FOR_CALL_INFO"));
        }
        if (!this.isButtonEnabled(SHOW_CRM_BUTON_PROP)) {
            this.crmButton = new CallToolBarButton(ImageLoader.getImage(ImageLoader.CRM), CRM_BUTTON, GuiActivator.getResources().getI18NString("service.gui.PRESS_TO_OPEN_CRM"));
        }
        if (this.isButtonEnabled(HIDE_CALL_MERGE_BUTON_PROP)) {
            this.mergeButton = new CallToolBarButton(ImageLoader.getImage(ImageLoader.MERGE_CALL_BUTTON), MERGE_BUTTON, GuiActivator.getResources().getI18NString("service.gui.MERGE_TO_CALL"));
        }
        if (this.isButtonEnabled(HIDE_CALL_RECORD_BUTON_PROP)) {
            this.recordButton = new RecordButton(aCall);
        }
        if (this.isButtonEnabled(HIDE_TOGGLE_VIDEO_BUTON_PROP)) {
            this.showHideVideoButton = new ShowHideVideoButton(this.uiVideoHandler);
        }
        if (this.isButtonEnabled(HIDE_CALL_TRANSFER_BUTON_PROP)) {
            this.transferCallButton = new TransferCallButton(aCall);
        }
        if (this.isButtonEnabled(HIDE_VIDEO_BUTON_PROP)) {
            this.videoButton = new LocalVideoButton(aCall);
        }
        if (this.isButtonEnabled(HIDE_PEERS_LIST_BUTON_PROP)) {
            this.showHidePeersButton = new ShowHidePeersButton(this, this.isButtonEnabled(PEERS_LIST_HIDDEN_PROP));
        }
        this.localLevel = new InputVolumeControlButton(this.callConference, ImageLoader.MICROPHONE, ImageLoader.MUTE_BUTTON, true, false);
        this.remoteLevel = new OutputVolumeControlButton(this.callConference, ImageLoader.VOLUME_CONTROL_BUTTON, false, true).getComponent();
        this.parkButton = new ParkCallButton(aCall);
        this.initButtonIndexes();
        this.chatButton.addActionListener((ActionListener)this);
        if (this.conferenceButton != null) {
            this.conferenceButton.addActionListener(this);
        }
        if (this.dialButton != null) {
            this.dialButton.addActionListener(this);
        }
        if (this.crmButton != null) {
            this.crmButton.addActionListener(this);
        }
        if (this.infoButton != null) {
            this.infoButton.addActionListener((ActionListener)this);
        }
        if (this.mergeButton != null) {
            this.mergeButton.addActionListener(this);
        }
        this.settingsPanel.add((Component)this.chatButton);
        if (this.conferenceButton != null) {
            this.settingsPanel.add((Component)((Object)this.conferenceButton));
        }
        if (this.desktopSharingButton != null) {
            this.settingsPanel.add((Component)((Object)this.desktopSharingButton));
        }
        if (this.dialButton != null) {
            this.settingsPanel.add((Component)((Object)this.dialButton));
        }
        if (this.fullScreenButton != null) {
            this.settingsPanel.add((Component)((Object)this.fullScreenButton));
        }
        this.settingsPanel.add((Component)this.hangupButton);
        if (this.holdButton != null) {
            this.settingsPanel.add((Component)((Object)this.holdButton));
        }
        if (this.crmButton != null) {
            this.settingsPanel.add((Component)((Object)this.crmButton));
        }
        if (this.infoButton != null) {
            this.settingsPanel.add((Component)this.infoButton);
        }
        if (this.mergeButton != null) {
            this.settingsPanel.add((Component)((Object)this.mergeButton));
        }
        if (this.recordButton != null) {
            this.settingsPanel.add((Component)((Object)this.recordButton));
        }
        if (this.showHideVideoButton != null) {
            this.settingsPanel.add((Component)((Object)this.showHideVideoButton));
        }
        if (this.transferCallButton != null) {
            this.settingsPanel.add((Component)((Object)this.transferCallButton));
        }
        if (this.videoButton != null) {
            this.settingsPanel.add((Component)((Object)this.videoButton));
        }
        if (this.showHidePeersButton != null) {
            this.settingsPanel.add((Component)((Object)this.showHidePeersButton));
        }
        this.add(this.createBottomBar(), "South");
    }

    private boolean isButtonEnabled(String buttonHidePropertyName) {
        return !GuiActivator.getConfigurationService().getBoolean(buttonHidePropertyName, false);
    }

    public boolean isCallTimerStarted() {
        return this.isCallTimerStarted;
    }

    boolean isConference() {
        if (this.callConference.isConferenceFocus()) {
            return true;
        }
        List callPeers = this.callConference.getCallPeers();
        for (CallPeer callPeer : callPeers) {
            if (!callPeer.isConferenceFocus()) continue;
            return true;
        }
        return callPeers.size() > 1;
    }

    boolean isFullScreen() {
        return this.callWindow.isFullScreen();
    }

    public boolean isRecordingStarted() {
        if (this.recordButton == null) {
            return false;
        }
        return this.recordButton.isSelected();
    }

    public boolean isShowHideVideoButtonSelected() {
        return this.showHideVideoButton.isSelected();
    }

    public void loadSkin() {
        if (this.dialButton != null) {
            this.dialButton.setBackgroundImage(ImageLoader.getImage(ImageLoader.CALL_SETTING_BUTTON_BG));
            this.dialButton.setIconImage(ImageLoader.getImage(ImageLoader.DIAL_BUTTON));
        }
        if (this.conferenceButton != null) {
            this.conferenceButton.setBackgroundImage(ImageLoader.getImage(ImageLoader.CALL_SETTING_BUTTON_BG));
            this.conferenceButton.setIconImage(ImageLoader.getImage(ImageLoader.ADD_TO_CALL_BUTTON));
        }
        if (this.hangupButton != null) {
            this.hangupButton.setBackgroundImage((Image)ImageLoader.getImage(ImageLoader.HANGUP_BUTTON_BG));
        }
    }

    private void maybeEnsureSize(final VideoEvent ev) {
        Component video;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CallPanel.this.maybeEnsureSize(ev);
                }
            });
            return;
        }
        if (ev instanceof SizeChangeVideoEvent) {
            SizeChangeVideoEvent scev = (SizeChangeVideoEvent)ev;
            this.ensureSize(scev.getVisualComponent(), scev.getWidth(), scev.getHeight());
        } else if (ev.getType() == 1 && (video = ev.getVisualComponent()) != null && UIVideoHandler2.isAncestor((Container)((Object)this), video) && video.isPreferredSizeSet()) {
            Dimension prefSize = video.getPreferredSize();
            if (prefSize.height > 0 && prefSize.width > 0) {
                Dimension size = video.getSize();
                if (prefSize.height > size.height || prefSize.width > size.width) {
                    this.ensureSize(video, prefSize.width, prefSize.height);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCallConferenceEventObject(EventObject ev) {
        try {
            boolean tryStopCallTimer = false;
            if (ev instanceof CallPeerEvent) {
                tryStopCallTimer = 2 == ((CallPeerEvent)ev).getEventID();
            } else if (ev instanceof PropertyChangeEvent) {
                PropertyChangeEvent pcev = (PropertyChangeEvent)ev;
                boolean bl = tryStopCallTimer = "calls".equals(pcev.getPropertyName()) && pcev.getOldValue() instanceof Call && pcev.getNewValue() == null;
            }
            if (tryStopCallTimer && (this.callConference.isEnded() || this.callConference.getCallPeerCount() == 0)) {
                this.stopCallTimer();
            }
        }
        finally {
            this.updateViewFromModel();
        }
    }

    void onCallEvent(CallEvent ev) {
        this.updateMergeButtonState();
    }

    protected void onPluginComponentEvent(PluginComponentEvent ev) {
        PluginComponentFactory pc = ev.getPluginComponentFactory();
        if (pc.getContainer().equals((Object)net.java.sip.communicator.service.gui.Container.CONTAINER_CALL_DIALOG)) {
            PluginComponent plugin = pc.getPluginComponentInstance((Object)this);
            Component c = (Component)plugin.getComponent();
            plugin.setCurrentContact(CallManager.getPeerMetaContact((CallPeer)this.callConference.getCallPeers().get(0)));
            switch (ev.getEventID()) {
                case 1: {
                    this.settingsPanel.add(c);
                    break;
                }
                case 2: {
                    this.settingsPanel.remove(c);
                }
            }
            this.settingsPanel.revalidate();
            this.settingsPanel.repaint();
        }
    }

    @Override
    public void peerViewAdded(ConferencePeerViewEvent ev) {
    }

    @Override
    public void peerViewRemoved(ConferencePeerViewEvent ev) {
        this.updateViewFromModel();
    }

    @Override
    public void pluginComponentAdded(PluginComponentEvent ev) {
        this.onPluginComponentEvent(ev);
    }

    @Override
    public void pluginComponentRemoved(PluginComponentEvent ev) {
        this.onPluginComponentEvent(ev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallTitleListener(CallTitleListener l) {
        Collection<CallTitleListener> collection = this.titleListeners;
        synchronized (collection) {
            this.titleListeners.remove(l);
        }
    }

    public void removeRemoteVideoSpecificComponents() {
        if (this.resizeVideoButton != null) {
            this.settingsPanel.remove((Component)((Object)this.resizeVideoButton));
        }
        this.settingsPanel.revalidate();
        this.settingsPanel.repaint();
    }

    private void setCallTitle(long startTime) {
        StringBuilder title = new StringBuilder();
        if (startTime != 0L) {
            title.append(GuiUtils.formatTime((long)startTime, (long)System.currentTimeMillis()));
            title.append(" | ");
        } else {
            title.append("00:00:00 | ");
        }
        List callPeers = this.callConference.getCallPeers();
        if (callPeers.size() > 0 && GuiActivator.getUIService().getSingleWindowContainer() != null) {
            title.append(((CallPeer)callPeers.get(0)).getDisplayName());
        } else {
            title.append(GuiActivator.getResources().getI18NString("service.gui.CALL"));
        }
        this.title = title.toString();
        this.fireTitleChangeEvent();
    }

    void setFullScreen(boolean fullScreen) {
        this.callWindow.setFullScreen(fullScreen);
    }

    public void showThumbnailsList(boolean show) {
        if (!(this.callPanel instanceof VideoConferenceCallPanel)) {
            return;
        }
        ((VideoConferenceCallPanel)this.callPanel).showThumbnailsList(show);
    }

    public void setVideoButtonSelected(boolean isSelected) {
        if (isSelected && !this.videoButton.isSelected()) {
            this.videoButton.setSelected(true);
        } else if (!isSelected && this.videoButton.isSelected()) {
            this.videoButton.setSelected(false);
        }
    }

    public void startCallTimer() {
        this.callConferenceStartTime = System.currentTimeMillis();
        this.callDurationTimer.start();
        this.isCallTimerStarted = true;
    }

    public void stopCallTimer() {
        this.callDurationTimer.stop();
    }

    private void uiVideoHandlerUpdate(Object arg) {
        VideoEvent maybeEnsureSize;
        block12: {
            maybeEnsureSize = null;
            if (arg instanceof VideoEvent) {
                try {
                    VideoEvent vev = (VideoEvent)arg;
                    int vevType = vev.getType();
                    if (vevType == 1) {
                        Component video = vev.getVisualComponent();
                        if (video != null && !UIVideoHandler2.isAncestor((Container)((Object)this), video)) {
                            maybeEnsureSize = vev;
                        }
                    } else if (vevType == 3) {
                        maybeEnsureSize = vev;
                    }
                }
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    if (!logger.isDebugEnabled()) break block12;
                    logger.debug((Object)"Failed to determine whether it is necessary to adjust a Frame's size in response to a VideoEvent.", t);
                }
            }
        }
        this.updateViewFromModel();
        if (maybeEnsureSize != null) {
            try {
                this.maybeEnsureSize(maybeEnsureSize);
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                logger.error((Object)"Failed to adjust a Frame's size in response to a VideoEvent.", t);
            }
        }
    }

    public void updateHoldButtonState() {
        boolean areAllPeersLocallyOnHold;
        if (this.holdButton == null) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CallPanel.this.updateHoldButtonState();
                }
            });
            return;
        }
        List peers = this.callConference.getCallPeers();
        if (peers.isEmpty()) {
            areAllPeersLocallyOnHold = false;
        } else {
            areAllPeersLocallyOnHold = true;
            for (CallPeer peer : this.callConference.getCallPeers()) {
                CallPeerState state = peer.getState();
                if (state.equals(CallPeerState.ON_HOLD_LOCALLY) || state.equals(CallPeerState.ON_HOLD_MUTUALLY)) continue;
                areAllPeersLocallyOnHold = false;
                break;
            }
        }
        this.holdButton.setSelected(areAllPeersLocallyOnHold);
    }

    private void updateMergeButtonState() {
        if (this.mergeButton == null) {
            return;
        }
        ArrayList<CallConference> conferences = new ArrayList<CallConference>();
        int cpt = 0;
        for (Call call : CallManager.getInProgressCalls()) {
            CallConference conference = call.getConference();
            if (conference == null) {
                ++cpt;
            } else {
                if (conferences.contains(conference)) continue;
                conferences.add(conference);
                ++cpt;
            }
            if (cpt <= 1) continue;
            break;
        }
        this.mergeButton.setVisible(cpt > 1);
    }

    private void updateSettingsPanelInEventDispatchThread(boolean callConferenceIsEnded) {
        this.doUpdateSettingsPanelInEventDispatchThread(callConferenceIsEnded);
    }

    private void updateViewFromModel() {
        if (!this.disposed) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.updateViewFromModelInEventDispatchThread();
            } else {
                SwingUtilities.invokeLater(this.updateViewFromModelInEventDispatchThread);
            }
        }
    }

    private void updateViewFromModelInEventDispatchThread() {
        if (this.disposed) {
            return;
        }
        Dimension oldPrefSize = this.getPreferredSize();
        this.doUpdateViewFromModelInEventDispatchThread();
        Dimension newPrefSize = this.getPreferredSize();
        if (newPrefSize != null && (newPrefSize.height > this.getHeight() || newPrefSize.width > this.getWidth())) {
            int oldPrefWidth;
            int oldPrefHeight;
            if (oldPrefSize == null) {
                oldPrefHeight = 0;
                oldPrefWidth = 0;
            } else {
                oldPrefHeight = oldPrefSize.height;
                oldPrefWidth = oldPrefSize.width;
            }
            if (newPrefSize.height != oldPrefHeight || newPrefSize.width != oldPrefWidth) {
                this.ensureSize((Component)((Object)this), newPrefSize.width, newPrefSize.height);
            }
        }
    }

    public void contactPresenceStatusChanged(ContactPresenceStatusChangeEvent evt) {
        Contact contact = this.getIMCapableCallPeers(1).get(0);
        if (contact != null && contact.equals(evt.getSourceContact())) {
            this.chatButton.setIconImage((Image)Constants.getMessageStatusIcon(contact.getPresenceStatus()));
            this.chatButton.repaint();
        }
    }

    private class CallConferenceListener
    extends CallPeerConferenceAdapter
    implements CallChangeListener,
    PropertyChangeListener {
        private CallConferenceListener() {
        }

        public void callPeerAdded(CallPeerEvent ev) {
            this.onCallPeerEvent(ev);
        }

        public void callPeerRemoved(CallPeerEvent ev) {
            this.onCallPeerEvent(ev);
        }

        public void callStateChanged(CallChangeEvent ev) {
            this.onEventObject((EventObject)ev);
        }

        protected void onCallPeerConferenceEvent(CallPeerConferenceEvent ev) {
            this.onEventObject((EventObject)ev);
        }

        private void onCallPeerEvent(CallPeerEvent ev) {
            this.onEventObject((EventObject)ev);
        }

        private void onEventObject(EventObject ev) {
            CallPanel.this.onCallConferenceEventObject(ev);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            String propertyName = ev.getPropertyName();
            if (propertyName.equals("calls")) {
                this.onEventObject(ev);
            } else if (propertyName.equals("fullScreen") && ev.getSource().equals(CallPanel.this.callWindow.getFrame())) {
                try {
                    this.onEventObject(ev);
                }
                finally {
                    CallPanel.this.callWindowPropertyChange(ev);
                }
            }
        }
    }
}

