/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui;

import java.awt.Frame;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.plugin.desktoputil.ErrorDialog;
import net.java.sip.communicator.service.gui.AlertUIService;
import net.java.sip.communicator.service.systray.PopupMessage;
import net.java.sip.communicator.service.systray.SystrayService;
import net.java.sip.communicator.service.systray.event.SystrayPopupMessageEvent;
import net.java.sip.communicator.service.systray.event.SystrayPopupMessageListener;
import net.java.sip.communicator.util.Logger;

public class AlertUIServiceImpl
implements AlertUIService {
    private SystrayPopupMessageListener listener = null;
    private static final Logger logger = Logger.getLogger(AlertUIServiceImpl.class);

    public void showAlertDialog(final String title, final String message) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AlertUIServiceImpl.this.showAlertDialog(title, message);
                }
            });
            return;
        }
        new ErrorDialog((Frame)((Object)GuiActivator.getUIService().getMainFrame()), title, message).showDialog();
    }

    public void showAlertDialog(final String title, final String message, final Throwable e) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AlertUIServiceImpl.this.showAlertDialog(title, message, e);
                }
            });
            return;
        }
        new ErrorDialog((Frame)((Object)GuiActivator.getUIService().getMainFrame()), title, message, e).showDialog();
    }

    public void showAlertDialog(final String title, final String message, final int type) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AlertUIServiceImpl.this.showAlertDialog(title, message, type);
                }
            });
            return;
        }
        new ErrorDialog((Frame)((Object)GuiActivator.getUIService().getMainFrame()), title, message, type).showDialog();
    }

    public void showAlertPopup(String title, String message) {
        this.showAlertPopup(title, message, title, message, null);
    }

    public void showAlertPopup(String title, String message, Throwable e) {
        this.showAlertPopup(title, message, title, message, e);
    }

    public void showAlertPopup(String title, String message, String errorDialogTitle, String errorDialogMessage) {
        this.showAlertPopup(title, message, errorDialogTitle, errorDialogMessage, null);
    }

    public void showAlertPopup(final String title, final String message, final String errorDialogTitle, final String errorDialogMessage, final Throwable e) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AlertUIServiceImpl.this.showAlertPopup(title, message, errorDialogTitle, errorDialogMessage, e);
                }
            });
            return;
        }
        SystrayService systray = GuiActivator.getSystrayService();
        if (systray == null) {
            logger.warn((Object)"SystrayService not available.");
            return;
        }
        if (this.listener == null) {
            this.listener = new SystrayPopupMessageListener(){

                public void popupMessageClicked(SystrayPopupMessageEvent evt) {
                    Object tag = evt.getTag();
                    if (tag instanceof ErrorDialogParams) {
                        ErrorDialogParams params = (ErrorDialogParams)tag;
                        Throwable e = params.getEx();
                        if (e != null) {
                            AlertUIServiceImpl.this.showAlertDialog(params.getTitle(), params.getMessage(), e);
                        } else {
                            AlertUIServiceImpl.this.showAlertDialog(params.getTitle(), params.getMessage());
                        }
                    }
                }
            };
            systray.addPopupMessageListener(this.listener);
        }
        systray.showPopupMessage(new PopupMessage(title, message, null, (Object)new ErrorDialogParams(errorDialogTitle, errorDialogMessage, e)));
    }

    public void dispose() {
        SystrayService systray = GuiActivator.getSystrayService();
        if (systray == null) {
            logger.warn((Object)"SystrayService not available.");
            return;
        }
        systray.removePopupMessageListener(this.listener);
    }

    class ErrorDialogParams {
        private String title;
        private String message;
        private Throwable e;

        public ErrorDialogParams(String title, String message, Throwable e) {
            this.title = title;
            this.message = message;
            this.e = e;
        }

        public String getTitle() {
            return this.title;
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getEx() {
            return this.e;
        }
    }
}

