/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.muc;

import net.java.sip.communicator.impl.muc.BaseChatRoomSourceContact;
import net.java.sip.communicator.impl.muc.ChatRoomQuery;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.muc.ChatRoomPresenceStatus;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class ChatRoomSourceContact
extends BaseChatRoomSourceContact {
    private boolean isAutoJoin;

    public ChatRoomSourceContact(String chatRoomName, String chatRoomID, ChatRoomQuery query, ProtocolProviderService pps, boolean isAutoJoin) {
        super(chatRoomName, chatRoomID, (ContactQuery)query, pps);
        this.isAutoJoin = isAutoJoin;
        this.initContactProperties(this.getChatRoomStateByName());
    }

    public ChatRoomSourceContact(ChatRoom chatRoom, ChatRoomQuery query, boolean isAutoJoin) {
        super(chatRoom.getName(), chatRoom.getIdentifier(), (ContactQuery)query, chatRoom.getParentProvider());
        this.isAutoJoin = isAutoJoin;
        this.initContactProperties(chatRoom.isJoined() ? ChatRoomPresenceStatus.CHAT_ROOM_ONLINE : ChatRoomPresenceStatus.CHAT_ROOM_OFFLINE);
    }

    private PresenceStatus getChatRoomStateByName() {
        for (ChatRoom room : ((OperationSetMultiUserChat)this.getProvider().getOperationSet(OperationSetMultiUserChat.class)).getCurrentlyJoinedChatRooms()) {
            if (!room.getName().equals(this.getChatRoomName())) continue;
            return ChatRoomPresenceStatus.CHAT_ROOM_ONLINE;
        }
        return ChatRoomPresenceStatus.CHAT_ROOM_OFFLINE;
    }

    @Override
    public int getIndex() {
        return ((ChatRoomQuery)this.parentQuery).indexOf(this);
    }

    public boolean isAutoJoin() {
        return this.isAutoJoin;
    }

    public void setAutoJoin(boolean isAutoJoin) {
        this.isAutoJoin = isAutoJoin;
    }
}

