/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.muc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.java.sip.communicator.impl.muc.ChatRoomProviderWrapperImpl;
import net.java.sip.communicator.impl.muc.ChatRoomWrapperImpl;
import net.java.sip.communicator.impl.muc.MUCActivator;
import net.java.sip.communicator.service.muc.ChatRoomListChangeEvent;
import net.java.sip.communicator.service.muc.ChatRoomListChangeListener;
import net.java.sip.communicator.service.muc.ChatRoomProviderWrapper;
import net.java.sip.communicator.service.muc.ChatRoomProviderWrapperListener;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class ChatRoomListImpl
implements RegistrationStateChangeListener,
ServiceListener {
    private static final Logger logger = Logger.getLogger(ChatRoomListImpl.class);
    private final List<ChatRoomProviderWrapper> providersList = new Vector<ChatRoomProviderWrapper>();
    private final List<ChatRoomProviderWrapperListener> providerChangeListeners = new ArrayList<ChatRoomProviderWrapperListener>();
    private final Vector<ChatRoomListChangeListener> listChangeListeners = new Vector();

    public ChatRoomListImpl() {
        this.loadList();
        MUCActivator.bundleContext.addServiceListener((ServiceListener)this);
    }

    public void loadList() {
        try {
            ServiceReference[] serRefs = MUCActivator.bundleContext.getServiceReferences(ProtocolProviderService.class.getName(), null);
            if (serRefs == null) {
                return;
            }
            for (ServiceReference serRef : serRefs) {
                ProtocolProviderService protocolProvider = (ProtocolProviderService)MUCActivator.bundleContext.getService(serRef);
                OperationSet multiUserChatOpSet = protocolProvider.getOperationSet(OperationSetMultiUserChat.class);
                if (multiUserChatOpSet == null) continue;
                this.addChatProvider(protocolProvider);
            }
        }
        catch (InvalidSyntaxException e) {
            logger.error((Object)"Failed to obtain service references.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChatRoomListChangeListener(ChatRoomListChangeListener l) {
        Vector<ChatRoomListChangeListener> vector = this.listChangeListeners;
        synchronized (vector) {
            this.listChangeListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChatRoomListChangeListener(ChatRoomListChangeListener l) {
        Vector<ChatRoomListChangeListener> vector = this.listChangeListeners;
        synchronized (vector) {
            this.listChangeListeners.remove(l);
        }
    }

    public void fireChatRoomListChangedEvent(ChatRoomWrapper chatRoomWrapper, int eventID) {
        ChatRoomListChangeEvent evt = new ChatRoomListChangeEvent(chatRoomWrapper, eventID);
        for (ChatRoomListChangeListener l : this.listChangeListeners) {
            l.contentChanged(evt);
        }
    }

    ChatRoomProviderWrapper addRegisteredChatProvider(ProtocolProviderService pps) {
        ChatRoomProviderWrapperImpl chatRoomProvider = new ChatRoomProviderWrapperImpl(pps);
        this.providersList.add(chatRoomProvider);
        ConfigurationService configService = MUCActivator.getConfigurationService();
        String prefix = "net.java.sip.communicator.impl.gui.accounts";
        List accounts = configService.getPropertyNamesByPrefix(prefix, true);
        for (String accountRootPropName : accounts) {
            String accountUID = configService.getString(accountRootPropName);
            if (!accountUID.equals(pps.getAccountID().getAccountUniqueID())) continue;
            List chatRooms = configService.getPropertyNamesByPrefix(accountRootPropName + ".chatRooms", true);
            for (String chatRoomPropName : chatRooms) {
                String chatRoomID = configService.getString(chatRoomPropName);
                String chatRoomName = configService.getString(chatRoomPropName + ".chatRoomName");
                ChatRoomWrapperImpl chatRoomWrapper = new ChatRoomWrapperImpl(chatRoomProvider, chatRoomID, chatRoomName);
                chatRoomProvider.addChatRoom(chatRoomWrapper);
            }
        }
        this.fireProviderWrapperAdded(chatRoomProvider);
        return chatRoomProvider;
    }

    public void addChatProvider(ProtocolProviderService pps) {
        if (pps.isRegistered()) {
            this.addRegisteredChatProvider(pps);
        } else {
            pps.addRegistrationStateChangeListener((RegistrationStateChangeListener)this);
        }
    }

    public void removeChatProvider(ProtocolProviderService pps) {
        ChatRoomProviderWrapper wrapper = this.findServerWrapperFromProvider(pps);
        if (wrapper != null) {
            this.removeChatProvider(wrapper, true);
        }
    }

    private void removeChatProvider(ChatRoomProviderWrapper chatRoomProvider, boolean permanently) {
        this.providersList.remove(chatRoomProvider);
        if (permanently) {
            chatRoomProvider.getProtocolProvider().removeRegistrationStateChangeListener((RegistrationStateChangeListener)this);
            ConfigurationService configService = MUCActivator.getConfigurationService();
            String prefix = "net.java.sip.communicator.impl.gui.accounts";
            AccountID accountID = chatRoomProvider.getProtocolProvider().getAccountID();
            if (!MUCActivator.getAccountManager().getStoredAccounts().contains(accountID)) {
                String providerAccountUID = accountID.getAccountUniqueID();
                for (String accountRootPropName : configService.getPropertyNamesByPrefix(prefix, true)) {
                    String accountUID = configService.getString(accountRootPropName);
                    if (!accountUID.equals(providerAccountUID)) continue;
                    List chatRooms = configService.getPropertyNamesByPrefix(accountRootPropName + ".chatRooms", true);
                    for (String chatRoomPropName : chatRooms) {
                        configService.setProperty(chatRoomPropName + ".chatRoomName", null);
                    }
                    configService.setProperty(accountRootPropName, null);
                }
            }
        }
        for (int i = 0; i < chatRoomProvider.countChatRooms(); ++i) {
            ChatRoomWrapper wrapper = chatRoomProvider.getChatRoom(i);
            MUCActivator.getUIService().closeChatRoomWindow(wrapper);
            wrapper.removeListeners();
        }
        chatRoomProvider.getSystemRoomWrapper().removeListeners();
        this.fireProviderWrapperRemoved(chatRoomProvider);
    }

    public void addChatRoom(ChatRoomWrapper chatRoomWrapper) {
        ChatRoomProviderWrapper chatRoomProvider = chatRoomWrapper.getParentProvider();
        if (!chatRoomProvider.containsChatRoom(chatRoomWrapper)) {
            chatRoomProvider.addChatRoom(chatRoomWrapper);
        }
        if (chatRoomWrapper.isPersistent()) {
            ConfigurationUtils.saveChatRoom((ProtocolProviderService)chatRoomProvider.getProtocolProvider(), (String)chatRoomWrapper.getChatRoomID(), (String)chatRoomWrapper.getChatRoomID(), (String)chatRoomWrapper.getChatRoomName());
        }
        this.fireChatRoomListChangedEvent(chatRoomWrapper, 1);
    }

    public void removeChatRoom(ChatRoomWrapper chatRoomWrapper) {
        ChatRoomProviderWrapper chatRoomProvider = chatRoomWrapper.getParentProvider();
        if (this.providersList.contains(chatRoomProvider)) {
            chatRoomProvider.removeChatRoom(chatRoomWrapper);
            ConfigurationUtils.saveChatRoom((ProtocolProviderService)chatRoomProvider.getProtocolProvider(), (String)chatRoomWrapper.getChatRoomID(), null, null);
            chatRoomWrapper.removeListeners();
            this.fireChatRoomListChangedEvent(chatRoomWrapper, 2);
        }
    }

    public ChatRoomWrapper findChatRoomWrapperFromChatRoom(ChatRoom chatRoom) {
        for (ChatRoomProviderWrapper provider : this.providersList) {
            if (!chatRoom.getParentProvider().equals(provider.getProtocolProvider())) continue;
            ChatRoomWrapper systemRoomWrapper = provider.getSystemRoomWrapper();
            ChatRoom systemRoom = systemRoomWrapper.getChatRoom();
            if (systemRoom != null && systemRoom.equals(chatRoom)) {
                return systemRoomWrapper;
            }
            ChatRoomWrapper chatRoomWrapper = provider.findChatRoomWrapperForChatRoom(chatRoom);
            if (chatRoomWrapper == null) continue;
            if (chatRoomWrapper.getChatRoom() == null || !chatRoomWrapper.getChatRoom().equals(chatRoom)) {
                chatRoomWrapper.setChatRoom(chatRoom);
            }
            return chatRoomWrapper;
        }
        return null;
    }

    public ChatRoomWrapper findChatRoomWrapperFromChatRoomID(String chatRoomID, ProtocolProviderService pps) {
        for (ChatRoomProviderWrapper provider : this.providersList) {
            if (!pps.equals(provider.getProtocolProvider())) continue;
            ChatRoomWrapper systemRoomWrapper = provider.getSystemRoomWrapper();
            ChatRoom systemRoom = systemRoomWrapper.getChatRoom();
            if (systemRoom != null && systemRoom.getIdentifier().equals(chatRoomID)) {
                return systemRoomWrapper;
            }
            ChatRoomWrapper chatRoomWrapper = provider.findChatRoomWrapperForChatRoomID(chatRoomID);
            return chatRoomWrapper;
        }
        return null;
    }

    public ChatRoomProviderWrapper findServerWrapperFromProvider(ProtocolProviderService protocolProvider) {
        for (ChatRoomProviderWrapper chatRoomProvider : this.providersList) {
            if (!chatRoomProvider.getProtocolProvider().equals(protocolProvider)) continue;
            return chatRoomProvider;
        }
        return null;
    }

    public Iterator<ChatRoomProviderWrapper> getChatRoomProviders() {
        return this.providersList.iterator();
    }

    public synchronized void addChatRoomProviderWrapperListener(ChatRoomProviderWrapperListener listener) {
        this.providerChangeListeners.add(listener);
    }

    public synchronized void removeChatRoomProviderWrapperListener(ChatRoomProviderWrapperListener listener) {
        this.providerChangeListeners.remove(listener);
    }

    private void fireProviderWrapperAdded(ChatRoomProviderWrapper provider) {
        if (this.providerChangeListeners != null) {
            for (ChatRoomProviderWrapperListener target : this.providerChangeListeners) {
                target.chatRoomProviderWrapperAdded(provider);
            }
        }
    }

    private void fireProviderWrapperRemoved(ChatRoomProviderWrapper provider) {
        if (this.providerChangeListeners != null) {
            for (ChatRoomProviderWrapperListener target : this.providerChangeListeners) {
                target.chatRoomProviderWrapperRemoved(provider);
            }
        }
    }

    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        ChatRoomProviderWrapper wrapper;
        ProtocolProviderService pps = evt.getProvider();
        if (evt.getNewState() != RegistrationState.REGISTERED && (evt.getNewState() == RegistrationState.UNREGISTERED || evt.getNewState() == RegistrationState.AUTHENTICATION_FAILED || evt.getNewState() == RegistrationState.CONNECTION_FAILED) && (wrapper = this.findServerWrapperFromProvider(pps)) != null) {
            this.removeChatProvider(wrapper, false);
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getServiceReference().getBundle().getState() == 16) {
            return;
        }
        Object service = MUCActivator.bundleContext.getService(event.getServiceReference());
        if (!(service instanceof ProtocolProviderService)) {
            return;
        }
        ProtocolProviderService protocolProvider = (ProtocolProviderService)service;
        OperationSet multiUserChatOpSet = protocolProvider.getOperationSet(OperationSetMultiUserChat.class);
        if (multiUserChatOpSet != null) {
            if (event.getType() == 1) {
                this.addChatProvider(protocolProvider);
            } else if (event.getType() == 4) {
                this.removeChatProvider(protocolProvider);
            }
        }
    }
}

