/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.ldap;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.java.sip.communicator.impl.ldap.LdapContactQuery;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.PrefixedContactSourceService;
import net.java.sip.communicator.service.ldap.LdapDirectory;

public class LdapContactSourceService
implements ContactSourceService,
PrefixedContactSourceService {
    private final List<LdapContactQuery> queries = new LinkedList<LdapContactQuery>();
    private final LdapDirectory ldapDirectory;

    public LdapContactSourceService(LdapDirectory ldapDirectory) {
        this.ldapDirectory = ldapDirectory;
    }

    public synchronized void removeQuery(ContactQuery query) {
        if (this.queries.remove(query)) {
            this.queries.notify();
        }
    }

    public String getDisplayName() {
        return this.ldapDirectory.getSettings().getName();
    }

    public int getType() {
        return 1;
    }

    public ContactQuery createContactQuery(String query) {
        return this.createContactQuery(query, 40);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContactQuery createContactQuery(String query, int contactCount) {
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(query);
        }
        catch (PatternSyntaxException pse) {
            pattern = Pattern.compile(Pattern.quote(query));
        }
        if (pattern != null) {
            LdapContactQuery ldapQuery = new LdapContactQuery(this, pattern, contactCount);
            List<LdapContactQuery> list = this.queries;
            synchronized (list) {
                this.queries.add(ldapQuery);
            }
            return ldapQuery;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        boolean interrupted = false;
        List<LdapContactQuery> list = this.queries;
        synchronized (list) {
            while (!this.queries.isEmpty()) {
                this.queries.get(0).cancel();
                try {
                    this.queries.wait();
                }
                catch (InterruptedException iex) {
                    interrupted = true;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public LdapDirectory getLdapDirectory() {
        return this.ldapDirectory;
    }

    public String getPhoneNumberPrefix() {
        return this.ldapDirectory.getSettings().getGlobalPhonePrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopped(LdapContactQuery query) {
        List<LdapContactQuery> list = this.queries;
        synchronized (list) {
            if (this.queries.remove((Object)query)) {
                this.queries.notify();
            }
        }
    }

    public int getIndex() {
        return -1;
    }
}

