/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import java.util.Hashtable;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.irc.IrcAccountID;
import net.java.sip.communicator.impl.protocol.irc.IrcActivator;
import net.java.sip.communicator.impl.protocol.irc.ProtocolProviderServiceIrcImpl;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ProtocolProviderFactoryIrcImpl
extends ProtocolProviderFactory {
    public static final String CHAT_ROOM_PRESENCE_TASK = "CHAT_ROOM_PRESENCE_TASK";
    public static final String CONTACT_PRESENCE_TASK = "CONTACT_PRESENCE_TASK";
    public static final String SASL_ENABLED = "SASL_ENABLED";
    public static final String SASL_USERNAME = "SASL_USERNAME";
    public static final String SASL_ROLE = "SASL_ROLE";
    public static final String RESOLVE_DNS_THROUGH_PROXY = "RESOLVE_DNS_THROUGH_PROXY";

    public ProtocolProviderFactoryIrcImpl() {
        super(IrcActivator.getBundleContext(), "IRC");
    }

    public AccountID installAccount(String userIDStr, Map<String, String> accountProperties) {
        BundleContext context = IrcActivator.getBundleContext();
        if (context == null) {
            throw new NullPointerException("The specified BundleContext was null");
        }
        if (userIDStr == null) {
            throw new NullPointerException("The specified AccountID was null");
        }
        if (accountProperties == null) {
            throw new NullPointerException("The specified property map was null");
        }
        accountProperties.put("USER_ID", userIDStr);
        String host = accountProperties.get("SERVER_ADDRESS");
        String port = accountProperties.get("SERVER_PORT");
        IrcAccountID accountID = new IrcAccountID(userIDStr, host, port, accountProperties);
        if (this.registeredAccounts.containsKey((Object)accountID)) {
            throw new IllegalStateException("An account for id " + userIDStr + " was already installed!");
        }
        this.storeAccount(accountID, false);
        accountID = this.loadAccount(accountProperties);
        return accountID;
    }

    protected AccountID createAccountID(String userID, Map<String, String> accountProperties) {
        String host = accountProperties.get("SERVER_ADDRESS");
        String port = accountProperties.get("SERVER_PORT");
        return new IrcAccountID(userID, host, port, accountProperties);
    }

    protected ProtocolProviderService createService(String userID, AccountID accountID) {
        ProtocolProviderServiceIrcImpl service = new ProtocolProviderServiceIrcImpl();
        service.initialize(userID, accountID);
        return service;
    }

    public void modifyAccount(ProtocolProviderService protocolProvider, Map<String, String> accountProperties) {
        if (protocolProvider == null) {
            throw new NullPointerException("The specified Protocol Provider was null");
        }
        if (!(protocolProvider instanceof ProtocolProviderServiceIrcImpl)) {
            throw new IllegalArgumentException("expected IRC instance of ProtocolProviderService");
        }
        if (accountProperties == null) {
            throw new NullPointerException("The specified property map was null");
        }
        BundleContext context = IrcActivator.getBundleContext();
        ProtocolProviderServiceIrcImpl ircProvider = (ProtocolProviderServiceIrcImpl)protocolProvider;
        if (context == null) {
            throw new NullPointerException("The specified BundleContext was null");
        }
        IrcAccountID accountID = (IrcAccountID)ircProvider.getAccountID();
        if (!this.registeredAccounts.containsKey((Object)accountID)) {
            return;
        }
        ServiceRegistration registration = (ServiceRegistration)this.registeredAccounts.get((Object)accountID);
        if (registration != null) {
            registration.unregister();
        }
        accountProperties.put("USER_ID", accountID.getUserID());
        if (!accountProperties.containsKey("PROTOCOL_NAME")) {
            accountProperties.put("PROTOCOL_NAME", "IRC");
        }
        accountID.setAccountProperties(accountProperties);
        this.storeAccount(accountID);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("PROTOCOL_NAME", "IRC");
        properties.put("USER_ID", accountID.getUserID());
        ircProvider.initialize(accountID.getUserID(), accountID);
        this.storeAccount(accountID);
        registration = context.registerService(ProtocolProviderService.class, (Object)protocolProvider, properties);
        this.registeredAccounts.put(accountID, registration);
    }
}

