/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import junit.framework.Assert;
import junit.framework.TestCase;
import net.java.sip.communicator.impl.protocol.irc.ChatRoomMemberIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.ContactIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.MessageIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.Utils;
import net.java.sip.communicator.service.protocol.Contact;
import org.easymock.EasyMock;

public class MessageIrcImplTest
extends TestCase {
    public void testConstruction() {
        new MessageIrcImpl("Message", "text/plain", "UTF-8", null);
    }

    public void testCorrectConstruction() {
        MessageIrcImpl message = new MessageIrcImpl("Message", "text/plain", "UTF-8", null);
        Assert.assertEquals((String)"Message", (String)message.getContent());
        Assert.assertEquals((String)"text/plain", (String)message.getContentType());
        Assert.assertEquals((String)"UTF-8", (String)message.getEncoding());
        Assert.assertNull((Object)message.getSubject());
        Assert.assertFalse((boolean)message.isAction());
        Assert.assertFalse((boolean)message.isCommand());
    }

    public void testActionRecognized() {
        MessageIrcImpl message = new MessageIrcImpl("/me is a genius!", "text/plain", "UTF-8", null);
        Assert.assertTrue((boolean)message.isAction());
        Assert.assertTrue((boolean)message.isCommand());
    }

    public void testCommandNonActionRecognized() {
        MessageIrcImpl message = new MessageIrcImpl("/msg user Hi!", "text/plain", "UTF-8", null);
        Assert.assertFalse((boolean)message.isAction());
        Assert.assertTrue((boolean)message.isCommand());
    }

    public void testNewMessageFromIRC() {
        MessageIrcImpl message = MessageIrcImpl.newMessageFromIRC("Hello world.");
        Assert.assertEquals((String)"Hello world.", (String)message.getContent());
        Assert.assertEquals((String)"text/html", (String)message.getContentType());
        Assert.assertEquals((String)"UTF-8", (String)message.getEncoding());
        Assert.assertNull((Object)message.getSubject());
    }

    public void testNewActionFromIRC() {
        String text = "Hello world.";
        ChatRoomMemberIrcImpl chatRoomMember = (ChatRoomMemberIrcImpl)EasyMock.createMock(ChatRoomMemberIrcImpl.class);
        EasyMock.replay((Object[])new Object[]{chatRoomMember});
        MessageIrcImpl message = MessageIrcImpl.newActionFromIRC("Hello world.");
        Assert.assertEquals((String)"/me Hello world.", (String)message.getContent());
        Assert.assertEquals((String)"text/html", (String)message.getContentType());
        Assert.assertEquals((String)"UTF-8", (String)message.getEncoding());
        Assert.assertNull((Object)message.getSubject());
        ContactIrcImpl contact = (ContactIrcImpl)((Object)EasyMock.createMock(ContactIrcImpl.class));
        EasyMock.replay((Object[])new Object[]{contact});
        message = MessageIrcImpl.newActionFromIRC("Hello world.");
        Assert.assertEquals((String)"/me Hello world.", (String)message.getContent());
        Assert.assertEquals((String)"text/html", (String)message.getContentType());
        Assert.assertEquals((String)"UTF-8", (String)message.getEncoding());
        Assert.assertNull((Object)message.getSubject());
    }

    public void testNewNoticeFromIRC() {
        String text = "Hello world.";
        ChatRoomMemberIrcImpl chatRoomMember = (ChatRoomMemberIrcImpl)EasyMock.createMock(ChatRoomMemberIrcImpl.class);
        EasyMock.expect((Object)chatRoomMember.getContactAddress()).andReturn((Object)"IamUser");
        EasyMock.replay((Object[])new Object[]{chatRoomMember});
        MessageIrcImpl message = MessageIrcImpl.newNoticeFromIRC(chatRoomMember, "Hello world.");
        Assert.assertEquals((String)Utils.styleAsNotice("Hello world.", "IamUser"), (String)message.getContent());
        Assert.assertEquals((String)"text/html", (String)message.getContentType());
        Assert.assertEquals((String)"UTF-8", (String)message.getEncoding());
        Assert.assertNull((Object)message.getSubject());
        ContactIrcImpl contact = (ContactIrcImpl)((Object)EasyMock.createMock(ContactIrcImpl.class));
        EasyMock.expect((Object)contact.getAddress()).andReturn((Object)"IamUser");
        EasyMock.replay((Object[])new Object[]{contact});
        message = MessageIrcImpl.newNoticeFromIRC((Contact)contact, "Hello world.");
        Assert.assertEquals((String)Utils.styleAsNotice("Hello world.", "IamUser"), (String)message.getContent());
        Assert.assertEquals((String)"text/html", (String)message.getContentType());
        Assert.assertEquals((String)"UTF-8", (String)message.getEncoding());
        Assert.assertNull((Object)message.getSubject());
    }
}

